// Copyright distributed.net 1997-1999 - All Rights Reserved
// For use in distributed.net projects only.
// Any other distribution or use of this source violates copyright.
//
// $Log: settings.c,v $
// Revision 1.2  1999/01/01 02:45:18  cramer
// Part 1 of 1999 Copyright updates...
//
// Revision 1.1  1998/12/15 05:40:47  dicamillo
// First Checked In.
//
#if (!defined(lint) && defined(__showids__))
const char *settings_c(void) {
return "@(#)$Id: settings.c,v 1.2 1999/01/01 02:45:18 cramer Exp $"; }
#endif

#include <CType.h>
#include <StdIO.h>
#include <StdLib.h>
#include <String.h>
#include "macdefs.h"
#include <Strings.h>
#include <Math.h>

#include "settings.h"
#include "resdefs.h"
#include "apputils.h"

static char setmsg1[256];	
static char setmsg2[256];
static char setmsg3[256];

static OSErr filerc = 0;
static short parserc = 0;

#define WRITEBUFFSIZE 256

#ifdef powerc
/* filter procs */
static RoutineDescriptor DlgFilter0RD =
	BUILD_ROUTINE_DESCRIPTOR(uppModalFilterProcInfo, DlgFilter0);
#endif

// private routines
short chrval(unsigned char chr);
short setval(keyinfo * k,
			 unsigned char * nameptr,
			 short namelen,
			 unsigned char * valueptr,
			 short valuelen);
OSErr alloc_copy(unsigned char **dest, unsigned char *source, long len);

OSErr init_settings(keyinfo *k, FSSpec *theFile)
{
							/* state table for reading definition file */
static unsigned char statetab[] =
/*								0		1		2		3		4		5		6		7	*/
/* 							  space   char     '='     '#'	   '"'	   CR     other    EOF	*/
/* 0: before name field	*/ {	0,		2,	   10,		1,	   10,		0,	   10,		0,
/* 1: comment line		*/		1,		1,		1,		1,		1,		0,		1,		0,
/* 2: reading name		*/		3,		2,		4,	   10,	   10,	   10,	   10,	   10,
/* 3: between name and =*/		3,	   10,		4,	   10,	   10,	   10,	   10,	   10,
/* 4: between = and val	*/		4,		5,	   10,	   10,		6,	   10,	   10,	   10,
/* 5: reading value		*/		8,		5,	   10,		9,	   10,		0,	   10,		0,
/* 6: reading quote val */		6,		6,		6,		6,		7,	   10,	   10,	   10,
/* 7: quote in quote val*/		8,	   10,	   10,		9,		6,		0,	   10,		0,
/* 8: after value		*/		8,	   10,	   10,		9,	   10,		0,	   10,		0,
/* 9: end comment		*/		9,		9,		9,		9,		9,		0,		9,		0 };
/*10: error				*/

keyinfo * kp;
short fnum;
OSErr rc;
long filesize, l, readcount, lastoffset, lineoffset;
unsigned char * filedata;
unsigned char * nameptr;
short oldstate, state, charindex;
short linenum, namelen, valuelen;
short msg3len;
unsigned char *valuestr;
OSErr value_err;

filerc = 0;
parserc = 0;

/* Loop through keytab resetting the PRESENT_IN_FILE flag and copying the
   default value as the current value. */

kp = k;
while ((kp->name) != 0) {
	kp->flags &= (255 - PRESENT_IN_FILE);
	
	switch(kp->type) {
		case 'a':
			alloc_copy((unsigned char **)&(kp->current_value),
				(unsigned char *)kp->default_value, 
				GetPtrSize((char *)kp->default_value));
			break;
		case 's':
			strcpy((char *)kp->current_value, (char *)kp->default_value);
			break;
		case '*':
			break;
		default:
			memcpy(kp->current_value, kp->default_value, kp->size);
			break;
		}

	kp++;
	}
	
if (theFile == 0) return(noErr);

// Process specified settings file
					/* prepare first part of error messages */
p2cstr(theFile->name);
sprintf(setmsg1, "Error reading settings file \"%s\":", theFile->name);
c2pstr((char *)theFile->name);

					/* null file line text */
setmsg3[0] = 0;
					/* read definition file into buffer */
rc = FSpOpenDF(theFile, fsRdPerm, &fnum);
if (rc != 0) {
	sprintf(setmsg2, "Error %d opening file.", rc);
	filerc = rc;
	return(rc);
	}

rc = GetEOF(fnum, &filesize);	/* get file size */
if (rc != 0) {
	FSClose(fnum);
	sprintf(setmsg2, "Error %d getting file size.", rc);
	filerc = rc;
	return(rc);
	}
filedata = (unsigned char *)NewPtr(filesize+1);	/* allocate buffer */
							/* extra byte for null termination */
if (filedata == 0L) {
	FSClose(fnum);
	sprintf(setmsg2, "Not enough storage (%ld bytes) for file.", filesize);
	filerc = rc;
	return(rc);
	}

readcount = filesize;			/* read file data */
rc = FSRead(fnum, &readcount, filedata);
FSClose(fnum);					/* close file */
if ((rc != 0) || (readcount != filesize)) {
	DisposePtr((char *)filedata);
	if (rc == 0) rc = 4;
	sprintf(setmsg2, "Error %d reading file contents.", rc);
	filerc = rc;
	return(rc);
	}
filedata[filesize] = 0;			/* null-terminate */

								/* parse file */
state = 0;
linenum = 1;
setmsg3[0] = '"';
msg3len = 1;
lastoffset = 0;
lineoffset = 0;
value_err = 0;
for (l=0; l <= filesize; l++) {
	if (l < filesize) {
		charindex = chrval(filedata[l]);
		lastoffset = l;
		}
	else charindex = 7;		/* EOF */
	if ((charindex < 7) && (msg3len < 254) && (charindex != 5))
		setmsg3[msg3len++] = filedata[l];
	oldstate = state;
	state = statetab[oldstate*8 + charindex]; 
	if (state == 10) break;
	if ((oldstate >= 5) && (state == 0)) {
		if (valuelen == 0) {	/* null strings can be parsed but are not allowed */
			state = 10;
			break;
			}
		valuestr[valuelen] = 0;
		rc = setval(k, nameptr, namelen, valuestr, valuelen);
		if (rc != 0) {
			value_err = rc;
			state = 10;
			break;
			}
		}
	if (charindex == 5) {
		linenum++;
		lineoffset = lastoffset;
		setmsg3[0] = '"';
		msg3len = 1;
		}
	if (charindex < 4) {
		switch(state) {
				case 6:
						if (oldstate >= 6) {
							if (valuelen == 0) {
								valuestr = filedata+l;
								}
							valuestr[valuelen++] = filedata[l];
							}
						break;
				default:	
						break;
				}
		}
	if (charindex == 1) {
		switch(state) {
				case 2:
						if (oldstate == 2) {
							namelen++;
							}
						else {
							nameptr = filedata+l;
							namelen = 1;
							}
						break;
				case 5:
						if (oldstate == 5) {
							valuelen++;
							}
						else {
							valuestr = filedata+l;
							valuelen = 1;
							}
						break;
				default:
						break;
				}
		}
	if (charindex == 4) {
		switch(state) {
				case 6:
						if (oldstate == 4) {
							valuelen = 0;
							}
						if (oldstate == 7) {
							if (valuelen == 0) {
								valuestr = filedata+l-1;
								}
							valuestr[valuelen++] = '"';
							}
						break;
				default:
						break;
				}
		}
	}
DisposePtr((char *)filedata);

if (state == 10) {		/* error state */
	if (value_err > 0) {
		sprintf(setmsg2, "Value error %d on line %d:", value_err, linenum);
		parserc = value_err + 1;
		}
	else {
		sprintf(setmsg2, "Syntax error at position %ld on line %d:",
				lastoffset - lineoffset + 1, linenum);
		parserc = 1;
		}
	setmsg3[msg3len++] = '"';
	setmsg3[msg3len] = 0;
	return(0);
	}

return(noErr);
}

short get_settings_parse_results(short *count, char *msg1, char *msg2, char *msg3)
{
unsigned char nullstr[1] = {0};

if ((filerc == 0) && (parserc == 0)) {
	if (msg1 == 0) {
		ParamText(nullstr, nullstr, nullstr, nullstr);
		}
	else {
		*msg1 = *msg2 = *msg3 = 0;
		}
	*count = 0;
	return(0);
	}

else {
	if (msg1 == 0) {
		c2pstr(setmsg1);
		c2pstr(setmsg2);
		c2pstr(setmsg3);
		ParamText((unsigned char *)setmsg1,
				  (unsigned char *)setmsg2,
				  (unsigned char *)setmsg3,
				  nullstr);
		p2cstr((unsigned char *)setmsg1);
		p2cstr((unsigned char *)setmsg2);
		p2cstr((unsigned char *)setmsg3);
		}
	else {
		strcpy(msg1, setmsg1);
		strcpy(msg2, setmsg2);
		strcpy(msg3, setmsg3);
		}

	if (filerc != 0) {
		*count = 2;
		return(filerc);
		}
	else {
		*count = 3;
		return(parserc);
		}
	}
}

OSErr find_prefs_file(OSType creator, OSType type, FSSpec *theFile,
					  FCBPBRec *myFCB)
{
OSErr rc;
short theVol;
long theDir;

// search in application's folder
if (myFCB != 0) {
	rc = search_folder_for_prefs(creator, type, myFCB->ioFCBVRefNum,
								 myFCB->ioFCBParID, theFile);
	if (rc == noErr) return(noErr);
	}

// search in preferences folder
rc = FindFolder(kOnSystemDisk, kPreferencesFolderType, false, &theVol, &theDir);
if (rc != noErr) {
	return(rc);
	}

return(search_folder_for_prefs(creator, type, theVol, theDir, theFile));
}

OSErr search_folder_for_prefs(OSType creator, OSType type,
							  short theVol, long theDir,
							  FSSpec *theFile)
{
short i;
HParamBlockRec hpb;
Str63 filename;
OSErr rc;

i = 1;
while (true) {
	memset(&hpb, 0, sizeof(HParamBlockRec));
	hpb.fileParam.ioVRefNum = theVol;
	hpb.fileParam.ioDirID = theDir;
	hpb.fileParam.ioFDirIndex = i++;
	hpb.fileParam.ioNamePtr = filename;
	rc = PBHGetFInfoSync(&hpb);
	if (rc != noErr) {
		return(rc);
		}
	if (type != 0) {
		if (hpb.fileParam.ioFlFndrInfo.fdType != type) {
			continue;
			}
		}
	if (creator != 0) {
		if (hpb.fileParam.ioFlFndrInfo.fdCreator != creator) {
			continue;
			}
		}
	break;
	}

// Found a file

theFile->vRefNum = theVol;
theFile->parID = theDir;
BlockMove(filename, theFile->name, *filename+1);
return(noErr);
}

OSErr define_prefs_file(char *prefsName, FSSpec *theFile)
{
OSErr rc;
short len;

rc = FindFolder(kOnSystemDisk, kPreferencesFolderType, false, &(theFile->vRefNum),
				&(theFile->parID));
if (rc != noErr) {
	return(rc);
	}

len = strlen(prefsName);
if (len < 1) return(1);
if (len > 63) len = 63;
(theFile->name)[0] = len;
BlockMove(prefsName, (theFile->name)+1, len);
return(noErr);
}

OSErr save_settings(keyinfo *k, OSType creator, OSType type, FSSpec *theFile,
					char *appname, Boolean force)
{
OSErr rc;
short fnum, i, j, m;
char writeok;
char s[WRITEBUFFSIZE];
unsigned char crtemp[5];
unsigned char *strval;
unsigned char c;
long count, ressize;
short currentvol;
long currentdirid;
Handle newreshandle;
WDPBRec wpb;
OSErr write_err, res_err;
keyinfo *kp;

// Unless "force" is specified, return if file already has all settings
if (!force) {
	if (!new_settings(k)) {
		return(noErr);
		}
	}

									// delete existing file
rc = FSpDelete(theFile);
if ((rc != 0) && (rc != -43)) {		// file not found is ok
	return(rc);
	}

								// Create new file
rc = FSpCreate(theFile, creator, type, smSystemScript);
if (rc != 0) {
	return(rc);
	}

								// Open the file
rc = FSpOpenDF(theFile, fsRdWrPerm, &fnum);
if (rc != 0) {
	return(rc);
	}

								// Write values to the file
writeok = 1;
while (k->size != 0) {
	s[0] = 0;
	switch (k->type) {
		case 'b':
			sprintf(s, "%s=%d \t#%s\015", k->name,
				*((unsigned char *)k->current_value), k->description);
			break;
		case 'c':
			sprintf(s, "%s=%d \t#%s\015", k->name,
				*((unsigned char *)k->current_value), k->description);
			break;
		case 'd':
			sprintf(s, "%s=%f \t#%s\015", k->name,
				*((double *)k->current_value), k->description);
			break;
		case 'i':
			sprintf(s, "%s=%d \t#%s\015", k->name,
				*((short *)k->current_value), k->description);
			break;
		case 'l':
			sprintf(s, "%s=\"%x", k->name, ((unsigned char *)k->current_value)[0]);
			m = strlen(s);
			if (k->size > 1) { 
				for (i=1; i < k->size; i++) {
					sprintf(s+m, " %x", ((unsigned char *)k->current_value)[i]);
					m = strlen(s);
					}
				}
			sprintf(s+m, "\" \t#%s\015", k->description);
			break;
		case 'o':
			memcpy(crtemp, k->current_value, 4);
			crtemp[4] = 0;
			sprintf(s, "%s=\"%s\" \t#%s\015", k->name,
					crtemp, k->description);
			break;
		case 'r':
			sprintf(s, "%s=\"%d", k->name, ((unsigned short *)k->current_value)[0]);
			m = strlen(s);
			if (k->size > 1) { 
				for (i=1; i < k->size; i++) {
					sprintf(s+m, " %d", ((unsigned short *)k->current_value)[i]);
					m = strlen(s);
					}
				}
			sprintf(s+m, "\" \t#%s\015", k->description);
			break;
		case 'a':	// arbitrary length string
		case 's':	// fixed-length string
			if (k->type == 'a') {
				strval = *((unsigned char **)k->current_value);
				}
			else {
				strval = (unsigned char *)k->current_value;
				}
			if (strval[0] == 0) break;
			sprintf(s, "%s=\"", k->name);
			m = strlen(s);
			j = 0;
			while(strval[j] != 0) {
				if (m > WRITEBUFFSIZE-2) {
					count = m;
					rc = FSWrite(fnum, &count, s);
					if (rc != 0) {
						writeok = 0;
						write_err = rc;
						break;
						}
					m = 0;
					}
				c = s[m++] = strval[j++];
				if (c == '"') s[m++] = '"';
				}
			if (!writeok) break;
			count = m;
			rc = FSWrite(fnum, &count, s);
			if (rc != 0) {
				writeok = 0;
				write_err = rc;
				break;
				}
			sprintf(s, "\" \t#%s\015", k->description);
			break;
		case 'u':
			sprintf(s, "%s=%d \t#%s\015", k->name,
				*((unsigned short *)k->current_value), k->description);
			break;
		case 'x':
			sprintf(s, "%s=%x \t#%s\015", k->name,
				*((unsigned char *)k->current_value), k->description);
			break;
		case '*':
			break;
		default:
			break;
		}
	if (!writeok) break;
	count = strlen(s);
	rc = 0;
	if (count > 0) {
		rc = FSWrite(fnum, &count, s);
		}
	if (rc != 0) {
		writeok = 0;
		write_err = rc;
		break;
		}
	k++;
	}

rc = FSClose(fnum);
if (!writeok) {
	return(write_err);
	}
if (rc != 0) {
	return(rc);
	}

/* now add a resource fork with a string resource with tells the Finder
   the application name for the settings file.	*/

if (appname == 0) {			// skip if not wanted
	return(noErr);
	}

// Get handle for data to store into resource
ressize = strlen(appname);
newreshandle = NewHandle(ressize + 1);
if (newreshandle == 0) {
	return(memFullErr);
	}
HLock(newreshandle);
*((unsigned char *)(*newreshandle)) = ressize;
memcpy((*newreshandle) + 1, appname, ressize);
HUnlock(newreshandle);

// Make volume for file the current volume
memset(&wpb, 0, sizeof(WDPBRec));
rc = PBHGetVolSync(&wpb);
if (rc != noErr) {
	DisposeHandle(newreshandle);
	return(rc);
	}
currentvol = wpb.ioWDVRefNum;
currentdirid = wpb.ioWDDirID;
memset(&wpb, 0, sizeof(WDPBRec));
wpb.ioVRefNum = theFile->vRefNum;
wpb.ioWDDirID = theFile->parID;
rc = PBHSetVolSync(&wpb);
if (rc != noErr) {
	DisposeHandle(newreshandle);
	return(rc);
	}

// Create new resource file
res_err = noErr;
CreateResFile(theFile->name);
fnum = OpenResFile(theFile->name);
if (ResError() == 0) {
	AddResource(newreshandle, 'STR ', -16396, "\p");
	if (ResError() == 0) {
		WriteResource(newreshandle);
		SetResAttrs(newreshandle, resPurgeable);
		ChangedResource(newreshandle);
		CloseResFile(fnum);
		}
	else {
		CloseResFile(fnum);
		res_err = ResError();
		}
	}
else {
	res_err = ResError();
	}

DisposeHandle(newreshandle);

memset(&wpb, 0, sizeof(WDPBRec));
wpb.ioVRefNum = currentvol;
wpb.ioWDDirID = currentdirid;
PBHSetVolSync(&wpb);

if (res_err != noErr) {
	return(res_err);
	}

// File was written ok.  Now store current values as file value.

kp = k;
while ((kp->name) != 0) {
	kp->flags |= PRESENT_IN_FILE;
	
	switch(kp->type) {
		case 'a':
			alloc_copy((unsigned char **)&(kp->file_value),
					   (unsigned char *)kp->current_value, 
				GetPtrSize((char *)kp->default_value));
			break;
		case 's':
			strcpy((char *)kp->file_value, (char *)kp->current_value);
			break;
		case '*':
			break;
		default:
			memcpy(kp->file_value, kp->current_value, kp->size);
			break;
		}

	kp++;
	}
	
return(noErr);
}

Boolean new_settings(keyinfo *k)
{
keyinfo * kp;
Size csize, fsize;

/* Loop through keytab comparing each setting */

kp = k;
while ((kp->name) != 0) {

	if ((kp->flags & PRESENT_IN_FILE) == 0) {		// check setting is in file
		return(true);
		}

	switch(kp->type) {
		case 'a':
			csize = GetPtrSize((char *)kp->current_value);
			fsize = GetPtrSize((char *)kp->file_value);
			if (csize != fsize) {
				return(true);
				}
			if (memcmp(kp->current_value, kp->file_value, kp->size) != 0) {
				return(true);
				}
			break;

		case 's':
			if (strcmp((char *)kp->current_value, (char *)kp->file_value) != 0) {
				return(true);
				}
			break;

		case '*':
			break;

		default:
			if (memcmp(kp->current_value, kp->file_value, kp->size) != 0) {
				return(true);
				}
			break;
		}

	kp++;
	}

return(false);
}

short chrval(unsigned char chr)
{
switch(chr) {
	case '=':
			return(2);
			break;
	case '#':
			return(3);
			break;
	case '"':
			return(4);
			break;
	case 0x0d:
			return(5);
			break;
	default:
			if (chr > 127) return(1);
			if (isspace(chr)) return(0);
			else if (iscntrl(chr)) return(6);
					else return(1);
			break;
	}
}

short setval(keyinfo * k,
			 unsigned char * nameptr,
			 short namelen,
			 unsigned char * valueptr,
			 short valuelen)
{
short i;
unsigned short u;
unsigned char namesave;
double d;
short rc;
unsigned short r[10];
short (*procptr)(void *);

for (i=0; i < namelen; i++) {
	nameptr[i] = tolower(nameptr[i]);
	}
namesave = nameptr[namelen];
nameptr[namelen] = 0;
valueptr[valuelen] = 0;
while (k->size > 0) {
	if (strcmp((char *)nameptr, k->name) == 0) break;
	k++;
	}
nameptr[namelen] = namesave;
if (k->size == 0) return(1);
switch(k->type) {
	case 'a':			/* string of arbitrary length */
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		rc = alloc_copy((unsigned char **)(k->current_value), valueptr, valuelen);
		if (rc != 0) return(14);
		rc = alloc_copy((unsigned char **)(k->file_value), valueptr, valuelen);
		if (rc != 0) return(14);
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'b':			/* binary flag */
		for (i=0; i < valuelen; i++)
			if (!isdigit(valueptr[i])) return(3);
		i = atoi((char *)valueptr);
		if ((i < 0) || (i > 1)) return(4);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		*((unsigned char *)k->current_value) = i;
		*((unsigned char *)k->file_value) = i;
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'c':			/* unsigned char (decimal) */
		for (i=0; i < valuelen; i++)
			if (!isdigit(valueptr[i])) return(3);
		i = atoi((char *)valueptr);
		if ((i < 0) || (i > 255)) return(4);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		*((unsigned char *)k->current_value) = i;
		*((unsigned char *)k->file_value) = i;
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'd':			/* double */
		d = strtod((char *)valueptr, NULL);
		if (d == HUGE_VAL) {
			return(14);
			}
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&d);
			if (rc != 0) return(rc);			
			}
		*((double *)(k->current_value)) = d;
		*((double *)(k->file_value)) = d;
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'i':			/* integer */
		for (i=0; i < valuelen; i++) {
			if (i == 0) {
				if (valueptr[0] == '-') continue;
				}
			if (!isdigit(valueptr[i])) return(5);
			}
		i = atoi((char *)valueptr);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		*((short *)(k->current_value)) = i;
		*((short *)(k->file_value)) = i;
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'l':			/* list of hex values (space separated) */
		if ((k->size < 1) || (k->size > 10)) return(7);
		for (i=0; i < valuelen; i++)
			if (!(isxdigit(valueptr[i]) || isspace(valueptr[i]))) return(8);
		rc = sscanf((char *)valueptr, "%hx %hx %hx %hx %hx %hx %hx %hx %hx %hx",
					r, r+1, r+2, r+3, r+4, r+5, r+6, r+7, r+8, r+9);
		if (rc != k->size) return(9);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		for (i=0; i < k->size; i++) {
			((unsigned char *)(k->current_value))[i] = r[i];
			((unsigned char *)(k->file_value))[i] = r[i];
			}
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'o':			/* OSType */
		if (valuelen != 4) return(10);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		memcpy(k->current_value, valueptr, 4);
		memcpy(k->file_value, valueptr, 4);
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'r':			/* RGB color */
		if ((k->size < 1) || (k->size > 10)) return(7);
		for (i=0; i < valuelen; i++)
			if (!(isdigit(valueptr[i]) || isspace(valueptr[i]))) return(8);
		rc = sscanf((char *)valueptr, "%hd %hd %hd %hd %hd %hd %hd %hd %hd %hd",
					r, r+1, r+2, r+3, r+4, r+5, r+6, r+7, r+8, r+9);
		if (rc != k->size) return(9);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		for (i=0; i < k->size; i++) {
			((unsigned short *)(k->current_value))[i] = r[i];
			((unsigned short *)(k->file_value))[i] = r[i];
			}
		k->flags |= PRESENT_IN_FILE;
		break;
	case 's':			/* string */
		if (valuelen > k->size) return(6);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		memset(k->current_value, 0, k->size+1);
		memcpy(k->current_value, valueptr, valuelen);
		memset(k->file_value, 0, k->size+1);
		memcpy(k->file_value, valueptr, valuelen);
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'u':			/* unsigned integer */
		for (i=0; i < valuelen; i++)
			if (!isdigit(valueptr[i])) return(5);
		u = atoi((char *)valueptr);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&u);
			if (rc != 0) return(rc);			
			}
		*((unsigned short *)(k->current_value)) = u;
		*((unsigned short *)(k->file_value)) = u;
		k->flags |= PRESENT_IN_FILE;
		break;
	case 'x':			/* unsigned char (hex) */
		for (i=0; i < valuelen; i++)
			if (!isxdigit(valueptr[i])) return(11);
		if (sscanf((char *)valueptr, "%hx", &i) != 1) return(12);
		if ((i < 0) || (i > 255)) return(13);
		if (k->procptr != 0) {
			procptr = k->procptr;
			rc = (*procptr)(&i);
			if (rc != 0) return(rc);			
			}
		*((unsigned char *)k->current_value) = i;
		*((unsigned char *)k->file_value) = i;
		k->flags |= PRESENT_IN_FILE;
		break;
	case '*':
		break;
	default:
		return(2);
		break;
	}
return(0);
}

OSErr alloc_copy(unsigned char **dest, unsigned char *source, long len)
{
Size currentsize;
Ptr newvalptr;

(*dest)[0] = 0;
currentsize = GetPtrSize((char *)*dest);
if (currentsize < (len+1)) {
	newvalptr = NewPtr((Size)(len+1));
	if (newvalptr == 0) {
		return(1);
		}
	else {
		DisposePtr((char *)*dest);
		*dest = (unsigned char *)newvalptr;
		currentsize = len+1;
		}
	}
memset(*dest, 0, currentsize);
memcpy(*dest, source, len);
return(0);
}

void show_settings_error(short count)
{
unsigned char nullstr[1] = {0};

mySetCursor(kArrowCursor);
waitcursor = ibeamcursor = 0;

if (count < 3) {
	alert_text_adjust(kSettingsAlert2, 2, 1, 1, 3, 0, 0, 0, 0);
	alert_text_adjust(kSettingsAlert2, 3, 1, 1, 0, 0, 0, 0, 0);
	ctralrt(kSettingsAlert2, kCenterDefault);
#ifdef powerc
	CautionAlert(kSettingsAlert2, &DlgFilter0RD);
#else
	CautionAlert(kSettingsAlert2, DlgFilter0);
#endif
	}

else {
	alert_text_adjust(kSettingsAlert3, 2, 1, 1, 3, 4, 0, 0, 0);
	alert_text_adjust(kSettingsAlert3, 3, 1, 1, 4, 0, 0, 0, 0);
	alert_text_adjust(kSettingsAlert3, 4, 1, 1, 0, 0, 0, 0, 0);
	ctralrt(kSettingsAlert3, kCenterDefault);
#ifdef powerc
	CautionAlert(kSettingsAlert3, &DlgFilter0RD);
#else
	CautionAlert(kSettingsAlert3, DlgFilter0);
#endif
	}

ParamText(nullstr, nullstr, nullstr, nullstr);
}


