/* 
 * Copyright distributed.net 1997-1999 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
*/

const char *client_boot_cpp(void) {
return "@(#)$Id: client_boot.cpp,v 1.1.2.30 2000/03/14 23:17:02 mfeiri Exp $"; }

#pragma mark -

#include "unistd.h"     // sleep
#include "string.h"     // memset
#include "triggers.h"    /* [Get|Set][Exit|Pause|Restart]RequestTrigger() */
#include "modereq.h"     /* ModeReq[Set|Clear|IsSet|Limit|]() */
#include "client.h"      /* CONTEST_COUNT */
#include "clicdata.h"    /* GetContestNameFromID() */
#include "baseincs.h"
#include "supp_common.h" /* internal support functions */
#define GUSI_SOURCE     // GUSI_SpinHook is 'hidden' unless we define this.
#include <GUSIBasics.h> // Dunno *WHY* Matthias did things this way, but <shrug> When in Rome...
                        // Answer: because its a HACK! (not clean separation of code space.)
#include <notification.h>/* stuff for notifies (used by FBA code only) */

#ifdef MAC_FBA
#include <console.stubs.c> // Overwrite SIOUX with empty console hooks
#endif

static struct _uiStateStatics /* this is our user interface state */
{                          /* and is initialized from macosClientConInit() */
  int initialized_counter;
  bool MPLibrary;
  //int pause_on_close;
  //int runhidden;
  //char keybuf[16][2]; /* currently unused, but _should_ be */
  //int keybufcount;
} my_uiStateStatics = 
{ 0 };

/* ================================================================== */

pascal OSErr DoOpenAppEvent (const AppleEvent *message,const AppleEvent *reply,long refcon)
{
#pragma unused (message,reply,refcon)
   return(noErr);
}

pascal OSErr DoQuitAppEvent (const AppleEvent *message,const AppleEvent *reply,long refcon)
{
#pragma unused (message,reply,refcon)
   RaiseExitRequestTrigger();
   return(noErr);
}



static void DoDeathAlert( short errNumber )
{
	Str255			theMessage;

#if defined (MAC_FBA)

	NMRec MyNotification;

	// Retrieve our error string
	GetIndString(theMessage, kErrorStrings, errNumber);
	// Set up notification record
	MyNotification.qType    = nmType;
	MyNotification.nmMark   = 0;
	MyNotification.nmIcon   = nil;
	MyNotification.nmSound  = (Handle) -1; // system beep
	MyNotification.nmStr    = (unsigned char *) &theMessage;
	MyNotification.nmResp   = (RoutineDescriptor *) -1;
	MyNotification.nmRefCon = 0;
	// Make the notification request
	NMInstall(&MyNotification);

#else

	short			result;
	
	SetCursor( &qd.arrow );
	GetIndString( theMessage, kErrorStrings, errNumber );
	ParamText( theMessage, nil, nil, nil );
	result = StopAlert( kAlertStartupError, nil );
#endif

	ExitToShell();
}


void DoAboutBox(void)
{
	DialogPtr	AboutDialog;
	short		itemHit = 0;
	SndChannelPtr theSoundChannelP = nil;
	Handle theSoundH = nil;
	OSErr err;

	AboutDialog = GetNewDialog(128, nil, (WindowPtr) -1);
	theSoundH = GetResource('snd ', 128);
	if (theSoundH != nil) {
		err = SndNewChannel(&theSoundChannelP, sampledSynth, initMono,
			nil);
	if (err == noErr)
			SndPlay(theSoundChannelP, (SndListHandle)theSoundH, true);
			}
	do ModalDialog(nil, &itemHit);
	while(itemHit != 1);
	SndDisposeChannel(theSoundChannelP, true);
	theSoundChannelP = nil;
	ReleaseResource(theSoundH);
	theSoundH = nil;
	DisposeDialog(AboutDialog);
}


static void DoAdjustMenus (void)
{
  MenuHandle file_menu = GetMenuHandle( mFile );
  MenuHandle client_menu = GetMenuHandle( mClient );

  if (ModeReqIsSet(MODEREQ_CONFIG))
  {
     DisableItem( file_menu, 1 );   // Pause
     DisableItem( file_menu, 3 );   // Quit
     DisableItem( client_menu, 1 ); // Fetch
     DisableItem( client_menu, 2 ); // Flush
     DisableItem( client_menu, 3 ); // Update
     DisableItem( client_menu, 5 ); // Benchmark
     DisableItem( client_menu, 6 ); // Test
     DisableItem( client_menu, 8 ); // Configure
  }
  else if (ModeReqIsSet(-1)) 
  {
     // a mode is running
     DisableItem( file_menu, 1 );   // Pause
     EnableItem( file_menu, 3 );   // Quit
     DisableItem( client_menu, 1 ); // Fetch
     DisableItem( client_menu, 2 ); // Flush
     DisableItem( client_menu, 3 ); // Update
     DisableItem( client_menu, 5 ); // Benchmark
     DisableItem( client_menu, 6 ); // Test
     DisableItem( client_menu, 8 ); // Configure
   }
   else if (CheckPauseRequestTrigger())
   {
     EnableItem( file_menu, 1 );   // Pause
     EnableItem( file_menu, 3 );   // Quit
     DisableItem( client_menu, 1 ); // Fetch
     DisableItem( client_menu, 2 ); // Flush
     DisableItem( client_menu, 3 ); // Update
     DisableItem( client_menu, 5 ); // Benchmark
     DisableItem( client_menu, 6 ); // Test
     DisableItem( client_menu, 8 ); // Configure
   }
   else
   {
     EnableItem( file_menu, 1 );   // Pause
     EnableItem( file_menu, 3 );   // Quit
     EnableItem( client_menu, 1 ); // Fetch
     EnableItem( client_menu, 2 ); // Flush
     EnableItem( client_menu, 3 ); // Update
     EnableItem( client_menu, 5 ); // Benchmark
     EnableItem( client_menu, 6 ); // Test
     EnableItem( client_menu, 8 ); // Configure
   }
}

#pragma mark -

void my_menucommand_handler( long menuResult )
{
  short menuID;
  short	menuItem;
  Str255 daName;
	
  menuID = HiWrd( menuResult );
  menuItem = LoWrd( menuResult );

   switch (menuID)
   {
   case mApple:
      if (menuItem == iAbout)
      {
         DoAboutBox();
         break;
      }
      else /* Desktop Accessories */
      {
         GetMenuItemText( GetMenuHandle( mApple ), menuItem, daName );
         OpenDeskAcc( daName );
         break;
      }
      break;

   case mFile:
		switch(menuItem)
		{
      case iPause:
         if (CheckPauseRequestTrigger())
         {
           ClearPauseRequestTrigger();
           CheckItem(GetMenuHandle( mFile ),iPause,false);
         }
         else
         {
           RaisePauseRequestTrigger();
           CheckItem(GetMenuHandle( mFile ),iPause,true);
         }
         break;
		  case iQuit:
		     RaiseExitRequestTrigger();
         break;
      default:
         break;
      }
      break;

   case mClient:
      switch(menuItem)
      {
      case iFetch:
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FETCH);
         break;
      case iFlush:
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FLUSH);
         break;
      case iUpdate:
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FETCH|MODEREQ_FLUSH);
         break;
      case iTest:
         ModeReqClear(-1);  /* clear all pending */
         ModeReqSet(MODEREQ_TEST_ALLCORE); /* request -test. */
         break;
      case iConfig:
         ModeReqClear(-1);  /* clear all pending */
         ModeReqSet(MODEREQ_CONFIG|MODEREQ_CONFRESTART); /* request -config */
         break;
      default:
         break;
      }
      break;

   case mBenchSub:
     switch(menuItem)
     {
      //MODEREQ_BENCHMARK defaults to a) ~16sec bench b) of current core,
      //but can be modified with...
      //    MODEREQ_BENCHMARK_ALLCORE (do all cores instead of current core)
      //    MODEREQ_BENCHMARK_QUICK (do ~8sec bench instead of ~16sec)
      //
      //Its important that the user has _some_ way to do a comparison of
      //all cores (for a particular contest), otherwise we will never be able
      //to catch mis-configured selcore defaults. [This is really, really, 
      //very important! client .450 had a wrong autoselect value for G4] 
      case iBenchAll: //case 1:
        ModeReqClear(-1);  /* clear all pending */
        ModeReqSet(MODEREQ_BENCHMARK|MODEREQ_BENCHMARK_QUICK); /*-benchmark2*/
        break;
      //case 2== menu separator
      default:        //case 3...
        ModeReqClear(-1);  /* clear all pending */
        ModeReqSet(MODEREQ_BENCHMARK_ALLCORE);  /* request "-bench" */
        ModeReqLimitProject(MODEREQ_BENCHMARK,menuItem-3); /* limit to one contest */
        break;
      }
      break;
      
    default:
      break;
   }
   HiliteMenu(0);
}


void my_HandleNextEvent(EventRecord event)
{
	switch (event.what) {
	case mouseDown:
      WindowPtr window;
      short part = FindWindow(event.where, &window);
	    switch (part) {
	      case inMenuBar:
	        DoAdjustMenus();
			    my_menucommand_handler(MenuSelect(event.where));
		      break;
	      case inSysWindow:
			    SystemClick(&event, window);
		      break;
		    default:
	        SIOUXHandleOneEvent(&event);
		      break; }
		  break;
   case keyDown:
		char theChar = event.message & charCodeMask; // Handle menu shortcuts
      if ( event.modifiers & cmdKey )
        my_menucommand_handler( MenuKey( theChar ) );
      else
        SysBeep(1); // Notify users that they may not write to the feedback window
		  break;
   case kHighLevelEvent: // I call AEProcessAppleEvent myself (FBA != SIOUX)
	   AEProcessAppleEvent(&event);
	case nullEvent: // Let SIOUX do some cursor mintaining
	case updateEvt: // Let SIOUX update its windows etc.
	case diskEvt: // SIOUX handles things like BadDiskInsertion for us
	case activateEvt: // Basically the same as updateEvt
	case osEvt: // This deserves some investigation...
	   SIOUXHandleOneEvent(&event);
	   break;
	case mouseUp: // Why should we care about mouseUp?
	case keyUp: // Why should we care about keyUp?
	case autoKey: // Dont handle autorepeat keyboard input
	default:
	  break;
	}
}


void my_spin_hook(bool wait)
{
	if (wait) macosTickSleep(60);
  else macosTickSleep(0);
}

#pragma mark -

int macosTickSleep(unsigned long tickcount)
{
   EventRecord event;
   unsigned long end_tick, new_tick;

   end_tick = LMGetTicks() + tickcount;

   do {new_tick = LMGetTicks(); if (new_tick > end_tick) break;
      //printf("%d\n",tickcount);
	   if (WaitNextEvent(everyEvent, &event, end_tick - new_tick, 0L))
      my_HandleNextEvent(event);}
   while (LMGetTicks() < end_tick);
  
   return(0);
}

/* --------------------------------------------------------------- */

void macosYield(int seconds)
{
#if (CLIENT_CPU == CPU_68K)
  macosTickSleep(seconds*60);  // TickSleep with WNE and eventhandling
#elif (CLIENT_CPU == CPU_POWERPC)
  if (my_uiStateStatics.MPLibrary == false)
    macosTickSleep(seconds*60); // TickSleep with WNE and eventhandling
  else if (seconds > 0) // used to pause/suspend an MP thread
  {
    unsigned long long end_micro = microuptime + seconds / 1000000;
    do MPYield();
    while (microuptime < end_micro);
  }
  else
    MPYield(); // hint the scheduler to yield here.
#endif
}

int macosConGetCh() /* wait (if needed) and return one keystroke */
{
   int c;
   EventRecord event;

   while (!CheckExitRequestTriggerNoIO())
   {
	   WaitNextEvent(everyEvent, &event, 100, nil);
	   if (event.what == keyDown )
	   {
	      c = event.message&charCodeMask;
         if ( event.modifiers & cmdKey )
            my_menucommand_handler( MenuKey( (char)c ) );
         else
         {
	         c = event.message&charCodeMask;
            #if (CLIENT_CPU == CPU_68K)
            c = (c & 0x000000ff);
            #endif
            if (c == 3) c = 13;  // "enter" equals "return".
            return c;
         }
	   }
      else if (event.what != autoKey )
      my_HandleNextEvent(event);
   }
   return 0;
}

/* --------------------------------------------------------------- */

int macosConOut(const char *msg)
{
  fwrite( msg, sizeof(char), strlen(msg), stdout);
  fflush(stdout);
  MacShowCursor(); // restore cursor
  return strlen(msg);
}

/* --------------------------------------------------------------- */

Boolean macosAltiVec(void)
{
  OSErr err;
  long	result;
  Boolean hasAltiVec = false;

  err = Gestalt( gestaltSystemVersion, &result );
  if ( err == noErr && result >= 0x860 )
  {
    if ( Gestalt(gestaltPowerPCProcessorFeatures, &result) == noErr)
      hasAltiVec = (1 << gestaltPowerPCHasVectorInstructions) & result;
  }
  return hasAltiVec;
}
/* --------------------------------------------------------------- */

int macosInitialize()
{
	Handle			menuBar;
	SInt16			contest_i;
	SInt32			result;
	OSErr			   err;
	
  if (my_uiStateStatics.initialized_counter == 0)
  {
	/* Free up our heap and clean out the event queue */

	MaxApplZone();
	MoreMasters();
	MoreMasters();
	MoreMasters();
	MoreMasters();
	MoreMasters();
	
   memset( &my_uiStateStatics, 0, sizeof(my_uiStateStatics));
	
	FlushEvents(everyEvent,0);


	/* Do basic Toolbox initializations */

   InitGraf(&qd.thePort);

#if !defined(MAC_FBA)

	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(nil);
	InitCursor();

#endif

	/* Check if we run a supported OS ( System7 or higher ) */
	
	err = Gestalt( gestaltSystemVersion, &result );
	if ( err != noErr || result < 0x700 )
		DoDeathAlert( kUnsupportedOSString );

#if !defined(MAC_FBA)

   /* Set up our menus */
	
	menuBar = GetNewMBar(rMenuBar);
	if ( menuBar == nil )
		DoDeathAlert( kResourceMissingString );

	SetMenuBar(menuBar);
	
	DisposeHandle(menuBar);
	AppendResMenu(GetMenuHandle(mApple),'DRVR');
	
	InsertMenu(GetMenu(mFile), 0);
	InsertMenu(GetMenu(mClient), 0);
	
	/* Dynamically generate contest submenu */
	
	InsertMenu( GetMenu(mBenchSub), -1 );
	
	for ( contest_i = 0; contest_i < CONTEST_COUNT; contest_i++ )
	{
      Str255  pstr; unsigned int pos;
      const char *cname = CliGetContestNameFromID(contest_i);
      if (!cname)  cname = "";
      if (!*cname) cname = "???";
      pos = 0;
      while (pos < 254 && *cname)
        pstr[++pos] = *cname++;
      pstr[0] = pos;

      InsertMenuItem(GetMenu(mBenchSub), pstr,contest_i+2);
      SetItemCmd(GetMenu(mBenchSub),contest_i+3,0x30+(contest_i+1));
	   if (!IsProblemLoadPermitted(-1 /*any thread*/, contest_i))
	      DisableItem( GetMenuHandle( mBenchSub ), contest_i+3 );
	}
	
	DrawMenuBar();

	/* Configure SIOUX */

	SIOUXSettings.initializeTB = false;
	SIOUXSettings.standalone = false; /* adjustable */
	SIOUXSettings.setupmenus = false; /* adjustable */
	SIOUXSettings.autocloseonquit = false; /* not adjustable */
	SIOUXSettings.asktosaveonclose = false; /* not adjustable */
	SIOUXSettings.showstatusline = false; /* adjustable */
	SIOUXSettings.userwindowtitle = (unsigned char *)"\pdistributed.net client"; /* adjustable */

  SIOUXSettings.rows = 25;
  SIOUXSettings.columns = 80;		

#endif /* defined(MAC_FBA) */

   /* Install GUSI and AppleEvent hooks */

   GUSISetHook(GUSI_SpinHook, (GUSIHook) my_spin_hook);
	
	#define INSTALL(event, handler) \
	   AEInstallEventHandler(kCoreEventClass, event, handler, 0, false)
	INSTALL (kAEOpenApplication, NewAEEventHandlerProc(DoOpenAppEvent));
	INSTALL (kAEQuitApplication, NewAEEventHandlerProc(DoQuitAppEvent));
	#undef INSTALL 

#if (CLIENT_CPU == CPU_POWERPC)  
  if (MPLibraryIsLoaded())
  {
  my_uiStateStatics.MPLibrary = true;
  /*
  const char * versionString;
  UInt32 minor, major, release, revision;
  _MPLibraryVersion(&versionString,&major,&minor,&release,&revision);
  printf("String: %s Major: %d Minor: %d Release: %d Revision: %d",versionString,major,minor,release,revision);
  */
  }
  else 
#endif
  my_uiStateStatics.MPLibrary = false;

  } /* if (my_uiStateStatics.initialized_counter == 0) */
  my_uiStateStatics.initialized_counter++;

return 0;

}

