/* 
 * Created for use in distributed.net projects, but incorporation
 * in other libraries (eg GUSI) is encouraged.
 *
 * This is POSIX and 4.2BSD compliant gettimeofday(),
 * supporting both timeval AND timezone structures.
*/

#if (!defined(lint) && defined(__showids__))
const char *gettime_c(void) {
return "@(#)$Id: gettime.c,v 1.1.4.6 2000/02/16 01:31:05 mfeiri Exp $"; }
#endif

#include <sys/time.h>
#include <Timer.h>
#include <math64.h>
#include "cputypes.h"

#define TICKS ((unsigned long *)0x16a)
#define TIME ((unsigned long *)0x20c)

static unsigned long long _get_micro_uptime(void)
{
//For discussion of several timing-related routines available on the Macintosh:
//http://developer.apple.com/dev/techsupport/develop/issue29/minow.html
  #if (CLIENT_CPU == CPU_68K)
    /* Microseconds (toolbox call) */
    UnsignedWide now; Microseconds(&now);
    return ((((unsigned long long)now.hi)<<32)+((unsigned long long)now.lo));
  #elif (CLIENT_CPU == CPU_POWERPC)
    /* Absolute Time -> Nanoseconds -> Microseconds (requires Toolbox+Math64) */
    Nanoseconds now = AbsoluteToNanoseconds(UpTime());
    return (float)UnsignedWideToUInt64(now)/1000.0;
  #endif
}


int gettimeofday(struct timeval *tvp, struct timezone *tzp)
{
  static unsigned long long micro_offset = ((unsigned long long)0);
  unsigned long long micro_time;
  static long result;

  if (micro_offset == ((unsigned long long)0)) 
  {
    #if (CLIENT_CPU == CPU_POWERPC)
    if ( (UInt32)UpTime == (UInt32)kUnresolvedCFragSymbolAddress )
      micro_time = (*TICKS) * (unsigned long long)16667;
    else // UpTime is not available in early (NuBus) PowerMacs
    #endif
    micro_time = _get_micro_uptime();
    // Subtract offset to get Unix time- since 1/1/1970
    micro_offset = ((*TIME) - 2082844800) * (unsigned long long)1000000;
    micro_offset = micro_offset - micro_time;
    if (micro_offset == ((unsigned long long)0))
      micro_offset = ((unsigned long long)1);
  }
  if (tvp)  // time in seconds and microseconds
  {
    #if (CLIENT_CPU == CPU_POWERPC)
    if ( (UInt32)UpTime == (UInt32)kUnresolvedCFragSymbolAddress )
      micro_time = (*TICKS) * (unsigned long long)16667;
    else // UpTime is not available in early (NuBus) PowerMacs
    #endif
    micro_time = _get_micro_uptime();
    micro_time += micro_offset;
    tvp->tv_sec = micro_time / 1000000;
    tvp->tv_usec = micro_time % 1000000;
  }
  if (tzp) // timezone in minuteswest and dst flag
  {
    long gmtDelta;
    int dsttype = 0; // DST_NONE
    MachineLocation theLocation;
    ReadLocation(&theLocation);

    if ((theLocation.u.dlsDelta & 0x80) != 0)
      dsttype = 1;  // DST_USA
    gmtDelta = theLocation.u.gmtDelta & 0x00ffffff;  // mask off dlsDelta
    if ( gmtDelta & 0x00800000 )  // need to sign extend gmtDelta
      gmtDelta |= 0xff000000;
    if (dsttype)
      gmtDelta -= 3600;    

    tzp->tz_minuteswest = -(gmtDelta / 60); // minutes west of Greenwich
    tzp->tz_dsttime = dsttype;              // type of dst correction
  }
  return(0);
}
