/* Hey, Emacs, this a -*-C++-*- file !
 *
 * Copyright distributed.net 1997-1999 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
 *
 * Created by Cyrus Patel <cyp@fb14.uni-mainz.de>
*/ 

#ifndef __W32UTIL_H__
#define __W32UTIL_H__ "@(#)$Id: w32util.h,v 1.1.2.8 2000/04/28 05:14:10 cyp Exp $"

/* ---------------------------------------------------- */

/* ScreenSaver boot vector (initialized from w32ss.cpp if linked) */
extern int (PASCAL *__SSMAIN)(HINSTANCE,HINSTANCE,LPSTR,int);

/* get DOS style version: (major*100)+minor. major is >=20 if NT */
extern long winGetVersion(void); 

/* ---------------------------------------------------- */

/* is executable gui subsys? <0=err, 0=no, >0=yes */
extern int winIsGUIExecutable( const char *filename );

/* ---------------------------------------------------- */

/* the next four funcs follow the same format at [Get|Write]ProfileString().
   For win32 (registry) HKLM\SoftWare\D C T I\sect.key = value
   For win16 (win.ini)               [D C T I]sect.key = value 
   ('D C T I' expands to "Distributed Computing Technologies, Inc.")
   'sect' is optional. If NULL or "", the format becomes key=value.
*/   
extern int WriteDCTIProfileString( const char *sect, const char *key, const char *val);
extern unsigned int GetDCTIProfileString(const char *sect, const char *key, 
                    const char *defaultval, char *buf, unsigned int bufsize );
extern int WriteDCTIProfileInt(const char *sect, const char *entry, int val );
extern int GetDCTIProfileInt(const char *sect, const char *entry, int defval);

/* use something other than "Distributed Computing Technologies, Inc." */
extern const char *SetDCTIProfileContext(const char *ctx);

/* ---------------------------------------------------- */

/* installer support */
extern int install_cmd_exever(int argc, char *argv[]);
extern int install_cmd_copyfile(int argc, char *argv[]);

/* ---------------------------------------------------- */

#endif /* __W32UTIL_H__ */
