#!/bin/sh

# Created by Cyrus Patel <cyp@fb14.uni-mainz.de> for forgetful people like me.
# $Id: upload.sh,v 1.1.2.12 2000/04/14 18:38:26 jbaker Exp $
# ---------------------------------------------------------------
# This little dodad does these things:
# - generates a detached signature file for a tarball
# - generates a .readme
# - uploads the tarball+signaturefile+readme to upload.distributed.net
#   - updates and commits builder.txt if this is a client
#   - sends an email message to moose that the tarball is in ./incoming.
# Just run it without command line options for a syntax description.


#-------------------------------PERSONALIZE THESE-----------------------
# ======= we can also set those things in ~/.dnet-builder =============
REL_SIGOWNER="cyp@fb14.uni-mainz.de"	#who we are (owner of signature)
REL_REALNAME="Cyrus Patel"		#our fullname
REL_SIGNTYPE="gpg"			#what we sign with (gpg, pgp2, pgp5, ???)
REL_BUILDERTXT="./builder.txt"	        #what we cat to after uploading
REL_DONEPERSONALIZATION="NO"		#have we set the fields above?
REL_PASSIVE_FTP="YES"			#do we require passive ftp?
# ======= we can also set those things in ~/.dnet-builder =============
#----------------------------END OF PERSONALIZATION--------------------




#------------------------------some 'constants'------------------------
REL_UPNOTIFY="moose@distributed.net"	#who we mail upload notification to
REL_DOBTXT="YES"                      
REL_DOFTP="YES"
REL_DOMAIL="YES"
REL_FTPSITE="upload.distributed.net"
REL_FTPDIR="/incoming/"

# *********************************************************************
REL_BASENAME=""                     #what we want to process
REL_ARCSUFFIX=""                    #archive suffix: "zip" or "tar.gz"

if [ "X$1" = "X-z"  ]; then
	REL_ARCSUFFIX="zip"
	REL_BASENAME="$1"
else

	for suffix in "zip" "tar.gz" ; do
		if [ -f $1.$suffix ]; then
			REL_ARCSUFFIX="$suffix"
			REL_BASENAME="$1"
		fi
	done
        if [ "X$REL_ARCSUFFIX" = "X" ]; then
            if [ -f $1.$2 ]; then
        	REL_BASENAME="$1"
                REL_ARCSUFFIX="$2"
            fi
        fi
fi

if [ -f ${REL_BASENAME}.${REL_ARCSUFFIX} ]; then
	echo "Working with ${REL_BASENAME}.${REL_ARCSUFFIX}..."
else  
	echo "Syntax: $0 [-z] <basename>"
	echo "<basename> is the base name of the archive (ie, without an"
	echo "           archive-type suffix). For example: 'rc5des443-freebsd-x86-elf'"
	echo "[-z]       is an optional switch which forces a .zip suffix instead"
	echo "           of .tar.gz. This switch is only required if both .zip and"
	echo "           .tar.gz versions of the same file exist."
	exit 1
fi

if [ -f ~/.dnet-builder ]; then		#if we have an external .conf ...
	. ~/.dnet-builder              	#scarf it up
fi
                                   
if [ "$REL_DONEPERSONALIZATION" = "NO" ]; then
	echo "error: this script has not been personalized."
	echo "Your name, signature owner, signing app, etc, need to be set first in"
	echo "$0, or ~/.dnet-builder."
	exit 1
fi


proxycheck=`echo "${REL_BASENAME}" |grep -ic "proxy"|tr -s " "|cut -d" " -f2`
if [ $proxycheck = "1" ]; then
	REL_DOBTXT="NO"
fi

if [ ${REL_DOBTXT} = "YES" ]; then
	if [ -f ${REL_BUILDERTXT} ]; then
		grep -q "${REL_BASENAME}.${REL_ARCSUFFIX}" ${REL_BUILDERTXT}
		if [ $? -eq 0 ]; then
			echo "error: ${REL_BASENAME}.${REL_ARCSUFFIX} is already in builder.txt"
			exit 1
		fi  
	else
		echo "error: cannot find ${REL_BUILDERTXT}."
		exit 1
	fi
fi



REL_SIGNSUFFIX=""
REL_SIGCOMMENT="${REL_BASENAME}.${REL_ARCSUFFIX} released by ${REL_REALNAME} (${REL_SIGOWNER})"
if [ "$REL_SIGNTYPE" = "gpg" ]; then
	REL_SIGNSUFFIX=${REL_ARCSUFFIX}.asc
	rm -f ${REL_BASENAME}.${REL_SIGNSUFFIX}
	echo "Generating signature..."
	gpg -bsa --comment "${REL_SIGCOMMENT}" ${REL_BASENAME}.${REL_ARCSUFFIX}
fi
if [ "$REL_SIGNTYPE" = "pgp2" ]; then
	REL_SIGNSUFFIX=${REL_ARCSUFFIX}.asc
	rm -f ${REL_BASENAME}.${REL_SIGNSUFFIX}
	echo "Generating signature..."
	pgp -bsa ${REL_BASENAME}.${REL_ARCSUFFIX} -u ${REL_SIGOWNER}
fi
if [ "$REL_SIGNTYPE" = "pgp5" ]; then
	REL_SIGNSUFFIX=${REL_ARCSUFFIX}.asc
	rm -f ${REL_BASENAME}.${REL_SIGNSUFFIX}
	echo "Generating signature..."
	pgps -ba ${REL_BASENAME}.${REL_ARCSUFFIX}
fi
if [ "X$REL_SIGNSUFFIX" = "X" ]; then
	echo "Nothing known about signing tool '${REL_SIGNTYPE}'"
	echo "If you add support for something, please commit your change."
	exit 1
fi    

if [ -f ${REL_BASENAME}.${REL_SIGNSUFFIX} ]; then 
	echo "Creating ${REL_BASENAME}.readme..."
else
	echo "oops! Something went wrong. '${REL_BASENAME}.${REL_SIGNSUFFIX}' wasn't created."
	exit 1
fi  

echo ""                                       > ${REL_BASENAME}.readme
echo "The following files were released to $REL_FTPSITE:$REL_FTPDIR :"\
                                             >> ${REL_BASENAME}.readme 
echo " - ${REL_BASENAME}.${REL_ARCSUFFIX} (binary + readmes)"  >> ${REL_BASENAME}.readme
echo " - ${REL_BASENAME}.${REL_SIGNSUFFIX} (${REL_SIGNTYPE} signature)"  >> ${REL_BASENAME}.readme
echo " - ${REL_BASENAME}.readme (this file)" >> ${REL_BASENAME}.readme
echo "" >> ${REL_BASENAME}.readme
if [ -f ${REL_BASENAME}.comment ]; then
	echo "Special Remarks:" >> ${REL_BASENAME}.readme
	cat ${REL_BASENAME}.comment >> ${REL_BASENAME}.readme
	echo "" >> ${REL_BASENAME}.readme
fi
echo "Special instructions for the ftp maintainer (${REL_UPNOTIFY}):"
echo "Max one line. Leave blank if none. Press enter when done."
read special_comments
echo "$special_comments" >> ${REL_BASENAME}.readme
echo "" >> ${REL_BASENAME}.readme
echo Released by ${REL_REALNAME} \<${REL_SIGOWNER}\> >> ${REL_BASENAME}.readme
date -u                                      >> ${REL_BASENAME}.readme
echo ""                                      >> ${REL_BASENAME}.readme

if [ "$REL_PASSIVE_FTP" != "NO" ]; then
	FTP_PASSCOMMAND="pass"
else
	FTP_PASSCOMMAND=""
fi

if [ "$REL_DOFTP" != "NO" ]; then
  echo "user anonymous -luser@distributed.net#cd $REL_FTPDIR#\
	mput ${REL_BASENAME}.readme#\
	mput ${REL_BASENAME}.${REL_SIGNSUFFIX}#\
	bin#\
	${FTP_PASSCOMMAND}#\
	mput ${REL_BASENAME}.${REL_ARCSUFFIX}#\
	bye#" | \
	tr "#" "\n" | ftp -n -i -v $REL_FTPSITE | \
	tee ${REL_BASENAME}.ftplog
	grep -q "^226 " ${REL_BASENAME}.ftplog
	if [ $? -ne 0 ]; then
		echo "error: upload failed. transcript is in ${REL_BASENAME}.ftplog"
		exit 1
	fi
fi

if [ "$REL_DOBTXT" != "NO" ]; then
	echo "Updating ${REL_BUILDERTXT}..."
	echo ${REL_BASENAME}.${REL_ARCSUFFIX} "                    "  \
		${REL_REALNAME} \<${REL_SIGOWNER}\>  >> ${REL_BUILDERTXT}
fi       

if [ "$REL_DOMAIL" != "NO" ]; then
	echo "Sending upload notification to ${REL_UPNOTIFY}..."
	echo "----------------------------------------" >>${REL_BASENAME}.readme
	echo "This message was automatically generated by $0" >>${REL_BASENAME}.readme
	echo "from the contents of ${REL_BASENAME}.readme" >>${REL_BASENAME}.readme
	cat ${REL_BASENAME}.readme | mail -s "Automatic upload notification" ${REL_UPNOTIFY}
fi

echo "Done."
echo "Don't forget to commit $REL_BUILDERTXT"
#cvs commit -F/dev/null $REL_BUILDERTXT  # can't do this
