/* 
 * Copyright distributed.net 1997-1999 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
*/

const char *client_boot_cpp(void) {
return "@(#)$Id: client_boot.cpp,v 1.1.2.1 2001/01/21 15:15:06 cyp Exp $"; }

#pragma mark -


#include "unistd.h"     // sleep
#include "string.h"     // memset
#include "triggers.h"    /* [Get|Set][Exit|Pause|Restart]RequestTrigger() */
#include "modereq.h"     /* ModeReq[Set|Clear|IsSet|Limit|]() */
#include "client.h"      /* CONTEST_COUNT */
#include "clicdata.h"    /* GetContestNameFromID() */
#include "client_defs.h" /* functions visible to the ./common/ code */
#include "cpucheck.h"    /* GetProcessorType() */
#include "baseincs.h"
#include "cliident.h"
#include "clievent.h"
#include <TextUtils.h>
#include <SIOUX.h>
#include <SIOUXGlobals.h>
#include <Devices.h>
#include <Folders.h>
#include <Dialogs.h>
#include <LowMem.h>
#include <Sound.h>
#include <Notification.h>/* stuff for notifies (used by FBA code only) */
#include <Power.h>
#include <MultiprocessingInfo.h>
#define GUSI_SOURCE     // GUSI_SpinHook is 'hidden' unless we define this.
#include <GUSIBasics.h> // Dunno *WHY* Matthias did things this way, but <shrug> When in Rome...
                        // Answer: because its a HACK! (not clean separation of code space.)
#include "ReadTemp.h"   // GetProcessorTemperature() 

#ifdef MAC_FBA
#include <console.stubs.c> // Overwrite SIOUX with empty console hooks
#endif

static struct _uiStateStatics /* this is our user interface state */
{                          /* and is initialized from macosClientConInit() */
  int initialized_counter;
  int foreground; /* in case we are running in FBA mode */
  //int runhidden;
  //char keybuf[16][2]; /* currently unused, but _should_ be */
  //int keybufcount;
} my_uiStateStatics = 
{ 0,0 };

static pascal void my_NotificationResponse ( NMRecPtr n );

#define	HiWrd(aLong)	(((aLong) >> 16) & 0xFFFF)
#define	LoWrd(aLong)	((aLong) & 0xFFFF)

enum
{
	kAlertStartupError		= 129  /* DITL plus DLOG resource */
};

enum
{
	rMenuBar				= 128				/* application's menu bar -> MBAR resource*/
};

enum
{
	mApple					= 128,				/* Apple menu -> MENU 128*/
	iAbout					= 1
};

enum
{
	mFile					= 129,				/* File menu -> MENU 129*/
	iPause		   	= 1,
	/* Separator line here */
	iQuit					= 3
};

enum
{
	mClient					= 130,				/* Commands menu  -> MENU 130*/
	iFetch   			= 1,
	iFlush				= 2,
	iUpdate				= 3,
	/* Separator line here */
	/* Benchmark submenu here */
	iTest					= 6,
	/* Separator line here */
	iConfig				= 8
};

enum
{
	mBenchSub					= 150,				/* Benchmark submenu  -> MENU 150*/
	iBenchAll			= 1
	/* Separator line here */
	/*iBenchRC5			= 3, */                 /* autogenerated values     */
	/*iBenchDES			= 4, */                 /* do not depend on these ! */
	/*iBenchOGR			= 5, */
	/*iBenchCSC			= 6  */
};


/* ================================================================== */

pascal OSErr DoOpenAppEvent (const AppleEvent *message, AppleEvent *reply, long refcon)
{
#pragma unused (message,reply,refcon)
   return(noErr);
}

pascal OSErr DoQuitAppEvent (const AppleEvent *message, AppleEvent *reply, long refcon)
{
#pragma unused (message,reply,refcon)
   RaiseExitRequestTrigger();
   return(noErr);
}

pascal OSErr DoUpdateEvent (const AppleEvent *message, AppleEvent *reply, long refcon)
{
#pragma unused (message,reply,refcon)
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FETCH|MODEREQ_FLUSH);
   return(noErr);
}

pascal OSErr DoFetchEvent (const AppleEvent *message, AppleEvent *reply, long refcon)
{
#pragma unused (message,reply,refcon)
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FETCH);
   return(noErr);
}

pascal OSErr DoFlushEvent (const AppleEvent *message, AppleEvent *reply, long refcon)
{
#pragma unused (message,reply,refcon)
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FLUSH);
   return(noErr);
}

pascal OSErr DoPauseEvent (const AppleEvent *message, AppleEvent *reply, long refcon)
{
#pragma unused (message,reply,refcon)
           RaisePauseRequestTrigger();
   return(noErr);
}

pascal OSErr DoResumeEvent (const AppleEvent *message, AppleEvent *reply, long refcon)
{
#pragma unused (message,reply,refcon)
           ClearPauseRequestTrigger();
   return(noErr);
}

#pragma mark -

void DoSetDirectory(void)
{
   SInt16              foundPrefVRefNum    = 0;
   SInt32              foundPrefDirID      = 0;
   SInt32              newDirID            = 0;
   Str255              prefsName           = "\pdnetc.ini";
   Str255              dnetfolderName      = "\pdistributed.net";
   FSSpec              prefsFSSpec;
	CInfoPBRec	        pb;
   
   // Get our current directory, usually the folder that holds this executable
   HGetVol(nil,&foundPrefVRefNum,&foundPrefDirID);

   // If we dont have a dnetc.ini file in our current directory we must look for one
   if (FSMakeFSSpec (foundPrefVRefNum, foundPrefDirID, prefsName, &prefsFSSpec) != noErr)
   {
      // Find the "Application Support" folder
      if (FindFolder (kOnSystemDisk, kApplicationSupportFolderType,
      kDontCreateFolder, &foundPrefVRefNum, &foundPrefDirID) == noErr)
      {
         if (FSMakeFSSpec (foundPrefVRefNum, foundPrefDirID, dnetfolderName, &prefsFSSpec) == noErr)
         {  // can we find a dnetc.ini inside a "distributed.net" folder?
			   pb.dirInfo.ioNamePtr = prefsFSSpec.name;
			   pb.dirInfo.ioVRefNum = prefsFSSpec.vRefNum;
			   pb.dirInfo.ioDrDirID = prefsFSSpec.parID;
			   pb.dirInfo.ioFDirIndex = 0;
			   if ( (PBGetCatInfoSync(&pb) == noErr) && (pb.hFileInfo.ioFlAttrib & kioFlAttribDirMask) != 0 )
               if (FSMakeFSSpec (pb.dirInfo.ioVRefNum, pb.dirInfo.ioDrDirID, prefsName, &prefsFSSpec) == noErr)
                  HSetVol(nil, pb.dirInfo.ioVRefNum, pb.dirInfo.ioDrDirID);
         }
      }
      // Find the "Preferences" folder
      else if (FindFolder (kOnSystemDisk, kPreferencesFolderType, 
      kDontCreateFolder, &foundPrefVRefNum, &foundPrefDirID) == noErr)
      {
         if (FSMakeFSSpec (foundPrefVRefNum, foundPrefDirID, dnetfolderName, &prefsFSSpec) == noErr)
         {  // can we find a dnetc.ini inside a "distributed.net" folder?
			   pb.dirInfo.ioNamePtr = prefsFSSpec.name;
			   pb.dirInfo.ioVRefNum = prefsFSSpec.vRefNum;
			   pb.dirInfo.ioDrDirID = prefsFSSpec.parID;
			   pb.dirInfo.ioFDirIndex = 0;
			   if ( (PBGetCatInfoSync(&pb) == noErr) && (pb.hFileInfo.ioFlAttrib & kioFlAttribDirMask) != 0 )
               if (FSMakeFSSpec (pb.dirInfo.ioVRefNum, pb.dirInfo.ioDrDirID, prefsName, &prefsFSSpec) == noErr)
                  HSetVol(nil, pb.dirInfo.ioVRefNum, pb.dirInfo.ioDrDirID);
         }
      }

   // A dnetc.ini file was not found, go and try to set or create a "distributed.net" folder as our home

      // Find the "Application Support" folder
      if (FindFolder(kOnSystemDisk,kApplicationSupportFolderType,kDontCreateFolder,&foundPrefVRefNum,&foundPrefDirID)==noErr)
      {  // try to set or create a "distributed.net" folder as our home directory
         if (FSMakeFSSpec (foundPrefVRefNum, foundPrefDirID, dnetfolderName, &prefsFSSpec) == noErr)
         {
			   pb.dirInfo.ioNamePtr = prefsFSSpec.name;
			   pb.dirInfo.ioVRefNum = prefsFSSpec.vRefNum;
			   pb.dirInfo.ioDrDirID = prefsFSSpec.parID;
			   pb.dirInfo.ioFDirIndex = 0;
			   if ( (PBGetCatInfoSync(&pb) == noErr) && (pb.hFileInfo.ioFlAttrib & kioFlAttribDirMask) != 0 )
               HSetVol(nil, pb.dirInfo.ioVRefNum, pb.dirInfo.ioDrDirID);
         }
         else if (DirCreate(foundPrefVRefNum, foundPrefDirID, dnetfolderName, &newDirID) == noErr)
            HSetVol(nil, foundPrefVRefNum, newDirID);
      }
      // Find the "Preferences" folder
      else if (FindFolder(kOnSystemDisk,kPreferencesFolderType,kDontCreateFolder,&foundPrefVRefNum,&foundPrefDirID)==noErr)
      {  // try to set or create a "distributed.net" folder as our home directory
         if (FSMakeFSSpec (foundPrefVRefNum, foundPrefDirID, dnetfolderName, &prefsFSSpec) == noErr)
         {
			   pb.dirInfo.ioNamePtr = prefsFSSpec.name;
			   pb.dirInfo.ioVRefNum = prefsFSSpec.vRefNum;
			   pb.dirInfo.ioDrDirID = prefsFSSpec.parID;
			   pb.dirInfo.ioFDirIndex = 0;
			   if ( (PBGetCatInfoSync(&pb) == noErr) && (pb.hFileInfo.ioFlAttrib & kioFlAttribDirMask) != 0 )
               HSetVol(nil, pb.dirInfo.ioVRefNum, pb.dirInfo.ioDrDirID);
         }
         else if (DirCreate(foundPrefVRefNum, foundPrefDirID, dnetfolderName, &newDirID) == noErr)
            HSetVol(nil, foundPrefVRefNum, newDirID);
      }
   }
   // If everything failed we just keep the current directory as our home
}

void DoAboutBox(void)
{
	DialogPtr	AboutDialog;
	short		itemHit = 0;
	SndChannelPtr theSoundChannelP = nil;
	Handle theSoundH = nil;
	OSErr err;
   GrafPtr gp;
	Str255	pstr;
   static FontInfo			gFontInfo;

	AboutDialog = GetNewDialog(128, nil, (WindowPtr) -1);
   SetDialogDefaultItem(AboutDialog, 1);
   SetDialogCancelItem(AboutDialog, 1);

   GetPort(&gp);
   SetPort(AboutDialog);

   // Client version info
   MoveTo(70,20);
   DrawString("\pdistributed.net client - a project of distributed.net");

   MoveTo(70,33);
      const char * text = CliGetFullVersionDescriptor();
		pstr[0] = strlen(text);
		strcpy((char*)&pstr[1],text);
   DrawString(pstr);

   MoveTo(70,46);
   DrawString("\pCopyright 1997-2001 distributed.net");

   // Frame
   const Rect frame = {0,0,60,400};
   FrameRect(&frame);

   // Misc inof
   GetFontInfo (&gFontInfo);

	short baseLine = 70 + gFontInfo.ascent;
	Rect	*portRect		= &(qd.thePort->portRect);

	MoveTo (portRect->left + ((portRect->right - portRect->left) / 2) - (StringWidth("\pThis client is maintained by") / 2), baseLine);
	DrawString ("\pThis client is maintained by");

	baseLine += gFontInfo.ascent + gFontInfo.leading + 2;

	MoveTo (portRect->left + ((portRect->right - portRect->left) / 2) - (StringWidth("\pMichael Feiri <mfeiri@distributed.net>, <michael@feiri.de>") / 2), baseLine);
	DrawString ("\pMichael Feiri <mfeiri@distributed.net>, <michael@feiri.de>");

   TextSize(10);
   GetFontInfo (&gFontInfo);
   
	baseLine += gFontInfo.ascent + gFontInfo.leading + 10;

	MoveTo (portRect->left + ((portRect->right - portRect->left) / 2) - (StringWidth("\pdistributed.net bug tracking pages are at http://www.distributed.net/bugs/") / 2), baseLine);
	DrawString ("\pdistributed.net bug tracking pages are at http://www.distributed.net/bugs/");

	baseLine += gFontInfo.ascent + gFontInfo.leading + 2;

	MoveTo (portRect->left + ((portRect->right - portRect->left) / 2) - (StringWidth("\pPlease provide the entire version descriptor when making reports.") / 2), baseLine);
	DrawString ("\pPlease provide the entire version descriptor when making reports.");

   // the cow
	Rect 			iconRect = {0,0,32,32};
	OffsetRect( &iconRect, 21, 14);
	PlotIconID(&iconRect, atNone, ttNone, 128);
	
   // Moo!!
	theSoundH = GetResource('snd ', 128);
	if (theSoundH != nil) {
		err = SndNewChannel(&theSoundChannelP, sampledSynth, initMono,
			nil);
	if (err == noErr)
			SndPlay(theSoundChannelP, (SndListHandle)theSoundH, true);
			}
	
	//Do it
	do ModalDialog(nil, &itemHit);
	while(itemHit != 1);
	SndDisposeChannel(theSoundChannelP, true);
	theSoundChannelP = nil;
	ReleaseResource(theSoundH);
	theSoundH = nil;
	DisposeDialog(AboutDialog);

   SetPort(gp);

}

static void DoAdjustMenus (void)
{
  MenuHandle file_menu = GetMenuHandle( mFile );
  MenuHandle client_menu = GetMenuHandle( mClient );

  if (ModeReqIsRunning()/*ModeReqIsSet(-1)*/) 
  {
    if (ModeReqIsSet(MODEREQ_CONFIG))
    {
       DisableItem( file_menu, 1 );   // Pause
       DisableItem( file_menu, 3 );   // Quit
       DisableItem( client_menu, 1 ); // Fetch
       DisableItem( client_menu, 2 ); // Flush
       DisableItem( client_menu, 3 ); // Update
       DisableItem( client_menu, 5 ); // Benchmark
       DisableItem( client_menu, 6 ); // Test
       DisableItem( client_menu, 8 ); // Configure
       return;
    }
    else
    {
       // a mode is running
       DisableItem( file_menu, 1 );   // Pause
       EnableItem( file_menu, 3 );   // Quit
       DisableItem( client_menu, 1 ); // Fetch
       DisableItem( client_menu, 2 ); // Flush
       DisableItem( client_menu, 3 ); // Update
       DisableItem( client_menu, 5 ); // Benchmark
       DisableItem( client_menu, 6 ); // Test
       DisableItem( client_menu, 8 ); // Configure
       return;
     }
   }
   else if (CheckPauseRequestTrigger())
   {
     EnableItem( file_menu, 1 );   // Pause
     EnableItem( file_menu, 3 );   // Quit
     DisableItem( client_menu, 1 ); // Fetch
     DisableItem( client_menu, 2 ); // Flush
     DisableItem( client_menu, 3 ); // Update
     DisableItem( client_menu, 5 ); // Benchmark
     DisableItem( client_menu, 6 ); // Test
     EnableItem( client_menu, 8 ); // Configure
     return;
   }
   else
   {
     EnableItem( file_menu, 1 );   // Pause
     EnableItem( file_menu, 3 );   // Quit
     EnableItem( client_menu, 1 ); // Fetch
     EnableItem( client_menu, 2 ); // Flush
     EnableItem( client_menu, 3 ); // Update
     EnableItem( client_menu, 5 ); // Benchmark
     EnableItem( client_menu, 6 ); // Test
     EnableItem( client_menu, 8 ); // Configure
     return;
   }
}

/* 
Boolean	hasPowerPCArch()

	Gestalt will return an error if the gestaltSysArchitecture selector is
	not recognized by the System, so we can assume this is a 68K machine.
	Otherwise, this function returns true for a Power Mac and false for
	a 68K Mac.

{
	long	gestaltResult;

	if (Gestalt(gestaltSysArchitecture, &gestaltResult))
		return(false);
	else
		return(gestaltResult == gestaltPowerPC);
}


bool EventsPending()
{
 EventRecord ignored;
 return (OSEventAvail (everyEvent, &ignored) || CheckUpdate (&ignored));
}
*/

#pragma mark -

static pascal void my_NotificationResponse ( NMRecPtr n )
{
   if (n->nmSound)
      ReleaseResource(n->nmSound);
   if (n->nmIcon)
      DisposeIconSuite( n->nmIcon, 0 );
   if (n->nmStr)
	   DisposePtr ( (Ptr) n->nmStr );

	NMRemove ( n );
	if ( n->nmRefCon )		// true if error was fatal
		n->nmRefCon = 0L;
	else
		DisposePtr ( (Ptr) n );

	return;
}

void my_menucommand_handler( long menuResult )
{
  short menuID;
  short	menuItem;
  Str255 daName;
	
  menuID = HiWrd( menuResult );
  menuItem = LoWrd( menuResult );

   switch (menuID)
   {
   case mApple:
      if (menuItem == iAbout)
      {
         DoAboutBox();
         break;
      }
      else /* Desktop Accessories */
      {
         GetMenuItemText( GetMenuHandle( mApple ), menuItem, daName );
         OpenDeskAcc( daName );
         break;
      }
      break;

   case mFile:
		switch(menuItem)
		{
      case iPause:
         if (CheckPauseRequestTrigger())
         {
           ClearPauseRequestTrigger();
           CheckItem(GetMenuHandle( mFile ),iPause,false);
           //ShowWindow((WindowPtr)SIOUXTextWindow);
         }
         else
         {
           RaisePauseRequestTrigger();
           CheckItem(GetMenuHandle( mFile ),iPause,true);
           //HideWindow((WindowPtr)SIOUXTextWindow);
         }
         break;
		  case iQuit:
		     RaiseExitRequestTrigger();
         break;
      default:
         break;
      }
      break;

   case mClient:
      switch(menuItem)
      {
      case iFetch:
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FETCH);
         break;
      case iFlush:
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FLUSH);
         break;
      case iUpdate:
         ModeReqClear(-1);  /* clear all */
         ModeReqSet(MODEREQ_FETCH|MODEREQ_FLUSH);
         break;
      case iTest:
         ModeReqClear(-1);  /* clear all pending */
         ModeReqSet(MODEREQ_TEST_ALLCORE); /* request -test. */
         break;
      case iConfig:
         ShowWindow((WindowPtr)SIOUXTextWindow); // just in case
         ModeReqClear(-1);  /* clear all pending */
         ModeReqSet(MODEREQ_CONFIG|MODEREQ_CONFRESTART); /* request -config */
         break;
      default:
         break;
      }
      break;

   case mBenchSub:
     switch(menuItem)
     {
      //MODEREQ_BENCHMARK defaults to a) ~16sec bench b) of current core,
      //but can be modified with...
      //    MODEREQ_BENCHMARK_ALLCORE (do all cores instead of current core)
      //    MODEREQ_BENCHMARK_QUICK (do ~8sec bench instead of ~16sec)
      //
      //Its important that the user has _some_ way to do a comparison of
      //all cores (for a particular contest), otherwise we will never be able
      //to catch mis-configured selcore defaults. [This is really, really, 
      //very important! client .450 had a wrong autoselect value for G4] 
      case iBenchAll: //case 1:
        ModeReqClear(-1);  /* clear all pending */
        ModeReqSet(MODEREQ_BENCHMARK|MODEREQ_BENCHMARK_QUICK); /*-benchmark2*/
        break;
      //case 2== menu separator
      default:        //case 3...
        ModeReqClear(-1);  /* clear all pending */
        ModeReqSet(MODEREQ_BENCHMARK_ALLCORE);  /* request "-bench" */
        ModeReqLimitProject(MODEREQ_BENCHMARK,menuItem-3); /* limit to one contest */
        break;
      }
      break;
      
    default:
      break;
   }
   HiliteMenu(0);
}


void my_HandleNextEvent(EventRecord event)
{
	switch (event.what) {
	case mouseDown:
      WindowPtr window;
      short part = FindWindow(event.where, &window);
	    switch (part) {
	      case inMenuBar:
	        DoAdjustMenus();
			    my_menucommand_handler(MenuSelect(event.where));
		      break;
	      case inSysWindow:
			    SystemClick(&event, window);
		      break;
		    default:
	        SIOUXHandleOneEvent(&event);
		      break; }
		  break;
   case keyDown:
		char theChar = event.message & charCodeMask; // Handle menu shortcuts
      if ( event.modifiers & cmdKey )
        my_menucommand_handler( MenuKey( theChar ) );
      else
        SysBeep(1); // Notify users that they may not write to the feedback window
		break;
   case kHighLevelEvent: // I call AEProcessAppleEvent myself (if FBA then !SIOUX)
	   AEProcessAppleEvent(&event);
	case osEvt: // This deserves some investigation...
      my_uiStateStatics.foreground = event.message & 1;
	   SIOUXHandleOneEvent(&event);
	case nullEvent: // Let SIOUX do some cursor mintaining
	case updateEvt: // Let SIOUX update its windows etc.
	case diskEvt: // SIOUX handles things like BadDiskInsertion for us
	case activateEvt: // Basically the same as updateEvt
	   SIOUXHandleOneEvent(&event);
	   break;
	case mouseUp: // Why should we care about mouseUp?
	case keyUp: // Why should we care about keyUp?
	case autoKey: // Dont handle autorepeat keyboard input
	default:
	  break;
	}
}
/*
void my_ClientEventListener(int event_id, long parm)
{

// struct contestInfo in clicdata.cpp delivers good information  !!!
// struct WorkRecord in client.h delivers good info
// struct Client in client.h delivers good information
// struct in ccoreio.h delivers good information
// struct in console.cpp delivers good information

// routines in clicdata.cpp deliver good information
// routines in client.cpp deliver good information
// routines in bench.cpp deliver good information
// routines in buffbase.cpp deliver good information
// routines in cliident.cpp deliver good information
// routines in clirate.cpp deliver good information
// routines in clisrate.cpp deliver good information
// routines in clitime.cpp deliver good information
// routines in console.cpp deliver good information
// routines in cpucheck.cpp deliver good information
// routines in network.cpp deliver good information
//
//.....10%.....20%.....30%.....40%.....50%.....60%.....70%.....80%.....90%....100
//....10%....20%....30%....40%....50%....60%....70%....80%....90%...100% @ 656kkeys
//.....|.....|.....|.....|.....|.....|.....|.....|.....|.....| @ [366.75 kkeys/s]
//....10%..20%..30%..40%..50%..60%..70%..80%..90%..100% @ [400,762.86 keys/sec]
//....10%..20%..30%..40%..50%..60%..70%..80%..90%..100% @ [366.75 kkeys/s]
//....:....:....:....:....:....:....:....:....:....: @ [366.75 kkeys/s]
//
//The distributed.net bug report pages are at http://www.distributed.net/bugs/
//.....10%.....20%.....30%.....40%.....50%.....60%.....70%.....80%.....90%....100
//
// events in modereq deliver good information
// events in clievent.h deliver good information
// see old RC5 client for better internal event usage

#if 0
char event_kind[64];

//convert event_id to string
switch(event_id) {
	case CLIEVENT_CLIENT_STARTED:
			strcpy(event_kind, "Client Started");
			break;
	case CLIEVENT_CLIENT_FINISHED:
			strcpy(event_kind, "Client Finished");
			break;
	case CLIEVENT_CLIENT_RUNSTARTED:
			strcpy(event_kind, "Run Started");
			break;
	case CLIEVENT_CLIENT_RUNFINISHED:
			strcpy(event_kind, "Run Finished");
			break;
	case CLIEVENT_CLIENT_THREADSTARTED:
			strcpy(event_kind, "Thread Started");
			break;
	case CLIEVENT_CLIENT_THREADSTOPPED:
			strcpy(event_kind, "Thread Stopped");
			break;
	case CLIEVENT_PROBLEM_STARTED:
			strcpy(event_kind, "Problem Started");
			break;
	case CLIEVENT_PROBLEM_FINISHED:
			strcpy(event_kind, "Problem Finished");
			break;
	case CLIEVENT_PROBLEM_TFILLSTARTED:
			strcpy(event_kind, "Fill Started");
			break;
	case CLIEVENT_PROBLEM_TFILLFINISHED:
			strcpy(event_kind, "Fill Finished");
			break;
	case CLIEVENT_BUFFER_FETCHBEGIN:
			strcpy(event_kind, "Fetch Begin");
			break;
	case CLIEVENT_BUFFER_FETCHFETCHED:
			strcpy(event_kind, "Fetch Fetched");
			break;
	case CLIEVENT_BUFFER_FETCHEND:
			strcpy(event_kind, "Fetch End");
			break;
	case CLIEVENT_BUFFER_FLUSHBEGIN:
			strcpy(event_kind, "Flush Begin");
			break;
	case CLIEVENT_BUFFER_FLUSHFLUSHED:
			strcpy(event_kind, "Flush Flushed");
			break;
	case CLIEVENT_BUFFER_FLUSHEND:
			strcpy(event_kind, "Flush End");
			break;
	case CLIEVENT_SELFTEST_STARTED:
			strcpy(event_kind, "Test Started");
			break;
	case CLIEVENT_SELFTEST_TESTBEGIN:
			strcpy(event_kind, "Test Problem Begin");
			break;
	case CLIEVENT_SELFTEST_TESTEND:
			strcpy(event_kind, "Test Problem End");
			break;
	case CLIEVENT_SELFTEST_FINISHED:
			strcpy(event_kind, "Test Finished");
			break;
	case CLIEVENT_BENCHMARK_STARTED:
			strcpy(event_kind, "Benchmark Started");
			break;
	case CLIEVENT_BENCHMARK_BENCHING:
//			strcpy(event_kind, "Benchmark Benching");
			
static char *thiscontest;
Problem *theProblem;

			theProblem = (Problem *)parm;
			thiscontest = (char *)CliGetContestNameFromID(theProblem->contest);
			
				theProblem->permille = theProblem->CalcPermille();
				//printf("\rBenchmarking %s:%u%% (%u keys)",
				printf("\rBenchmarking %s:%u%% \n",
					thiscontest, (unsigned int)((theProblem->permille + 5) / 10)
					//,(unsigned int)theProblem->GetKeysDone().lo
					);
				fflush(stdout);
				
			break;
	case CLIEVENT_BENCHMARK_FINISHED:
			strcpy(event_kind, "Benchmark Finished");
			break;
	default:
			strcpy(event_kind, "Unknown Event");
			break;
	}

printf("--> ClientEventListener: %s event with parameter %x (hex)\n",
	event_kind, parm);
#endif
}




pascal void my_OTEndpointNotifier(void *context, OTEventCode code, OTResult result, void *cookie)
{
   printf("my_OTEndpointNotifier (%X)\n",code); SysBeep(1);
   switch (code)
   {

// Endpoint opened
		case T_OPENCOMPLETE:
         printf("failed (T_OPENCOMPLETE)\n"); SysBeep(1);
			//csm->fState = kPPPFailed;

			if(result != kOTNoError) DebugStr("\p CSM::NotifyProc - T_OPENCOMPLETE Failed; d3.w;");
			
			if(result != kOTNoError) break;
			
			if(OTIoctl((EndpointRef) cookie, I_OTGetMiscellaneousEvents, (void*)1) != kOTNoError ) break;
			
         printf("open(T_OPENCOMPLETE)\n"); SysBeep(1);
			//csm->fState = kPPPOpen;
		 	break;

		case kStreamIoctlEvent:
		
//		   dialup.gStatus=0;
		   
				if(result != kOTNoError){
						DebugStr("\p PPP CSM::NotifyProc -  kStreamIoctlEvent");
						
         printf("failed (kStreamIoctlEvent)\n"); SysBeep(1);
			//csm->fState = kPPPFailed;
						break;
						};
				
         printf("open (kStreamIoctlEvent)\n"); SysBeep(1);
			//csm->fState = kPPPOpen;

			break;

		case kPPPConnectCompleteEvent: //kPPPConnectCompleteEvent
//		   dialup.gStatus=1;
         printf("open (kPPPConnectCompleteEvent)\n");
		   break;
		   
//		default:
//		   dialup.gStatus=0;

	}
}



pascal void
CEndpoint::Notifier(void		*contextPtr,
					OTEventCode code,
					OTResult	result,
					void		*cookie)
{
OSStatus	status;
	
	if (result < kOTNoError)
	{
#if ASYNCDEBUGGING
		dprintf("Error returned in notifier: %ld, EventCode %ld", result);
#endif
		return;
	}
	
	EPCookie *epCookie = (EPCookie *) contextPtr;
	CEndpoint *theEndpoint = epCookie->endPoint;

	switch (code)
	{
		case T_DATA:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_DATA");
#endif
			status = theEndpoint->DoReceive(epCookie->ep, epCookie);
			break;
			
		case T_CONNECT:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_CONNECT");
#endif
			status = theEndpoint->HandleConnectComplete(epCookie);
			break;
			
		case T_DISCONNECT:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_DISCONNECT");
#endif
			status = theEndpoint->HandleDisconnect(epCookie, epCookie->ep, false);
			break;
			
		case T_ORDREL:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_ORDREL");
#endif
			status = theEndpoint->HandleDisconnect(epCookie, epCookie->ep, true);
			break;
			
		case T_DISCONNECTCOMPLETE:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_DISCONNECTCOMPLETE.  You can leave now");
#endif
			status = theEndpoint->HandleDisconnectComplete(epCookie, epCookie->ep);
			break;
			
		case T_LISTEN:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_LISTEN");
#endif
			status = theEndpoint->HandleNewConnection();
			break;
			
		case T_OPENCOMPLETE:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_OPENCOMPLETE");
#endif
			status = theEndpoint->HandleOpenEndpointComplete(epCookie, (EndpointRef) cookie);
			break;
			
		case T_ACCEPTCOMPLETE:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_ACCEPTCOMPLETE");
#endif
			theEndpoint->HandleHandoffComplete(epCookie, (EndpointRef) cookie);
			break;
			
		case T_PASSCON:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_PASSCON");
#endif
			break;
			
		case T_GODATA:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_GODATA");
#endif
			theEndpoint->HandleGoData((EndpointRef) cookie);
			break;
			
		case T_UNBINDCOMPLETE:
#if ASYNCDEBUGGING
			DebugStr("\pIn Notifier:T_UNBINDCOMPLETE");
#endif
			theEndpoint->HandleUnbindComplete(epCookie);
			break;
			
		default:
#if ASYNCDEBUGGING
		dprintf("In notifier: Unhandled event %ld", code);
#endif
		break;
	}
}
*/

#pragma mark -

int macosTickSleep(unsigned long tickcount)
{
   EventRecord event;

   //printf("tickcount: %d\n",tickcount);
	if (WaitNextEvent(everyEvent, &event, tickcount, NULL))
   my_HandleNextEvent(event);
   
   return(0);
}

void macosSmartYield(unsigned int priority)
{
/*
   0 use idle cycles only
   1 use idle cycles only
   2 use idle cycles only
   3 treated like an app
   4 treated like an app
   5 treated like an app
   6 no energy saver
   7 no energy saver
   8 no energy saver
   9 special hog-on-idle mode

what about the dyn_timeslice_table.usec values?
12345678,1 or 123,123,123,1

10000000 10 sec
1000000  1 sec
100000   1/10 sec
10000    1/100 sec
1000     1 ms

or have the hog on idle feature as a seperate option?

*/


//if(my_uiStateStatics.foreground)
if (priority < 3)
   macosTickSleep(1);
else
   macosTickSleep(0);
}

void macosGUSIYield(bool wait)
{
	if (wait) macosTickSleep(60);
  else macosTickSleep(0);
}

long macosFindProc( const char* name )
{
	OSErr err;
	ProcessInfoRec info;
	Str255				procName;
   unsigned char	len;
	ProcessSerialNumber	psn;	
   FSSpec              appFSSpec;

	psn.highLongOfPSN = kNoProcess;
	psn.lowLongOfPSN  = kNoProcess;

	info.processInfoLength	        = sizeof(ProcessInfoRec);
	info.processName		           = procName;
	info.processAppSpec             = &appFSSpec;

	do{
		err= GetNextProcess(&psn);
		if( !err ) {
			err= GetProcessInformation(&psn,&info);

         // a selfmade p2c
         BlockMove(procName + 1, procName, len = *procName);
	      procName[len] = 0;

         if (!strcmp((const char*)procName,name))
            //printf("MATCH");
            return psn.lowLongOfPSN;
      }
	} while( !err  );

   return 0;
}


int macosCPUTemp()
{
   int cputemp = -1;
#if (CLIENT_CPU == CPU_POWERPC)
   long result;

   if (MPLibraryIsLoaded())
   {
    int cpucount = MPProcessors();

/*   We cant use the official API because it involves a call to MP 2.x which whould break MP 1.x support */
//	   if ((Gestalt(gestaltPowerMgrVers, &result) == noErr) && (result >= 0x200))
//	   {
//         int cputemp2;
//         MPCpuID cpuID;
//	   
//         while (cpucount>0)
//         {
//            if (MPGetNextCpuID(kInvalidID,&cpuID) != noErr) return -1; //invalid
//            cputemp2=GetCoreProcessorTemperature(cpuID);
//            if (cputemp2 < 0) return -1; //invalid
//            if (cputemp2 > cputemp) cputemp=cputemp2;
//            cpucount--;
//         }
//         cputemp += 273;
//      }
/*      else*/ if ((cpucount == 1) && (Gestalt(gestaltMachineType, &result) == noErr))
      {
         if ((result != gestaltMacOSCompatibility) && (Gestalt(gestaltNativeCPUtype, &result) == noErr))
         {
            if ((result == gestaltCPU750) || (result == gestaltCPUG4))
            {
               // Single CPU G3/G4 but no MP and not inside a BlueBox. Do the deed!
               cputemp = GetProcessorTemperature() + 273;
            }
         }
      }
   }
#endif /* (CLIENT_CPU == CPU_POWERPC) */
//   printf("\nTemp:%i\n",cputemp);
   return cputemp; // assume everybody who might have tried returned the temp in Kelvin.
}


int macosConGetCh() /* wait (if needed) and return one keystroke */
{
   int c;
   EventRecord event;

   while (!CheckExitRequestTriggerNoIO())
   {
	   WaitNextEvent(everyEvent, &event, 100, nil);
	   if (event.what == keyDown )
	   {
	      c = event.message&charCodeMask;
         if ( event.modifiers & cmdKey )
            my_menucommand_handler( MenuKey( (char)c ) );
         else
         {
	         c = event.message&charCodeMask;
            #if (CLIENT_CPU == CPU_68K)
            c = (c & 0x000000ff);
            #endif
            if (c == 3) c = 13;  // "enter" equals "return".
            return c;
         }
	   }
      else if (event.what != autoKey )
      my_HandleNextEvent(event);
   }
   return 0;
}

/* --------------------------------------------------------------- */

int macosConOut(const char *msg)
{
  if (FreeMem()<32000)
    clrscr();

  fwrite( msg, sizeof(char), strlen(msg), stdout);
  fflush(stdout);
  MacShowCursor(); // restore cursor
  
  return strlen(msg);
}

/* --------------------------------------------------------------- */

void macosAlert( const char *cname, int deadly )
{
	NMRecPtr	notePtr;
	Str255	msg;
//	UInt32	tickLimit;

	msg[0] = sprintf((char*)&msg[1],"Moo! Your distributed.net client needs attention:\r\r%s",cname);
	
	notePtr = (NMRecPtr) NewPtr ( sizeof ( NMRec ) );
	
	if ( MemError() == noErr)
   {
	   notePtr->qType     = nmType;         // standard queue type for NM
	   notePtr->nmMark    = FALSE;	      // flash application menu instead of Apple menu 
//	   if (GetIconSuite(&notePtr->nmIcon,-16455,svAllAvailableData) != noErr) flash in menubar
		   notePtr->nmIcon = NULL;
	   notePtr->nmSound   = GetResource('snd ', 128); //(Handle) -1L;
   	notePtr->nmResp    = NewNMProc( my_NotificationResponse );
   	notePtr->nmRefCon  = deadly;  // true if application should quit
   	notePtr->nmStr     = NULL; // just in case NewPtr fails
	   notePtr->nmStr     = (StringPtr) NewPtr ( sizeof ( Str255 ) );
	   BlockMoveData( msg, notePtr->nmStr, msg[0] + 1 );

	   if ( NMInstall ( notePtr ) == noErr && deadly )// true if application should quit
	   {
	   //tickLimit = TickCount() + (5 * 1); //	Timeout the notification after approximately 60 seconds.

		   while ( notePtr->nmRefCon /*|| (TickCount() < tickLimit)*/)
		   	sleep(1);
      	ExitToShell();
	   }
   }
   if (deadly) ExitToShell();
}

/* --------------------------------------------------------------- */

int macosInitializeConsole(int runhidden, int runmodes)
// runhidden = -hide, runmodes = pending_event(modereq)
{
  InstallConsole(0);
  
  if (!runmodes && runhidden) // better write a real SIOUX Initializer
     HideWindow((WindowPtr)SIOUXTextWindow);
  
  SetCursor(&qd.arrow); // just in case
  
  return 0;
}

/* --------------------------------------------------------------- */

void macosInitialize(void)
{
	Handle			menuBar;
	SInt16			contest_i;
	SInt32			result;
	OSErr			   err;
	
  if (my_uiStateStatics.initialized_counter == 0)
  {
	/* Free up our heap and clean out the event queue */

#if defined (MAC_FBA)

   // As seen in Technote 1070:
	THz		myZone;
	
   // Check that we aren't running with a corrupt heap. If we are,
   // fix the problem. This was a bug with FBA's before System 7.5.5.
   // With System Software later than 7.5.5, this "fix" is harmless.
   myZone = GetZone();
   if (myZone->bkLim != LMGetHeapEnd())
      LMSetHeapEnd(myZone->bkLim);
 
   // Increase the stack size by lowering the heap limit. 24kb
   SetApplLimit((Ptr) ((unsigned long) GetApplLimit() - 0x00006000));
   if (MemError() != noErr) ExitToShell(); // Performing an alert is not yet possible

#endif

	MaxApplZone();
	MoreMasters();
	MoreMasters();
	MoreMasters();
	MoreMasters();
	MoreMasters();
	
   memset( &my_uiStateStatics, 0, sizeof(my_uiStateStatics));
	
	FlushEvents(everyEvent,0);


	/* Do basic Toolbox initializations */

   InitGraf(&qd.thePort);

#if !defined(MAC_FBA)

	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(nil);
	InitCursor();

   my_uiStateStatics.foreground = 1;

#else

   my_uiStateStatics.foreground = 0;

#endif

	/* Check if we run a supported OS ( System7 or higher ) */
	
	err = Gestalt( gestaltSystemVersion, &result );
	if ( err != noErr || result < 0x700 )
		macosAlert( "Sorry, this client cannot be used because it requires Mac OS 7.0 or higher.", 1 );

#if !defined(MAC_FBA)


   /* Set up our menus */
	
	menuBar = GetNewMBar(rMenuBar);
	if ( menuBar == nil )
		macosAlert( "Sorry, your client cannot startup because a necessary resource seems to be missing.", 1 );

	SetMenuBar(menuBar);
	
	DisposeHandle(menuBar);
	AppendResMenu(GetMenuHandle(mApple),'DRVR');
	
	InsertMenu(GetMenu(mFile), 0);
	InsertMenu(GetMenu(mClient), 0);
	
	/* Dynamically generate contest submenu */
	
	InsertMenu( GetMenu(mBenchSub), -1 );
	
	for ( contest_i = 0; contest_i < CONTEST_COUNT; contest_i++ )
	{
      Str255  pstr; unsigned int pos;
      const char *cname = CliGetContestNameFromID(contest_i);
      if (!cname)  cname = "";
      if (!*cname) cname = "???";
      pos = 0;
      while (pos < 254 && *cname)
        pstr[++pos] = *cname++;
      pstr[0] = pos;

      InsertMenuItem(GetMenu(mBenchSub), pstr,contest_i+2);
      SetItemCmd(GetMenu(mBenchSub),contest_i+3,0x30+(contest_i+1));
	   if (!IsProblemLoadPermitted(-1 /*any thread*/, contest_i))
	      DisableItem( GetMenuHandle( mBenchSub ), contest_i+3 );
	}
	
	DrawMenuBar();

	/* Configure SIOUX */

	SIOUXSettings.initializeTB = false;
	SIOUXSettings.standalone = false; /* adjustable */
	SIOUXSettings.setupmenus = false; /* adjustable */
	SIOUXSettings.autocloseonquit = false; /* not adjustable */
	SIOUXSettings.asktosaveonclose = false; /* not adjustable */
	SIOUXSettings.showstatusline = false; /* adjustable */
	SIOUXSettings.userwindowtitle = (unsigned char *)"\pdistributed.net client"; /* adjustable */

   SIOUXSettings.rows = 25;
   SIOUXSettings.columns = 80;		


#endif /* defined(MAC_FBA) */

   /* Install hooks */
	
   GUSISetHook(GUSI_SpinHook, (GUSIHook) macosGUSIYield);
	
   AEInstallEventHandler(kCoreEventClass, kAEOpenApplication, NewAEEventHandlerProc(DoOpenAppEvent), 0, false);
	 
   AEInstallEventHandler(kCoreEventClass, kAEQuitApplication, NewAEEventHandlerProc(DoQuitAppEvent), 0, false);
	
   AEInstallEventHandler( 'DNET', 'UPDA', NewAEEventHandlerProc(DoUpdateEvent), 0, false);
	 
   AEInstallEventHandler( 'DNET', 'FLSH', NewAEEventHandlerProc(DoFlushEvent), 0, false);
	
   AEInstallEventHandler( 'DNET', 'FTCH', NewAEEventHandlerProc(DoFetchEvent), 0, false);
	 
   AEInstallEventHandler( 'DNET', 'PAUS', NewAEEventHandlerProc(DoPauseEvent), 0, false);
	
   AEInstallEventHandler( 'DNET', 'RESU', NewAEEventHandlerProc(DoResumeEvent), 0, false);

   DoSetDirectory();

   my_uiStateStatics.initialized_counter++;

  } /* if (my_uiStateStatics.initialized_counter == 0) */

}

#pragma mark -

char * strdup(char * str)
{
   char *newstring;

   newstring = (char *) malloc(sizeof(char) * (strlen(str) + 1));
   if(!newstring)
      return(NULL);

   strcpy(newstring, str);

   return(newstring);
}
