;; notes on changes made for OSX assembler
;;	SP			->		r2
;;	vrsave		->		256
;;	*+36		->		.+36		-> 		labels
;;	vrN			->		vN
;;	lvx		vN, r0, rN		->		lvx		vN, 0, rN


.data
.cstring
	.align 2
	.ascii	"AltiVec assembly by Dan Oetting\0"
	.ascii	"Last minute miracles by Chris Cox and Michael Feiri\0"



.text

	;;  HACK ALERT - cpu_number appears to be unimplemented
	
	.align 5
	
	.globl _cpu_number__Fv
	
_cpu_number__Fv:
		li r3, 2
		blr

	

	;; This is the AltiVec RC5 cruncher
	.align 5
	
	.globl _crunch_vec
	
_crunch_vec:
	
		mflr       r0
		stw        r0,8(r1)
		stmw       r13,-76(r1)
		stw        r3,24(r1)
		stw        r4,28(r1)
		mfspr      r0,256
		stw        r0,-80(r1)
		li         r0,-1
		mtspr      256,r0
		mr         r6,r1
		clrlwi     r12,r1,28
		subfic     r12,r12,-656
		stwux      r1,r1,r12
		li         r0,384
		stvx       v20,r1,r0
		li         r0,400
		stvx       v21,r1,r0
		li         r0,416
		stvx       v22,r1,r0
		li         r0,432
		stvx       v23,r1,r0
		li         r0,448
		stvx       v24,r1,r0
		li         r0,464
		stvx       v25,r1,r0
		li         r0,480
		stvx       v26,r1,r0
		li         r0,496
		stvx       v27,r1,r0
		li         r0,512
		stvx       v28,r1,r0
		li         r0,528
		stvx       v29,r1,r0
		li         r0,544
		stvx       v30,r1,r0
		li         r0,560
		stvx       v31,r1,r0
		lwz        r0,0(r3)
		stw        r0,184(r1)
		lwz        r0,4(r3)
		stw        r0,180(r1)
		lwz        r0,8(r3)
		stw        r0,36(r1)
		lwz        r0,12(r3)
		stw        r0,188(r1)
		li         r5,16
		lwbrx      r18,r5,r3
		li         r5,20
		lwbrx      r13,r5,r3
		addi       r6,r1,16
		addi       r7,r1,32
		addi       r8,r1,48
		li         r9,128
		li         r10,192
		li         r11,256
		li         r12,320
		li         r5,64
		clrlwi     r0,r18,30
		add        r4,r4,r0
		clrrwi     r18,r18,2
start:
		stw        r13,48(r1)
		stw        r18,32(r1)
		subi       r19,r4,1
		ori        r19,r19,3
		not        r0,r18
		cmplw      r0,r19
		bge        L1
		mr         r19,r0
L1:
		srwi       r19,r19,2
		addi       r19,r19,1
		mtctr      r19
		slwi       r19,r19,2
		subf       r4,r19,r4
		lis        r19,-18463
		lis        r17,-25033
		addi       r19,r19,20835
		addi       r17,r17,31161
		lwbrx      r13,0,r8
		rotlwi     r28,r19,3
		add        r13,r13,r28
		rotlw      r13,r13,r28
		add        r19,r19,r17
		add        r0,r19,r28
		add        r0,r0,r13
		rotlwi     r29,r0,3
		add        r14,r13,r29
		add        r19,r19,r17
		add        r15,r19,r29
		stw        r19,64(r1)
		stw        r17,68(r1)
		stw        r13,72(r1)
		stw        r29,76(r1)
		stw        r28,172(r1)
		stw        r29,176(r1)
		lwbrx      r24,0,r7
		stw        r24,96(r1)
		addis      r25,r24,256
		stw        r25,100(r1)
		addis      r26,r25,256
		stw        r26,104(r1)
		addis      r27,r26,256
		stw        r27,108(r1)
		lvx        v29,r5,r1
		vspltisw   v28,3
		vspltw     v0,v29,0
		vspltw     v23,v29,1
		vspltw     v30,v29,2
		vspltw     v1,v29,3
		lvx        v31,r5,r7
		vadduwm    v27,v1,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v2,v0,v1
		vadduwm    v2,v2,v31
		vrlw       v2,v2,v28
		vadduwm    v27,v2,v31
		vadduwm    v30,v30,v27
		vrlw       v30,v30,v27
		vadduwm    v0,v0,v23
		vadduwm    v3,v0,v2
		vadduwm    v3,v3,v30
		vrlw       v3,v3,v28
		vadduwm    v27,v3,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v0,v0,v23
		vadduwm    v4,v0,v3
		vadduwm    v4,v4,v31
		vrlw       v4,v4,v28
		vadduwm    v27,v4,v31
		vadduwm    v30,v30,v27
		vrlw       v30,v30,v27
		vadduwm    v0,v0,v23
		vadduwm    v5,v0,v4
		vadduwm    v5,v5,v30
		vrlw       v5,v5,v28
		vadduwm    v27,v5,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v0,v0,v23
		vadduwm    v6,v0,v5
		vadduwm    v6,v6,v31
		vrlw       v6,v6,v28
		stvx       v6,r11,r1
		vadduwm    v27,v6,v31
		vadduwm    v30,v30,v27
		vrlw       v30,v30,v27
		vadduwm    v0,v0,v23
		vadduwm    v7,v0,v6
		vadduwm    v7,v7,v30
		vrlw       v7,v7,v28
		stvx       v7,r11,r6
		vadduwm    v27,v7,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v0,v0,v23
		vadduwm    v8,v0,v7
		vadduwm    v8,v8,v31
		vrlw       v8,v8,v28
		stvx       v8,r11,r7
		vadduwm    v27,v8,v31
		vadduwm    v30,v30,v27
		vrlw       v30,v30,v27
		vadduwm    v0,v0,v23
		vadduwm    v9,v0,v8
		vadduwm    v9,v9,v30
		vrlw       v9,v9,v28
		stvx       v9,r11,r8
		vadduwm    v27,v9,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v0,v0,v23
		vadduwm    v10,v0,v9
		vadduwm    v10,v10,v31
		vrlw       v10,v10,v28
		stvx       v10,r12,r1
		vadduwm    v27,v10,v31
		vadduwm    v30,v30,v27
		vrlw       v30,v30,v27
		vadduwm    v0,v0,v23
		vadduwm    v11,v0,v10
		vadduwm    v11,v11,v30
		vrlw       v11,v11,v28
		stvx       v11,r12,r6
		vadduwm    v27,v11,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v0,v0,v23
		vadduwm    v12,v0,v11
		vadduwm    v12,v12,v31
		vrlw       v12,v12,v28
		stvx       v12,r12,r7
		vadduwm    v27,v12,v31
		vadduwm    v30,v30,v27
		vrlw       v30,v30,v27
		vadduwm    v0,v0,v23
		vadduwm    v13,v0,v12
		vadduwm    v13,v13,v30
		vrlw       v13,v13,v28
		stvx       v13,r12,r8
		vadduwm    v27,v13,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v0,v0,v23
		vadduwm    v14,v0,v13
		vadduwm    v14,v14,v31
		vrlw       v14,v14,v28
		vadduwm    v27,v14,v31
		vadduwm    v30,v30,v27
		vrlw       v30,v30,v27
		vadduwm    v0,v0,v23
		vadduwm    v15,v0,v14
		vadduwm    v15,v15,v30
		vrlw       v15,v15,v28
		vadduwm    v27,v15,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vadduwm    v16,v0,v23
		addi       r18,r18,4
		stw        r18,32(r1)
		lwbrx      r24,0,r7
		add        r16,r19,r17
		add        r24,r24,r14
		addis      r25,r24,256
		addis      r26,r25,256
		addis      r27,r26,256
		rotlw      r24,r24,r14
		rotlw      r25,r25,r14
		rotlw      r26,r26,r14
		rotlw      r27,r27,r14
		add        r28,r15,r24
		rotlwi     r28,r28,3
		stw        r28,192(r1)
		add        r29,r15,r25
		rotlwi     r29,r29,3
		stw        r29,196(r1)
		add        r30,r15,r26
		rotlwi     r30,r30,3
		stw        r30,200(r1)
		add        r31,r15,r27
		rotlwi     r31,r31,3
		stw        r31,204(r1)
		add        r0,r28,r24
		add        r20,r13,r0
		rotlw      r20,r20,r0
		add        r0,r29,r25
		add        r21,r13,r0
		rotlw      r21,r21,r0
		add        r0,r30,r26
		add        r22,r13,r0
		rotlw      r22,r22,r0
		add        r0,r31,r27
		add        r23,r13,r0
		rotlw      r23,r23,r0
		add        r19,r16,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		add        r19,r19,r17
		stw        r19,128(r1)
		add        r19,r19,r17
		stw        r19,132(r1)
		add        r19,r19,r17
		stw        r19,136(r1)
		add        r19,r19,r17
		stw        r19,140(r1)
		add        r19,r19,r17
		stw        r19,144(r1)
		add        r19,r19,r17
		stw        r19,148(r1)
		add        r19,r19,r17
		stw        r19,152(r1)
		add        r19,r19,r17
		stw        r19,156(r1)
		add        r19,r19,r17
		stw        r19,160(r1)
		add        r19,r19,r17
		stw        r19,164(r1)
		add        r19,r19,r17
		stw        r19,168(r1)
		lvx        v29,r9,r1
loop:
		vadduwm    v16,v16,v15
		vspltw     v17,v29,2
		vadduwm    v16,v16,v31
		vspltw     v18,v29,3
		vrlw       v16,v16,v28
		lvx        v29,r9,r6
		vadduwm    v27,v16,v31
		vadduwm    v30,v30,v27
		add        r28,r16,r28
		vrlw       v30,v30,v27
		add        r28,r28,r20
		vadduwm    v17,v17,v16
		rotlwi     r28,r28,3
		vadduwm    v17,v17,v30
		stw        r28,208(r1)
		vrlw       v17,v17,v28
		add        r29,r16,r29
		vadduwm    v27,v17,v30
		add        r29,r29,r21
		vadduwm    v31,v31,v27
		rotlwi     r29,r29,3
		vrlw       v31,v31,v27
		stw        r29,212(r1)
		vadduwm    v18,v18,v17
		add        r30,r16,r30
		vadduwm    v18,v18,v31
		add        r30,r30,r22
		vrlw       v18,v18,v28
		vspltw     v19,v29,0
		vadduwm    v27,v18,v31
		rotlwi     r30,r30,3
		vadduwm    v30,v30,v27
		stw        r30,216(r1)
		vrlw       v30,v30,v27
		add        r31,r16,r31
		vadduwm    v19,v19,v18
		add        r31,r31,r23
		vadduwm    v19,v19,v30
		rotlwi     r31,r31,3
		vrlw       v19,v19,v28
		vspltw     v20,v29,1
		vadduwm    v27,v19,v30
		stw        r31,220(r1)
		vadduwm    v31,v31,v27
		add        r0,r28,r20
		vrlw       v31,v31,v27
		add        r24,r24,r0
		vadduwm    v20,v20,v19
		rotlw      r24,r24,r0
		vadduwm    v20,v20,v31
		vspltw     v21,v29,2
		vrlw       v20,v20,v28
		lvx        v6,r11,r1
		vadduwm    v27,v20,v31
		add        r0,r29,r21
		vadduwm    v30,v30,v27
		add        r25,r25,r0
		vrlw       v30,v30,v27
		rotlw      r25,r25,r0
		vadduwm    v21,v21,v20
		vspltw     v22,v29,3
		vadduwm    v21,v21,v30
		lvx        v29,r9,r7
		vrlw       v21,v21,v28
		add        r0,r30,r22
		vadduwm    v27,v21,v30
		add        r26,r26,r0
		vadduwm    v31,v31,v27
		rotlw      r26,r26,r0
		vrlw       v31,v31,v27
		add        r0,r31,r23
		vadduwm    v22,v22,v21
		add        r27,r27,r0
		vadduwm    v22,v22,v31
		lvx        v7,r11,r6
		vrlw       v22,v22,v28
		rotlw      r27,r27,r0
		vadduwm    v27,v22,v31
		vspltw     v23,v29,0
		vadduwm    v30,v30,v27
		vspltw     v24,v29,1
		vrlw       v30,v30,v27
		vspltw     v25,v29,2
		vadduwm    v23,v23,v22
		vspltw     v0,v29,3
		vadduwm    v23,v23,v30
		lvx        v29,r9,r8
		vrlw       v23,v23,v28
		add        r19,r16,r17
		vadduwm    v27,v23,v30
		add        r28,r19,r28
		vadduwm    v31,v31,v27
		add        r28,r28,r24
		vrlw       v31,v31,v27
		rotlwi     r28,r28,3
		vadduwm    v24,v24,v23
		stw        r28,224(r1)
		vadduwm    v24,v24,v31
		add        r29,r19,r29
		vrlw       v24,v24,v28
		vspltw     v1,v29,0
		vadduwm    v27,v24,v31
		add        r29,r29,r25
		vadduwm    v30,v30,v27
		rotlwi     r29,r29,3
		vrlw       v30,v30,v27
		stw        r29,228(r1)
		vadduwm    v25,v25,v24
		add        r30,r19,r30
		vadduwm    v25,v25,v30
		add        r30,r30,r26
		vrlw       v25,v25,v28
		rotlwi     r30,r30,3
		vadduwm    v27,v25,v30
		stw        r30,232(r1)
		vadduwm    v31,v31,v27
		add        r31,r19,r31
		vrlw       v31,v31,v27
		add        r31,r31,r27
		vadduwm    v0,v0,v25
		rotlwi     r31,r31,3
		vadduwm    v0,v0,v31
		stw        r31,236(r1)
		vrlw       v0,v0,v28
		add        r0,r28,r24
		vadduwm    v27,v0,v31
		add        r20,r20,r0
		vadduwm    v30,v27,v30
		rotlw      r20,r20,r0
		vrlw       v30,v30,v27
		lvx        v8,r11,r7
		vadduwm    v1,v1,v0
		add        r0,r29,r25
		vadduwm    v1,v1,v30
		add        r21,r21,r0
		vrlw       v1,v1,v28
		rotlw      r21,r21,r0
		vadduwm    v27,v1,v30
		add        r0,r30,r26
		vadduwm    v31,v27,v31
		add        r22,r22,r0
		vrlw       v31,v31,v27
		lvx        v9,r11,r8
		vadduwm    v2,v2,v1
		rotlw      r22,r22,r0
		vadduwm    v2,v2,v31
		add        r0,r31,r27
		vrlw       v2,v2,v28
		add        r23,r23,r0
		vadduwm    v27,v2,v31
		rotlw      r23,r23,r0
		vadduwm    v30,v27,v30
		add        r19,r19,r17
		vrlw       v30,v30,v27
		lvx        v10,r12,r1
		vadduwm    v3,v3,v2
		add        r28,r19,r28
		vadduwm    v3,v3,v30
		add        r28,r28,r20
		vrlw       v3,v3,v28
		rotlwi     r28,r28,3
		vadduwm    v27,v3,v30
		stw        r28,240(r1)
		vadduwm    v31,v27,v31
		add        r29,r19,r29
		vrlw       v31,v31,v27
		add        r29,r29,r21
		vadduwm    v4,v4,v3
		rotlwi     r29,r29,3
		vadduwm    v4,v4,v31
		stw        r29,244(r1)
		vrlw       v4,v4,v28
		add        r30,r19,r30
		vadduwm    v27,v4,v31
		add        r30,r30,r22
		vadduwm    v30,v27,v30
		rotlwi     r30,r30,3
		vrlw       v30,v30,v27
		stw        r30,248(r1)
		vadduwm    v5,v5,v4
		add        r31,r19,r31
		vadduwm    v5,v5,v30
		add        r31,r31,r23
		vrlw       v5,v5,v28
		rotlwi     r31,r31,3
		vadduwm    v27,v5,v30
		stw        r31,252(r1)
		vadduwm    v31,v27,v31
		add        r0,r28,r20
		vrlw       v31,v31,v27
		add        r24,r24,r0
		vadduwm    v6,v6,v5
		rotlw      r24,r24,r0
		vadduwm    v6,v6,v31
		lvx        v11,r12,r6
		vrlw       v6,v6,v28
		add        r0,r29,r21
		vadduwm    v27,v6,v31
		add        r25,r25,r0
		vadduwm    v30,v27,v30
		rotlw      r25,r25,r0
		vrlw       v30,v30,v27
		add        r0,r30,r22
		vadduwm    v7,v7,v6
		add        r26,r26,r0
		vadduwm    v7,v7,v30
		lvx        v12,r12,r7
		vrlw       v7,v7,v28
		rotlw      r26,r26,r0
		vadduwm    v27,v7,v30
		add        r0,r31,r23
		vadduwm    v31,v27,v31
		add        r27,r27,r0
		vrlw       v31,v31,v27
		rotlw      r27,r27,r0
		vadduwm    v8,v8,v7
		add        r19,r19,r17
		vadduwm    v8,v8,v31
		add        r28,r19,r28
		vrlw       v8,v8,v28
		add        r28,r28,r24
		vadduwm    v27,v8,v31
		rotlwi     r28,r28,3
		vadduwm    v30,v27,v30
		stw        r28,256(r1)
		vrlw       v30,v30,v27
		add        r29,r19,r29
		vadduwm    v9,v9,v8
		add        r29,r29,r25
		vadduwm    v9,v9,v30
		rotlwi     r29,r29,3
		vrlw       v9,v9,v28
		stw        r29,260(r1)
		vadduwm    v27,v9,v30
		add        r30,r19,r30
		vadduwm    v31,v27,v31
		add        r30,r30,r26
		vrlw       v31,v31,v27
		rotlwi     r30,r30,3
		vadduwm    v10,v10,v9
		stw        r30,264(r1)
		vadduwm    v10,v10,v31
		add        r31,r19,r31
		vrlw       v10,v10,v28
		add        r31,r31,r27
		vadduwm    v27,v10,v31
		rotlwi     r31,r31,3
		vadduwm    v30,v27,v30
		stw        r31,268(r1)
		vrlw       v30,v30,v27
		add        r0,r28,r24
		vadduwm    v11,v11,v10
		add        r20,r20,r0
		vadduwm    v11,v11,v30
		rotlw      r20,r20,r0
		vrlw       v11,v11,v28
		add        r0,r29,r25
		vadduwm    v27,v11,v30
		lvx        v13,r12,r8
		vadduwm    v31,v27,v31
		add        r21,r21,r0
		vrlw       v31,v31,v27
		rotlw      r21,r21,r0
		vadduwm    v12,v12,v11
		add        r0,r30,r26
		vadduwm    v12,v12,v31
		add        r22,r22,r0
		vrlw       v12,v12,v28
		rotlw      r22,r22,r0
		vadduwm    v27,v12,v31
		add        r0,r31,r27
		vadduwm    v30,v27,v30
		add        r23,r23,r0
		vrlw       v30,v30,v27
		rotlw      r23,r23,r0
		vadduwm    v13,v13,v12
		add        r19,r19,r17
		vadduwm    v13,v13,v30
		add        r28,r19,r28
		vrlw       v13,v13,v28
		add        r28,r28,r20
		vadduwm    v27,v13,v30
		rotlwi     r28,r28,3
		vadduwm    v31,v27,v31
		stw        r28,272(r1)
		vrlw       v31,v31,v27
		add        r29,r19,r29
		vadduwm    v14,v14,v13
		add        r29,r29,r21
		vadduwm    v14,v14,v31
		rotlwi     r29,r29,3
		vrlw       v14,v14,v28
		stw        r29,276(r1)
		vadduwm    v27,v14,v31
		add        r30,r19,r30
		vadduwm    v30,v27,v30
		add        r30,r30,r22
		vrlw       v30,v30,v27
		rotlwi     r30,r30,3
		vadduwm    v15,v15,v14
		stw        r30,280(r1)
		vadduwm    v15,v15,v30
		add        r31,r19,r31
		vrlw       v15,v15,v28
		add        r31,r31,r23
		vadduwm    v27,v15,v30
		rotlwi     r31,r31,3
		vadduwm    v31,v27,v31
		stw        r31,284(r1)
		vrlw       v31,v31,v27
		add        r0,r28,r20
		vadduwm    v16,v16,v15
		add        r24,r24,r0
		vadduwm    v16,v16,v31
		rotlw      r24,r24,r0
		vrlw       v16,v16,v28
		add        r0,r29,r21
		vadduwm    v27,v16,v31
		add        r25,r25,r0
		vadduwm    v30,v27,v30
		rotlw      r25,r25,r0
		vrlw       v30,v30,v27
		add        r0,r30,r22
		vadduwm    v17,v17,v16
		add        r26,r26,r0
		vadduwm    v17,v17,v30
		rotlw      r26,r26,r0
		vrlw       v17,v17,v28
		add        r0,r31,r23
		vadduwm    v27,v17,v30
		add        r27,r27,r0
		vadduwm    v31,v27,v31
		rotlw      r27,r27,r0
		vrlw       v31,v31,v27
		add        r19,r19,r17
		vadduwm    v18,v18,v17
		add        r28,r19,r28
		vadduwm    v18,v18,v31
		add        r28,r28,r24
		vrlw       v18,v18,v28
		rotlwi     r28,r28,3
		vadduwm    v27,v18,v31
		stw        r28,288(r1)
		vadduwm    v30,v27,v30
		add        r29,r19,r29
		vrlw       v30,v30,v27
		add        r29,r29,r25
		vadduwm    v19,v19,v18
		rotlwi     r29,r29,3
		vadduwm    v19,v19,v30
		stw        r29,292(r1)
		vrlw       v19,v19,v28
		add        r30,r19,r30
		vadduwm    v27,v19,v30
		add        r30,r30,r26
		vadduwm    v31,v27,v31
		rotlwi     r30,r30,3
		vrlw       v31,v31,v27
		stw        r30,296(r1)
		vadduwm    v20,v20,v19
		add        r31,r19,r31
		vadduwm    v20,v20,v31
		add        r31,r31,r27
		vrlw       v20,v20,v28
		rotlwi     r31,r31,3
		vadduwm    v27,v20,v31
		stw        r31,300(r1)
		vadduwm    v30,v27,v30
		add        r0,r28,r24
		vrlw       v30,v30,v27
		add        r20,r20,r0
		vadduwm    v21,v21,v20
		rotlw      r20,r20,r0
		vadduwm    v21,v21,v30
		add        r0,r29,r25
		vrlw       v21,v21,v28
		add        r21,r21,r0
		vadduwm    v27,v21,v30
		rotlw      r21,r21,r0
		vadduwm    v31,v27,v31
		add        r0,r30,r26
		vrlw       v31,v31,v27
		add        r22,r22,r0
		vadduwm    v22,v22,v21
		rotlw      r22,r22,r0
		vadduwm    v22,v22,v31
		add        r0,r31,r27
		vrlw       v22,v22,v28
		add        r23,r23,r0
		vadduwm    v27,v22,v31
		rotlw      r23,r23,r0
		vadduwm    v30,v27,v30
		add        r19,r19,r17
		vrlw       v30,v30,v27
		add        r28,r19,r28
		vadduwm    v23,v23,v22
		add        r28,r28,r20
		vadduwm    v23,v23,v30
		rotlwi     r28,r28,3
		vrlw       v23,v23,v28
		stw        r28,304(r1)
		vadduwm    v27,v23,v30
		add        r29,r19,r29
		vadduwm    v31,v27,v31
		add        r29,r29,r21
		vrlw       v31,v31,v27
		rotlwi     r29,r29,3
		vadduwm    v24,v24,v23
		stw        r29,308(r1)
		vadduwm    v24,v24,v31
		add        r30,r19,r30
		vrlw       v24,v24,v28
		add        r30,r30,r22
		vadduwm    v27,v24,v31
		rotlwi     r30,r30,3
		vadduwm    v30,v27,v30
		stw        r30,312(r1)
		vrlw       v30,v30,v27
		add        r31,r19,r31
		vadduwm    v25,v25,v24
		add        r31,r31,r23
		vadduwm    v25,v25,v30
		rotlwi     r31,r31,3
		vrlw       v25,v25,v28
		stw        r31,316(r1)
		vadduwm    v27,v25,v30
		add        r0,r28,r20
		vadduwm    v31,v27,v31
		add        r24,r24,r0
		vrlw       v31,v31,v27
		rotlw      r24,r24,r0
		vadduwm    v0,v0,v25
		add        r0,r29,r21
		vadduwm    v0,v0,v31
		add        r25,r25,r0
		vrlw       v0,v0,v28
		rotlw      r25,r25,r0
		vadduwm    v27,v0,v31
		add        r0,r30,r22
		vadduwm    v30,v27,v30
		add        r26,r26,r0
		vrlw       v30,v30,v27
		vspltw     v27,v29,1
		vadduwm    v1,v1,v0
		rotlw      r26,r26,r0
		vadduwm    v1,v1,v30
		add        r0,r31,r23
		vrlw       v1,v1,v28
		add        r27,r27,r0
		vadduwm    v0,v27,v0
		rotlw      r27,r27,r0
		vadduwm    v27,v1,v30
		add        r19,r19,r17
		vadduwm    v31,v27,v31
		add        r28,r19,r28
		vrlw       v31,v31,v27
		vspltw     v27,v29,2
		vadduwm    v2,v2,v1
		add        r28,r28,r24
		vadduwm    v2,v2,v31
		rotlwi     r28,r28,3
		vrlw       v2,v2,v28
		stw        r28,320(r1)
		vadduwm    v1,v27,v1
		add        r29,r19,r29
		vadduwm    v27,v2,v31
		add        r29,r29,r25
		vadduwm    v30,v27,v30
		rotlwi     r29,r29,3
		vrlw       v30,v30,v27
		stw        r29,324(r1)
		vxor       v0,v0,v1
		add        r30,r19,r30
		vrlw       v0,v0,v1
		add        r30,r30,r26
		vadduwm    v0,v0,v2
		rotlwi     r30,r30,3
		vadduwm    v3,v3,v2
		stw        r30,328(r1)
		vadduwm    v3,v3,v30
		add        r31,r19,r31
		vrlw       v3,v3,v28
		add        r31,r31,r27
		vadduwm    v27,v3,v30
		rotlwi     r31,r31,3
		vadduwm    v31,v27,v31
		stw        r31,332(r1)
		vrlw       v31,v31,v27
		add        r0,r28,r24
		vxor       v1,v1,v0
		add        r20,r20,r0
		vrlw       v1,v1,v0
		rotlw      r20,r20,r0
		vadduwm    v1,v1,v3
		add        r0,r29,r25
		vadduwm    v4,v4,v3
		add        r21,r21,r0
		vadduwm    v4,v4,v31
		rotlw      r21,r21,r0
		vrlw       v4,v4,v28
		add        r0,r30,r26
		vadduwm    v27,v4,v31
		add        r22,r22,r0
		vadduwm    v30,v27,v30
		lvx        v2,r10,r1
		vrlw       v30,v30,v27
		rotlw      r22,r22,r0
		vxor       v0,v0,v1
		add        r0,r31,r27
		vrlw       v0,v0,v1
		add        r23,r23,r0
		vadduwm    v0,v0,v4
		rotlw      r23,r23,r0
		vadduwm    v5,v5,v4
		add        r19,r19,r17
		vadduwm    v5,v5,v30
		lvx        v3,r10,r6
		vrlw       v5,v5,v28
		add        r28,r19,r28
		vadduwm    v27,v5,v30
		add        r28,r28,r20
		vadduwm    v31,v27,v31
		rotlwi     r28,r28,3
		vrlw       v31,v31,v27
		stw        r28,336(r1)
		vxor       v1,v1,v0
		add        r29,r19,r29
		vrlw       v1,v1,v0
		add        r29,r29,r21
		vadduwm    v1,v1,v5
		rotlwi     r29,r29,3
		vadduwm    v6,v6,v5
		stw        r29,340(r1)
		vadduwm    v6,v6,v31
		add        r30,r19,r30
		vrlw       v6,v6,v28
		add        r30,r30,r22
		vadduwm    v27,v6,v31
		rotlwi     r30,r30,3
		vadduwm    v30,v27,v30
		stw        r30,344(r1)
		vrlw       v30,v30,v27
		add        r31,r19,r31
		vxor       v0,v0,v1
		add        r31,r31,r23
		vrlw       v0,v0,v1
		rotlwi     r31,r31,3
		vadduwm    v0,v0,v6
		stw        r31,348(r1)
		vadduwm    v7,v7,v6
		add        r0,r28,r20
		vadduwm    v7,v7,v30
		add        r24,r24,r0
		vrlw       v7,v7,v28
		rotlw      r24,r24,r0
		vadduwm    v27,v7,v30
		vadduwm    v31,v27,v31
		add        r0,r29,r21
		vrlw       v31,v31,v27
		add        r25,r25,r0
		vxor       v1,v1,v0
		rotlw      r25,r25,r0
		vrlw       v1,v1,v0
		add        r0,r30,r22
		vadduwm    v1,v1,v7
		addi       r18,r18,4
		vadduwm    v8,v8,v7
		stw        r18,32(r1)
		vadduwm    v8,v8,v31
		add        r26,r26,r0
		vrlw       v8,v8,v28
		rotlw      r26,r26,r0
		vadduwm    v27,v8,v31
		add        r0,r31,r23
		vadduwm    v30,v27,v30
		add        r27,r27,r0
		vrlw       v30,v30,v27
		rotlw      r27,r27,r0
		vxor       v0,v0,v1
		vrlw       v0,v0,v1
		add        r19,r19,r17
		vadduwm    v0,v0,v8
		add        r28,r19,r28
		vadduwm    v9,v9,v8
		add        r28,r28,r24
		vadduwm    v9,v9,v30
		rotlwi     r28,r28,3
		vrlw       v9,v9,v28
		stw        r28,352(r1)
		vadduwm    v27,v9,v30
		add        r29,r19,r29
		vadduwm    v31,v27,v31
		add        r29,r29,r25
		vrlw       v31,v31,v27
		rotlwi     r29,r29,3
		vxor       v1,v1,v0
		stw        r29,356(r1)
		vrlw       v1,v1,v0
		add        r30,r19,r30
		vadduwm    v1,v1,v9
		add        r30,r30,r26
		vadduwm    v10,v10,v9
		rotlwi     r30,r30,3
		vadduwm    v10,v10,v31
		stw        r30,360(r1)
		vrlw       v10,v10,v28
		add        r31,r19,r31
		vadduwm    v27,v10,v31
		add        r31,r31,r27
		vadduwm    v30,v27,v30
		rotlwi     r31,r31,3
		vrlw       v30,v30,v27
		stw        r31,364(r1)
		vxor       v0,v0,v1
		add        r0,r28,r24
		vrlw       v0,v0,v1
		add        r20,r20,r0
		vadduwm    v0,v0,v10
		rotlw      r20,r20,r0
		vadduwm    v11,v11,v10
		add        r0,r29,r25
		vadduwm    v11,v11,v30
		lvx        v4,r10,r7
		vrlw       v11,v11,v28
		add        r21,r21,r0
		vadduwm    v27,v11,v30
		rotlw      r21,r21,r0
		vadduwm    v31,v27,v31
		add        r0,r30,r26
		vrlw       v31,v31,v27
		add        r22,r22,r0
		vxor       v1,v1,v0
		rotlw      r22,r22,r0
		vrlw       v1,v1,v0
		lvx        v5,r10,r8
		vadduwm    v1,v1,v11
		add        r0,r31,r27
		vadduwm    v12,v12,v11
		add        r23,r23,r0
		vadduwm    v12,v12,v31
		rotlw      r23,r23,r0
		vrlw       v12,v12,v28
		add        r19,r19,r17
		vadduwm    v27,v12,v31
		add        r28,r19,r28
		vadduwm    v30,v27,v30
		add        r28,r28,r20
		vrlw       v30,v30,v27
		rotlwi     r28,r28,3
		vxor       v0,v0,v1
		stw        r28,368(r1)
		vrlw       v0,v0,v1
		add        r29,r19,r29
		vadduwm    v0,v0,v12
		add        r29,r29,r21
		vadduwm    v13,v13,v12
		rotlwi     r29,r29,3
		vadduwm    v13,v13,v30
		stw        r29,372(r1)
		vrlw       v13,v13,v28
		add        r30,r19,r30
		vadduwm    v27,v13,v30
		add        r30,r30,r22
		vadduwm    v31,v27,v31
		rotlwi     r30,r30,3
		vrlw       v31,v31,v27
		stw        r30,376(r1)
		vxor       v1,v1,v0
		add        r31,r19,r31
		vrlw       v1,v1,v0
		add        r31,r31,r23
		vadduwm    v1,v1,v13
		rotlwi     r31,r31,3
		vadduwm    v14,v14,v13
		stw        r31,380(r1)
		vadduwm    v14,v14,v31
		add        r0,r28,r20
		vrlw       v14,v14,v28
		add        r24,r24,r0
		vadduwm    v27,v14,v31
		rotlw      r24,r24,r0
		vadduwm    v30,v27,v30
		stw        r24,96(r1)
		vrlw       v30,v30,v27
		add        r0,r29,r21
		vxor       v0,v0,v1
		add        r25,r25,r0
		vrlw       v0,v0,v1
		rotlw      r25,r25,r0
		vadduwm    v0,v0,v14
		stw        r25,100(r1)
		vadduwm    v15,v15,v14
		add        r0,r30,r22
		vadduwm    v15,v15,v30
		add        r26,r26,r0
		vrlw       v15,v15,v28
		rotlw      r26,r26,r0
		vadduwm    v27,v15,v30
		stw        r26,104(r1)
		vadduwm    v31,v27,v31
		add        r0,r31,r23
		vrlw       v31,v31,v27
		add        r27,r27,r0
		vxor       v1,v1,v0
		rotlw      r27,r27,r0
		vrlw       v1,v1,v0
		stw        r27,108(r1)
		vadduwm    v1,v1,v15
		add        r19,r19,r17
		vadduwm    v16,v16,v15
		add        r28,r19,r28
		vadduwm    v16,v16,v31
		add        r28,r28,r24
		vrlw       v16,v16,v28
		rotlwi     r28,r28,3
		vadduwm    v27,v16,v31
		stw        r28,64(r1)
		vadduwm    v30,v27,v30
		add        r29,r19,r29
		vrlw       v30,v30,v27
		add        r29,r29,r25
		vxor       v0,v0,v1
		rotlwi     r29,r29,3
		vrlw       v0,v0,v1
		stw        r29,68(r1)
		vadduwm    v0,v0,v16
		add        r30,r19,r30
		vadduwm    v17,v17,v16
		add        r30,r30,r26
		vadduwm    v17,v17,v30
		rotlwi     r30,r30,3
		vrlw       v17,v17,v28
		stw        r30,72(r1)
		vadduwm    v27,v17,v30
		add        r31,r19,r31
		vadduwm    v31,v27,v31
		add        r31,r31,r27
		vrlw       v31,v31,v27
		rotlwi     r31,r31,3
		vxor       v1,v1,v0
		stw        r31,76(r1)
		vrlw       v1,v1,v0
		add        r0,r28,r24
		vadduwm    v1,v1,v17
		add        r20,r20,r0
		vadduwm    v18,v18,v17
		rotlw      r20,r20,r0
		vadduwm    v18,v18,v31
		stw        r20,80(r1)
		vrlw       v18,v18,v28
		add        r0,r29,r25
		vadduwm    v27,v18,v31
		add        r21,r21,r0
		vadduwm    v30,v27,v30
		rotlw      r21,r21,r0
		vrlw       v30,v30,v27
		stw        r21,84(r1)
		vxor       v0,v0,v1
		add        r0,r30,r26
		vrlw       v0,v0,v1
		add        r22,r22,r0
		vadduwm    v0,v0,v18
		rotlw      r22,r22,r0
		vadduwm    v19,v19,v18
		stw        r22,88(r1)
		vadduwm    v19,v19,v30
		add        r0,r31,r27
		vrlw       v19,v19,v28
		add        r23,r23,r0
		vadduwm    v27,v19,v30
		rotlw      r23,r23,r0
		vadduwm    v31,v27,v31
		stw        r23,92(r1)
		vrlw       v31,v31,v27
		lwbrx      r24,0,r7
		add        r24,r24,r14
		vxor       v1,v1,v0
		addis      r25,r24,256
		vrlw       v1,v1,v0
		addis      r26,r25,256
		vadduwm    v1,v1,v19
		addis      r27,r26,256
		vadduwm    v20,v20,v19
		vspltw     v19,v29,3
		vadduwm    v20,v20,v31
		lvx        v29,r9,r1
		vrlw       v20,v20,v28
		rotlw      r24,r24,r14
		vadduwm    v27,v20,v31
		rotlw      r25,r25,r14
		vadduwm    v30,v27,v30
		rotlw      r26,r26,r14
		vrlw       v30,v30,v27
		rotlw      r27,r27,r14
		vxor       v0,v0,v1
		add        r28,r15,r24
		vrlw       v0,v0,v1
		rotlwi     r28,r28,3
		vadduwm    v0,v0,v20
		stw        r28,192(r1)
		vadduwm    v21,v21,v20
		add        r29,r15,r25
		vadduwm    v21,v21,v30
		rotlwi     r29,r29,3
		vrlw       v21,v21,v28
		stw        r29,196(r1)
		vadduwm    v27,v21,v30
		add        r30,r15,r26
		vadduwm    v31,v27,v31
		rotlwi     r30,r30,3
		vrlw       v31,v31,v27
		stw        r30,200(r1)
		vxor       v1,v1,v0
		add        r31,r15,r27
		vrlw       v1,v1,v0
		rotlwi     r31,r31,3
		vadduwm    v1,v1,v21
		stw        r31,204(r1)
		vadduwm    v22,v22,v21
		add        r0,r28,r24
		vadduwm    v22,v22,v31
		add        r20,r13,r0
		vrlw       v22,v22,v28
		rotlw      r20,r20,r0
		vadduwm    v27,v22,v31
		add        r0,r29,r25
		vadduwm    v20,v27,v30
		lvx        v30,r5,r6
		vrlw       v20,v20,v27
		add        r21,r13,r0
		vxor       v0,v0,v1
		rotlw      r21,r21,r0
		vrlw       v0,v0,v1
		add        r0,r30,r26
		vadduwm    v0,v0,v22
		add        r22,r13,r0
		vadduwm    v23,v23,v22
		rotlw      r22,r22,r0
		vadduwm    v23,v23,v20
		add        r0,r31,r27
		vrlw       v23,v23,v28
		add        r23,r13,r0
		vadduwm    v27,v23,v20
		rotlw      r23,r23,r0
		vadduwm    v21,v27,v31
		lvx        v31,r5,r7
		vrlw       v21,v21,v27
		vxor       v1,v1,v0
		vrlw       v1,v1,v0
		vadduwm    v1,v1,v23
		vadduwm    v24,v24,v23
		lvx        v14,r5,r1
		vadduwm    v24,v24,v21
		vrlw       v24,v24,v28
		vxor       v0,v0,v1
		vrlw       v0,v0,v1
		vadduwm    v0,v0,v24
		vcmpequw.  v22,v0,v19
		vspltw     v15,v29,0
		vadduwm    v15,v15,v14
		vadduwm    v15,v15,v30
		vrlw       v15,v15,v28
		vadduwm    v27,v15,v30
		vadduwm    v31,v31,v27
		vrlw       v31,v31,v27
		vspltw     v16,v29,1
		bdnzt      26,loop		;; bdnzt      cr6_EQ,.-3464
		mfctr      r19
		beq        cr6,done
		vadduwm    v27,v24,v21
		vadduwm    v20,v27,v20
		vrlw       v20,v20,v27
		vadduwm    v25,v25,v24
		vadduwm    v25,v25,v20
		vrlw       v25,v25,v28
		vxor       v1,v1,v0
		vrlw       v1,v1,v0
		vadduwm    v1,v1,v25
		lvx        v19,0,r7
		vspltw     v19,v19,1
		vcmpequw   v27,v1,v19
		vand       v22,v22,v27
		vspltisw   v27,-1
		vcmpequw.  v27,v27,v22
		bne        cr6,found
		cmplwi     r19,0
		bne        loop
done:
		lwz        r13,48(r1)
		subi       r18,r18,5
		addic      r18,r18,1
		addze      r13,r13
		neg        r0,r4
		clrrwi.    r19,r0,2
		bne        start
		subfc      r18,r0,r18
		addme      r13,r13
		li         r4,0
		b          exit
found:
		subi       r18,r18,4
		lwz        r13,48(r1)
		vspltisw   v1,0
		slwi       r19,r19,2
		add        r4,r4,r19
shift_out:
		subi       r18,r18,1
		addi       r4,r4,1
		vsldoi     v22,v1,v22,0xC
		vcmpequw.  v27,v22,v1
		bge        cr6,shift_out
exit:	
		li         r0,384
		lvx        v20,r1,r0
		li         r0,400
		lvx        v21,r1,r0
		li         r0,416
		lvx        v22,r1,r0
		li         r0,432
		lvx        v23,r1,r0
		li         r0,448
		lvx        v24,r1,r0
		li         r0,464
		lvx        v25,r1,r0
		li         r0,480
		lvx        v26,r1,r0
		li         r0,496
		lvx        v27,r1,r0
		li         r0,512
		lvx        v28,r1,r0
		li         r0,528
		lvx        v29,r1,r0
		li         r0,544
		lvx        v30,r1,r0
		li         r0,560
		lvx        v31,r1,r0
		lwz        r1,0(r1)
		lwz        r3,24(r1)
		li         r5,16
		stwbrx     r18,r5,r3
		li         r5,20
		stwbrx     r13,r5,r3
		lwz        r3,28(r1)
		subf       r3,r4,r3
		lwz        r0,-80(r1)
		mtspr      256,r0
		lwz        r0,8(r1)
		mtlr       r0
		lmw        r13,-76(r1)
		blr
