#! /usr/bin/perl -w

# generate ogr_dat2.cpp for OGROPT_NEW_CHOOSEDAT

# $Id: choosedat.pl,v 1.1.2.4 2001/03/19 16:51:13 andreasb Exp $


sub usage
{
  print "Usage: $0 infile outfile\n";
  exit(1);
}

sub bitmap
{
  my $bmp = shift;
  my $bits = shift;
  my $ret = "";
  for my $i (1..$bits) {
    $ret = (($bmp & 1) ? '1' : '0') . $ret;
    $bmp >>= 1;
  }
    
  return $ret;
}

$inf = $ARGV[0] or usage;
$outf = $ARGV[1] or usage;
$name = ogr_choose_dat2;
open(INF, $inf) or die "Could not open $inf: $!";
binmode INF;
open(OUTF, ">$outf") or die "Could not create $outf: $!";

$n = read INF, $buf, 3;
$choose_version   = unpack("c", substr($buf, 0, 1)) & 0xff;
$choose_max_marks = unpack("c", substr($buf, 1, 1)) & 0xff;
$choose_dist_bits = unpack("c", substr($buf, 2, 1)) & 0xff;
$choose_alignment = $choose_max_marks < 16 ? 16 : $choose_max_marks;
$choose_max_depth = $choose_max_marks - 1;

print OUTF 
"/*
 * static choose table used by ogr core(s).
 *
 */                                                                                                                    

const char *ogr_dat_cpp(void) {
return ".'"@(#)$'."Id: ${outf} 0.0.0.0 0000/00/00 00:00:00 uncommitted Exp ".'$'."\"; }

#include \"ogr.h\"

const int choose_version   = ${choose_version};
const int choose_dist_bits = ${choose_dist_bits};
const int choose_max_depth = ${choose_max_depth};
const int choose_alignment = ${choose_alignment};

const unsigned char ${name}[] = {\n";

#$format = "0x%02X";
$format = "%4d";
$bmpi = 0;
while ($n = read INF, $buf, $choose_max_marks) {
  printf OUTF "/* %s */ ", bitmap($bmpi++, $choose_dist_bits);
  for $i (0..$n-1) {
    print OUTF sprintf("${format},", unpack("c", substr($buf, $i, 1)) & 0xff);
  }
  for $i ($n..$choose_alignment-1) {
    print OUTF sprintf("${format},", 0);
  }
  print OUTF "\n";
}

print OUTF "};\n";

close(INF);
close(OUTF);
