// ogrtest -- 

// $Id: runstub.cpp,v 1.1.2.3 2001/03/19 16:51:14 andreasb Exp $

#include "baseincs.h"
#define OGR_CORE_INTERNAL_STRUCTURES
#include "ogr.h"

#define NODESPERRUN 1000000
#define RAISE_BGR 0

extern "C" CoreDispatchTable* ogr_get_dispatch_table();
extern int BGR[];

static void usage()
{
  fprintf(stderr, "Usage:  runstub marks diff1 diff2 ... \n"
          "Example:  to test with stub 24/1-12-7-25-3 you would use this command line:\n"
          "\trunstub 24 1 12 7 25 3\n");
}

WorkStub ws;
State st;
CoreDispatchTable *dispatch = ogr_get_dispatch_table();

int loadstub(int argc, char** argv)
{
  int argnum = 1;

  if (argc < 2)
    return -1;

  ws.stub.marks = atoi(argv[argnum++]);
  ws.stub.length = 0;
  ws.worklength = 0;

  if (argc < 2+ws.stub.length)
    return -1;

  for (int i = 0; i < STUB_MAX && argnum < argc; i++)
  {
    ws.stub.diffs[ws.stub.length++] = atoi(argv[argnum++]);
  }

  printf("Loaded: %d/", ws.stub.marks);
  for (u32 i = 0; i < ws.stub.length; i++)
    printf("%s%d", i?"-":"", ws.stub.diffs[i]);
  printf("\n");

  return 0;
}

void printstub(const State *state, char eol = '\n', int depth = -1)
{
  int len = 0;

  if (depth < 0)
    depth = state->depth;

  printf("%d(%d)/", state->maxmarks, depth);
  for (int i = 0; i < state->maxdepth && (i < depth || i < state->startdepth); ++i)
  {
    if (i == state->startdepth)
      printf("+");
    else if (i)
      printf("-");
    printf("%d", state->markpos[i+1] - state->markpos[i]);
    len += state->markpos[i+1] - state->markpos[i];
  }
  if (depth == state->startdepth)
    printf("+");
  if (depth < state->maxdepth)
    printf("...");
  printf(" = %d   %c",len,eol);
}

int main(int argc, char** argv)
{
  if (loadstub(argc, argv) != 0)
  {
    usage();
    return 1;
  }

  int res = dispatch->init();
  printf("ogr_init() = %d\n", res);

  for (int i = ws.stub.marks-1; i < 29; ++i)
    BGR[i] += RAISE_BGR;
  if (int r = dispatch->create(&ws, sizeof(ws), &st, sizeof(st)) != CORE_S_OK)
  {
    fprintf(stderr, "ERROR: ogr_create() = %d\n", r);
    return 2;
  }
  printstub(&st);

// ============================================================================    

  unsigned long long totalnodes = 0;
  int r;
  do {
    int nodes = NODESPERRUN;
    r = dispatch->cycle(&st, &nodes, 0);
    totalnodes += nodes;
    //printf("%d nodes = %d\n", r, nodes);
    printf("%Ld ", totalnodes); 
    printstub(&st, '\r');
    fflush(stdout);

    switch (r) {
      case CORE_S_OK :
          break;
      case CORE_S_CONTINUE :
          break;
      case CORE_S_SUCCESS :
          printstub(&st, '\n', st.depth+1);
          break;
    }
  } while (r == CORE_S_CONTINUE);

  printf("\nStub (%d)  ", r);
  printstub(&st);
  printf("Totalnodes %Ld %016LX\n", totalnodes, totalnodes);

// ============================================================================    



  return 0;
}
