#!/usr/bin/perl -w
# $Id: run_stublen.pl,v 1.1.2.2 2001/03/19 16:51:14 andreasb Exp $

chomp($hostname = `hostname`);
$logfile = "$hostname.log";
$proggie = "stublen";
$nice = 15;

### set these in stublen.cfg
$marks = 10;
$depth = 2;
$minsum = 0;
$maxdifflen = 255;

### now import stublen.cfg
do "stublen.cfg";

$start = 0;
$seed = -1;

open SEEDS, "seeds" or die "no 'seeds'\n";
while ( <SEEDS> ) {
  if ( /^${hostname} (\d+)$/ ) { $seed = $1; }
}
close SEEDS;
die "no seed\n" unless $seed >= 0;

$is_running = `pgrep -x $proggie`;
die "'$proggie' is active: PID $is_running\n" if ($is_running);

if (open LOGFILE, $logfile) {
  while ( <LOGFILE> ) {
    if ( /^$marks $depth $minsum $maxdifflen $seed\s*(\d+) : [0-9 ]* : \d+ : \d+$/ ) 
      { $start = $1+1 unless $start > $1 };
  }
  close LOGFILE;
}
$stop = $start+10000;

$cmd = "./$proggie $logfile $marks $depth $minsum $maxdifflen $seed $start $stop";
print "$cmd\n";
system "nice -$nice $cmd";
