// stubmap -- main

// $Id: stubmap.cpp,v 1.1.2.4 2001/03/19 16:51:14 andreasb Exp $

#include "baseincs.h"
#define OGR_CORE_INTERNAL_STRUCTURES
#include "ogr.h"

#define NODESPERRUN 10000

extern "C" CoreDispatchTable* ogr_get_dispatch_table_callback();

static void usage(const char* argv0)
{
  fprintf(stderr, "Usage:  %s marks depth [diff1 diff2 ... diffN] \n"
          "\t(depth > N)\n", argv0);
}

WorkStub ws;
State st;
CoreDispatchTable *dispatch = ogr_get_dispatch_table_callback();

extern int ogr_callback_depth;
int ogr_callback_depth = 42;
extern long long int ogr_stubcount;
long long int ogr_stubcount = 0;

int loadstub(int argc, char** argv)
{
  int argnum = 1;

  if (argc < 3)
    return -1;

  ws.stub.marks = atoi(argv[argnum++]);
  ws.stub.length = 0;
  ws.worklength = 0;

  ogr_callback_depth = atoi(argv[argnum++]);
  
  for (int i = 0; i < STUB_MAX && argnum < argc; i++)
  {
    ws.stub.diffs[ws.stub.length++] = atoi(argv[argnum++]);
  }
  
  if (ogr_callback_depth <= ws.stub.length) {
    fprintf(stderr, "Depth too low/too much diffs - this makes no sense!\n");
    return 1;
  }

  printf("Loaded: %d/", ws.stub.marks);
  for (u32 i = 0; i < ws.stub.length; i++)
    printf("%s%d", i?"-":"", ws.stub.diffs[i]);
  printf("\ngenerating stubs of depth %d\n", ogr_callback_depth);
  return 0;
}

void printstub(const State *state, char eol = '\n', int depth = -1)
{
  int len = 0;

  if (depth < 0)
    depth = state->depth;

  printf("%d(%d)/", state->maxmarks, depth);
  for (int i = 0; i < state->maxdepth && (i < depth || i < state->startdepth); ++i)
  {
    if (i == state->startdepth)
      printf("+");
    else if (i)
      printf("-");
    printf("%d", state->markpos[i+1] - state->markpos[i]);
    len += state->markpos[i+1] - state->markpos[i];
  }
  printf("     %c",eol);
}

int main(int argc, char** argv)
{
  if (loadstub(argc, argv) != 0)
  {
    usage(argv[0]);
    return 1;
  }

  int res = dispatch->init();
//  printf("ogr_init() = %d\n", res);
  res = res;

  if (int r = dispatch->create(&ws, sizeof(ws), &st, sizeof(st)) != CORE_S_OK)
  {
    fprintf(stderr, "ERROR: ogr_create() = %d\n", r);
    return 2;
  }
//  printstub(&st);

// ============================================================================    

  unsigned long long totalnodes = 0;
  int r;
  do {
    int nodes = NODESPERRUN;
    r = dispatch->cycle(&st, &nodes, 0);
    totalnodes += nodes;
//    printf("%Ld ", ogr_stubcount); 
//    printstub(&st, '\r');
    fflush(stdout);

    switch (r) {
      case CORE_S_OK :
          break;
      case CORE_S_CONTINUE :
          break;
      case CORE_S_SUCCESS :
          printf("SUCCESS: ");
          printstub(&st, '\n', st.depth+1);
          break;
    }
  } while (r == CORE_S_CONTINUE);

//  printf("\nStub (%d)  ", r);
//  printstub(&st);
//  printf("Total nodes %Ld %016LX\n", totalnodes, totalnodes);
  printf("Total stubs %Ld %016LX\n", ogr_stubcount, ogr_stubcount);

// ============================================================================    



  return 0;
}
