$!==============================================================================
$!
$!  Program:  make-vms.com
$!  Created:  06/19/97
$!  Author:   David Sowder (davids@cosmic.swau.edu)
$!
$!  Program Summary: A "make" for RC5 on VMS
$!
$!  Modifications:
$!    xx/xx/xx      Who            Description of Change
$!    12/14/97      David Sowder   Added menu for compile and link options
$!
$!==============================================================================
$!
$ CYCLECNTRL :== ""
$ IF P1 .EQS. "MAKEALL" THEN CYCLECNTRL :== "0"
$ IF P1 .NES. "MAKEALL" THEN GOTO NORMALOPS
$!
$ CYCLETOP:
$!
$ IF CYCLECNTRL .EQS. "6" THEN GOTO SUPERDONE
$ IF CYCLECNTRL .EQS. "5" THEN CYCLECNTRL :== "6"
$ IF CYCLECNTRL .EQS. "4" THEN CYCLECNTRL :== "5"
$ IF CYCLECNTRL .EQS. "3" THEN CYCLECNTRL :== "4"
$ IF CYCLECNTRL .EQS. "2" THEN CYCLECNTRL :== "3"
$ IF CYCLECNTRL .EQS. "1" THEN CYCLECNTRL :== "2"
$ IF CYCLECNTRL .EQS. "0" THEN CYCLECNTRL :== "1"
$!
$ LNK :== "BOTH"
$ IF CYCLECNTRL .EQS. "1" THEN NET :== "MULTINET"
$ IF CYCLECNTRL .EQS. "1" THEN NETNAM :== "MULTINET"
$ IF CYCLECNTRL .EQS. "1" THEN PROCOP :== "EV4"
$ IF CYCLECNTRL .EQS. "2" THEN NET :== "MULTINET"
$ IF CYCLECNTRL .EQS. "2" THEN NETNAM :== "MULTINET"
$ IF CYCLECNTRL .EQS. "2" THEN PROCOP :== "EV5"
$ IF CYCLECNTRL .EQS. "3" THEN NET :== "__VMS_UCX__"
$ IF CYCLECNTRL .EQS. "3" THEN NETNAM :== "UCX"
$ IF CYCLECNTRL .EQS. "3" THEN PROCOP :== "EV4"
$ IF CYCLECNTRL .EQS. "4" THEN NET :== "__VMS_UCX__"
$ IF CYCLECNTRL .EQS. "4" THEN NETNAM :== "UCX"
$ IF CYCLECNTRL .EQS. "4" THEN PROCOP :== "EV5"
$! IF CYCLECNTRL .EQS. "5" THEN NET :== "NONETWORK"
$! IF CYCLECNTRL .EQS. "5" THEN NETNAM :== "NONET"
$! IF CYCLECNTRL .EQS. "5" THEN PROCOP :== "EV4"
$! IF CYCLECNTRL .EQS. "6" THEN NET :== "NONETWORK"
$! IF CYCLECNTRL .EQS. "6" THEN NETNAM :== "NONET"
$! IF CYCLECNTRL .EQS. "6" THEN PROCOP :== "EV5"
$ GOTO COMPILE
$!
$ NORMALOPS:
$ NET :== ""
$ NETNAM :== ""
$ PROCOP :== ""
$ LNK :== ""
$!
$ DEFINE/NOLOG/USER SYS$INPUT TT:
$ WRITE SYS$OUTPUT "1 - Multinet"
$ WRITE SYS$OUTPUT "2 - UCX"
$! WRITE SYS$OUTPUT "3 - No Network"
$ WRITE SYS$OUTPUT ""
$ READ/PROMPT="Enter desired network option: " SYS$COMMAND CMD
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT ""
$ IF CMD .EQ. 1 THEN NET :== "MULTINET"
$ IF CMD .EQ. 1 THEN NETNAM :== "MULTINET"
$ IF CMD .EQ. 2 THEN NET :== "__VMS_UCX__"
$ IF CMD .EQ. 2 THEN NETNAM :== "UCX"
$! IF CMD .EQ. 3 THEN NET :== "NONETWORK"
$! IF CMD .EQ. 3 THEN NETNAM :== "NONET"
$ IF NET .EQS. "" THEN GOTO QUIT
$!
$ DEFINE/NOLOG/USER SYS$INPUT TT:
$ WRITE SYS$OUTPUT "1 - EV4"
$ WRITE SYS$OUTPUT "2 - EV5"
$ WRITE SYS$OUTPUT "3 - Current Host"
$ WRITE SYS$OUTPUT ""
$ READ/PROMPT="Enter desired processor option: " SYS$COMMAND CMD
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT ""
$ IF CMD .EQ. 1 THEN PROCOP :== "EV4"
$ IF CMD .EQ. 2 THEN PROCOP :== "EV5"
$ IF CMD .EQ. 3 THEN PROCOP :== "HOST"
$ IF PROCOP .EQS. "" THEN GOTO QUIT
$!
$ DEFINE/NOLOG/USER SYS$INPUT TT:
$ WRITE SYS$OUTPUT "1 - Make Executable"
$ WRITE SYS$OUTPUT "2 - Make Library"
$ WRITE SYS$OUTPUT "3 - Make Both"
$ WRITE SYS$OUTPUT ""
$ READ/PROMPT="Enter desired link option: " SYS$COMMAND CMD
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT ""
$ IF CMD .EQ. 1 THEN LNK :== "EXEC"
$ IF CMD .EQ. 2 THEN LNK :== "LIB"
$ IF CMD .EQ. 3 THEN LNK :== "BOTH"
$ IF LNK .EQS. "" THEN GOTO QUIT
$ GOTO COMPILE
$!
$ QUIT:
$ WRITE SYS$OUTPUT "Compile terminated abnormally."
$ DONE:
$ IF CYCLECNTRL .NES. "" THEN GOTO CYCLETOP
$ SUPERDONE:
$ EXIT
$!
$ COMPILE:
$! Some versions of DEC C++ older than 5.0 may not support the TUNE
$! optimization option.  Remove the TUNE='PROCOP' portion from the
$! /OPTIMIZE= switch if you experience difficulties.
$!
$ MU SHOW/VER
$ CXX/STANDARD=MS/VERSION/NOOBJECT NL:
$ Write sys$output "Compiling..."
$ IF F$GETSYI( "ARCH_NAME" ) .NES. "Alpha" THEN GOTO NOT_ALPHA_COMPILE
$ CXX/STANDARD=MS/PREFIX=ALL/DEBUG=NONE/DEFINE='NET' -
	/OPTIMIZE=(LEVEL=4,UNROLL=50,TUNE='PROCOP') -
	CLIENT.CPP,INIREAD.CPP
$ CXX/STANDARD=MS/PREFIX=ALL/DEBUG=NONE/DEFINE='NET' -
	/OPTIMIZE=(LEVEL=4,INLINE=ALL,UNROLL=50,TUNE='PROCOP') -
	CLICONFIG.CPP,PROBLEM.CPP,AUTOBUFF.CPP,NETWORK.CPP,SCRAM.CPP, -
	BUFFWORK.CPP,MAIL.CPP
$ GOTO LINK
$ NOT_ALPHA_COMPILE:
$! If we're still executing here, it's assumed the architecture is VAX
$! VAX architecture not currently supported
$! CC/DECC -
$!	/NOOPTIMIZE -
$!	CLIENT
$! CC/DECC -
$!	/OPTIMIZE=(DISJOINT,INLINE) -
$!	COMMON,CLIOPS
$!
$ LINK:
$ Write sys$output "Linking..."
$ IF LNK .EQS. "BOTH" THEN GOTO MAKE_LIBRARY
$ IF LNK .EQS. "LIB" THEN GOTO MAKE_LIBRARY
$ LINKPASSTWOTOP:
$ IF NET .EQS. "MULTINET" THEN GOTO LINK_MULTINET
$ IF NET .EQS. "__VMS_UCX__" THEN GOTO LINK_UCX
$ IF NET .EQS. "NONETWORK" THEN GOTO LINK_NONETWORK
$ GOTO QUIT
$!
$ MAKE_LIBRARY:
$ LIBRARY/CREATE RC5DES-'PROCOP'-'NETNAM'
$ LIBRARY/OBJECT/INSERT RC5DES-'PROCOP'-'NETNAM' PROBLEM.OBJ,CLICONFIG.OBJ, -
	CLIENT.OBJ,AUTOBUFF.OBJ,INIREAD.OBJ,NETWORK.OBJ,SCRAM.OBJ, -
	BUFFWORK.OBJ,MAIL.OBJ
$ PURGE RC5*.OBJ
$ PURGE RC5DES*.OLB
$ IF LNK .EQS. "BOTH" THEN GOTO LINKPASSTWOTOP
$ GOTO DONE
$!
$ LINK_UCX:
$ LINK_NONETWORK:
$ LINK/NOTRACEBACK/EXECUTABLE=RC5DES-'PROCOP'-'NETNAM' -
  	PROBLEM,CLICONFIG,CLIENT,AUTOBUFF,INIREAD,NETWORK,SCRAM,BUFFWORK,MAIL
$ GOTO DONE
$!
$ LINK_MULTINET:
$ LINK/NOTRACEBACK/EXECUTABLE=RC5DES-'PROCOP'-'NETNAM' -
  	PROBLEM,CLICONFIG,CLIENT,AUTOBUFF,INIREAD,NETWORK,SCRAM,BUFFWORK,MAIL, -
	MULTINET.OPT/OPT
$ GOTO DONE

