#include "myclient.h"

MyClient::MyClient(HWND hwnd)
	{
	srand( time( NULL ) );
	InitRandom();

	MainClient = this;
	hwndClient = hwnd;    /* Get handle of parent */
	hwndMenu = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT),
													FID_MENU);
//   percent[0] = 0;
   strcpy(statustext, "RC5/DES Ready to crack!");
	percentbar = 0;
	
   ScreenIndex = 0;
	ScreenPtr = ScreenBuffer[ScreenIndex];
	
   /* Queue up screen output */
	DosCreateQueue(&hqScreenQue, QUE_FIFO | QUE_CONVERT_ADDRESS,
						SCREENQUENAME);

   /* Gets the minor version of OS2 */
	DosQuerySysInfo(QSV_VERSION_MINOR, QSV_VERSION_MINOR, (PVOID)&OS2_Version,
						 sizeof(OS2_Version));
	
	}

/****************************************************************************/
MyClient::~MyClient()
	{
	DosCloseQueue(hqScreenQue);
	MainClient = NULL;
	}

void MyClient :: PrintBanner()
      {
		  Client::PrintBanner(argv[0]);
        LogScreen("OS/2 PM Modifications by Oscar Chang\n");
      }

void MyClient::DrawPercentage(s32 percent, s32 cpu)
	{
	HPS      hps;
	int      len, barwidth;
	char     buffer[10];
   POINTL   ptl;
	int      xtext, ytext;
	// Save percentage
	percentbar = percent;
	
   // Precalc some variable
	xtext = (WindowWidth - windowXMargin) / 2;
	ytext = percentHeight / 2 - 2;

	hps = WinGetPS(hwndClient);

	// most used calculation
	barwidth = WindowWidth - windowXMargin - 2;

	// Move to lower left of percent bar
	ptl.x = windowXMargin+2;
	ptl.y = windowYMargin+1;
	GpiMove(hps, &ptl);

	// Fill in percent done - x wise
	ptl.x += ((barwidth + 1) * percent) / 100;
	if(ptl.x > barwidth)
		ptl.x = barwidth;
	ptl.y = percentHeight - 2;

	GpiSetColor(hps, CLR_DARKGRAY);
	GpiBox(hps, DRO_OUTLINEFILL, &ptl, 0L, 0L);

	// fill percent not done
	if(percent != 100)
		{
		GpiMove(hps, &ptl);           // move to where bar stopped
		ptl.x = barwidth;
		ptl.y = windowYMargin+1;
		GpiSetColor(hps, CLR_PALEGRAY);
		GpiBox(hps, DRO_OUTLINEFILL, &ptl, 0L, 0L);  // Fill in left over
		}

	ptl.x = xtext;
	ptl.y = ytext;
   if(cpu == 0)
		len = sprintf(buffer, "%d%c", percentbar, '%');
	else
		len = sprintf(buffer, "%c%d%c", 'A'+ cpu, percentbar, '%');
	
	GpiSetColor(hps, CLR_BLACK);
	GpiCharStringAt(hps, &ptl, len, buffer);

	WinReleasePS(hps);
	//    if ( ( p % 10 ) == 0 ) LogScreenf( "%d%%", p );
	//  if (restarted) LogScreen( "R" );
	//  fflush( stdout );
   }

void MyClient::LogScreenPercentSingle(u32 percent, u32 lastpercent, bool restarted)
{
  for ( u32 p = lastpercent + 1 ; p < percent + 1 ; p++ )
  {
  if ( ( p % 2 ) == 0 )
	  DrawPercentage(percent, 0);    // only one CPU
//    if ( ( p % 10 ) == 0 ) LogScreenf( "%d%%", p );
  }
  if (restarted) LogScreen( "R" );
//  fflush( stdout );
}

/***************/
/* Config Menu */
/***************/
/*****************************
	Configure window
	hwnd = OS2 Window handle
	Note: Bovine Code
******************************/
s32 MyClient :: Configure()
	{
	changed = 0;

	WinDlgBox(HWND_DESKTOP, hwndClient, ConfigDlgProc, NULLHANDLE,
				 DID_NOTEBOOK, NULL);

	ValidateConfig();
	
	if(changed == 1)
		return 1;
	else
		return 0;
	};

/****************************************************************************/
static MRESULT EXPENTRY MyClient :: ConfigDlgProc(HWND hwnd, ULONG msg,
																  MPARAM mp1, MPARAM mp2)
	{
   INT i, j;
	CHAR Text[MAX_ENTRYTEXT];
	HWND hwndEntry;
   char szFont[] = "8.Helv";

	static HWND     hwndNotebook, hwndtmp;
	static ULONG    ulNBStyle;

	const int NumNBPages = 7;
	enum PageIDs {pgEmail=0, pgBlock, pgNetwork, pgSystem, pgMessage,
		pgOS2Options};
	NBPAGE         nbPage[NumNBPages] =
		// Email Page
		{EmailDlgProc, NULLHANDLE, 0, "E-Mail Address", "E-Mail", DID_EMAIL, 0,
		// Block Page
		BlockDlgProc, NULLHANDLE, 0, "Block Configuration", "Block", DID_BLOCK_CONFIG, 0,
		// Network Page
		NetworkDlgProc, NULLHANDLE, 0, "Network Settings", "Network", DID_NETWORK, 0,
		// Systems Page
		SystemDlgProc, NULLHANDLE, 0, "System Settings", "System", DID_SYSTEM, 0,
		// Message Page
		MessageDlgProc, NULLHANDLE, 0, "Message Settings", "Message", DID_MAIL_CONFIG, 0,
		// Options Page
		OptionsDlgProc, NULLHANDLE, 0, "Options", "Options", DID_OPTIONS, 0,
		// OS2 Options Page
		OS2OptionsDlgProc, NULLHANDLE, 0, "OS/2 Options", "OS/2 Options", DID_OS2_OPTIONS, 0
		};

	RECTL          winRect, buttonRect;
	USHORT         nbWidth, nbHeight;
	static USHORT  xoffset, yoffset;

	switch(msg)
		{
		case WM_INITDLG:
		   /* Get window size */
			WinQueryWindowRect(hwnd, &winRect);
			WinQueryWindowRect(WinWindowFromID(hwnd, DID_OK), &buttonRect);

			ulNBStyle = WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_VISIBLE;
			if(MainClient->OS2_Version >= WARP_40)      /* Warp 4 or higher */
				{
				ulNBStyle |= (BKS_TABBEDDIALOG | BKS_MAJORTABTOP |
								  BKS_BACKPAGESTR | BKS_STATUSTEXTRIGHT |
								  BKS_TABTEXTCENTER | BKS_POLYGONTABS);
				xoffset = -10;
				yoffset = -60;
				}
			else
				{
				ulNBStyle |= (BKS_SPIRALBIND | BKS_MAJORTABRIGHT |
								  BKS_BACKPAGESBR | BKS_STATUSTEXTCENTER |
								  BKS_TABTEXTRIGHT);
				xoffset = -15;
				yoffset = -75;
				}

			nbWidth = (winRect.xRight - winRect.xLeft) + xoffset;
			nbHeight = (winRect.yTop - winRect.yBottom) + yoffset;

			// Create notebook window
			hwndNotebook = WinCreateWindow(hwnd, WC_NOTEBOOK, NULL, ulNBStyle,
													 5,
													 30,
													 nbWidth,
													 nbHeight,
													 hwnd,
													 HWND_TOP,
													 ID_NOTEBOOK, NULL, NULL);

			WinSetPresParam(hwndNotebook, PP_FONTNAMESIZE,
								 strlen(szFont)+1, szFont);
			
			/* Notebook Setup */
			WinSendMsg(hwndNotebook, BKM_SETNOTEBOOKCOLORS,    /* Set bg color */
						  MPFROMLONG(SYSCLR_FIELDBACKGROUND),
						  MPFROMSHORT(BKA_BACKGROUNDPAGECOLORINDEX));

			/* Warp 3 Setup */
			if(MainClient->OS2_Version < WARP_40)
         // shouldn't do absolutes, but being lazy
			   WinSendMsg(hwndNotebook, BKM_SETDIMENSIONS, MPFROM2SHORT(95, 30),
							  MPFROMSHORT(BKA_MAJORTAB));

			for(i = 0; i < NumNBPages; i++)
				{
            // Loading Dialog Page
				nbPage[i].hwndNBPage =
					WinLoadDlg(hwndNotebook, hwndNotebook,
								  nbPage[i].pDialogWndProc, NULLHANDLE,
								  nbPage[i].ulIDDialogPage, NULL);

            // Adding Page to Notebook
				nbPage[i].ulIDPage =
					LONGFROMMR(WinSendMsg(hwndNotebook, BKM_INSERTPAGE, 0,
												 MPFROM2SHORT(BKA_MAJOR,BKA_LAST)));

				// Set Text into status line
				WinSendMsg(hwndNotebook, BKM_SETSTATUSLINETEXT,
							  MPFROMP(nbPage[i].ulIDPage),
							  MPFROMP(nbPage[i].pszStatusLine));
				
				// Setting tab
				WinSendMsg(hwndNotebook, BKM_SETTABTEXT,
							  MPFROMLONG(nbPage[i].ulIDPage),
							  MPFROMP(nbPage[i].pszTab));

				// Associate Page with dialog
				WinSendMsg(hwndNotebook, BKM_SETPAGEWINDOWHWND,
							  MPFROMP(nbPage[i].ulIDPage),
							  MPFROMLONG(nbPage[i].hwndNBPage));
				}

			WinShowWindow(hwndNotebook, TRUE);
		   break;
		case WM_COMMAND:
		   switch(COMMANDMSG(&msg)->cmd)
				{
				case ID_SAVE:
					MainClient->changed = 1; break;
				case ID_CANCEL:
					MainClient->changed = 0; break;
				}
         break;
		case WM_PAINT:
   		WinQueryWindowRect(hwnd, &winRect);
		   nbWidth = (winRect.xRight - winRect.xLeft) + xoffset;
			nbHeight = (winRect.yTop - winRect.yBottom) + yoffset;
			WinSetWindowPos(hwndNotebook, HWND_TOP, 0, 0, nbWidth, nbHeight,
								 SWP_SIZE);
			break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}

/****************************************************************************/
static MRESULT EXPENTRY MyClient :: EmailDlgProc(HWND hwnd, ULONG msg,
														  MPARAM mp1, MPARAM mp2)
	{
	HWND hwndEntry;
   char Text[MAX_ENTRYTEXT];
	
	switch(msg)
		{
		case WM_INITDLG:
	      /* Make the email entry longer */
         hwndEntry = WinWindowFromID(hwnd, ID_EMAIL);
   	   WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)64, (MPARAM)0);
   		if(MainClient->id[0])
				WinSetWindowText(hwndEntry, MainClient->id);
			break;
		case WM_DESTROY:
   		if(MainClient->changed == 1)     // If wanted to be saved
				{
//				hwndEntry = WinWindowFromID(hwnd, ID_EMAIL);
				MainClient->GetEntryFieldText(hwnd, ID_EMAIL, Text);
				strncpy( MainClient->id, Text, sizeof(MainClient->id) - 1 );
				}
		   break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}

/****************************************************************************/
static MRESULT EXPENTRY MyClient :: BlockDlgProc(HWND hwnd, ULONG msg,
														  MPARAM mp1, MPARAM mp2)
	{
	HWND hwndEntry;
   char Text[MAX_ENTRYTEXT];

	switch(msg)
		{
		case WM_INITDLG:
	      /* Make the block entries shorter */

		   /* Block in - RC5 */
		   hwndEntry = WinWindowFromID(hwnd, ID_BLOCKIN);
   	   WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)4, (MPARAM)0);

         itoa(MainClient->inthreshold[0], Text, 10);
			WinSetWindowText(hwndEntry, Text);

			/* Block in - DES */
		   hwndEntry = WinWindowFromID(hwnd, ID_BLOCKIN_DES);
   	   WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)4, (MPARAM)0);

         itoa(MainClient->inthreshold[1], Text, 10);
			WinSetWindowText(hwndEntry, Text);

         /* Block Out - RC5 */
			hwndEntry = WinWindowFromID(hwnd, ID_BLOCKOUT);
   	   WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)4, (MPARAM)0);

         itoa(MainClient->outthreshold[0], Text, 10);
			WinSetWindowText(hwndEntry, Text);

			/* Block Out - DES */
			hwndEntry = WinWindowFromID(hwnd, ID_BLOCKOUT_DES);
   	   WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)4, (MPARAM)0);

         itoa(MainClient->outthreshold[1], Text, 10);
			WinSetWindowText(hwndEntry, Text);

			// Block complete
			hwndEntry = WinWindowFromID(hwnd, ID_BLOCK_COMPLETE);

			itoa(MainClient->blockcount, Text, 10);
			WinSetWindowText(hwndEntry, Text);

			// Hourly runs
         hwndEntry = WinWindowFromID(hwnd, ID_HOURS_COMPLETE);
			WinSetWindowText(hwndEntry, MainClient->hours);
			break;

		case WM_DESTROY:
   		if(MainClient->changed == 1)     // If wanted to be saved
				{
				s32  inthreshold[2];
				s32  outthreshold[2];
				char threshold[2][64];

				// Block thresholds
				// RC5
				MainClient->GetEntryFieldText(hwnd, ID_BLOCKIN, Text);
				inthreshold[0]=atoi(Text);
            // DES
				MainClient->GetEntryFieldText(hwnd, ID_BLOCKIN_DES, Text);
				inthreshold[1]=atoi(Text);
				// RC5
				MainClient->GetEntryFieldText(hwnd, ID_BLOCKOUT, Text);
            outthreshold[0]=atoi(Text);
				// DES
				MainClient->GetEntryFieldText(hwnd, ID_BLOCKOUT_DES, Text);
            outthreshold[1]=atoi(Text);
				
				if ((inthreshold[0] != 0) || (outthreshold[0]) != 0) {
				if ( inthreshold[0] < 1   ) inthreshold[0] = 1;
				if ( inthreshold[0] > 1000 ) inthreshold[0] = 1000;
				if ( outthreshold[0] < 1   ) outthreshold[0] = 1;
				if ( outthreshold[0] > 1000 ) outthreshold[0] = 1000;
				MainClient->contestdone[0]=0;
				} else {
				MainClient->contestdone[0]=1;
				}
				sprintf(threshold[64*0],"%d:%d",
						  inthreshold[0],outthreshold[0]);

				if ((inthreshold[1] != 0) || (outthreshold[1]) != 0) {
				if ( inthreshold[1] < 1   ) inthreshold[1] = 1;
				if ( inthreshold[1] > 1000 ) inthreshold[1] = 1000;
				if ( outthreshold[1] < 1   ) outthreshold[1] = 1;
				if ( outthreshold[1] > 1000 ) outthreshold[1] = 1000;
				MainClient->contestdone[1]=0;
				} else {
				MainClient->contestdone[1]=1;
				}
				sprintf(threshold[64*1],"%d:%d",inthreshold[1],outthreshold[1]);

				MainClient->inthreshold[0] = inthreshold[0];
				MainClient->outthreshold[0] = outthreshold[0];
				MainClient->inthreshold[1] = inthreshold[1];
				MainClient->outthreshold[1] = outthreshold[1];

				// Block complete
				MainClient->GetEntryFieldText(hwnd, ID_BLOCK_COMPLETE, Text);
				MainClient->blockcount = atoi(Text);
				if (MainClient->blockcount < 0)
					MainClient->blockcount = 0;

				// Hourly runs
				MainClient->GetEntryFieldText(hwnd, ID_HOURS_COMPLETE, Text);
				MainClient->minutes = (s32) (60. * atol(Text));
				if ( MainClient->minutes < 0 ) MainClient->minutes = 0;
				strncpy( MainClient->hours, Text, sizeof(MainClient->hours) - 1 );
				break;
				}
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}
/****************************************************************************/
static MRESULT EXPENTRY MyClient :: NetworkDlgProc(HWND hwnd, ULONG msg,
														  MPARAM mp1, MPARAM mp2)
	{
	HWND  hwndEntry;
	char  Text[MAX_ENTRYTEXT];
	int   i, j;
	static CHAR *NetworkList[NUM_NETWORK_LIST] =
		{"I can communicate freely to the Internet on all ports",
		 "I can communicate freely on telnet ports",
		 "I can communicate freely on telnet ports, but need uuencoding",
		 "I have a local HTTP proxy that I can go through",
		 "Let me specify custom network settings (expert mode)"};

	switch(msg)
		{
		case WM_INITDLG:
   		/* Setup key proxy */
			hwndEntry = WinWindowFromID(hwnd, ID_PROXY);
			WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)64, (MPARAM)0);
			if(MainClient->httpproxy[0] != 0)
				WinSetWindowText(hwndEntry, MainClient->keyproxy);
			
			/* Setup key port */
			hwndEntry = WinWindowFromID(hwnd, ID_KEYPORT);
			WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)4, (MPARAM)0);
			itoa(MainClient->keyport, Text, 10);
			WinSetWindowText(hwndEntry, Text);

			/* Setup http proxy */
			/* Make http proxy longer */
			hwndEntry = WinWindowFromID(hwnd, ID_HTTP_PROXY);
			WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)64, (MPARAM)0);
			if(MainClient->httpproxy[0] != 0)
				WinSetWindowText(hwndEntry, MainClient->httpproxy);

			/* Setup http port */
			hwndEntry = WinWindowFromID(hwnd, ID_HTTPPORT);
			WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)4, (MPARAM)0);
			if(MainClient->httpport != 80)
				{
				itoa(MainClient->httpport, Text, 10);
				WinSetWindowText(hwndEntry, Text);
				}
			
			/* Fire Wall Mode */
			/* Set network mode */
			hwndEntry = WinWindowFromID(hwnd, ID_NETWORK);
			
			for(i = 0; i < NUM_NETWORK_LIST; i++)
				WinInsertLboxItem(hwndEntry, LIT_END, NetworkList[i]);

			WinSendDlgItemMsg(hwnd, ID_NETWORK, LM_SELECTITEM,
									MPFROMSHORT(MainClient->firemode-1),
									MPFROMSHORT(TRUE));

			MainClient->SetNetworkMode(hwnd, MainClient->firemode);
			break;
/****************************************************************************/
		case WM_COMMAND:
			switch(COMMANDMSG(&msg)->cmd)
				{
				case IDM_HTTP_PASS:
               SetPass(hwnd);
				}
   		return 0;   // needed instead of break so notebook doesn't disappear
/****************************************************************************/
		case WM_CONTROL:
		   switch(SHORT1FROMMP(mp1))
				{
				case ID_NETWORK:                 /* Update Network Dialog */
   				switch(SHORT2FROMMP(mp1))
						{
						case CBN_LBSELECT:
						   i = WinQueryLboxSelectedItem(HWNDFROMMP(mp2)) + 1;
						   MainClient->SetNetworkMode(hwnd, i);
                     MainClient->firemode = i;
							break;
						}
   				break;
				case ID_HTTPHEADER:
				   i = WinQueryButtonCheckstate(hwnd, ID_HTTPHEADER);
				   WinEnableWindow(WinWindowFromID(hwnd, ID_HTTPPORT), i);
					WinEnableWindow(WinWindowFromID(hwnd, ID_HTTP_PROXY), i);
               if(MainClient->uuehttpmode == MODE_SOCKS)
						WinEnableWindow(WinWindowFromID(hwnd, IDM_HTTP_PASS), i);
					break;
				case ID_SOCKS4:
				   i = WinQueryButtonCheckstate(hwnd, ID_SOCKS4);
				   if(i == TRUE)
						{
						SetPass(hwnd);
                  MainClient->uuehttpmode = MODE_SOCKS;
						MainClient->SetNetworkMode(hwnd, MainClient->firemode);
						}
				   break;
				}
   		break;
		case WM_DESTROY:
   		if(MainClient->changed == 1)
				{
				/* Fire Wall Mode */
				hwndEntry = WinWindowFromID(hwnd, ID_NETWORK);
				MainClient->firemode = WinQueryLboxSelectedItem(hwndEntry) + 1;
				
				/* Key Proxy */
				MainClient->GetEntryFieldText(hwnd, ID_PROXY, Text);
				strncpy( MainClient->keyproxy, Text, sizeof(MainClient->keyproxy) - 1 );

				/* Key port */
				MainClient->GetEntryFieldText(hwnd, ID_KEYPORT, Text);
				MainClient->keyport = atoi(Text);

				/* http proxy */
				MainClient->GetEntryFieldText(hwnd, ID_HTTP_PROXY, Text);
				strcpy(MainClient->httpproxy, Text);

				/* http port */
				MainClient->GetEntryFieldText(hwnd, ID_HTTPPORT, Text);
				MainClient->httpport = atoi(Text);

				/* save uuehttp mode */
				MainClient->uuehttpmode = 0;
				i = WinQueryButtonCheckstate(hwnd, ID_UUENCODING);
				if(i == TRUE)
					MainClient->uuehttpmode += 1;

				/* httpheader mode */
				i = WinQueryButtonCheckstate(hwnd, ID_HTTPHEADER);
				if(i == TRUE)
					MainClient->uuehttpmode += 2;

				/* SOCKS4 mode */
				i = WinQueryButtonCheckstate(hwnd, ID_SOCKS4);
				if(i == TRUE)
					MainClient->uuehttpmode = MODE_SOCKS;
				}
		break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}

/****************************************************************************/
static MRESULT EXPENTRY MyClient :: SystemDlgProc(HWND hwnd, ULONG msg,
														  MPARAM mp1, MPARAM mp2)
	{
	HWND hwndEntry;
   char Text[MAX_ENTRYTEXT];
   s32 i;
	
	static CHAR *PriorityList[NUM_PRIORITY_LIST] =
		{"(recomended) Very nice. Runs when nothing else is.",
       "Nice, runs with slightly higher priority than idle.",
		 "Normal. Same as other programs."};

	static CHAR *CPUList[NUM_CPU_LIST] =
		{"Autodetect",
		 "Intel Pentium, Intel Pentium MMX, Cyrix 5x86",
		 "Intel 80386, Intel 80486",
		 "Intel Pentium Pro, Intel Pentium II",
		 "AMD 486, Cyrix 6x86/6x86MX/M2",
		 "AMD K5" /*,
		 "AMD K6" */};    // K6 core taken out for now

	switch(msg)
		{
		case WM_INITDLG:
      	/* Set CPU mode */
			hwndEntry = WinWindowFromID(hwnd, ID_CPU);
			for(i = 0; i < NUM_CPU_LIST; i++)
				WinInsertLboxItem(hwndEntry, LIT_END, CPUList[i]);

			i = MainClient->cputype + 1;

			WinSendDlgItemMsg(hwnd, ID_CPU, LM_SELECTITEM,
									MPFROMSHORT(i), MPFROMSHORT(TRUE));

			/* Setup Niceness */
         hwndEntry = WinWindowFromID(hwnd, ID_PRIORITY);
			for(i = 0; i < NUM_PRIORITY_LIST; i++)
   			WinInsertLboxItem(hwndEntry, LIT_END, PriorityList[i]);

			WinSendMsg(hwndEntry, LM_SELECTITEM,
						  MPFROMSHORT(MainClient->niceness), MPFROMSHORT(TRUE));

			/* Setup Logname */
			hwndEntry = WinWindowFromID(hwnd, ID_LOGNAME);
			WinSendDlgItemMsg(hwnd, ID_LOGNAME, LM_SELECTITEM,
									MPFROMSHORT(128), MPFROMSHORT(TRUE));
			WinSetWindowText(hwndEntry, MainClient->logname);

			/* Setup Number of CPUs */
			hwndEntry = WinWindowFromID(hwnd, ID_NUM_CPU);
			WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)2, (MPARAM)0);

			itoa(MainClient->numcpu, Text, 10);
			WinSetWindowText(hwndEntry, Text);
			break;
		case WM_DESTROY:
   		if(MainClient->changed == 1)     // If wanted to be saved
				{
				/* Save CPU */
				hwndEntry = WinWindowFromID(hwnd, ID_CPU);
				MainClient->cputype = WinQueryLboxSelectedItem(hwndEntry) - 1;

				/* Niceness */
				hwndEntry = WinWindowFromID(hwnd, ID_PRIORITY);
				MainClient->niceness = WinQueryLboxSelectedItem(hwndEntry);

				/* Logname */
				MainClient->GetEntryFieldText(hwnd, ID_LOGNAME, Text);
				strcpy(MainClient->logname, Text);

				/* Save number of CPUs */
				MainClient->GetEntryFieldText(hwnd, ID_NUM_CPU, Text);
            MainClient->numcpu = atoi(Text);
				}
		   break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}
/****************************************************************************/
static MRESULT EXPENTRY MyClient :: MessageDlgProc(HWND hwnd, ULONG msg,
														  MPARAM mp1, MPARAM mp2)
	{
	HWND hwndEntry;
   char Text[MAX_ENTRYTEXT];
	
	switch(msg)
		{
		case WM_INITDLG:
		   if(MainClient->messagelen > 0)
				{
				// Configure stuff

				/* Setup message length */
				hwndEntry = WinWindowFromID(hwnd, ID_MAIL_MESG);
				WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)6, (MPARAM)0);
				itoa(MainClient->messagelen, Text, 10);
				WinSetWindowText(hwndEntry, Text);

				/* Setup SMTP server */
				hwndEntry = WinWindowFromID(hwnd, ID_SMTP_SERVER);
				WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)128, (MPARAM)0);
				WinSetWindowText(hwndEntry, MainClient->smtpsrvr);

				/* Setup SMTP port */
				hwndEntry = WinWindowFromID(hwnd, ID_SMTP_PORT);
				WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)4, (MPARAM)0);
            itoa(MainClient->smtpport, Text, 10);
				WinSetWindowText(hwndEntry, Text);

            /* Setup SMTP From */
				hwndEntry = WinWindowFromID(hwnd, ID_SMTP_FROM);
				WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)128, (MPARAM)0);
				WinSetWindowText(hwndEntry, MainClient->smtpfrom);

				/* Setup SMTP To */
				hwndEntry = WinWindowFromID(hwnd, ID_SMTP_TO);
				WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)128, (MPARAM)0);
				WinSetWindowText(hwndEntry, MainClient->smtpdest);
				}
         // else, there's nothing, all default values
		
		   break;
		case WM_DESTROY:
   		if(MainClient->changed == 1)     // If wanted to be saved
				{
				hwndEntry = WinWindowFromID(hwnd, ID_MAIL_MESG);
				MainClient->GetEntryFieldText(hwnd, ID_MAIL_MESG, Text);
				MainClient->messagelen = atoi(Text);
				if ( MainClient->messagelen < 0 ) MainClient->messagelen = 0;
				if ( MainClient->messagelen > MAXMAILSIZE)
					MainClient->messagelen = MAXMAILSIZE;
				if(MainClient->messagelen > 0)
					{
					/* Save SMTP server */
					MainClient->GetEntryFieldText(hwnd, ID_SMTP_SERVER, Text);
					strncpy( MainClient->smtpsrvr, Text,
							  sizeof(MainClient->smtpsrvr) - 1 );

					/* Save SMTP port */
					MainClient->GetEntryFieldText(hwnd, ID_SMTP_PORT, Text);
					MainClient->smtpport = atoi(Text);
					if ( MainClient->smtpport < 0 )
						MainClient->smtpport = 0;

					/* Save SMTP From */
					MainClient->GetEntryFieldText(hwnd, ID_SMTP_FROM, Text);
					strncpy( MainClient->smtpfrom, Text,
							  sizeof(MainClient->smtpfrom) - 1 );

					/* Save SMTP To */
					MainClient->GetEntryFieldText(hwnd, ID_SMTP_TO, Text);
					strncpy( MainClient->smtpdest, Text,
							  sizeof(MainClient->smtpdest) - 1 );

					}
				}
		   break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}
/****************************************************************************/
static MRESULT EXPENTRY MyClient :: GetProxyPassProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	HWND hwndEntry;
	char Username[MAX_ENTRYTEXT], Password[MAX_ENTRYTEXT];
	
	switch(msg)
		{
		case WM_INITDLG:
	      /* Make the username and password entry longer */
         hwndEntry = WinWindowFromID(hwnd, ID_PROXY_USER);
   	   WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)64, (MPARAM)0);

         hwndEntry = WinWindowFromID(hwnd, ID_PROXY_PASS);
   	   WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, (MPARAM)64, (MPARAM)0);
			break;
		case WM_COMMAND:
   		switch(COMMANDMSG(&msg)->cmd)
				{
				case ID_OK:
   				MainClient->GetEntryFieldText(hwnd, ID_PROXY_USER, Username);
   				if(MainClient->uuehttpmode == MODE_SOCKS)
						{
						strcpy(MainClient->httpid, Username);
						}
				   else if (Username[0] != 0)   // Not Blank
						{
						MainClient->GetEntryFieldText(hwnd, ID_PROXY_PASS, Password);
						strcpy(MainClient->httpid,
								 MainClient->base64_encode(Username, Password));
						}
					else
						MainClient->httpid[0] = 0; // Blank it
					
				   WinDismissDlg(hwnd,TRUE);
				   return 0;
				}
		   break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}

/****************************************************************************/
static MRESULT EXPENTRY MyClient :: OS2OptionsDlgProc(HWND hwnd, ULONG msg,
																		MPARAM mp1, MPARAM mp2)
	{
	HWND hwndEntry;

	switch(msg)
		{
		case WM_INITDLG:
   		/* Set auto start */
		   if(MainClient->autorun == 1)
				WinSendDlgItemMsg(hwnd, ID_STARTUP, BM_SETCHECK,
                              MPFROMSHORT(TRUE), MPFROMSHORT(0));

			/* Set auto minimize */
         if(MainClient->automin == 1)
				WinSendDlgItemMsg(hwnd, ID_MINIMIZE, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));
			break;
		case WM_DESTROY:
		   if(MainClient->changed == 1)
				{
				/* Save auto Run */
				MainClient->autorun =
					WinQueryButtonCheckstate(hwnd, ID_STARTUP);

				/* Save auto Minimize */
				MainClient->automin =
					WinQueryButtonCheckstate(hwnd, ID_MINIMIZE);
				}
   		break;
		}
		return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}

/****************************************************************************/
static MRESULT EXPENTRY MyClient :: OptionsDlgProc(HWND hwnd, ULONG msg,
														  MPARAM mp1, MPARAM mp2)
	{
	HWND hwndEntry;
   int i;
	char Text[MAX_ENTRYTEXT];
	static CHAR *ContestList[CONTEST_LIST] = {"RC5", "DES"};

	switch(msg)
		{
		case WM_INITDLG:
		   
		   /* turn on all the right checks */
         /* Run offline */
		   if(MainClient->offlinemode > 0)
				WinSendDlgItemMsg(hwnd, ID_RUNOFFLINE, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));
		   /* exit when no more buffers */
   		if(MainClient->offlinemode == 2)
				WinSendDlgItemMsg(hwnd, ID_RUNBUFFERS, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));
			/* exitrc5.now check */
			if(MainClient->noexitfilecheck != 0)
				WinSendDlgItemMsg(hwnd, ID_EXITFILECHECK, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));
			/* percent */
			if(MainClient->percentprintingoff != 0)
				WinSendDlgItemMsg(hwnd, ID_PERCENT, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));
			/* no disk buffers */
			if(MainClient->nodiskbuffers != 0)
				WinSendDlgItemMsg(hwnd, ID_NODISKBUFFERS, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));
			/* No Fall back */
			if(MainClient->nofallback != 0)
				WinSendDlgItemMsg(hwnd, ID_NOFALLBACK, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));
			/* Frequent */
			if(MainClient->connectoften != 0)
				WinSendDlgItemMsg(hwnd, ID_FREQUENT, BM_SETCHECK,
										MPFROMSHORT(TRUE), MPFROMSHORT(0));

			/* Checkpoint file name - RC5 */
			hwndEntry = WinWindowFromID(hwnd, ID_CHECKPOINT_FILE);
			WinSetWindowText(hwndEntry, MainClient->checkpoint_file[0]);

			/* Checkpoint file name - DES */
			hwndEntry = WinWindowFromID(hwnd, ID_CHECKPOINT_FILE_DES);
			WinSetWindowText(hwndEntry, MainClient->checkpoint_file[1]);

			/* Check point interval */
			hwndEntry = WinWindowFromID(hwnd, ID_CHECKPOINT_INT_VALUE);
			itoa(MainClient->checkpoint_min, Text, 10);
			WinSetWindowText(hwndEntry, Text);
			/* network timeout interval */
			hwndEntry = WinWindowFromID(hwnd, ID_NETWORKTIMEOUT_VAL);
			itoa(MainClient->nettimeout, Text, 10);
			WinSetWindowText(hwndEntry, Text);

			/* Perferred block size */
			hwndEntry = WinWindowFromID(hwnd, ID_BLOCK_SIZE);
			itoa(MainClient->preferred_blocksize, Text, 10);
			WinSetWindowText(hwndEntry, Text);

			/* Set Contests */
			hwndEntry = WinWindowFromID(hwnd, ID_CONTEST);
			
			for(i = 0; i < CONTEST_LIST; i++)
				WinInsertLboxItem(hwndEntry, LIT_END, ContestList[i]);

			WinSendDlgItemMsg(hwnd, ID_CONTEST, LM_SELECTITEM,
									MPFROMSHORT(MainClient->preferred_contest-1),
									MPFROMSHORT(TRUE));
			
			break;
		case WM_DESTROY:
   		if(MainClient->changed == 1)
				{
				/* Contest */
				hwndEntry = WinWindowFromID(hwnd, ID_CONTEST);
				MainClient->preferred_contest =
					WinQueryLboxSelectedItem(hwndEntry) + 1;

				/* Perferred block size */
				MainClient->GetEntryFieldText(hwnd,ID_BLOCK_SIZE, Text);
            MainClient->preferred_blocksize = atoi(Text);

				/* checkpoint file - RC5 */
				MainClient->GetEntryFieldText(hwnd, ID_CHECKPOINT_FILE, Text);
				if(Text[0] == 0)
					strcpy(MainClient->checkpoint_file[0], "none");
				else
					strncpy(MainClient->checkpoint_file[0], Text,
							  sizeof(MainClient->checkpoint_file));
				/* checkpoint file - DES */
				MainClient->GetEntryFieldText(hwnd, ID_CHECKPOINT_FILE_DES, Text);
				if(Text[0] == 0)
					strcpy(MainClient->checkpoint_file[1], "none");
				else
					strncpy(MainClient->checkpoint_file[1], Text,
							  sizeof(MainClient->checkpoint_file));
				/* checkpoint interval */
				MainClient->GetEntryFieldText(hwnd,ID_CHECKPOINT_INT_VALUE, Text);
				MainClient->checkpoint_min = atoi(Text);
				if(MainClient->checkpoint_min == 0)
					{
					strcpy(MainClient->checkpoint_file[0], "none");
					strcpy(MainClient->checkpoint_file[1], "none");
					}
				/* Save network timeout */
				MainClient->GetEntryFieldText(hwnd,ID_NETWORKTIMEOUT_VAL, Text);
				MainClient->nettimeout=atoi(Text);
				if(MainClient->nettimeout == 0)
					MainClient->nettimeout = NETTIMEOUT;
				/* Save Runoffline */
				MainClient->offlinemode =
					WinQueryButtonCheckstate(hwnd, ID_RUNOFFLINE);
				/* Save exit when buffer empty */
				if (WinQueryButtonCheckstate(hwnd, ID_RUNBUFFERS) == TRUE)
					MainClient->offlinemode = 2;
				/* Save exitrc5.now check */
				MainClient->noexitfilecheck =
					WinQueryButtonCheckstate(hwnd, ID_EXITFILECHECK);
				/* Save Percent */
				MainClient->percentprintingoff =
					WinQueryButtonCheckstate(hwnd, ID_PERCENT);
				/* Save no disk buffers */
				MainClient->nodiskbuffers =
					WinQueryButtonCheckstate(hwnd, ID_NODISKBUFFERS);
				/* Save no fallback */
				MainClient->nofallback =
					WinQueryButtonCheckstate(hwnd, ID_NOFALLBACK);
				/* Save frequent */
				MainClient->connectoften =
					WinQueryButtonCheckstate(hwnd, ID_FREQUENT);
				}
		   break;
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}

/****************************************************************************/
/*	static MRESULT EXPENTRY MyClient :: DlgProc(HWND hwnd, ULONG msg,
														  MPARAM mp1, MPARAM mp2)
	{
	switch(msg)
		{
		case WM_INITDLG:
		case WM_DESTROY:
		}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
	}
*/
/****************************************************************************/


/*****************
   StartThread()
******************/
void MyClient::StartThread(int Job)
	{
	int i;
	
	workThread.SetWork(Job);
   i = workThread.Start();
	if(Job == ClientRun)
		rc5pid = i;
	}


/*****************
	LogScreen()
******************/
virtual void MyClient :: LogScreen ( const char *text )
	{
	ScreenPtr = ScreenBuffer[ScreenIndex];
	// Advance to next line in queue
	if((ScreenIndex+1) != (MAX_LINES-1))
		ScreenIndex++;        // not max lines, then inc
	else
		ScreenIndex = 0;      // Else reset to 0

	strcpy(ScreenPtr, text);
	
	// Add text to queue
	DosWriteQueue(hqScreenQue, 0, MAX_CHARS, ScreenPtr, 0);

//	WinPostMsg(hwndClient, WM_MY_PRINT, MPFROMP(text), 0);
	WinPostMsg(hwndClient, WM_MY_PRINT, 0, 0);
	}

/*****************
	WriteScreen()
******************/
//void MyClient :: WriteScreen ( const char *text )
void MyClient :: WriteScreen()
	{
	static bool NoEOL = false;
   static char buffer[MAX_CHARS];
	char *start;
   int index, length;
   BOOL done = 1;

	/* Queue stuff, not used */
	REQUESTDATA    rq;
	PVOID          address;
	ULONG          len;
//   ULONG          rc;
	BYTE           prior;

  DosReadQueue(hqScreenQue, &rq, &len, &address, 0, DCWW_WAIT,
					 &prior, 0);

/*	if(rc != 0)
		{
		char teststr[60];
		switch(rc)
			{
			case 87: strcpy(teststr, "87"); break;
			case 330: strcpy(teststr, "330"); break;
			case 333: strcpy(teststr, "333"); break;
			case 337: strcpy(teststr, "337"); break;
			case 342: strcpy(teststr, "342"); break;
			case 433: strcpy(teststr, "433"); break;
			}
		start = teststr;
		}
   else
		start = (char *)address;
*/

   start = (char *)address;

	buffer[0] = 0;

	while (done)
		{
		char *end = strchr(start, '\n');
		if (!end) end = strchr(start, 0);

		/* Get number of items */
		index = (int)WinQueryLboxCount(hwndOutput);

		// build line
		if (NoEOL)  /* Update those without an \n */
			{
			/* Get length of last item with no terminating NULL */
			length = (int)WinQueryLboxItemTextLength(hwndOutput, index - 1) + 1;

			if(length > 70)
				WinInsertLboxItem(hwndOutput, index, buffer);
			else
				{
				/* Get the text of last item */
				WinQueryLboxItemText(hwndOutput, index - 1, buffer, length);

				strncat(buffer, start, end - start);

				/* Add back item */
				WinInsertLboxItem(hwndOutput, index - 1, buffer);

				/* Delete last item */
				WinDeleteLboxItem(hwndOutput, index);
				}
			}
		else
			{
			length = end - start;
			strncpy(buffer, start, length);
			buffer[length] = '\0';
			WinInsertLboxItem(hwndOutput, index, buffer);
			}
		NoEOL = (*end != '\n');

		// go to next string
		if (*end)
			start = end + 1;
		else
			done = 0;
		}

	// Don't get the listbox get too filled
	while ( index >= 200)
      index = WinDeleteLboxItem(hwndOutput, 0);

	// Position the cursor at the bottom of the list
	WinSendDlgItemMsg(hwndClient, ID_OUTPUT, LM_SELECTITEM,
							MPFROMSHORT(index - 1), MPFROMSHORT(0));

	}


/***********************************************************************
	SetNetworkMode()
	Turns on and off varies other network settings to fit the selected
	network mode
	hwnd - parent handle
	mode - the selected network mode
************************************************************************/
void MyClient::SetNetworkMode(HWND hwnd, int mode)
	{
	char Text[128];
   int uue, http, socks, i, state = FALSE;
	int toggle[] = {ID_PROXY, ID_KEYPORT, ID_UUENCODING, ID_HTTPHEADER,
		ID_SOCKS4, IDM_HTTP_PASS};
	int len = sizeof(toggle);

	char defaultproxy[] = "us.v27.distributed.net";
	char telnetproxy[]  = "us23.v27.distributed.net";

	switch(mode)
		{
		case 4:                          /* HTTP Proxy */
			MainClient->uuehttpmode = 3;
         MainClient->httpport = 80;
         MainClient->keyport = 2064;
			strcpy(MainClient->keyproxy, defaultproxy);
			state = FALSE;
			break;
		case 3:                          /* Freely over telnet + uuencode */
		   MainClient->uuehttpmode = 1;
   		MainClient->keyport = 23;
			strcpy(MainClient->keyproxy, telnetproxy);
         state = FALSE;
			break;
		case 2:                          /* Freely over telnet */
   		MainClient->keyport = 23;
   		MainClient->uuehttpmode = 0;
         strcpy(MainClient->keyproxy, telnetproxy);
         state = FALSE;
			break;
		case 1:                          /* Freely Communicate */
		/* Disable things not needed */
		   MainClient->uuehttpmode = 0;
		   MainClient->httpport = 80;
		   MainClient->keyport = 2064;
			strcpy(MainClient->keyproxy, defaultproxy);
		   break;
		case 5:                          /* Let me Specify everything */
   		state = TRUE;
		   break;
		}

	/* Set all the button states */
	for(i = 0; i <= len; i++)
		WinEnableWindow(WinWindowFromID(hwnd, toggle[i]), state);

	switch(MainClient->uuehttpmode)     /* uuehttpmode and their settings */
		{
		case 0: uue = FALSE; http = FALSE; break;
		case 1: uue = TRUE;  http = FALSE; break;
		case 2: uue = FALSE; http = TRUE; break;
		case 3: uue = TRUE;  http = TRUE; break;
		case 4: uue = FALSE; http = FALSE; break; /* SOCKS4 */
		}

	/* Special for http stuff */
	if(uuehttpmode == 3)    // http proxy
		state = TRUE;
	WinEnableWindow(WinWindowFromID(hwnd, ID_HTTP_PROXY), state);
	WinEnableWindow(WinWindowFromID(hwnd, ID_HTTPPORT), state);
	WinEnableWindow(WinWindowFromID(hwnd, IDM_HTTP_PASS), state);
	WinEnableWindow(WinWindowFromID(hwnd, ID_SOCKS4), state);
	if(MainClient->httpid[0] == 0)
		WinEnableWindow(WinWindowFromID(hwnd, IDM_HTTP_PASS), state);
	else
		{
		WinEnableWindow(WinWindowFromID(hwnd, IDM_HTTP_PASS), TRUE);
		WinSetWindowText(WinWindowFromID(hwnd, ID_HTTP_PASS_TXT), "Set");
		}
		
	WinSendDlgItemMsg(hwnd, ID_UUENCODING, BM_SETCHECK,
							MPFROMSHORT(uue), MPFROMSHORT(0));
	WinSendDlgItemMsg(hwnd, ID_HTTPHEADER, BM_SETCHECK,
							MPFROMSHORT(http), MPFROMSHORT(0));

	if(MainClient->uuehttpmode == MODE_SOCKS)
		i = TRUE;
	else
		i = FALSE;
	WinSendDlgItemMsg(hwnd, ID_SOCKS4, BM_SETCHECK,
							MPFROMSHORT(i), MPFROMSHORT(0));

	WinSetWindowText(WinWindowFromID(hwnd, ID_PROXY), MainClient->keyproxy);
	itoa(MainClient->keyport, Text, 10);
	WinSetWindowText(WinWindowFromID(hwnd, ID_KEYPORT), Text);
	}

/****************************************************************************/
// Password Dialog box for network configuration

void MyClient::SetPass(HWND hwnd)
	{
	WinDlgBox(HWND_DESKTOP, hwnd, GetProxyPassProc, NULLHANDLE,
				 DID_QUERY_HTTP_PASS, NULL);

	HWND hwndEntry = WinWindowFromID(hwnd, ID_HTTP_PASS_TXT);
	if(MainClient->httpid[0] == 0)
		WinSetWindowText(hwndEntry, "Not Set");
	else
		WinSetWindowText(hwndEntry, "Set");
	}
		
/****************************************************************************/
void MyClient::InternalReadConfig(IniSection &ini)
	{
   autorun = ini.getkey("os2pm", "autorun", "0")[0];
	automin = ini.getkey("os2pm", "automin", "0")[0];
/*   autorun = ini.getkey("os2pm", "autorun", IniString(0))[0];
	automin = ini.getkey("os2pm", "automin", IniString(0))[0];
*/	}

/****************************************************************************/
void MyClient::InternalWriteConfig(IniSection &ini)
	{
   s32 i;
// ini.setrecord(OPTION_SECTION, options[key][0], IniString(value))
	ini.setrecord("os2pm", "autorun", IniString(autorun));
	ini.setrecord("os2pm", "automin", IniString(automin));

	// In the standard cli, but not used
   // Offline mode
	if(offlinemode >= 1)
		i = 1;
	else
      i = 0;
	ini.setrecord("parameters", "runoffline", IniString(i));
		
   if(offlinemode == 2)
		i = 1;
	else
		i = 0;
	ini.setrecord("parameters", "runbuffers", IniString(i));
   // Percent off
	ini.setrecord("parameters", "percentoff", IniString(percentprintingoff));
	// Frequent
	ini.setrecord("parameters", "frequent", IniString(connectoften));
   // No disk
	ini.setrecord("parameters", "nodisk", IniString(nodiskbuffers));
   // no fall back
	ini.setrecord("parameters", "nofallback", IniString(nofallback));
	// Check time
	ini.setrecord("parameters", "cktime", IniString(checkpoint_min));
   // network timeout
	ini.setrecord("parameters", "nettimeout", IniString(nettimeout));
	// exitfile check
	ini.setrecord("parameters", "noexitfilecheck", IniString(noexitfilecheck));
	}

/****************************************************************************/
THREADRET Rc5Thread::Run(void)
	{
   #define TEST_CASE_COUNT 32
/* Turn off all menu/buttons for block operations */
#define BLOCKOFF()\
	{\
	if(cracking == FALSE)\
	   MainClient->Menu(IDM_OPTIONS, MIA_DISABLED);\
   MainClient->Menu(IDM_BLOCK, MIA_DISABLED);\
	MainClient->Button(ID_FETCH, FALSE);\
	MainClient->Button(ID_FLUSH, FALSE);\
	MainClient->Button(ID_UPDATE, FALSE);\
	}\
	
#define BLOCKON()\
	{\
	MainClient->Button(ID_UPDATE, TRUE);\
	MainClient->Button(ID_FLUSH, TRUE);\
	MainClient->Button(ID_FETCH, TRUE);\
	MainClient->Menu(IDM_BLOCK, MIA_ENABLED);\
	if(cracking == FALSE)\
		MainClient->Menu(IDM_OPTIONS, MIA_ENABLED);\
	}\

	int i;
	int retcode;
   int oldrunning;
	
	switch(job)
		{
		case ClientFetch:
//   		MainClient->SetStatus("Fetching Key Blocks...");
         BLOCKOFF();

			oldrunning = MainClient->offlinemode;
			MainClient->offlinemode = 0;
			NetworkInitialize();
			MainClient->ValidateConfig();
			retcode = MainClient->Fetch(0); // RC5 Fetch
			if (MainClient->randomchanged) MainClient->WriteConfig();
			retcode = MainClient->Fetch(1); // DES Fetch
			if (MainClient->randomchanged) MainClient->WriteConfig();
			MainClient->mailmessage.checktosend(1);
			NetworkDeinitialize();
			MainClient->offlinemode = oldrunning;
			if (retcode < 0 )
				MainClient->LogScreen( "An error occured trying to fetch.  Please try again later" );
//			else
//				MainClient->LogScreen( "Fetch completed." );
			BLOCKON();
			return( retcode );

		case ClientFlush:
//   		MainClient->LogScreen("Flushing Key Blocks...");
         BLOCKOFF();

			oldrunning = MainClient->offlinemode;
			MainClient->offlinemode = 0;
			NetworkInitialize();
			MainClient->ValidateConfig();
			retcode = MainClient->Flush(0); // RC5 Flush
			retcode = MainClient->Flush(1); // DES Flush
			MainClient->mailmessage.checktosend(1);
			NetworkDeinitialize();
			oldrunning = MainClient->offlinemode;
			if (retcode < 0 )
				MainClient->LogScreen( "An error occured trying to flush the files out."
							  "Please try again later" );
//			else
//				MainClient->LogScreen( "Flush completed." );

			BLOCKON();
			return( retcode );

		case ClientUpdate:
   		MainClient->LogScreen("Updating Key Blocks...");
		   BLOCKOFF();

			oldrunning = MainClient->offlinemode;
			MainClient->offlinemode = 0;
			NetworkInitialize();
			MainClient->ValidateConfig();
			retcode = MainClient->Update(1 ,1,1); // RC5 We care about both the fetch & flush errors.
			if (MainClient->randomchanged) MainClient->WriteConfig();
			retcode = MainClient->Update(0 ,1,1); // DES We care about both the fetch & flush errors.
			if (MainClient->randomchanged) MainClient->WriteConfig();
			MainClient->mailmessage.checktosend(1);
			NetworkDeinitialize();
			oldrunning = MainClient->offlinemode;
			if (retcode < 0)
				MainClient->LogScreen( "An error occured during the update." );
			else
				MainClient->LogScreen( "Update completed." );

			BLOCKON();
			return( retcode );

		case ClientRun:
         cracking = TRUE;
		   MainClient->SetStatus("Cracking Thread Started...");
		   MainClient->Menu(IDM_STOP, MIA_ENABLED);
		   MainClient->Menu(IDM_START, MIA_DISABLED);
			MainClient->Menu(IDM_OPTIONS, MIA_DISABLED);

			// otherwise we are running
			if (MainClient->RunStartup()) return 0;
			if ((!MainClient->offlinemode) || (MainClient->messagelen > 0))
				NetworkInitialize();
			MainClient->Log("\n\nRC5DES Client v2.%d.%d started.  Using %s as email address.\n\n",
								 CLIENT_CONTEST*100+CLIENT_BUILD,CLIENT_BUILD_FRAC,MainClient->id);

			MainClient->PercentClear();
			MainClient->Run();

			if (MainClient->randomchanged) MainClient->WriteConfig();
			MainClient->mailmessage.checktosend(1);
			if ((!MainClient->offlinemode) || (MainClient->messagelen > 0))
				NetworkDeinitialize();

		   MainClient->Menu(IDM_STOP, MIA_DISABLED);
		   MainClient->Menu(IDM_START, MIA_ENABLED);
			MainClient->Menu(IDM_OPTIONS, MIA_ENABLED);
			MainClient->SetStatus("Cracking Thread Stopped...");
			SignalTriggered = 0;
			cracking = FALSE;
         return 0;
		case ClientTest:
         MainClient->SetStatus("Running Test...");
         MainClient->Menu(IDM_CLIENT, MIA_DISABLED);
		   BLOCKOFF();
		   i = MainClient->SelfTest();
			if ( i < 0 )
				{
				if (MainClient->preferred_contest == 1)
					MainClient->LogScreenf( "%d Tests, Failed on RC5 Test %d", (int) TEST_CASE_COUNT, (int) -i );
				else
					MainClient->LogScreenf( "%d Tests, Failed on DES Test %d", (int) TEST_CASE_COUNT, (int) -i );
				}
			else
				{
				if (MainClient->preferred_contest == 1)
					MainClient->LogScreenf( "%d/%d RC5 Tests Passed", (int) TEST_CASE_COUNT, (int) i );
				else
					MainClient->LogScreenf( "%d/%d DES Tests Passed", (int) TEST_CASE_COUNT, (int) i );
				}
         BLOCKON();
			MainClient->Menu(IDM_CLIENT, MIA_ENABLED);
			MainClient->SetStatus("Tests Complete...");
		return( 0 );

		case ClientBenchmark:
   		MainClient->SetStatus("Running Benchmark...");
   		MainClient->Menu(IDM_CLIENT, MIA_DISABLED);
		   BLOCKOFF();
         MainClient->PercentClear();
			MainClient->Benchmark(0);
         BLOCKON();
			MainClient->Menu(IDM_CLIENT, MIA_ENABLED);
			MainClient->SetStatus("Benchmark Complete...");
			return 0;
		case ClientBenchmark2:
   		MainClient->SetStatus("Running Benchmark...");
   		MainClient->Menu(IDM_CLIENT, MIA_DISABLED);
		   BLOCKOFF();
         MainClient->PercentClear();
			MainClient->Benchmark(1000000);
         BLOCKON();
			MainClient->Menu(IDM_CLIENT, MIA_ENABLED);
			MainClient->SetStatus("Benchmark Complete...");
			return 0;
		}
	return 0;
	}

 
