/*
 * Copyright distributed.net 1999-2004 - All Rights Reserved
 * For use in distributed.net projects only.
 * Any other distribution or use of this source violates copyright.
*/

#ifndef __ASM_X86_H__
#define __ASM_X86_H__ "@(#)$Id: asm-x86.h,v 1.1.4.2 2005/05/27 08:00:14 stream Exp $"

/*
 * Macro to check assertions at compile-time (e.g. sizeof(foo) == something)
 */
#define STATIC_ASSERT(cond)  { typedef int safoo[(cond) ? 1 : -1]; }

/* If we were to cover the whole range of 0x00000000 ... 0xffffffff
   we would need ...
   static __inline__ int __CNTLZ__(register unsigned int input)
   {
      register unsigned int result;
      __asm__("notl %1\n\t"     \
              "movl $33,%0\n\t" \
              "bsrl %1,%1\n\t"  \
              "jz   0f\n\t"     \
              "subl %1,%0\n\t"  \
              "decl %0\n\t"     \
              "0:"              \
              :"=r"(result), "=r"(input) : "1"(input) : "cc" );
      return result;
   }
   but since the function is only executed for (comp0 < 0xfffffffe),
   we can optimize it to...
*/

#if defined(__ICC)
  static inline int __CNTLZ__(register unsigned int i)
  {
    _asm mov eax,i
    _asm not eax
    _asm mov edx,20h
    _asm bsr eax,eax
    _asm sub edx,eax
    _asm mov i,edx
    return i;
  }
  #define __CNTLZ(x) __CNTLZ__(x)

#elif defined(__WATCOMC__)

  #if (OGROPT_ALTERNATE_CYCLE == 0) && (OGROPT_ALTERNATE_COMP_LEFT_LIST_RIGHT == 1)
    #include <stddef.h>   /* offsetof */

    void LIST_RIGHT_xx(void *levlist, int s, int newbit);
    void COMP_LEFT_xx(void *levcomp, int s);
    #pragma aux LIST_RIGHT_xx =  \
      "mov  edx,[edi+12]"                  \
      "shrd [edi+16],edx,cl"               \
      "mov  edx,[edi+8]"                   \
      "shrd [edi+12],edx,cl"               \
      "mov  edx,[edi+4]"                   \
      "shrd [edi+8],edx,cl"                \
      "mov edx,[edi+0]"                    \
      "shrd [edi+4],edx,cl"                \
      "shrd edx,esi,cl"                    \
      "mov  [edi+0],edx"                   \
      parm [edi] [ecx] [esi] modify exact [edx];

    #pragma aux COMP_LEFT_xx =  \
      "mov  eax,[edi+4]"        \
      "mov  edx,[edi+8]"        \
      "shld [edi+0],eax,cl"     \
      "shld eax,edx,cl"         \
      "mov  [edi+4],eax"        \
      "mov  eax,[edi+12]"       \
      "shld edx,eax,cl"         \
      "mov  [edi+8],edx"        \
      "mov  edx,[edi+16]"       \
      "shld eax,edx,cl"         \
      "mov  [edi+12],eax"       \
      "shl  edx,cl"             \
      "mov  [edi+16],edx"       \
      parm [edi] [ecx] modify exact [eax edx ebx];

    #define COMP_LEFT_LIST_RIGHT(lev,s)        \
      STATIC_ASSERT( offsetof(struct Level, list) == 0  );   \
      STATIC_ASSERT( offsetof(struct Level, comp) == 40 );   \
      STATIC_ASSERT( sizeof(lev->list) == 20 );              \
      STATIC_ASSERT( sizeof(lev->comp) == 20 );              \
      LIST_RIGHT_xx(&(lev->list[0]),s,newbit); \
      COMP_LEFT_xx(&(lev->comp[0]),s);         \
      newbit = 0;                              \
      comp0  = lev->comp[0];                   

  #endif

  int __CNTLONEREV__(unsigned int);
  #pragma aux __CNTLONEREV__ =  \
          "bsr  eax,eax"      \
          value [eax] parm [eax] modify [eax] nomemory;
  #define __CNTLZ(x) (32-__CNTLONEREV__(~(x)))


#elif defined(__GNUC__)

  // unfortunately, this inline assembly version seems to be slower
  // than the code generated by gcc 3.2 from the C version.
  #if 0 && (OGROPT_ALTERNATE_CYCLE == 0) && (OGROPT_ALTERNATE_COMP_LEFT_LIST_RIGHT == 1) && !defined(OGROPT_64BIT_IMPLEMENTATION)
    #define COMP_LEFT_LIST_RIGHT(lev,s) { \
      __asm__ volatile(                   \
        "movl  4(%2),%%eax\n\t"           \
        "movl  12(%3),%%edx\n\t"          \
                                          \
        "shldl %%cl,%%eax,(%2)\n\t"       \
        "movl  8(%2),%%eax\n\t"           \
                                          \
        "shrdl %%cl,%%edx,16(%3)\n\t"     \
        "movl  8(%3),%%edx\n\t"           \
                                          \
        "shldl %%cl,%%eax,4(%2)\n\t"      \
        "movl  12(%2),%%eax\n\t"          \
                                          \
        "shrdl %%cl,%%edx,12(%3)\n\t"     \
        "movl  4(%3),%%edx\n\t"           \
                                          \
        "shldl %%cl,%%eax,8(%2)\n\t"      \
        "movl  16(%2),%%eax\n\t"          \
                                          \
        "shrdl %%cl,%%edx,8(%3)\n\t"      \
        "movl  (%3),%%edx\n\t"            \
                                          \
        "shldl %%cl,%%eax,12(%2)\n\t"     \
        "shrdl %%cl,%%edx,4(%3)\n\t"      \
                                          \
        "xorl  %%edx,%%edx\n\t"           \
        "shll  %%cl,16(%2)\n\t"           \
        "xchgl  %0,%%edx\n\t"  /* newbit = 0 */         \
        "movl (%2),%1\n\t"   /* comp0 = lev->comp[0] */    \
        "shrdl  %%cl,%%edx,(%3)\n\t"      \
                                          \
        : "=rm" (newbit), "=r" (comp0)   \
        : "D" (&(lev->comp)), /* get lev->comp in edi */ \
          "S" (&(lev->list)), /* get lev->list in esi */ \
          "c" (s), /* get s in ecx */ \
          "0" (newbit)  \
        : "memory", "cc", "eax", "edx"    \
      );                                  \
    }
  #endif

  static __inline__ int __CNTLZ__(register unsigned int input)
  {
     register unsigned int result;
     __asm__("notl %1\n\t"     \
             "movl $32,%0\n\t" \
             "bsrl %1,%1\n\t"  \
             "subl %1,%0\n\t"  \
             :"=r"(result), "=r"(input) : "1"(input) : "cc" );
     return result;
  }
  #define __CNTLZ(x) __CNTLZ__(x)

#elif defined(_MSC_VER)

  static __forceinline int __CNTLZ__(register unsigned int i)
  {
      __asm {
        mov ecx,i
        not ecx
        mov eax,20h
        bsr ecx,ecx
        sub eax,ecx
      }
      // return value in eax
  }
  #define __CNTLZ(x) __CNTLZ__(x)

#endif  /* compiler */

#endif  /* __ASM_X86__ */
