;#
;# RC5-72 core generated by genCore.
;# Time stamp : Fri Aug  3 15:51:04 2007
;# Target : PPC_cell
;#
;# Written by Didier Levet (kakace@distributed.net)
;# Copyright distributed.net 1997-2007 - All Rights Reserved.
;# For use in distributed.net projects only. Any other distribution
;# or use of this source violates copyright.
;#
;# Dependencies :
;#
;#	struct rc5_72UnitWork (ccoreio.h) :
;#		typedef struct {
;#			struct {u32 hi, lo;} plain;
;#			struct {u32 hi, lo;} cypher;
;#			struct {u32 hi, mid, lo;} L0;
;#			struct {u32 count, hi, mid, lo;} check;
;#		} RC5_72UnitWork;
;#
;#	MINIMUM_ITERATIONS (problem.cpp) :
;#		The number of iterations to perform is always an even multiple of
;#		MINIMUM_ITERATIONS, and the first key to checked is also an even
;#		multiple of this constant.
;#		Therefore, it is assumed that the number of iterations is never
;#		equal to zero (otherwise it would be interpreted as 2^32).
;#		The current value of 48 also ensure that we can process 1, 2, 4, 8 or
;#		16 keys at once, all keys (within each group) having the same mid
;#		and lo values.
;#
;#
;# $Id: r72-cellv1-ppe.s,v 1.2 2007/10/22 16:48:35 jlawson Exp $
;#
;# $Log: r72-cellv1-ppe.s,v $
;# Revision 1.2  2007/10/22 16:48:35  jlawson
;# overwrite head with contents of release-2-90xx
;#
;# Revision 1.1.2.2  2007/08/07 07:46:06  decio
;# kakace's new PPE core for Cell
;#
;#============================================================================

		.text
		.align	4
		.globl	_rc5_72_unit_func_cellv1_ppe
		.globl	rc5_72_unit_func_cellv1_ppe


;# Register aliases (gas support)

;.set	r0,0
;.set	r1,1
;.set	r2,2
;.set	r3,3
;.set	r4,4
;.set	r5,5
;.set	r6,6
;.set	r7,7
;.set	r8,8
;.set	r9,9
;.set	r10,10
;.set	r11,11
;.set	r12,12
;.set	r13,13
;.set	r14,14
;.set	r15,15
;.set	r16,16
;.set	r17,17
;.set	r18,18
;.set	r19,19
;.set	r20,20
;.set	r21,21
;.set	r22,22
;.set	r23,23
;.set	r24,24
;.set	r25,25
;.set	r26,26
;.set	r27,27
;.set	r28,28
;.set	r29,29
;.set	r30,30
;.set	r31,31

;.set	v0,0
;.set	v1,1
;.set	v2,2
;.set	v3,3
;.set	v4,4
;.set	v5,5
;.set	v6,6
;.set	v7,7
;.set	v8,8
;.set	v9,9
;.set	v10,10
;.set	v11,11
;.set	v12,12
;.set	v13,13
;.set	v14,14
;.set	v15,15
;.set	v16,16
;.set	v17,17
;.set	v18,18
;.set	v19,19
;.set	v20,20
;.set	v21,21
;.set	v22,22
;.set	v23,23
;.set	v24,24
;.set	v25,25
;.set	v26,26
;.set	v27,27
;.set	v28,28
;.set	v29,29
;.set	v30,30
;.set	v31,31

;.set	VRsave,256


;# Result values (see ccoreio.h)

.set	RESULT_NOTHING,	1
.set	RESULT_FOUND,	2


;# struct RC5_72UnitWork (see ccoreio.h) :

.set	plain_hi,	  0
.set	plain_lo,	  4
.set	cypher_hi,	  8
.set	cypher_lo,	 12
.set	L0_hi,		 16
.set	L0_mid,		 20
.set	L0_lo,		 24
.set	check_count, 28
.set	check_hi,	 32
.set	check_mid,	 36
.set	check_lo,	 40


;# RSA constants

.set	P, 0xB7E15163
.set	Q, 0x9E3779B9


;# Misc constants.

.set hi16_P,	(P >> 16)
.set lo16_P,	(P & 0xFFFF)
.set hi16_Q,	(Q >> 16)
.set lo16_Q,	(Q & 0xFFFF)


;# About the stack frame :
;# Since the core is a leaf procedure, the stack frame doesn't have to follow
;# specific ABI conventions. However, the stack pointer shall be aligned on a
;# quad-word (16 bytes) boundary to accomodate AltiVec limitations. This 
;#alignment is enforced at run time when allocating the stack frame.
;#
;# Conventions :
;# The LR register is not used, so it doesn't have to be preserved.
;# Register r2, usually used as RTOC, is preserved although it might be
;# defined as volatile.
;#
;# Volatile registers (not preserved) :
;#  CR (cr0-1, cr5-cr7)
;#  CTR
;#  r0, r3-r12, v0-v19

		;# The following constants are used to determine the size of the GPR
		;# and VR save areas. Prolog and epilog code have to be modified if
		;# your ABI defines another convention.
.set	NV_GPR,			13		;# Non-volatile GPR : r13 - r31
.set	NV_VR,			20		;# Non-volatile VR  : v20 - v31

.set	wVRSave,		 4		;# vrsave backup
.set	wSaveR2,		 8		;# r2 backup
.set	wKIter,			20		;# Remaining iterations
.set	pUnitWork,		24		;# struct RC5_72UnitWork * (copy)
.set	pIterations,	28		;# u32 * (copy)

.set	aVectorArea,	32		;# Vector registers save area
								;# (12 registers, 192 bytes)

		;# Vector datas : (S[] arrays, and misc variables).
		;# All vector datas are addressed through 11 base registers and 12
		;# offsets (including the form (rA|0)). The combinations base + offset 
		;#provide direct access to 132 consecutive vectors.
		;#
		;# DO NOT CHANGE THEIR RESPECTIVE ORDER !!!
.set	vBase,		aVectorArea + (32 - NV_VR) * 16

.set	vS0_00,		vBase + 16 *   0	;# (indexing: 0,r21)
.set	vS0_01,		vBase + 16 *   1	;# (indexing: r10,r21)
.set	vS0_02,		vBase + 16 *   2	;# (indexing: r11,r21)
.set	vS0_03,		vBase + 16 *   3	;# (indexing: r12,r21)
.set	vS0_04,		vBase + 16 *   4	;# (indexing: r13,r21)
.set	vS0_05,		vBase + 16 *   5	;# (indexing: r14,r21)
.set	vS0_06,		vBase + 16 *   6	;# (indexing: r15,r21)
.set	vS0_07,		vBase + 16 *   7	;# (indexing: r16,r21)
.set	vS0_08,		vBase + 16 *   8	;# (indexing: r17,r21)
.set	vS0_09,		vBase + 16 *   9	;# (indexing: r18,r21)
.set	vS0_10,		vBase + 16 *  10	;# (indexing: r19,r21)
.set	vS0_11,		vBase + 16 *  11	;# (indexing: r20,r21)
.set	vS0_12,		vBase + 16 *  12	;# (indexing: 0,r22)
.set	vS0_13,		vBase + 16 *  13	;# (indexing: r10,r22)
.set	vS0_14,		vBase + 16 *  14	;# (indexing: r11,r22)
.set	vS0_15,		vBase + 16 *  15	;# (indexing: r12,r22)
.set	vS0_16,		vBase + 16 *  16	;# (indexing: r13,r22)
.set	vS0_17,		vBase + 16 *  17	;# (indexing: r14,r22)
.set	vS0_18,		vBase + 16 *  18	;# (indexing: r15,r22)
.set	vS0_19,		vBase + 16 *  19	;# (indexing: r16,r22)
.set	vS0_20,		vBase + 16 *  20	;# (indexing: r17,r22)
.set	vS0_21,		vBase + 16 *  21	;# (indexing: r18,r22)
.set	vS0_22,		vBase + 16 *  22	;# (indexing: r19,r22)
.set	vS0_23,		vBase + 16 *  23	;# (indexing: r20,r22)
.set	vS0_24,		vBase + 16 *  24	;# (indexing: 0,r23)
.set	vS0_25,		vBase + 16 *  25	;# (indexing: r10,r23)
.set	vS1_00,		vBase + 16 *  26	;# (indexing: r11,r23)
.set	vS1_01,		vBase + 16 *  27	;# (indexing: r12,r23)
.set	vS1_02,		vBase + 16 *  28	;# (indexing: r13,r23)
.set	vS1_03,		vBase + 16 *  29	;# (indexing: r14,r23)
.set	vS1_04,		vBase + 16 *  30	;# (indexing: r15,r23)
.set	vS1_05,		vBase + 16 *  31	;# (indexing: r16,r23)
.set	vS1_06,		vBase + 16 *  32	;# (indexing: r17,r23)
.set	vS1_07,		vBase + 16 *  33	;# (indexing: r18,r23)
.set	vS1_08,		vBase + 16 *  34	;# (indexing: r19,r23)
.set	vS1_09,		vBase + 16 *  35	;# (indexing: r20,r23)
.set	vS1_10,		vBase + 16 *  36	;# (indexing: 0,r24)
.set	vS1_11,		vBase + 16 *  37	;# (indexing: r10,r24)
.set	vS1_12,		vBase + 16 *  38	;# (indexing: r11,r24)
.set	vS1_13,		vBase + 16 *  39	;# (indexing: r12,r24)
.set	vS1_14,		vBase + 16 *  40	;# (indexing: r13,r24)
.set	vS1_15,		vBase + 16 *  41	;# (indexing: r14,r24)
.set	vS1_16,		vBase + 16 *  42	;# (indexing: r15,r24)
.set	vS1_17,		vBase + 16 *  43	;# (indexing: r16,r24)
.set	vS1_18,		vBase + 16 *  44	;# (indexing: r17,r24)
.set	vS1_19,		vBase + 16 *  45	;# (indexing: r18,r24)
.set	vS1_20,		vBase + 16 *  46	;# (indexing: r19,r24)
.set	vS1_21,		vBase + 16 *  47	;# (indexing: r20,r24)
.set	vS1_22,		vBase + 16 *  48	;# (indexing: 0,r25)
.set	vS1_23,		vBase + 16 *  49	;# (indexing: r10,r25)
.set	vS1_24,		vBase + 16 *  50	;# (indexing: r11,r25)
.set	vS1_25,		vBase + 16 *  51	;# (indexing: r12,r25)
.set	vS2_00,		vBase + 16 *  52	;# (indexing: r13,r25)
.set	vS2_01,		vBase + 16 *  53	;# (indexing: r14,r25)
.set	vS2_02,		vBase + 16 *  54	;# (indexing: r15,r25)
.set	vS2_03,		vBase + 16 *  55	;# (indexing: r16,r25)
.set	vS2_04,		vBase + 16 *  56	;# (indexing: r17,r25)
.set	vS2_05,		vBase + 16 *  57	;# (indexing: r18,r25)
.set	vS2_06,		vBase + 16 *  58	;# (indexing: r19,r25)
.set	vS2_07,		vBase + 16 *  59	;# (indexing: r20,r25)
.set	vS2_08,		vBase + 16 *  60	;# (indexing: 0,r26)
.set	vS2_09,		vBase + 16 *  61	;# (indexing: r10,r26)
.set	vS2_10,		vBase + 16 *  62	;# (indexing: r11,r26)
.set	vS2_11,		vBase + 16 *  63	;# (indexing: r12,r26)
.set	vS2_12,		vBase + 16 *  64	;# (indexing: r13,r26)
.set	vS2_13,		vBase + 16 *  65	;# (indexing: r14,r26)
.set	vS2_14,		vBase + 16 *  66	;# (indexing: r15,r26)
.set	vS2_15,		vBase + 16 *  67	;# (indexing: r16,r26)
.set	vS2_16,		vBase + 16 *  68	;# (indexing: r17,r26)
.set	vS2_17,		vBase + 16 *  69	;# (indexing: r18,r26)
.set	vS2_18,		vBase + 16 *  70	;# (indexing: r19,r26)
.set	vS2_19,		vBase + 16 *  71	;# (indexing: r20,r26)
.set	vS2_20,		vBase + 16 *  72	;# (indexing: 0,r27)
.set	vS2_21,		vBase + 16 *  73	;# (indexing: r10,r27)
.set	vS2_22,		vBase + 16 *  74	;# (indexing: r11,r27)
.set	vS2_23,		vBase + 16 *  75	;# (indexing: r12,r27)
.set	vS2_24,		vBase + 16 *  76	;# (indexing: r13,r27)
.set	vS2_25,		vBase + 16 *  77	;# (indexing: r14,r27)
.set	vS3_00,		vBase + 16 *  78	;# (indexing: r15,r27)
.set	vS3_01,		vBase + 16 *  79	;# (indexing: r16,r27)
.set	vS3_02,		vBase + 16 *  80	;# (indexing: r17,r27)
.set	vS3_03,		vBase + 16 *  81	;# (indexing: r18,r27)
.set	vS3_04,		vBase + 16 *  82	;# (indexing: r19,r27)
.set	vS3_05,		vBase + 16 *  83	;# (indexing: r20,r27)
.set	vS3_06,		vBase + 16 *  84	;# (indexing: 0,r28)
.set	vS3_07,		vBase + 16 *  85	;# (indexing: r10,r28)
.set	vS3_08,		vBase + 16 *  86	;# (indexing: r11,r28)
.set	vS3_09,		vBase + 16 *  87	;# (indexing: r12,r28)
.set	vS3_10,		vBase + 16 *  88	;# (indexing: r13,r28)
.set	vS3_11,		vBase + 16 *  89	;# (indexing: r14,r28)
.set	vS3_12,		vBase + 16 *  90	;# (indexing: r15,r28)
.set	vS3_13,		vBase + 16 *  91	;# (indexing: r16,r28)
.set	vS3_14,		vBase + 16 *  92	;# (indexing: r17,r28)
.set	vS3_15,		vBase + 16 *  93	;# (indexing: r18,r28)
.set	vS3_16,		vBase + 16 *  94	;# (indexing: r19,r28)
.set	vS3_17,		vBase + 16 *  95	;# (indexing: r20,r28)
.set	vS3_18,		vBase + 16 *  96	;# (indexing: 0,r29)
.set	vS3_19,		vBase + 16 *  97	;# (indexing: r10,r29)
.set	vS3_20,		vBase + 16 *  98	;# (indexing: r11,r29)
.set	vS3_21,		vBase + 16 *  99	;# (indexing: r12,r29)
.set	vS3_22,		vBase + 16 * 100	;# (indexing: r13,r29)
.set	vS3_23,		vBase + 16 * 101	;# (indexing: r14,r29)
.set	vS3_24,		vBase + 16 * 102	;# (indexing: r15,r29)
.set	vS3_25,		vBase + 16 * 103	;# (indexing: r16,r29)
.set	vS4_00,		vBase + 16 * 104	;# (indexing: r17,r29)
.set	vS4_01,		vBase + 16 * 105	;# (indexing: r18,r29)
.set	vS4_02,		vBase + 16 * 106	;# (indexing: r19,r29)
.set	vS4_03,		vBase + 16 * 107	;# (indexing: r20,r29)
.set	vS4_04,		vBase + 16 * 108	;# (indexing: 0,r30)
.set	vS4_05,		vBase + 16 * 109	;# (indexing: r10,r30)
.set	vS4_06,		vBase + 16 * 110	;# (indexing: r11,r30)
.set	vS4_07,		vBase + 16 * 111	;# (indexing: r12,r30)
.set	vS4_08,		vBase + 16 * 112	;# (indexing: r13,r30)
.set	vS4_09,		vBase + 16 * 113	;# (indexing: r14,r30)
.set	vS4_10,		vBase + 16 * 114	;# (indexing: r15,r30)
.set	vS4_11,		vBase + 16 * 115	;# (indexing: r16,r30)
.set	vS4_12,		vBase + 16 * 116	;# (indexing: r17,r30)
.set	vS4_13,		vBase + 16 * 117	;# (indexing: r18,r30)
.set	vS4_14,		vBase + 16 * 118	;# (indexing: r19,r30)
.set	vS4_15,		vBase + 16 * 119	;# (indexing: r20,r30)
.set	vS4_16,		vBase + 16 * 120	;# (indexing: 0,r31)
.set	vS4_17,		vBase + 16 * 121	;# (indexing: r10,r31)
.set	vS4_18,		vBase + 16 * 122	;# (indexing: r11,r31)
.set	vS4_19,		vBase + 16 * 123	;# (indexing: r12,r31)
.set	vS4_20,		vBase + 16 * 124	;# (indexing: r13,r31)
.set	vS4_21,		vBase + 16 * 125	;# (indexing: r14,r31)
.set	vS4_22,		vBase + 16 * 126	;# (indexing: r15,r31)
.set	vS4_23,		vBase + 16 * 127	;# (indexing: r16,r31)
.set	vS4_24,		vBase + 16 * 128	;# (indexing: r17,r31)
.set	vS4_25,		vBase + 16 * 129	;# (indexing: r18,r31)

.set	vTmp,		vBase + 2080		;# Conversion storage
.set	vKeyBase,	vTmp				;# Key vector.
.set	wKeyHi,		vKeyBase
.set	wKeyMid,	vKeyBase + 4
.set	wKeyLo,		vKeyBase + 8
.set	wPad0,		vKeyBase + 12		;# Set to 0

.set	vCypherPlain,	vBase + 2096	;# Cypher/Plain vector

.set	vCheck,		vBase + 2112		;# check vector
.set	wCheckHi,	vCheck
.set	wCheckMid,	vCheck + 4
.set	wCheckLo,	vCheck + 8
.set	wCount,		vCheck + 12

.set	localTop,	vBase + 2128		;# (== 2352)
.set	GPRsave,	(32-NV_GPR) * 4		;# Size of the GPR save area

		;# The prolog code assumes that the size of the stack frame is a
		;# multiple of 16
.set	FrameSize,	(localTop + GPRsave + 15) & (-16)


;#=============================================================================
;# u32 (r3) = rc5_72_unit_func_cellv1_ppe(RC5_72UnitWork *rc5_72unitwork (r3),
;#						u32 *iterations (r4),
;#						void * /* memblk (r5) */)

rc5_72_unit_func_cellv1_ppe:
_rc5_72_unit_func_cellv1_ppe:

		;# Allocate the stack frame
		mr		r5,r1				;# Caller's stack pointer
		clrlwi	r6,r1,27			;# Keep the low order 4-bits
		subfic	r6,r6,-FrameSize	;# Total frame size, including padding.
		stwux	r1,r1,r6			;# Create the stack frame.

		;# Save non-volatile scalar registers
		stmw	r13,-GPRsave(r5)	;# Save r13-r31
		stw		r2,wSaveR2(r1)		;# Save r2

		mfspr	r6,VRsave
		li		r7,-1				;# Use all vector registers
		stw		r6,wVRSave(r1)
		mtspr	VRsave,r7

		;# Save non-volatile vector registers
		li		r5,aVectorArea
		stvx	v31,r1,r5
		addi	r5,r5,16
		stvx	v30,r1,r5
		addi	r5,r5,16
		stvx	v29,r1,r5
		addi	r5,r5,16
		stvx	v28,r1,r5
		addi	r5,r5,16
		stvx	v27,r1,r5
		addi	r5,r5,16
		stvx	v26,r1,r5
		addi	r5,r5,16
		stvx	v25,r1,r5
		addi	r5,r5,16
		stvx	v24,r1,r5
		addi	r5,r5,16
		stvx	v23,r1,r5
		addi	r5,r5,16
		stvx	v22,r1,r5
		addi	r5,r5,16
		stvx	v21,r1,r5
		addi	r5,r5,16
		stvx	v20,r1,r5

		;# Copy the arguments
		stw		r3,pUnitWork(r1)	;# RC5_72UnitWork *
		stw		r4,pIterations(r1)	;# u32 *

		lwz		r5,check_count(r3)	;# Prepare vCheck vector
		lwz		r6,check_hi(r3)
		lwz		r7,check_mid(r3)
		lwz		r8,check_lo(r3)
		stw		r5,wCount(r1)
		stw		r6,wCheckHi(r1)
		stw		r7,wCheckMid(r1)
		stw		r8,wCheckLo(r1)
		;# vCheck = (check.hi, check.mid, check.lo, check.count)

		lwz		r5,plain_lo(r3)		;# Prepare 'plain' and 'text' vector
		lwz		r6,plain_hi(r3)
		lwz		r7,cypher_lo(r3)
		lwz		r8,cypher_hi(r3)
		stw		r5,vCypherPlain(r1)
		stw		r6,vCypherPlain+4(r1)
		stw		r7,vCypherPlain+8(r1)
		stw		r8,vCypherPlain+12(r1)
		;# vCypherPlain = (plain.lo, plain.hi, cypher.lo, cypher.hi)

		li		r5,0				;# Initialize vCst0123 vector
		li		r6,1
		li		r7,2
		li		r8,3
		li		r10,vTmp
		stw		r5,vTmp(r1)
		stw		r6,vTmp+4(r1)
		stw		r7,vTmp+8(r1)
		stw		r8,vTmp+12(r1)
		lvx		v27,r10,r1			;# Load vTmp = (0, 1, 2, 3)
		vspltisw v26,3				;# vector int (3,3,3,3) (const)

		;# Initialize RSA constants
		lis		r5,hi16_P
		lis		r6,hi16_Q
		ori		r5,r5,lo16_P
		ori		r6,r6,lo16_Q
		stw		r5,vTmp(r1)
		stw		r6,vTmp+4(r1)
		lvx		v24,r10,r1			;# Load vTmp
		vspltw	v0,v24,0			;# = (P, P, P, P)
		vspltw	v1,v24,1			;# = (Q, Q, Q, Q)

		lwz		r5,L0_hi(r3)		;# Setup vKey vector
		lwz		r6,L0_mid(r3)
		lwz		r7,L0_lo(r3)
		li		r8,0
		stw		r5,wKeyHi(r1)
		stw		r6,wKeyMid(r1)
		stw		r7,wKeyLo(r1)
		stw		r8,wPad0(r1)
		;# vKey = (key.hi, key.mid, key.lo, 0)

		;# Initialize bases/offsets registers. They are used to load/store
		;# datas using the indexed addressing mode. All these registers remain
		;# constant.
		;# Assignments :
		;# r21 := Points to vector vS0[00]
		;# r22 := Points to vector vS0[12]
		;# r23 := Points to vector vS0[24]
		;# r24 := Points to vector vS1[10]
		;# r25 := Points to vector vS1[22]
		;# r26 := Points to vector vS2[08]
		;# r27 := Points to vector vS2[20]
		;# r28 := Points to vector vS3[06]
		;# r29 := Points to vector vS3[18]
		;# r30 := Points to vector vS4[04]
		;# r31 := Points to vector vS4[16]
		;#   0 == 0
		;# r10 == 16
		;# r11 == 32
		;# r12 == 48
		;# r13 == 64
		;# r14 == 80
		;# r15 == 96
		;# r16 == 112
		;# r17 == 128
		;# r18 == 144
		;# r19 == 160
		;# r20 == 176
		addi	r21,r1,vBase
		addi	r22,r21,16*12
		addi	r23,r22,16*12
		addi	r24,r23,16*12
		addi	r25,r24,16*12
		addi	r26,r25,16*12
		addi	r27,r26,16*12
		addi	r28,r27,16*12
		addi	r29,r28,16*12
		addi	r30,r29,16*12
		addi	r31,r30,16*12
		li		r10,16
		li		r11,32
		li		r12,48
		li		r13,64
		li		r14,80
		li		r15,96
		li		r16,112
		li		r17,128
		li		r18,144
		li		r19,160
		li		r20,176


;#============================================================================
;# Main loop implementation :
;# Compute how many iterations to perform in the inner loop.
;# The inner loop shall exit when the iteration count becomes zero, or when
;# key.hi becomes zero (in the later case, we have to increment key.mid and
;# maybe key.lo).
;# NOTE : The code below relies on MINIMUM_ITERATIONS and assumes that
;#        (key % MINIMUM_ITERATION) == 0)
;#
;# r3 : rc5_72unitwork
;# r4 : iterations

		lwz		r5,wKeyHi(r1)		;# Load key.hi
		lwz		r4,0(r4)

		;# Compute how many iterations to perform in the inner loop until
		;# key.hi == 0 or the total number of iterations is reached.

		li		r6,256/16			;# Setup max value
		srwi	r5,r5,4				;# key.hi / 16
		srwi	r4,r4,4				;# = Total number of iterations / 16
		subf	r6,r5,r6			;# = Iterations until key.hi == 0
		cmplw	r4,r6
		bgt		set_count1

		mr		r6,r4

set_count1:
		subf	r4,r6,r4			;# Remaining iterations
		stw		r4,wKIter(r1)
		mtctr	r6					;# Cannot be zero


		;# S[n] = P + n.Q
		;# v0  = (P, P, P, P)
		;# v1  = (Q, Q, Q, Q)
		vrlw	v24,v0,v26			;# = ROTL(S0[0],3)
		stvx	v24,0,r21		;# vS0[0]
		vadduwm	v0,v0,v1
		stvx	v0,r10,r21			;# vS0[1]
		vadduwm	v0,v0,v1
		stvx	v0,r11,r21			;# vS0[2]
		vadduwm	v0,v0,v1
		stvx	v0,r12,r21			;# vS0[3]
		vadduwm	v0,v0,v1
		stvx	v0,r13,r21			;# vS0[4]
		vadduwm	v0,v0,v1
		stvx	v0,r14,r21			;# vS0[5]
		vadduwm	v0,v0,v1
		stvx	v0,r15,r21			;# vS0[6]
		vadduwm	v0,v0,v1
		stvx	v0,r16,r21			;# vS0[7]
		vadduwm	v0,v0,v1
		stvx	v0,r17,r21			;# vS0[8]
		vadduwm	v0,v0,v1
		stvx	v0,r18,r21			;# vS0[9]
		vadduwm	v0,v0,v1
		stvx	v0,r19,r21			;# vS0[10]
		vadduwm	v0,v0,v1
		stvx	v0,r20,r21			;# vS0[11]
		vadduwm	v0,v0,v1
		stvx	v0,0,r22			;# vS0[12]
		vadduwm	v0,v0,v1
		stvx	v0,r10,r22			;# vS0[13]
		vadduwm	v0,v0,v1
		stvx	v0,r11,r22			;# vS0[14]
		vadduwm	v0,v0,v1
		stvx	v0,r12,r22			;# vS0[15]
		vadduwm	v0,v0,v1
		stvx	v0,r13,r22			;# vS0[16]
		vadduwm	v0,v0,v1
		stvx	v0,r14,r22			;# vS0[17]
		vadduwm	v0,v0,v1
		stvx	v0,r15,r22			;# vS0[18]
		vadduwm	v0,v0,v1
		stvx	v0,r16,r22			;# vS0[19]
		vadduwm	v0,v0,v1
		stvx	v0,r17,r22			;# vS0[20]
		vadduwm	v0,v0,v1
		stvx	v0,r18,r22			;# vS0[21]
		vadduwm	v0,v0,v1
		stvx	v0,r19,r22			;# vS0[22]
		vadduwm	v0,v0,v1
		stvx	v0,r20,r22			;# vS0[23]
		vadduwm	v0,v0,v1
		stvx	v0,0,r23			;# vS0[24]
		vadduwm	v0,v0,v1
		stvx	v0,r10,r23			;# vS0[25]


;# Handle new key.lo value.
;# Load S[0], and compute L[0] and S[1]

new_key_lo:
		lvx		v24,r19,r31			;# vKey
		lvx		v16,0,r21			;# S0[0]
		vspltw	v20,v24,2			;# L[0] = key.lo

		vadduwm	v20,v20,v16			;# L = L[0] + S0[0]
		vrlw	v20,v20,v16			;# B = L[0] = ROTL(L, S0[0])

		lvx		v12,r10,r21			;# S[1]
		vadduwm	v16,v16,v20			;# A += B
		vadduwm	v12,v12,v16			;# S = A + S[1]
		vrlw	v22,v12,v26			;# A = S[1] = ROTL3(S)


;# Handle new key.mid value : Compute L[1] and S[2].
;# Pre-conditions :
;# v24 := vKey
;# v22 := S[1] = A
;# v20 := L[0] = B

new_key_mid:
		vspltw	v21,v24,1			;# L[1] = key.mid
		vadduwm	v16,v22,v20			;# T = A + B
		vadduwm	v21,v21,v16			;# L = L[1] + T
		vrlw	v21,v21,v16			;# B = L[1] = ROTL(L, T)
		lvx		v12,r11,r21			;# S0[2]
		vadduwm	v23,v22,v21			;# A += B
		vspltw	v2,v24,0			;# = key.hi
		vadduwm	v23,v23,v12			;# S = A + S0[2]
		vspltisw v16,4
		vrlw	v23,v23,v26			;# A = S[2] = ROTL3(S)

		;# Setup key.hi
		vadduwm	v2,v2,v27			;# key.hi + (0,1,2,3)
		vadduwm	v5,v2,v16			;# key.hi + (4,5,6,7)
		vadduwm	v8,v5,v16			;# key.hi + (8,9,10,11)
		vadduwm	v11,v8,v16			;# key.hi + (12,13,14,15)

		;# Complete stage #2
		;# Although these instructions could be made part of the inner loop,
		;# it is better to have them at the end of the loop to hide some
		;# latencies.
		vadduwm	v13,v23,v21			;# T1 = T2 = T3 = T4 = A + B
		lvx		v15,r12,r21			;# S0[3] = P + 3.Q
		vadduwm	v2,v2,v13			;# L1[2] += T1
		vadduwm	v5,v5,v13			;# L2[2] += T2
		vadduwm	v8,v8,v13			;# L3[2] += T3
		vadduwm	v11,v11,v13			;# L4[2] += T4
		vadduwm	v15,v15,v23			;# S[3] += A
		vrlw	v2,v2,v13			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v13			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v13			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v13			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		b		new_key_hi

		nop
		.align	4


;# Inner loop (processed at most 16 times).
;# Preconditions :
;# v22 := S[1] (cached, const)
;# v23 := S[2] (cached, const)
;# v20 := L[0] (cached, const)
;# v21 := L[1] (cached, const)
;# v2  := B0
;# v5  := B1
;# v8  := B2
;# v11 := B3
;# v15 := S[3]

new_key_hi:

		;# Stage 3
		vadduwm	v12,v15,v2			;# S1[3] += B1
		vadduwm	v13,v15,v5			;# S2[3] += B2
		vadduwm	v14,v15,v8			;# S3[3] += B3
		vadduwm	v15,v15,v11			;# S4[3] += B4
		vrlw	v28,v12,v26			;# A1 = S1[3] = ROTL3(S1[3] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[3] = ROTL3(S2[3] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[3] = ROTL3(S3[3] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[3] = ROTL3(S4[3] + A4 + B4)

		;# Stage 3-4
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v15,r13,r21			;# S0[4] = P + 4.Q
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r14,r23			;# store S1[3]
		vadduwm	v0,v20,v16			;# L1[0] += T1
		stvx	v29,r16,r25			;# store S2[3]
		vadduwm	v3,v20,v17			;# L2[0] += T2
		stvx	v30,r18,r27			;# store S3[3]
		vadduwm	v6,v20,v18			;# L3[0] += T3
		stvx	v31,r20,r29			;# store S4[3]
		vadduwm	v9,v20,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[4] = S0[4] + A1
		vadduwm	v13,v15,v29			;# S2[4] = S0[4] + A2
		vadduwm	v14,v15,v30			;# S3[4] = S0[4] + A3
		vadduwm	v15,v15,v31			;# S4[4] = S0[4] + A4
		vadduwm	v12,v12,v0			;# S1[4] += B1
		vadduwm	v13,v13,v3			;# S2[4] += B2
		vadduwm	v14,v14,v6			;# S3[4] += B3
		vadduwm	v15,v15,v9			;# S4[4] += B4
		vrlw	v28,v12,v26			;# A1 = S1[4] = ROTL3(S1[4] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[4] = ROTL3(S2[4] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[4] = ROTL3(S3[4] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[4] = ROTL3(S4[4] + A4 + B4)

		;# Stage 4-5
		lvx		v15,r14,r21			;# S0[5] = P + 5.Q
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		vadduwm	v1,v21,v16			;# L1[1] += T1
		stvx	v28,r15,r23			;# store S1[4]
		vadduwm	v4,v21,v17			;# L2[1] += T2
		stvx	v29,r17,r25			;# store S2[4]
		vadduwm	v7,v21,v18			;# L3[1] += T3
		stvx	v30,r19,r27			;# store S3[4]
		vadduwm	v10,v21,v19			;# L4[1] += T4
		stvx	v31,0,r30			;# store S4[4]
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[5] = S0[5] + A1
		vadduwm	v13,v15,v29			;# S2[5] = S0[5] + A2
		vadduwm	v14,v15,v30			;# S3[5] = S0[5] + A3
		vadduwm	v15,v15,v31			;# S4[5] = S0[5] + A4
		vadduwm	v12,v12,v1			;# S1[5] += B1
		vadduwm	v13,v13,v4			;# S2[5] += B2
		vadduwm	v14,v14,v7			;# S3[5] += B3
		vadduwm	v15,v15,v10			;# S4[5] += B4
		vrlw	v28,v12,v26			;# A1 = S1[5] = ROTL3(S1[5] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[5] = ROTL3(S2[5] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[5] = ROTL3(S3[5] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[5] = ROTL3(S4[5] + A4 + B4)

		;# Stage 5-6
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v15,r15,r21			;# S0[6] = P + 6.Q
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r16,r23			;# store S1[5]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r18,r25			;# store S2[5]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r20,r27			;# store S3[5]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r10,r30			;# store S4[5]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[6] = S0[6] + A1
		vadduwm	v13,v15,v29			;# S2[6] = S0[6] + A2
		vadduwm	v14,v15,v30			;# S3[6] = S0[6] + A3
		vadduwm	v15,v15,v31			;# S4[6] = S0[6] + A4
		vadduwm	v12,v12,v2			;# S1[6] += B1
		vadduwm	v13,v13,v5			;# S2[6] += B2
		vadduwm	v14,v14,v8			;# S3[6] += B3
		vadduwm	v15,v15,v11			;# S4[6] += B4
		vrlw	v28,v12,v26			;# A1 = S1[6] = ROTL3(S1[6] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[6] = ROTL3(S2[6] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[6] = ROTL3(S3[6] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[6] = ROTL3(S4[6] + A4 + B4)

		;# Stage 6-7
		lvx		v15,r16,r21			;# S0[7] = P + 7.Q
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v28,r17,r23			;# store S1[6]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v29,r19,r25			;# store S2[6]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v30,0,r28			;# store S3[6]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		stvx	v31,r11,r30			;# store S4[6]
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[7] = S0[7] + A1
		vadduwm	v13,v15,v29			;# S2[7] = S0[7] + A2
		vadduwm	v14,v15,v30			;# S3[7] = S0[7] + A3
		vadduwm	v15,v15,v31			;# S4[7] = S0[7] + A4
		vadduwm	v12,v12,v0			;# S1[7] += B1
		vadduwm	v13,v13,v3			;# S2[7] += B2
		vadduwm	v14,v14,v6			;# S3[7] += B3
		vadduwm	v15,v15,v9			;# S4[7] += B4
		vrlw	v28,v12,v26			;# A1 = S1[7] = ROTL3(S1[7] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[7] = ROTL3(S2[7] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[7] = ROTL3(S3[7] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[7] = ROTL3(S4[7] + A4 + B4)

		;# Stage 7-8
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v15,r17,r21			;# S0[8] = P + 8.Q
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r18,r23			;# store S1[7]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r20,r25			;# store S2[7]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r10,r28			;# store S3[7]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r12,r30			;# store S4[7]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[8] = S0[8] + A1
		vadduwm	v13,v15,v29			;# S2[8] = S0[8] + A2
		vadduwm	v14,v15,v30			;# S3[8] = S0[8] + A3
		vadduwm	v15,v15,v31			;# S4[8] = S0[8] + A4
		vadduwm	v12,v12,v1			;# S1[8] += B1
		vadduwm	v13,v13,v4			;# S2[8] += B2
		vadduwm	v14,v14,v7			;# S3[8] += B3
		vadduwm	v15,v15,v10			;# S4[8] += B4
		vrlw	v28,v12,v26			;# A1 = S1[8] = ROTL3(S1[8] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[8] = ROTL3(S2[8] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[8] = ROTL3(S3[8] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[8] = ROTL3(S4[8] + A4 + B4)

		;# Stage 8-9
		lvx		v15,r18,r21			;# S0[9] = P + 9.Q
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v28,r19,r23			;# store S1[8]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v29,0,r26			;# store S2[8]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v30,r11,r28			;# store S3[8]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		stvx	v31,r13,r30			;# store S4[8]
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[9] = S0[9] + A1
		vadduwm	v13,v15,v29			;# S2[9] = S0[9] + A2
		vadduwm	v14,v15,v30			;# S3[9] = S0[9] + A3
		vadduwm	v15,v15,v31			;# S4[9] = S0[9] + A4
		vadduwm	v12,v12,v2			;# S1[9] += B1
		vadduwm	v13,v13,v5			;# S2[9] += B2
		vadduwm	v14,v14,v8			;# S3[9] += B3
		vadduwm	v15,v15,v11			;# S4[9] += B4
		vrlw	v28,v12,v26			;# A1 = S1[9] = ROTL3(S1[9] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[9] = ROTL3(S2[9] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[9] = ROTL3(S3[9] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[9] = ROTL3(S4[9] + A4 + B4)

		;# Stage 9-10
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v15,r19,r21			;# S0[10] = P + 10.Q
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r20,r23			;# store S1[9]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r10,r26			;# store S2[9]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r12,r28			;# store S3[9]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r14,r30			;# store S4[9]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[10] = S0[10] + A1
		vadduwm	v13,v15,v29			;# S2[10] = S0[10] + A2
		vadduwm	v14,v15,v30			;# S3[10] = S0[10] + A3
		vadduwm	v15,v15,v31			;# S4[10] = S0[10] + A4
		vadduwm	v12,v12,v0			;# S1[10] += B1
		vadduwm	v13,v13,v3			;# S2[10] += B2
		vadduwm	v14,v14,v6			;# S3[10] += B3
		vadduwm	v15,v15,v9			;# S4[10] += B4
		vrlw	v28,v12,v26			;# A1 = S1[10] = ROTL3(S1[10] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[10] = ROTL3(S2[10] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[10] = ROTL3(S3[10] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[10] = ROTL3(S4[10] + A4 + B4)

		;# Stage 10-11
		lvx		v15,r20,r21			;# S0[11] = P + 11.Q
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v28,0,r24			;# store S1[10]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v29,r11,r26			;# store S2[10]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v30,r13,r28			;# store S3[10]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		stvx	v31,r15,r30			;# store S4[10]
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[11] = S0[11] + A1
		vadduwm	v13,v15,v29			;# S2[11] = S0[11] + A2
		vadduwm	v14,v15,v30			;# S3[11] = S0[11] + A3
		vadduwm	v15,v15,v31			;# S4[11] = S0[11] + A4
		vadduwm	v12,v12,v1			;# S1[11] += B1
		vadduwm	v13,v13,v4			;# S2[11] += B2
		vadduwm	v14,v14,v7			;# S3[11] += B3
		vadduwm	v15,v15,v10			;# S4[11] += B4
		vrlw	v28,v12,v26			;# A1 = S1[11] = ROTL3(S1[11] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[11] = ROTL3(S2[11] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[11] = ROTL3(S3[11] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[11] = ROTL3(S4[11] + A4 + B4)

		;# Stage 11-12
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v15,0,r22			;# S0[12] = P + 12.Q
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r10,r24			;# store S1[11]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r12,r26			;# store S2[11]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r14,r28			;# store S3[11]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r16,r30			;# store S4[11]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[12] = S0[12] + A1
		vadduwm	v13,v15,v29			;# S2[12] = S0[12] + A2
		vadduwm	v14,v15,v30			;# S3[12] = S0[12] + A3
		vadduwm	v15,v15,v31			;# S4[12] = S0[12] + A4
		vadduwm	v12,v12,v2			;# S1[12] += B1
		vadduwm	v13,v13,v5			;# S2[12] += B2
		vadduwm	v14,v14,v8			;# S3[12] += B3
		vadduwm	v15,v15,v11			;# S4[12] += B4
		vrlw	v28,v12,v26			;# A1 = S1[12] = ROTL3(S1[12] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[12] = ROTL3(S2[12] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[12] = ROTL3(S3[12] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[12] = ROTL3(S4[12] + A4 + B4)

		;# Stage 12-13
		lvx		v15,r10,r22			;# S0[13] = P + 13.Q
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v28,r11,r24			;# store S1[12]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v29,r13,r26			;# store S2[12]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v30,r15,r28			;# store S3[12]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		stvx	v31,r17,r30			;# store S4[12]
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[13] = S0[13] + A1
		vadduwm	v13,v15,v29			;# S2[13] = S0[13] + A2
		vadduwm	v14,v15,v30			;# S3[13] = S0[13] + A3
		vadduwm	v15,v15,v31			;# S4[13] = S0[13] + A4
		vadduwm	v12,v12,v0			;# S1[13] += B1
		vadduwm	v13,v13,v3			;# S2[13] += B2
		vadduwm	v14,v14,v6			;# S3[13] += B3
		vadduwm	v15,v15,v9			;# S4[13] += B4
		vrlw	v28,v12,v26			;# A1 = S1[13] = ROTL3(S1[13] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[13] = ROTL3(S2[13] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[13] = ROTL3(S3[13] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[13] = ROTL3(S4[13] + A4 + B4)

		;# Stage 13-14
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v15,r11,r22			;# S0[14] = P + 14.Q
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r12,r24			;# store S1[13]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r14,r26			;# store S2[13]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r16,r28			;# store S3[13]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r18,r30			;# store S4[13]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[14] = S0[14] + A1
		vadduwm	v13,v15,v29			;# S2[14] = S0[14] + A2
		vadduwm	v14,v15,v30			;# S3[14] = S0[14] + A3
		vadduwm	v15,v15,v31			;# S4[14] = S0[14] + A4
		vadduwm	v12,v12,v1			;# S1[14] += B1
		vadduwm	v13,v13,v4			;# S2[14] += B2
		vadduwm	v14,v14,v7			;# S3[14] += B3
		vadduwm	v15,v15,v10			;# S4[14] += B4
		vrlw	v28,v12,v26			;# A1 = S1[14] = ROTL3(S1[14] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[14] = ROTL3(S2[14] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[14] = ROTL3(S3[14] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[14] = ROTL3(S4[14] + A4 + B4)

		;# Stage 14-15
		lvx		v15,r12,r22			;# S0[15] = P + 15.Q
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v28,r13,r24			;# store S1[14]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v29,r15,r26			;# store S2[14]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v30,r17,r28			;# store S3[14]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		stvx	v31,r19,r30			;# store S4[14]
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[15] = S0[15] + A1
		vadduwm	v13,v15,v29			;# S2[15] = S0[15] + A2
		vadduwm	v14,v15,v30			;# S3[15] = S0[15] + A3
		vadduwm	v15,v15,v31			;# S4[15] = S0[15] + A4
		vadduwm	v12,v12,v2			;# S1[15] += B1
		vadduwm	v13,v13,v5			;# S2[15] += B2
		vadduwm	v14,v14,v8			;# S3[15] += B3
		vadduwm	v15,v15,v11			;# S4[15] += B4
		vrlw	v28,v12,v26			;# A1 = S1[15] = ROTL3(S1[15] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[15] = ROTL3(S2[15] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[15] = ROTL3(S3[15] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[15] = ROTL3(S4[15] + A4 + B4)

		;# Stage 15-16
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v15,r13,r22			;# S0[16] = P + 16.Q
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r14,r24			;# store S1[15]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r16,r26			;# store S2[15]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r18,r28			;# store S3[15]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r20,r30			;# store S4[15]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[16] = S0[16] + A1
		vadduwm	v13,v15,v29			;# S2[16] = S0[16] + A2
		vadduwm	v14,v15,v30			;# S3[16] = S0[16] + A3
		vadduwm	v15,v15,v31			;# S4[16] = S0[16] + A4
		vadduwm	v12,v12,v0			;# S1[16] += B1
		vadduwm	v13,v13,v3			;# S2[16] += B2
		vadduwm	v14,v14,v6			;# S3[16] += B3
		vadduwm	v15,v15,v9			;# S4[16] += B4
		vrlw	v28,v12,v26			;# A1 = S1[16] = ROTL3(S1[16] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[16] = ROTL3(S2[16] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[16] = ROTL3(S3[16] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[16] = ROTL3(S4[16] + A4 + B4)

		;# Stage 16-17
		lvx		v15,r14,r22			;# S0[17] = P + 17.Q
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v28,r15,r24			;# store S1[16]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v29,r17,r26			;# store S2[16]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v30,r19,r28			;# store S3[16]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		stvx	v31,0,r31			;# store S4[16]
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[17] = S0[17] + A1
		vadduwm	v13,v15,v29			;# S2[17] = S0[17] + A2
		vadduwm	v14,v15,v30			;# S3[17] = S0[17] + A3
		vadduwm	v15,v15,v31			;# S4[17] = S0[17] + A4
		vadduwm	v12,v12,v1			;# S1[17] += B1
		vadduwm	v13,v13,v4			;# S2[17] += B2
		vadduwm	v14,v14,v7			;# S3[17] += B3
		vadduwm	v15,v15,v10			;# S4[17] += B4
		vrlw	v28,v12,v26			;# A1 = S1[17] = ROTL3(S1[17] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[17] = ROTL3(S2[17] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[17] = ROTL3(S3[17] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[17] = ROTL3(S4[17] + A4 + B4)

		;# Stage 17-18
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v15,r15,r22			;# S0[18] = P + 18.Q
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r16,r24			;# store S1[17]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r18,r26			;# store S2[17]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r20,r28			;# store S3[17]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r10,r31			;# store S4[17]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[18] = S0[18] + A1
		vadduwm	v13,v15,v29			;# S2[18] = S0[18] + A2
		vadduwm	v14,v15,v30			;# S3[18] = S0[18] + A3
		vadduwm	v15,v15,v31			;# S4[18] = S0[18] + A4
		vadduwm	v12,v12,v2			;# S1[18] += B1
		vadduwm	v13,v13,v5			;# S2[18] += B2
		vadduwm	v14,v14,v8			;# S3[18] += B3
		vadduwm	v15,v15,v11			;# S4[18] += B4
		vrlw	v28,v12,v26			;# A1 = S1[18] = ROTL3(S1[18] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[18] = ROTL3(S2[18] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[18] = ROTL3(S3[18] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[18] = ROTL3(S4[18] + A4 + B4)

		;# Stage 18-19
		lvx		v15,r16,r22			;# S0[19] = P + 19.Q
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v28,r17,r24			;# store S1[18]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v29,r19,r26			;# store S2[18]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v30,0,r29			;# store S3[18]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		stvx	v31,r11,r31			;# store S4[18]
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[19] = S0[19] + A1
		vadduwm	v13,v15,v29			;# S2[19] = S0[19] + A2
		vadduwm	v14,v15,v30			;# S3[19] = S0[19] + A3
		vadduwm	v15,v15,v31			;# S4[19] = S0[19] + A4
		vadduwm	v12,v12,v0			;# S1[19] += B1
		vadduwm	v13,v13,v3			;# S2[19] += B2
		vadduwm	v14,v14,v6			;# S3[19] += B3
		vadduwm	v15,v15,v9			;# S4[19] += B4
		vrlw	v28,v12,v26			;# A1 = S1[19] = ROTL3(S1[19] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[19] = ROTL3(S2[19] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[19] = ROTL3(S3[19] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[19] = ROTL3(S4[19] + A4 + B4)

		;# Stage 19-20
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v15,r17,r22			;# S0[20] = P + 20.Q
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r18,r24			;# store S1[19]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r20,r26			;# store S2[19]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r10,r29			;# store S3[19]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r12,r31			;# store S4[19]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[20] = S0[20] + A1
		vadduwm	v13,v15,v29			;# S2[20] = S0[20] + A2
		vadduwm	v14,v15,v30			;# S3[20] = S0[20] + A3
		vadduwm	v15,v15,v31			;# S4[20] = S0[20] + A4
		vadduwm	v12,v12,v1			;# S1[20] += B1
		vadduwm	v13,v13,v4			;# S2[20] += B2
		vadduwm	v14,v14,v7			;# S3[20] += B3
		vadduwm	v15,v15,v10			;# S4[20] += B4
		vrlw	v28,v12,v26			;# A1 = S1[20] = ROTL3(S1[20] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[20] = ROTL3(S2[20] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[20] = ROTL3(S3[20] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[20] = ROTL3(S4[20] + A4 + B4)

		;# Stage 20-21
		lvx		v15,r18,r22			;# S0[21] = P + 21.Q
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v28,r19,r24			;# store S1[20]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v29,0,r27			;# store S2[20]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v30,r11,r29			;# store S3[20]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		stvx	v31,r13,r31			;# store S4[20]
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[21] = S0[21] + A1
		vadduwm	v13,v15,v29			;# S2[21] = S0[21] + A2
		vadduwm	v14,v15,v30			;# S3[21] = S0[21] + A3
		vadduwm	v15,v15,v31			;# S4[21] = S0[21] + A4
		vadduwm	v12,v12,v2			;# S1[21] += B1
		vadduwm	v13,v13,v5			;# S2[21] += B2
		vadduwm	v14,v14,v8			;# S3[21] += B3
		vadduwm	v15,v15,v11			;# S4[21] += B4
		vrlw	v28,v12,v26			;# A1 = S1[21] = ROTL3(S1[21] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[21] = ROTL3(S2[21] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[21] = ROTL3(S3[21] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[21] = ROTL3(S4[21] + A4 + B4)

		;# Stage 21-22
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v15,r19,r22			;# S0[22] = P + 22.Q
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r20,r24			;# store S1[21]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r10,r27			;# store S2[21]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r12,r29			;# store S3[21]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r14,r31			;# store S4[21]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[22] = S0[22] + A1
		vadduwm	v13,v15,v29			;# S2[22] = S0[22] + A2
		vadduwm	v14,v15,v30			;# S3[22] = S0[22] + A3
		vadduwm	v15,v15,v31			;# S4[22] = S0[22] + A4
		vadduwm	v12,v12,v0			;# S1[22] += B1
		vadduwm	v13,v13,v3			;# S2[22] += B2
		vadduwm	v14,v14,v6			;# S3[22] += B3
		vadduwm	v15,v15,v9			;# S4[22] += B4
		vrlw	v28,v12,v26			;# A1 = S1[22] = ROTL3(S1[22] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[22] = ROTL3(S2[22] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[22] = ROTL3(S3[22] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[22] = ROTL3(S4[22] + A4 + B4)

		;# Stage 22-23
		lvx		v15,r20,r22			;# S0[23] = P + 23.Q
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v28,0,r25			;# store S1[22]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v29,r11,r27			;# store S2[22]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v30,r13,r29			;# store S3[22]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		stvx	v31,r15,r31			;# store S4[22]
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[23] = S0[23] + A1
		vadduwm	v13,v15,v29			;# S2[23] = S0[23] + A2
		vadduwm	v14,v15,v30			;# S3[23] = S0[23] + A3
		vadduwm	v15,v15,v31			;# S4[23] = S0[23] + A4
		vadduwm	v12,v12,v1			;# S1[23] += B1
		vadduwm	v13,v13,v4			;# S2[23] += B2
		vadduwm	v14,v14,v7			;# S3[23] += B3
		vadduwm	v15,v15,v10			;# S4[23] += B4
		vrlw	v28,v12,v26			;# A1 = S1[23] = ROTL3(S1[23] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[23] = ROTL3(S2[23] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[23] = ROTL3(S3[23] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[23] = ROTL3(S4[23] + A4 + B4)

		;# Stage 23-24
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v15,0,r23			;# S0[24] = P + 24.Q
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r10,r25			;# store S1[23]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r12,r27			;# store S2[23]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r14,r29			;# store S3[23]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r16,r31			;# store S4[23]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[24] = S0[24] + A1
		vadduwm	v13,v15,v29			;# S2[24] = S0[24] + A2
		vadduwm	v14,v15,v30			;# S3[24] = S0[24] + A3
		vadduwm	v15,v15,v31			;# S4[24] = S0[24] + A4
		vadduwm	v12,v12,v2			;# S1[24] += B1
		vadduwm	v13,v13,v5			;# S2[24] += B2
		vadduwm	v14,v14,v8			;# S3[24] += B3
		vadduwm	v15,v15,v11			;# S4[24] += B4
		vrlw	v28,v12,v26			;# A1 = S1[24] = ROTL3(S1[24] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[24] = ROTL3(S2[24] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[24] = ROTL3(S3[24] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[24] = ROTL3(S4[24] + A4 + B4)

		;# Stage 24-25
		lvx		v15,r10,r23			;# S0[25] = P + 25.Q
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v28,r11,r25			;# store S1[24]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v29,r13,r27			;# store S2[24]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v30,r15,r29			;# store S3[24]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		stvx	v31,r17,r31			;# store S4[24]
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[25] = S0[25] + A1
		vadduwm	v13,v15,v29			;# S2[25] = S0[25] + A2
		vadduwm	v14,v15,v30			;# S3[25] = S0[25] + A3
		vadduwm	v15,v15,v31			;# S4[25] = S0[25] + A4
		vadduwm	v12,v12,v0			;# S1[25] += B1
		vadduwm	v13,v13,v3			;# S2[25] += B2
		vadduwm	v14,v14,v6			;# S3[25] += B3
		vadduwm	v15,v15,v9			;# S4[25] += B4
		vrlw	v28,v12,v26			;# A1 = S1[25] = ROTL3(S1[25] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[25] = ROTL3(S2[25] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[25] = ROTL3(S3[25] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[25] = ROTL3(S4[25] + A4 + B4)

		;# Stage 25-26
		;# S[0] = ROTL3(P)
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v15,0,r21			;# S[0]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r12,r25			;# store S1[25]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r14,r27			;# store S2[25]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r16,r29			;# store S3[25]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r18,r31			;# store S4[25]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v15,v28			;# S1[0] += A1
		vadduwm	v13,v15,v29			;# S2[0] += A2
		vadduwm	v14,v15,v30			;# S3[0] += A3
		vadduwm	v15,v15,v31			;# S4[0] += A4
		vadduwm	v12,v12,v1			;# S1[0] += B1
		vadduwm	v13,v13,v4			;# S2[0] += B2
		vadduwm	v14,v14,v7			;# S3[0] += B3
		vadduwm	v15,v15,v10			;# S4[0] += B4
		vrlw	v28,v12,v26			;# A1 = S1[0] = ROTL3(S1[0] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[0] = ROTL3(S2[0] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[0] = ROTL3(S3[0] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[0] = ROTL3(S4[0] + A4 + B4)

		;# Stage 26-27
		;# v22 = S[1]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r11,r23			;# store S1[0]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r13,r25			;# store S2[0]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r15,r27			;# store S3[0]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r17,r29			;# store S4[0]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v22,v28			;# S1[1] += A1
		vadduwm	v13,v22,v29			;# S2[1] += A2
		vadduwm	v14,v22,v30			;# S3[1] += A3
		vadduwm	v15,v22,v31			;# S4[1] += A4
		vadduwm	v12,v12,v2			;# S1[1] += B1
		vadduwm	v13,v13,v5			;# S2[1] += B2
		vadduwm	v14,v14,v8			;# S3[1] += B3
		vadduwm	v15,v15,v11			;# S4[1] += B4
		vrlw	v28,v12,v26			;# A1 = S1[1] = ROTL3(S1[1] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[1] = ROTL3(S2[1] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[1] = ROTL3(S3[1] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[1] = ROTL3(S4[1] + A4 + B4)

		;# Stage 27-28
		;# v23 = S[2]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r12,r23			;# store S1[1]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r14,r25			;# store S2[1]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r16,r27			;# store S3[1]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r18,r29			;# store S4[1]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v23,v28			;# S1[2] += A1
		vadduwm	v13,v23,v29			;# S2[2] += A2
		vadduwm	v14,v23,v30			;# S3[2] += A3
		vadduwm	v15,v23,v31			;# S4[2] += A4
		vadduwm	v12,v12,v0			;# S1[2] += B1
		vadduwm	v13,v13,v3			;# S2[2] += B2
		vadduwm	v14,v14,v6			;# S3[2] += B3
		vadduwm	v15,v15,v9			;# S4[2] += B4
		vrlw	v28,v12,v26			;# A1 = S1[2] = ROTL3(S1[2] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[2] = ROTL3(S2[2] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[2] = ROTL3(S3[2] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[2] = ROTL3(S4[2] + A4 + B4)

		;# Stage 28-29
		lvx		v12,r14,r23			;# S1[3]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r16,r25			;# S2[3]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r18,r27			;# S3[3]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r20,r29			;# S4[3]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r13,r23			;# store S1[2]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r15,r25			;# store S2[2]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r17,r27			;# store S3[2]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r19,r29			;# store S4[2]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[3] += A1
		vadduwm	v13,v13,v29			;# S2[3] += A2
		vadduwm	v14,v14,v30			;# S3[3] += A3
		vadduwm	v15,v15,v31			;# S4[3] += A4
		vadduwm	v12,v12,v1			;# S1[3] += B1
		vadduwm	v13,v13,v4			;# S2[3] += B2
		vadduwm	v14,v14,v7			;# S3[3] += B3
		vadduwm	v15,v15,v10			;# S4[3] += B4
		vrlw	v28,v12,v26			;# A1 = S1[3] = ROTL3(S1[3] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[3] = ROTL3(S2[3] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[3] = ROTL3(S3[3] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[3] = ROTL3(S4[3] + A4 + B4)

		;# Stage 29-30
		lvx		v12,r15,r23			;# S1[4]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r17,r25			;# S2[4]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r19,r27			;# S3[4]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,0,r30			;# S4[4]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r14,r23			;# store S1[3]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r16,r25			;# store S2[3]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r18,r27			;# store S3[3]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r20,r29			;# store S4[3]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[4] += A1
		vadduwm	v13,v13,v29			;# S2[4] += A2
		vadduwm	v14,v14,v30			;# S3[4] += A3
		vadduwm	v15,v15,v31			;# S4[4] += A4
		vadduwm	v12,v12,v2			;# S1[4] += B1
		vadduwm	v13,v13,v5			;# S2[4] += B2
		vadduwm	v14,v14,v8			;# S3[4] += B3
		vadduwm	v15,v15,v11			;# S4[4] += B4
		vrlw	v28,v12,v26			;# A1 = S1[4] = ROTL3(S1[4] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[4] = ROTL3(S2[4] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[4] = ROTL3(S3[4] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[4] = ROTL3(S4[4] + A4 + B4)

		;# Stage 30-31
		lvx		v12,r16,r23			;# S1[5]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r18,r25			;# S2[5]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r20,r27			;# S3[5]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r10,r30			;# S4[5]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r15,r23			;# store S1[4]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r17,r25			;# store S2[4]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r19,r27			;# store S3[4]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,0,r30			;# store S4[4]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[5] += A1
		vadduwm	v13,v13,v29			;# S2[5] += A2
		vadduwm	v14,v14,v30			;# S3[5] += A3
		vadduwm	v15,v15,v31			;# S4[5] += A4
		vadduwm	v12,v12,v0			;# S1[5] += B1
		vadduwm	v13,v13,v3			;# S2[5] += B2
		vadduwm	v14,v14,v6			;# S3[5] += B3
		vadduwm	v15,v15,v9			;# S4[5] += B4
		vrlw	v28,v12,v26			;# A1 = S1[5] = ROTL3(S1[5] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[5] = ROTL3(S2[5] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[5] = ROTL3(S3[5] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[5] = ROTL3(S4[5] + A4 + B4)

		;# Stage 31-32
		lvx		v12,r17,r23			;# S1[6]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r19,r25			;# S2[6]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,0,r28			;# S3[6]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r11,r30			;# S4[6]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r16,r23			;# store S1[5]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r18,r25			;# store S2[5]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r20,r27			;# store S3[5]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r10,r30			;# store S4[5]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[6] += A1
		vadduwm	v13,v13,v29			;# S2[6] += A2
		vadduwm	v14,v14,v30			;# S3[6] += A3
		vadduwm	v15,v15,v31			;# S4[6] += A4
		vadduwm	v12,v12,v1			;# S1[6] += B1
		vadduwm	v13,v13,v4			;# S2[6] += B2
		vadduwm	v14,v14,v7			;# S3[6] += B3
		vadduwm	v15,v15,v10			;# S4[6] += B4
		vrlw	v28,v12,v26			;# A1 = S1[6] = ROTL3(S1[6] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[6] = ROTL3(S2[6] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[6] = ROTL3(S3[6] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[6] = ROTL3(S4[6] + A4 + B4)

		;# Stage 32-33
		lvx		v12,r18,r23			;# S1[7]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r20,r25			;# S2[7]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r10,r28			;# S3[7]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r12,r30			;# S4[7]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r17,r23			;# store S1[6]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r19,r25			;# store S2[6]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,0,r28			;# store S3[6]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r11,r30			;# store S4[6]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[7] += A1
		vadduwm	v13,v13,v29			;# S2[7] += A2
		vadduwm	v14,v14,v30			;# S3[7] += A3
		vadduwm	v15,v15,v31			;# S4[7] += A4
		vadduwm	v12,v12,v2			;# S1[7] += B1
		vadduwm	v13,v13,v5			;# S2[7] += B2
		vadduwm	v14,v14,v8			;# S3[7] += B3
		vadduwm	v15,v15,v11			;# S4[7] += B4
		vrlw	v28,v12,v26			;# A1 = S1[7] = ROTL3(S1[7] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[7] = ROTL3(S2[7] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[7] = ROTL3(S3[7] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[7] = ROTL3(S4[7] + A4 + B4)

		;# Stage 33-34
		lvx		v12,r19,r23			;# S1[8]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,0,r26			;# S2[8]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r11,r28			;# S3[8]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r13,r30			;# S4[8]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r18,r23			;# store S1[7]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r20,r25			;# store S2[7]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r10,r28			;# store S3[7]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r12,r30			;# store S4[7]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[8] += A1
		vadduwm	v13,v13,v29			;# S2[8] += A2
		vadduwm	v14,v14,v30			;# S3[8] += A3
		vadduwm	v15,v15,v31			;# S4[8] += A4
		vadduwm	v12,v12,v0			;# S1[8] += B1
		vadduwm	v13,v13,v3			;# S2[8] += B2
		vadduwm	v14,v14,v6			;# S3[8] += B3
		vadduwm	v15,v15,v9			;# S4[8] += B4
		vrlw	v28,v12,v26			;# A1 = S1[8] = ROTL3(S1[8] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[8] = ROTL3(S2[8] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[8] = ROTL3(S3[8] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[8] = ROTL3(S4[8] + A4 + B4)

		;# Stage 34-35
		lvx		v12,r20,r23			;# S1[9]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r10,r26			;# S2[9]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r12,r28			;# S3[9]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r14,r30			;# S4[9]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r19,r23			;# store S1[8]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,0,r26			;# store S2[8]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r11,r28			;# store S3[8]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r13,r30			;# store S4[8]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[9] += A1
		vadduwm	v13,v13,v29			;# S2[9] += A2
		vadduwm	v14,v14,v30			;# S3[9] += A3
		vadduwm	v15,v15,v31			;# S4[9] += A4
		vadduwm	v12,v12,v1			;# S1[9] += B1
		vadduwm	v13,v13,v4			;# S2[9] += B2
		vadduwm	v14,v14,v7			;# S3[9] += B3
		vadduwm	v15,v15,v10			;# S4[9] += B4
		vrlw	v28,v12,v26			;# A1 = S1[9] = ROTL3(S1[9] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[9] = ROTL3(S2[9] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[9] = ROTL3(S3[9] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[9] = ROTL3(S4[9] + A4 + B4)

		;# Stage 35-36
		lvx		v12,0,r24			;# S1[10]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r11,r26			;# S2[10]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r13,r28			;# S3[10]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r15,r30			;# S4[10]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r20,r23			;# store S1[9]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r10,r26			;# store S2[9]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r12,r28			;# store S3[9]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r14,r30			;# store S4[9]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[10] += A1
		vadduwm	v13,v13,v29			;# S2[10] += A2
		vadduwm	v14,v14,v30			;# S3[10] += A3
		vadduwm	v15,v15,v31			;# S4[10] += A4
		vadduwm	v12,v12,v2			;# S1[10] += B1
		vadduwm	v13,v13,v5			;# S2[10] += B2
		vadduwm	v14,v14,v8			;# S3[10] += B3
		vadduwm	v15,v15,v11			;# S4[10] += B4
		vrlw	v28,v12,v26			;# A1 = S1[10] = ROTL3(S1[10] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[10] = ROTL3(S2[10] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[10] = ROTL3(S3[10] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[10] = ROTL3(S4[10] + A4 + B4)

		;# Stage 36-37
		lvx		v12,r10,r24			;# S1[11]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r12,r26			;# S2[11]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r14,r28			;# S3[11]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r16,r30			;# S4[11]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,0,r24			;# store S1[10]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r11,r26			;# store S2[10]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r13,r28			;# store S3[10]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r15,r30			;# store S4[10]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[11] += A1
		vadduwm	v13,v13,v29			;# S2[11] += A2
		vadduwm	v14,v14,v30			;# S3[11] += A3
		vadduwm	v15,v15,v31			;# S4[11] += A4
		vadduwm	v12,v12,v0			;# S1[11] += B1
		vadduwm	v13,v13,v3			;# S2[11] += B2
		vadduwm	v14,v14,v6			;# S3[11] += B3
		vadduwm	v15,v15,v9			;# S4[11] += B4
		vrlw	v28,v12,v26			;# A1 = S1[11] = ROTL3(S1[11] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[11] = ROTL3(S2[11] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[11] = ROTL3(S3[11] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[11] = ROTL3(S4[11] + A4 + B4)

		;# Stage 37-38
		lvx		v12,r11,r24			;# S1[12]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r13,r26			;# S2[12]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r15,r28			;# S3[12]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r17,r30			;# S4[12]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r10,r24			;# store S1[11]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r12,r26			;# store S2[11]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r14,r28			;# store S3[11]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r16,r30			;# store S4[11]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[12] += A1
		vadduwm	v13,v13,v29			;# S2[12] += A2
		vadduwm	v14,v14,v30			;# S3[12] += A3
		vadduwm	v15,v15,v31			;# S4[12] += A4
		vadduwm	v12,v12,v1			;# S1[12] += B1
		vadduwm	v13,v13,v4			;# S2[12] += B2
		vadduwm	v14,v14,v7			;# S3[12] += B3
		vadduwm	v15,v15,v10			;# S4[12] += B4
		vrlw	v28,v12,v26			;# A1 = S1[12] = ROTL3(S1[12] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[12] = ROTL3(S2[12] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[12] = ROTL3(S3[12] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[12] = ROTL3(S4[12] + A4 + B4)

		;# Stage 38-39
		lvx		v12,r12,r24			;# S1[13]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r14,r26			;# S2[13]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r16,r28			;# S3[13]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r18,r30			;# S4[13]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r11,r24			;# store S1[12]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r13,r26			;# store S2[12]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r15,r28			;# store S3[12]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r17,r30			;# store S4[12]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[13] += A1
		vadduwm	v13,v13,v29			;# S2[13] += A2
		vadduwm	v14,v14,v30			;# S3[13] += A3
		vadduwm	v15,v15,v31			;# S4[13] += A4
		vadduwm	v12,v12,v2			;# S1[13] += B1
		vadduwm	v13,v13,v5			;# S2[13] += B2
		vadduwm	v14,v14,v8			;# S3[13] += B3
		vadduwm	v15,v15,v11			;# S4[13] += B4
		vrlw	v28,v12,v26			;# A1 = S1[13] = ROTL3(S1[13] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[13] = ROTL3(S2[13] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[13] = ROTL3(S3[13] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[13] = ROTL3(S4[13] + A4 + B4)

		;# Stage 39-40
		lvx		v12,r13,r24			;# S1[14]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r15,r26			;# S2[14]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r17,r28			;# S3[14]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r19,r30			;# S4[14]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r12,r24			;# store S1[13]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r14,r26			;# store S2[13]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r16,r28			;# store S3[13]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r18,r30			;# store S4[13]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[14] += A1
		vadduwm	v13,v13,v29			;# S2[14] += A2
		vadduwm	v14,v14,v30			;# S3[14] += A3
		vadduwm	v15,v15,v31			;# S4[14] += A4
		vadduwm	v12,v12,v0			;# S1[14] += B1
		vadduwm	v13,v13,v3			;# S2[14] += B2
		vadduwm	v14,v14,v6			;# S3[14] += B3
		vadduwm	v15,v15,v9			;# S4[14] += B4
		vrlw	v28,v12,v26			;# A1 = S1[14] = ROTL3(S1[14] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[14] = ROTL3(S2[14] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[14] = ROTL3(S3[14] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[14] = ROTL3(S4[14] + A4 + B4)

		;# Stage 40-41
		lvx		v12,r14,r24			;# S1[15]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r16,r26			;# S2[15]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r18,r28			;# S3[15]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r20,r30			;# S4[15]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r13,r24			;# store S1[14]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r15,r26			;# store S2[14]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r17,r28			;# store S3[14]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r19,r30			;# store S4[14]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[15] += A1
		vadduwm	v13,v13,v29			;# S2[15] += A2
		vadduwm	v14,v14,v30			;# S3[15] += A3
		vadduwm	v15,v15,v31			;# S4[15] += A4
		vadduwm	v12,v12,v1			;# S1[15] += B1
		vadduwm	v13,v13,v4			;# S2[15] += B2
		vadduwm	v14,v14,v7			;# S3[15] += B3
		vadduwm	v15,v15,v10			;# S4[15] += B4
		vrlw	v28,v12,v26			;# A1 = S1[15] = ROTL3(S1[15] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[15] = ROTL3(S2[15] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[15] = ROTL3(S3[15] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[15] = ROTL3(S4[15] + A4 + B4)

		;# Stage 41-42
		lvx		v12,r15,r24			;# S1[16]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r17,r26			;# S2[16]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r19,r28			;# S3[16]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,0,r31			;# S4[16]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r14,r24			;# store S1[15]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r16,r26			;# store S2[15]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r18,r28			;# store S3[15]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r20,r30			;# store S4[15]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[16] += A1
		vadduwm	v13,v13,v29			;# S2[16] += A2
		vadduwm	v14,v14,v30			;# S3[16] += A3
		vadduwm	v15,v15,v31			;# S4[16] += A4
		vadduwm	v12,v12,v2			;# S1[16] += B1
		vadduwm	v13,v13,v5			;# S2[16] += B2
		vadduwm	v14,v14,v8			;# S3[16] += B3
		vadduwm	v15,v15,v11			;# S4[16] += B4
		vrlw	v28,v12,v26			;# A1 = S1[16] = ROTL3(S1[16] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[16] = ROTL3(S2[16] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[16] = ROTL3(S3[16] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[16] = ROTL3(S4[16] + A4 + B4)

		;# Stage 42-43
		lvx		v12,r16,r24			;# S1[17]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r18,r26			;# S2[17]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r20,r28			;# S3[17]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r10,r31			;# S4[17]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r15,r24			;# store S1[16]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r17,r26			;# store S2[16]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r19,r28			;# store S3[16]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,0,r31			;# store S4[16]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[17] += A1
		vadduwm	v13,v13,v29			;# S2[17] += A2
		vadduwm	v14,v14,v30			;# S3[17] += A3
		vadduwm	v15,v15,v31			;# S4[17] += A4
		vadduwm	v12,v12,v0			;# S1[17] += B1
		vadduwm	v13,v13,v3			;# S2[17] += B2
		vadduwm	v14,v14,v6			;# S3[17] += B3
		vadduwm	v15,v15,v9			;# S4[17] += B4
		vrlw	v28,v12,v26			;# A1 = S1[17] = ROTL3(S1[17] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[17] = ROTL3(S2[17] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[17] = ROTL3(S3[17] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[17] = ROTL3(S4[17] + A4 + B4)

		;# Stage 43-44
		lvx		v12,r17,r24			;# S1[18]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r19,r26			;# S2[18]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,0,r29			;# S3[18]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r11,r31			;# S4[18]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r16,r24			;# store S1[17]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r18,r26			;# store S2[17]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r20,r28			;# store S3[17]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r10,r31			;# store S4[17]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[18] += A1
		vadduwm	v13,v13,v29			;# S2[18] += A2
		vadduwm	v14,v14,v30			;# S3[18] += A3
		vadduwm	v15,v15,v31			;# S4[18] += A4
		vadduwm	v12,v12,v1			;# S1[18] += B1
		vadduwm	v13,v13,v4			;# S2[18] += B2
		vadduwm	v14,v14,v7			;# S3[18] += B3
		vadduwm	v15,v15,v10			;# S4[18] += B4
		vrlw	v28,v12,v26			;# A1 = S1[18] = ROTL3(S1[18] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[18] = ROTL3(S2[18] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[18] = ROTL3(S3[18] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[18] = ROTL3(S4[18] + A4 + B4)

		;# Stage 44-45
		lvx		v12,r18,r24			;# S1[19]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r20,r26			;# S2[19]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r10,r29			;# S3[19]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r12,r31			;# S4[19]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r17,r24			;# store S1[18]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r19,r26			;# store S2[18]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,0,r29			;# store S3[18]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r11,r31			;# store S4[18]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[19] += A1
		vadduwm	v13,v13,v29			;# S2[19] += A2
		vadduwm	v14,v14,v30			;# S3[19] += A3
		vadduwm	v15,v15,v31			;# S4[19] += A4
		vadduwm	v12,v12,v2			;# S1[19] += B1
		vadduwm	v13,v13,v5			;# S2[19] += B2
		vadduwm	v14,v14,v8			;# S3[19] += B3
		vadduwm	v15,v15,v11			;# S4[19] += B4
		vrlw	v28,v12,v26			;# A1 = S1[19] = ROTL3(S1[19] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[19] = ROTL3(S2[19] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[19] = ROTL3(S3[19] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[19] = ROTL3(S4[19] + A4 + B4)

		;# Stage 45-46
		lvx		v12,r19,r24			;# S1[20]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,0,r27			;# S2[20]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r11,r29			;# S3[20]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r13,r31			;# S4[20]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r18,r24			;# store S1[19]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r20,r26			;# store S2[19]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r10,r29			;# store S3[19]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r12,r31			;# store S4[19]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[20] += A1
		vadduwm	v13,v13,v29			;# S2[20] += A2
		vadduwm	v14,v14,v30			;# S3[20] += A3
		vadduwm	v15,v15,v31			;# S4[20] += A4
		vadduwm	v12,v12,v0			;# S1[20] += B1
		vadduwm	v13,v13,v3			;# S2[20] += B2
		vadduwm	v14,v14,v6			;# S3[20] += B3
		vadduwm	v15,v15,v9			;# S4[20] += B4
		vrlw	v28,v12,v26			;# A1 = S1[20] = ROTL3(S1[20] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[20] = ROTL3(S2[20] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[20] = ROTL3(S3[20] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[20] = ROTL3(S4[20] + A4 + B4)

		;# Stage 46-47
		lvx		v12,r20,r24			;# S1[21]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r10,r27			;# S2[21]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r12,r29			;# S3[21]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r14,r31			;# S4[21]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r19,r24			;# store S1[20]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,0,r27			;# store S2[20]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r11,r29			;# store S3[20]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r13,r31			;# store S4[20]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[21] += A1
		vadduwm	v13,v13,v29			;# S2[21] += A2
		vadduwm	v14,v14,v30			;# S3[21] += A3
		vadduwm	v15,v15,v31			;# S4[21] += A4
		vadduwm	v12,v12,v1			;# S1[21] += B1
		vadduwm	v13,v13,v4			;# S2[21] += B2
		vadduwm	v14,v14,v7			;# S3[21] += B3
		vadduwm	v15,v15,v10			;# S4[21] += B4
		vrlw	v28,v12,v26			;# A1 = S1[21] = ROTL3(S1[21] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[21] = ROTL3(S2[21] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[21] = ROTL3(S3[21] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[21] = ROTL3(S4[21] + A4 + B4)

		;# Stage 47-48
		lvx		v12,0,r25			;# S1[22]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r11,r27			;# S2[22]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r13,r29			;# S3[22]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r15,r31			;# S4[22]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r20,r24			;# store S1[21]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r10,r27			;# store S2[21]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r12,r29			;# store S3[21]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r14,r31			;# store S4[21]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[22] += A1
		vadduwm	v13,v13,v29			;# S2[22] += A2
		vadduwm	v14,v14,v30			;# S3[22] += A3
		vadduwm	v15,v15,v31			;# S4[22] += A4
		vadduwm	v12,v12,v2			;# S1[22] += B1
		vadduwm	v13,v13,v5			;# S2[22] += B2
		vadduwm	v14,v14,v8			;# S3[22] += B3
		vadduwm	v15,v15,v11			;# S4[22] += B4
		vrlw	v28,v12,v26			;# A1 = S1[22] = ROTL3(S1[22] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[22] = ROTL3(S2[22] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[22] = ROTL3(S3[22] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[22] = ROTL3(S4[22] + A4 + B4)

		;# Stage 48-49
		lvx		v12,r10,r25			;# S1[23]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r12,r27			;# S2[23]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r14,r29			;# S3[23]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r16,r31			;# S4[23]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,0,r25			;# store S1[22]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r11,r27			;# store S2[22]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r13,r29			;# store S3[22]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r15,r31			;# store S4[22]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[23] += A1
		vadduwm	v13,v13,v29			;# S2[23] += A2
		vadduwm	v14,v14,v30			;# S3[23] += A3
		vadduwm	v15,v15,v31			;# S4[23] += A4
		vadduwm	v12,v12,v0			;# S1[23] += B1
		vadduwm	v13,v13,v3			;# S2[23] += B2
		vadduwm	v14,v14,v6			;# S3[23] += B3
		vadduwm	v15,v15,v9			;# S4[23] += B4
		vrlw	v28,v12,v26			;# A1 = S1[23] = ROTL3(S1[23] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[23] = ROTL3(S2[23] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[23] = ROTL3(S3[23] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[23] = ROTL3(S4[23] + A4 + B4)

		;# Stage 49-50
		lvx		v12,r11,r25			;# S1[24]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r13,r27			;# S2[24]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r15,r29			;# S3[24]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r17,r31			;# S4[24]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r10,r25			;# store S1[23]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r12,r27			;# store S2[23]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r14,r29			;# store S3[23]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r16,r31			;# store S4[23]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[24] += A1
		vadduwm	v13,v13,v29			;# S2[24] += A2
		vadduwm	v14,v14,v30			;# S3[24] += A3
		vadduwm	v15,v15,v31			;# S4[24] += A4
		vadduwm	v12,v12,v1			;# S1[24] += B1
		vadduwm	v13,v13,v4			;# S2[24] += B2
		vadduwm	v14,v14,v7			;# S3[24] += B3
		vadduwm	v15,v15,v10			;# S4[24] += B4
		vrlw	v28,v12,v26			;# A1 = S1[24] = ROTL3(S1[24] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[24] = ROTL3(S2[24] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[24] = ROTL3(S3[24] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[24] = ROTL3(S4[24] + A4 + B4)

		;# Stage 50-51
		lvx		v12,r12,r25			;# S1[25]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r14,r27			;# S2[25]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r16,r29			;# S3[25]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r18,r31			;# S4[25]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r11,r25			;# store S1[24]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r13,r27			;# store S2[24]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r15,r29			;# store S3[24]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r17,r31			;# store S4[24]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[25] += A1
		vadduwm	v13,v13,v29			;# S2[25] += A2
		vadduwm	v14,v14,v30			;# S3[25] += A3
		vadduwm	v15,v15,v31			;# S4[25] += A4
		vadduwm	v12,v12,v2			;# S1[25] += B1
		vadduwm	v13,v13,v5			;# S2[25] += B2
		vadduwm	v14,v14,v8			;# S3[25] += B3
		vadduwm	v15,v15,v11			;# S4[25] += B4
		vrlw	v28,v12,v26			;# A1 = S1[25] = ROTL3(S1[25] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[25] = ROTL3(S2[25] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[25] = ROTL3(S3[25] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[25] = ROTL3(S4[25] + A4 + B4)

		;# Stage 51-52
		lvx		v12,r11,r23			;# S1[0]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r13,r25			;# S2[0]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r15,r27			;# S3[0]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r17,r29			;# S4[0]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r12,r25			;# store S1[25]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r14,r27			;# store S2[25]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r16,r29			;# store S3[25]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r18,r31			;# store S4[25]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[0] += A1
		vadduwm	v13,v13,v29			;# S2[0] += A2
		vadduwm	v14,v14,v30			;# S3[0] += A3
		vadduwm	v15,v15,v31			;# S4[0] += A4
		vadduwm	v12,v12,v0			;# S1[0] += B1
		vadduwm	v13,v13,v3			;# S2[0] += B2
		vadduwm	v14,v14,v6			;# S3[0] += B3
		vadduwm	v15,v15,v9			;# S4[0] += B4
		vrlw	v28,v12,v26			;# A1 = S1[0] = ROTL3(S1[0] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[0] = ROTL3(S2[0] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[0] = ROTL3(S3[0] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[0] = ROTL3(S4[0] + A4 + B4)

		;# Stage 52-53
		lvx		v12,r12,r23			;# S1[1]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r14,r25			;# S2[1]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r16,r27			;# S3[1]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r18,r29			;# S4[1]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r11,r23			;# store S1[0]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r13,r25			;# store S2[0]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r15,r27			;# store S3[0]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r17,r29			;# store S4[0]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[1] += A1
		vadduwm	v13,v13,v29			;# S2[1] += A2
		vadduwm	v14,v14,v30			;# S3[1] += A3
		vadduwm	v15,v15,v31			;# S4[1] += A4
		vadduwm	v12,v12,v1			;# S1[1] += B1
		vadduwm	v13,v13,v4			;# S2[1] += B2
		vadduwm	v14,v14,v7			;# S3[1] += B3
		vadduwm	v15,v15,v10			;# S4[1] += B4
		vrlw	v28,v12,v26			;# A1 = S1[1] = ROTL3(S1[1] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[1] = ROTL3(S2[1] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[1] = ROTL3(S3[1] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[1] = ROTL3(S4[1] + A4 + B4)

		;# Stage 53-54
		lvx		v12,r13,r23			;# S1[2]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r15,r25			;# S2[2]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r17,r27			;# S3[2]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r19,r29			;# S4[2]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r12,r23			;# store S1[1]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r14,r25			;# store S2[1]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r16,r27			;# store S3[1]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r18,r29			;# store S4[1]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[2] += A1
		vadduwm	v13,v13,v29			;# S2[2] += A2
		vadduwm	v14,v14,v30			;# S3[2] += A3
		vadduwm	v15,v15,v31			;# S4[2] += A4
		vadduwm	v12,v12,v2			;# S1[2] += B1
		vadduwm	v13,v13,v5			;# S2[2] += B2
		vadduwm	v14,v14,v8			;# S3[2] += B3
		vadduwm	v15,v15,v11			;# S4[2] += B4
		vrlw	v28,v12,v26			;# A1 = S1[2] = ROTL3(S1[2] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[2] = ROTL3(S2[2] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[2] = ROTL3(S3[2] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[2] = ROTL3(S4[2] + A4 + B4)

		;# Stage 54-55
		lvx		v12,r14,r23			;# S1[3]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r16,r25			;# S2[3]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r18,r27			;# S3[3]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r20,r29			;# S4[3]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r13,r23			;# store S1[2]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r15,r25			;# store S2[2]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r17,r27			;# store S3[2]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r19,r29			;# store S4[2]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[3] += A1
		vadduwm	v13,v13,v29			;# S2[3] += A2
		vadduwm	v14,v14,v30			;# S3[3] += A3
		vadduwm	v15,v15,v31			;# S4[3] += A4
		vadduwm	v12,v12,v0			;# S1[3] += B1
		vadduwm	v13,v13,v3			;# S2[3] += B2
		vadduwm	v14,v14,v6			;# S3[3] += B3
		vadduwm	v15,v15,v9			;# S4[3] += B4
		vrlw	v28,v12,v26			;# A1 = S1[3] = ROTL3(S1[3] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[3] = ROTL3(S2[3] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[3] = ROTL3(S3[3] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[3] = ROTL3(S4[3] + A4 + B4)

		;# Stage 55-56
		lvx		v12,r15,r23			;# S1[4]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r17,r25			;# S2[4]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r19,r27			;# S3[4]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,0,r30			;# S4[4]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r14,r23			;# store S1[3]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r16,r25			;# store S2[3]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r18,r27			;# store S3[3]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r20,r29			;# store S4[3]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[4] += A1
		vadduwm	v13,v13,v29			;# S2[4] += A2
		vadduwm	v14,v14,v30			;# S3[4] += A3
		vadduwm	v15,v15,v31			;# S4[4] += A4
		vadduwm	v12,v12,v1			;# S1[4] += B1
		vadduwm	v13,v13,v4			;# S2[4] += B2
		vadduwm	v14,v14,v7			;# S3[4] += B3
		vadduwm	v15,v15,v10			;# S4[4] += B4
		vrlw	v28,v12,v26			;# A1 = S1[4] = ROTL3(S1[4] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[4] = ROTL3(S2[4] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[4] = ROTL3(S3[4] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[4] = ROTL3(S4[4] + A4 + B4)

		;# Stage 56-57
		lvx		v12,r16,r23			;# S1[5]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r18,r25			;# S2[5]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r20,r27			;# S3[5]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r10,r30			;# S4[5]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r15,r23			;# store S1[4]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r17,r25			;# store S2[4]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r19,r27			;# store S3[4]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,0,r30			;# store S4[4]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[5] += A1
		vadduwm	v13,v13,v29			;# S2[5] += A2
		vadduwm	v14,v14,v30			;# S3[5] += A3
		vadduwm	v15,v15,v31			;# S4[5] += A4
		vadduwm	v12,v12,v2			;# S1[5] += B1
		vadduwm	v13,v13,v5			;# S2[5] += B2
		vadduwm	v14,v14,v8			;# S3[5] += B3
		vadduwm	v15,v15,v11			;# S4[5] += B4
		vrlw	v28,v12,v26			;# A1 = S1[5] = ROTL3(S1[5] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[5] = ROTL3(S2[5] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[5] = ROTL3(S3[5] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[5] = ROTL3(S4[5] + A4 + B4)

		;# Stage 57-58
		lvx		v12,r17,r23			;# S1[6]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r19,r25			;# S2[6]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,0,r28			;# S3[6]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r11,r30			;# S4[6]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r16,r23			;# store S1[5]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r18,r25			;# store S2[5]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r20,r27			;# store S3[5]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r10,r30			;# store S4[5]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[6] += A1
		vadduwm	v13,v13,v29			;# S2[6] += A2
		vadduwm	v14,v14,v30			;# S3[6] += A3
		vadduwm	v15,v15,v31			;# S4[6] += A4
		vadduwm	v12,v12,v0			;# S1[6] += B1
		vadduwm	v13,v13,v3			;# S2[6] += B2
		vadduwm	v14,v14,v6			;# S3[6] += B3
		vadduwm	v15,v15,v9			;# S4[6] += B4
		vrlw	v28,v12,v26			;# A1 = S1[6] = ROTL3(S1[6] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[6] = ROTL3(S2[6] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[6] = ROTL3(S3[6] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[6] = ROTL3(S4[6] + A4 + B4)

		;# Stage 58-59
		lvx		v12,r18,r23			;# S1[7]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r20,r25			;# S2[7]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r10,r28			;# S3[7]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r12,r30			;# S4[7]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r17,r23			;# store S1[6]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r19,r25			;# store S2[6]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,0,r28			;# store S3[6]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r11,r30			;# store S4[6]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[7] += A1
		vadduwm	v13,v13,v29			;# S2[7] += A2
		vadduwm	v14,v14,v30			;# S3[7] += A3
		vadduwm	v15,v15,v31			;# S4[7] += A4
		vadduwm	v12,v12,v1			;# S1[7] += B1
		vadduwm	v13,v13,v4			;# S2[7] += B2
		vadduwm	v14,v14,v7			;# S3[7] += B3
		vadduwm	v15,v15,v10			;# S4[7] += B4
		vrlw	v28,v12,v26			;# A1 = S1[7] = ROTL3(S1[7] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[7] = ROTL3(S2[7] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[7] = ROTL3(S3[7] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[7] = ROTL3(S4[7] + A4 + B4)

		;# Stage 59-60
		lvx		v12,r19,r23			;# S1[8]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,0,r26			;# S2[8]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r11,r28			;# S3[8]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r13,r30			;# S4[8]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r18,r23			;# store S1[7]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r20,r25			;# store S2[7]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r10,r28			;# store S3[7]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r12,r30			;# store S4[7]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[8] += A1
		vadduwm	v13,v13,v29			;# S2[8] += A2
		vadduwm	v14,v14,v30			;# S3[8] += A3
		vadduwm	v15,v15,v31			;# S4[8] += A4
		vadduwm	v12,v12,v2			;# S1[8] += B1
		vadduwm	v13,v13,v5			;# S2[8] += B2
		vadduwm	v14,v14,v8			;# S3[8] += B3
		vadduwm	v15,v15,v11			;# S4[8] += B4
		vrlw	v28,v12,v26			;# A1 = S1[8] = ROTL3(S1[8] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[8] = ROTL3(S2[8] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[8] = ROTL3(S3[8] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[8] = ROTL3(S4[8] + A4 + B4)

		;# Stage 60-61
		lvx		v12,r20,r23			;# S1[9]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r10,r26			;# S2[9]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r12,r28			;# S3[9]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r14,r30			;# S4[9]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r19,r23			;# store S1[8]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,0,r26			;# store S2[8]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r11,r28			;# store S3[8]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r13,r30			;# store S4[8]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[9] += A1
		vadduwm	v13,v13,v29			;# S2[9] += A2
		vadduwm	v14,v14,v30			;# S3[9] += A3
		vadduwm	v15,v15,v31			;# S4[9] += A4
		vadduwm	v12,v12,v0			;# S1[9] += B1
		vadduwm	v13,v13,v3			;# S2[9] += B2
		vadduwm	v14,v14,v6			;# S3[9] += B3
		vadduwm	v15,v15,v9			;# S4[9] += B4
		vrlw	v28,v12,v26			;# A1 = S1[9] = ROTL3(S1[9] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[9] = ROTL3(S2[9] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[9] = ROTL3(S3[9] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[9] = ROTL3(S4[9] + A4 + B4)

		;# Stage 61-62
		lvx		v12,0,r24			;# S1[10]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r11,r26			;# S2[10]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r13,r28			;# S3[10]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r15,r30			;# S4[10]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r20,r23			;# store S1[9]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r10,r26			;# store S2[9]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r12,r28			;# store S3[9]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r14,r30			;# store S4[9]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[10] += A1
		vadduwm	v13,v13,v29			;# S2[10] += A2
		vadduwm	v14,v14,v30			;# S3[10] += A3
		vadduwm	v15,v15,v31			;# S4[10] += A4
		vadduwm	v12,v12,v1			;# S1[10] += B1
		vadduwm	v13,v13,v4			;# S2[10] += B2
		vadduwm	v14,v14,v7			;# S3[10] += B3
		vadduwm	v15,v15,v10			;# S4[10] += B4
		vrlw	v28,v12,v26			;# A1 = S1[10] = ROTL3(S1[10] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[10] = ROTL3(S2[10] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[10] = ROTL3(S3[10] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[10] = ROTL3(S4[10] + A4 + B4)

		;# Stage 62-63
		lvx		v12,r10,r24			;# S1[11]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r12,r26			;# S2[11]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r14,r28			;# S3[11]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r16,r30			;# S4[11]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,0,r24			;# store S1[10]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r11,r26			;# store S2[10]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r13,r28			;# store S3[10]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r15,r30			;# store S4[10]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[11] += A1
		vadduwm	v13,v13,v29			;# S2[11] += A2
		vadduwm	v14,v14,v30			;# S3[11] += A3
		vadduwm	v15,v15,v31			;# S4[11] += A4
		vadduwm	v12,v12,v2			;# S1[11] += B1
		vadduwm	v13,v13,v5			;# S2[11] += B2
		vadduwm	v14,v14,v8			;# S3[11] += B3
		vadduwm	v15,v15,v11			;# S4[11] += B4
		vrlw	v28,v12,v26			;# A1 = S1[11] = ROTL3(S1[11] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[11] = ROTL3(S2[11] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[11] = ROTL3(S3[11] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[11] = ROTL3(S4[11] + A4 + B4)

		;# Stage 63-64
		lvx		v12,r11,r24			;# S1[12]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r13,r26			;# S2[12]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r15,r28			;# S3[12]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r17,r30			;# S4[12]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r10,r24			;# store S1[11]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r12,r26			;# store S2[11]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r14,r28			;# store S3[11]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r16,r30			;# store S4[11]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[12] += A1
		vadduwm	v13,v13,v29			;# S2[12] += A2
		vadduwm	v14,v14,v30			;# S3[12] += A3
		vadduwm	v15,v15,v31			;# S4[12] += A4
		vadduwm	v12,v12,v0			;# S1[12] += B1
		vadduwm	v13,v13,v3			;# S2[12] += B2
		vadduwm	v14,v14,v6			;# S3[12] += B3
		vadduwm	v15,v15,v9			;# S4[12] += B4
		vrlw	v28,v12,v26			;# A1 = S1[12] = ROTL3(S1[12] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[12] = ROTL3(S2[12] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[12] = ROTL3(S3[12] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[12] = ROTL3(S4[12] + A4 + B4)

		;# Stage 64-65
		lvx		v12,r12,r24			;# S1[13]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r14,r26			;# S2[13]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r16,r28			;# S3[13]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r18,r30			;# S4[13]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r11,r24			;# store S1[12]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r13,r26			;# store S2[12]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r15,r28			;# store S3[12]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r17,r30			;# store S4[12]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[13] += A1
		vadduwm	v13,v13,v29			;# S2[13] += A2
		vadduwm	v14,v14,v30			;# S3[13] += A3
		vadduwm	v15,v15,v31			;# S4[13] += A4
		vadduwm	v12,v12,v1			;# S1[13] += B1
		vadduwm	v13,v13,v4			;# S2[13] += B2
		vadduwm	v14,v14,v7			;# S3[13] += B3
		vadduwm	v15,v15,v10			;# S4[13] += B4
		vrlw	v28,v12,v26			;# A1 = S1[13] = ROTL3(S1[13] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[13] = ROTL3(S2[13] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[13] = ROTL3(S3[13] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[13] = ROTL3(S4[13] + A4 + B4)

		;# Stage 65-66
		lvx		v12,r13,r24			;# S1[14]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r15,r26			;# S2[14]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r17,r28			;# S3[14]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r19,r30			;# S4[14]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r12,r24			;# store S1[13]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r14,r26			;# store S2[13]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r16,r28			;# store S3[13]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r18,r30			;# store S4[13]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[14] += A1
		vadduwm	v13,v13,v29			;# S2[14] += A2
		vadduwm	v14,v14,v30			;# S3[14] += A3
		vadduwm	v15,v15,v31			;# S4[14] += A4
		vadduwm	v12,v12,v2			;# S1[14] += B1
		vadduwm	v13,v13,v5			;# S2[14] += B2
		vadduwm	v14,v14,v8			;# S3[14] += B3
		vadduwm	v15,v15,v11			;# S4[14] += B4
		vrlw	v28,v12,v26			;# A1 = S1[14] = ROTL3(S1[14] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[14] = ROTL3(S2[14] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[14] = ROTL3(S3[14] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[14] = ROTL3(S4[14] + A4 + B4)

		;# Stage 66-67
		lvx		v12,r14,r24			;# S1[15]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r16,r26			;# S2[15]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r18,r28			;# S3[15]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r20,r30			;# S4[15]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r13,r24			;# store S1[14]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r15,r26			;# store S2[14]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r17,r28			;# store S3[14]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r19,r30			;# store S4[14]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[15] += A1
		vadduwm	v13,v13,v29			;# S2[15] += A2
		vadduwm	v14,v14,v30			;# S3[15] += A3
		vadduwm	v15,v15,v31			;# S4[15] += A4
		vadduwm	v12,v12,v0			;# S1[15] += B1
		vadduwm	v13,v13,v3			;# S2[15] += B2
		vadduwm	v14,v14,v6			;# S3[15] += B3
		vadduwm	v15,v15,v9			;# S4[15] += B4
		vrlw	v28,v12,v26			;# A1 = S1[15] = ROTL3(S1[15] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[15] = ROTL3(S2[15] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[15] = ROTL3(S3[15] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[15] = ROTL3(S4[15] + A4 + B4)

		;# Stage 67-68
		lvx		v12,r15,r24			;# S1[16]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r17,r26			;# S2[16]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r19,r28			;# S3[16]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,0,r31			;# S4[16]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r14,r24			;# store S1[15]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r16,r26			;# store S2[15]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r18,r28			;# store S3[15]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r20,r30			;# store S4[15]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[16] += A1
		vadduwm	v13,v13,v29			;# S2[16] += A2
		vadduwm	v14,v14,v30			;# S3[16] += A3
		vadduwm	v15,v15,v31			;# S4[16] += A4
		vadduwm	v12,v12,v1			;# S1[16] += B1
		vadduwm	v13,v13,v4			;# S2[16] += B2
		vadduwm	v14,v14,v7			;# S3[16] += B3
		vadduwm	v15,v15,v10			;# S4[16] += B4
		vrlw	v28,v12,v26			;# A1 = S1[16] = ROTL3(S1[16] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[16] = ROTL3(S2[16] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[16] = ROTL3(S3[16] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[16] = ROTL3(S4[16] + A4 + B4)

		;# Stage 68-69
		lvx		v12,r16,r24			;# S1[17]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r18,r26			;# S2[17]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r20,r28			;# S3[17]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r10,r31			;# S4[17]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r15,r24			;# store S1[16]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r17,r26			;# store S2[16]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r19,r28			;# store S3[16]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,0,r31			;# store S4[16]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[17] += A1
		vadduwm	v13,v13,v29			;# S2[17] += A2
		vadduwm	v14,v14,v30			;# S3[17] += A3
		vadduwm	v15,v15,v31			;# S4[17] += A4
		vadduwm	v12,v12,v2			;# S1[17] += B1
		vadduwm	v13,v13,v5			;# S2[17] += B2
		vadduwm	v14,v14,v8			;# S3[17] += B3
		vadduwm	v15,v15,v11			;# S4[17] += B4
		vrlw	v28,v12,v26			;# A1 = S1[17] = ROTL3(S1[17] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[17] = ROTL3(S2[17] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[17] = ROTL3(S3[17] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[17] = ROTL3(S4[17] + A4 + B4)

		;# Stage 69-70
		lvx		v12,r17,r24			;# S1[18]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r19,r26			;# S2[18]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,0,r29			;# S3[18]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r11,r31			;# S4[18]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r16,r24			;# store S1[17]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,r18,r26			;# store S2[17]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r20,r28			;# store S3[17]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r10,r31			;# store S4[17]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[18] += A1
		vadduwm	v13,v13,v29			;# S2[18] += A2
		vadduwm	v14,v14,v30			;# S3[18] += A3
		vadduwm	v15,v15,v31			;# S4[18] += A4
		vadduwm	v12,v12,v0			;# S1[18] += B1
		vadduwm	v13,v13,v3			;# S2[18] += B2
		vadduwm	v14,v14,v6			;# S3[18] += B3
		vadduwm	v15,v15,v9			;# S4[18] += B4
		vrlw	v28,v12,v26			;# A1 = S1[18] = ROTL3(S1[18] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[18] = ROTL3(S2[18] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[18] = ROTL3(S3[18] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[18] = ROTL3(S4[18] + A4 + B4)

		;# Stage 70-71
		lvx		v12,r18,r24			;# S1[19]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r20,r26			;# S2[19]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r10,r29			;# S3[19]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r12,r31			;# S4[19]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r17,r24			;# store S1[18]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r19,r26			;# store S2[18]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,0,r29			;# store S3[18]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r11,r31			;# store S4[18]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[19] += A1
		vadduwm	v13,v13,v29			;# S2[19] += A2
		vadduwm	v14,v14,v30			;# S3[19] += A3
		vadduwm	v15,v15,v31			;# S4[19] += A4
		vadduwm	v12,v12,v1			;# S1[19] += B1
		vadduwm	v13,v13,v4			;# S2[19] += B2
		vadduwm	v14,v14,v7			;# S3[19] += B3
		vadduwm	v15,v15,v10			;# S4[19] += B4
		vrlw	v28,v12,v26			;# A1 = S1[19] = ROTL3(S1[19] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[19] = ROTL3(S2[19] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[19] = ROTL3(S3[19] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[19] = ROTL3(S4[19] + A4 + B4)

		;# Stage 71-72
		lvx		v12,r19,r24			;# S1[20]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,0,r27			;# S2[20]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r11,r29			;# S3[20]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r13,r31			;# S4[20]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,r18,r24			;# store S1[19]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r20,r26			;# store S2[19]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r10,r29			;# store S3[19]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r12,r31			;# store S4[19]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[20] += A1
		vadduwm	v13,v13,v29			;# S2[20] += A2
		vadduwm	v14,v14,v30			;# S3[20] += A3
		vadduwm	v15,v15,v31			;# S4[20] += A4
		vadduwm	v12,v12,v2			;# S1[20] += B1
		vadduwm	v13,v13,v5			;# S2[20] += B2
		vadduwm	v14,v14,v8			;# S3[20] += B3
		vadduwm	v15,v15,v11			;# S4[20] += B4
		vrlw	v28,v12,v26			;# A1 = S1[20] = ROTL3(S1[20] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[20] = ROTL3(S2[20] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[20] = ROTL3(S3[20] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[20] = ROTL3(S4[20] + A4 + B4)

		;# Stage 72-73
		lvx		v12,r20,r24			;# S1[21]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r10,r27			;# S2[21]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r12,r29			;# S3[21]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r14,r31			;# S4[21]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		stvx	v28,r19,r24			;# store S1[20]
		vadduwm	v0,v0,v16			;# L1[0] += T1
		stvx	v29,0,r27			;# store S2[20]
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v30,r11,r29			;# store S3[20]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v31,r13,r31			;# store S4[20]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[21] += A1
		vadduwm	v13,v13,v29			;# S2[21] += A2
		vadduwm	v14,v14,v30			;# S3[21] += A3
		vadduwm	v15,v15,v31			;# S4[21] += A4
		vadduwm	v12,v12,v0			;# S1[21] += B1
		vadduwm	v13,v13,v3			;# S2[21] += B2
		vadduwm	v14,v14,v6			;# S3[21] += B3
		vadduwm	v15,v15,v9			;# S4[21] += B4
		vrlw	v28,v12,v26			;# A1 = S1[21] = ROTL3(S1[21] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[21] = ROTL3(S2[21] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[21] = ROTL3(S3[21] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[21] = ROTL3(S4[21] + A4 + B4)

		;# Stage 73-74
		lvx		v12,0,r25			;# S1[22]
		vadduwm	v16,v28,v0			;# T1 = A1 + B1
		lvx		v13,r11,r27			;# S2[22]
		vadduwm	v17,v29,v3			;# T2 = A2 + B2
		lvx		v14,r13,r29			;# S3[22]
		vadduwm	v18,v30,v6			;# T3 = A3 + B3
		lvx		v15,r15,r31			;# S4[22]
		vadduwm	v19,v31,v9			;# T4 = A4 + B4
		stvx	v28,r20,r24			;# store S1[21]
		vadduwm	v1,v1,v16			;# L1[1] += T1
		stvx	v29,r10,r27			;# store S2[21]
		vadduwm	v4,v4,v17			;# L2[1] += T2
		stvx	v30,r12,r29			;# store S3[21]
		vadduwm	v7,v7,v18			;# L3[1] += T3
		stvx	v31,r14,r31			;# store S4[21]
		vadduwm	v10,v10,v19			;# L4[1] += T4
		vrlw	v1,v1,v16			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v17			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v18			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v19			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[22] += A1
		vadduwm	v13,v13,v29			;# S2[22] += A2
		vadduwm	v14,v14,v30			;# S3[22] += A3
		vadduwm	v15,v15,v31			;# S4[22] += A4
		vadduwm	v12,v12,v1			;# S1[22] += B1
		vadduwm	v13,v13,v4			;# S2[22] += B2
		vadduwm	v14,v14,v7			;# S3[22] += B3
		vadduwm	v15,v15,v10			;# S4[22] += B4
		vrlw	v28,v12,v26			;# A1 = S1[22] = ROTL3(S1[22] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[22] = ROTL3(S2[22] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[22] = ROTL3(S3[22] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[22] = ROTL3(S4[22] + A4 + B4)

		;# Stage 74-75
		lvx		v12,r10,r25			;# S1[23]
		vadduwm	v16,v28,v1			;# T1 = A1 + B1
		lvx		v13,r12,r27			;# S2[23]
		vadduwm	v17,v29,v4			;# T2 = A2 + B2
		lvx		v14,r14,r29			;# S3[23]
		vadduwm	v18,v30,v7			;# T3 = A3 + B3
		lvx		v15,r16,r31			;# S4[23]
		vadduwm	v19,v31,v10			;# T4 = A4 + B4
		stvx	v28,0,r25			;# store S1[22]
		vadduwm	v2,v2,v16			;# L1[2] += T1
		stvx	v29,r11,r27			;# store S2[22]
		vadduwm	v5,v5,v17			;# L2[2] += T2
		stvx	v30,r13,r29			;# store S3[22]
		vadduwm	v8,v8,v18			;# L3[2] += T3
		stvx	v31,r15,r31			;# store S4[22]
		vadduwm	v11,v11,v19			;# L4[2] += T4
		vrlw	v2,v2,v16			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v17			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v18			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v19			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[23] += A1
		vadduwm	v13,v13,v29			;# S2[23] += A2
		vadduwm	v14,v14,v30			;# S3[23] += A3
		vadduwm	v15,v15,v31			;# S4[23] += A4
		vadduwm	v12,v12,v2			;# S1[23] += B1
		vadduwm	v13,v13,v5			;# S2[23] += B2
		vadduwm	v14,v14,v8			;# S3[23] += B3
		vadduwm	v15,v15,v11			;# S4[23] += B4
		vrlw	v28,v12,v26			;# A1 = S1[23] = ROTL3(S1[23] + A1 + B1)
		vrlw	v29,v13,v26			;# A2 = S2[23] = ROTL3(S2[23] + A2 + B2)
		vrlw	v30,v14,v26			;# A3 = S3[23] = ROTL3(S3[23] + A3 + B3)
		vrlw	v31,v15,v26			;# A4 = S4[23] = ROTL3(S4[23] + A4 + B4)

		;# Stage 75-76
		lvx		v12,r11,r25			;# S1[24]
		vadduwm	v16,v28,v2			;# T1 = A1 + B1
		lvx		v13,r13,r27			;# S2[24]
		vadduwm	v17,v29,v5			;# T2 = A2 + B2
		lvx		v14,r15,r29			;# S3[24]
		vadduwm	v18,v30,v8			;# T3 = A3 + B3
		lvx		v15,r17,r31			;# S4[24]
		vadduwm	v19,v31,v11			;# T4 = A4 + B4
		lvx		v24,r20,r31			;# Load vCypherPlain vector
		vadduwm	v0,v0,v16			;# L1[0] += T1
		lbz		r6,wKeyHi+3(r1)		;# key.hi
		vadduwm	v3,v3,v17			;# L2[0] += T2
		stvx	v28,r10,r25			;# store S1[23]
		vadduwm	v6,v6,v18			;# L3[0] += T3
		stvx	v29,r12,r27			;# store S2[23]
		vadduwm	v9,v9,v19			;# L4[0] += T4
		stvx	v30,r14,r29			;# store S3[23]
		vrlw	v0,v0,v16			;# B1 = L1[0] = ROTL(L1[0] + T1, T1)
		stvx	v31,r16,r31			;# store S4[23]
		vrlw	v3,v3,v17			;# B2 = L2[0] = ROTL(L2[0] + T2, T2)
		vrlw	v6,v6,v18			;# B3 = L3[0] = ROTL(L3[0] + T3, T3)
		vrlw	v9,v9,v19			;# B4 = L4[0] = ROTL(L4[0] + T4, T4)
		vadduwm	v12,v12,v28			;# S1[24] += A1
		vadduwm	v13,v13,v29			;# S2[24] += A2
		lvx		v28,r11,r23			;# S1[0]
		vadduwm	v14,v14,v30			;# S3[24] += A3
		lvx		v29,r13,r25			;# S2[0]
		vadduwm	v15,v15,v31			;# S4[24] += A4
		lvx		v30,r15,r27			;# S3[0]
		vadduwm	v12,v12,v0			;# S1[24] += B1
		lvx		v31,r17,r29			;# S4[0]
		vadduwm	v13,v13,v3			;# S2[24] += B2
		lvx		v16,r12,r23			;# S1[1]
		vadduwm	v14,v14,v6			;# S3[24] += B3
		lvx		v17,r14,r25			;# S2[1]
		vadduwm	v15,v15,v9			;# S4[24] += B4
		lvx		v18,r16,r27			;# S3[1]
		vrlw	v12,v12,v26			;# A1 = S1[24] = ROTL3(S1[24] + A1 + B1)
		lvx		v19,r18,r29			;# S4[1]
		vrlw	v13,v13,v26			;# A2 = S2[24] = ROTL3(S2[24] + A2 + B2)
		vspltw	v2,v24,0			;# plain.lo
		vrlw	v14,v14,v26			;# A3 = S3[24] = ROTL3(S3[24] + A3 + B3)
		vspltw	v5,v24,1			;# plain.hi
		vrlw	v15,v15,v26			;# A4 = S4[24] = ROTL3(S4[24] + A4 + B4)
		vspltw	v8,v24,2			;# cypher.lo

		;# Initialize key encryption stages.
		;# Also pre-increment key.hi for the next iteration.
		vadduwm	v28,v2,v28			;# C1 = plain.lo + S1[0]
		stvx	v12,r11,r25			;# store S1[24]
		vadduwm	v29,v2,v29			;# C2 = plain.lo + S2[0]
		stvx	v13,r13,r27			;# store S2[24]
		vadduwm	v30,v2,v30			;# C3 = plain.lo + S3[0]
		stvx	v14,r15,r29			;# store S3[24]
		vadduwm	v31,v2,v31			;# C4 = plain.lo + S4[0]
		stvx	v15,r17,r31			;# store S4[24]
		vadduwm	v16,v5,v16			;# D1 = plain.hi + S1[1]
		addi	r6,r6,16			;# Increment key.hi
		vadduwm	v17,v5,v17			;# D2 = plain.hi + S2[1]
		vadduwm	v18,v5,v18			;# D3 = plain.hi + S3[1]
		vadduwm	v19,v5,v19			;# D4 = plain.hi + S4[1]
		lvx		v12,r13,r23			;# S1[2]
		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v13,r15,r25			;# S2[2]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v14,r17,r27			;# S3[2]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v15,r19,r29			;# S4[2]
		vxor	v31,v31,v19			;# C4 ^= D4
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		stb		r6,wKeyHi+3(r1)		;# Store key.hi + 16
		vadduwm	v28,v28,v12			;# C1 += S1[2]
		vadduwm	v29,v29,v13			;# C2 += S2[2]
		vadduwm	v30,v30,v14			;# C3 += S3[2]
		vadduwm	v31,v31,v15			;# C4 += S4[2]

		;# Round stage 1-2
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r14,r23			;# S1[3]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r16,r25			;# S2[3]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r18,r27			;# S3[3]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r20,r29			;# S4[3]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[3]
		vadduwm	v17,v17,v13			;# D2 += S2[3]
		vadduwm	v18,v18,v14			;# D3 += S3[3]
		vadduwm	v19,v19,v15			;# D4 += S4[3]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r15,r23			;# S1[4]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r17,r25			;# S2[4]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r19,r27			;# S3[4]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,0,r30			;# S4[4]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[4]
		vadduwm	v29,v29,v13			;# C2 += S2[4]
		vadduwm	v30,v30,v14			;# C3 += S3[4]
		vadduwm	v31,v31,v15			;# C4 += S4[4]

		;# Round stage 2-3
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r16,r23			;# S1[5]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r18,r25			;# S2[5]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r20,r27			;# S3[5]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r10,r30			;# S4[5]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[5]
		vadduwm	v17,v17,v13			;# D2 += S2[5]
		vadduwm	v18,v18,v14			;# D3 += S3[5]
		vadduwm	v19,v19,v15			;# D4 += S4[5]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r17,r23			;# S1[6]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r19,r25			;# S2[6]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,0,r28			;# S3[6]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r11,r30			;# S4[6]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[6]
		vadduwm	v29,v29,v13			;# C2 += S2[6]
		vadduwm	v30,v30,v14			;# C3 += S3[6]
		vadduwm	v31,v31,v15			;# C4 += S4[6]

		;# Round stage 3-4
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r18,r23			;# S1[7]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r20,r25			;# S2[7]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r10,r28			;# S3[7]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r12,r30			;# S4[7]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[7]
		vadduwm	v17,v17,v13			;# D2 += S2[7]
		vadduwm	v18,v18,v14			;# D3 += S3[7]
		vadduwm	v19,v19,v15			;# D4 += S4[7]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r19,r23			;# S1[8]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,0,r26			;# S2[8]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r11,r28			;# S3[8]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r13,r30			;# S4[8]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[8]
		vadduwm	v29,v29,v13			;# C2 += S2[8]
		vadduwm	v30,v30,v14			;# C3 += S3[8]
		vadduwm	v31,v31,v15			;# C4 += S4[8]

		;# Round stage 4-5
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r20,r23			;# S1[9]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r10,r26			;# S2[9]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r12,r28			;# S3[9]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r14,r30			;# S4[9]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[9]
		vadduwm	v17,v17,v13			;# D2 += S2[9]
		vadduwm	v18,v18,v14			;# D3 += S3[9]
		vadduwm	v19,v19,v15			;# D4 += S4[9]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,0,r24			;# S1[10]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r11,r26			;# S2[10]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r13,r28			;# S3[10]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r15,r30			;# S4[10]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[10]
		vadduwm	v29,v29,v13			;# C2 += S2[10]
		vadduwm	v30,v30,v14			;# C3 += S3[10]
		vadduwm	v31,v31,v15			;# C4 += S4[10]

		;# Round stage 5-6
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r10,r24			;# S1[11]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r12,r26			;# S2[11]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r14,r28			;# S3[11]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r16,r30			;# S4[11]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[11]
		vadduwm	v17,v17,v13			;# D2 += S2[11]
		vadduwm	v18,v18,v14			;# D3 += S3[11]
		vadduwm	v19,v19,v15			;# D4 += S4[11]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r11,r24			;# S1[12]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r13,r26			;# S2[12]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r15,r28			;# S3[12]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r17,r30			;# S4[12]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[12]
		vadduwm	v29,v29,v13			;# C2 += S2[12]
		vadduwm	v30,v30,v14			;# C3 += S3[12]
		vadduwm	v31,v31,v15			;# C4 += S4[12]

		;# Round stage 6-7
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r12,r24			;# S1[13]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r14,r26			;# S2[13]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r16,r28			;# S3[13]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r18,r30			;# S4[13]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[13]
		vadduwm	v17,v17,v13			;# D2 += S2[13]
		vadduwm	v18,v18,v14			;# D3 += S3[13]
		vadduwm	v19,v19,v15			;# D4 += S4[13]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r13,r24			;# S1[14]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r15,r26			;# S2[14]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r17,r28			;# S3[14]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r19,r30			;# S4[14]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[14]
		vadduwm	v29,v29,v13			;# C2 += S2[14]
		vadduwm	v30,v30,v14			;# C3 += S3[14]
		vadduwm	v31,v31,v15			;# C4 += S4[14]

		;# Round stage 7-8
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r14,r24			;# S1[15]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r16,r26			;# S2[15]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r18,r28			;# S3[15]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r20,r30			;# S4[15]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[15]
		vadduwm	v17,v17,v13			;# D2 += S2[15]
		vadduwm	v18,v18,v14			;# D3 += S3[15]
		vadduwm	v19,v19,v15			;# D4 += S4[15]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r15,r24			;# S1[16]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r17,r26			;# S2[16]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r19,r28			;# S3[16]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,0,r31			;# S4[16]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[16]
		vadduwm	v29,v29,v13			;# C2 += S2[16]
		vadduwm	v30,v30,v14			;# C3 += S3[16]
		vadduwm	v31,v31,v15			;# C4 += S4[16]

		;# Round stage 8-9
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r16,r24			;# S1[17]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r18,r26			;# S2[17]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r20,r28			;# S3[17]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r10,r31			;# S4[17]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[17]
		vadduwm	v17,v17,v13			;# D2 += S2[17]
		vadduwm	v18,v18,v14			;# D3 += S3[17]
		vadduwm	v19,v19,v15			;# D4 += S4[17]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r17,r24			;# S1[18]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r19,r26			;# S2[18]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,0,r29			;# S3[18]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r11,r31			;# S4[18]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[18]
		vadduwm	v29,v29,v13			;# C2 += S2[18]
		vadduwm	v30,v30,v14			;# C3 += S3[18]
		vadduwm	v31,v31,v15			;# C4 += S4[18]

		;# Round stage 9-10
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r18,r24			;# S1[19]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r20,r26			;# S2[19]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r10,r29			;# S3[19]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r12,r31			;# S4[19]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[19]
		vadduwm	v17,v17,v13			;# D2 += S2[19]
		vadduwm	v18,v18,v14			;# D3 += S3[19]
		vadduwm	v19,v19,v15			;# D4 += S4[19]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r19,r24			;# S1[20]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,0,r27			;# S2[20]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r11,r29			;# S3[20]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r13,r31			;# S4[20]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[20]
		vadduwm	v29,v29,v13			;# C2 += S2[20]
		vadduwm	v30,v30,v14			;# C3 += S3[20]
		vadduwm	v31,v31,v15			;# C4 += S4[20]

		;# Round stage 10-11
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r20,r24			;# S1[21]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r10,r27			;# S2[21]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r12,r29			;# S3[21]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r14,r31			;# S4[21]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[21]
		vadduwm	v17,v17,v13			;# D2 += S2[21]
		vadduwm	v18,v18,v14			;# D3 += S3[21]
		vadduwm	v19,v19,v15			;# D4 += S4[21]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,0,r25			;# S1[22]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r11,r27			;# S2[22]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r13,r29			;# S3[22]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r15,r31			;# S4[22]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[22]
		vadduwm	v29,v29,v13			;# C2 += S2[22]
		vadduwm	v30,v30,v14			;# C3 += S3[22]
		vadduwm	v31,v31,v15			;# C4 += S4[22]

		;# Round stage 11-12
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v12,r10,r25			;# S1[23]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v13,r12,r27			;# S2[23]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v14,r14,r29			;# S3[23]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v15,r16,r31			;# S4[23]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)
		vadduwm	v16,v16,v12			;# D1 += S1[23]
		vadduwm	v17,v17,v13			;# D2 += S2[23]
		vadduwm	v18,v18,v14			;# D3 += S3[23]
		vadduwm	v19,v19,v15			;# D4 += S4[23]

		vxor	v28,v28,v16			;# C1 ^= D1
		lvx		v12,r11,r25			;# S1[24]
		vxor	v29,v29,v17			;# C2 ^= D2
		lvx		v13,r13,r27			;# S2[24]
		vxor	v30,v30,v18			;# C3 ^= D3
		lvx		v14,r15,r29			;# S3[24]
		vxor	v31,v31,v19			;# C4 ^= D4
		lvx		v15,r17,r31			;# S4[24]
		vrlw	v28,v28,v16			;# C1 = ROTL(C1^D1, D1)
		lvx		v2,r19,r31			;# vKey
		vrlw	v29,v29,v17			;# C2 = ROTL(C2^D2, D2)
		vrlw	v30,v30,v18			;# C3 = ROTL(C3^D3, D3)
		vrlw	v31,v31,v19			;# C4 = ROTL(C4^D4, D4)
		vadduwm	v28,v28,v12			;# C1 += S1[24]
		vadduwm	v29,v29,v13			;# C2 += S2[24]
		vadduwm	v30,v30,v14			;# C3 += S3[24]
		vadduwm	v31,v31,v15			;# C4 += S4[24]

		;# Check for a partial match in any pipeline.
		;# The first four 'vcmpequw' instructions initialize four vectors so
		;# that a word set to -1 indicates that the corresponding key matches
		;# the cyphered text. These four vectors are then packed into a single
		;# vector in which each byte indicates whether a key matches or not.
		;# In the meantime, we anticipate another iteration by re-initializing
		;# the inner loop (hiding latencies in the process).
		vcmpequw v12,v28,v8			;# C1 == cypher.lo ?
		vspltisw v25,-1
		vcmpequw v13,v29,v8			;# C2 == cypher.lo ?
		vspltw	v2,v2,0				;# L1[2] = key.hi
		vcmpequw v14,v30,v8			;# C3 == cypher.lo ?
		vspltisw v11,4
		vcmpequw v15,v31,v8			;# C4 == cypher.lo ?

		vadduwm	v2,v2,v27			;# key.hi + (0,1,2,3)
		lbz		r3,wKeyHi+3(r1)
		vadduwm	v5,v2,v11			;# L2[2] = key.hi + 4
		vpkuwus	v12,v12,v13
		vadduwm	v8,v5,v11			;# L3[2] = key.hi + 8
		vadduwm	v13,v23,v21			;# T1 = A1 + B1
		vpkuwus	v14,v14,v15
		vadduwm	v11,v8,v11			;# L3[2] = key.hi + 12
		vadduwm	v2,v2,v13			;# L1[2] += T1
		lvx		v15,r12,r21			;# S0[3]
		vadduwm	v5,v5,v13			;# L2[2] += T2
		vadduwm	v8,v8,v13			;# L3[2] += T3
		vpkuhum	v12,v12,v14
		vadduwm	v11,v11,v13			;# L4[2] += T4
		vadduwm	v15,v15,v23			;# S1[3] = S0[3] + A1
		vrlw	v2,v2,v13			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vcmpequb. v25,v12,v25

		vrlw	v5,v5,v13			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v13			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v13			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		bne-	cr6,check_keys		;# Partial/Full match
		bdnz	new_key_hi


;# The inner loop exits when all iterations have been done or when key.hi == 0
;# (key.hi has already been incremented by 16). The (simplified) logic is as
;# follows :
;#
;#	if (key.hi != 0) {		// then iter == 0
;#		exit();
;#	}
;#	else {
;#		increment key.mid (and even key.lo)
;#		store new key.mid/key.lo values
;#		if (iter == 0) {
;#			exit();
;#		}
;#	}
;#
;# Pre-conditions :
;# r3  : key.hi (byte)
next_block:
		cmplwi	r3,0				;# key.hi == 0 ? (cr0)
		li		r4,wKeyMid
		lwz		r6,wKIter(r1)		;# Remaining iterations / 2
		li		r5,wKeyLo
		lwbrx	r7,r4,r1 			;# key.mid (byte reversed)
		li		r0,16				;# Preset next loop count
		lwbrx	r8,r5,r1 			;# key.lo (byte reversed)
		bne-	not_found			;# key.hi != 0 means that kiter == 0

		addic.	r7,r7,1				;# key.mid += 1 (cr0)
		cmplw	cr1,r6,r0			;# iter < count ? (cr1)
		addze	r8,r8				;# key.lo + carry
		cmplwi	cr6,r6,0			;# Iteration count == 0 ? (cr6)
		stwbrx	r7,r4,r1 			;# Store updated key.mid
		stwbrx	r8,r5,r1 			;# Store updated key.lo
		beq-	cr6,not_found		;# Iteration count == 0
		bgt		cr1,set_count2		;# jump if iter >= count

		mr		r0,r6				;# Loop count = remaining iterations / 16

set_count2:
		subf	r6,r0,r6			;# Update iteration count
		mtctr	r0
		lvx		v24,r19,r31			;# Load vKey
		stw		r6,wKIter(r1)
		bne+	new_key_mid			;# key.mid != 0
		b		new_key_lo			;# overwise, key.lo has changed

not_found:
		li		r3,RESULT_NOTHING
		b		epilog


;# At least one of the keys matches cypher.lo
;# We first need to complete the last round stage and cyphered text decryption
;# to determine whether we got a full or a partial match.
;# In addition, the last matching key (in sequential order) must be set aside
;# as a counter-measure check, along with the total number of matches (either
;# partial or full) since the beginning of the current key block.
;#
;#     THIS PART IS SELDOM USED - OPTIMISATIONS ARE FUTILE
;#
;# v0  : B1 = L1[0]
;# v3  : B2 = L2[0]
;# v6  : B3 = L3[0]
;# v9  : B4 = L4[0]
;# v1  : L1[1]
;# v4  : L2[1]
;# v7  : L3[1]
;# v10 : L4[1]
;# v28 : C1
;# v29 : C2
;# v30 : C3
;# v31 : C4
;# v16 : D1
;# v17 : D2
;# v18 : D3
;# v19 : D4
;# v25 : C == cypher.lo
;# v24 : vCypherPlain

check_keys:
		;# Last mixing stage.
		vxor	v16,v16,v28			;# D1 ^= C1
		lvx		v2,r11,r25			;# A1 = S1[24]
		vxor	v17,v17,v29			;# D2 ^= C2
		lvx		v5,r13,r27			;# A2 = S2[24]
		vxor	v18,v18,v30			;# D3 ^= C3
		lvx		v8,r15,r29			;# A3 = S3[24]
		vxor	v19,v19,v31			;# D4 ^= C4
		lvx		v11,r17,r31			;# A4 = S4[24]
		vrlw	v16,v16,v28			;# D1 = ROTL(D1^C1, C1)
		vrlw	v17,v17,v29			;# D2 = ROTL(D2^C2, C2)
		vrlw	v18,v18,v30			;# D3 = ROTL(D3^C3, C3)
		vrlw	v19,v19,v31			;# D4 = ROTL(D4^C4, C4)

		;# Stage 76-77
		vadduwm	v0,v2,v0			;# T1 = A1 + B1
		vadduwm	v3,v5,v3			;# T2 = A2 + B2
		vadduwm	v6,v8,v6			;# T3 = A3 + B3
		vadduwm	v9,v11,v9			;# T4 = A4 + B4
		vadduwm	v1,v1,v0			;# L1[1] += T1
		lvx		v12,r12,r25			;# S1[25]
		vadduwm	v4,v4,v3			;# L2[1] += T2
		lvx		v13,r14,r27			;# S2[25]
		vadduwm	v7,v7,v6			;# L3[1] += T3
		lvx		v14,r16,r29			;# S3[25]
		vadduwm	v10,v10,v9			;# L4[1] += T4
		lvx		v15,r18,r31			;# S4[25]
		vrlw	v1,v1,v0			;# B1 = L1[1] = ROTL(L1[1] + T1, T1)
		vrlw	v4,v4,v3			;# B2 = L2[1] = ROTL(L2[1] + T2, T2)
		vrlw	v7,v7,v6			;# B3 = L3[1] = ROTL(L3[1] + T3, T3)
		vrlw	v10,v10,v9			;# B4 = L4[1] = ROTL(L4[1] + T4, T4)
		vadduwm	v12,v12,v2			;# S1[25] += A1
		vadduwm	v13,v13,v5			;# S2[25] += A2
		vadduwm	v14,v14,v8			;# S3[25] += A3
		vadduwm	v15,v15,v11			;# S4[25] += A4
		vadduwm	v12,v12,v1			;# S1[25] += B1
		vadduwm	v13,v13,v4			;# S2[25] += B2
		vadduwm	v14,v14,v7			;# S3[25] += B3
		vadduwm	v15,v15,v10			;# S4[25] += B4
		vrlw	v12,v12,v26			;# A1 = S1[25] = ROTL3(S1[25] + A1 + B1)
		vspltw	v11,v24,3			;# cypher.hi
		vrlw	v13,v13,v26			;# A2 = S2[25] = ROTL3(S2[25] + A2 + B2)
		vrlw	v14,v14,v26			;# A3 = S3[25] = ROTL3(S3[25] + A3 + B3)
		vrlw	v15,v15,v26			;# A4 = S4[25] = ROTL3(S4[25] + A4 + B4)

		vadduwm	v16,v16,v12			;# D1 += S1[25]
		vadduwm	v17,v17,v13			;# D2 += S2[25]
		vadduwm	v18,v18,v14			;# D3 += S3[25]
		vadduwm	v19,v19,v15			;# D4 += S4[25]

		;# Pack the 16 results into a single vector.
		vcmpequw v16,v16,v11		;# D1 == cypher.hi ?
		vspltisw v12,-1
		vcmpequw v17,v17,v11		;# D2 == cypher.hi ?
		vcmpequw v18,v18,v11		;# D3 == cypher.hi ?
		vcmpequw v19,v19,v11		;# D4 == cypher.hi ?

		vpkuwus	v16,v16,v17
		vpkuwus	v18,v18,v19
		vpkuhum	v16,v16,v18
		vand	v16,v16,v25
		vcmpequb. v16,v16,v12

		;# Now a bit of trickery :
		;# We have to be prepared to deal with up to 16 potential winning
		;# keys, where only the first one is of interest. Beside that, any
		;# partial match (against cypher.lo) that occurs in elements upto
		;# the one that matches both cypher.lo and cypher.hi has to be
		;# registered in the check.count member.
		;# The first byte vector element in v16 which is equal to -1
		;# identifies the first matching key. By shifting and or'ing the
		;# vector elements, we create a mask that will be used to flush all
		;# potential matches after the first one.

		addi	r4,r1,vCheck

		vspltisw v24,0
		vsldoi	v13,v24,v16,15
		vsldoi	v14,v24,v16,7
		vor		v13,v13,v14
		vsldoi	v14,v24,v13,12
		vor		v13,v13,v14
		vsldoi	v14,v24,v13,14
		vor		v13,v13,v14
		vsldoi	v14,v24,v13,15
		vnor	v13,v13,v14
		vand	v25,v25,v13			;# Discard partial matches beyond a full match.
		vsum4sbs v12,v25,v24
		vsumsws	v12,v12,v24
		vsubuwm	v12,v24,v12			;# = number of partial matches

		vspltisw v14,8
		vspltisw v15,9
		vadduwm	v15,v14,v15

		;# Find which key produced the last partial match.
		vsldoi	v13,v24,v25,15
		vsldoi	v14,v24,v25,7
		vor		v13,v13,v14
		vsldoi	v14,v24,v13,12
		vor		v13,v13,v14
		vsldoi	v14,v24,v13,14
		vor		v13,v13,v14
		vsldoi	v14,v24,v13,15
		vnor	v13,v13,v14			;# bitmask

		vsum4sbs v13,v13,v24		;# Collect key offset in LSB
		vsumsws	v13,v13,v15
		vsldoi	v13,v13,v24,12		;# then in MSW

		;# Build a new vCheck vector that contains the last key
		;# and the total number of matches.
		vspltisw v25,-1
		vsldoi	v25,v24,v25,4
		lvx		v24,0,r4			;# vCheck
		lvx		v2,r19,r31			;# vKey
		vand	v24,v24,v25
		vsububm	v13,v2,v13			;# key.hi - offset
		vadduwm	v24,v24,v12			;# Increment check.count
		vor		v13,v13,v24
		stvx	v13,0,r4			;# Store vCheck

		bne-	cr6,key_found		;# One of the keys fully matched !

		;# Re-initialize the inner loop for the next iteration.
		vspltw	v2,v2,0				;# L1[2] = key.hi
		vspltisw v11,4
		vadduwm	v2,v2,v27			;# key.hi + (0,1,2,3)
		vadduwm	v5,v2,v11			;# L2[2] = key.hi + 4
		vadduwm	v8,v5,v11			;# L3[2] = key.hi + 8
		vadduwm	v11,v8,v11			;# L3[2] = key.hi + 12

		vadduwm	v13,v23,v21			;# T1 = A1 + B1
		lvx		v15,r12,r21			;# S0[3]
		vadduwm	v2,v2,v13			;# L1[2] += T1
		vadduwm	v5,v5,v13			;# L2[2] += T2
		vadduwm	v8,v8,v13			;# L3[2] += T3
		vadduwm	v11,v11,v13			;# L4[2] += T4
		vadduwm	v15,v15,v23			;# S1[3] = S0[3] + A1
		vrlw	v2,v2,v13			;# B1 = L1[2] = ROTL(L1[2] + T1, T1)
		vrlw	v5,v5,v13			;# B2 = L2[2] = ROTL(L2[2] + T2, T2)
		vrlw	v8,v8,v13			;# B3 = L3[2] = ROTL(L3[2] + T3, T3)
		vrlw	v11,v11,v13			;# B4 = L4[2] = ROTL(L4[2] + T4, T4)
		bdnz	new_key_hi
		b		next_block


key_found:
		lwz		r5,pIterations(r1)
		lwz		r6,wKIter(r1)		;# iterations / 16
		lwz		r8,0(r5)
		lwz		r9,wCheckHi(r1)
		mfctr	r7					;# Remaining loop iterations
		add		r6,r6,r7
		slwi	r6,r6,4
		andi.	r9,r9,0x0F
		subf	r6,r9,r6
		subf	r6,r6,r8			;# Total remaining iterations.
		stw		r6,0(r5)
		li		r3,RESULT_FOUND


;#============================================================================
;# Epilog : Update the RC5_72UnitWork structure, then restore all non-volatile
;#		registers.
;#		r3 := RESULT_FOUND or RESULT_NOTHING

epilog:
		lwz		r4,pUnitWork(r1)

		;# Update rc5_72unitwork->L0
		lwz		r5,wKeyHi(r1)
		lwz		r6,wKeyMid(r1)
		lwz		r7,wKeyLo(r1)
		stw		r5,L0_hi(r4)
		stw		r6,L0_mid(r4)
		stw		r7,L0_lo(r4)

		;# Update rc5_72unitwork->check
		lwz		r5,wCount(r1)
		lwz		r6,wCheckHi(r1)
		lwz		r7,wCheckMid(r1)
		lwz		r8,wCheckLo(r1)
		stw		r5,check_count(r4)
		stw		r6,check_hi(r4)
		stw		r7,check_mid(r4)
		stw		r8,check_lo(r4)

		;# Restore vector registers
		li		r5,aVectorArea
		lvx		v31,r1,r5
		addi	r5,r5,16
		lvx		v30,r1,r5
		addi	r5,r5,16
		lvx		v29,r1,r5
		addi	r5,r5,16
		lvx		v28,r1,r5
		addi	r5,r5,16
		lvx		v27,r1,r5
		addi	r5,r5,16
		lvx		v26,r1,r5
		addi	r5,r5,16
		lvx		v25,r1,r5
		addi	r5,r5,16
		lvx		v24,r1,r5
		addi	r5,r5,16
		lvx		v23,r1,r5
		addi	r5,r5,16
		lvx		v22,r1,r5
		addi	r5,r5,16
		lvx		v21,r1,r5
		addi	r5,r5,16
		lvx		v20,r1,r5

		;# Restore non-volatile registers
		lwz		r5,wVRSave(r1)
		mtspr	VRsave,r5
		lwz		r2,wSaveR2(r1)

		lwz		r5,0(r1)				;# Caller's stack pointer
		lmw		r13,-GPRsave(r5)
		mr		r1,r5
		blr
