! Copyright distributed.net 2003 - All Rights Reserved
! For use in distributed.net projects only.
! Any other distribution or use of this source violates copyright.
!
! Author: Andreas Beckmann <andreasb@distributed.net>
!
! $Id: r72-anbe2.s,v 1.3 2007/10/22 16:48:36 jlawson Exp $
!
! This 2 pipeline core is optimized for a 1 processor that is able to
! dispatch two integer instructions (but only one shift, which must be the
! first of the two) and one load/store instruction per cycle. The branches
! have been scheduled to be at least 4 instructions apart for improved
! UltraSPARC-III performance.
! The scheduling works optimally on an UltraSPARC-I/II processor, both integer
! units are always busy. The mainloop (per key: 1067 instructions: 954 integer,
! 111 load/store, 2 branch and 477.5 cycles, 2.23 instr/cycle) is maximally
! optimized, but exceeds the size of the L1I cache by ~350 bytes.
! Tested on an UltraSPARC-II processor with 16 KB L1I cache.
! Tested on an UltraSPARC-III processor with 32 KB L1I cache, but there the
! core runs a cycle slower at 478.5 cycles/key.
!
!
! ***** Do NOT edit THIS file, edit r72-anbe2.gcc.S instead! *****
!
! This file was generated from r72-anbe2.gcc.S using the command
! gcc -E -P r72-anbe2.gcc.S | perl -pe '... see r72-anbe2.gcc.S ...' > r72-anbe2.s
! (the full perl formatting expression can be viewed in r72-anbe2.gcc.S)


.section ".text"

! extern "C" s32 rc5_72_unit_func_anbe_2( RC5_72UnitWork *, u32 *, void *)
.global rc5_72_unit_func_anbe_2
rc5_72_unit_func_anbe_2:

! Input:
! %i0 = RC5_72UnitWork *
! %i1 = u32* iterations
! %i2 = (unused)

! Output:
! [rc5_72unitwork]
! [iterations]
! %i0 = RESULT_{NOTHING|FOUND}
        save	%sp,-(((4*(16+1+6))+(44 +2*4+3*4)+4*(1+2*26+26))+(((4*(16+1+6))+(44 +2*4+3*4)+4*(1+2*26+26)) % 8)),%sp
        st	%i7,[%sp+(4*(16+1+6))+0]

        st	%i0,[%fp-44 -4]
! copy r72unitwork to %sp+(4*(16+1+6))
        ld	[%i0+0],%l0
        ld	[%i0+4],%l1
        ld	[%i0+8],%l2
        ld	[%i0+12],%l3
        ld	[%i0+28],%l4
        ld	[%i0+32],%l5
        ld	[%i0+36],%l6
        ld	[%i0+40],%l7
        st	%l0,[%fp-44 +(0)]
        st	%l1,[%fp-44 +(4)]
        st	%l2,[%fp-44 +(8)]
        st	%l3,[%fp-44 +(12)]
        st	%l4,[%fp-44 +(28)]
        st	%l5,[%fp-44 +(32)]
        st	%l6,[%fp-44 +(36)]
        st	%l7,[%fp-44 +(40)]
        st	%i1,[%fp-44 -8]
! about registers
! do not use %sp, %fp, %g0, %g5, %g6, %g7
! save before use: %i7
! all other registers are available for free use unless we are going to call
! some functions

! free registers: none
        ld	[%i1],%i2
        ld	[%i0+16],%l5
        ld	[%i0+20],%l4
        ld	[%i0+24],%o5

KEYINIT:
!! S[i] = 0xB7E15163 + i*0x9E3779B9
!! Sinit[0] = 0xB7E15163
!! Sinit[i] = Sinit[i-1]+0x9E3779B9


        set	0xB7E15163,%o4
        set	0x9E3779B9,%o3
        st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*0)]

        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*1)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*2)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*3)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*4)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*5)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*6)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*7)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*8)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*9)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*10)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*11)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*12)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*13)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*14)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*15)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*16)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*17)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*18)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*19)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*20)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*21)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*22)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*23)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*24)]
        add	%o4,%o3,%o4
	st	%o4,[%sp+(4*(16+1+6))+4+8*26+(4*25)]

! preset constant values: s0
ROUND1_S_i0_j0:
        !! S[0] = ROTL3(S[0])
        set	0xBF0A8B1D,%l6
        st	%l6,[%fp-44 -8 -4]

! precalculate seldom changing values in ROUND1: s1, s2, l0, l1
ROUND1_L_i0_j0_init:
	ld	[%fp-44 -8 -4], %l6
	add	%o5,%l6,%i3
	sll	%i3,(0xBF0A8B1D % 32),%l2
	srl	%i3,(32 - (0xBF0A8B1D % 32)),%i3
	or	%i3,%l2,%o3
ROUND1_S_i1_j1_init:
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*1)],%o7
	add	%l6,%o3,%l0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	srl	%l0,29,%l0
	or	%l0,%l2,%l7
	st	%l7,[%fp-44 -8 -4 -4]
CALCULATE_RGLmid_DEPS_init:
	ROUND1_L_i1_j1_init: ld [%fp-44 -8 -4 -4],%l7
	add	%l7,%o3,%l2
	add	%l4,%l2,%i4
	sll	%i4,%l2,%g1
	neg	%l2
	srl	%i4,%l2,%i4
	or	%i4,%g1,%o4
ROUND1_S_i2_j2_init:
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*2)],%o7
	add	%l7,%o4,%l0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	srl	%l0,29,%l0
	or	%l0,%l2,%o1
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*3)],%o7
	add	%o4,%o1,%i0
	add	%o1,%o7,%i1
	st	%o1,[%fp-44 -8 -4 -4 -4]

! ##########################################################################

INLINE_ROUND1_L_i2_j2:
        add	%l5,%i0,%o7

        sll	%o7,%i0,%g1
        neg	%i0,%l3

        srl	%o7,%l3,%i5
        add	%o7,1,%o0

        sll	%o0,%i0,%g2
        or	%i5,%g1,%i5

        srl	%o0,%l3,%o0
        add	%i1,%i5,%l0

        b	mainloop
        nop
.align 16
mainloop:

! ROUND 1 - key expansion
        ! Precalculated:
        !! S[0] = ROTL3(S[0])
        ! RCS0	= RCP_ROTL3
        !! L[0] = ROTL(L[0]+S[0],S[0])
        ! %o3 = ROTL(%o5+RCS0,0xBF0A8B1D)
        !! S[1] = ROTL3(S[1]+(S[0]+L[0]))
        ! RGS1	= ROTL3(Sinit[1]+RCS0+%o3)
        !! L[1] = ROTL(L[1]+(S[1]+L[0]),(S[1]+L[0]))
        ! %o4 = ROTL(%l4+(RGS1+%o3),(RGS1+%o3))
        !! S[2] = ROTL3(S[2]+S[1]+L[1])
        ! RGS2	= ROTL3(Sinit[2]+RGS1+%o4)
        ! %i0 = %o4+RGS2
        ! %i1 = RGS2+Sinit[3]


!INLINE_ROUND1_L_i2_j2:
        !! L[2] = ROTL(L[2]+(S[2]+L[1]),(S[2]+L[1]))
!INLINE_ROUND1_S_i3_j0:


        sll	%l0,3,%l2
        or	%o0,%g2,%o0

        srl	%l0,29,%l0
        add	%i1,%o0,%l1

        sll	%l1,3,%l3
        or	%l0,%l2,%l0

        srl	%l1,29,%l1
        add	%l0,%i5,%l2


        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! L[j] = ROTL(L[j]+(S[i]+L[j-1]),(S[i]+L[j-1]))

        !! the	ROUND1*(i,j,*) macros calculate the values reordered:
        !! L[j-1] = ROTL(L[j-1]+(S[i-1]+L[j-2]),(S[i-1]+L[j-2]))
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])


ROUND1_L_S_i4_j1:
	or	%l1,%l3,%l1
	add	%o3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((4 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((4 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%o3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*4)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND1_L_S_i5_j2:
	or	%l1,%l3,%l1
	add	%o4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((5 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((5 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%o4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*5)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND1_L_S_i6_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((6 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((6 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*6)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND1_L_S_i7_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((7 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((7 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*7)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND1_L_S_i8_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((8 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((8 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*8)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND1_L_S_i9_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((9 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((9 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*9)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND1_L_S_i10_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((10 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((10 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*10)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND1_L_S_i11_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((11 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((11 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*11)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND1_L_S_i12_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((12 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((12 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*12)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND1_L_S_i13_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((13 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((13 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*13)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND1_L_S_i14_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((14 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((14 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*14)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND1_L_S_i15_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((15 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((15 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*15)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND1_L_S_i16_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((16 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((16 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*16)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND1_L_S_i17_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((17 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((17 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*17)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND1_L_S_i18_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((18 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((18 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*18)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND1_L_S_i19_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((19 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((19 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*19)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND1_L_S_i20_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((20 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((20 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*20)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND1_L_S_i21_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((21 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((21 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*21)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND1_L_S_i22_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((22 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((22 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*22)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND1_L_S_i23_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((23 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((23 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*23)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND1_L_S_i24_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((24 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((24 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*24)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND1_L_S_i25_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((25 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((25 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*25)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2


INLINE_ROUND1_L_i26_j2:


        or	%l1,%l3,%l1

        add	%i4,%l2,%i4

        st	%l0,[%sp+(4*(16+1+6))+4+8*(((26 -1)+26) % 26)]

        add	%l1,%g3,%l3
        neg	%l2,%g1
        st	%l1,[%sp+(4*(16+1+6))+4+8*(((26 -1)+26) % 26)+4]

        sll	%i4,%l2,%l2
        add	%g4,%l3,%g4


        srl	%i4,%g1,%i4
        neg	%l3,%g2

        sll	%g4,%l3,%l3
        or	%i4,%l2,%i4
        ld	[%fp-44 -8 -4], %o7

        srl	%g4,%g2,%g4


! ############################################################################
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! L[j] = ROTL(L[j]+(S[i]+L[j-1]),(S[i]+L[j-1]))

        !! the	ROUND2*(i,j,*) macros calculate the values reordered:
        !! L[j-1] = ROTL(L[j-1]+(S[i-1]+L[j-2]),(S[i-1]+L[j-2]))
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])


INLINE_ROUND2_START_S_PREC_i0_j2:


        add	%l0,%i4,%l0

        or	%g4,%l3,%g4


        add	%l0,%o7,%l0

        sll	%l0,3,%l2
        add	%l1,%g4,%l1

        srl	%l0,29,%l0


        add	%l1,%o7,%l1

        sll	%l1,3,%l3
        or	%l0,%l2,%l0

        srl	%l1,29,%l1
        add	%l0,%i4,%l2
        ld	[%fp-44 -8 -4 -4],%o7

ROUND2_L_S_prec_i1_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((1 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((1 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
        ld	[%fp-44 -8 -4 -4 -4],%o7

ROUND2_L_S_prec_i2_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((2 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((2 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%o7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i3_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((3 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((3 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((3)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((3)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i4_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((4 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((4 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((4)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((4)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND2_L_S_i5_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((5 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((5 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((5)+26) % 26)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((5)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i6_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((6 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((6 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((6)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((6)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i7_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((7 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((7 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((7)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((7)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND2_L_S_i8_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((8 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((8 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((8)+26) % 26)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((8)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i9_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((9 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((9 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((9)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((9)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i10_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((10 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((10 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((10)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((10)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND2_L_S_i11_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((11 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((11 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((11)+26) % 26)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((11)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i12_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((12 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((12 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((12)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((12)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i13_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((13 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((13 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((13)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((13)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND2_L_S_i14_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((14 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((14 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((14)+26) % 26)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((14)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i15_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((15 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((15 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((15)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((15)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i16_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((16 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((16 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((16)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((16)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND2_L_S_i17_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((17 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((17 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((17)+26) % 26)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((17)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i18_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((18 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((18 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((18)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((18)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i19_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((19 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((19 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((19)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((19)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND2_L_S_i20_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((20 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((20 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((20)+26) % 26)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((20)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i21_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((21 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((21 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((21)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((21)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i22_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((22 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((22 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((22)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((22)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2
ROUND2_L_S_i23_j1:
	or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((23 -1)+26) % 26)]
	add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((23 -1)+26) % 26)+4]
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((23)+26) % 26)],%o7
	srl	%g3,%g2,%g3
	add	%l0,%i3,%l0
	or	%g3,%l3,%g3
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((23)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g3,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i3,%l2
ROUND2_L_S_i24_j2:
	or	%l1,%l3,%l1
	add	%i4,%l2,%i4
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((24 -1)+26) % 26)]
	add	%l1,%g3,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((24 -1)+26) % 26)+4]
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	ld	[%sp+(4*(16+1+6))+4+8*(((24)+26) % 26)],%o7
	srl	%g4,%g2,%g4
	add	%l0,%i4,%l0
	or	%g4,%l3,%g4
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((24)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%g4,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i4,%l2
ROUND2_L_S_i25_j0:
	or	%l1,%l3,%l1
	add	%i5,%l2,%i5
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((25 -1)+26) % 26)]
	add	%l1,%g4,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((25 -1)+26) % 26)+4]
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	ld	[%sp+(4*(16+1+6))+4+8*(((25)+26) % 26)],%o7
	srl	%o0,%g2,%o0
	add	%l0,%i5,%l0
	or	%o0,%l3,%o0
	add	%l0,%o7,%l0
	ld	[%sp+(4*(16+1+6))+4+8*(((25)+26) % 26)+4],%i7
	sll	%l0,3,%l2
	add	%l1,%o0,%l1
	srl	%l0,29,%l0
	add	%l1,%i7,%l1
	sll	%l1,3,%l3
	or	%l0,%l2,%l0
	srl	%l1,29,%l1
	add	%l0,%i5,%l2


INLINE_ROUND2_END_L_i26_j1:


        or	%l1,%l3,%l1
	add	%i3,%l2,%i3
	st	%l0,[%sp+(4*(16+1+6))+4+8*(((26 -1)+26) % 26)]


        add	%l1,%o0,%l3
	neg	%l2,%g1
	st	%l1,[%sp+(4*(16+1+6))+4+8*(((26 -1)+26) % 26)+4]


        sll	%i3,%l2,%l2
	add	%g3,%l3,%g3


        srl	%i3,%g1,%i3
	neg	%l3,%g2


        sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	ld	[%sp+(4*(16+1+6))+4+8*(((0)+26) % 26)],%o7


        srl	%g3,%g2,%g3
	add	%l0,%i3,%l0

        ld	[%sp+(4*(16+1+6))+4+8*(((0)+26) % 26)+4],%i7

        or	%g3,%l3,%g3


! ############################################################################

! ROUND 3 - key expansion and encryption
!
! ROUND3EVEN(i,j) = ROUND3(i,j,A,B)
! ROUND3ODD (i,j) = ROUND3(i,j,B,A)
! ROUND3(i,j,A,B) =
! S[i] = ROTL3(S[i]+(S[i-1]+Lpred[j]))
! L[j] = ROTL(L[j]+(S[i]+Lpred[j]),(S[i]+Lpred[j]))
! A = ROTL(A^B,B) + S[i]
! lets reorder this a bit ...
! * A depends on S[i] (in A's last operation)'
! * L[j] depends on S[i] (in L's first operation)'
! * S[i] depends on Lpred[j] (in S's first or second operation'
! * we don't need to calculate L[j] for i=25'
! * this ordering allows better instruction sceduling because the S[i]->L[j]
! dependency is no longer in adjacent operations
! ROUND3(i,j,A,B) =
! L[j-1] = ROTL(L[j-1]+(S[i-1]+Lpred[j-1]),(S[i-1]+Lpred[j-1]))
! S[i] = ROTL3(S[i]+(S[i-1]+Lpred[j]))
! A = ROTL(A^B,B) + S[i]
! Note: L[j-1] actually is L[(j-1) % 3]
! Note: there is a special A calculation for i=0 and i=1 (A initialization)
! Note: ROUND3(0,...) just needs to calculate S[0]
! lets translate this into some other variable names
! ROUND3(i,j,A,B) = ROUND3_LSA(i,j,A,B,Lpred[j],Lpred[j-1])
! ROUND3_LSA(i,j,A,B,Lprd,Lcur) =
! Lcur = ROTL(Lcur+(SS+Lprd),(SS+Lprd))
! SS = ROTL3(S[i]+SS+Lcur)
! A = ROTL(A^B,B) + SS
! split into basic oprations:
! ROUND3_LSA(i,j,A,B,Lprd,Lcur) =
! T1 = SS+Lprd
! Lcur = Lcur+T1
! Lcur = ROTL(Lcur,T1)
! T2 = S[i]
! SS = SS+T2
! SS = SS+Lcur
! SS = ROTL3(SS)
! A = A^B
! A = ROTL(A^B,B)
! A = A+SS
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! L[j] = ROTL(L[j]+(S[i]+L[j-1]),(S[i]+L[j-1]))
        !! i	even:
        !! A	= ROTL(A^B,B)+S[i]
        !! i	odd:
        !! B	= ROTL(B^A,A)+S[i]

        !! the	ROUND3*(i,j,A,B,*) macros calculate the values reordered:
        !! L[j-1] = ROTL(L[j-1]+(S[i-1]+L[j-2]),(S[i-1]+L[j-2]))
        !! S[i] = ROTL3(S[i]+S[i-1]+L[j-1])
        !! A	= ROTL(A^B)+S[i]


INLINE_ROUND3_i0_j1___i1_j2:
        add	%l0,%o7,%l0
        ld	[%fp-44 +(4)],%o1

        sll	%l0,3,%l2
        add	%l1,%g3,%l1
        ld	[%fp-44 +(0)],%o2

        srl	%l0,29,%l0
        add	%l1,%i7,%l1

        sll	%l1,3,%l3
        or	%l0,%l2,%l0

        srl	%l1,29,%l1
        add	%o1,%l0,%l6

        or	%l1,%l3,%l1
        add	%l0,%i3,%l2

        add	%o1,%l1,%o1
        add	%l1,%g3,%l3
        ld	[%sp+(4*(16+1+6))+4+8*(((1)+26) % 26)],%o7

        add	%i4,%l2,%i4
        add	%g4,%l3,%g4
        ld	[%sp+(4*(16+1+6))+4+8*(((1)+26) % 26)+4],%i7

        sll	%i4,%l2,%g1
        neg	%l2

        srl	%i4,%l2,%i4
        add	%l0,%o7,%l0

        sll	%g4,%l3,%g2
        neg	%l3

        srl	%g4,%l3,%g4
        or	%i4,%g1,%i4

        add	%l1,%i7,%l1
        add	%l0,%i4,%l0

        sll	%l0,3,%l2
        or	%g4,%g2,%g4

        srl	%l0,29,%l0
        add	%l1,%g4,%l1

        sll	%l1,3,%l3
        or	%l0,%l2,%l0

        srl	%l1,29,%l1
        add	%o2,%l0,%l7

        or	%l1,%l3,%l1


ROUND3_L_S_A_i2_j0:
	add	%l0,%i4,%l2
	add	%o2,%l1,%o2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((2)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((2)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1


ROUND3_L_S_A_i3_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((3)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((3)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i4_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((4)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((4)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i5_j0:
	add	%l0,%i4,%l2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((5)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((5)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i6_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((6)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((6)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i7_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((7)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((7)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i8_j0:
	add	%l0,%i4,%l2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((8)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((8)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i9_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((9)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((9)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i10_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((10)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((10)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i11_j0:
	add	%l0,%i4,%l2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((11)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((11)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i12_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((12)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((12)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i13_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((13)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((13)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i14_j0:
	add	%l0,%i4,%l2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((14)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((14)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i15_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((15)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((15)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i16_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((16)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((16)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i17_j0:
	add	%l0,%i4,%l2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((17)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((17)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i18_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((18)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((18)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i19_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((19)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((19)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i20_j0:
	add	%l0,%i4,%l2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((20)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((20)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i21_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((21)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((21)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
ROUND3_L_S_A_i22_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((22)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((22)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1
ROUND3_L_S_A_i23_j0:
	add	%l0,%i4,%l2
	add	%l1,%g4,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((23)+26) % 26)],%o7
	add	%i5,%l2,%i5
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((23)+26) % 26)+4],%i7
	sll	%i5,%l2,%l2
	add	%o0,%l3,%o0
	srl	%i5,%g1,%i5
	neg	%l3,%g2
	sll	%o0,%l3,%l3
	or	%i5,%l2,%i5
	srl	%o0,%g2,%o0
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i5,%l0
	sll	%l0,3,%o7
	or	%o0,%l3,%o0
	srl	%l0,29,%l0
	add	%l1,%o0,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2


ROUND3_L_S_A_i24_j1:
	add	%l0,%i5,%l2
	add	%l1,%o0,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((24)+26) % 26)],%o7
	add	%i3,%l2,%i3
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((24)+26) % 26)+4],%i7
	sll	%i3,%l2,%l2
	add	%g3,%l3,%g3
	srl	%i3,%g1,%i3
	neg	%l3,%g2
	sll	%g3,%l3,%l3
	or	%i3,%l2,%i3
	srl	%g3,%g2,%g3
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i3,%l0
	sll	%l0,3,%o7
	or	%g3,%l3,%g3
	srl	%l0,29,%l0
	add	%l1,%g3,%l1
	sll	%l1,3,%i7
	xor	%l6,%l7,%l6
	srl	%l1,29,%l1
	neg	%l7,%g1
	sll	%l6,%l7,%l2
	xor	%o1,%o2,%o1
	srl	%l6,%g1,%l6
	neg	%o2,%g2
	sll	%o1,%o2,%l3
	or	%l0,%o7,%l0
	srl	%o1,%g2,%o1
	or	%l1,%i7,%l1
	ld	[%fp-44 +(12)],%i7
	or	%l6,%l2,%l6
	or	%o1,%l3,%o1
	add	%l6,%l0,%l6
	add	%o1,%l1,%o1


! delay ROUND3ODD_i25_j2 (calculates cypher_hi) after a successful
! cypher_lo test

! ############################################################################

        ! For	optimal UltraSPARC-III performance, branches should be at least
        ! 4	instructions apart.
        ! Predict	'NOT complex_increment' and start operations of the next
        ! iteration, to put them between the branch instructions.
        ! In	case of a mispredict (prob: 1/256 keys) redo these ops at the
        ! end	of complex_increment with updated values of %l5, %i0 etc.


test_pipe_1:
        cmp	%l6,%i7
        be	partial_success
         add	%l5,2,%l5

test_pipe_2:
        cmp	%o1,%i7
        ! redo	the following 3 ops after partial_success
        add	%l5,%i0,%o7

        sll	%o7,%i0,%g1
        be	partial_success
         neg	%i0,%l3

increment_key:


        srl	%o7,%l3,%i5
        andcc	%l5,0xff,%l5

        add	%o7,1,%o0
        bz	complex_increment
         subcc	%i2,2,%i2

increment_key_done:
        sll	%o0,%i0,%g2
        or	%i5,%g1,%i5

        srl	%o0,%l3,%o0

        bnz	mainloop
         add	%i1,%i5,%l0

! ############################################################################

end_of_mainloop:
        b	finish
         mov	1,%i0

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

complex_increment:
        ! increment	%l4
        set	0x01000000,%o1
        set	0xFF000000,%o2
        add	%l4,%o1,%l4
        btst	%o2,%l4
        bnz	update_RGLmid
         set	0x00010000,%l3
        !set	0x00FFFFFF,RI0x00FFFFFF !!! 2 ops
        !sub	%o1,1,RI0x00FFFFFF
        add	%l4,%l3,%l4
        set	0x00FF0000,%g3
        !and	%l4,RI0x00FFFFFF,%l4
        andn	%l4,%o2,%l4
        btst	%g3,%l4
        bnz	update_RGLmid
         sub	%l3,1,%g4
        add	%l4,0x0100,%l4
        !set	0x0000FF00,%o0 !!! 2 ops
        andn	%g4,0xff,%o0
        and	%l4,%g4,%l4
        btst	%o0,%l4
        bnz	update_RGLmid
         nop
        add	%l4,0x01,%l4
        andcc	%l4,0xff,%l4
        bnz	update_RGLmid
         nop

        ! increment	%o5
        add	%o5,%o1,%o5
        btst	%o2,%o5
        bnz	update_RGLlo
         nop
        add	%o5,%l3,%o5
        !and	%o5,RI0x00FFFFFF,%o5
        andn	%o5,%o2,%o5
        btst	%g3,%o5
        bnz	update_RGLlo
         nop
        add	%o5,0x0100,%o5
        and	%o5,%g4,%o5
        btst	%o0,%o5
        bnz	update_RGLlo
         nop
        add	%o5,0x01,%o5
        and	%o5,0xff,%o5
        !b	update_RGLlo
        ! nop

update_RGLlo:
        ! update	precalculated values %o3, RGS1, %o4, RGS2

        ! first	calculate %o3, RGS1
ROUND1_L_i0_j0_increment:
	ld	[%fp-44 -8 -4], %l6
	add	%o5,%l6,%i3
	sll	%i3,(0xBF0A8B1D % 32),%l2
	srl	%i3,(32 - (0xBF0A8B1D % 32)),%i3
	or	%i3,%l2,%o3
ROUND1_S_i1_j1_increment:
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*1)],%o7
	add	%l6,%o3,%l0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	srl	%l0,29,%l0
	or	%l0,%l2,%l7
	st	%l7,[%fp-44 -8 -4 -4]
        ! and	fall through to calculate %o4, RGS2

update_RGLmid:
        ! update	precalculated values %o4, RGS2

CALCULATE_RGLmid_DEPS_increment:
	ROUND1_L_i1_j1_increment: ld [%fp-44 -8 -4 -4],%l7
	add	%l7,%o3,%l2
	add	%l4,%l2,%i4
	sll	%i4,%l2,%g1
	neg	%l2
	srl	%i4,%l2,%i4
	or	%i4,%g1,%o4
ROUND1_S_i2_j2_increment:
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*2)],%o7
	add	%l7,%o4,%l0
	add	%l0,%o7,%l0
	sll	%l0,3,%l2
	srl	%l0,29,%l0
	or	%l0,%l2,%o1
	ld	[%sp+(4*(16+1+6))+4+8*26+(4*3)],%o7
	add	%o4,%o1,%i0
	add	%o1,%o7,%i1
	st	%o1,[%fp-44 -8 -4 -4 -4]

        ! redo	operations from begin-of-mainloop that have been moved to the
        ! end	of the loop to bring the branches more apart
        ! because	they have been calculated before complex_increment and we
        ! are	in complex_increment, the prediction has been wrong and we have
        ! to	redo a bit of work ...
        add	%l5,%i0,%o7
        sll	%o7,%i0,%g1
        neg	%i0,%l3
        srl	%o7,%l3,%i5
        add	%o7,1,%o0
        !sll	%o0,%i0,%g2
        !or	%i5,%g1,%i5
        !srl	%o0,%l3,%o0
        !add	%i1,%i5,%l0

        b	increment_key_done
         subcc	%i2,0,%i2

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

partial_success:
ROUND3_L_S_A_i25_j2:
	add	%l0,%i3,%l2
	add	%l1,%g3,%l3
	ld	[%sp+(4*(16+1+6))+4+8*(((25)+26) % 26)],%o7
	add	%i4,%l2,%i4
	neg	%l2,%g1
	ld	[%sp+(4*(16+1+6))+4+8*(((25)+26) % 26)+4],%i7
	sll	%i4,%l2,%l2
	add	%g4,%l3,%g4
	srl	%i4,%g1,%i4
	neg	%l3,%g2
	sll	%g4,%l3,%l3
	or	%i4,%l2,%i4
	srl	%g4,%g2,%g4
	add	%l0,%o7,%l0
	add	%l1,%i7,%l1
	add	%l0,%i4,%l0
	sll	%l0,3,%o7
	or	%g4,%l3,%g4
	srl	%l0,29,%l0
	add	%l1,%g4,%l1
	sll	%l1,3,%i7
	xor	%l7,%l6,%l7
	srl	%l1,29,%l1
	neg	%l6,%g1
	sll	%l7,%l6,%l2
	xor	%o2,%o1,%o2
	srl	%l7,%g1,%l7
	neg	%o1,%g2
	sll	%o2,%o1,%l3
	or	%l0,%o7,%l0
	srl	%o2,%g2,%o2
	or	%l1,%i7,%l1
	or	%l7,%l2,%l7
	or	%o2,%l3,%o2
	add	%l7,%l0,%l7
	add	%o2,%l1,%o2
        ld	[%fp-44 +(12)],%i7
        cmp	%l6,%i7
        bne	test_pipe_2_lo_success
         ld	[%fp-44 +(8)],%g1
test_pipe_1_lo_success:
        ld	[%fp-44 +(28)],%l2
        inc	%l2
        st	%l4,[%fp-44 +(36)]
        st	%l2,[%fp-44 +(28)]
        add	%l5,-2 +0,%l3
        st	%o5,[%fp-44 +(40)]
        !st	%l5,[%fp-44 +(32)]
        st	%l3,[%fp-44 +(32)]
        cmp	%l7,%g1
        be	test_pipe_1_lohi_success
         cmp	%o1,%i7
        bne	only_partial_success
         nop
test_pipe_2_lo_success:
        ld	[%fp-44 +(28)],%l3
        inc	%l3
        st	%l4,[%fp-44 +(36)]
        st	%l3,[%fp-44 +(28)]
        add	%l5,-2 +1,%l3
        st	%o5,[%fp-44 +(40)]
        !st	%l5,[%fp-44 +(32)]
        st	%l3,[%fp-44 +(32)]
        cmp	%o2,%g1
        bne	only_partial_success
         nop
test_pipe_2_lohi_success:
        ld	[%fp-44 -8],%l3
        ld	[%l3],%g2
        sub	%g2,%i2,%g2
        inc	%g2
        st	%g2,[%l3]
        b	finish
         mov	2,%i0
only_partial_success:
        ! redo	these three ops here because they were skipped because of
        ! partial_success	or the registers have been reused for other stuff
        ! during	handling of partial_success
        add	%l5,%i0,%o7
        sll	%o7,%i0,%g1
        b	increment_key
         neg	%i0,%l3
test_pipe_1_lohi_success:
        ld	[%fp-44 -8],%l2
        ld	[%l2],%g1
        sub	%g1,%i2,%g1
        st	%g1,[%l2]
        !b	finish
         mov	2,%i0

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

finish:

! copy r72unitwork from %sp+(4*(16+1+6)) back into supplied memory
        ld	[%fp-44 -4],%g1
        st	%l5,[%g1+16]
        st	%l4,[%g1+20]
        st	%o5,[%g1+24]
        ld	[%fp-44 +(28)],%l0
        ld	[%fp-44 +(32)],%l1
        ld	[%fp-44 +(36)],%l2
        ld	[%fp-44 +(40)],%l3
        st	%l0,[%g1+28]
        st	%l1,[%g1+32]
        st	%l2,[%g1+36]
        st	%l3,[%g1+40]

        ld	[%sp+(4*(16+1+6))+0],%i7

        ret
        restore
