// ScreenSaver.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "ScreenSaver.h"
#include "ScrnSave.h"
#include "ConfigureDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScreenSaverApp

BEGIN_MESSAGE_MAP(CScreenSaverApp, CWinApp)
	//{{AFX_MSG_MAP(CScreenSaverApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScreenSaverApp construction

CScreenSaverApp::CScreenSaverApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CScreenSaverApp object

CScreenSaverApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CScreenSaverApp initialization

BOOL CScreenSaverApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.
	
	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

char szAppName[APPNAMEBUFFERLEN] = "Just A Test";

#define ID_TIMER 1

void ShowLog(HWND hWnd);

#define REG_REFRESH_RATE "RefreshRate"
#define REG_NUMBER_OF_LINES "NumberOfLines"
#define REG_FILENAME "Filename"
#define REG_MAIN "RC5_Log_ScreenSaver"
#define DEFAULT_NUMBER_OF_LINES 5
#define DEFAULT_REFRESH_RATE 60
#define DEFAULT_FILENAME ""

LRESULT WINAPI ScreenSaverProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{	
    switch(message) 
    { 
        case WM_CREATE:
		{
			time_t t;
			t=time(&t);
			srand(t);
			SetTimer(hWnd,ID_TIMER, 1,NULL);
			break;
		}
        case WM_TIMER:
		{
			if(wParam == ID_TIMER)
			{				
				ShowLog(hWnd);
			}
			break;
		}

		case WM_ERASEBKGND:
		{
			RECT rc;
			HDC hdc;
            hdc = GetDC(hWnd); 
            GetClientRect (hWnd, &rc);
			HBRUSH hBrush = CreateSolidBrush(RGB(0,0,0));
            FillRect (hdc, &rc, hBrush); 
			DeleteObject(hBrush);
            ReleaseDC(hWnd,hdc); 
            break;  
		}

        case WM_DESTROY:
		{
			KillTimer(hWnd,ID_TIMER);
            break; 
		}
    } 
 
   /* 
    * DefScreenSaverProc processes any messages 
    * ignored by ScreenSaverProc.  
    */ 
 
    return DefScreenSaverProc(hWnd, message, wParam, lParam); 
 
}

BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) 
{    
	switch(message) 
    {		
        case WM_COMMAND:
		{
			switch(LOWORD(wParam))
            {                 
				case IDOK:
				{
					char sFilename[255];
					char sTemp[10];
					long nRefreshRate,nNumberOfLines;
					HWND hEdFilename = GetDlgItem(hDlg,IDC_ED_FILENAME);
					GetWindowText( hEdFilename,sFilename,254);
					HWND hEdRefreshRate = GetDlgItem(hDlg,IDC_ED_REFRESH_RATE);
					GetWindowText( hEdRefreshRate,sTemp,9);
					nRefreshRate = atol(sTemp);
					HWND hEdNumberOfLines = GetDlgItem(hDlg,IDC_ED_NUMBER_OF_LINES);
					GetWindowText( hEdNumberOfLines,sTemp,9);
					nNumberOfLines = atol(sTemp);
					CWinApp* pApp = AfxGetApp();
					pApp->WriteProfileString(REG_MAIN, REG_FILENAME, sFilename);
					pApp->WriteProfileInt(REG_MAIN, REG_REFRESH_RATE, nRefreshRate);
					pApp->WriteProfileInt(REG_MAIN,REG_NUMBER_OF_LINES, nNumberOfLines);
					EndDialog(hDlg,IDOK);
					return TRUE;
					break;
				}
                case IDCANCEL:
				{
                    EndDialog(hDlg,IDCANCEL);
					return TRUE;
					break;
				}
				case IDC_BUT_BROWSE:
				{
					CString sFilename;
					CWinApp* pApp = AfxGetApp();
					sFilename = pApp->GetProfileString(REG_MAIN, REG_FILENAME, DEFAULT_FILENAME);
					CFileDialog fileDlg(TRUE,NULL,sFilename,OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST,NULL,NULL);
					if(fileDlg.DoModal() == IDOK)
					{						
						CWinApp* pApp = AfxGetApp();
						pApp->WriteProfileString(REG_MAIN,REG_FILENAME, fileDlg.GetPathName());
						HWND hEdFilename = GetDlgItem(hDlg,IDC_ED_FILENAME);
						SetWindowText( hEdFilename,fileDlg.GetPathName());
						InvalidateRect(hEdFilename,NULL,TRUE);
					}
					break;
				}
			}
			break;
		}
		case WM_INITDIALOG:
		{
			CString sFilename;
			long nRefreshRate;
			long nNumberOfLines;
			CString sTemp;
			CWinApp* pApp = AfxGetApp();
			sFilename = pApp->GetProfileString(REG_MAIN, REG_FILENAME, DEFAULT_FILENAME);
			HWND hEdFilename = GetDlgItem(hDlg,IDC_ED_FILENAME);			
			nRefreshRate = pApp->GetProfileInt(REG_MAIN, REG_REFRESH_RATE, DEFAULT_REFRESH_RATE);
			HWND hEdRefreshRate = GetDlgItem(hDlg,IDC_ED_REFRESH_RATE);
			nNumberOfLines = pApp->GetProfileInt(REG_MAIN, REG_NUMBER_OF_LINES, DEFAULT_NUMBER_OF_LINES);
			HWND hEdNumberOfLines = GetDlgItem(hDlg,IDC_ED_NUMBER_OF_LINES);
			sTemp.Format("%li",nRefreshRate);
			SetWindowText( hEdRefreshRate,sTemp);
			sTemp.Format("%li",nNumberOfLines);
			SetWindowText( hEdNumberOfLines,sTemp);
			SetWindowText( hEdFilename,sFilename);			
			return TRUE;
			break;
		}
	}
	return FALSE;
}
 
BOOL WINAPI RegisterDialogClasses (HANDLE hInst)
{
	return TRUE;
}


void ShowLog(HWND hWnd)
{
	HDC hdc;
	CStringArray sLastLines;
	hdc = GetDC(hWnd);

	HFONT hFont=CreateFont(25,0,0,0,FW_BOLD,0,0,0,0,OUT_TT_PRECIS,CLIP_TT_ALWAYS,PROOF_QUALITY,FIXED_PITCH,"Courier New");

	COLORREF OldForColor = SetTextColor(hdc,RGB(3,73,124)); 
	COLORREF OldBackColor = SetBkColor(hdc,RGB(0,0,0));				
	
	HGDIOBJ OldObject = SelectObject(hdc,hFont); 

	TEXTMETRIC metric;
	GetTextMetrics(hdc,&metric);

	RECT rc;
	//clear Screen
	HBRUSH hBrush = CreateSolidBrush(RGB(0,0,0));
	GetClientRect (hWnd, &rc);
	FillRect (hdc, &rc, hBrush); 
	DeleteObject(hBrush);


	CWinApp* pApp = AfxGetApp();	
	CString sFilename = pApp->GetProfileString(REG_MAIN,REG_FILENAME, DEFAULT_FILENAME);
	long nNumberOfLines = max(1,pApp->GetProfileInt(REG_MAIN, REG_NUMBER_OF_LINES, DEFAULT_NUMBER_OF_LINES));
	nNumberOfLines = min(nNumberOfLines,rc.bottom/metric.tmHeight);
	 
	try
	{
		CStdioFile fLogFile(sFilename,CFile::modeRead);
		CString sLine;				
		while(fLogFile.ReadString(sLine) == TRUE)
		{
			sLastLines.Add(sLine);
			if(sLastLines.GetSize() > nNumberOfLines)
			{
				sLastLines.RemoveAt(0);
			}
		}
	}
	catch (...)
	{
		CString sWarning;
		sWarning.Format("File %s NOT found !",sFilename);
		sLastLines.Add(sWarning);
	}
	
	int nBottom = rc.bottom - (metric.tmHeight * sLastLines.GetSize());

	int nRandom = rand() + 1;

	int y=(nBottom * nRandom) / RAND_MAX;
	for(int i=0;i<sLastLines.GetSize();i++)
	{
		TextOut(hdc, 10,y,sLastLines[i],sLastLines[i].GetLength());
		y += metric.tmHeight;
	}				
	SetBkColor(hdc,OldBackColor);
	SetTextColor(hdc,OldForColor); 
	SelectObject(hdc,OldObject); 
	ReleaseDC(hWnd,hdc);
	long nRefreshRate = max(2000,1000 * pApp->GetProfileInt(REG_MAIN, REG_REFRESH_RATE, DEFAULT_REFRESH_RATE));
	KillTimer(hWnd,ID_TIMER);
	SetTimer(hWnd,ID_TIMER, nRefreshRate,NULL);
}