% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_control.R
\name{set_control}
\alias{set_control}
\title{Set internal parameters that control ACE and AVAS algorithms}
\usage{
set_control(
  alpha = NULL,
  big = NULL,
  span = NULL,
  sml = NULL,
  eps = NULL,
  spans = NULL,
  maxit = NULL,
  nterm = NULL
)
}
\arguments{
\item{alpha}{numeric(1); AVAS; Controls high frequency (small span) penalty
used with automatic span selection (base tone control). An
alpha < 0.0 or alpha > 10.0 results in no effect. Default is 5.0.}

\item{big}{numeric(1); ACE and AVAS; a large floating point number.
Default is 1.0e30.}

\item{span}{numeric(1); ACE and AVAS; Span to use in smoothing represents the
        fraction of observations in smoothing window. Automatic span selection
        is performed if set to 0.0. Default is 0.0 (automatic).

        For small samples (n < 40) or if there are substantial serial
        correlations between observations close in x - value, then
        a specified fixed span smoother (span > 0) should be
        used. Reasonable span values are 0.3 to 0.5.}

\item{sml}{numeric(1); AVAS; A small number. Should be set so that `(sml)**(10.0)`
does not cause floating point underflow. Default is 1e-30.}

\item{eps}{numeric(1); AVAS; Used to numerically stabilize slope calculations
for running linear fits.}

\item{spans}{numeric(3); AVAS; span values for the three running linear smoothers.
 \describe{
   \item{"spans(1)"}{Tweeter span. Default is 0.05.}
   \item{"spans(2)"}{Midrange span. Default is 0.2.}
   \item{"spans(3)"}{Woofer span. Default is 0.5.}
}
Warning: These span values should be changed only with great care.}

\item{maxit}{integer(1); ACE and AVAS; Maximum number of iterations.
Default is 20.}

\item{nterm}{integer(1); ACE and AVAS; Number of consecutive iterations for
which rsq must change less than delcor for convergence. Default is 3.}
}
\description{
These parameters are used in the smoothing routines of ACE and AVAS. ACE and
AVAS both have their own smoothing implementations. This sets them globally
for the package. 

The default values are good for the vast majority of cases. This routine
is included to provide complete control to the user, but is rarely needed.
}
\examples{
set_control(maxit=40)
set_control(maxit=20)
set_control(alpha=5.0)
set_control(big=1e30, sml=1e-30)
set_control(eps=1e-3)
set_control(span=0.0, spans=c(0.05, 0.2, 0.5))
set_control(maxit=20, nterm=3)
}
