// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2014-10-16 11:28:58
// From command line:
//  --cld2 --cc --just_read_raw --distinct_octa --standard --minchars=2 
//  --mincount=2 --max_items_per_langscript=300 --flatmap --rr_alloc 
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=224 
//  --v25 --kentries=8 --tablename=DistinctOctaChrome1015 
//  --remap=xxx-Latn=>ut-Latn tw-Latn=>ak-Latn nd-Latn=>nr-Latn 
//  blu-Latn=>hmn-Latn nn-Latn=>no-Latn  --include=af-Latn ar-Arab be-Cyrl 
//  bg-Cyrl bs-Latn ca-Latn cs-Latn cy-Latn   da-Latn de-Latn el-Grek 
//  en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn   ga-Latn gd-Latn 
//  hi-Deva hr-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr   ja-Hani 
//  ko-Hani lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn   
//  pl-Latn pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn 
//  sl-Latn sr-Cyrl   sv-Latn sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl 
//  vi-Latn yi-Hebr   zh-Hani zh-TW zhT-Hani   sq-Latn az-Latn eu-Latn 
//  bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab   bh-Deva mr-Deva 
//  ne-Deva lg-Latn rw-Latn gd-Latn   ut-Latn ut-Deva   ceb-Latn blu-Latn 
//  hmn-Latn jw-Latn   kk-Cyrl ku-Latn ky-Cyrl mg-Latn ny-Latn st-Latn 
//  su-Latn tg-Cyrl uz-Latn uz-Cyrl  --ko_english --force_to_lang_soft 
//  --nosoft_cram2 --nomsidlevel --shapeflatprob --langpriorpercent=10 
//  --skipnuc --noshapeforcetop --noshapeeventop --noshapesteep2 --spread=15 
//  --nodoubleclose --langcounts --writebin --list_items=120 
//  /tmp/xocta_octa2.utf8 
// 
// CLD2_pslangs
// 
// See compact_lang_det.cc for usage
// 
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDistinctOctaChrome1015BuildDate = 20141016;    // yyyymmdd


// Of 4448 offered items into 8192 table entries:
// 4214 filled (94%), 0 merged (0%), 234 dropped (5%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 17 languages in range DANISH..KINYARWANDA:
//     DANISH NORWEGIAN PORTUGUESE SPANISH CZECH CROATIAN SERBIAN 
//     GALICIAN HINDI INDONESIAN MALAY NEPALI BIHARI MARATHI SLOVAK 
//     BOSNIAN KINYARWANDA 

// TopLanguage  TokenCount
//  DANISH 284
//  NORWEGIAN 283
//  PORTUGUESE 276
//  SPANISH 285
//  CZECH 283
//  CROATIAN 95
//  SERBIAN 508
//  GALICIAN 286
//  HINDI 285
//  INDONESIAN 281
//  MALAY 281
//  NEPALI 48
//  BIHARI 282
//  MARATHI 26
//  SLOVAK 283
//  BOSNIAN 150
//  KINYARWANDA 278



// Recognized language-script combinations [18]:
static const char* const kDistinctOctaChrome1015RecognizedLangScripts = 
  "bh-Deva bs-Latn cs-Latn da-Latn es-Latn gl-Latn hi-Deva hr-Latn "
  "id-Latn mr-Deva ms-Latn ne-Deva no-Latn pt-Latn rw-Latn sk-Latn "
  "sr-Cyrl sr-Latn ";

static const uint32 kDistinctOctaChrome1015Size = 2048;    // Bucket count
static const uint32 kDistinctOctaChrome1015KeyMask = 0xfffff800;    // Mask hash key

static const IndirectProbBucket4 kDistinctOctaChrome1015[kDistinctOctaChrome1015Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x53098802,0x4ae00803,0xb964a804,0x00000000}},	// [000] _añadir_, _kabupate, _použití_, --, 
   {{0x52907805,0x34427806,0xdfa54007,0x72918008}},	//   _kuna_, _jen_, _desember_, _surah_, 
   {{0x93877009,0x4722700a,0x0442180b,0x00000000}},	//   _bošnjačk, _बाड़े_, _secara__terus_, --, 
   {{0x5442780c,0xd4c0580d,0x00000000,0x00000000}},	//   _len_, _http__gl_, --, --, 
   {{0x4a4e300e,0x2475980f,0xd2902010,0x00000000}},	//   _के__नाम_, _dana__apr_, _inka_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4a967010,0x52b15011,0x00000000,0x00000000}},	//   _tanzania_, _mostrará_, --, --, 
   {{0x6291e812,0x0200c813,0x00000000,0x00000000}},	//   _antal_, _nadie_, --, --, 
   {{0xb4427814,0x524b6815,0xb2ca9010,0x00000000}},	//   _ben_, _tinjau__ahli_, _stade_, --, 
   {{0x1495e00c,0x626de806,0x00000000,0x00000000}},	//   _sa__mi_, _tyto_, --, --, 
   {{0x73eb900c,0x5bfea016,0xdb93900f,0x00000000}},	//   _mesta_, _sua__opinião_, _pjesama__tekstova_, --, 
   {{0x6290f815,0x00000000,0x00000000,0x00000000}},	//   _bahawa_, --, --, --, 
   {{0x7ec8e017,0x8a3c9018,0x00000000,0x00000000}},	//   _регистру_се_, _लॉग_, --, --, 
   {{0x39fe0819,0x00000000,0x00000000,0x00000000}},	//   _novament, --, --, --, 
   {{0x8442681a,0xe47a581b,0xdcca0817,0x6e05981a}},	//   _klo_, _hvad__er_, _јануар__децембар_, _kendaraa, 
   {{0x0242101c,0x00000000,0x00000000,0x00000000}},	//   _मामले_, --, --, --, 
   {{0x8291e81d,0x9a3e480e,0x00000000,0x00000000}},	// [010] _dotaz_, _भीम_, --, --, 
   {{0x8290100d,0x00000000,0x00000000,0x00000000}},	//   _unha_, --, --, --, 
   {{0x36fee01c,0xa2f0b81b,0x1e73c018,0x00000000}},	//   _करना_, _søg_, _सिर्फ_, --, 
   {{0x6d7f3017,0x6c02a018,0x00000000,0x00000000}},	//   _јун_, _लॉग__इन_, --, --, 
   {{0x12248006,0x00000000,0x00000000,0x00000000}},	//   _velké_, --, --, --, 
   {{0x627f0010,0x92f85815,0x00000000,0x00000000}},	//   _abandi_, _dalam__laman_, --, --, 
   {{0x12f6d005,0x0a84500e,0x00000000,0x00000000}},	//   _pošalji__osobnu_, _भवन__में_, --, --, 
   {{0xc442780d,0x92c7d816,0x00000000,0x00000000}},	//   _sen_, _comentár_comentár, --, --, 
   {{0x23945807,0xe46e7807,0x00000000,0x00000000}},	//   _helse_, _seg__til_, --, --, 
   {{0xe451e01e,0x13551009,0x0ac3a00e,0xd4a17016}},	//   _poruke__na_, _postignu_dogovor_, _जवाब__में_, _escreva__sua_, 
   {{0xf236d817,0x36f9481c,0x03ea681b,0x00000000}},	//   _tanjug_, _सकता_, _flot_, --, 
   {{0x7274f807,0x5a4bd81c,0x00000000,0x00000000}},	//   _forskjel, _की__मौत_, --, --, 
   {{0x3d83881f,0x00000000,0x00000000,0x00000000}},	//   _reči_, --, --, --, 
   {{0x83ea0016,0x8237e01e,0x00000000,0x00000000}},	//   _muito_, _promena_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x844c880d,0x00000000,0x00000000,0x00000000}},	//   _xestión_, --, --, --, 
   {{0xe364c817,0x5bd00016,0xb3f85813,0xd254f820}},	// [020] _ekstovi__blogu_, _opinião_, _salud_, _no__artigo_, 
   {{0x3225000b,0x92d81010,0x92d58816,0xe44d6007}},	//   _adakah_, _gihe_, _conosco_, _dersom__du_, 
   {{0xbb88f821,0x6c90581c,0xe68a7017,0x00000000}},	//   _पर_, _लोगों_, _презимен, --, 
   {{0xa3a5a007,0x725af817,0x00000000,0x00000000}},	//   _innlegg__svar_, _đilas_, --, --, 
   {{0xe4765811,0x0395c80c,0x0c14601c,0xd4b7d815}},	//   _lugar__es_, _časť_, _दिया__है_, _versi__ke_, 
   {{0x45852015,0x92cae81b,0x00000000,0x00000000}},	//   _pengguna_komersil_, _findes_, --, --, 
   {{0x827ee01b,0x00000000,0x00000000,0x00000000}},	//   _gennem_, --, --, --, 
   {{0x32fd5822,0x00000000,0x00000000,0x00000000}},	//   _dana__tjedna_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf290a010,0x2eba5007,0x00000000,0x00000000}},	//   _kuba_, _kjøpe_, --, --, 
   {{0x83eb9017,0x00000000,0x00000000,0x00000000}},	//   _vesti_, --, --, --, 
   {{0x125b901e,0x12a61810,0x00000000,0x00000000}},	//   _posle_, _ntushobo_kubona_, --, --, 
   {{0x8458780c,0x0b011810,0x00000000,0x00000000}},	//   _izbový__byt_, _ukoreshe, --, --, 
   {{0x967cb023,0xb01cb006,0x00000000,0x00000000}},	//   _se__registri, _se__registro, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8c86200e,0x09f43006,0x42fc7807,0x00000000}},	// [030] _के__माध्यम_, _mají_, _lenge_, --, 
   {{0xebad3024,0x00000000,0x00000000,0x00000000}},	//   _कार्यक्र_के_, --, --, --, 
   {{0x427f7813,0x1a3e701c,0xc3d9081b,0x7290a015}},	//   _cuando_, _मैं_, _at__være_, _cuba_, 
   {{0xe46f581a,0x00000000,0x00000000,0x00000000}},	//   _jawa__timur_, --, --, --, 
   {{0xebed9824,0x00000000,0x00000000,0x00000000}},	//   _संस्कृति__के_, --, --, --, 
   {{0xed86b01e,0x00000000,0x00000000,0x00000000}},	//   _vrednost_, --, --, --, 
   {{0xb3eb901e,0x00000000,0x00000000,0x00000000}},	//   _mestu_, --, --, --, 
   {{0x3b88101c,0x44426810,0x00000000,0x00000000}},	//   _यह_, _bwo_, --, --, 
   {{0x8a33e824,0x99f5b006,0x00000000,0x00000000}},	//   _जाई_, _navíc_, --, --, 
   {{0xa2cb480c,0x62aab81b,0xd351b825,0x00000000}},	//   _predaj_, _købe_, _synes__ikke_, --, 
   {{0xa2e6c00d,0x35dd7017,0x3303981b,0x00000000}},	//   _da__súa_, _подаци__други_, _bruge__vores_, --, 
   {{0x6a3d581c,0xe3543015,0x0a69380e,0xe495f81b}},	//   _रहा_, _selepas_, _पाकिस्ता_में_, _op__til_, 
   {{0x6ee2e817,0x00000000,0x00000000,0x00000000}},	//   _он_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3556c01c,0x4a3d2818,0xbb21c80c,0x00000000}},	//   _असहमत__बढ़िया_, _हॉट_, _komplime, --, 
   {{0xd49d500d,0xebed6024,0x00000000,0x00000000}},	//   _páxinas__que_, _मध्यप्रद_के_, --, --, 
   {{0x2bf8180e,0x846a8017,0x00000000,0x00000000}},	// [040] _में__हम_, _povezane__vesti_, --, --, 
   {{0xf00bc017,0xf29bd80c,0x23ebe807,0x72b4680c}},	//   _prijavi__komentar_, _chybu__upraviť_, _sette_, _dvoch_, 
   {{0x2dd77015,0x6a32980e,0x42d19807,0x00000000}},	//   _janji__perniaga, _गौर_, _på__grunn_, --, 
   {{0x447c581f,0xec0a9824,0x00000000,0x00000000}},	//   _html__kod_, _कहानी__के_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64b3680d,0x31ed180c,0x00000000,0x00000000}},	//   _concello__de_, _formulár, --, --, 
   {{0x32013017,0xc226701a,0x42249010,0x00000000}},	//   _свиђа_, _terbaru__kali_, _mwaka_, --, 
   {{0x22d9800c,0x00000000,0x00000000,0x00000000}},	//   _hore_, --, --, --, 
   {{0x42918010,0x4f240806,0xba3e3817,0x00000000}},	//   _kora_, _našem_, _sreda__neregist, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf442c80c,0xfed52817,0x74426810,0x248e601b}},	//   _ked_, _код_, _uwo_, _af__og_, 
   {{0xd490a007,0x6d950817,0x19711806,0x00000000}},	//   _av__den_, _slanje__lične_, _stažení_, --, 
   {{0xd218a01c,0xb9ee6810,0x00000000,0x00000000}},	//   _पृष्ठ__हमारे_, _kubikora_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9442b00c,0x34aea007,0x00000000,0x00000000}},	// [050] _vec_, _mer__enn_, --, --, 
   {{0x7d8c000c,0x66d2880e,0x00000000,0x00000000}},	//   _počas_, _लोगिन_, --, --, 
   {{0x4c4f201c,0x00000000,0x00000000,0x00000000}},	//   _उसने_, --, --, --, 
   {{0xbc0d300e,0x64429010,0xe2d90010,0x00000000}},	//   _देर__तक_, _kwa_, _imbere_, --, 
   {{0x2bf6280e,0x00000000,0x00000000,0x00000000}},	//   _में__जब_, --, --, --, 
   {{0xc3f8c804,0xd9f4300c,0x5b1d200d,0x22d99010}},	//   _budu_, _majú_, _calquera_, _hose_, 
   {{0xd2c71008,0xc3954016,0xfafb5006,0x00000000}},	//   _mana__mana_, _acesso_, _žádné_, --, 
   {{0x9290c813,0x00000000,0x00000000,0x00000000}},	//   _duda_, --, --, --, 
   {{0x72d99010,0xbbf56024,0x00000000,0x00000000}},	//   _mose_, _अच्__छा_, --, --, 
   {{0xb2d6f006,0xaa3e581c,0x00000000,0x00000000}},	//   _přes_, _कविता__कोश_, --, --, 
   {{0xa2904808,0xca00f81a,0x00000000,0x00000000}},	//   _ramai_, _surabaya_, --, --, 
   {{0x7291900d,0xd4429010,0x025b7816,0x00000000}},	//   _nosa_, _bwa_, _avalia_, --, 
   {{0x29da001e,0x7f238816,0x00000000,0x00000000}},	//   _subotica_, _semelhan, --, --, 
   {{0xb26c8806,0x6b7fc01e,0x5b194815,0x00000000}},	//   _nahoru_, _posledic, _kewangan_, --, 
   {{0xc2d99010,0x00000000,0x00000000,0x00000000}},	//   _bose_, --, --, --, 
   {{0xb3991813,0x6366d817,0x7bbb901c,0x0469a017}},	//   _más_, _ponedelj, _हैं__तो_, _dodaci__gratis_, 
   {{0x0ba27818,0x226d2010,0x00000000,0x00000000}},	// [060] _रहा__है_, _icyo_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x84867024,0x5ebed011,0xbf7b081b,0xebea200e}},	//   _तिवारी_, _mostrará__públicam, _denne__tråd_, _मन__के_, 
   {{0x5201a010,0x326cc81e,0x048f6826,0x00000000}},	//   _kopi_, _delovi_, _ja__som_, --, 
   {{0xb38b5807,0xba390017,0x00000000,0x00000000}},	//   _våre_, _četvrtak__neregist, --, --, 
   {{0x427f4004,0x00000000,0x00000000,0x00000000}},	//   _jednou_, --, --, --, 
   {{0x73950019,0xb4b16009,0x72907827,0x00000000}},	//   _brasil_, _postovi__dan_, _anna_, --, 
   {{0xc2e5681a,0x3328a81b,0x00000000,0x00000000}},	//   _rp__kamar_, _du__vores_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6c4ed81c,0x6200a00b,0x00000000,0x00000000}},	//   _जैसे_, _habib_, --, --, 
   {{0x42f62022,0xd424701a,0x00000000,0x00000000}},	//   _dan__dana_, _ketentua_serta_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x60d7c817,0x00000000,0x00000000,0x00000000}},	//   _neregist_korisnik_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92ad0017,0x00000000,0x00000000,0x00000000}},	//   _нису_, --, --, --, 
   {{0x03207815,0x20fe200e,0x00000000,0x00000000}},	// [070] _ianya_, _के__गांव_, --, --, 
   {{0x2f247006,0x00000000,0x00000000,0x00000000}},	//   _část_, --, --, --, 
   {{0xa9f36023,0xc48e601b,0x34bba015,0x9cf75024}},	//   _prosvjed, _af__en_, _sama__ada_, _नामकरण_, 
   {{0x62905815,0x1e5d800d,0x34c58028,0xb296b810}},	//   _sila_, _traballa, _trabalho_, _amakuru_, 
   {{0x9248d816,0x00000000,0x00000000,0x00000000}},	//   _quem_, --, --, --, 
   {{0x6201901a,0x22d9e807,0xc344c01d,0xb46ab016}},	//   _musik_, _liten_, _inzerce_, _com__uma_, 
   {{0x12c20003,0x00000000,0x00000000,0x00000000}},	//   _soalnya_, --, --, --, 
   {{0x52396817,0x62df780d,0x00000000,0x00000000}},	//   _коју_, _na__pola_, --, --, 
   {{0x032c181b,0x13df300d,0x2ac14004,0x00000000}},	//   _så__meget_, _esta__páxina_, _lepší_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xefa7281a,0xc4a9d822,0xf2e1a029,0x93966007}},	//   _komentar_, _napisao__la_, _kolovoz_, _norske_, 
   {{0xf2127814,0xda6af00e,0x32fc0814,0x00000000}},	//   _cunha_, _कुछ__दिन_, _debes__estar_, --, 
   {{0x4442d80d,0x0495e026,0x0318201b,0x00000000}},	//   _lle_, _potrebuj, _at__finde_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82f7301a,0x00000000,0x00000000,0x00000000}},	//   _dan__bisa_, --, --, --, 
   {{0x2442f807,0x00000000,0x00000000,0x00000000}},	// [080] _meg_, --, --, --, 
   {{0x2e9a5817,0x7a3d301c,0xf229c806,0xc9f3480c}},	//   _што__је_, _हुआ_, _díky_, _prostred, 
   {{0xa442d807,0x92e2701e,0xde292017,0x00000000}},	//   _ble_, _odgovori__prijavi_, _дан_, --, 
   {{0xe475f80f,0x00000000,0x00000000,0x00000000}},	//   _dana__okt_, --, --, --, 
   {{0x83ea780d,0xff185817,0xc442d806,0x00000000}},	//   _xunta_, _да__би_, _dle_, --, 
   {{0x920ee806,0xd442d816,0xb2240007,0x2ee86017}},	//   _při_, _ele_, _klikk_, _где__је_, 
   {{0xc2613816,0x4285e817,0x7290f80d,0x42126016}},	//   _não_, _na__nadji_, _auga_, _julho_, 
   {{0xca331021,0x00000000,0x00000000,0x00000000}},	//   _टेक_, --, --, --, 
   {{0x9442f807,0x27a1382a,0x00000000,0x00000000}},	//   _deg_, _अन्तर्रा, --, --, 
   {{0xd20ee806,0x00000000,0x00000000,0x00000000}},	//   _tři_, --, --, --, 
   {{0x52fe601b,0x00000000,0x00000000,0x00000000}},	//   _brugte_, --, --, --, 
   {{0x4471780d,0x4ae9c817,0x4a3dc821,0x00000000}},	//   _que__lle_, _политика_, _तुम_, --, 
   {{0xe4956010,0x0a4d480e,0x6290b028,0xd25ab807}},	//   _ni__na_, _के__देश_, _ficar_, _hjelpe_, 
   {{0x95c0580f,0x54625028,0x00000000,0x00000000}},	//   _uz__obavezno_, _não__se_, --, --, 
   {{0xa7803820,0x00000000,0x00000000,0x00000000}},	//   _subvenci, --, --, --, 
   {{0xe2907810,0x00000000,0x00000000,0x00000000}},	//   _zina_, --, --, --, 
   {{0xc278c00d,0x00000000,0x00000000,0x00000000}},	// [090] _ler__máis_, --, --, --, 
   {{0x6b69f00d,0x4a4c1818,0x83ead825,0x00000000}},	//   _ligazóns_, _हो__गया_, _slet_, --, 
   {{0xa38ab81b,0x74ba5002,0x7dc2b81a,0xd4bc000c}},	//   _børn_, _como__si_, _kebijaka, _viac__ako_, 
   {{0x9a3d301c,0x04780007,0xd4717816,0x647dd00d}},	//   _हुई_, _blir__det_, _que__ele_, _xullo__de_, 
   {{0x9f78780c,0x00000000,0x00000000,0x00000000}},	//   _všetky__práva_, --, --, --, 
   {{0x8442f807,0xd28da022,0xc28fe028,0x83eaf01a}},	//   _seg_, _nja__naslov_, _que__não_, _kantor_, 
   {{0x0a3d301c,0xadde7017,0x325a600d,0x00000000}},	//   _हुए_, _да__су_, _xullo_, --, 
   {{0xfebce81f,0xd2132013,0x00000000,0x00000000}},	//   _verovatn, _muchas_, --, --, 
   {{0x12613816,0x48d4882b,0x42be201e,0x9e10800d}},	//   _são_, _चर्चित_, _pre__dana_, _igual__pódense_, 
   {{0x7bdce80e,0x00000000,0x00000000,0x00000000}},	//   _पलायन_, --, --, --, 
   {{0x337b9006,0xbcd0301b,0x4464d010,0xfc66a01b}},	//   _skladem_, _flexbloc, _bbc__bbc_, _hurtigt_, 
   {{0x4a88b81c,0x1f49d817,0x00000000,0x00000000}},	//   _दुनिया__खेल_, _производ, --, --, 
   {{0x7e72e817,0x00000000,0x00000000,0x00000000}},	//   _се_, --, --, --, 
   {{0xb406f817,0xa2566006,0x00000000,0x00000000}},	//   _profil__poruke_, _více__hodin_, --, --, 
   {{0x19aa2017,0xdaf3b81b,0x00000000,0x00000000}},	//   _нови_, _yderlige, --, --, 
   {{0xa1f7980c,0x00000000,0x00000000,0x00000000}},	//   _najlepši, --, --, --, 
   {{0xa075a80d,0x00000000,0x00000000,0x00000000}},	// [0a0] _navegaci_ferramen, --, --, --, 
   {{0x2443100c,0x74420010,0x226cf810,0x00000000}},	//   _cez_, _iti_, _yehova_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22502017,0xc49f7011,0x00000000,0x00000000}},	//   _нема_, _escribe__una_, --, --, 
   {{0xaac7f806,0xb491e016,0x46e0600b,0x00000000}},	//   _kteří_, _em__um_, _linkedin__perjanji, --, 
   {{0x3c4ee01c,0x227ee807,0x00000000,0x00000000}},	//   _करें_, _funnet_, --, --, 
   {{0xefb10017,0x0b8f8021,0x4298080c,0x53af3007}},	//   _pošaljit_komentar_, _था_, _vďaka_, _løpet_, 
   {{0x14b78007,0x6be1f80d,0x00000000,0x00000000}},	//   _samarbei_med_, _ligazón__informac, --, --, 
   {{0xa6f8402c,0xa4677005,0x5290a015,0x00000000}},	//   _शंका_, _prije__minuta_, _sabah_, --, 
   {{0x8d704817,0x9a5f8013,0x6326681b,0xc2916810}},	//   _reputaci_moć_, _pregunta_, _at__vide_, _hagati_, 
   {{0xd399601b,0xf4420010,0xc200c810,0x4f3ab82d}},	//   _læs_, _ati_, _indi_, _koordina, 
   {{0xf2d75006,0x00000000,0x00000000,0x00000000}},	//   _třeba_, --, --, --, 
   {{0x5291e82e,0x00000000,0x00000000,0x00000000}},	//   _kota_, --, --, --, 
   {{0x3b940017,0x5307e819,0x42cb5002,0x0496c017}},	//   _komentar_pošaljit, _seu__nome_, _puedes_, _preporuč_ne_, 
   {{0x340b0005,0x02fcf807,0x00000000,0x00000000}},	//   _osobnu__poruku_, _legge_, --, --, 
   {{0xf606382f,0x28c5882b,0x58c6e007,0x00000000}},	//   _प्रतिक्र, _उदयपुर_, _innehold, --, 
   {{0x22fce81a,0x2200a010,0x0290a010,0x2be7a00e}},	// [0b0] _banget_, _bibi_, _biba_, _से__हम_, 
   {{0xce35000d,0xbeed0016,0x00000000,0x00000000}},	//   _mulleres_, _mulheres_, --, --, 
   {{0x1c60b808,0x99224824,0x00000000,0x00000000}},	//   _rujukan_, _इतिहासका, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2efd80d,0x1452d01e,0x9290301a,0x00000000}},	//   _galicia_, _strana__od_, _pajak_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6290c807,0x00000000,0x00000000,0x00000000}},	//   _enda_, --, --, --, 
   {{0x433fb80d,0xd496f80d,0xca33601c,0x4389c81b}},	//   _dispoñib_baixo_, _xa__que_, _किए_, _søgning_, 
   {{0x02ca781b,0xeb8e8021,0x72d9201c,0x00000000}},	//   _finde_, _वे_, _मूवी_, --, 
   {{0x4477980d,0x00000000,0x00000000,0x00000000}},	//   _informac_da_, --, --, --, 
   {{0x1c398004,0x78d0101c,0x00000000,0x00000000}},	//   _kombinac, _बच्चों_, --, --, 
   {{0x62fc7802,0xa2eeb829,0x02d8e013,0x00000000}},	//   _tengo_, _štimac_, _manera_, --, 
   {{0x5e68c019,0x00000000,0x00000000,0x00000000}},	//   _menciona, --, --, --, 
   {{0x53ea6803,0x12d8b010,0xd47fa80d,0x00000000}},	//   _quote_, _bice_, _unha__das_, --, 
   {{0xa2ef801e,0x3b48700c,0x00000000,0x00000000}},	//   _pogledaj__javni_, _musíte__prihlási, --, --, 
   {{0x92d83010,0xcb03d017,0x56b1a018,0x00000000}},	// [0c0] _kamena_, _можете_, _मस्ती_, --, 
   {{0x5229601b,0x00000000,0x00000000,0x00000000}},	//   _væk_, --, --, --, 
   {{0x327f7816,0x4290b028,0x00000000,0x00000000}},	//   _quando_, _fica_, --, --, 
   {{0x02905808,0x00000000,0x00000000,0x00000000}},	//   _ialah_, --, --, --, 
   {{0x8442000d,0x929b400c,0x00000000,0x00000000}},	//   _moi_, _izbový_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1273601b,0x00000000,0x00000000,0x00000000}},	//   _mænd_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2eb3f817,0x00000000,0x00000000,0x00000000}},	//   _која__је_, --, --, --, 
   {{0x93f98008,0xf373c00c,0xf2c9e010,0x00000000}},	//   _turut_, _žiadne_, _vyacu__umva_, --, 
   {{0x3c59f01a,0x00000000,0x00000000,0x00000000}},	//   _listrik_, --, --, --, 
   {{0x5497e013,0xfc922817,0x00000000,0x00000000}},	//   _si__no_, _овде_, --, --, 
   {{0x2309c016,0x3b8ea830,0x0201801a,0xd3a2382e}},	//   _também_, _लग_, _kirim_, _tampak_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb4444016,0x2cd6c017,0x1d46c017,0xc2d8c812}},	//   _em_, _српски_, _српске_, _lide_, 
   {{0x72a8781b,0x00000000,0x00000000,0x00000000}},	// [0d0] _en__lille_, --, --, --, 
   {{0x2212b013,0x00000000,0x00000000,0x00000000}},	//   _mucho_, --, --, --, 
   {{0x8a885803,0x02c4b80d,0x9632e00d,0x00000000}},	//   _kegiatan_, _ademais_, _coñeceme, --, 
   {{0x16d1300a,0x00000000,0x00000000,0x00000000}},	//   _खातिर_, --, --, --, 
   {{0x0cb7280e,0x00000000,0x00000000,0x00000000}},	//   _में__कहीं_, --, --, --, 
   {{0xf4912812,0x00000000,0x00000000,0x00000000}},	//   _at__der_, --, --, --, 
   {{0x82fc781b,0xebc07824,0x12ca1015,0x00000000}},	//   _penge_, _शक्ति__के_, _mohd_, --, 
   {{0xe2d88002,0x00000000,0x00000000,0x00000000}},	//   _mejores_, --, --, --, 
   {{0xda564010,0xe489d007,0x00000000,0x00000000}},	//   _ubufasha__buboneka_, _finner__du_, --, --, 
   {{0x07281817,0xff6ca816,0x449fd81b,0x00000000}},	//   _због_, _detalhes_, _indlæg__af_, --, 
   {{0x84444015,0x13a2001e,0x00000000,0x00000000}},	//   _rm_, _gripa_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb201801e,0xb303b00d,0x00000000,0x00000000}},	//   _kurir_, _desde__túa_, --, --, 
   {{0x44b08006,0x6c4e081c,0x00000000,0x00000000}},	//   _můžete_, _कहते_, --, --, 
   {{0xb3232017,0x4bb3f01b,0x0abc8824,0x00000000}},	//   _odgovora__poslednj, _se__billeder, _अभाव__में_, --, 
   {{0x6c6e582e,0x28464016,0x272e800f,0xf3eb9007}},	//   _amerika_, _qualidad, _zoran__bibanovi, _posta_, 
   {{0xf3eae803,0x00000000,0x00000000,0x00000000}},	// [0e0] _lintas_, --, --, --, 
   {{0xb4444016,0xc201f01b,0x00000000,0x00000000}},	//   _um_, _butik_, --, --, 
   {{0xff8bf016,0x4edc5817,0xc386d813,0x00000000}},	//   _além_, _више__од_, _ayer_, --, 
   {{0x13157008,0x00000000,0x00000000,0x00000000}},	//   _yang__boleh_, --, --, --, 
   {{0x62907815,0x4495c013,0x00000000,0x00000000}},	//   _kanak_, _no__hay_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x74422003,0x62d8c812,0xfbdba014,0xfc60b802}},	//   _kok_, _vide_, _alumnado_, _este__artículo_, 
   {{0xde5d780c,0x00000000,0x00000000,0x00000000}},	//   _nehnuteľ, --, --, --, 
   {{0xe2d8c00d,0xb212780d,0x3ee2900d,0x349e2006}},	//   _galega_, _nunha_, _adiciona_consulte_, _od__kč_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0b6b681b,0x00000000,0x00000000,0x00000000}},	//   _annoncer, --, --, --, 
   {{0x42bb101e,0x00000000,0x00000000,0x00000000}},	//   _mesec__dana_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb2e8501e,0x42315011,0x00000000,0x00000000}},	//   _poslednj, _la__autoprom, --, --, 
   {{0x9f8bf006,0x2c75b006,0xa303b006,0x00000000}},	//   _své_, _hlavní_, _opravdu_, --, 
   {{0x4497e01b,0x00000000,0x00000000,0x00000000}},	//   _ud__af_, --, --, --, 
   {{0x48c7d824,0xf440d022,0x00000000,0x00000000}},	// [0f0] _भोजपुर_, _lokacija__sarajevo_, --, --, 
   {{0xc4aa080c,0x00000000,0x00000000,0x00000000}},	//   _prísluše, --, --, --, 
   {{0xf371f00b,0xa25b7808,0xf50e7824,0xd2011010}},	//   _lagi__dengan_, _amalan_, _भी__ज्यादा_, _kabiri_, 
   {{0xd2ca781a,0x9291a816,0x8bc0c01c,0x00000000}},	//   _bunda_, _título__comentár, _करने__का_, --, 
   {{0x74ba9007,0xc698b00c,0x00000000,0x00000000}},	//   _logg__inn_, _košíka_, --, --, 
   {{0x0212780d,0x641e681b,0x33ead816,0x00000000}},	//   _dunha_, _er__blevet_, _frete_, --, 
   {{0x127f701f,0x227ed807,0xdc763017,0x00000000}},	//   _slanje_, _kjent_, _децембар_, --, 
   {{0xf33df814,0x00000000,0x00000000,0x00000000}},	//   _en__galicia_, --, --, --, 
   {{0xfe8f1817,0x00000000,0x00000000,0x00000000}},	//   _или_, --, --, --, 
   {{0x34801806,0x248a601b,0xc4b22007,0x00000000}},	//   _cena__kč_, _logget__ind_, _vil__bli_, --, 
   {{0x5c7c4013,0xe3afb822,0x00000000,0x00000000}},	//   _nuestra_, _ispisa__čpp_, --, --, 
   {{0xc7518831,0x32d82003,0x0526e816,0x08c7301b}},	//   _विकिपीडि, _paket_, _carrinho_, _indehold, 
   {{0xf9f47806,0x00000000,0x00000000,0x00000000}},	//   _nyní_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb4c05007,0x02e28016,0x544e5006,0x527f4013}},	//   _slik__at_, _sobre__produto_, _přihlási_se_, _fuente_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf4051015,0x00000000,0x00000000,0x00000000}},	// [100] _profil__penuh_, --, --, --, 
   {{0x7444401b,0xd2d8f81b,0x0399b816,0x00000000}},	//   _ud_, _lige_, _mês_, --, 
   {{0x04422007,0x8292781a,0xf347980c,0x00000000}},	//   _tok_, _desain_, _týždeň_, --, 
   {{0x04b3581d,0x00000000,0x00000000,0x00000000}},	//   _idnes__cz_, --, --, --, 
   {{0x627ff806,0x0a6e981c,0x00000000,0x00000000}},	//   _seznam_, _करते__हुए_, --, --, 
   {{0x125a9015,0x00000000,0x00000000,0x00000000}},	//   _kuala_, --, --, --, 
   {{0xd48cc017,0x3c4f081c,0xb266c024,0x00000000}},	//   _učlanjen__pol_, _इससे_, _के__निदेशक_, --, 
   {{0x22d9f816,0xc3ea6806,0x785ca003,0x00000000}},	//   _avalia__este_, _proto_, _karakter_, --, 
   {{0x75b6c00e,0x5ab2d815,0xa2902015,0xc53eb824}},	//   _कि__भारत_, _berkongs, _zakar_, _में__दुनिया_, 
   {{0x1496e006,0x92018010,0x82d98010,0x9330a81c}},	//   _se__mi_, _kuri_, _kure_, _ज्योतिष__धर्मयात्, 
   {{0x84438007,0x3712a01c,0x5cc2f01d,0x00000000}},	//   _mer_, _हो__सकता_, _český_, --, 
   {{0xb2018010,0x42f4080d,0x00000000,0x00000000}},	//   _muri_, _entrada__debes_, --, --, 
   {{0x2496e010,0xe495e00c,0x00000000,0x00000000}},	//   _se__ni_, _sa__na_, --, --, 
   {{0x7ba6a80f,0xe2b5d006,0xb2127816,0x00000000}},	//   _komentar_čitanja_, _najdete_, _tinha_, --, 
   {{0x5c264822,0x122b8013,0x00000000,0x00000000}},	//   _postovi__pridruže, _siempre_, --, --, 
   {{0x64779809,0xc442680c,0x1e3b2815,0x6cb0181e}},	//   _informac_iz_, _kto_, _kepakara, _kuhinjsk_aparati_, 
   {{0x42d82007,0x00000000,0x00000000,0x00000000}},	// [110] _saker_, --, --, --, 
   {{0x02018010,0x00000000,0x00000000,0x00000000}},	//   _buri_, --, --, --, 
   {{0xf4424816,0x7d6d3017,0xc8fc8806,0xc273a815}},	//   _bom_, _шта_, _odpovědě, _peribadi_, 
   {{0x6c48d01c,0xff3ca803,0x24425823,0x2d260806}},	//   _होने_, _perusaha, _rtl_, _hodnocen_produktu_, 
   {{0x1442480c,0x9f7c281d,0xe292001a,0x5c691011}},	//   _dom_, _všechna__práva_, _jepang_, _cerrado_, 
   {{0x3669080d,0x1cd8a815,0x42d8f81b,0x2633981a}},	//   _da__foundati, _perminta_rujukan_, _sige_, _maksimal_, 
   {{0xf3f81015,0x2442681a,0x64439015,0x9e25d81a}},	//   _mahu_, _ato_, _kes_, _konfirma, 
   {{0x8300a803,0x3e0d1817,0x85fe481b,0x00000000}},	//   _tidak__bisa_, _сви_, _tilmeldi, --, 
   {{0x030d3807,0xe46f781b,0x62366826,0x00000000}},	//   _hele__saken_, _sig__til_, _tvoje_, --, 
   {{0x74439007,0x1c719032,0xeeb91817,0xb2019010}},	//   _les_, _पार्टी_, _био_, _musi_, 
   {{0xae19e81a,0x821cb006,0x0859e815,0x00000000}},	//   _selengka, _během_, _selangor_, --, 
   {{0xd2b70817,0x00000000,0x00000000,0x00000000}},	//   _paročist_dodaci_, --, --, --, 
   {{0x4e72e817,0x047e1817,0xbec76808,0xd29e1817}},	//   _не_, _било_, _menyerta, _била_, 
   {{0xe26c7815,0x00000000,0x00000000,0x00000000}},	//   _umno_, --, --, --, 
   {{0xd493d81b,0x00000000,0x00000000,0x00000000}},	//   _på__vej_, --, --, --, 
   {{0x32ca9008,0x825b1009,0xec5c780e,0x00000000}},	//   _tiada_, _tuzla_, _संदेह_, --, 
   {{0x12902015,0x00000000,0x00000000,0x00000000}},	// [120] _cakap_, --, --, --, 
   {{0x89992006,0xa2ca5807,0x00000000,0x00000000}},	//   _když_, _bilde_, --, --, 
   {{0x8fc7402b,0xad83881f,0xe3eb8007,0xd2d5481e}},	//   _समाचार_, _reč_, _vert_, _devojka_, 
   {{0x3494f00f,0x52366826,0x4e292017,0x2200c00d}},	//   _pridruže_vrh_, _svoje_, _сам_, _galiza_, 
   {{0xf442580c,0xb2019016,0x00000000,0x00000000}},	//   _bol_, _assim_, --, --, 
   {{0xc290481a,0xe48f6002,0xf7bc101e,0xe399b006}},	//   _kamar_, _de__tu_, _kragujev, _místo_, 
   {{0x0c09b824,0x00000000,0x00000000,0x00000000}},	//   _फरवरी__को_, --, --, --, 
   {{0x895eb013,0x14451005,0x82bef809,0xc2c92811}},	//   _cualquie, _mlađim__od_, _se__bilo_, _escribe__como_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc200202e,0x92002810,0xbde6c00c,0x9d67281c}},	//   _laki_, _komite_, _nájdete_, _अपना__ब्लॉग_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0e292817,0x00000000,0x00000000,0x00000000}},	//   _сад_, --, --, --, 
   {{0xc4444007,0x84b8501a,0x00000000,0x00000000}},	//   _av_, _bisa__di_, --, --, 
   {{0x04619802,0x00000000,0x00000000,0x00000000}},	//   _gracias__por_, --, --, --, 
   {{0xd2d8f807,0xbeb1380c,0x00000000,0x00000000}},	//   _laget_, _porovnan, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3b88080a,0xb290582e,0x40ae3017,0x582e3017}},	// [130] _बा_, _iklan_, _срба_, _срби_, 
   {{0xb2cad813,0x32d8c80d,0xb466700d,0xb50c700d}},	//   _puede_, _orde_, _decembro_, _febreiro_, 
   {{0x32d01022,0xc4550813,0xf443900d,0xc3a6b813}},	//   _redanje__autor_, _producto_, _tes_, _la__página_, 
   {{0x13b0e016,0xa291a01a,0x00000000,0x00000000}},	//   _clique_, _kapan_, --, --, 
   {{0x72f8901a,0x12c50815,0xe27e901a,0x5ba07818}},	//   _kamar__mandi_, _berhubun_lihat_, _emang_, _है__या_, 
   {{0xeb979024,0x00000000,0x00000000,0x00000000}},	//   _नाम__के_, --, --, --, 
   {{0xb4a37017,0xe31e600d,0x3291801a,0x00000000}},	//   _društvo__pre_, _traído__desde_, _saran_, --, 
   {{0xa3e2201b,0x2be9200e,0x9386d807,0x00000000}},	//   _indlæg__svar_, _जब__हम_, _uker_, --, 
   {{0xeb98100e,0x84429010,0x00000000,0x00000000}},	//   _समय__के_, _nta_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb442900d,0x32026810,0xab4f9002,0x74292815}},	//   _ata_, _afrika_, _la__posición_, _tempatan_, 
   {{0x33f40006,0xa9f66814,0x00000000,0x00000000}},	//   _jestli_, _verán_, --, --, 
   {{0x54b2600d,0x2d20980c,0x00000000,0x00000000}},	//   _non__se_, _vyhľadáv, --, --, 
   {{0x4e737017,0x00000000,0x00000000,0x00000000}},	//   _јер_, --, --, --, 
   {{0xf2d8201a,0xebdb4024,0x00000000,0x00000000}},	//   _pake_, _बातचीत__के_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x12d83010,0x02903013,0x00000000,0x00000000}},	// [140] _baje_, _baja_, --, --, 
   {{0xb0b2800c,0x53e9701a,0x125b080c,0x00000000}},	//   _práva__vyhraden, _menambah__wawasan_, _ďalej_, --, 
   {{0x6a3da824,0x97ddf01f,0x8320201d,0x00000000}},	//   _धार_, _mihajlov, _taky_, --, 
   {{0x6bdd101c,0x00000000,0x00000000,0x00000000}},	//   _यदि__आप_, --, --, --, 
   {{0x0ca6b80e,0xc3940016,0x00000000,0x00000000}},	//   _से__कहीं_, _coisa_, --, --, 
   {{0xc442780d,0xae82c80e,0x0e426017,0x00000000}},	//   _non_, _के__राज्य_, _је__за_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe290c022,0x00000000,0x00000000,0x00000000}},	//   _islama_, --, --, --, 
   {{0x39ebc017,0x00000000,0x00000000,0x00000000}},	//   _коментар_који_, --, --, --, 
   {{0x7278180b,0x00000000,0x00000000,0x00000000}},	//   _nama__cari_, --, --, --, 
   {{0x64325005,0x1bf1200e,0xa282500f,0x02735807}},	//   _profil__korisnik, _में__ना_, _pregled__budžetsk, _sånn_, 
   {{0xc20e2817,0x00000000,0x00000000,0x00000000}},	//   _када_, --, --, --, 
   {{0x737b8008,0x00000000,0x00000000,0x00000000}},	//   _semalam_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1290302e,0x00000000,0x00000000,0x00000000}},	//   _saja_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [150] --, --, --, --, 
   {{0xeae53802,0x9291c810,0x00000000,0x00000000}},	//   _siguient, _kuva_, --, --, 
   {{0x2201081f,0x538d181a,0x00000000,0x00000000}},	//   _srbija_, _properti_, --, --, 
   {{0xc471200d,0x00000000,0x00000000,0x00000000}},	//   _que__non_, --, --, --, 
   {{0x0aa1b00e,0x7a70881c,0xf4919816,0x00000000}},	//   _इतिहास__में_, _कहते__हैं_, _em__seu_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfae6f815,0x43d2600f,0x553ce808,0xcf53401c}},	//   _ahli__linkedin_, _za__stranke_, _sekirany, _जाएगा_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92e95803,0x74bcd006,0x6259f824,0x00000000}},	//   _artinya_, _jsem__si_, _यक्ष_, --, 
   {{0xb2d98010,0x00000000,0x00000000,0x00000000}},	//   _aires_, --, --, --, 
   {{0xa442900d,0xa465f00f,0x947ec807,0x00000000}},	//   _coa_, _partije__bih_, _registre_deg_, --, 
   {{0x7ed4e817,0xbefb2029,0xb633981c,0x00000000}},	//   _по_, _natjecan, _व्रत__त्योहार_, --, 
   {{0xd467e80d,0xb9a7f80f,0x8378e02e,0x00000000}},	//   _aínda__que_, _zabranje_koristit, _silakan_, --, 
   {{0xe200580c,0xc290580c,0xe316701a,0x00000000}},	//   _mali_, _mala_, _pribadi_, --, 
   {{0xf0ddf823,0xd036c026,0x00000000,0x00000000}},	//   _branitel, _ubytovan, --, --, 
   {{0x22d8e802,0x64bd5020,0x00000000,0x00000000}},	// [160] _quiero_, _logo__de_, --, --, 
   {{0xd2a65029,0x92d83007,0x00000000,0x00000000}},	//   _seljaci_, _skjer_, --, --, 
   {{0xb2b2200b,0x4ab7f01c,0x00000000,0x00000000}},	//   _cari__orang_, _दिया__गया_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x73cef81b,0x3200581a,0xa38b5807,0x00000000}},	//   _bliver_, _bali_, _vårt_, --, 
   {{0x329fd80c,0x00000000,0x00000000,0x00000000}},	//   _dňa_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf3299811,0x00000000,0x00000000,0x00000000}},	//   _quieres__recibir_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2dff007,0x00000000,0x00000000,0x00000000}},	//   _trening_, --, --, --, 
   {{0xee644817,0x00000000,0x00000000,0x00000000}},	//   _тако__да_, --, --, --, 
   {{0x75c63820,0x553ea017,0x3b30d00e,0x00000000}},	//   _de__santiago_, _devojčic, _पर__चर्चा_, --, 
   {{0x0bc3881c,0x00000000,0x00000000,0x00000000}},	//   _रही__है_, --, --, --, 
   {{0xc2da5815,0x1c2bb80e,0x4bcec818,0x1c013006}},	//   _isteri_, _जा__सके_, _नही_, _prostor_, 
   {{0xb38b6007,0x00000000,0x00000000,0x00000000}},	//   _vært_, --, --, --, 
   {{0xc4926007,0x0c4f081c,0x53ebe807,0x62d9f002}},	//   _en__av_, _इसके_, _lett_, _usted_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [170] --, --, --, --, 
   {{0x1eb31015,0x73ebe807,0x02bbf01a,0x00000000}},	//   _perminta_kepakara, _nett_, _mandi__dalam_, --, 
   {{0xa28a0015,0x00000000,0x00000000,0x00000000}},	//   _rundinga_usaha_, --, --, --, 
   {{0x73ead80c,0x42127816,0x62924808,0x00000000}},	//   _preto_, _minha_, _petang_, --, 
   {{0x2d7c9817,0x2d47c806,0x32127816,0x00000000}},	//   _не__може_, _nejoblíb, _linha_, --, 
   {{0xfc10a00e,0x00000000,0x00000000,0x00000000}},	//   _लाख__से_, --, --, --, 
   {{0x6284081a,0x00000000,0x00000000,0x00000000}},	//   _kyuhyun_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62ca7828,0x5442b004,0x2eff3017,0x7213f015}},	//   _ainda_, _moc_, _доступан__под_, _perkhidm, 
   {{0xd39cd016,0x6450d813,0x00000000,0x00000000}},	//   _informaç_sobre_, _nombre__de_, --, --, 
   {{0x9c4f1021,0x92a6e81a,0x52018003,0x72df1018}},	//   _उनके_, _di__follow_, _mirip_, _उनकी_, 
   {{0xb2fce815,0x09a41817,0xb63a3813,0x9492b80c}},	//   _kongsi_, _април_, _habitaci, _komentár_tak_, 
   {{0xa31a700c,0x00000000,0x00000000,0x00000000}},	//   _na__predaj_, --, --, --, 
   {{0x4212901d,0x9fb66806,0x0c06e00c,0x00000000}},	//   _praha_, _právě_, _potreby_, --, 
   {{0xec360809,0x00000000,0x00000000,0x00000000}},	//   _se__komentar, --, --, --, 
   {{0xb442a028,0x00000000,0x00000000,0x00000000}},	//   _sob_, --, --, --, 
   {{0xc2d87810,0xce14a00c,0x03e68021,0x7e0d2017}},	// [180] _kane_, _zamestna, _उत्तराखं, _два_, 
   {{0xfccf9006,0x00000000,0x00000000,0x00000000}},	//   _zpět_, --, --, --, 
   {{0xd290780b,0xe443e81b,0x644c5002,0x64c10014}},	//   _mana_, _ret_, _cuenta__de_, _parroqui_de_, 
   {{0x5200580b,0x5422a010,0x7290a003,0x00000000}},	//   _ahli_, _hanze__imbuga_, _kabar_, --, 
   {{0xca6f401c,0xf26c0016,0x00000000,0x00000000}},	//   _विज्ञापन__दें_, _meio_, --, --, 
   {{0x2eb4b817,0x341f7810,0x1478c00c,0x00000000}},	//   _који__је_, _rupapuro_, _nie__sú_, --, 
   {{0x2443e807,0x00000000,0x00000000,0x00000000}},	//   _vet_, --, --, --, 
   {{0x39aa7817,0xbb46981e,0x3d5a7817,0x222a7817}},	//   _који_, _privatna_, _које_, _која_, 
   {{0x52d8b013,0x32018010,0x32d87810,0x22907810}},	//   _hacer_, _kiri_, _bane_, _bana_, 
   {{0x42d87810,0x148f6013,0x00000000,0x00000000}},	//   _cane_, _de__mi_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1c4f201c,0x00000000,0x00000000,0x00000000}},	//   _उसके_, --, --, --, 
   {{0x32d84806,0x0379a808,0x00000000,0x00000000}},	//   _jsme_, _bayaran_, --, --, 
   {{0xec7ac033,0x226c3013,0x32d8b00d,0x00000000}},	//   _परिवर्तन_, _mejor_, _facer_, --, 
   {{0x6442c812,0x00000000,0x00000000,0x00000000}},	//   _mod_, --, --, --, 
   {{0xb7ad580d,0x04b6081a,0x00000000,0x00000000}},	//   _obxectiv, _tokobagu_com_, --, --, 
   {{0x4a3df80e,0xa26dc810,0xa2018010,0x02d9e81c}},	// [190] _तार_, _ministri_, _biri_, _पूरी_, 
   {{0x6491e016,0xfbe5c80c,0xd473e816,0x00000000}},	//   _em__de_, _priestor, _acho__que_, --, 
   {{0xf442d80c,0x82887017,0xdc4e6034,0x6b530803}},	//   _ste_, _preporuk_odgovori_, _खाने_, _yang__tersedia_, 
   {{0xf2e67010,0xf79ee017,0x02d9b81e,0x93fa7807}},	//   _cyangwa_, _треба_, _saveti_, _seg__selv_, 
   {{0x31e6d80e,0x4247500c,0x00000000,0x00000000}},	//   _चौधरी_, _nahlásiť_, --, --, 
   {{0x163f080c,0x63949007,0x73ead80c,0xd448181d}},	//   _komentár_, _plass_, _tieto_, _dobrý__den_, 
   {{0x0443f820,0x4b88700e,0x00000000,0x00000000}},	//   _teu_, _भा_, --, --, 
   {{0xaa3d780e,0x00000000,0x00000000,0x00000000}},	//   _दर्जा_, --, --, --, 
   {{0xca685022,0x32919010,0x9290c806,0x1442d807}},	//   _pridruže_lokacija_, _misa_, _zadat_, _ute_, 
   {{0x4d2e6817,0x02f1980d,0x00000000,0x00000000}},	//   _član__učlanjen_, _unha__marca_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1399f815,0xd379e816,0x3cb81806,0x00000000}},	//   _kerjaya__tawaran_, _tamanho_, _odpovědi_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2e917817,0x6768300e,0x00000000,0x00000000}},	//   _страница__је_, _में__उनका_, --, --, 
   {{0x8291901a,0x5499e006,0x5491e01b,0xa2018010}},	//   _bisa_, _to__se_, _at__se_, _riri_, 
   {{0x7442d807,0x1e8c5024,0x14138015,0x00000000}},	//   _noe_, _के__पुत्र_, _kristian_, --, 
   {{0x8a3e081c,0x00000000,0x00000000,0x00000000}},	// [1a0] _बार_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x54a8d829,0x72904809,0x2ef4d017,0x00000000}},	//   _prijavi__se_, _namaz_, _које__је_, --, 
   {{0xd26e1828,0xc495782d,0x1e292017,0x937a6015}},	//   _depois_, _om__nye_, _нам_, _jawatan_, 
   {{0x3f6b2817,0x00000000,0x00000000,0x00000000}},	//   _стране_, --, --, --, 
   {{0x323a600c,0x00000000,0x00000000,0x00000000}},	//   _môj_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22d9c81b,0x025b1022,0x2290a010,0xd355d816}},	//   _giver_, _tuzli_, _haba_, _confira_, 
   {{0xf8673011,0xbc773002,0x00000000,0x00000000}},	//   _mensajes_, _mensaje_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x52b4001e,0xd313601b,0xb4422012,0xf3c6180d}},	//   _blic_, _skal__have_, _luk_, _debe__darse_, 
   {{0xe1a32022,0x00000000,0x00000000,0x00000000}},	//   _na__vlastito, --, --, --, 
   {{0x0267b022,0x00000000,0x00000000,0x00000000}},	//   _sallalla_alejhi_, --, --, --, 
   {{0x5eced817,0x00000000,0x00000000,0x00000000}},	//   _преко_, --, --, --, 
   {{0x7290c823,0xec12780e,0x72925016,0x67d0c017}},	//   _zadar_, _बाबा__के_, _estava_, _много_, 
   {{0xee625817,0x326c1015,0x00000000,0x00000000}},	//   _lepota__zdravlje_, _johor_, --, --, 
   {{0x83f86806,0x3aea1829,0xf22bf810,0x00000000}},	// [1b0] _jsou_, _vjerojat, _css__mugihe_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3e017017,0xb491e013,0x00000000,0x00000000}},	//   _izveštaj, _el__el_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32d8b002,0x00000000,0x00000000,0x00000000}},	//   _hace_, --, --, --, 
   {{0xe315e016,0x3da90003,0xe7b5481b,0x00000000}},	//   _usuários_, _fasilita, _regering, --, 
   {{0x12d8d035,0x42d9801a,0x29f5c80c,0xd442f815}},	//   _होती_, _maret_, _prvý_, _ptg_, 
   {{0x8290a80b,0x54132015,0x841bb017,0x00000000}},	//   _undang_, _lihat__siapa_, _sve__vesti_, --, 
   {{0x04920807,0xb9e70024,0x00000000,0x00000000}},	//   _av__det_, _के__प्रयास_, --, --, 
   {{0x726e081e,0x568f481a,0x00000000,0x00000000}},	//   _lepota_, _spotligh, --, --, 
   {{0x830f7015,0x00000000,0x00000000,0x00000000}},	//   _berbeza_, --, --, --, 
   {{0x7e72e817,0x00000000,0x00000000,0x00000000}},	//   _те_, --, --, --, 
   {{0xc349301a,0x00000000,0x00000000,0x00000000}},	//   _info__terbaru_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe2bed80e,0xe2aed834,0x44bbd81b,0x00000000}},	//   _कहां_, _कहाँ_, _brug__af_, --, 
   {{0xfaf2200c,0x5344a814,0xa2d9a01a,0x0edbe816}},	// [1c0] _prihláse, _ourense_, _tipe_, _conteúdo_, 
   {{0x1290d015,0x7291f813,0x0a8b700e,0x00000000}},	//   _melayu_, _agua_, _विश्व__में_, --, 
   {{0x4f370822,0x43f9e81a,0xb388f80d,0xa2ad781b}},	//   _ukupno__mijenjan, _fitur_, _páxina__outras_, _besked__dato_, 
   {{0xe2fc681e,0x7327481b,0x00000000,0x00000000}},	//   _blogu_, _at__levere_, --, --, 
   {{0x82cad817,0x00000000,0x00000000,0x00000000}},	//   _sreda_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2f3e2806,0x725ae805,0xc442f81b,0x00000000}},	//   _méně__než_, _rofl_, _bog_, --, 
   {{0xe4444013,0x7669a036,0x52d8f81b,0x00000000}},	//   _le_, _सम्पादन__इतिहास_, _taget_, --, 
   {{0xa2481015,0x00000000,0x00000000,0x00000000}},	//   _negara__lagi_, --, --, --, 
   {{0xc3216813,0x3a3df021,0xcdb94817,0xf3710008}},	//   _gracias_, _साथ_, _последњи__пут_, _atas__dengan_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfbac300e,0xddbab81c,0x84808810,0xd452a007}},	//   _माध्यम__से_, _आपत्तिजन, _kuri__uru_, _har__blitt_, 
   {{0xe468701b,0x00000000,0x00000000,0x00000000}},	//   _tilføj__til_, --, --, --, 
   {{0x42dea022,0x5eb6881d,0x0e94e017,0xef4e2817}},	//   _la__dana_, _zobrazit_, _јун__мај_, _политичк, 
   {{0x23f9e81a,0x2495100f,0xbf87501e,0x1e19d017}},	//   _situs_, _pridruže_maj_, _mašine_, _београд_, 
   {{0xd2494013,0x00000000,0x00000000,0x00000000}},	//   _tiempo_, --, --, --, 
   {{0x42ca3807,0x43c93806,0x00000000,0x00000000}},	// [1d0] _veldig_, _pro__vás_, --, --, 
   {{0xebf6f024,0x00000000,0x00000000,0x00000000}},	//   _हिंदी__के_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b802006,0x9470481e,0x6290381a,0x00000000}},	//   _informac, _privatna__poruka_, _bilang_, --, 
   {{0xb4444010,0x00000000,0x00000000,0x00000000}},	//   _ye_, --, --, --, 
   {{0xe1eb3006,0x00000000,0x00000000,0x00000000}},	//   _obchodní_, --, --, --, 
   {{0x92ca7015,0xba3e281c,0x00000000,0x00000000}},	//   _komersil__laman_, _मां_, --, --, 
   {{0x9342380d,0x00000000,0x00000000,0x00000000}},	//   _goberno_, --, --, --, 
   {{0xd224d81f,0x00000000,0x00000000,0x00000000}},	//   _uvek_, --, --, --, 
   {{0x3cc4181c,0x926c481a,0x00000000,0x00000000}},	//   _क्लिक__करें_, _nomor_, --, --, 
   {{0xd369a015,0x0ff7e028,0x00000000,0x00000000}},	//   _usaha__niaga_, _de__favorito, --, --, 
   {{0x32d8f807,0x8920d824,0x00000000,0x00000000}},	//   _dager_, _रामजी_, --, --, 
   {{0x4eb8e817,0x2e28e817,0x00000000,0x00000000}},	//   _ли_, _ла_, --, --, 
   {{0x1326981b,0x00000000,0x00000000,0x00000000}},	//   _at__tage_, --, --, --, 
   {{0xc6f4b80e,0xbc682013,0x5870d817,0x00000000}},	//   _में__सरकार_, _febrero_, _pevačica_, --, 
   {{0x94444010,0x22fc7810,0x217dd00e,0x2200b006}},	//   _we_, _kongo_, _भरोसा_, _chci_, 
   {{0x24b19822,0x00000000,0x00000000,0x00000000}},	// [1e0] _stare__svi_, --, --, --, 
   {{0xb4432013,0x0aa6400e,0x00000000,0x00000000}},	//   _hoy_, _में__देश_, --, --, 
   {{0x226cb01a,0xb0ec0017,0x00000000,0x00000000}},	//   _cocok_, _на__навигаци, --, --, 
   {{0x487d5003,0xaac70806,0x33f8c81e,0x8f686811}},	//   _महाराष्ट, _zboží_, _sadu_, _informac_reportar_, 
   {{0x82678817,0x644c000a,0x00000000,0x00000000}},	//   _dan__sati_, _साहित्य__अकादमी_, --, --, 
   {{0xee426017,0x32d8f81b,0x7a421024,0x0444401a}},	//   _је__да_, _tager_, _के__गठन_, _jl_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebc0a01c,0xb994c80c,0x34af600c,0xebf65824}},	//   _करने__के_, _môže_, _že__sa_, _संगीत__के_, 
   {{0x1d1a500c,0xa2fc7810,0xe394901a,0x5320c806}},	//   _ďalšie_, _congo_, _sukses_, _tady_, 
   {{0x784b8811,0xb3080815,0x9297a010,0xf2ca581b}},	//   _por__proporci, _terakhir__pada_, _umukuru_, _fuld_, 
   {{0xae1ff028,0xa65ab817,0xc4840810,0x00000000}},	//   _após_, _се__пријави_, _hagufi__aho_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9ab6a011,0x00000000,0x00000000,0x00000000}},	//   _tu__pregunta_, --, --, --, 
   {{0x9bb9301c,0x00000000,0x00000000,0x00000000}},	//   _हैं__कि_, --, --, --, 
   {{0x94499017,0x00000000,0x00000000,0x00000000}},	//   _na__poruka_, --, --, --, 
   {{0xf2d91016,0x42d9e807,0xb4b6980b,0x6200e810}},	//   _fazer_, _lite_, _atas__dan_, _hafi_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1f0] --, --, --, --, 
   {{0xd4444014,0x6e83400c,0x00000000,0x00000000}},	//   _gl_, _spoločno, --, --, 
   {{0x9430781e,0x72fa181b,0x00000000,0x00000000}},	//   _broj__poruka_, _tilmeldt__indlæg_, --, --, 
   {{0x926c1006,0x82d9a817,0xa444581a,0x00000000}},	//   _mohou_, _uspeh_, _gambar__rp_, --, 
   {{0x426c5828,0x382e3017,0xc338a004,0x00000000}},	//   _pelo_, _први_, _zdraví_, --, 
   {{0x2dc5601a,0x00000000,0x00000000,0x00000000}},	//   _semoga__bermanfa, --, --, --, 
   {{0xec11900e,0x5484e00d,0x3994d80c,0x82fc5807}},	//   _आदि__के_, _de__traballo_, _môžu_, _velg_, 
   {{0x32ffc805,0x00000000,0x00000000,0x00000000}},	//   _sakrij__citiraj_, --, --, --, 
   {{0x826c580c,0x2b9f2024,0x00000000,0x00000000}},	//   _telo_, _के__स्_, --, --, 
   {{0xcabc700a,0x64432002,0x33f9e82e,0x00000000}},	//   _राजा__भोज_, _soy_, _gitu_, --, 
   {{0xa31fa01a,0x023ab81b,0x00000000,0x00000000}},	//   _aja__yang_, _høj_, --, --, 
   {{0x12aab81b,0x00000000,0x00000000,0x00000000}},	//   _køb_, --, --, --, 
   {{0xfeb7d016,0x3e72e817,0x00000000,0x00000000}},	//   _possível_, _ме_, --, --, 
   {{0xb4b65807,0x1f072816,0x00000000,0x00000000}},	//   _etter__at_, _disponív, --, --, 
   {{0x2c3e8805,0x00000000,0x00000000,0x00000000}},	//   _se__komentir, --, --, --, 
   {{0xc26c580d,0x00000000,0x00000000,0x00000000}},	//   _polos_, --, --, --, 
   {{0x03ab5815,0x52d9c81b,0x00000000,0x00000000}},	// [200] _berkongs_kenalan_, _lavet_, --, --, 
   {{0xc27e9010,0x92d8f807,0xec4e080a,0x00000000}},	//   _imana_, _lage_, _काहे_, --, 
   {{0x82441813,0x226c780c,0x00000000,0x00000000}},	//   _cómo_, _meno_, --, --, 
   {{0xecb6a805,0x2bccc00a,0xa70f3824,0x00000000}},	//   _korisnik_nađi_, _एगो_, _मनाया__जाता_, --, 
   {{0x52de6037,0xb4b15016,0x5f9c7811,0x00000000}},	//   _खाली_, _descriçã, _ofensivo__publicar_, --, 
   {{0x64444010,0xd2e9c00d,0xb7764006,0xa3961006}},	//   _kw_, _as__súas_, _zkušenos, _napsal_, 
   {{0x3e426017,0x48d30817,0x00000000,0x00000000}},	//   _је__на_, _је__последњи_, --, --, 
   {{0x84444010,0xce834006,0x9de2f00d,0xe39ab006}},	//   _mw_, _společno, _pódense_, _města_, 
   {{0xb9f4300d,0x12d8f81b,0x138ab81b,0x00000000}},	//   _tamén_, _dage_, _gør_, --, 
   {{0x82cac807,0x4498a817,0x00000000,0x00000000}},	//   _hadde_, _moć__re_, --, --, 
   {{0x4442780d,0x00000000,0x00000000,0x00000000}},	//   _cun_, --, --, --, 
   {{0xc4ab2007,0x00000000,0x00000000,0x00000000}},	//   _kan__bli_, --, --, --, 
   {{0xe496e006,0xd3874806,0xc37e280d,0x00000000}},	//   _se__na_, _kterou_, _de__imaxes_, --, 
   {{0xd4444010,0x82b8b00d,0x133a180f,0x00000000}},	//   _bw_, _inc__unha_, _opće__diskusij, --, 
   {{0x93eb9013,0x00000000,0x00000000,0x00000000}},	//   _gusta_, --, --, --, 
   {{0xd2d92021,0x00000000,0x00000000,0x00000000}},	//   _मोदी_, --, --, --, 
   {{0xef9a6013,0xe291a02e,0x00000000,0x00000000}},	// [210] _las__palabras_, _bapak_, --, --, 
   {{0x4225e829,0x822f8817,0x64926007,0x7355d807}},	//   _netko_, _pre__sati_, _av__de_, _nyheter_, 
   {{0x631b7805,0x2444401a,0x00000000,0x00000000}},	//   _crna__kronika_, _gw_, --, --, 
   {{0x0bd9781c,0x5236680c,0x00000000,0x00000000}},	//   _गया__है_, _svoju_, --, --, 
   {{0x3af2200c,0xe422f81a,0x12be900c,0x00000000}},	//   _prihlási, _email__untuk_, _zatiaľ_, --, 
   {{0x9bd1280f,0xe461701b,0x00000000,0x00000000}},	//   _finansir_političk, _tilbage__til_, --, --, 
   {{0xd30fd815,0x00000000,0x00000000,0x00000000}},	//   _carian__nama_, --, --, --, 
   {{0xed937023,0x6192a820,0x00000000,0x00000000}},	//   _listopad_, _autonómi, --, --, 
   {{0x5053c817,0x4163c817,0x32011010,0x00000000}},	//   _године_, _година_, _kazi_, --, 
   {{0x6b8fe021,0x4c74d011,0x998e1817,0xe9a5f00c}},	//   _थे_, _lenguaje__ofensivo_, _начин_, _diskusia_, 
   {{0x026c200c,0xb045880c,0x12d8f81b,0x42d91010}},	//   _rokov_, _vyhraden, _tage_, _maze_, 
   {{0xd4444010,0x94b7201a,0x1c26e006,0x00000000}},	//   _rw_, _topik__apa_, _prostě_, --, 
   {{0x1248d806,0x825a9013,0x5d4fb006,0x0b9c881c}},	//   _jsem_, _cual_, _včetně_, _की__है_, 
   {{0x6273a813,0x53eab810,0x00000000,0x00000000}},	//   _línea_, _ndetse_, --, --, 
   {{0x26f8a01c,0xa37a2808,0x00000000,0x00000000}},	//   _होगा_, _paparan_, --, --, 
   {{0xb3a2481a,0x8334e01a,0x00000000,0x00000000}},	//   _sampe_, _pukul__melalui_, --, --, 
   {{0xa273a80d,0xa2011010,0x025aa015,0x00000000}},	// [220] _aínda_, _bazi_, _majlis_, --, 
   {{0xf4444010,0xae732017,0x4448b81f,0x047bd807}},	//   _tw_, _без_, _možete__da_, _noen__som_, 
   {{0xa396700b,0x49ebd01b,0x326c4838,0x7496e010}},	//   _kursus_, _undersøg, _domov_, _ku__wa_, 
   {{0xa6ffc039,0x44993028,0x00000000,0x00000000}},	//   _अर्थ_, _um__dos_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfe701803,0x00000000,0x00000000,0x00000000}},	//   _pencaria, --, --, --, 
   {{0x4ec27817,0x1ebdc006,0xb46c6016,0x00000000}},	//   _свиђа__ми_, _hodnocen, _com__um_, --, 
   {{0xfe3bf00d,0x3420901b,0xd4b7481b,0xffc0901b}},	//   _xuño_, _hjælper_, _find__vej_, _hjælpe_, 
   {{0x32ca780d,0x54422007,0x00000000,0x00000000}},	//   _cando_, _lik_, --, --, 
   {{0xd4429028,0xe41ba01b,0x00000000,0x00000000}},	//   _sua_, _at__blive_, --, --, 
   {{0xb442101a,0xb26ca00c,0xf257c01b,0xc2a6c015}},	//   _sih_, _lebo_, _vælge_, _nombor_, 
   {{0x93f9e806,0x625a9016,0x00000000,0x00000000}},	//   _datum_, _qual_, --, --, 
   {{0xd26ca006,0xb522c016,0xebbe3824,0xb2c9e815}},	//   _nebo_, _nome__opcional_, _युद्ध__के_, _dengan__resolusi_, 
   {{0x03ea0015,0x00000000,0x00000000,0x00000000}},	//   _iaitu_, --, --, --, 
   {{0xe0ecd006,0x00000000,0x00000000,0x00000000}},	//   _hodnocen_hvězdičk, --, --, --, 
   {{0x42317808,0x00000000,0x00000000,0x00000000}},	// [230] _bermula_, --, --, --, 
   {{0x3386d00c,0x00000000,0x00000000,0x00000000}},	//   _ktorej_, --, --, --, 
   {{0xf442201b,0xe4836017,0xecab480d,0x00000000}},	//   _fik_, _vest__na_, _da__coruña_, --, 
   {{0xe3f4681e,0x0442201b,0xb386e80d,0x25ff6818}},	//   _ujutru_, _gik_, _venres_, _क्योंकि_, 
   {{0x6a3c503a,0x8481c026,0x00000000,0x00000000}},	//   _आता_, _modrykon_sk_, --, --, 
   {{0x52fd7802,0x7ea98817,0x00000000,0x00000000}},	//   _imagen_, _одјавите__се_, --, --, 
   {{0x09645006,0x72de6024,0xf00a0817,0x00000000}},	//   _fotogale, _खाती_, _користећ_свој_, --, 
   {{0x6ac77806,0x0c4e3824,0x00000000,0x00000000}},	//   _další_, _चाहे_, --, --, 
   {{0xd4907828,0xd2b05011,0x137a6015,0x00000000}},	//   _em__que_, _opinión__otras_, _rawatan_, --, 
   {{0xddae3815,0x33f47807,0x54343017,0xad32000d}},	//   _mengikut_, _nesten_, _očistite__dezinfik, _calidade_, 
   {{0xe38c3817,0x00000000,0x00000000,0x00000000}},	//   _буде_, --, --, --, 
   {{0x227ff80c,0x00000000,0x00000000,0x00000000}},	//   _zoznam_, --, --, --, 
   {{0x537a602e,0x227e7827,0xdb88180e,0x00000000}},	//   _wawasan_, _henne_, _मय_, --, 
   {{0x1bf7181c,0x00000000,0x00000000,0x00000000}},	//   _में__एक_, --, --, --, 
   {{0xce38300b,0x00000000,0x00000000,0x00000000}},	//   _pengajia, --, --, --, 
   {{0xd6ffd81c,0x00000000,0x00000000,0x00000000}},	//   _इसका_, --, --, --, 
   {{0x03ea001a,0xb712a80d,0x00000000,0x00000000}},	// [240] _yaitu_, _dispoñib, --, --, 
   {{0x6394d812,0xc4919811,0x8324380c,0x00000000}},	//   _danske_, _posición__en_, _ak__chcete_, --, 
   {{0x14bd080d,0x2b81b80c,0x1300000d,0x00000000}},	//   _proxecto_, _sledovať_, _citar__esta_, --, 
   {{0x7419f802,0x00000000,0x00000000,0x00000000}},	//   _de__nuevo_, --, --, --, 
   {{0xc3959016,0x0a83d024,0x0bcda01c,0xc2070816}},	//   _nossa_, _काम__में_, _मित्र__को_, _código__abaixo_, 
   {{0x3afdf807,0xf2970017,0x8386d81b,0x00000000}},	//   _prosjekt, _nadji__info_, _ejer_, --, 
   {{0x6706380e,0x00000000,0x00000000,0x00000000}},	//   _आर्थिक__विकास_, --, --, --, 
   {{0x52d8281b,0x00000000,0x00000000,0x00000000}},	//   _anmeld_, --, --, --, 
   {{0x8d3fb817,0x00000000,0x00000000,0x00000000}},	//   _децембар__новембар_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xab88201c,0x12c56814,0x00000000,0x00000000}},	//   _नए_, _comentar__esta_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf34ba807,0xfbdff80c,0x00000000,0x00000000}},	//   _ikke__tillatt_, _aplikáci, --, --, 
   {{0x8291802e,0x00000000,0x00000000,0x00000000}},	//   _barat_, --, --, --, 
   {{0x42d8d01c,0x00000000,0x00000000,0x00000000}},	//   _होगी_, --, --, --, 
   {{0x0200d00b,0xc47b700d,0x8308981a,0x53ced81a}},	//   _beliau_, _organiza_sen_, _jawa__barat_, _trovit_, 
   {{0x450fb015,0xf3eb802d,0xe497201a,0x00000000}},	// [250] _komersil_, _bort_, _ya__gan_, --, 
   {{0x4c48d00a,0x00000000,0x00000000,0x00000000}},	//   _होखे_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x23f9802e,0xe496e013,0x00000000,0x00000000}},	//   _harus_, _no__es_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf492a825,0x00000000,0x00000000,0x00000000}},	//   _er__der_, --, --, --, 
   {{0x612d0017,0xb443900b,0xe0bbd806,0x04424828}},	//   _март_, _kos_, _hvězdičk, _fim_, 
   {{0x7338581b,0x537a6015,0x00000000,0x00000000}},	//   _tilmeldi_indlæg_, _jawapan_, --, --, 
   {{0x6cb39813,0x00000000,0x00000000,0x00000000}},	//   _de__ingreso_, --, --, --, 
   {{0x2338201b,0x82711803,0x00000000,0x00000000}},	//   _læs__mere_, _mulai__dari_, --, --, 
   {{0xcc4e883b,0xa2de8821,0x00000000,0x00000000}},	//   _जाते_, _जाती_, --, --, 
   {{0x92b81814,0x00000000,0x00000000,0x00000000}},	//   _de__vigo_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa290f815,0x9a475016,0x00000000,0x00000000}},	//   _sahaja_, _se__você_, --, --, 
   {{0x17c0d817,0x2443900d,0x00000000,0x00000000}},	//   _poruke__reputaci, _bos_, --, --, 
   {{0x0f31f00b,0x00000000,0x00000000,0x00000000}},	//   _seterusn, --, --, --, 
   {{0x2a1e7017,0x6c84b824,0xb291b80c,0x00000000}},	// [260] _бити_, _के__समर्थन_, _tovaru_, --, 
   {{0x8354180c,0x64420010,0xd4424828,0xf0319006}},	//   _všetky_, _iri_, _sim_, _předchoz, 
   {{0xf46ee00e,0x6fd99816,0x53f9901a,0x6b00b817}},	//   _मध्य__प्रदेश_, _em__até_, _kasus_, _септемба_август_, 
   {{0x7b882818,0x4b7cd80d,0x33a3a007,0x00000000}},	//   _ने_, _recoñece, _hopp_, --, 
   {{0x04916826,0x00000000,0x00000000,0x00000000}},	//   _by__som_, --, --, --, 
   {{0xd2905806,0x8290d022,0x33205806,0xbc57e80a}},	//   _byla_, _allahu_, _byly_, _के__साथे_, 
   {{0x9e438816,0x43960016,0x00000000,0x00000000}},	//   _atualiza, _nossos_, --, --, 
   {{0x2442d813,0xe3ce001b,0x2234b015,0x22aef022}},	//   _fue_, _blive_, _dari__lebih_, _ve__sellem_, 
   {{0x2ec86017,0x3442d81a,0xf427c00d,0xb3cfb802}},	//   _то__је_, _gue_, _todo__texto_, _leer__más_, 
   {{0x9200d01b,0x00000000,0x00000000,0x00000000}},	//   _muligt_, --, --, --, 
   {{0xe4420010,0x9bb16822,0xd37fc020,0xd4779815}},	//   _ari_, _za__političk, _comarca_, _pukul__ptg_, 
   {{0x34426813,0x7fc8e820,0x00000000,0x00000000}},	//   _uno_, _obrigato, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0bc6e01c,0x94300017,0x28a49824,0x00000000}},	//   _होता__है_, _poslednj_poruka_, _कौन__बनेगा_, --, 
   {{0x1f945806,0x72fe7027,0xeb99c80e,0x1201b00c}},	//   _jméno_, _norges_, _परिषद__के_, _neviem_, 
   {{0x5499201f,0x00000000,0x00000000,0x00000000}},	//   _pridruži_se_, --, --, --, 
   {{0xdb88483c,0x8442681b,0x22ab7027,0x00000000}},	// [270] _भए_, _mio_, _melding_, --, 
   {{0x2dacd815,0x00000000,0x00000000,0x00000000}},	//   _perniaga, --, --, --, 
   {{0x20eec00e,0xd2ca7810,0xc490602d,0x00000000}},	//   _गांव_, _kanda_, _ha__en_, --, 
   {{0x0a8f3024,0xb1beb01c,0xd2925007,0x00000000}},	//   _बिहार__में_, _टाइल_, _avtale_, --, 
   {{0x6e1d3007,0x1a3e280e,0x00000000,0x00000000}},	//   _spørsmål_, _माई_, --, --, 
   {{0x12f5981e,0xdd84a01b,0x416af006,0xb8eaf006}},	//   _miliona__evra_, _oprettet_, _nabídka_, _nabídky_, 
   {{0xb990b820,0x2e2a1017,0x00000000,0x00000000}},	//   _para__imprimir_, _национал, --, --, 
   {{0x6236e815,0x53807002,0x00000000,0x00000000}},	//   _tinjau_, _cerrar_, --, --, 
   {{0xa35e101e,0x92fd5002,0x534b9813,0x00000000}},	//   _beograd_, _juegos_, _la__imagen_, --, 
   {{0x018c680e,0xe2a11010,0x4a41f024,0x00000000}},	//   _सरोवर_, _bbc__izindi_, _के__गीत_, --, 
   {{0xd340481e,0x5092a024,0x00000000,0x00000000}},	//   _nedelja_, _शिवराज__सिंह_, --, --, 
   {{0x2e72e817,0xd442000c,0x44aa601b,0x00000000}},	//   _је_, _pri_, _del__af_, --, 
   {{0x2e56e817,0xed18201b,0x00000000,0x00000000}},	//   _из_, _længere_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1442000c,0xc3449007,0x00000000,0x00000000}},	//   _tri_, _blant__annet_, --, --, 
   {{0x6b6e5817,0x24420010,0xf3a3a007,0x3a3df00e}},	// [280] _се__прокомен, _uri_, _topp_, _देस_, 
   {{0xffa54015,0x42d9800c,0x00000000,0x00000000}},	//   _disember_, _okrem_, --, --, 
   {{0xd2fd8027,0xe5b3f806,0x8b645006,0xc2ca7810}},	//   _norge_, _nejlepší_, _oblečení_, _bandi_, 
   {{0xe6c34817,0x00000000,0x00000000,0x00000000}},	//   _порекло__презимен, --, --, --, 
   {{0xd4426828,0xf3005815,0x00000000,0x00000000}},	//   _rio_, _peluang__kerjaya_, --, --, 
   {{0x9442780d,0xb4976818,0x00000000,0x00000000}},	//   _nin_, _जम्मू_, --, --, 
   {{0xb46ed817,0xda6a101e,0x00000000,0x00000000}},	//   _време_, _sledeća_, --, --, 
   {{0xde737817,0x00000000,0x00000000,0x00000000}},	//   _већ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x24465805,0x00000000,0x00000000,0x00000000}},	//   _cijena__kn_, --, --, --, 
   {{0xe4895809,0xb727f80d,0x326cf816,0x82240010}},	//   _natrag__na_, _está__dispoñib, _jogos_, _ariko_, 
   {{0x04427807,0x72eb9807,0x73960016,0x00000000}},	//   _ein_, _kjenner_, _possui_, --, 
   {{0x6395401e,0xe48f6026,0xc4422007,0xe41ae01a}},	//   _umesto_, _aj__na_, _nrk_, _jakarta__timur_, 
   {{0x22018010,0x7020380d,0x00000000,0x00000000}},	//   _nari_, _votar__comentar_, --, --, 
   {{0x52bac806,0xd212e016,0x93eaf818,0x02ca9015}},	//   _něco_, _nenhum_, _राजस्थान_, _ini__diubah_, 
   {{0x546be006,0x27e6580e,0x00000000,0x00000000}},	//   _jak__se_, _शिवराज_, --, --, 
   {{0x62018010,0xc2d15016,0x00000000,0x00000000}},	// [290] _bari_, _produto__não_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd327701b,0xebc3d00e,0xc225901a,0x64c2d813}},	//   _at__have_, _डॉलर__के_, _meski_, _ciudad__de_, 
   {{0x93fb781b,0x00000000,0x00000000,0x00000000}},	//   _sig__selv_, --, --, --, 
   {{0xd2d86822,0xeae8200e,0x00000000,0x00000000}},	//   _opštinam, _आश्वासन_, --, --, 
   {{0xefe6c017,0xd3ea902e,0xb2018010,0x00000000}},	//   _против_, _liat_, _gari_, --, 
   {{0x6dea2017,0x1327701b,0x00000000,0x00000000}},	//   _јул__јун_, _at__lave_, --, --, 
   {{0x69fd3819,0xa334800b,0xe2018010,0x81b5c817}},	//   _pagament, _profesio_yang_, _zari_, _чланак_, 
   {{0xb4702017,0x9443e807,0xd2018010,0x00000000}},	//   _pre__dan_, _ett_, _yari_, --, 
   {{0xb2e31810,0x00000000,0x00000000,0x00000000}},	//   _buenos__aires_, --, --, --, 
   {{0xe301081b,0x2a63501c,0x00000000,0x00000000}},	//   _tilbage_, _में__विज्ञापन_, --, --, 
   {{0x1442600c,0xc48eb80d,0x5eac2027,0x00000000}},	//   _čo_, _de__ás_, _eksterne_, --, 
   {{0xbdc66817,0x54b63016,0x00000000,0x00000000}},	//   _lak__jednosta, _cadastre__se_, --, --, 
   {{0x998aa006,0x068d401c,0x00000000,0x00000000}},	//   _době_, _बदलाव_, --, --, 
   {{0x6f8bf019,0xaa3d4018,0xd2fe701b,0xe2267007}},	//   _até_, _लिए_, _bruger_, _bruker_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2291801a,0xa26cf81a,0x53cba003,0x00000000}},	// [2a0] _para_, _bogor_, _di__jakarta_, --, 
   {{0x86128806,0x44c4280d,0x00000000,0x00000000}},	//   _příspěvk, _rexistra_da_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2bf0000e,0x2c57c81c,0x4499b00d,0x92918010}},	//   _ना__हो_, _के__लिये_, _un__dos_, _wara_, 
   {{0xfbd3780e,0xc2d9c81e,0xe020980f,0x00000000}},	//   _भारत__से_, _savet_, _opštinam_izdvajan, --, 
   {{0xc44f6022,0x34432013,0x8cbff022,0x43781822}},	//   _postao__la_, _muy_, _mjesec__mjeseca_, _godina__redanje_, 
   {{0x5a3e1033,0x86f2581c,0x32d9c81b,0x00000000}},	//   _मगर_, _धर्म__संसार_, _laver_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x19f87806,0x0ec4580d,0x7335c811,0x00000000}},	//   _recenzí_, _teñen_, _dato__erróneo_, --, 
   {{0xc305681a,0x905c781c,0x32503817,0x00000000}},	//   _tidur__kamar_, _समाचार__व्यापार_, _рекао_, --, 
   {{0x2442c81b,0xa290e80c,0x00000000,0x00000000}},	//   _ind_, _priamo_, --, --, 
   {{0xf468d81a,0x00000000,0x00000000,0x00000000}},	//   _topic__kamu_, --, --, --, 
   {{0x23089016,0x3291a015,0xb44e182e,0x00000000}},	//   _aqui__para_, _bapa_, _syarat__dan_, --, 
   {{0xe29c980d,0xb6503813,0x00000000,0x00000000}},	//   _dúas_, _ubicació, --, --, 
   {{0xe443e807,0x850b380e,0xc2781803,0x00000000}},	//   _mot_, _के__किनारे_, _pengirim, --, 
   {{0x638b5007,0xefd71006,0x322ee017,0x00000000}},	//   _vår_, _protože_, _pre__godinu_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2b0] --, --, --, --, 
   {{0x1b5ec80e,0x00000000,0x00000000,0x00000000}},	//   _कमान_, --, --, --, 
   {{0xca3df01c,0xe305a00c,0x00000000,0x00000000}},	//   _दें_, _sk__pridala_, --, --, 
   {{0xada66817,0x00000000,0x00000000,0x00000000}},	//   _што__су_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc3ea7810,0xcd7f0017,0xe473201b,0x00000000}},	//   _bantu_, _пут_, _accepter_du_, --, 
   {{0x73fa6023,0xc27fb80d,0xa442d81b,0xb242d81c}},	//   _udruge_, _obter__máis_, _uge_, _पिछले_, 
   {{0x6692f024,0x2442d810,0x23ec1820,0x62fcf007}},	//   _के__विकास_, _ine_, _editar__editar_, _ganger_, 
   {{0x83f8c015,0x47721817,0xa2cad804,0x00000000}},	//   _laluan_, _овог_, _hned_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3442b004,0xa9827006,0x0318f00f,0xab1e7016}},	//   _nic_, _možnost_, _vlastito_siteu_, _pesquisa_, 
   {{0x1291a010,0xf28ca011,0x00000000,0x00000000}},	//   _papa_, _lugar__real_, --, --, 
   {{0x2300a00b,0x1ee3281c,0x00000000,0x00000000}},	//   _linkedin__anda_, _दें__मित्र_, --, --, 
   {{0x1450e01f,0x0bc4401c,0x904d0017,0x799b8810}},	//   _poruka__od_, _जाती__है_, _фотограф, _shakisha_, 
   {{0xc2926015,0x00000000,0x00000000,0x00000000}},	//   _borang_, --, --, --, 
   {{0xae47e80c,0x00000000,0x00000000,0x00000000}},	// [2c0] _spravoda, --, --, --, 
   {{0xa442d81a,0x00000000,0x00000000,0x00000000}},	//   _ane_, --, --, --, 
   {{0xdb8c983b,0xd29c980d,0xe25b7815,0x842fd015}},	//   _ऑफ_, _súas_, _soalan_, _kata__laluan_, 
   {{0x33958010,0x00000000,0x00000000,0x00000000}},	//   _morsi_, --, --, --, 
   {{0xf2f2c005,0x7e03701f,0xd442d806,0xc192b80c}},	//   _profil__pogledaj, _uključen_, _dne_, _zmazať__topovať_, 
   {{0xb409b802,0x00000000,0x00000000,0x00000000}},	//   _ver__más_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00b7a81c,0x00000000,0x00000000,0x00000000}},	//   _टीवी__गुदगुदी_, --, --, --, 
   {{0xe2359808,0xed9c080c,0x2ffea007,0x00000000}},	//   _pukul__pagi_, _odpoveda, _diskusjo, --, 
   {{0xcca96824,0x00000000,0x00000000,0x00000000}},	//   _तक__पहुंच_, --, --, --, 
   {{0x5306c805,0xfe0d2817,0x7019980c,0x00000000}},	//   _milijuna__kuna_, _ове_, _podmienk_používan, --, 
   {{0xc3940016,0x00000000,0x00000000,0x00000000}},	//   _dois_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2d9c81b,0xf3eac81b,0xebbc800e,0x3fbc500d}},	//   _have_, _lidt_, _वर्ग__के_, _cambios__relacion, 
   {{0x8205a82e,0x13a22819,0xab91e816,0x00000000}},	// [2d0] _memiliki_, _compre_, _gravar__registro_, --, 
   {{0x1b8c9824,0x72faf815,0x549fb007,0x4443f816}},	//   _गो_, _lebih__juta_, _spørsmål__om_, _sou_, 
   {{0xc356682e,0x00000000,0x00000000,0x00000000}},	//   _sebesar_, --, --, --, 
   {{0x12d9c825,0x00000000,0x00000000,0x00000000}},	//   _lave_, --, --, --, 
   {{0xea3df03d,0x7443f819,0x8c11c810,0x00000000}},	//   _देत_, _vou_, _bishya__ibiganir, --, 
   {{0xd2d34015,0x00000000,0x00000000,0x00000000}},	//   _dikenali_, --, --, --, 
   {{0xe32d0811,0x00000000,0x00000000,0x00000000}},	//   _cerrar__sesión_, --, --, --, 
   {{0xa7bb8809,0xc4b53827,0x00000000,0x00000000}},	//   _poslanik_, _index__php_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x82f99006,0xc708280a,0x00000000,0x00000000}},	//   _přidat_, _के__राजा_, --, --, 
   {{0xfc27a013,0xf2f9a80b,0x00000000,0x00000000}},	//   _artículo_, _dalam__masa_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5068e81e,0xee28e817,0x00000000,0x00000000}},	//   _ne__preporuč, _га_, --, --, 
   {{0x53054016,0xa317401e,0x00000000,0x00000000}},	//   _menciona_citado_, _zvezda_, --, --, 
   {{0xda3e380a,0x00000000,0x00000000,0x00000000}},	//   _फेर_, --, --, --, 
   {{0x4442d80c,0xe291d803,0x32d1c815,0xe2c49006}},	//   _nie_, _jawa_, _bertulis__adalah_, _jméno__heslo_, 
   {{0x935f600b,0x00000000,0x00000000,0x00000000}},	// [2e0] _lihat__profil_, --, --, --, 
   {{0x11752024,0xf323e010,0x00000000,0x00000000}},	//   _अल्पसंख्, _software__cyangwa_, --, --, 
   {{0x12d99016,0x02919016,0x026d800d,0x00000000}},	//   _esse_, _essa_, _foron_, --, 
   {{0x32d9d810,0x00000000,0x00000000,0x00000000}},	//   _nawe_, --, --, --, 
   {{0xc0536816,0x00000000,0x00000000,0x00000000}},	//   _mensagen, --, --, --, 
   {{0x0b8cb021,0xebce9824,0x00000000,0x00000000}},	//   _को_, _अध्ययन__के_, --, --, 
   {{0x127c2006,0x326c2010,0x72027015,0x44444003}},	//   _méně_, _koko_, _tarikh_, _jt_, 
   {{0x04426806,0x3dce7817,0x00000000,0x00000000}},	//   _pro_, _није_, --, --, 
   {{0x485f6816,0x0c6f6819,0x00000000,0x00000000}},	//   _estrelas_, _estrela_, --, --, 
   {{0xc26de005,0x1249f810,0x00000000,0x00000000}},	//   _diskutan_broj_, _nyuma_, --, --, 
   {{0xfe3bf00d,0xf236c01a,0x00000000,0x00000000}},	//   _liña_, _produksi_, --, --, 
   {{0x92787006,0x64bb5819,0xd469e01e,0xc297b816}},	//   _první_, _mais__de_, _gde__su_, _adiciona_como_, 
   {{0x2ed52817,0x64a3d811,0x00000000,0x00000000}},	//   _под_, _delante__de_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9c537023,0x447ba00f,0xe2d9d810,0xcaa2500c}},	//   _postova_, _komentar_re_, _yawe_, _sa__musíte_, 
   {{0xc49be007,0xe44c6017,0x00000000,0x00000000}},	//   _ut__av_, _gratis__na_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2f0] --, --, --, --, 
   {{0xeb546014,0xdd699816,0x7ad68017,0x5cee3017}},	//   _de__composte, _acessóri, _јануар_, _пред_, 
   {{0x52d8c80d,0x00000000,0x00000000,0x00000000}},	//   _galego_, --, --, --, 
   {{0xbe1c480d,0x6459980f,0xe498601b,0xfa3e500a}},	//   _última__modifica, _bih__postao_, _nu__er_, _भइल_, 
   {{0x62d9e810,0x7201e810,0x72f3981b,0x00000000}},	//   _bate_, _bati_, _udgivet_, --, 
   {{0xd419800d,0x00000000,0x00000000,0x00000000}},	//   _modifica_desta_, --, --, --, 
   {{0xa442d826,0x63e10815,0x00000000,0x00000000}},	//   _tie_, _hb__ogos_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x86ff580a,0x00000000,0x00000000,0x00000000}},	//   _जाला_, --, --, --, 
   {{0x2eecd817,0x00000000,0x00000000,0x00000000}},	//   _ово__је_, --, --, --, 
   {{0x6a8a8817,0x52ca7810,0xa3959016,0xa0189006}},	//   _август_, _kandi_, _nosso_, _přísluše, 
   {{0x14b3601b,0xb4429007,0x17a09006,0xb5f9681c}},	//   _okt__kl_, _bra_, _podmínky_, _त्योहार_, 
   {{0x2ed4e817,0xf2fcd802,0x00000000,0x00000000}},	//   _до_, _juego_, --, --, 
   {{0x12d8b006,0xb9ffc80d,0x2c072807,0x00000000}},	//   _akce_, _véxase__tamén_, _uansett_, --, 
   {{0xc2da681a,0x12fcd802,0x2190a010,0x00000000}},	//   _karena_, _luego_, _css__ntushobo, --, 
   {{0x9c813811,0x4a56b81c,0x00000000,0x00000000}},	//   _opinión__escribe_, _अन्य__खेल_, --, --, 
   {{0x4442f81b,0xcef12017,0x00000000,0x00000000}},	// [300] _mig_, _има_, --, --, 
   {{0xc442000d,0x7355d81b,0xbc4e600a,0x00000000}},	//   _hai_, _nyheder_, _कइले_, --, 
   {{0xf4444007,0xd1f79817,0xc26c201a,0xd7537817}},	//   _ut_, _ова__страница_, _toko_, _други__језици_, 
   {{0xf4444007,0x9af6c01b,0x00000000,0x00000000}},	//   _ho_, _oplevels, --, --, 
   {{0x24444010,0x3ec71013,0x56f9f00e,0x00000000}},	//   _ko_, _nosotros_, _मोटा_, --, 
   {{0x64b7e814,0xee08c017,0x00000000,0x00000000}},	//   _santiago__de_, _фебруар_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x34444013,0x72fce00d,0x1c96781c,0x00000000}},	//   _lo_, _lingua_, _क्यों_, --, 
   {{0xb442f81b,0x7e51901e,0x00000000,0x00000000}},	//   _dig_, _je__uključen_, --, --, 
   {{0xe4438022,0xa26de838,0xefe10817,0x7ab81806}},	//   _kur_, _potom_, _свој_, _odpověď_, 
   {{0x8c083810,0x00000000,0x00000000,0x00000000}},	//   _ibiganir, --, --, --, 
   {{0x94429028,0xc2de081c,0x04438010,0x86fe081c}},	//   _pra_, _किसी_, _mur_, _खेल__संसार_, 
   {{0x94444010,0xf4b48816,0x07534007,0x74432006}},	//   _bo_, _estrelas__bom_, _barnehag, _dny_, 
   {{0x22cbc81b,0xe2dc1029,0x83236820,0x00000000}},	//   _havde_, _dalmacij, _de__nomes_, --, 
   {{0x430d2008,0xa442000d,0xd34c8803,0x00000000}},	//   _pelajar_, _fai_, _yang__berbeda_, --, 
   {{0x84be380d,0x3470e00c,0x5165501c,0xc9fff811}},	//   _consulte__os_, _tak__sa_, _कॉमेंट__लाइव_, _búsqueda, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [310] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1444400c,0xa4be3022,0xc20b981a,0xda63280e}},	//   _zo_, _programe__za_, _minggu__hari_, _फेस्टिवल_, 
   {{0x04444010,0x84438038,0x646c6019,0x00000000}},	//   _yo_, _eur_, _com__de_, --, 
   {{0xa442f81b,0x48fa2816,0xd28a5017,0x00000000}},	//   _sig_, _direitos__reservad, _навигаци_претрага_, --, 
   {{0x16fed818,0x8706081c,0x6bd74011,0x00000000}},	//   _किया_, _खबर__संसार_, _tu__informac, --, 
   {{0x55fec81f,0xb3134006,0xf3730011,0x82c2a81a}},	//   _korišćen, _než__více_, _delante_, _anda__bisa_, 
   {{0x34bb901b,0x92781803,0x00000000,0x00000000}},	//   _klik__her_, _mengirim, --, --, 
   {{0x8ef11817,0x2442101a,0x2eefe817,0x00000000}},	//   _смо_, _nah_, _текст__је_, --, 
   {{0xcc7e6013,0x086e6013,0x7307e015,0x00000000}},	//   _nuestro_, _nuestros_, _menyerta_juta_, --, 
   {{0x9fd7800c,0x00000000,0x00000000,0x00000000}},	//   _pretože_, --, --, --, 
   {{0x127b7806,0xe4627007,0x0397c01b,0x00000000}},	//   _komentář, _tilbake__til_, _medarbej, --, 
   {{0xc4746029,0x00000000,0x00000000,0x00000000}},	//   _tko__je_, --, --, --, 
   {{0xd444400c,0x54936006,0x00000000,0x00000000}},	//   _vo_, _by__se_, --, --, 
   {{0x2ed5981d,0xe4444010,0x00000000,0x00000000}},	//   _než_, _wo_, --, --, 
   {{0xf328a009,0x83415006,0x5bee7017,0x00000000}},	// [320] _na__jezeru_, _stejně_, _зато_, --, 
   {{0x6caff816,0xebbe6024,0xac617813,0x00000000}},	//   _no__cartão_, _केंद्र__के_, _alguien_, --, 
   {{0x198b400c,0x54431016,0x6367c80d,0x00000000}},	//   _prečo_, _diz_, _imprimir__caixa_, --, 
   {{0xb2329009,0x00000000,0x00000000,0x00000000}},	//   _februara__godine_, --, --, --, 
   {{0xb26c580c,0xd442101a,0x00000000,0x00000000}},	//   _bolo_, _yah_, --, --, 
   {{0xa98b400c,0x526e180c,0x6eab8817,0x00000000}},	//   _niečo_, _šport_, _повезао__са_, --, 
   {{0x04422023,0x1386880c,0xb27ee807,0x2f1b980c}},	//   _kak_, _ktoré_, _finner_, _vaša_, 
   {{0xf4422006,0x226da01f,0xfb248015,0xdb09f811}},	//   _jak_, _lepo_, _dilarang__linkedin_, _publicar__opinión_, 
   {{0xc27f0010,0xc290e023,0xe0f3e829,0x24422008}},	//   _abantu_, _dinamo_, _županije_, _mak_, 
   {{0xe2b5d807,0x00000000,0x00000000,0x00000000}},	//   _upassend_innlegg_, --, --, --, 
   {{0x4ceed817,0x6478600d,0x942af817,0x0c07e01c}},	//   _уреди_, _xunta__de_, _dezinfik_celu_, _लगता__है_, 
   {{0x4444401b,0xc20d200d,0x34422015,0x00000000}},	//   _af_, _máis_, _nak_, --, 
   {{0x0cd9381a,0x6e53200b,0x00000000,0x00000000}},	//   _melalui__seluler_, _sumbanga, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa26da00f,0x72d9e806,0xd386900c,0x74422027}},	//   _depo_, _jste_, _ktorá_, _bak_, 
   {{0x09c0f805,0x101fa016,0x00000000,0x00000000}},	//   _prometna_, _endereço_, --, --, 
   {{0xe226001a,0x00000000,0x00000000,0x00000000}},	// [330] _kaskus_, --, --, --, 
   {{0xbe19f803,0x4399c01b,0xac71b82d,0x00000000}},	//   _menemuka, _læste_, _startet_, --, 
   {{0xb4936013,0x13f0b80d,0x00000000,0x00000000}},	//   _es__el_, _da__páxina_, --, --, 
   {{0xc4422003,0x74439002,0x6399c01b,0x13960012}},	//   _gak_, _tus_, _næste_, _masser_, 
   {{0xa7605017,0x0a80500e,0x930b9816,0x00000000}},	//   _ауторств_делити_, _असल__में_, _um__pouco_, --, 
   {{0xaed56817,0xec5af817,0x60b27806,0x5326e80d}},	//   _још_, _izvor__komentar, _práva__vyhrazen, _en__galego_, 
   {{0x230e100b,0xe33b4817,0x5ea6a807,0x130d281a}},	//   _apabila_, _tekstova__blogu_, _fortsatt_, _pelapor_, 
   {{0xc9c64028,0x00000000,0x00000000,0x00000000}},	//   _apresent, --, --, --, 
   {{0x22d9e80c,0x04423005,0x72979811,0x00000000}},	//   _este_, _kaj_, _amigo__pero_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x24423012,0xe4826825,0x00000000,0x00000000}},	//   _maj_, _adgang__til_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0cca0815,0x00000000,0x00000000,0x00000000}},	//   _nama__pertama_, --, --, --, 
   {{0xb6f9b03e,0x54422006,0xd1c5e81c,0xf2fce01a}},	//   _पैसा_, _pak_, _सेहत__व्यंजन_, _pengen_, 
   {{0xb3395822,0xa3b89822,0x4c01b81a,0x0355d815}},	//   _je__napisao_, _stranica__natrag_, _agustus_, _suka__komen_, 
   {{0xcc802017,0xe290c015,0x9f945806,0x00000000}},	// [340] _везе_, _jumaat_, _svého_, --, 
   {{0x64420010,0x00000000,0x00000000,0x00000000}},	//   _isi_, --, --, --, 
   {{0xb2cb4815,0x00000000,0x00000000,0x00000000}},	//   _kaedah_, --, --, --, 
   {{0xc234f815,0x00000000,0x00000000,0x00000000}},	//   _buat__kali_, --, --, --, 
   {{0x609eb005,0xb9dbf836,0x00000000,0x00000000}},	//   _registri_korisnik_, _दान__सहायता_, --, --, 
   {{0x6301e01a,0x6457b828,0xabf51006,0x84433020}},	//   _berarti_, _até__de_, _produktů_, _xix_, 
   {{0x434c200f,0x472d980e,0x73afc807,0x96efe00d}},	//   _lud__zbunjen_, _दिखाई__देता_, _håper_, _páxinas__especiai, 
   {{0xa303f807,0x00000000,0x00000000,0x00000000}},	//   _les__hele_, --, --, --, 
   {{0x2412401a,0x73bcd81a,0x02b4301a,0x71fe2817}},	//   _bagi__simpan_, _menerima__syarat_, _jakarta__pusat_, _кроз_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc2fc7803,0xecbe2817,0x00000000,0x00000000}},	//   _dong_, _каже_, --, --, 
   {{0xaa32b018,0x00000000,0x00000000,0x00000000}},	//   _कोश_, --, --, --, 
   {{0x8c38201c,0xdb926806,0x00000000,0x00000000}},	//   _लखनऊ_, _srovnání_, --, --, 
   {{0xe98a6806,0x9f5c8020,0x00000000,0x00000000}},	//   _proč_, _de__contrata, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x204ba034,0x14a77807,0x66465007,0x4245a015}},	//   _सामग्री_, _kontakt__oss_, _gjennomf, _pandu__arah_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [350] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72d8a029,0xd2d9801b,0xa36a1003,0x00000000}},	//   _uvjeti_, _opret_, _iklan__yang_, --, 
   {{0xb442d80c,0x42cad80c,0xdc01e01b,0x00000000}},	//   _pre_, _pred_, _næsten_, --, 
   {{0xad9c4017,0x00000000,0x00000000,0x00000000}},	//   _могући__су_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c74003e,0xa4aa581a,0x00000000,0x00000000}},	//   _आवश्यक_, _harga__rp_, --, --, 
   {{0x2fcde80c,0xb4b2181b,0x00000000,0x00000000}},	//   _článok_, _til__dig_, --, --, 
   {{0xc2b6e022,0x0dad0016,0x140d380d,0x54254017}},	//   _ica__vrijeme_, _quantida, _desta__páxina_, _dezinfik, 
   {{0x3ba5881c,0x00000000,0x00000000,0x00000000}},	//   _है__जो_, --, --, --, 
   {{0x5a3cc00a,0x52ebc81b,0x2ba0100c,0x00000000}},	//   _एकर_, _kvinder_, _porovnať__sledovať_, --, 
   {{0xe442582e,0x7394900d,0x00000000,0x00000000}},	//   _hal_, _coas_, --, --, 
   {{0x6fe79806,0x00000000,0x00000000,0x00000000}},	//   _svůj_, --, --, --, 
   {{0xa22b201e,0x00000000,0x00000000,0x00000000}},	//   _promene_, --, --, --, 
   {{0x23ef4829,0x34425826,0x1c5f4829,0x84b1b022}},	//   _obitelji_, _mal_, _obitelj_, _kur__ana_, 
   {{0x43721016,0x6ca5b80c,0x00000000,0x00000000}},	//   _como__amigo_, _upraviť__zmazať_, --, --, 
   {{0x8201601a,0x34b22822,0xfb0ae00d,0xe08ae00d}},	// [360] _bagian_, _posta__nja_, _conselle, _concello, 
   {{0xd471f814,0x223ea025,0xb6dc6017,0x00000000}},	//   _nos__que_, _svar__skriv_, _коришћењ, --, 
   {{0x626de81b,0x9412b01a,0x00000000,0x00000000}},	//   _netop_, _com__buat_, --, --, 
   {{0x4aea6807,0x00000000,0x00000000,0x00000000}},	//   _fortelle, --, --, --, 
   {{0x0bffc01c,0xc4b6e007,0x00000000,0x00000000}},	//   _होती__है_, _løpet__av_, --, --, 
   {{0x94425814,0xb299701a,0x00000000,0x00000000}},	//   _cal_, _simpan__iklan_, --, --, 
   {{0xf236680c,0x53eac007,0x00000000,0x00000000}},	//   _svoj_, _alltid_, --, --, 
   {{0x6b8e4018,0xebcb7824,0x00000000,0x00000000}},	//   _आप_, _राष्ट्र__के_, --, --, 
   {{0x9467c805,0x63ce900f,0x3323a81b,0x00000000}},	//   _postove__datum_, _slavo_, _af__vores_, --, 
   {{0x998ab00c,0x00000000,0x00000000,0x00000000}},	//   _podľa_, --, --, --, 
   {{0xae612817,0x626fb815,0x00000000,0x00000000}},	//   _где_, _malaysia__tinjau_, --, --, 
   {{0xf4aa2017,0x0236680c,0x00000000,0x00000000}},	//   _din__din_, _tvoj_, --, --, 
   {{0xe66c1823,0xe386c807,0x1a421824,0x00000000}},	//   _odvjetni, _aldri_, _के__कुल_, --, 
   {{0xa254001c,0x6ba20006,0x00000000,0x00000000}},	//   _कॉमेंट_, _případě_, --, --, 
   {{0xdc49e035,0xb2f56006,0x00000000,0x00000000}},	//   _पैसे_, _mpix__více_, --, --, 
   {{0x4492601b,0x3a3c400a,0x6303f807,0x00000000}},	//   _en__af_, _आपन_, _les__alle_, --, 
   {{0x646ce014,0x911d9829,0x00000000,0x00000000}},	// [370] _foi__de_, _na__sadržaj_, --, --, 
   {{0x34b9b00f,0x00000000,0x00000000,0x00000000}},	//   _sarajevo__vrh_, --, --, --, 
   {{0x47154016,0x2afe881a,0x00000000,0x00000000}},	//   _seguranç, _aparteme, --, --, 
   {{0x0864e809,0xdfe3d806,0x54426816,0xb4a82819}},	//   _bosne__hercegov, _celý__článek_, _nao_, _opcional_, 
   {{0xa3325003,0x00000000,0x00000000,0x00000000}},	//   _informas_yang_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e8a9830,0x0a5df00e,0x8a3ee01c,0x00000000}},	//   _प्रतिशत_, _कार्यक्र_में_, _फिर_, --, 
   {{0x026cd81e,0x548a5806,0x5f3a402e,0x00000000}},	//   _hteo_, _které__se_, _transfer_, --, 
   {{0x6c621803,0x00000000,0x00000000,0x00000000}},	//   _masukan_, --, --, --, 
   {{0x52ff880f,0xe27f7804,0x00000000,0x00000000}},	//   _odobrenj_takođe_, _jedná_, --, --, 
   {{0xec59e01c,0xfed51817,0x00000000,0x00000000}},	//   _साल__पहले_, _док_, --, --, 
   {{0x0a3e500e,0xd44cd815,0x00000000,0x00000000}},	//   _भजन_, _lompat__ke_, --, --, 
   {{0xc25ac81b,0xc6c5f808,0x00000000,0x00000000}},	//   _mellem_, _sebahagi, --, --, 
   {{0x1c537029,0xd2fc9008,0x92dfa01c,0xe4c3b006}},	// [380] _sustava_, _niaga_, _शादी_, _přejít__na_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2ca781b,0x927f5007,0x00000000,0x00000000}},	//   _mand_, _trener_, --, --, 
   {{0xaea0980b,0x00000000,0x00000000,0x00000000}},	//   _linkedin__pengguna, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x726cf804,0x00000000,0x00000000,0x00000000}},	//   _tohoto_, --, --, --, 
   {{0xeb94c00e,0x23163016,0x7eb3000d,0xc62d6807}},	//   _दिवस__के_, _em__estoque_, _dereitos_, _trondhei, 
   {{0x13dc4810,0x00000000,0x00000000,0x00000000}},	//   _hamwe_, --, --, --, 
   {{0xe40b8817,0x9442782e,0x00000000,0x00000000}},	//   _ujutru__ujutru_, _ban_, --, --, 
   {{0xdf10c01e,0xaf1b980c,0x00000000,0x00000000}},	//   _predsedn, _naša_, --, --, 
   {{0x52925028,0x00000000,0x00000000,0x00000000}},	//   _citado_, --, --, --, 
   {{0xf26cd006,0xcca9101c,0x5e2ae00c,0x00000000}},	//   _budou_, _और__देखें_, _na__základe_, --, 
   {{0xa3ea7807,0x1da3380a,0x00000000,0x00000000}},	//   _fant_, _संगोष्ठी_, --, --, 
   {{0xe442781a,0x34439017,0x12f1200e,0x7cc0a81c}},	//   _gan_, _sns_, _जरुरत_, _जाने__वाले_, 
   {{0x426cb013,0xd1ff3822,0xdf3bd01a,0xc5591017}},	//   _poco_, _sljedeća__prikaži_, _kebutuha, _октобар__септемба, 
   {{0x54900813,0x34baf007,0x00000000,0x00000000}},	//   _el__uso_, _inn__på_, --, --, 
   {{0x5c649002,0xaf87500c,0x00000000,0x00000000}},	// [390] _octubre_, _košice_, --, --, 
   {{0xf484883b,0x8d83880c,0x547dd014,0x00000000}},	//   _ऑनलाइन_, _nič_, _foto__no_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa9f54016,0xc29b2016,0xafe12811,0x00000000}},	//   _preço_, _sem__juros_, _el__vendedor_, --, 
   {{0x44438007,0xb3869809,0xc4426810,0x00000000}},	//   _gir_, _bajram_, _aho_, --, 
   {{0x92d2e80d,0xd38ea01d,0x00000000,0x00000000}},	//   _ás__todo_, _ubytován, --, --, 
   {{0x427ed81b,0xc2015816,0x14adc016,0x00000000}},	//   _uden_, _digite_, _serviços_, --, 
   {{0x6c51f022,0xa4439013,0xc4a4e00c,0x9426181a}},	//   _kantona_, _mis_, _čo__je_, _tulisan__baru_, 
   {{0x22cb4013,0x00000000,0x00000000,0x00000000}},	//   _pueden_, --, --, --, 
   {{0x43d4581b,0x03eb8015,0x62ca781b,0xb421f817}},	//   _mest__læste_, _parti_, _vand_, _ženski__poruke_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2fe701b,0xe2267007,0x73566815,0x00000000}},	//   _bruges_, _brukes_, _sebenar_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe386a026,0xb3871006,0xb466881b,0x00000000}},	//   _dobre_, _vybrat_, _tilmeld__dig_, --, 
   {{0x12a6d80c,0x47cea810,0x2446d80d,0x00000000}},	// [3a0] _alebo_, _amashaki, _galego__ir_, --, 
   {{0xc2c91815,0x97580024,0x00000000,0x00000000}},	//   _dengan__terma_, _विद्वान_, --, --, 
   {{0xc3870006,0xf208000c,0x6fa4f838,0xc32e8010}},	//   _které_, _informác, _používan, _to__friend_, 
   {{0x0492a811,0x54983010,0x22d3a811,0x00000000}},	//   _es__por_, _ya__css_, _del__foro_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf450100d,0xec527810,0x00000000,0x00000000}},	//   _túa__conta_, _amatora_, --, --, 
   {{0x34b1300f,0xdfa1100d,0x93b1100d,0x00000000}},	//   _okt__vrh_, _servizos_, _servizo_, --, 
   {{0x626c2010,0x8396680d,0x00000000,0x00000000}},	//   _kuko_, _persoa_, --, --, 
   {{0xbbbdb00e,0x00000000,0x00000000,0x00000000}},	//   _अंत__तक_, --, --, --, 
   {{0x03ea9003,0x34429010,0xd3b55817,0x00000000}},	//   _saat_, _saa_, _налог__одјавите_, --, 
   {{0x99f3a808,0x83860007,0x83870806,0x93ce001b}},	//   _daripada_, _blir_, _která_, _bliv_, 
   {{0x1999a006,0x00000000,0x00000000,0x00000000}},	//   _např_, --, --, --, 
   {{0xe23b0807,0x12a6d805,0xd2fc901b,0xac60580c}},	//   _innlegg_, _osobnu_, _fragt_, _augusta_, 
   {{0x94426820,0xd3eb9007,0xfc0b2024,0x00000000}},	//   _iso_, _sist_, _रुप__से_, --, 
   {{0x48871016,0x93947807,0x8fd0981c,0x00000000}},	//   _bom__estrelas_, _minst_, _पर्यटन__समाचार_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4fe11017,0x00000000,0x00000000,0x00000000}},	// [3b0] _овај_, --, --, --, 
   {{0xb218101c,0x00000000,0x00000000,0x00000000}},	//   _स्__टाइल_, --, --, --, 
   {{0x8352880a,0x525bf828,0x3cd6201c,0xe3f88810}},	//   _के__संबंध_, _paulo_, _संपर्क__करें_, _gihugu_, 
   {{0x547d5019,0x63492010,0x00000000,0x00000000}},	//   _para__se_, _yishingi_ibibera_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xeb8c901c,0x83967816,0x00000000,0x00000000}},	//   _गई_, _pessoa_, --, --, 
   {{0x73eb801a,0x26eae81c,0x6c61781c,0xea5ab011}},	//   _kartu_, _है__लेकिन_, _को__भेजें_, _reportar__contenid, 
   {{0xadc0c817,0x5ae20028,0x93e3a822,0x6e6c5007}},	//   _који__су_, _interess, _tuzlansk, _du__spørsmål_, 
   {{0x14b4600d,0x1f92a817,0xd491f814,0xec7d7813}},	//   _foundati_inc_, _pol__muški_, _na__que_, _persona_, 
   {{0x54429010,0x00000000,0x00000000,0x00000000}},	//   _aha_, --, --, --, 
   {{0x04a99811,0x00000000,0x00000000,0x00000000}},	//   _abajo__por_, --, --, --, 
   {{0x4dc2601e,0x00000000,0x00000000,0x00000000}},	//   _jednosta_način_, --, --, --, 
   {{0xaed4e817,0xca0f8006,0x0292100d,0x00000000}},	//   _то_, _následuj, _espazo_, --, 
   {{0xe498f011,0x00000000,0x00000000,0x00000000}},	//   _categorí_es_, --, --, --, 
   {{0xc9b14806,0x33e51023,0xbe71480c,0x00000000}},	//   _ostatní_, _prikaži__sakrij_, _ostatné_, --, 
   {{0x026cf816,0xd690c01c,0x00000000,0x00000000}},	//   _jogo_, _के__खिलाफ_, --, --, 
   {{0xe3085015,0x3ce9f00c,0x14abe811,0x00000000}},	// [3c0] _mengikut__negara_, _pridala__príspevk, _hablaras__con_, --, 
   {{0x02fcf807,0x00000000,0x00000000,0x00000000}},	//   _logg_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x26d29021,0xc200b00f,0x22c89016,0xf345901c}},	//   _लेकिन_, _kukić_, _estoque_, _बॉलीवुड__टीवी_, 
   {{0x4ed25817,0x00000000,0x00000000,0x00000000}},	//   _да__ће_, --, --, --, 
   {{0x54444010,0x7c36380c,0x00000000,0x00000000}},	//   _ku_, _vybrať_, --, --, 
   {{0x44444026,0xc2d38803,0x00000000,0x00000000}},	//   _ju_, _dari__berbagai_, --, --, 
   {{0x74444010,0x00000000,0x00000000,0x00000000}},	//   _mu_, --, --, --, 
   {{0x9316c80c,0x00000000,0x00000000,0x00000000}},	//   _medzi_, --, --, --, 
   {{0xd33fc012,0xf62c1816,0x24e9781c,0x7291a01a}},	//   _der__ikke_, _condiçõe, _नायिका__रोमांस_, _oppa_, 
   {{0x8444401b,0x00859808,0xf4908816,0x00000000}},	//   _nu_, _juta__profesio, _comentár_seu_, --, 
   {{0x327f801b,0x19f65016,0x00000000,0x00000000}},	//   _gerne_, _então_, --, --, 
   {{0xd442c815,0x72542017,0x0b3c2810,0x00000000}},	//   _kad_, _po__ceni_, _neza__ukoreshe, --, 
   {{0xbb89d013,0x232c281b,0xd4426810,0x00000000}},	//   _noviembr, _se__mere_, _izo_, --, 
   {{0xa4b4d01f,0x0491a007,0x00000000,0x00000000}},	//   _noćenja_, _er__ein_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbab46806,0x53178006,0x00000000,0x00000000}},	// [3d0] _vlastní_, _verze_, --, --, 
   {{0x943b3802,0xc05fe80e,0x42c2d013,0x00000000}},	//   _me__gusta_, _उदास_, _un__poco_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb3f40807,0x801a601f,0x00000000,0x00000000}},	//   _har__vært_, _vojvodin, --, --, 
   {{0xbf8bf00c,0x00000000,0x00000000,0x00000000}},	//   _iné_, --, --, --, 
   {{0xae00e817,0x00000000,0x00000000,0x00000000}},	//   _које__су_, --, --, --, 
   {{0x72d5581b,0xfb4a4811,0x99990006,0x00000000}},	//   _fået_, _una__respuest, _dobře_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x74ae580f,0x00fd800a,0x00000000,0x00000000}},	//   _stranke__po_, _मालवा_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x48163810,0x0abe101c,0x00000000,0x00000000}},	//   _mugihe__amashaki, _मामले__में_, --, --, 
   {{0xb4abe81a,0xc399381b,0x649fa016,0x6443c812}},	//   _bermanfa_dan_, _måske_, _cartão__de_, _giv_, 
   {{0x0443f810,0xec70301c,0x5c6bc027,0x00000000}},	//   _onu_, _महीने__पहले_, _akkurat_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [3e0] --, --, --, --, 
   {{0x126d8013,0xf3cd0806,0x00000000,0x00000000}},	//   _otros_, _osobní_, --, --, 
   {{0x4def300c,0x00000000,0x00000000,0x00000000}},	//   _zaujímav, --, --, --, 
   {{0xebcb780e,0x6467301a,0xceaa381c,0x00000000}},	//   _सरकार__के_, _apa__aja_, _हॉट__शॉट्_, --, 
   {{0x422a2006,0x19f4e006,0x434b981b,0x00000000}},	//   _přihlási, _deník_, _at__bruge_, --, 
   {{0x0c8fb81c,0xa31e1015,0x00000000,0x00000000}},	//   _हमारे__बारे_, _sesiapa__yang_, --, --, 
   {{0x7c48481c,0x00000000,0x00000000,0x00000000}},	//   _वाले_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x42532810,0xc220d80c,0x00000000,0x00000000}},	//   _new__york_, _dámske_, --, --, 
   {{0x3c8ad80c,0x2baba017,0x34924013,0x00000000}},	//   _príspevk, _истим__условима_, _es__muy_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9da79815,0xe4b1f807,0x630ed002,0x00000000}},	//   _kerosaka, _opp__til_, _tambien_, --, 
   {{0x348f080c,0xda3c281c,0x00000000,0x00000000}},	//   _páči__sa_, _एंड_, --, --, 
   {{0x7c8ad80c,0xe402a00d,0x00000000,0x00000000}},	//   _príspevo, _sen__fins_, --, --, 
   {{0xb443e81b,0xa38a8016,0x83ebe807,0x00000000}},	//   _mit_, _fórum_, _mitt_, --, 
   {{0x73ebe807,0x83eae81b,0x00000000,0x00000000}},	//   _litt_, _haft_, --, --, 
   {{0x646d6020,0x00000000,0x00000000,0x00000000}},	// [3f0] _lei__de_, --, --, --, 
   {{0x9a263839,0x776f6833,0x00000000,0x00000000}},	//   _उपलब्ध_, _टिप्पणी_, --, --, 
   {{0xab8cb818,0x00000000,0x00000000,0x00000000}},	//   _की_, --, --, --, 
   {{0xf2026815,0x22e7a00d,0x00000000,0x00000000}},	//   _carian_, _acceder__para_, --, --, 
   {{0xeca1681c,0x00000000,0x00000000,0x00000000}},	//   _से__पहले_, --, --, --, 
   {{0x929c980d,0x00000000,0x00000000,0x00000000}},	//   _rúa_, --, --, --, 
   {{0xa29c980d,0x2443e825,0x29bce817,0xf3ebe807}},	//   _súa_, _dit_, _коментар, _ditt_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6461d813,0x5427c017,0x00000000,0x00000000}},	//   _más__de_, _се__повезао_, --, --, 
   {{0xee9d1817,0x546f2007,0xcf33c002,0x23ebe807}},	//   _ако_, _varslet__om_, _presenta, _gitt_, 
   {{0xd2cc181b,0x432cb807,0xa2f4e815,0x00000000}},	//   _at__kunne_, _høy_, _melalui__mudah_, --, 
   {{0x147bc029,0xb29c980d,0x00000000,0x00000000}},	//   _komentar__od_, _túa_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe27f7810,0x2a883818,0x6b9db813,0x50e8381c}},	//   _rwanda_, _लाइफ_, _más__informac, _लाइव_, 
   {{0x83e3300b,0x00000000,0x00000000,0x00000000}},	//   _ke__atas_, --, --, --, 
   {{0x53a6201a,0xd7377806,0xcf01a80c,0x00000000}},	//   _dki__jakarta_, _dalších_, _hodnoten_hviezdič, --, 
  
   {{0x826bb029,0x0c16581c,0x00000000,0x00000000}},	// [400] _sveučili, _व्यापार__करियर_, --, --, 
   {{0x539ab006,0x94420010,0x00000000,0x00000000}},	//   _město_, _iyi_, --, --, 
   {{0xf2965003,0x227e7807,0xd47ba016,0x00000000}},	//   _ini__semoga_, _menn_, _para__sua_, --, 
   {{0xec7b8805,0xeed28817,0x0395080c,0x2460c80d}},	//   _nađi_, _је__био_, _časti_, _tamén__editar_, 
   {{0x6c62300c,0x00000000,0x00000000,0x00000000}},	//   _pozrite_, --, --, --, 
   {{0xda0aa008,0x00000000,0x00000000,0x00000000}},	//   _manakala_, --, --, --, 
   {{0x0b9e881c,0x12e86815,0x1c102017,0x04979017}},	//   _गई__है_, _baginda_, _фејсбуку__како_, _је__било_, 
   {{0xf2d82810,0x5546900c,0x00000000,0x00000000}},	//   _kamere_, _zobraziť_, --, --, 
   {{0xdc49201c,0xc2d9201c,0x00000000,0x00000000}},	//   _बड़े_, _बड़ी_, --, --, 
   {{0x5c5d900e,0xf2ce2809,0x7c69f010,0x00000000}},	//   _के__चलते_, _navođenj_izvora_, _burundi_, --, 
   {{0x5236d015,0x00000000,0x00000000,0x00000000}},	//   _projek_, --, --, --, 
   {{0x046be807,0xd0fe8024,0x630de810,0x00000000}},	//   _hva__som_, _के__अभाव_, _ibibera_, --, 
   {{0xa29cb80c,0x6c5a580b,0x00000000,0x00000000}},	//   _zľava_, _menteri_, --, --, 
   {{0xca32b021,0x00000000,0x00000000,0x00000000}},	//   _कोई_, --, --, --, 
   {{0x53dc1003,0x60458006,0x00000000,0x00000000}},	//   _bahwa_, _vyhrazen, --, --, 
   {{0x84444007,0x63417010,0x00000000,0x00000000}},	//   _eg_, _barenga_, --, --, 
   {{0x03f40029,0x82561813,0x00000000,0x00000000}},	// [410] _sustav_, _sólo_, --, --, 
   {{0x2b5fd817,0x00000000,0x00000000,0x00000000}},	//   _условима_, --, --, --, 
   {{0x92a64810,0x00000000,0x00000000,0x00000000}},	//   _zombi_, --, --, --, 
   {{0x92e66006,0xd4444023,0xe408081a,0x00000000}},	//   _více__zadat_, _zg_, _serupa__untuk_, --, 
   {{0xbc48f03b,0x00000000,0x00000000,0x00000000}},	//   _तुझे_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4472d81b,0x00000000,0x00000000,0x00000000}},	//   _skrevet__af_, --, --, --, 
   {{0xb07bd01e,0x69d2d007,0xeda8a817,0x54431002}},	//   _bezbedno, _nettsted, _оно__што_, _haz_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xccf4900f,0x0f1b700c,0x00000000,0x00000000}},	//   _objavlji_pjesama_, _odporúča, --, --, 
   {{0xa434f017,0xa718b01c,0xb27e7807,0x00000000}},	//   _sati__minuta_, _हो__जाता_, _venn_, --, 
   {{0x23eaf814,0x327f9009,0x92abe013,0x52391815}},	//   _editar_, _bosne_, _de__años_, _urus__janji_, 
   {{0xf22b400c,0x00000000,0x00000000,0x00000000}},	//   _upraviť_, --, --, --, 
   {{0xb3949019,0x00000000,0x00000000,0x00000000}},	//   _duas_, --, --, --, 
   {{0xf3dd901a,0xe28c3010,0x847dd027,0x00000000}},	//   _siswa_, _igihugu_, _skal__ha_, --, 
   {{0x126d0810,0x4fe00806,0x00000000,0x00000000}},	//   _kubona_, _kvůli_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [420] --, --, --, --, 
   {{0x44432013,0x42fdf81b,0x5225f807,0xfb8ff80a}},	//   _hay_, _bruge_, _bruke_, _तऽ_, 
   {{0x1e0d2017,0xb24a500b,0x00000000,0x00000000}},	//   _све_, _resolusi_, --, --, 
   {{0xb3eab813,0xd442c817,0xb47bd816,0xe4b11813}},	//   _lo__más_, _rsd_, _de__desconto_, _puede__ser_, 
   {{0x24444005,0xae43600e,0x34431016,0x225ac822}},	//   _kn_, _बांग्लाद, _faz_, _sellem_, 
   {{0xd2ad5029,0x0b16c009,0xce55a009,0xe4926002}},	//   _objavlje_prije_, _sarajevs, _islamske_, _en__tu_, 
   {{0x0442d810,0x9c51d815,0x00000000,0x00000000}},	//   _ese_, _tentera_, --, --, 
   {{0x54b7080c,0x81e1d81c,0x00000000,0x00000000}},	//   _môžete_, _दूसरे_, --, --, 
   {{0xfdaac80d,0x54a3e015,0x8e57d022,0x00000000}},	//   _rexistra, _bersetuj, _bosanske_, --, 
   {{0x93043815,0xa4456014,0x00000000,0x00000000}},	//   _mengguna_laman_, _editar__as_, --, --, 
   {{0xffe82036,0xa3949028,0x3e756017,0xa4218015}},	//   _स्थानीय_, _suas_, _скочи__на_, _pelawat__about_, 
   {{0xa455e029,0x2e847817,0x00000000,0x00000000}},	//   _poruku__za_, _рекао__је_, --, --, 
   {{0x31fda806,0x52291815,0x00000000,0x00000000}},	//   _vyhledáv, _rujukan__saling_, --, --, 
   {{0xdeb9f007,0xe26d8013,0x00000000,0x00000000}},	//   _gjør_, _otro_, --, --, 
   {{0x64abd814,0xc0895011,0xf443100c,0x00000000}},	//   _darse__de_, _términos__condicio, _raz_, --, 
   {{0x646da813,0x00000000,0x00000000,0x00000000}},	//   _cantidad__de_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [430] --, --, --, --, 
   {{0x5bb76809,0xec49901c,0xdb29f011,0xd2d9901c}},	//   _pridruže, _पहले_, _públicam_opinión_, _पहली_, 
   {{0xa2242007,0x63946815,0xc3e4c027,0x0d2d9006}},	//   _fikk_, _ogos_, _kl__tekst_, _napište_, 
   {{0xb2242007,0x8d3c3806,0x746ae00c,0x00000000}},	//   _gikk_, _velikost_, _ako__si_, --, 
   {{0x41427817,0x03869010,0x00000000,0x00000000}},	//   _је__доступан_, _atari_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9c898005,0x41a77817,0x3291681a,0x00000000}},	//   _broj__postova_, _на__фејсбуку_, _dijual__rumah_, --, 
   {{0x62fb9008,0xf9f43006,0x00000000,0x00000000}},	//   _kanak__kanak_, _její_, --, --, 
   {{0xc4439816,0x00000000,0x00000000,0x00000000}},	//   _às_, --, --, --, 
   {{0xc4bc5007,0xcbe51024,0x00000000,0x00000000}},	//   _bruk__av_, _तक__ही_, --, --, 
   {{0xa25a001b,0x00000000,0x00000000,0x00000000}},	//   _spil_, --, --, --, 
   {{0xe291d810,0x00000000,0x00000000,0x00000000}},	//   _ukwa_, --, --, --, 
   {{0x6d6d3817,0x00000000,0x00000000,0x00000000}},	//   _сте_, --, --, --, 
   {{0x6bee1817,0x72f1301b,0x00000000,0x00000000}},	//   _тако_, _bøger_, --, --, 
   {{0x62e5e005,0x9c8e100a,0xb442d806,0x00000000}},	//   _kronika_, _कवनो_, _lze_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0c49201c,0x24420010,0x22771817,0x1a92101b}},	// [440] _मुझे_, _iki_, _blogu__snimi_, _danmarks__største_, 
   {{0x623e4025,0xf244e038,0xae2e401b,0x2afb880f}},	//   _danmark_, _tým_, _danmarks_, _zbunjen__normalan_, 
   {{0x926c3002,0xd3ead80c,0x00000000,0x00000000}},	//   _dijo_, _azet_, --, --, 
   {{0xfb81f81c,0xd2fc781b,0x4a74e006,0x00000000}},	//   _असहमत_, _gange_, _zprávy_, --, 
   {{0xf4444010,0x2496600f,0x00000000,0x00000000}},	//   _ki_, _pridruže_apr_, --, --, 
   {{0xe4444006,0x00000000,0x00000000,0x00000000}},	//   _ji_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x34444007,0x74b96807,0x00000000,0x00000000}},	//   _oi_, _ikke__noe_, --, --, 
   {{0x24444010,0x9f072016,0x00000000,0x00000000}},	//   _ni_, _os__direitos_, --, --, 
   {{0xb326d806,0x34936013,0x942b1803,0x00000000}},	//   _hodin__více_, _es__lo_, _rumah__baru_, --, 
   {{0xced6780c,0xda74e038,0x00000000,0x00000000}},	//   _veľmi_, _správy_, --, --, 
   {{0x8a11f02e,0x82f1301b,0xce292817,0xd442001a}},	//   _pemberit, _søger_, _кад_, _dki_, 
   {{0xd48ca01b,0xe4135022,0xc31fd81e,0xc187580c}},	//   _af__den_, _bez__odobrenj, _crvene__zvezde_, _topovať_, 
   {{0xa5996034,0xae9ed815,0x73eb801b,0x347b7007}},	//   _सहित_, _terma__pengguna, _marts_, _seg__på_, 
   {{0x94444007,0x6bd5b006,0x00000000,0x00000000}},	//   _ei_, _více__informac, --, --, 
   {{0x1be54024,0x04a32006,0x00000000,0x00000000}},	// [450] _से__कर_, _heureka__cz_, --, --, 
   {{0xb4444027,0x147fb022,0xc3ea8017,0x00000000}},	//   _gi_, _historij, _zahtev_, --, 
   {{0x330d0816,0x00000000,0x00000000,0x00000000}},	//   _recados_, --, --, --, 
   {{0x9e1bb815,0x00000000,0x00000000,0x00000000}},	//   _atau__kerosaka, --, --, --, 
   {{0x3e386817,0xa252c811,0x0f9a0816,0x00000000}},	//   _bonitetn_izveštaj, _se__admite_, _dúvidas_, --, 
   {{0xa35c900b,0x00000000,0x00000000,0x00000000}},	//   _perkara__yang_, --, --, --, 
   {{0x0bd9d01c,0x62d92824,0x00000000,0x00000000}},	//   _गया__था_, _बानी_, --, --, 
   {{0x0d98c822,0xf367e003,0x00000000,0x00000000}},	//   _sallalla, _bergabun_dengan_, --, --, 
   {{0x7354300d,0x00000000,0x00000000,0x00000000}},	//   _galegas_, --, --, --, 
   {{0xebc29818,0xe9d7681b,0x4f648807,0xca1f8011}},	//   _ऐसे_, _vores__tjeneste, _utdannin, _hay__algún_, 
   {{0x0aae500e,0x00000000,0x00000000,0x00000000}},	//   _खोज__में_, --, --, --, 
   {{0xeb421804,0xa26d900d,0x72902015,0xba69c010}},	//   _doporuču, _noso_, _kekal_, _washobor_kubikora_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x537f801a,0xd386d813,0xebca780a,0xf8f4980c}},	//   _jakarta_, _leer_, _जाति__के_, _všetkých_, 
   {{0x5e08e80b,0x00000000,0x00000000,0x00000000}},	//   _hendakla, --, --, --, 
   {{0xbb54381e,0x5aeff015,0x00000000,0x00000000}},	//   _forumu__privatna_, _yang__berkongs, --, --, 
   {{0xeee93029,0xe4420010,0xcdc7300c,0xfa9e6024}},	// [460] _diskutan, _ibi_, _kliknite_, _प्राचीन__काल_, 
   {{0x546d5011,0x0ab1500e,0x4497d010,0x00000000}},	//   _email__no_, _लेख__में_, _za__bbc_, --, 
   {{0xf2c8881e,0x00000000,0x00000000,0x00000000}},	//   _devojke_, --, --, --, 
   {{0x7baa880e,0xf2d90007,0xced59806,0x8fb4e011}},	//   _कि__अब_, _arbeid_, _což_, _respuest_reportar_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44425806,0xee3ce017,0x00000000,0x00000000}},	//   _byl_, _се__да_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbc48900a,0x00000000,0x00000000,0x00000000}},	//   _साथे_, --, --, --, 
   {{0xab56d015,0x00000000,0x00000000,0x00000000}},	//   _sentiasa_, --, --, --, 
   {{0xc26cc816,0xcb9e900e,0xe2497803,0x00000000}},	//   _tudo_, _के__ही_, _nyaman_, --, 
   {{0x16d5e808,0x00000000,0x00000000,0x00000000}},	//   _berbandi, --, --, --, 
   {{0xb2b9881c,0xbb2db017,0x00000000,0x00000000}},	//   _यहां_, _delatnos, --, --, 
   {{0xfb1c2002,0x0ab95024,0xb47e501b,0x00000000}},	//   _respuest, _रुप__में_, _uden__at_, --, 
   {{0x93e4c806,0xc4426810,0xe2d46013,0x94ad1807}},	//   _děti_, _iyo_, _verdad_, _gir__deg_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfb29d80b,0xe2b1800c,0x00000000,0x00000000}},	//   _pengguna_linkedin_, _pridala_, --, --, 
   {{0xe442201b,0xb224900c,0x00000000,0x00000000}},	// [470] _dkk_, _inak_, --, --, 
   {{0xa2bcc00f,0x34677010,0xf479981b,0x00000000}},	//   _na__depo_, _niba__bishobok, _hvad__der_, --, 
   {{0xb48db028,0xc4926007,0x4ec8f00c,0x00000000}},	//   _de__uma_, _av__en_, _zariaden, --, 
   {{0x9394d813,0xf229c01b,0x00000000,0x00000000}},	//   _pues_, _række_, --, --, 
   {{0xea33303f,0x0ab3800e,0x06f8381c,0x937b702e}},	//   _जैन_, _वर्तमान__में_, _लिया_, _padahal_, 
   {{0xe9c2f01e,0x42d8481a,0x447fa003,0x00000000}},	//   _vrednost, _temen_, _satu__ini_, --, 
   {{0x44426810,0x00000000,0x00000000,0x00000000}},	//   _ayo_, --, --, --, 
   {{0xdfc70806,0x8ccf8806,0x00000000,0x00000000}},	//   _článek_, _dvě_, --, --, 
   {{0x8443f810,0x4b893813,0xc3946813,0x00000000}},	//   _uru_, _diciembr, _dios_, --, 
   {{0xec10780e,0xa402080c,0xc2925807,0x00000000}},	//   _विकास__के_, _dovolenk, _antall_, --, 
   {{0xca3dd824,0x00000000,0x00000000,0x00000000}},	//   _सकल_, --, --, --, 
   {{0x23290802,0x6429c80b,0x00000000,0x00000000}},	//   _es__este_, _kumpulan_, --, --, 
   {{0xefeb9031,0x13cf5013,0x5a329821,0x3ef0e817}},	//   _सामाजिक_, _nuevos_, _ऐसा_, _им_, 
   {{0x52bb181b,0x6dce6817,0x00000000,0x00000000}},	//   _seneste_, _више_, --, --, 
   {{0x0b8d5818,0x00000000,0x00000000,0x00000000}},	//   _और_, --, --, --, 
   {{0x327f5010,0x11a4d01f,0xc4616807,0xf26c7810}},	//   _buenos_, _nikolić_, _innlegg__del_, _hino_, 
   {{0xabcdd80e,0xa646c817,0x00000000,0x00000000}},	// [480] _सकी_, _пријави_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcc50b81c,0x526cf814,0x00000000,0x00000000}},	//   _देखें_, _lugo_, --, --, 
   {{0x59f47806,0x00000000,0x00000000,0x00000000}},	//   _není_, --, --, --, 
   {{0x7ed25817,0x1adf6805,0xe3441810,0x48470010}},	//   _да__се_, _osobama__mlađim_, _amashaki_yawe_, _ukoreshe_amashaki, 
   {{0x44b5e00f,0xc8386816,0xaa280811,0x7e8d6017}},	//   _vrh__re_, _comparti_mensagem_, _lugar__está_, _ће__се_, 
   {{0x3e3ce017,0x8c15c824,0xdb8d500a,0x00000000}},	//   _се__на_, _स्क्रिप्, _छी_, --, 
   {{0xff01c817,0x7afd980c,0xd26dc80c,0x0f60d01d}},	//   _како__би_, _prípade_, _prvom_, _displeje_, 
   {{0x13eb8007,0xd2e3e80c,0x00000000,0x00000000}},	//   _kart_, _ktorých_, --, --, 
   {{0x5a3cf80e,0x14926013,0x00000000,0x00000000}},	//   _वंश_, _en__mi_, --, --, 
   {{0x6bcde01c,0x00000000,0x00000000,0x00000000}},	//   _सभी_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe3947820,0x00000000,0x00000000,0x00000000}},	//   _fins_, --, --, --, 
   {{0x9f3b701a,0x00000000,0x00000000,0x00000000}},	//   _mengomen, --, --, --, 
   {{0x124dc01a,0x3fcd9817,0x137eb01c,0x00000000}},	//   _di__topic_, _од__стране_, _मुक्त__ज्ञानकोष_, --, 
   {{0x739ed822,0x5317f806,0x00000000,0x00000000}},	//   _tjedna__mjesec_, _pouze_, --, --, 
   {{0x6225e829,0xe8477024,0xe4c15017,0x00000000}},	// [490] _nitko_, _मातृभाषा_, _skok__na_, --, 
   {{0x5442901a,0x00000000,0x00000000,0x00000000}},	//   _iya_, --, --, --, 
   {{0x02d18816,0xee7bc817,0x00000000,0x00000000}},	//   _como__avalia_, _март__фебруар_, --, --, 
   {{0x7ab3881c,0x82bc200d,0x00000000,0x00000000}},	//   _जाते__हैं_, _crear__unha_, --, --, 
   {{0x72903015,0x00000000,0x00000000,0x00000000}},	//   _semasa_, --, --, --, 
   {{0xe21c9817,0x00000000,0x00000000,0x00000000}},	//   _да__бисте_, --, --, --, 
   {{0x82707829,0x63007805,0xede62017,0x53ea8007}},	//   _prije__sati_, _prije__sata_, _као__што_, _riktig_, 
   {{0xc5802016,0x6a61500d,0x00000000,0x00000000}},	//   _informaç, _algúns_, --, --, 
   {{0x1225b006,0x00000000,0x00000000,0x00000000}},	//   _mobilní__telefony_, --, --, --, 
   {{0x554c2810,0x42cf1807,0xee6a0017,0x6b1fa80b}},	//   _mashyash, _annonse_, _могу__да_, _kejayaan_, 
   {{0xd4429010,0x79bbb81e,0x00000000,0x00000000}},	//   _aya_, _nameštaj_, --, --, 
   {{0x33868823,0xf3e6980c,0xaa601024,0x00000000}},	//   _sakrij_, _túto_, _कुछ__कुछ_, --, 
   {{0xfeb8e817,0x9f53980c,0xf4429010,0x0679e817}},	//   _би_, _mať_, _cya_, _правосла, 
   {{0x9479d015,0x62572006,0x00000000,0x00000000}},	//   _pada__hb_, _dále_, --, --, 
   {{0xb4439015,0x5acdc818,0x00000000,0x00000000}},	//   _bas_, _भाजपा_, --, --, 
   {{0xa394c81b,0x00000000,0x00000000,0x00000000}},	//   _sidst_, --, --, --, 
   {{0x6c06601c,0x00000000,0x00000000,0x00000000}},	// [4a0] _किसी__भी_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4354d013,0x629d500c,0x00000000,0x00000000}},	//   _tenemos_, _zľavy_, --, --, 
   {{0xd4438007,0x2c48681c,0xc46a3816,0x00000000}},	//   _tar_, _लिये_, _das__às_, --, 
   {{0x7340180d,0x7e89d015,0x02cae81b,0xeba5e81c}},	//   _licenza_, _pertanya_pekerjaa, _fundet_, _हो__गई_, 
   {{0x2307a811,0x6b413004,0x00000000,0x00000000}},	//   _duplicad_este_, _pravidla_, --, --, 
   {{0x49786802,0xf3f96828,0x00000000,0x00000000}},	//   _administ, _alguns_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4b908006,0xfbbbf024,0x3fc0b806,0xe4429010}},	//   _prostřed, _क्षेत्र__से_, _stránek_, _rya_, 
   {{0xe3f82006,0x0f2f281b,0xc2cae81b,0xc2cf281b}},	//   _pokud_, _annoncer_, _kender_, _annonce_, 
   {{0x2bcde83d,0x2ab0e024,0x31595006,0x00000000}},	//   _हवे_, _पांडेय_, _doplňky_, --, 
   {{0x32b4900c,0x53f90810,0x00000000,0x00000000}},	//   _viac_, _imbuga_, --, --, 
   {{0xb4444016,0x3b94d80a,0xa74ed817,0x51b8380a}},	//   _br_, _रहल__बा_, _права_, _लागल_, 
   {{0xad7ef817,0x77566804,0x79765816,0x00000000}},	//   _су_, _प्रमाणित_, _atendime, --, 
   {{0x5b8c880a,0x64996022,0x00000000,0x00000000}},	//   _ओह_, _za__bh_, --, --, 
   {{0xd84bf815,0x00000000,0x00000000,0x00000000}},	// [4b0] _bertulis_, --, --, --, 
   {{0xeb9cd80a,0x613d5017,0x00000000,0x00000000}},	//   _भोजपुरी__के_, _април__март_, --, --, 
   {{0xc45f2011,0xd443901a,0x00000000,0x00000000}},	//   _cerrado__la_, _tas_, --, --, 
   {{0x5439c00d,0xe8979015,0x00000000,0x00000000}},	//   _traballo_, _kali__terakhir_, --, --, 
   {{0x1144f011,0x00000000,0x00000000,0x00000000}},	//   _por__inténtel, --, --, --, 
   {{0xd442680c,0xca59000c,0x00000000,0x00000000}},	//   _ako_, _inzercia_, --, --, 
   {{0xe9de3002,0x32fe6807,0xf277e01b,0x79807006}},	//   _contenid, _bergen_, _en__række_, _péče_, 
   {{0xf20ec817,0x00000000,0x00000000,0x00000000}},	//   _данас_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xed019815,0x227e7807,0x7a6e881c,0x144a980d}},	//   _maklumat_, _finne_, _होते__हैं_, _páxina__foi_, 
   {{0x734a881e,0x00000000,0x00000000,0x00000000}},	//   _nedelju_, --, --, --, 
   {{0xebe3681a,0xaa79380e,0x00000000,0x00000000}},	//   _komentar, _काम__करत_, --, --, 
   {{0xc4444038,0x00000000,0x00000000,0x00000000}},	//   _sr_, --, --, --, 
   {{0xebfa6817,0x00000000,0x00000000,0x00000000}},	//   _najviše__komentar, --, --, --, 
   {{0x9a69e024,0x649cc811,0xf30dc00b,0x00000000}},	//   _कुछ__लोग_, _inténtel_de_, _membina_, --, 
   {{0x0c08e01c,0x9212b006,0x00000000,0x00000000}},	//   _सकता__है_, _bych_, --, --, 
   {{0x67f6f80e,0x00000000,0x00000000,0x00000000}},	// [4c0] _के__संदर्भ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe496c00f,0xf4bd501b,0x03b6700d,0x00000000}},	//   _pridruže_okt_, _skriv__et_, _outras__linguas_, --, 
   {{0x2395f80d,0x00000000,0x00000000,0x00000000}},	//   _dous_, --, --, --, 
   {{0x8c612829,0xe06f180f,0x00000000,0x00000000}},	//   _tisuća_, _budžetsk_izdvajan, --, --, 
   {{0xa3ced01f,0xfeb9f007,0x33cf5013,0x4396681a}},	//   _čovek_, _kjøp_, _nuevas_, _persen_, 
   {{0x8434980d,0xf26d8014,0x00000000,0x00000000}},	//   _da__xunta_, _muros_, --, --, 
   {{0x63f47809,0x62ab5802,0x00000000,0x00000000}},	//   _postao_, _de__año_, --, --, 
   {{0xc333080d,0x92d25802,0xd3169006,0x00000000}},	//   _imaxes_, _hace__años_, _praze_, --, 
   {{0x5303f011,0xd5fda824,0x00000000,0x00000000}},	//   _se__mostrará_, _पटकथा_, --, --, 
   {{0x14426810,0xeb69400e,0x438ca028,0x00000000}},	//   _uko_, _के__बयान_, _de__janeiro_, --, 
   {{0x34ab300f,0x2a330821,0x54bae01b,0x95d4281a}},	//   _maj__vrh_, _टीम_, _godt__om_, _membutuh, 
   {{0x33e75807,0xf2c7581b,0xbc10f80e,0x534b2811}},	//   _måte_, _måde_, _जहां__तक_, _hace__meses_, 
   {{0x9a3de835,0xc26d8016,0xebefd00e,0x0358a01b}},	//   _हवा_, _juros_, _सिनेमा__के_, _brugere_, 
   {{0x7602380e,0x8c2b301c,0x00000000,0x00000000}},	//   _में__भारत_, _जा__रही_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [4d0] --, --, --, --, 
   {{0x361ee00d,0xeb93900a,0xd257601b,0x427f5002}},	//   _foundati, _बात__के_, _vælg_, _buenas_, 
   {{0xf33b380a,0xf2be580c,0x9b9bc01c,0x00000000}},	//   _भोजपुरी_, _predám_, _बताया__कि_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa998d80c,0x339c382e,0x00000000,0x00000000}},	//   _tiež_, _pada__tanggal_, --, --, 
   {{0x94426810,0x8290c807,0xf4bd5007,0xda76781c}},	//   _abo_, _medan_, _skriv__ut_, _हॉट__एंड_, 
   {{0x7bc33040,0x729dc815,0xcb18201a,0xac48981c}},	//   _घरी_, _pelbagai_, _sebagian_, _देने_, 
   {{0x93e3f006,0xbd6a081b,0x722a081b,0x6fd88816}},	//   _zadat__rozpětí_, _tilmeldt_, _tilmeld_, _comentár_até_, 
   {{0x0487600e,0x00000000,0x00000000,0x00000000}},	//   _अंदाजा_, --, --, --, 
   {{0x638bd025,0x64429010,0x02374822,0xe280b006}},	//   _været_, _aka_, _alejhi_, _diskuse_, 
   {{0x52bb6816,0x00000000,0x00000000,0x00000000}},	//   _somente_, --, --, --, 
   {{0xc2017819,0x238ca00d,0x930fe00b,0x00000000}},	//   _abaixo_, _de__xaneiro_, _melihat__profil_, --, 
   {{0x17e25017,0x00000000,0x00000000,0x00000000}},	//   _blogu__reputaci, --, --, --, 
   {{0xb442d807,0x82d86841,0xa711f01c,0x64651014}},	//   _mye_, _लागी_, _कर__दिया_, _menú__de_, 
   {{0x14427822,0x142c6024,0xb8475802,0x00000000}},	//   _ibn_, _साइबर_, _duplicad, --, 
   {{0x6d8c7029,0x5e297017,0xe47a6027,0x00000000}},	//   _točno_, _нас_, _tekst__er_, --, 
   {{0x54439010,0x00000000,0x00000000,0x00000000}},	// [4e0] _css_, --, --, --, 
   {{0x8dfe901e,0xb3007015,0x00000000,0x00000000}},	//   _neverova, _senarai_, --, --, 
   {{0x0ce1b016,0x48d1b016,0x00000000,0x00000000}},	//   _estrelas__estrela_, _estrelas__estrelas_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x527c8816,0xa386d813,0x00000000,0x00000000}},	//   _são__paulo_, _enero_, --, --, 
   {{0x24aa2012,0x00000000,0x00000000,0x00000000}},	//   _der__kan_, --, --, --, 
   {{0xa78b600d,0x6a4c080e,0x00000000,0x00000000}},	//   _fins__política_, _के__रुप_, --, --, 
   {{0x9db14002,0x00000000,0x00000000,0x00000000}},	//   _lenguaje_, --, --, --, 
   {{0x96fe2818,0xf29f7015,0x00000000,0x00000000}},	//   _क्या_, _kerjaya_, --, --, 
   {{0x9290901a,0x7e74b815,0xe26c781d,0x3a3d301c}},	//   _bekasi_, _peluang__pekerjaa, _brno_, _हूँ_, 
   {{0x42e04808,0x00000000,0x00000000,0x00000000}},	//   _abdullah_, --, --, --, 
   {{0xac4a4018,0xf3ebe807,0xebc3900a,0x00000000}},	//   _नहीं_, _hatt_, _भोज__के_, --, 
   {{0x5443e815,0x97f2700c,0x3757201c,0x52824018}},	//   _kat_, _možnosť_, _जा__सकता_, _धर्म__दर्शन_, 
   {{0x84232817,0x652c1802,0x4867581b,0x99675807}},	//   _najnovij_vesti_, _términos_, _mulighed, _mulighet, 
   {{0x7443e827,0x7f029807,0x00000000,0x00000000}},	//   _mat_, _regjerin, --, --, 
   {{0x9410e01f,0x00000000,0x00000000,0x00000000}},	//   _još__poruka_, --, --, --, 
   {{0x32485804,0xa442900c,0x629f7015,0x00000000}},	// [4f0] _velmi_, _iba_, _berjaya_, --, 
   {{0xd2249010,0x48cf8016,0x0442d810,0x00000000}},	//   _irak_, _produto__estrelas_, _rye_, --, 
   {{0xebb8780e,0x5312f820,0x8212d016,0xec037824}},	//   _पाकिस्ता_के_, _para__obter_, _melhor_, _घटना__के_, 
   {{0x12cbf813,0xf224901b,0xb11b4807,0x00000000}},	//   _ayuda_, _krak_, _nasjonal, --, 
   {{0x82cea803,0x422ab006,0x00000000,0x00000000}},	//   _yang__bisa_, _někdo_, --, --, 
   {{0x128c0817,0x00000000,0x00000000,0x00000000}},	//   _profil__slanje_, --, --, --, 
   {{0xdde0c815,0xd3ea901a,0x0bc1401c,0x4a3d301c}},	//   _ahli__mengikut_, _obat_, _सकती__है_, _हूं_, 
   {{0x1a5c6815,0x00000000,0x00000000,0x00000000}},	//   _di__malaysia_, --, --, --, 
   {{0x1919b00e,0x00000000,0x00000000,0x00000000}},	//   _सिंहासन_, --, --, --, 
   {{0x24429010,0x00000000,0x00000000,0x00000000}},	//   _aba_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa394b01b,0x00000000,0x00000000,0x00000000}},	//   _bedste_, --, --, --, 
   {{0x7443f803,0xe494e007,0x00000000,0x00000000}},	//   _mau_, _nå__er_, --, --, 
   {{0x536d180f,0x00000000,0x00000000,0x00000000}},	//   _opštinam_pregled_, --, --, --, 
   {{0xde7cb016,0x830ab01a,0x0ab65024,0x75ad4024}},	//   _mensagen_verdinha, _langsung__bisa_, _जगत__में_, _भी__भारत_, 
   {{0x8959483f,0x5406e815,0x00000000,0x00000000}},	//   _वैयक्तिक_, _kepakara_urus_, --, --, 
   {{0x73ced802,0x27c6581c,0x1ca19816,0x2a60d017}},	// [500] _nuevo_, _उन्हें_, _em__contato_, _неће__бити_, 
   {{0x126c9815,0x32beb80c,0x00000000,0x00000000}},	//   _aktiviti_, _všetko_, --, --, 
   {{0xe201f819,0x6c51181c,0xd2cf900c,0x00000000}},	//   _aqui_, _भेजें_, _kancelár, --, 
   {{0xc9696041,0x3200a006,0x927ed813,0xa3ebe807}},	//   _साँझ_, _jejich_, _bueno_, _satt_, 
   {{0x5c26c007,0x00000000,0x00000000,0x00000000}},	//   _bli__varslet_, --, --, --, 
   {{0xc7d0a007,0x4ed26017,0x00000000,0x00000000}},	//   _tilgjeng, _да__не_, --, --, 
   {{0x952d9817,0x4c49401c,0x00000000,0x00000000}},	//   _између_, _हमें_, --, --, 
   {{0x2f326017,0x00000000,0x00000000,0x00000000}},	//   _делити__под_, --, --, --, 
   {{0xb3ebe807,0x00000000,0x00000000,0x00000000}},	//   _tatt_, --, --, --, 
   {{0x7ed2e017,0xb926480c,0x00000000,0x00000000}},	//   _би__се_, _odpoveď_, --, --, 
   {{0xc491e002,0x73300011,0x9295e81b,0x00000000}},	//   _el__la_, _contenid_erróneo_, _at__komme_, --, 
   {{0x47692024,0x52493806,0x5b8fe00e,0xd144180e}},	//   _के__निर्माण_, _přihláše, _तप_, _जासूसी_, 
   {{0x3da7880c,0xc2e2701e,0xdc17b016,0x444ad020}},	//   _keď_, _od__prva_, _tópico_, _artigo__da_, 
   {{0x6a9b301c,0x00000000,0x00000000,0x00000000}},	//   _जा__रहा_, --, --, --, 
   {{0x635a100d,0x946d2816,0x8493601b,0x00000000}},	//   _pódense__aplicar_, _não__há_, _er__nu_, --, 
   {{0x758a080c,0x39b51017,0x64429010,0xa2d4700d}},	//   _registrá, _uveče__uveče_, _uba_, _axudas_, 
   {{0x84b36022,0x79cd2810,0x0a396024,0x00000000}},	// [510] _kur__an_, _bishobok_shakisha_, _सांप_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3ed5801b,0x4a5b301c,0x00000000,0x00000000}},	//   _udviklin, _का__नाम_, --, --, 
   {{0x73a87811,0x00000000,0x00000000,0x00000000}},	//   _si__quieres_, --, --, --, 
   {{0x8682f82d,0x2b88f00a,0xcc8a8817,0x00000000}},	//   _kategori, _पऽ_, _уреди__везе_, --, 
   {{0x7a3e3824,0x00000000,0x00000000,0x00000000}},	//   _नकद_, --, --, --, 
   {{0x6b5a6817,0x8e2d1817,0x526d1013,0x00000000}},	//   _прокомен, _број_, _hizo_, --, 
   {{0x926cf814,0x00000000,0x00000000,0x00000000}},	//   _vigo_, --, --, --, 
   {{0x12fa8820,0x0a79b00e,0xc2bb4810,0x00000000}},	//   _con__esta_, _नेपाल__में_, _css__niba_, --, 
   {{0xee2ec815,0x72b46806,0x1029e01c,0x7e188017}},	//   _tanpa__kebenara, _líbí_, _एंड__स्पाइसी_, _posetila, 
   {{0x02ecf816,0x29c5f817,0x00000000,0x00000000}},	//   _este__produto_, _нема__коментар, --, --, 
   {{0xd6dcf80a,0x00000000,0x00000000,0x00000000}},	//   _बाकिर_, --, --, --, 
   {{0xc2dc5816,0x00000000,0x00000000,0x00000000}},	//   _produto__como_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x527f5002,0x5a5e280d,0x00000000,0x00000000}},	//   _tienes_, _traído_, --, --, 
   {{0xe7d0c82e,0x32fdf81b,0x4225f807,0xb229501f}},	// [520] _lingkung, _brugt_, _brukt_, _dve__godine_, 
   {{0x7245c01d,0x23e7200c,0x00000000,0x00000000}},	//   _tím_, _táto_, --, --, 
   {{0x32562017,0xf35bf013,0x00000000,0x00000000}},	//   _становни, _ninguna_, --, --, 
   {{0x9366002d,0x00000000,0x00000000,0x00000000}},	//   _offentli_profil_, --, --, --, 
   {{0x5e643811,0xb48d6816,0x00000000,0x00000000}},	//   _públicam, _de__sem_, --, --, 
   {{0x3cc7601c,0x00000000,0x00000000,0x00000000}},	//   _संपादित__करें_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb26c2006,0x7f1ff00c,0x527f1015,0x2408981a}},	//   _jako_, _oblečeni, _mudah__alih_, _bisa__langsung_, 
   {{0xbac5a009,0xb85ca811,0x61332806,0xcda78806}},	//   _iz__sarajeva_, _está__duplicad, _kvalitní_, _teď_, 
   {{0x2a8bb007,0x34d5681c,0x00000000,0x00000000}},	//   _trenings, _वीडियो_, --, --, 
   {{0x73e7a028,0x00000000,0x00000000,0x00000000}},	//   _no__brasil_, --, --, --, 
   {{0x51dfc024,0x00000000,0x00000000,0x00000000}},	//   _आयकर_, --, --, --, 
   {{0xbb03b802,0x00000000,0x00000000,0x00000000}},	//   _herramie, --, --, --, 
   {{0x56d2303e,0x00000000,0x00000000,0x00000000}},	//   _दैनिक_, --, --, --, 
   {{0x0fbad006,0xba6c0806,0x00000000,0x00000000}},	//   _zařízení_, _přímo_, --, --, 
   {{0x5200781a,0xbbfb9813,0x958e981a,0x22d88007}},	//   _menit_, _septiemb, _quote__original_, _sakene_, 
   {{0x93cca008,0xfc31480c,0x00000000,0x00000000}},	// [530] _ini__tanpa_, _detské_, --, --, 
   {{0xf292600c,0x00000000,0x00000000,0x00000000}},	//   _strane_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x33f46023,0x346ae00c,0x48027810,0x4e778017}},	//   _tvrtke_, _ako__sa_, _shakisha__amashaki, _један__од_, 
   {{0x826c180e,0x43232820,0x1a213007,0x73946810}},	//   _रक्षा_, _século_, _les__også_, _byose_, 
   {{0x49f65816,0xd47f680d,0x4c5c201b,0x00000000}},	//   _estão_, _polo__que_, _sætter_, --, 
   {{0x7c39a006,0x523b6807,0xa2fdd815,0x00000000}},	//   _सम्पादन_, _tillegg_, _orang__ramai_, --, 
   {{0xd8bb6815,0xfebf0007,0xc442d807,0x00000000}},	//   _kebenara_bertulis_, _spesielt_, _uke_, --, 
   {{0xaa336842,0xd27e0010,0x52fd7816,0xd250c817}},	//   _करत_, _print_, _imagem_, _један_, 
   {{0xc443f808,0xcc52e00e,0x00000000,0x00000000}},	//   _isu_, _अवशेष_, --, --, 
   {{0xa2ebc00d,0xbbc8e81c,0x00000000,0x00000000}},	//   _na__súa_, _चंडीगढ़_, --, --, 
   {{0x2bebe829,0x00000000,0x00000000,0x00000000}},	//   _komentir, --, --, --, 
   {{0xf67f681a,0x00000000,0x00000000,0x00000000}},	//   _peneliti, --, --, --, 
   {{0x1c53f816,0x38dc3817,0x00000000,0x00000000}},	//   _contato_, _људи_, --, --, 
   {{0x8bdd381c,0x00000000,0x00000000,0x00000000}},	//   _आज__का_, --, --, --, 
   {{0x9b97780e,0x9fe13017,0x00000000,0x00000000}},	//   _के__मन_, _своје_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [540] --, --, --, --, 
   {{0x56152806,0x00000000,0x00000000,0x00000000}},	//   _příspěve, --, --, --, 
   {{0xc9f8f029,0x43728804,0x42242007,0x62f2000c}},	//   _milijuna_, _katalog_, _takk_, _nasleduj, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb4444010,0xde0ea816,0x2686880e,0xf2015810}},	//   _ka_, _verdinha, _खुदाई_, _mugihe_, 
   {{0xf3f47022,0x740b5808,0x00000000,0x00000000}},	//   _postove__stare_, _kuala__lumpur_, --, --, 
   {{0x4201001f,0xd96bb806,0xd394d813,0x00000000}},	//   _srbije_, _uživatel, _eres_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebe3200e,0xf3457010,0x00000000,0x00000000}},	//   _तक__के_, _share__tweet_, --, --, 
   {{0x154d880c,0x8d492817,0x00000000,0x00000000}},	//   _prevádzk, _три_, --, --, 
   {{0x93ced813,0x00000000,0x00000000,0x00000000}},	//   _nueva_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x24444010,0xa6f91018,0xc4ae601f,0x00000000}},	//   _ba_, _दिया_, _kod__je_, --, 
   {{0x34444010,0xb492201a,0x2332900d,0x00000000}},	//   _ca_, _me__dan_, _imaxe_, --, 
   {{0x22ab101a,0xc2d84816,0x00000000,0x00000000}},	//   _bandung_, _homem_, --, --, 
   {{0x82131810,0x242a281a,0xaf33602e,0x00000000}},	//   _michel_, _rumah__dijual_, _konsulta, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [550] --, --, --, --, 
   {{0xbcb54022,0x00000000,0x00000000,0x00000000}},	//   _prikaži__postove_, --, --, --, 
   {{0xe442100c,0x7264001d,0x4ef80819,0x00000000}},	//   _ich_, _poslat_, _os__produtos_, --, 
   {{0xc46e600c,0x9be3380e,0xc2370016,0x00000000}},	//   _nie__je_, _तक__कि_, _opcional__digite_, --, 
   {{0x94444010,0x282ba00d,0xf27ec81b,0x48438814}},	//   _ya_, _recoñece_comparti, _endnu_, _contidos_, 
   {{0x8444400d,0xc201101f,0xe4800011,0xb27ed813}},	//   _xa_, _srbiju_, _proporci_tu_, _buena_, 
   {{0xfbeb280e,0x13f31816,0x00000000,0x00000000}},	//   _तब__से_, _lista__negra_, --, --, 
   {{0x226fc010,0x00000000,0x00000000,0x00000000}},	//   _imbuga__zayo_, --, --, --, 
   {{0xc4439814,0xa473400f,0x368c8021,0x00000000}},	//   _ás_, _izdvajan_za_, _पंजाब_, --, 
   {{0xcbb4700c,0x00000000,0x00000000,0x00000000}},	//   _reagovať_, --, --, --, 
   {{0x33050810,0x00000000,0x00000000,0x00000000}},	//   _izindi__mbuga_, --, --, --, 
   {{0x3444400c,0x00000000,0x00000000,0x00000000}},	//   _sa_, --, --, --, 
   {{0xd26c5803,0x4e28e817,0x00000000,0x00000000}},	//   _kalo_, _па_, --, --, 
   {{0x6eba1817,0x00000000,0x00000000,0x00000000}},	//   _после_, --, --, --, 
   {{0xf26c580c,0x64444013,0x346d581e,0x00000000}},	//   _malo_, _va_, _novom__sadu_, --, 
   {{0x74444010,0x4290a01b,0x22303016,0x00000000}},	//   _wa_, _debat_, _seu__email_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [560] --, --, --, --, 
   {{0x8309301a,0x02018812,0xf2d85806,0x22e2081b}},	//   _kamu__bisa_, _årig_, _kolem_, _igennem_, 
   {{0x84684815,0x00000000,0x00000000,0x00000000}},	//   _kehilang_atau_, --, --, --, 
   {{0x0a49d00e,0x00000000,0x00000000,0x00000000}},	//   _दिल__में_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44718010,0x23f86806,0x00000000,0x00000000}},	//   _buboneka__bbc_, _svou_, --, --, 
   {{0x9bef380a,0xec78280d,0x725ad807,0x00000000}},	//   _बा__कि_, _persoal_, _kveld_, --, 
   {{0x0a6a280e,0x12c3c81e,0x6290101a,0x6baa281c}},	//   _क्षेत्र__में_, _milijard_evra_, _sehat_, _यह__भी_, 
   {{0xb2a6a007,0x00000000,0x00000000,0x00000000}},	//   _jobb_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64444022,0xb2dd200b,0x52d80007,0x00000000}},	//   _bh_, _al__quran_, _seier_, --, 
   {{0xf3ae9811,0x00000000,0x00000000,0x00000000}},	//   _pero__delante_, --, --, --, 
   {{0x33eb581b,0x12d99824,0x00000000,0x00000000}},	//   _rigtig_, _पाती_, --, --, 
   {{0xf200c810,0x16f9602b,0x374df80f,0x5f3fa01a}},	//   _polisi_, _साझा_, _bih__istraživ, _tangeran, 
   {{0x1b65a005,0x431df811,0xaef3c00e,0x00000000}},	// [570] _coolinar, _no__puedes_, _इलाका_, --, 
   {{0x14703017,0xc395400c,0x00000000,0x00000000}},	//   _veoma__lak_, _miesto_, --, --, 
   {{0x3a453017,0x00000000,0x00000000,0x00000000}},	//   _izveštaj_, --, --, --, 
   {{0x0866e809,0xc44cc806,0x7254c806,0xc28c6016}},	//   _bosni__hercegov, _mě_, _měl_, _mas__não_, 
   {{0x34ab300f,0xb225400c,0xb4ad601b,0x00000000}},	//   _apr__vrh_, _niekto_, _ind__at_, --, 
   {{0x0a6ef024,0x00000000,0x00000000,0x00000000}},	//   _युद्ध__में_, --, --, --, 
   {{0x7a75081c,0xe47b5811,0x848cf810,0x5eefc80e}},	//   _रहे__हैं_, _mapa__es_, _kugira__ngo_, _आतंक_, 
   {{0x6b8e5021,0x8e32781a,0xee3d8806,0x839b080a}},	//   _इन_, _kualitas_, _přejít_, _से__संबंध_, 
   {{0x228b280c,0x00000000,0x00000000,0x00000000}},	//   _poslať_, --, --, --, 
   {{0xfe731817,0x00000000,0x00000000,0x00000000}},	//   _део_, --, --, --, 
   {{0x0a648809,0x00115038,0x00000000,0x00000000}},	//   _ov__stranica_, _produkto, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x02b5800c,0x00000000,0x00000000,0x00000000}},	//   _marca_, --, --, --, 
   {{0xa1e6081c,0xee325817,0xeb94900e,0x9316900d}},	//   _गैलरी_, _може__да_, _रात__के_, _praza_, 
   {{0x3a11e028,0x00000000,0x00000000,0x00000000}},	//   _garantia_, --, --, --, 
   {{0xcc31b81c,0x00000000,0x00000000,0x00000000}},	//   _ने__बताया_, --, --, --, 
   {{0x237ea009,0x00000000,0x00000000,0x00000000}},	// [580] _bir__izaberi_, --, --, --, 
   {{0x6b97a824,0x00000000,0x00000000,0x00000000}},	//   _के__भी_, --, --, --, 
   {{0xd20e2017,0xeba6c81c,0x026c7813,0x00000000}},	//   _дана_, _है__इस_, _mano_, --, 
   {{0x544dd01e,0x00000000,0x00000000,0x00000000}},	//   _za__decu_, --, --, --, 
   {{0xc4936013,0x6bd77010,0x00000000,0x00000000}},	//   _es__un_, _niba__washobor, --, --, 
   {{0xd379980c,0xa32f3015,0x00000000,0x00000000}},	//   _pridať_, _dikenali__sebagai_, --, --, 
   {{0x32e97815,0x4e297817,0x00000000,0x00000000}},	//   _sesiapa_, _тај_, --, --, 
   {{0x7ec05817,0x00000000,0x00000000,0x00000000}},	//   _су__се_, --, --, --, 
   {{0x027f4013,0x310ff807,0x00000000,0x00000000}},	//   _cuenta_, _denne__artikkel, --, --, 
   {{0xde72e82e,0x9bd9b01c,0x426de81d,0xe27f3002}},	//   _एकत्र_, _कहा__कि_, _tuto_, _el__primero_, 
   {{0x2d5a2817,0xa3959017,0xb3ea901a,0x00000000}},	//   _може_, _komentar__beograd_, _dokter_, --, 
   {{0x52024816,0xcbddd81c,0x4670181c,0x00000000}},	//   _ótimo_, _बताया_, _दर्शन__ज्योतिष_, --, 
   {{0x12d85808,0xbcf4300c,0x8af52006,0x44424815}},	//   _boleh_, _septembr, _napříkla, _mcm_, 
   {{0x0bc6e01c,0xd290201a,0x00000000,0x00000000}},	//   _करता__है_, _lokal_, --, --, 
   {{0x2474480f,0x9d59200e,0x00000000,0x00000000}},	//   _dana__maj_, _राजभाषा_, --, --, 
   {{0x23ead80c,0x00000000,0x00000000,0x00000000}},	//   _svete_, --, --, --, 
   {{0xeb8e681c,0xdc8d1022,0xb26d8010,0xec03600b}},	// [590] _इस_, _svi__postovi_, _biro_, _kampung_, 
   {{0x63e79006,0xcaf6f817,0x00000000,0x00000000}},	//   _této_, _mop__paročist, --, --, 
   {{0x4a9fc01c,0x00000000,0x00000000,0x00000000}},	//   _सिनेमा__हॉट_, --, --, --, 
   {{0x12cbf80d,0x00000000,0x00000000,0x00000000}},	//   _axuda_, --, --, --, 
   {{0x84445022,0x93eaa01a,0x00000000,0x00000000}},	//   _alejhi__ve_, _gambar__buat_, --, --, 
   {{0x8d42d017,0x62903002,0xfa3c3806,0xe3eab81b}},	//   _информац, _dejar_, _září_, _indtil_, 
   {{0xc2498015,0xb32c9023,0xb47e5011,0xca4b681c}},	//   _terma_, _se__putem_, _autoprom_el_, _की__बात_, 
   {{0x9c18700d,0x00000000,0x00000000,0x00000000}},	//   _despois_, --, --, --, 
   {{0x02d84815,0xc27ed807,0x1c773007,0x12843002}},	//   _komen_, _uten_, _kanskje_, _archivo_, 
   {{0x83a92815,0x00000000,0x00000000,0x00000000}},	//   _sebarang_, --, --, --, 
   {{0x99f4b016,0x526cc828,0x00000000,0x00000000}},	//   _você_, _dados_, --, --, 
   {{0x0ed59806,0xc3c1d80f,0x1293481a,0x2f2b2806}},	//   _již_, _po__kantonim, _berapa__saja_, _více__než_, 
   {{0xfb8e781c,0x00000000,0x00000000,0x00000000}},	//   _उस_, --, --, --, 
   {{0x62fc781a,0x137b0028,0x00000000,0x00000000}},	//   _uang_, _citando_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x327ed807,0x00000000,0x00000000,0x00000000}},	//   _noen_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [5a0] --, --, --, --, 
   {{0xa26c5807,0x398b401e,0x92d0e816,0x74746026}},	//   _oslo_, _uveče_, _um__comentár, _som__si_, 
   {{0xfc06a81c,0x54d4f015,0x8767700e,0xfafa5808}},	//   _सहमत__असहमत_, _anda__bersetuj, _में__अपना_, _pengurus, 
   {{0xb27ed813,0xaf53980c,0x00000000,0x00000000}},	//   _tiene_, _byť_, --, --, 
   {{0x0fea4029,0x00000000,0x00000000,0x00000000}},	//   _dubrovač, --, --, --, 
   {{0x0b302017,0x00000000,0x00000000,0x00000000}},	//   _него_, --, --, --, 
   {{0xb9d52830,0xa47a1009,0x92d79807,0xf435c01e}},	//   _सहायता_, _reprezen_bih_, _gjelder_, _veličinu__slova_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9a235016,0x92cae81b,0x00000000,0x00000000}},	//   _que__você_, _hendes_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x12e1300c,0xebf5b024,0x00000000,0x00000000}},	//   _nahlásiť__chybu_, _प्रणाली__के_, --, --, 
   {{0xc2dd0015,0x00000000,0x00000000,0x00000000}},	//   _hb__julai_, --, --, --, 
   {{0x14426810,0x14bb280f,0x00000000,0x00000000}},	//   _ico_, _siteu__bez_, --, --, 
   {{0xb26ca010,0xee351013,0x00000000,0x00000000}},	//   _nabo_, _millones_, --, --, 
   {{0x04444004,0xeb09400d,0xee67e815,0x00000000}},	//   _cz_, _composte, _tawaran__rundinga, --, 
   {{0x84b4d01a,0x00000000,0x00000000,0x00000000}},	//   _topic__di_, --, --, --, 
   {{0xf26ca010,0x00000000,0x00000000,0x00000000}},	// [5b0] _babo_, --, --, --, 
   {{0x52d8c81f,0x00000000,0x00000000,0x00000000}},	//   _ovde_, --, --, --, 
   {{0xb2ad7813,0x00000000,0x00000000,0x00000000}},	//   _que__tiene_, --, --, --, 
   {{0x8343280e,0x3a33d043,0x746d5011,0xc5f73816}},	//   _संबंध_, _जना_, _email__si_, _mais__informaç, 
   {{0x03f9a015,0xd1c9e811,0x00000000,0x00000000}},	//   _jepun_, _sobre__mercadol, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xba3cc82e,0xb32d0015,0x42903016,0x00000000}},	//   _शोध_, _komen__kongsi_, _lojas_, --, 
   {{0x3ee31817,0x726ca010,0x00000000,0x00000000}},	//   _они_, _zabo_, --, --, 
   {{0x26ff3044,0x626ca010,0xf236d00c,0x00000000}},	//   _अथवा_, _yabo_, _svojho_, --, 
   {{0x3e0d1817,0x5e9d1817,0x048e081b,0x6468e00c}},	//   _ово_, _око_, _af__det_, _ale__aj_, 
   {{0xf2bb881e,0x00000000,0x00000000,0x00000000}},	//   _nedelje_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa0921814,0x0c6a1017,0x03788008,0x00000000}},	//   _de__ferramen, _представ, _kenalan_, --, 
   {{0x43738809,0x2291902e,0xc297881e,0xf451e017}},	//   _redanje_, _pesan_, _na__veoma_, _kuću__din_, 
   {{0xd4ace013,0x00000000,0x00000000,0x00000000}},	//   _con__su_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1aabe806,0xd681601c,0xfee32017,0x00000000}},	// [5c0] _základní_, _खिलाफ_, _она_, --, 
   {{0x83ee2007,0x031d7808,0x2e85a811,0xa92f380e}},	//   _det__blir_, _percuma_, _si__hablaras_, _के__इलाज_, 
   {{0x2e737045,0x42903002,0x336b781b,0x00000000}},	//   _मार्च_, _deja_, _til__salg_, --, 
   {{0x7eb8f817,0x426ca010,0x00000000,0x00000000}},	//   _када__се_, _wabo_, --, --, 
   {{0x4f185817,0xa373e015,0x00000000,0x00000000}},	//   _да__ли_, _maklumat__yang_, --, --, 
   {{0xa290b01a,0xc4635007,0x9414e806,0x00000000}},	//   _terkait_, _innlegg__av_, _pro__děti_, --, 
   {{0xe2318802,0x1290c815,0x0bd4180d,0xc394a006}},	//   _primero_, _kedai_, _páxina__elemento_, _nejsou_, 
   {{0xa2f1001e,0xe4b46002,0x687e180c,0x00000000}},	//   _životne__sredine_, _por__tu_, _prehliad, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92a6d80c,0x00000000,0x00000000,0x00000000}},	//   _treba_, --, --, --, 
   {{0xbc37b01d,0x7e711021,0xd290c00c,0x54dfa81c}},	//   _české_, _अगस्त_, _sklade_, _व्यंजन__नायिका_, 
   {{0xa200d029,0x00000000,0x00000000,0x00000000}},	//   _splitu_, --, --, --, 
   {{0x12ffd807,0x00000000,0x00000000,0x00000000}},	//   _denne__siden_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6c49281c,0xebbbd80e,0xbd7ef817,0x00000000}},	//   _मेरे_, _आदमी__के_, _ту_, --, 
   {{0x32903016,0xc599401c,0x00000000,0x00000000}},	//   _seja_, _सेहत_, --, --, 
   {{0xc0a26009,0xa3efc01b,0x00000000,0x00000000}},	// [5d0] _vrh__prethodn, _spørgsmå_svar_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62903016,0xa2cbf816,0x00000000,0x00000000}},	//   _veja_, _ajuda_, --, --, 
   {{0xc7666024,0x00000000,0x00000000,0x00000000}},	//   _में__गंगा_, --, --, --, 
   {{0x0af52007,0xd2e23817,0x00000000,0x00000000}},	//   _internas, _večernje__novosti_, --, --, 
   {{0x127b480c,0xa37fc810,0x00000000,0x00000000}},	//   _komentár, _somalia_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe9d73023,0xc3e75807,0x00000000,0x00000000}},	//   _listopad, _gått_, --, --, 
   {{0x949fa016,0x00000000,0x00000000,0x00000000}},	//   _cartão__ou_, --, --, --, 
   {{0x5b1fd81a,0x32a5800d,0x00000000,0x00000000}},	//   _silahkan_, _de__xullo_, --, --, 
   {{0x4d0ad017,0x7394900b,0x00000000,0x00000000}},	//   _učlanjen_, _asas_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x927b4816,0x33a12013,0xe470b810,0x00000000}},	//   _comentár, _méxico_, _adakoran_na_, --, 
   {{0x92c9d816,0x00000000,0x00000000,0x00000000}},	//   _nenhum__comentár, --, --, --, 
   {{0x3256980c,0x00000000,0x00000000,0x00000000}},	// [5e0] _júl_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5c00a007,0x00000000,0x00000000,0x00000000}},	//   _varslet_, --, --, --, 
   {{0x72d8781a,0x1280b806,0x00000000,0x00000000}},	//   _bener_, _diskuze_, --, --, 
   {{0x932bb010,0x00000000,0x00000000,0x00000000}},	//   _mu__gihe_, --, --, --, 
   {{0x93f8581f,0xa3010015,0x00000000,0x00000000}},	//   _celu_, _telah__berada_, --, --, 
   {{0x15409817,0x64040824,0xa3f8581e,0x2f376017}},	//   _original__postavio_, _अकादमी_, _delu_, _од__до_, 
   {{0xba9bb00e,0x92d87813,0xd44a1003,0x00000000}},	//   _में__काम_, _tener_, _karena__itu_, --, 
   {{0xf473a82d,0x4c807817,0x29fae817,0x00000000}},	//   _som__var_, _неће_, _промени__коментар, --, 
   {{0x83f82817,0x7ba8181c,0x02d8c816,0x00000000}},	//   _ostale__vesti_, _है__तो_, _podem_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x14ab2812,0x03f46015,0x52d9901e,0xc249901e}},	//   _der__har_, _pautan_, _mesec_, _pesme_, 
   {{0xd4f4b016,0x00000000,0x00000000,0x00000000}},	//   _acompanh, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2905815,0xec612814,0x20946806,0x8291d80b}},	//   _solat_, _coruña_, _nabízí_, _dewan_, 
   {{0x2f6fc016,0x8641e015,0x00000000,0x00000000}},	// [5f0] _palavras_, _perkahwi, --, --, 
   {{0x4d493017,0x00000000,0x00000000,0x00000000}},	//   _пре_, --, --, --, 
   {{0x4443e81b,0x13ebe807,0x00000000,0x00000000}},	//   _nyt_, _nytt_, --, --, 
   {{0xb46c6016,0xf1ba6841,0xccc77816,0x00000000}},	//   _com__br_, _पावल_, _ruim__título_, --, 
   {{0x12905816,0xb31d7813,0x63ea9008,0x525ad807}},	//   _pela_, _se__puede_, _doktor_, _vanlig_, 
   {{0xb6d7e017,0xb667e017,0x97e7e017,0x2d91e802}},	//   _србије_, _србији_, _србија_, _cantidad_, 
   {{0x144e980c,0x00000000,0x00000000,0x00000000}},	//   _sú_, --, --, --, 
   {{0xf33af80d,0x34429009,0xf2006027,0x1bab2018}},	//   _de__galicia_, _nja_, _mulig_, _का__एक_, 
   {{0xc224c80c,0x00000000,0x00000000,0x00000000}},	//   _celkom_, --, --, --, 
   {{0x6442901a,0xa2d58806,0x00000000,0x00000000}},	//   _aja_, _všech_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8f06b80c,0x244e9813,0x00000000,0x00000000}},	//   _súvisiac, _tú_, --, --, 
   {{0x1386c802,0x00000000,0x00000000,0x00000000}},	//   _madre_, --, --, --, 
   {{0x53f83008,0x00000000,0x00000000,0x00000000}},	//   _semula_, --, --, --, 
   {{0x9be90033,0x00000000,0x00000000,0x00000000}},	//   _अमेरिकी_, --, --, --, 
   {{0x9290580d,0xb2005815,0x00000000,0x00000000}},	//   _polas_, _polis_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [600] --, --, --, --, 
   {{0xd1812817,0x00000000,0x00000000,0x00000000}},	//   _страница_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe278001a,0x6fd9780d,0x00000000,0x00000000}},	//   _bisnis_, _estás__comentar_, --, --, 
   {{0x02cee81a,0x00000000,0x00000000,0x00000000}},	//   _com__gambar_, --, --, --, 
   {{0xf313e803,0xa27ff81b,0x8a3da00e,0x00000000}},	//   _mencoba_, _grund_, _नतीजा_, --, 
   {{0x9eb30016,0x00000000,0x00000000,0x00000000}},	//   _direitos_, --, --, --, 
   {{0x4b996824,0x92905813,0x00000000,0x00000000}},	//   _पता__चल_, _ella_, --, --, 
   {{0x0b62581c,0x52d87810,0x2e72600e,0x00000000}},	//   _बनाने_, _bene_, _इंद्र_, --, 
   {{0xaa3d2842,0x62d8781e,0x72007817,0x42783010}},	//   _होत_, _cene_, _ceni_, _mu__mwaka_, 
   {{0xba02f836,0x4ba0780d,0x7d7ef817,0x8f675010}},	//   _सहायता__सहायता_, _licenza__recoñece, _му_, _yawe__adakoran, 
   {{0xd394f815,0xeef12817,0x00000000,0x00000000}},	//   _rahsia_, _име_, --, --, 
   {{0xebf0f00e,0x1bcc481c,0x29456811,0x00000000}},	//   _इतिहास__के_, _आने_, _alquiler_, --, 
   {{0x835e601a,0x346b600c,0x00000000,0x00000000}},	//   _pengikut__lainnya_, _aby__sa_, --, --, 
   {{0xc200a01a,0x5d7f2817,0x2224c806,0x00000000}},	//   _mobil_, _јул_, _celkem_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3bcc681c,0x00000000,0x00000000,0x00000000}},	// [610] _इसी_, --, --, --, 
   {{0x648e601b,0xe24a9016,0x021c8817,0x00000000}},	//   _af__de_, _clique__aqui_, _објављен, --, 
   {{0x8756f80e,0x00000000,0x00000000,0x00000000}},	//   _से__अपना_, --, --, --, 
   {{0x44ae801b,0x64997020,0xf40c580c,0x00000000}},	//   _seneste__nyt_, _condició_de_, _aktuálne_, --, 
   {{0x8c48980e,0x94bee810,0xf27e0010,0x00000000}},	//   _देखे_, _mashyash_ya_, _ukine_, --, 
   {{0xe4abe012,0xe5af701d,0x00000000,0x00000000}},	//   _der__er_, _obchodní, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x73eb980d,0x00000000,0x00000000,0x00000000}},	//   _editar__fonte_, --, --, --, 
   {{0xb443f810,0x00000000,0x00000000,0x00000000}},	//   _uyu_, --, --, --, 
   {{0x71cda806,0xfa4da806,0x03859015,0x207da017}},	//   _všechny_, _všechna_, _ianya__percuma_, _коментар_користећ, 
   {{0x0a5ac80e,0x00000000,0x00000000,0x00000000}},	//   _कि__देश_, --, --, --, 
   {{0xd3e18016,0x00000000,0x00000000,0x00000000}},	//   _opinião__sobre_, --, --, --, 
   {{0xe2ca8003,0x0ae1d807,0x00000000,0x00000000}},	//   _apalagi_, _nettside, --, --, 
   {{0xd23b501f,0x00000000,0x00000000,0x00000000}},	//   _još__uvek_, --, --, --, 
   {{0x6421980f,0x6463d816,0xe3f9a810,0x00000000}},	//   _about__postao_, _imagens__de_, _yavuze_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd9e2f010,0xcb88f821,0x00000000,0x00000000}},	// [620] _ruboneka_, _पल_, --, --, 
   {{0xa200c806,0x00000000,0x00000000,0x00000000}},	//   _hodin_, --, --, --, 
   {{0xe3eba817,0x00000000,0x00000000,0x00000000}},	//   _да__буде_, --, --, --, 
   {{0x7bee2017,0x8b8fe818,0xa4268017,0x5492b010}},	//   _само_, _दो_, _pre__minuta_, _na__css_, 
   {{0xb48f6028,0x0ead5009,0x526d2013,0x00000000}},	//   _de__um_, _navođenj, _mayo_, --, 
   {{0x344d8006,0xf3696816,0x00000000,0x00000000}},	//   _kč_, _imagens_, --, --, 
   {{0x926ba010,0x2249901a,0x00000000,0x00000000}},	//   _ibiri__kuri_, _resmi_, --, --, 
   {{0x82fc2007,0xd3bdb00c,0x626d2010,0x00000000}},	//   _innhold_, _chcete__pridať_, _nayo_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0eae1015,0xc273d00f,0x00000000,0x00000000}},	//   _syarikat_, _slavo__kukić_, --, --, 
   {{0xaa33900a,0x00000000,0x00000000,0x00000000}},	//   _अउर_, --, --, --, 
   {{0xabcc6821,0x020e2817,0xee70a817,0x6a96580e}},	//   _इसे_, _сада_, _треба__да_, _से__बढ़_, 
   {{0xb42a8029,0x80533006,0x00000000,0x00000000}},	//   _sve__poruke_, _sportovn, --, --, 
   {{0xe3e6e006,0xff257829,0xbf535815,0x00000000}},	//   _být_, _profil__pošalji_, _baru__pertanya, --, 
   {{0x55b66810,0x00000000,0x00000000,0x00000000}},	//   _amashaki_mashyash, --, --, --, 
   {{0x046de807,0x00000000,0x00000000,0x00000000}},	//   _noe__som_, --, --, --, 
   {{0xe443e825,0x7a3dc032,0x96c74007,0xd6f9f824}},	// [630] _okt_, _संग_, _samarbei, _बिया_, 
   {{0x226d2010,0x00000000,0x00000000,0x00000000}},	//   _zayo_, --, --, --, 
   {{0x03b5a805,0x12d8c80d,0x626c700c,0x126d2010}},	//   _lokacija__zagreb_, _poden_, _áno_, _yayo_, 
   {{0x0a3e5846,0x8a46901a,0xb3ea000d,0xe8e61017}},	//   _बंद_, _buat__pemberit, _xeito_, _библиогр_подаци_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6a951010,0xce538017,0x00000000,0x00000000}},	//   _aho__ubufasha_, _везе__ова_, --, --, 
   {{0xebdfa00a,0x00000000,0x00000000,0x00000000}},	//   _पी__के_, --, --, --, 
   {{0xc2ca780d,0xbbcc781c,0x6e7a580d,0x6b98a81c}},	//   _dende_, _उसे_, _termos__adiciona, _को__भी_, 
   {{0x932a6029,0x00000000,0x00000000,0x00000000}},	//   _vidi__profil_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b15f02e,0x733df81b,0xcc56501c,0x00000000}},	//   _tersedia_, _har__fået_, _खोजें_, --, 
   {{0x4e60e817,0x8a87401c,0xc2e70807,0x00000000}},	//   _од_, _ने__कहा_, _det__finnes_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf400a017,0x1e8c000e,0x00000000,0x00000000}},	//   _datum__upisa_, _के__महत्व_, --, --, 
   {{0x268cf80e,0xf201e81b,0x74b7d008,0x00000000}},	//   _बिहार_, _altid_, _surah__al_, --, 
   {{0x12d8b01e,0x0290b01e,0x53f8b01f,0x00000000}},	// [640] _dece_, _deca_, _decu_, --, 
   {{0xdd3fe81e,0xeb9d480a,0x00000000,0x00000000}},	//   _očistite_, _मालवा__के_, --, --, 
   {{0x1e292017,0x5aba081e,0x00000000,0x00000000}},	//   _као_, _proverit, --, --, 
   {{0x134b4023,0xe3ead80c,0x54444010,0x00000000}},	//   _nitko__nije_, _sveta_, _iy_, --, 
   {{0xb41dc817,0x00000000,0x00000000,0x00000000}},	//   _lične__poruke_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x02e0f010,0x00000000,0x00000000,0x00000000}},	//   _ibiganir_vyacu_, --, --, --, 
   {{0xd6e4080d,0x74571008,0x2b2a681c,0x53946807}},	//   _ir__navegaci, _kenal__minta_, _गुदगुदी__पर्यटन_, _epost_, 
   {{0xdb82c817,0xc81fc007,0x00000000,0x00000000}},	//   _poruke__tekstova_, _er__tilgjeng, --, --, 
   {{0x8a33601c,0xdbe0101b,0x2a38e017,0x7f79f81d}},	//   _कहा_, _accepter, _ће__бити_, _možná_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa211e81c,0x7ab0081c,0xced60038,0x00000000}},	//   _फोटो__गैलरी_, _सकते__हैं_, _možno_, --, 
   {{0x32fd902d,0xa3316815,0xe320c80c,0x00000000}},	//   _rediger_, _kerosaka_yang_, _kedy_, --, 
   {{0xb303300d,0x2386a81b,0x635d1003,0x00000000}},	//   _comparti_igual_, _aldrig_, _bingung_, --, 
   {{0x8d37881f,0x8291800d,0xf4444010,0x32c23012}},	//   _moć_, _xeral_, _cy_, _der__skal_, 
   {{0x5a3ab80c,0x00000000,0x00000000,0x00000000}},	//   _alebo__zaregist, --, --, --, 
   {{0xb40ab011,0x4200b00c,0xa6ffb80a,0x00000000}},	// [650] _hace__más_, _veci_, _एकरा_, --, 
   {{0x02d8f81b,0x437a6838,0x00000000,0x00000000}},	//   _nogen_, _zadarmo_, --, --, 
   {{0xe290c022,0x1200e009,0x00000000,0x00000000}},	//   _allaha_, _zenica_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72a1380c,0xf290c81a,0xc2d9f813,0x00000000}},	//   _pravidlá_, _beda_, _mejorar_, --, 
   {{0xcadc7002,0x92902015,0x00000000,0x00000000}},	//   _imágenes_, _sukan_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x59f95827,0x00000000,0x00000000,0x00000000}},	//   _upassend, --, --, --, 
   {{0x5e13c01e,0x00000000,0x00000000,0x00000000}},	//   _vučić_, --, --, --, 
   {{0x027e901a,0xf4760817,0x6270f80c,0x04969814}},	//   _agan_, _ceni__din_, _napríkla, _no__teu_, 
   {{0x8248900b,0x82a69010,0x44a81815,0x00000000}},	//   _awam_, _usaba_, _sebelum__ini_, --, 
   {{0xe4444010,0x00000000,0x00000000,0x00000000}},	//   _ry_, --, --, --, 
   {{0x0e28e817,0x944f1828,0x00000000,0x00000000}},	//   _за_, _há_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb44f1816,0xa4b42009,0x6c5d5816,0x247c5009}},	//   _já_, _autor__ica_, _cartão_, _onaj__ko_, 
   {{0x24444010,0x1cbf100b,0xe2ff100d,0x93ea5820}},	//   _vy_, _dan__peluang_, _comentar__desde_, _celta_, 
   {{0xabc0201c,0xd44f1816,0xbf24500c,0x00000000}},	// [660] _करने__की_, _lá_, _práve_, --, 
   {{0x42ca1011,0x9ad51007,0x00000000,0x00000000}},	//   _este__lugar_, _postadre, --, --, 
   {{0x0b8f2818,0x824d1809,0x9223381a,0xe354380d}},	//   _है_, _prikaz__ispisa_, _lengkap__topik_, _galegos_, 
   {{0xf2fdf81b,0xa27ed813,0x00000000,0x00000000}},	//   _brug_, _buen_, --, --, 
   {{0x2ed25817,0x048d6827,0x73f4001a,0x00000000}},	//   _да__је_, _de__som_, _justru_, --, 
   {{0x949cf01b,0x026c5806,0xe4ade009,0xdf3a2816}},	//   _at__få_, _bylo_, _staviti__na_, _as__melhores_, 
   {{0xa49cf01b,0x46614006,0x00000000,0x00000000}},	//   _at__gå_, _zaměstna, --, --, 
   {{0x54af6006,0x02571806,0x00000000,0x00000000}},	//   _že__se_, _dál_, --, --, 
   {{0x7320c806,0x1290c838,0x00000000,0x00000000}},	//   _tedy_, _teda_, --, --, 
   {{0x7444401b,0x238e2813,0x00000000,0x00000000}},	//   _op_, _de__acuerdo_, --, --, 
   {{0x0f22000f,0xf2918810,0x706d6807,0x00000000}},	//   _obavezno__navođenj, _imyaka_, _kompetan, --, 
   {{0x9502f845,0x1eb16820,0x00000000,0x00000000}},	//   _अनुभव_, _externas_, --, --, 
   {{0xa3f9580b,0x00000000,0x00000000,0x00000000}},	//   _kepada__semua_, --, --, --, 
   {{0x5f4bf003,0xf291c810,0x00000000,0x00000000}},	//   _bergabun, _umva_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62d8c820,0x00000000,0x00000000,0x00000000}},	//   _podes_, --, --, --, 
   {{0x7c51c006,0xcf905016,0x00000000,0x00000000}},	// [670] _kultura_, _grátis_, --, --, 
   {{0x649a500d,0x00000000,0x00000000,0x00000000}},	//   _máis__de_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x51f44826,0x927f7810,0x00000000,0x00000000}},	//   _nevhodné_, _uganda_, --, --, 
   {{0x1291801e,0x83ea300c,0x927ed80d,0xa386d828}},	//   _evra_, _tejto_, _quen_, _quer_, 
   {{0x32d98005,0x00000000,0x00000000,0x00000000}},	//   _cerek_, --, --, --, 
   {{0x846f2807,0x6bd6300d,0x22d91016,0x00000000}},	//   _les__mer_, _máis__informac, _vezes_, --, 
   {{0x8f350813,0x0443f810,0x4395f803,0x00000000}},	//   _reportar_, _ubu_, _trus_, --, 
   {{0x6bfa4039,0x22c42814,0x5395f815,0x0bb0101c}},	//   _नियम_, _uso__para_, _urus_, _लोगों__को_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa444401a,0x8a4c9824,0xaf5a3016,0x00000000}},	//   _rp_, _के__लाभ_, _pesquisa, --, 
   {{0xc3a23815,0x00000000,0x00000000,0x00000000}},	//   _tempoh_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2eea6017,0x00000000,0x00000000,0x00000000}},	//   _био__је_, --, --, --, 
   {{0xbc4f5018,0x92df5021,0x23ead81e,0x92f3c802}},	//   _अपने_, _अपनी_, _svetu_, _el__nombre_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [680] --, --, --, --, 
   {{0x6212d016,0x00000000,0x00000000,0x00000000}},	//   _mulher_, --, --, --, 
   {{0x82e5f003,0x03ac601a,0x927c601b,0x10f9480d}},	//   _lainnya_, _maupun_, _forskell, _proxecto, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x04444027,0xf2918008,0xb22f880c,0x00000000}},	//   _kk_, _perak_, _pre__deti_, --, 
   {{0xea3d280a,0x00000000,0x00000000,0x00000000}},	//   _होई_, --, --, --, 
   {{0x8b8d6021,0x42006013,0x4e86e017,0x00000000}},	//   _का_, _julio_, _се__не_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x34972006,0xd3445806,0x12b8b00c,0x400ac006}},	//   _kč__kč_, _recenze_, _prihlási_alebo_, _několik_, 
   {{0x34444010,0x653e400e,0xf496e013,0x0bcfe01c}},	//   _nk_, _के__करीब_, _no__me_, _किया__है_, 
   {{0xc4936013,0x04946010,0x5d12f817,0xdb052011}},	//   _es__la_, _li__li_, _их_, _una__opinión_, 
   {{0x6444400c,0x00000000,0x00000000,0x00000000}},	//   _ak_, --, --, --, 
   {{0xe3ea7802,0x96599011,0x00000000,0x00000000}},	//   _venta_, _otras__categorí, --, --, 
   {{0x92d83007,0x00000000,0x00000000,0x00000000}},	//   _igjen_, --, --, --, 
   {{0x9444401b,0x00000000,0x00000000,0x00000000}},	//   _dk_, --, --, --, 
   {{0x6e6de012,0x33ab001a,0x00000000,0x00000000}},	//   _københav, _daftar__lengkap_, --, --, 
   {{0x52cc201b,0x5c0e780e,0x00000000,0x00000000}},	// [690] _sælger_, _सामने__आई_, --, --, 
   {{0x1496e81b,0x00000000,0x00000000,0x00000000}},	//   _os__med_, --, --, --, 
   {{0x84b46027,0x21660010,0xbd600020,0x00000000}},	//   _vil__ha_, _ntushobo, _comunida_autónoma_, --, 
   {{0x1a20483e,0x74160810,0x00000000,0x00000000}},	//   _फेसबुक_, _rupapuro__byose_, --, --, 
   {{0xb4a69833,0x2304800d,0x00000000,0x00000000}},	//   _स्वास्थ्, _poder__votar_, --, --, 
   {{0x92ba581a,0xf2ae7017,0x00000000,0x00000000}},	//   _kondisi_, _izvor__tanjug_, --, --, 
   {{0xa4936010,0x7dd7d80d,0xb30e4015,0x00000000}},	//   _na__za_, _lingüíst, _peratus_, --, 
   {{0x54d74841,0x00000000,0x00000000,0x00000000}},	//   _मामिला_, --, --, --, 
   {{0xa27ed81b,0x226d9010,0xc4605816,0x00000000}},	//   _igen_, _maso_, _não__tem_, --, 
   {{0x446e9015,0xaa93c817,0x00000000,0x00000000}},	//   _laman__ini_, _подели_, --, --, 
   {{0xfab4680b,0x144f5027,0x72011006,0x52007813}},	//   _linkedin_, _nå_, _mezi_, _junio_, 
   {{0x84444026,0x4250001b,0x00000000,0x00000000}},	//   _sk_, _at__skrive_, --, --, 
   {{0x6e28e817,0x8eb8e817,0x00000000,0x00000000}},	//   _са_, _си_, --, --, 
   {{0xa9964006,0x62911010,0x00000000,0x00000000}},	//   _může_, _neza_, --, --, 
   {{0x5496e013,0x9659002e,0x46f9f821,0x34936026}},	//   _no__se_, _di__indonesi, _मेरा_, _by__sa_, 
   {{0xf2921023,0x1e7ea00d,0x48a9f816,0x744f5007}},	//   _srpanj_, _unha__organiza, _ótimo__estrelas_, _då_, 
   {{0x7300b811,0x525ad02d,0x00000000,0x00000000}},	// [6a0] _erróneo_, _tallet_, --, --, 
   {{0x34746026,0x7e9a5817,0x16ec580e,0x00000000}},	//   _som__sa_, _што__се_, _के__मंदिर_, --, 
   {{0xc290c80b,0x547d581b,0x23030015,0x00000000}},	//   _lelaki_, _mere__om_, _pelawat_, --, 
   {{0x94444015,0xddf24817,0x6496e002,0x00000000}},	//   _hb_, _пут__измењена_, _no__te_, --, 
   {{0xc7c72816,0xdc74a007,0x1b9c2021,0x421d880e}},	//   _mensagem_, _forumet_, _की__एक_, _नक्शा_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xec0ab80e,0xaeee6017,0x97a5e814,0x64b8500d}},	//   _राज्य__के_, _је__то_, _parroqui, _xeral__de_, 
   {{0x62fd2020,0x03011807,0x00000000,0x00000000}},	//   _aplicar_, _tilbake_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22020003,0x0a148817,0x5dca8017,0x09f9d01b}},	//   _posisi_, _мај__април_, _август__јул_, _opdatere, 
   {{0xebbfc00e,0xd26df002,0x00000000,0x00000000}},	//   _सिंह__के_, _estoy_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x547a1007,0x00000000,0x00000000,0x00000000}},	//   _informas_om_, --, --, --, 
   {{0x26b52029,0x54b06007,0x00000000,0x00000000}},	//   _milanovi, _mer__om_, --, --, 
   {{0x7d5fc80e,0x00000000,0x00000000,0x00000000}},	//   _इकाई_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2cae81b,0x00000000,0x00000000,0x00000000}},	// [6b0] _mindst_, --, --, --, 
   {{0x03eaf80d,0x00000000,0x00000000,0x00000000}},	//   _moitas_, --, --, --, 
   {{0x49e0c00b,0x00000000,0x00000000,0x00000000}},	//   _menghant, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1a104008,0x00000000,0x00000000,0x00000000}},	//   _malaysia_, --, --, --, 
   {{0xf2ab301b,0x00000000,0x00000000,0x00000000}},	//   _køber_, --, --, --, 
   {{0x07e4a81c,0x00000000,0x00000000,0x00000000}},	//   _ख़बरें_, --, --, --, 
   {{0x22d51806,0xd34ab00d,0x7386d81b,0xfe1c600d}},	//   _vše_, _esta__cambios_, _uger_, _estar__rexistra, 
   {{0x2292080b,0xdc0f6016,0x3b96a80d,0x00000000}},	//   _kepada_, _seja__primeiro_, _especiai_ligazón_, --, 
   {{0xd2eba007,0x526df80c,0x00000000,0x00000000}},	//   _trenger_, _predchád, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x085df812,0x4444401d,0xf30b002e,0x00000000}},	//   _fotoalbu, _sb_, _serupa__dengan_, --, 
   {{0x92a62813,0x2b8c9821,0x5ed4e817,0x4200202e}},	//   _nombre_, _गए_, _ко_, _bikin_, 
   {{0xf226701b,0x00000000,0x00000000,0x00000000}},	//   _besked_, --, --, --, 
   {{0x513c1006,0x32a62813,0xab7b901d,0xc40a5015}},	//   _poslední_, _hombre_, _rekonstr, _dalam__tempoh_, 
   {{0x1eccc00d,0x00000000,0x00000000,0x00000000}},	//   _ligazóns__externas_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6c0] --, --, --, --, 
   {{0x7ae5f017,0x0a85f80e,0xcc60d003,0x00000000}},	//   _фебруар__јануар_, _साहित्य__में_, _temukan_, --, 
   {{0xea89300c,0xda33d80e,0x00000000,0x00000000}},	//   _inzeráto, _जड़_, --, --, 
   {{0x53e7601b,0x00000000,0x00000000,0x00000000}},	//   _tæt_, --, --, --, 
   {{0xb9d22017,0x53fa6829,0x00000000,0x00000000}},	//   _neregist, _udruga_, --, --, 
   {{0xa224681f,0x00000000,0x00000000,0x00000000}},	//   _skok_, --, --, --, 
   {{0x1e65701a,0x00000000,0x00000000,0x00000000}},	//   _dan__ketentua, --, --, --, 
   {{0x0e297817,0x43ea780d,0x00000000,0x00000000}},	//   _мај_, _xente_, --, --, 
   {{0xec03f824,0x00000000,0x00000000,0x00000000}},	//   _कुमार__के_, --, --, --, 
   {{0x147d201f,0x448cd81b,0x00000000,0x00000000}},	//   _često__postavlj, _masser__af_, --, --, 
   {{0x0734280e,0xb47bd011,0xb9dec017,0x32bbc015}},	//   _दिल्ली__पुलिस_, _real__el_, _utorak__neregist, _ibu__bapa_, 
   {{0x6b8ea01c,0x52d9d803,0x02d66011,0xa291300d}},	//   _वह_, _cewek_, _tu__cuenta_, _sexa_, 
   {{0x22742811,0x00000000,0x00000000,0x00000000}},	//   _nuevo__email_, --, --, --, 
   {{0x72ddb047,0x00000000,0x00000000,0x00000000}},	//   _खोजी_, --, --, --, 
   {{0x33359816,0x00000000,0x00000000,0x00000000}},	//   _você__pode_, --, --, --, 
   {{0xbfb61006,0xcdbbb813,0x8f1fb802,0x846c6028}},	//   _ještě_, _búsqueda_, _particip, _com__os_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6d0] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa46c6028,0x00000000,0x00000000,0x00000000}},	//   _com__as_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5df5e006,0x00000000,0x00000000,0x00000000}},	//   _představ, --, --, --, 
   {{0xb2b9c806,0x726d9016,0x9fab3806,0x22d9801b}},	//   _více_, _isso_, _nemovito, _jeres_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x547cd820,0x00000000,0x00000000,0x00000000}},	//   _onde__se_, --, --, --, 
   {{0x9260c013,0xec04f80e,0x2399601b,0x33548013}},	//   _años_, _जनता__के_, _læse_, _mujeres_, 
   {{0x3a46600e,0x00000000,0x00000000,0x00000000}},	//   _संरक्षित_, --, --, --, 
   {{0x54bcd006,0x00000000,0x00000000,0x00000000}},	//   _jsem__se_, --, --, --, 
   {{0x3366a01a,0x146f900d,0xf48be01a,0x73eae820}},	//   _tanggal_, _ligan__con_, _lintas__me_, _montes_, 
   {{0x163f3806,0x8e56e817,0x00000000,0x00000000}},	//   _komentář_, _уз_, --, --, 
   {{0x6a6ef010,0x00000000,0x00000000,0x00000000}},	//   _ubufasha_, --, --, --, 
   {{0xa3e7200c,0x00000000,0x00000000,0x00000000}},	//   _ešte_, --, --, --, 
   {{0x84423010,0x84bad81b,0x00000000,0x00000000}},	//   _adj_, _lige__nu_, --, --, 
   {{0xb430b816,0xd1e1301c,0xe04d6806,0x00000000}},	// [6e0] _desconto_, _हमारे_, _prohlíže, --, 
   {{0x0c5bf017,0xc317401e,0x00000000,0x00000000}},	//   _ekstovi_, _zvezde_, --, --, 
   {{0x427ed813,0x0da4080f,0x00000000,0x00000000}},	//   _bien_, _opšte__opće_, --, --, 
   {{0xb495e026,0x00000000,0x00000000,0x00000000}},	//   _sa__to_, --, --, --, 
   {{0x844f8813,0x00000000,0x00000000,0x00000000}},	//   _sé_, --, --, --, 
   {{0x64b24013,0x62c7e010,0x00000000,0x00000000}},	//   _condicio_de_, _ruboneka__neza_, --, --, 
   {{0xde24601c,0x1e00f803,0x0bb9281c,0x2da8f815}},	//   _बढ़िया__आपत्तिजन, _kesehata, _हैं__और_, _kesihata, 
   {{0x6a3cb00e,0x7ba91818,0x00000000,0x00000000}},	//   _रुप_, _हो__तो_, --, --, 
   {{0xc2906015,0x00000000,0x00000000,0x00000000}},	//   _julai_, --, --, --, 
   {{0x13b1680f,0x7eb3f817,0x5236d00c,0x00000000}},	//   _tekstova__ostalog_, _која__се_, _svojom_, --, 
   {{0x22e6701e,0x2386d810,0x525d7015,0xd972c802}},	//   _planeta_, _mbere_, _sebagai__ahli_, _opinione, 
   {{0xa426d81a,0xa0473017,0x00000000,0x00000000}},	//   _kamar__tidur_, _текст_, --, --, 
   {{0x26f03848,0x7a3d2818,0x43f5d014,0x00000000}},	//   _प्रवेश_, _हैं_, _datos__acerca_, --, 
   {{0x9c600805,0x00000000,0x00000000,0x00000000}},	//   _profil__postova_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x13a6980d,0x62d8f81b,0x4f96980d,0x00000000}},	//   _páxina_, _noget_, _páxinas_, --, 
   {{0x9c8e7805,0x127f5019,0x00000000,0x00000000}},	// [6f0] _korisnik__postova_, _apenas_, --, --, 
   {{0x6386d807,0x0fe80018,0x00000000,0x00000000}},	//   _sier_, _संपादित_, --, --, 
   {{0xc29f7003,0x22480017,0xb4903016,0xe2daa00c}},	//   _berbagai_, _snimi_, _em__uma_, _doplnky_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x826de810,0xe2d87807,0x99f65806,0x00000000}},	//   _bato_, _innen_, _zatím_, --, 
   {{0xc26e5003,0x84954814,0x00000000,0x00000000}},	//   _metode_, _século__xix_, --, --, 
   {{0xcb8dd00e,0x6470e00d,0x00000000,0x00000000}},	//   _झा_, _servizo__de_, --, --, 
   {{0x3b8ed00a,0xe2d83028,0x427ff807,0x0368d00d}},	//   _एह_, _hoje_, _grunn_, _linguas_, 
   {{0x071f580f,0x00000000,0x00000000,0x00000000}},	//   _je__objavlji, --, --, --, 
   {{0xd26de810,0xda29b81a,0x245b6010,0x00000000}},	//   _gato_, _bisa__mendapat, _yavuze__ko_, --, 
   {{0x4340e81a,0x00000000,0x00000000,0x00000000}},	//   _telepon_, --, --, --, 
   {{0x12903016,0xa8ec2017,0x00000000,0x00000000}},	//   _loja_, _условима__могући_, --, --, 
   {{0xee28e817,0x7290200c,0x00000000,0x00000000}},	//   _да_, _roka_, --, --, 
   {{0x62d87807,0x54a7d811,0xe27ef010,0x00000000}},	//   _annen_, _erróneo__no_, _izindi_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc782b836,0x00000000,0x00000000,0x00000000}},	//   _नीति__विकिपीडि, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [700] --, --, --, --, 
   {{0x72c4281b,0xfe12e00d,0xff89281c,0xbc743802}},	//   _indlæg_, _marca__rexistra, _रोमांस__साहित्य_, _saludos_, 
   {{0xe273f81a,0xb28cb01c,0x00000000,0x00000000}},	//   _bisa__menambah_, _उन्होंने_, --, --, 
   {{0x1248d81e,0x32fcf81b,0x00000000,0x00000000}},	//   _vreme_, _indhold_, --, --, 
   {{0x5e9fb016,0x5a60b016,0x2344501b,0x3d5ea81c}},	//   _verdinha_menciona, _preços_, _arbejde_, _भेजें__अस्वीकरण_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x13096815,0x00000000,0x00000000,0x00000000}},	//   _anda__boleh_, --, --, --, 
   {{0x13e7c006,0xf4857016,0x00000000,0x00000000}},	//   _mít_, _faça__seu_, --, --, 
   {{0xd30b2017,0xf2918010,0xa26de806,0xc9f4c806}},	//   _октобар_, _kera_, _tato_, _lidé_, 
   {{0x32cad006,0x67a8480c,0x00000000,0x00000000}},	//   _prodej_, _odpovedz_, --, --, 
   {{0x22d9801b,0xeba62024,0x546cd811,0x440c7806}},	//   _mere_, _कर__के_, _madre__no_, _aktuální_, 
   {{0xf2dde017,0x7859701a,0x74956010,0x00000000}},	//   _petak__izvor_, _tokobagu, _ko__mu_, --, 
   {{0x35be2817,0xf0c4d017,0x00000000,0x00000000}},	//   _други_, _додатни__услови_, --, --, 
   {{0xd2dfe00c,0x45986821,0x00000000,0x00000000}},	//   _na__sklade_, _व्रत_, --, --, 
   {{0x44426806,0xd369581a,0x00000000,0x00000000}},	//   _kdo_, _inggris_, --, --, 
   {{0x02b3e828,0x4ea3e819,0x00000000,0x00000000}},	//   _produto_, _produtos_, --, --, 
   {{0x56146017,0xed6c3017,0x00000000,0x00000000}},	// [710] _uslovi__korišćen, _celu__kuću_, --, --, 
   {{0xd467a005,0x3394f010,0x00000000,0x00000000}},	//   _tematski__alati_, _kristu_, --, --, 
   {{0x2b8fd81c,0x92d98007,0x7645180e,0x2671700f}},	//   _थी_, _dere_, _के__इतिहास_, _opštinsk_službeni, 
   {{0xed6d3017,0x92904814,0x00000000,0x00000000}},	//   _што_, _coma_, --, --, 
   {{0xbed58007,0xb4895011,0x00000000,0x00000000}},	//   _utviklin, _admite__el_, --, --, 
   {{0xaebdb00c,0x3e35700f,0x00000000,0x00000000}},	//   _hodnoten, _koristit_programe_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2904810,0x8290f81a,0x64b4180d,0x1c6d301f}},	//   _goma_, _nggak_, _conselle_de_, _verujem_, 
   {{0xec36a80c,0x00000000,0x00000000,0x00000000}},	//   _kategóri, --, --, --, 
   {{0x7442901a,0x12d99007,0xc2369002,0x00000000}},	//   _ama_, _lese_, _abajo_, --, 
   {{0xf863e013,0x00000000,0x00000000,0x00000000}},	//   _artículo, --, --, --, 
   {{0xe2905813,0x4317f81b,0x32d9900d,0x92fd6807}},	//   _hola_, _at__holde_, _nese_, _legger_, 
   {{0x3e28e817,0x5eb8e817,0x00000000,0x00000000}},	//   _на_, _ни_, --, --, 
   {{0x6ba16010,0x48b99817,0x00000000,0x00000000}},	//   _washobor, _последњи_, --, --, 
   {{0x5c0b0829,0x00000000,0x00000000,0x00000000}},	//   _obiteljs, --, --, --, 
   {{0xcb25780c,0x00000000,0x00000000,0x00000000}},	//   _porovnať_, --, --, --, 
   {{0xe4cea00d,0x00000000,0x00000000,0x00000000}},	// [720] _concello_, --, --, --, 
   {{0x92904810,0x00000000,0x00000000,0x00000000}},	//   _soma_, --, --, --, 
   {{0xdeed0016,0x73f8e00c,0x2c8f600e,0x00000000}},	//   _melhores_, _ponuka_, _इंडो_, --, 
   {{0xc2d87807,0x1394e82e,0x00000000,0x00000000}},	//   _annet_, _sensor_, --, --, 
   {{0x8290580c,0xadd9980c,0xa200580c,0xf437081a}},	//   _bola_, _deň_, _boli_, _di__lintas_, 
   {{0x32d9801b,0xebd7f824,0x3ee9d807,0x00000000}},	//   _vores_, _भाषा__के_, _funksjon, --, 
   {{0x332b201b,0x00000000,0x00000000,0x00000000}},	//   _om__synes_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x23fa281a,0x12d59806,0x94429003,0x00000000}},	//   _dan__langsung_, _než__méně_, _sma_, --, 
   {{0xaa9f2017,0xaa2d9014,0xf2919013,0x436bf81a}},	//   _прокомен_подели_, _texto__está_, _cosas_, _sejak__minggu_, 
   {{0xebde7824,0xe4acd80f,0x00000000,0x00000000}},	//   _बिहार__के_, _ostalog__na_, --, --, 
   {{0xfa33002b,0x59c2c00c,0x6bae981c,0x00000000}},	//   _चयन_, _odpovedz__páči_, _कोई__भी_, --, 
   {{0xa5a99817,0x00000000,0x00000000,0x00000000}},	//   _организа, --, --, --, 
   {{0x34a4e00c,0x00000000,0x00000000,0x00000000}},	//   _čo__sa_, --, --, --, 
   {{0xb4429016,0xc2cb4023,0x00000000,0x00000000}},	//   _uma_, _tjedan_, --, --, 
   {{0xb48e601b,0x00000000,0x00000000,0x00000000}},	// [730] _af__at_, --, --, --, 
   {{0x3386900c,0x83878019,0x00000000,0x00000000}},	//   _ktorí_, _carro_, --, --, 
   {{0xe4b86017,0xcc57301c,0x00000000,0x00000000}},	//   _vesti__na_, _इसमें_, --, --, 
   {{0x9c69e805,0x00000000,0x00000000,0x00000000}},	//   _još__postova_, --, --, --, 
   {{0x6290580d,0x4212b013,0xd71fb049,0x0224d807}},	//   _pola_, _fecha_, _उद्देश्य, _sjekk_, 
   {{0xd9daa82e,0x00000000,0x00000000,0x00000000}},	//   _ternyata_, --, --, --, 
   {{0x1bee1817,0xcb99001c,0x00000000,0x00000000}},	//   _како_, _साथ__ही_, --, --, 
   {{0xeb9ce00e,0x00000000,0x00000000,0x00000000}},	//   _प्रदेश__के_, --, --, --, 
   {{0xd4957820,0xb386980c,0xebde100e,0x64686019}},	//   _no__que_, _ktorý_, _हाल__के_, _dia__de_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc2d6f006,0x9ad29002,0x33f8f80c,0x00000000}},	//   _před_, _contrase, _ponuky_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6200f81a,0xf297f014,0x00000000,0x00000000}},	//   _bugil_, _dos__novos_, --, --, 
   {{0x02ca9013,0x03eb3028,0x00000000,0x00000000}},	//   _edad_, _sexta_, --, --, 
   {{0x63f4701b,0x76d7f81c,0x00000000,0x00000000}},	//   _har__været_, _चाहिए_, --, --, 
   {{0xab980014,0x4a32a00a,0x13dde811,0x8c49d00a}},	//   _ficheiro_, _गइल_, _tu__madre_, _नइखे_, 
   {{0x92d8c81b,0x00000000,0x00000000,0x00000000}},	// [740] _inden_, --, --, --, 
   {{0x6326a007,0x00000000,0x00000000,0x00000000}},	//   _en__annen_, --, --, --, 
   {{0x6c4e101c,0x4a329021,0x7475a807,0xf9f47806}},	//   _करने_, _खेल_, _saker__les_, _jiné_, 
   {{0x4236c81e,0x42d98017,0x00000000,0x00000000}},	//   _nadji_, _ocenite_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb3eb900c,0x422a2017,0x00000000,0x00000000}},	//   _meste_, _тога_, --, --, 
   {{0xebc0a01c,0x32abc81b,0x00000000,0x00000000}},	//   _होने__के_, _håber_, --, --, 
   {{0x447a1803,0x1fe13017,0x00000000,0x00000000}},	//   _saat__ini_, _своју_, --, --, 
   {{0xe462602d,0x00000000,0x00000000,0x00000000}},	//   _bør__du_, --, --, --, 
   {{0x397d4023,0x54429022,0x12d8c81b,0x53f95816}},	//   _uvjeti__korišten, _sda_, _anden_, _alguma_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf68cb81c,0x00000000,0x00000000,0x00000000}},	//   _प्यार_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3c071007,0x78c1881a,0xf327101b,0x00000000}},	//   _prosent_, _dalam__tokobagu, _procent_, --, 
   {{0xb449d016,0x00000000,0x00000000,0x00000000}},	//   _enviar__um_, --, --, --, 
   {{0x1212901a,0xf321e807,0x00000000,0x00000000}},	//   _udah_, _betyr_, --, --, 
   {{0x5a32a00e,0xf4548807,0x00000000,0x00000000}},	// [750] _गेल_, _har__hatt_, --, --, 
   {{0x7354d802,0x0275481a,0x027e9010,0x00000000}},	//   _quieres_, _pemberit_bagi_, _cyane_, --, 
   {{0xbb197808,0x3b69f00d,0x3beec017,0x00000000}},	//   _kerajaan_, _ligazón_, _након_, --, 
   {{0xdb8c6017,0x00000000,0x00000000,0x00000000}},	//   _povređen, --, --, --, 
   {{0x4654d011,0xbc0c3024,0x00000000,0x00000000}},	//   _tu__direcció, _दूर__तक_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9ef48015,0x00000000,0x00000000,0x00000000}},	//   _saling__berhubun, --, --, --, 
   {{0x5cb53011,0xe3eaf80d,0x00000000,0x00000000}},	//   _ha__cerrado_, _moitos_, --, --, 
   {{0x8255b022,0x3265880d,0xc300780d,0x00000000}},	//   _kantonal, _aplicar__termos_, _datos__citar_, --, 
   {{0xca3e400a,0x7a6e881c,0x127f0012,0x0b09200e}},	//   _भोज_, _करते__हैं_, _blandt_, _और__संस्कृति_, 
   {{0xb2d9c816,0x5c61d01c,0x43860010,0x00000000}},	//   _deve_, _कर__सकते_, _ibiri_, --, 
   {{0x92da001e,0xfb96200e,0x226c1016,0x53ea000d}},	//   _meseci_, _बात__से_, _acho_, _moito_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8543e003,0x00000000,0x00000000,0x00000000}},	//   _berhasil_, --, --, --, 
   {{0xfde25815,0xd4b9d01e,0xd9ec5002,0x00000000}},	//   _perniaga_perminta, _smajliji__su_, _colombia_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdbe0500e,0x00000000,0x00000000,0x00000000}},	// [760] _से__भर_, --, --, --, 
   {{0xa25ac806,0xf2906003,0x42906015,0x00000000}},	//   _podle_, _mulai_, _pulak_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44d6900e,0xd9f7a010,0x00000000,0x00000000}},	//   _मैथिली_, _bibiliya_, --, --, 
   {{0xf3120810,0xc5327817,0x00000000,0x00000000}},	//   _byose__cyangwa_, _септемба, --, --, 
   {{0x1315b00b,0xd3ea0007,0x826e180b,0x3439882d}},	//   _memberi_, _blitt_, _kenal__dari_, _at__dette_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0c51b01c,0x00000000,0x00000000,0x00000000}},	//   _पढ़ें_, --, --, --, 
   {{0x73a2c008,0x00000000,0x00000000,0x00000000}},	//   _lumpur_, --, --, --, 
   {{0x2e966017,0x00000000,0x00000000,0x00000000}},	//   _он__је_, --, --, --, 
   {{0x43522013,0xfe87180d,0xdbe7a017,0xc39eb01b}},	//   _un__amigo_, _de__xuño_, _под__лиценцом_, _betyder_, 
   {{0x42011002,0x00000000,0x00000000,0x00000000}},	//   _cocina_, --, --, --, 
   {{0x840b0014,0x00000000,0x00000000,0x00000000}},	//   _desde__http_, --, --, --, 
   {{0x028d600b,0x4fc3980d,0xd48db016,0x00000000}},	//   _perkara_, _ferramen_páxinas_, _de__sua_, --, 
   {{0x1291e810,0x72d8c81b,0xd464601b,0xeb99e81c}},	//   _leta_, _andet_, _synes__godt_, _की__गई_, 
   {{0x94201815,0x00000000,0x00000000,0x00000000}},	// [770] _niaga__baru_, --, --, --, 
   {{0xb442d80c,0x4290a01a,0x00000000,0x00000000}},	//   _sme_, _coba_, --, --, 
   {{0xc2ca901b,0x34429007,0xf317f01a,0x00000000}},	//   _hvad_, _hva_, _berbagi_, --, 
   {{0x64661809,0x9245e006,0x997e502d,0x00000000}},	//   _vrh__postao_, _dům_, _du__kommente, --, 
   {{0xcc213809,0x00000000,0x00000000,0x00000000}},	//   _mjeseca__mjeseci_, --, --, --, 
   {{0x22391017,0x00000000,0x00000000,0x00000000}},	//   _могу_, --, --, --, 
   {{0xb201e80c,0xa2d9e81e,0xd472101c,0x1291c80c}},	//   _deti_, _dete_, _महीने_, _tovar_, 
   {{0x2291800c,0xb7c41028,0x62927810,0x2eb4f812}},	//   _teraz_, _brasilei, _yesaya_, _anvendes_, 
   {{0xd442d826,0x00000000,0x00000000,0x00000000}},	//   _ide_, --, --, --, 
   {{0x8500a01c,0xc0e7381b,0x00000000,0x00000000}},	//   _क्रिकेट__अन्य_, _almindel, --, --, 
   {{0x96311802,0x00000000,0x00000000,0x00000000}},	//   _la__categorí, --, --, --, 
   {{0x0b99f81c,0xe442d806,0x00000000,0x00000000}},	//   _की__ओर_, _jde_, --, --, 
   {{0xc3de4816,0x92aae816,0x93806003,0xfbbb0824}},	//   _avaliaçã, _seu__comentár, _aturan_, _पाकिस्ता_से_, 
   {{0x5ea3b80f,0x739ab00d,0x00000000,0x00000000}},	//   _za__djelimič, _véxase_, --, --, 
   {{0xd2926815,0x1c59700b,0xc352701b,0x00000000}},	//   _kerana_, _peluang_, _tilføj_, --, 
   {{0x2442d810,0xda649010,0x7019c014,0x00000000}},	//   _nde_, _rupapuro__ruboneka_, _poder__comentar_, --, 
   {{0x226d2010,0x99f4d00c,0x00000000,0x00000000}},	// [780] _ibyo_, _budú_, --, --, 
   {{0xe4420007,0x63d8581b,0x00000000,0x00000000}},	//   _hei_, _at__gøre_, --, --, 
   {{0x7291e810,0x8213900c,0x00000000,0x00000000}},	//   _reta_, _najnovši, --, --, 
   {{0xcbcb681b,0x0bd1e018,0x00000000,0x00000000}},	//   _erhvervs, _करियर_, --, --, 
   {{0xcf22f805,0x6e92e016,0x73432013,0x8305701a}},	//   _nađi__još_, _amigo__adiciona, _derecho_, _pemberit_saya_, 
   {{0x14b12023,0x52749016,0xfa3d580e,0x00000000}},	//   _postova__od_, _estrelas__ótimo_, _रहन_, --, 
   {{0x3dd93815,0x82d83013,0x92a7800c,0xe4603802}},	//   _berkenaa, _mujer_, _farba_, _qué__es_, 
   {{0xb442d81f,0xa290f80d,0x44420007,0x5b5f6017}},	//   _gde_, _ligan_, _nei_, _climatec, 
   {{0x6250581e,0x43418028,0x00000000,0x00000000}},	//   _ne__bojim_, _janeiro_, --, --, 
   {{0x7ed56017,0xe442d806,0x00000000,0x00000000}},	//   _ми__се_, _zde_, --, --, 
   {{0xd394b01b,0x31d9a01c,0x00000000,0x00000000}},	//   _sidste_, _नज़र_, --, --, 
   {{0x6320901a,0x0a6e1824,0x00000000,0x00000000}},	//   _biaya_, _सत्र__में_, --, --, 
   {{0xe2d8c803,0x42d8b006,0x64b86017,0x00000000}},	//   _kode_, _roce_, _vesti__iz_, --, 
   {{0x1326e81b,0x00000000,0x00000000,0x00000000}},	//   _en__anden_, --, --, --, 
   {{0x17b3381f,0x92c7c01b,0x725a0007,0x645bf016}},	//   _reputaci, _sådan_, _feil_, _condiçõe_de_, 
   {{0xc3ea100c,0x225af00c,0x00000000,0x00000000}},	//   _tohto_, _mailom_, --, --, 
   {{0x0eba5007,0x11d0e806,0xc2d0e810,0xdc6e1016}},	// [790] _gjøre_, _telefony_, _telefoni_, _escreva_, 
   {{0xaa3cf821,0xc44ef011,0x00000000,0x00000000}},	//   _शहर_, _nombre__del_, --, --, 
   {{0x7ec27817,0x00000000,0x00000000,0x00000000}},	//   _данас__се_, --, --, --, 
   {{0xf39b781a,0x00000000,0x00000000,0x00000000}},	//   _jakarta__selatan_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2bf980d,0x22ca901b,0x9387e80d,0x00000000}},	//   _que__ligan_, _plads_, _catro_, --, 
   {{0xf36f202e,0xa00d5806,0xca489024,0x00000000}},	//   _tingkat_, _proveden, _खास__तौर_, --, 
   {{0x1c02580d,0x9442d81b,0xd2e8a01a,0x00000000}},	//   _persoas_, _ude_, _pikiran_, --, 
   {{0x2341800d,0x00000000,0x00000000,0x00000000}},	//   _xaneiro_, --, --, --, 
   {{0x3b5ca01f,0x78b1a017,0xc2480016,0x3ee9d81b}},	//   _pošaljit, _под__истим_, _ruim_, _funktion, 
   {{0x927e7807,0xe46de007,0x00000000,0x00000000}},	//   _vann_, _hva__er_, --, --, 
   {{0x19ff8006,0x1a9c0024,0x00000000,0x00000000}},	//   _hvězdičk_recenzí_, _में__अगर_, --, --, 
   {{0xcd03002e,0x02915825,0xc4420007,0x00000000}},	//   _terlihat_, _adgang_, _vei_, --, 
   {{0xc588d00d,0x72d85815,0x00000000,0x00000000}},	//   _poboació, _filem_, --, --, 
   {{0xa442101a,0x32cad007,0x66ff381c,0x74444016}},	//   _deh_, _bilder_, _आपका_, _vc_, 
   {{0xfb620807,0x00000000,0x00000000,0x00000000}},	//   _publiser, --, --, --, 
   {{0x4a32b818,0x86ad5024,0x00000000,0x00000000}},	// [7a0] _गया_, _जन्म__स्थान_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44af901a,0xf2d4a817,0x9badb81c,0x00000000}},	//   _iklan__ini_, _četvrtak__izvor_, _था__कि_, --, 
   {{0x33ebe82d,0x2eb8f817,0x34539810,0x52d8d038}},	//   _dette_, _када__је_, _uru__rupapuro_, _budem_, 
   {{0xaae6283e,0x42f72011,0xf2d51007,0x00000000}},	//   _उद्योग_, _del__lugar_, _tillatt_, --, 
   {{0x2c026816,0x7eb4b817,0x00000000,0x00000000}},	//   _pessoas_, _који__се_, --, --, 
   {{0x9bd30807,0x00000000,0x00000000,0x00000000}},	//   _oppdater, --, --, --, 
   {{0x52002010,0x00000000,0x00000000,0x00000000}},	//   _kuki_, --, --, --, 
   {{0xf46ed817,0xfbe6301c,0x348c681e,0xb495f807}},	//   _према_, _कर__रहे_, _naprednj, _så__mye_, 
   {{0x33218010,0x00000000,0x00000000,0x00000000}},	//   _buryo_, --, --, --, 
   {{0xd2d9e81b,0x42902010,0xc4420007,0x3712201c}},	//   _efter_, _luka_, _bli_, _कर__सकता_, 
   {{0x64444026,0xf985d81c,0x00000000,0x00000000}},	//   _aj_, _जिसमें_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2387f01a,0x00000000,0x00000000,0x00000000}},	//   _istri_, --, --, --, 
   {{0xa3f87806,0x84bd5803,0x3436b007,0x00000000}},	//   _minut_, _langsung__di_, _de__siste_, --, 
   {{0x1c90b01c,0x54a32810,0xcecc300c,0x00000000}},	//   _दोनों_, _cyangwa__css_, _hviezdič, --, 
   {{0x53eb900c,0x00000000,0x00000000,0x00000000}},	// [7b0] _mesto_, --, --, --, 
   {{0x04ac901a,0x00000000,0x00000000,0x00000000}},	//   _berniaga__com_, --, --, --, 
   {{0x63cf481b,0x5429181a,0xb497e013,0x00000000}},	//   _blevet_, _original__posted_, _si__el_, --, 
   {{0xcb1f9015,0xb2f5b816,0x5d845007,0x00000000}},	//   _bahagian_, _digite__código_, _arbeidet_, --, 
   {{0x63871006,0xc2686016,0x3e5e2017,0x0c5de024}},	//   _který_, _estrela__ruim_, _пријави__на_, _के__जाने_, 
   {{0x02786810,0x2ad4401f,0x7e1b7003,0x00000000}},	//   _umuntu_, _đoković_, _ditemuka, --, 
   {{0x42b54002,0x2df8a817,0x00000000,0x00000000}},	//   _precio_, _коментар_, --, --, 
   {{0x9f25b016,0xd30f701a,0xf442301b,0x00000000}},	//   _qualquer_, _berbeda_, _hej_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x14423038,0x03ea7810,0x00000000,0x00000000}},	//   _jej_, _konti_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xec32f817,0x72003010,0x649c300d,0x00000000}},	//   _tanjug__komentar, _muji_, _xuño__de_, --, 
   {{0x4a33e84a,0xbc86d023,0x8eb8e817,0x00000000}},	//   _जात_, _sve__postove_, _ти_, --, 
   {{0x275aa830,0xf35d6817,0x54423026,0x00000000}},	//   _संस्करण_, _pol__ženski_, _nej_, --, 
   {{0x638ab81b,0x73aa300d,0x43874013,0x00000000}},	//   _gøre_, _baixo__licenza_, _cuerpo_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xce0d2017,0x00000000,0x00000000,0x00000000}},	// [7c0] _ова_, --, --, --, 
   {{0x02e9600e,0x52016010,0x00000000,0x00000000}},	//   _सत्र_, _kugira_, --, --, 
   {{0x2439f81e,0x94432006,0x527f7813,0x00000000}},	//   _na__svetu_, _kdy_, _cuanto_, --, 
   {{0xa290e01e,0xf236d00c,0x7ef4d817,0x4c61b810}},	//   _dinara_, _svojim_, _које__се_, _akarere_, 
   {{0x09f4c806,0x825a301b,0x00000000,0x00000000}},	//   _lidí_, _fejl_, --, --, 
   {{0x1442d80c,0x648c3816,0x00000000,0x00000000}},	//   _dve_, _além__de_, --, --, 
   {{0x5008900d,0x00000000,0x00000000,0x00000000}},	//   _relacion_páxinas_, --, --, --, 
   {{0x4a73701c,0x22005815,0xa2900016,0x00000000}},	//   _किया__गया_, _bilik_, _criar_, --, 
   {{0x9e13c01e,0xebeda00a,0x00000000,0x00000000}},	//   _dačić_, _सब__के_, --, --, 
   {{0x5987880c,0x44abd80c,0x00000000,0x00000000}},	//   _páči_, _stránke_, --, --, 
   {{0x5c48f81c,0x31ea781c,0x42d8f81c,0x3496e013}},	//   _सकते_, _एक__नज़र_, _सकती_, _no__lo_, 
   {{0xd34e800f,0x00000000,0x00000000,0x00000000}},	//   _kantonim_opštinam, --, --, --, 
   {{0x33719010,0xf1772817,0x00000000,0x00000000}},	//   _ibibera__hanze_, _вести_, --, --, 
   {{0x12907815,0x00000000,0x00000000,0x00000000}},	//   _sunat_, --, --, --, 
   {{0x8c4f681c,0x7ca39022,0x9c8f681c,0x62df681c}},	//   _आपके_, _političk_partije_, _आपको_, _आपकी_, 
   {{0x64424828,0x00000000,0x00000000,0x00000000}},	//   _nem_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [7d0] --, --, --, --, 
   {{0xc3567016,0xf2720815,0x00000000,0x00000000}},	//   _receber_, _penuh__carian_, --, --, 
   {{0xa4424816,0x12caa029,0xd442301b,0xd3ead80c}},	//   _bem_, _hajduk_, _vej_, _svet_, 
   {{0x52da781e,0xe2902015,0x00000000,0x00000000}},	//   _meseca_, _rakan_, --, --, 
   {{0x92904815,0x02d82007,0xe2004810,0xc46e100d}},	//   _laman_, _saken_, _cumi_, _enderezo_, 
   {{0x6bb7100d,0x5b1fc015,0x00000000,0x00000000}},	//   _as__ligazóns_, _kelantan_, --, --, 
   {{0xf451a822,0x00000000,0x00000000,0x00000000}},	//   _vrijeme__posta_, --, --, --, 
   {{0xeec0d030,0x84765011,0xe27f5810,0x00000000}},	//   _विशेष__पृष्ठ_, _lugar__ha_, _ukwa__cumi_, --, 
   {{0xc36e300f,0x00000000,0x00000000,0x00000000}},	//   _kantonim, --, --, --, 
   {{0x921f1009,0xe0120822,0x00000000,0x00000000}},	//   _mjeseci__godina_, _izdvajan, --, --, 
   {{0x6a485828,0x0e2dd01a,0x00000000,0x00000000}},	//   _de__pagament, _dengan__pengikut_, --, --, 
   {{0x4e72e817,0x4f25101b,0x12c5101b,0xc284c016}},	//   _ће_, _billeder_, _billede_, _páginas__como_, 
   {{0x03eb9007,0x575fe00e,0x9c3dd00f,0xd34f8017}},	//   _beste_, _विस्फोट_, _istraživ_finansir, _новембар__октобар_, 
   {{0x936f6006,0x6597380e,0x4c9fe813,0x00000000}},	//   _rozpětí_, _में__करीब_, _la__última_, --, 
   {{0xa2959023,0x54425815,0xc3ead811,0x00000000}},	//   _tematski_, _mel_, _cuotas_, --, 
   {{0x62905808,0x00000000,0x00000000,0x00000000}},	//   _mula_, --, --, --, 
   {{0x027eb804,0x3c4e501c,0x3481c00c,0xb2389816}},	// [7e0] _jednom_, _कैसे_, _registro_sa_, _primeiro__enviar_, 
   {{0xb442481d,0xd2918013,0xedff5015,0xa2d4201e}},	//   _sem_, _otras_, _rundinga, _večernje_, 
   {{0x5175e016,0x00000000,0x00000000,0x00000000}},	//   _notícias_, --, --, --, 
   {{0xebf64824,0xb496e006,0x00000000,0x00000000}},	//   _गांव__के_, _se__to_, --, --, 
   {{0x92907806,0x00000000,0x00000000,0x00000000}},	//   _jinak_, --, --, --, 
   {{0xf4128009,0x1cb28009,0xba728009,0x1dffd02e}},	//   _sarajevo_, _sarajevu_, _sarajeva_, _ketentua, 
   {{0xc4424816,0x99207806,0x2c4e1018,0x02de101c}},	//   _tem_, _mobilní_, _करते_, _करती_, 
   {{0x82901015,0x00000000,0x00000000,0x00000000}},	//   _sihat_, --, --, --, 
   {{0xb0739009,0x93e5100c,0xb3266817,0x00000000}},	//   _bosansko, _podmienk, _prva__poslednj, --, 
   {{0xb4629815,0x2ed5e017,0x0aa5881c,0x00000000}},	//   _kenalan__dan_, _ко__је_, _में__हुए_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd94f4807,0x7ef0301c,0x00000000,0x00000000}},	//   _innlegge, _लड़की_, --, --, 
   {{0x6474a014,0x00000000,0x00000000,0x00000000}},	//   _elemento__de_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4c6d200d,0x00000000,0x00000000,0x00000000}},	//   _ligazóns__última_, --, --, --, 
   {{0x7290480b,0x632c4806,0x00000000,0x00000000}},	// [7f0] _zaman_, _těchto_, --, --, 
   {{0xff298826,0xd442481b,0xb2680802,0x00000000}},	//   _bratisla, _alm_, _del__sitio_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6a3df821,0x52d9300d,0x00000000,0x00000000}},	//   _तरह_, _hoxe_, --, --, 
   {{0x44b66022,0x2f77f016,0x00000000,0x00000000}},	//   _mijenjan_put_, _faça_, --, --, 
   {{0x44bb201a,0x00000000,0x00000000,0x00000000}},	//   _situs__ini_, --, --, --, 
   {{0xd9d15814,0x00000000,0x00000000,0x00000000}},	//   _ponteved, --, --, --, 
   {{0xbe8f1817,0x9a3d580a,0x0d864020,0x00000000}},	//   _али_, _रहल_, _interese_, --, 
   {{0xd442681e,0x925af81b,0xcf66601b,0xa2e43811}},	//   _deo_, _nogle_, _hjælp_, _algún__dato_, 
   {{0xf36f8815,0x9290e810,0x00000000,0x00000000}},	//   _bersetuj_dengan_, _munani_, --, --, 
   {{0xc0abc817,0x00000000,0x00000000,0x00000000}},	//   _се__промени_, --, --, --, 
   {{0x12d82007,0xd26c581e,0x2264a82e,0x00000000}},	//   _liker_, _belog_, _melalui__email_, --, 
   {{0x39f4201d,0x4eb8e817,0x26a2201b,0x93100010}},	//   _také_, _ми_, _spørgsmå, _ukwa__munani_, 
   {{0x8bcd5821,0xbff4181b,0x04976005,0x00000000}},	//   _रही_, _oplysnin, _pronađi__sve_, --, 
   {{0x02120010,0x2e320811,0x00000000,0x00000000}},	//   _igihe_, _hablaras_, --, --, 
   {{0x14427812,0x2eebd817,0x00000000,0x00000000}},	//   _hen_, _нам__је_, --, --, 
  
  };
  // table_hash = eb69-5560, unused_entries = 3978 (48.56%)

static const uint32 kDistinctOctaChrome1015SizeOne = 75;    // Bucket count one-lang
extern const uint32 kDistinctOctaIndSize = kDistinctOctaChrome1015SizeOne; // Source-agnostic named constant
static const uint32 kDistinctOctaChrome1015Ind[75] = {
  // [0000]
  0x00000000, 0x00000000, 0x00000b03, 0x00001c03,   // -- --  es.un.un_300 id.un.un_300 
  0x00000d01, 0x00001606, 0x00000d06, 0x00000806,   // cs.un.un_200 hr.un.un_400  cs.un.un_400 no.un.un_400 
  0x00001e03, 0x00003201, 0x00001306, 0x00001e01,   // ms.un.un_300 bs.un.un_200  bh.un.un_400 ms.un.un_200 
  0x00002d06, 0x00001906, 0x00001301, 0x00003206,   // sk.un.un_400 gl.un.un_400  bh.un.un_200 bs.un.un_400 
  // [0010]
  0x00005506, 0x00000b06, 0x00000203, 0x00000b01,   // rw.un.un_400 es.un.un_400  da.un.un_300 es.un.un_200 
  0x00001903, 0x00001e06, 0x00000a06, 0x00001706,   // gl.un.un_300 ms.un.un_400  pt.un.un_400 sr.un.un_400 
  0x00000903, 0x00000a01, 0x00001c06, 0x00000206,   // hi.un.un_300 pt.un.un_200  id.un.un_400 da.un.un_400 
  0x00000906, 0x00000d03, 0x00001703, 0x00001701,   // hi.un.un_400 cs.un.un_300  sr.un.un_300 sr.un.un_200 
  // [0020]
  0x00001901, 0x00000901, 0x00003203, 0x00001603,   // gl.un.un_200 hi.un.un_200  bs.un.un_300 hr.un.un_300 
  0x00001303, 0x00000201, 0x00002d03, 0x00000803,   // bh.un.un_300 da.un.un_200  sk.un.un_300 no.un.un_300 
  0x00000a03, 0x00001601, 0x13000d02, 0x09000d09,   // pt.un.un_300 hr.un.un_200  ne.bh.un_220 ne.hi.un_440 
  0x130d1c02, 0x00000801, 0x00001c01, 0x0d001c07,   // mr.ne.bh_222 no.un.un_200  id.un.un_200 mr.ne.un_420 
  // [0030]
  0x09000d08, 0x091c0d07, 0x09000d02, 0x09000d04,   // ne.hi.un_430 ne.mr.hi_432  ne.hi.un_220 ne.hi.un_320 
  0x09000d05, 0x09001c08, 0x09000d07, 0x13001c04,   // ne.hi.un_330 mr.hi.un_430  ne.hi.un_420 mr.bh.un_320 
  0x00002d01, 0x091c0d08, 0x09001c07, 0x09001c09,   // sk.un.un_200 ne.mr.hi_443  mr.hi.un_420 mr.hi.un_440 
  0x13000d07, 0x13001c09, 0x091c0da4, 0x09001c02,   // ne.bh.un_420 mr.bh.un_440  ne.mr.hi_433 mr.hi.un_220 
  // [0040] --- double_langprob_start=004b ---
  0x13001c05, 0x13000d09, 0x13001c08, 0x13000d08,   // mr.bh.un_330 ne.bh.un_440  mr.bh.un_430 ne.bh.un_430 
  0x0d001c08, 0x090d1ca4, 0x09001c05, 0x13000d04,   // mr.ne.un_430 mr.ne.hi_433  mr.hi.un_330 ne.bh.un_320 
  0x091c0d55, 0x13000d05, 0x13001c02,               // ne.mr.hi_442 ne.bh.un_330  mr.bh.un_220 
                                                    // 
  };

//  COMPILE_ASSERT(75 <= 2048, k_indirectbits_too_small);

extern const CLD2TableSummary kDistinctOcta_obj = {
  kDistinctOctaChrome1015,
  kDistinctOctaChrome1015Ind,
  kDistinctOctaChrome1015SizeOne,
  kDistinctOctaChrome1015Size,
  kDistinctOctaChrome1015KeyMask,
  kDistinctOctaChrome1015BuildDate,
  kDistinctOctaChrome1015RecognizedLangScripts,
};

static const uint32 kDistinctOctaChrome1015_2Size = 0;    // Bucket count
static const uint32 kDistinctOctaChrome1015_2KeyMask = 0xffffffff;    // Mask hash key

// NOTE: Some compilers will not allow an array of structs to have a constant
//       size of zero. Thus, we tell the code that the size is zero, but
//       actually allocate a single element array that will never be read.
//       More info: https://code.google.com/p/cld2/issues/detail?id=9
static const IndirectProbBucket4 kDistinctOctaChrome1015_2[1] = {
  // hash_indirect[4], tokens[4] in UTF-8
  {0x00000000,0x00000000,0x00000000,0x00000000} // UNUSED, see above!
  };
  // table_hash = ffff-ffff, unused_entries = 0 (0.00%)

static const uint32 kDistinctOctaChrome1015_2SizeOne = 2;    // Bucket count one-lang
extern const uint32 kDistinctOcta2IndSize = kDistinctOctaChrome1015_2SizeOne; // Source-agnostic named constant
static const uint32 kDistinctOctaChrome1015_2Ind[2] = {
  // [0000] --- double_langprob_start=0002 ---
  0x00000000, 0x00000000,                           // -- --  
                                                    // 
  };

extern const CLD2TableSummary kDistinctOcta_obj2 = {
  kDistinctOctaChrome1015_2,
  kDistinctOctaChrome1015_2Ind,
  kDistinctOctaChrome1015_2SizeOne,
  kDistinctOctaChrome1015_2Size,
  kDistinctOctaChrome1015_2KeyMask,
  kDistinctOctaChrome1015BuildDate,
  kDistinctOctaChrome1015RecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
