-- |
--
-- Module      :  System.Posix.Types
-- Copyright   :  (c) The University of Glasgow 2002
-- License     :  BSD-style (see the file libraries/base/LICENSE)
--
-- Maintainer  :  libraries@haskell.org
-- Stability   :  provisional
-- Portability :  non-portable (requires POSIX)
--
-- POSIX data types: Haskell equivalents of the types defined by the
-- @\<sys\/types.h>@ C header on a POSIX system.
--

module System.Posix.Types
    (-- *  POSIX data types
     -- **  Platform differences
     -- |  This module contains platform specific information about types.
     -- __/As such the types presented on this page reflect the platform
     -- on which the documentation was generated and may not coincide with
     -- the types on your platform./__
     module GHC.Internal.System.Posix.Types
     ) where

import GHC.Internal.System.Posix.Types
