/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/sviterbi.h
*       Authors:  Bernhard Knab, Benjamin Georgi
*
*       Copyright (C) 1998-2004 Alexander Schliep 
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*	Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik, 
*                               Berlin
*                                   
*       Contact: schliep@ghmm.org             
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 2214 $ 
*                       from $Date: 2008-04-02 10:37:28 -0400 (Wed, 02 Apr 2008) $
*             last change by $Author: grunau $.
*
*******************************************************************************/
#ifndef GHMM_SVITERBI_H
#define GHMM_SVITERBI_H

#ifdef __cplusplus
extern "C" {
#endif


#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

/* #if __EXPERIMENTAL__ == 3  */

/**@name CHMM-Viterbi-Algorithmus */
/*@{ (Doc++-Group: sviterbi) */

#include "smodel.h"

/**
   Viterbi algorithm: calculation of the viterbi path (best possible
   state sequenz for a given sequenz and a given model (smo)). Also 
   calculates logp according to this path, the matrices in the local_store
   struct are allocated using stat_matrix_d_alloc.
  @return        Viterbi-path 
  @param smo    model
  @param o       double-sequence
  @param T       sequence length (number of samples for multidemsional)
  @param log_p   log(p) of the sequence using the vitberbi path
  */
  int *ghmm_cmodel_viterbi (ghmm_cmodel * smo, double *o, int T, double *log_p);

/* #endif *//* __EXPERIMENTAL__ == 3 */

#ifdef __cplusplus
}
#endif
#endif
/*@} (Doc++-Group: cviterbi) */
