# ITK 5.3 Release Candidate 4: Distributed Computing

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.3 Release Candidate 4 is available for testing! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

ITK 5.3 is a feature release that accelerates performance, provides new segmentation and shape analysis algorithms, improves documentation, adds distributed computing support, among many more improvements. For more information about performance improvements, see [the 5.3 RC 1 Release Notes](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc01). For more information about new segmentation and shape analysis algorithms, see [the 5.3 RC 2 Release Notes](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc02). For more information about documentation improvements, see [the 5.3 RC 3 Release Notes](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc03).

ITK 5.3 RC 4 highlights distributed computing support with Dask. [Dask](https://www.dask.org/) is a Python library that makes scaling analysis easy through simple programming on a laptop that can then be deployed to HPC or cloud computing resources. In ITK 5.3 RC 4, Dask support applied in [medical imaging](https://www.youtube.com/watch?v=CMmoa8pP_eo), [bioimaging](https://blog.dask.org/2019/08/09/image-itk), and [material science](https://www.kitware.com/accelerating-volumetric-x-ray-microstructural-analytics-with-dask-itk-from-supercomputers-to-the-cloud/), is robust (caveat: `import itk` should be called in Dask worker functions). Furthermore, support was expanded from NumPy array views on `itk.Image`'s to full metadata-preserving distributed computing with `itk.Image`, `itk.Mesh`, `itk.PointSet`, and `itk.Transform`. With ITK's Dask support, batch processing a cohort of thousands of medical images or processing biomicroscopy, histopathology, or geospatial images with trillions of pixels is now a matter of minutes instead of weeks.

ITK 5.3 RC 4 also includes advancements in Python interface file (`.pyi`) support and new remote modules to [build WebAssembly processing pipelines to native executables and support ITK WebAssembly file formats](https://github.com/InsightSoftwareConsortium/itk-wasm), [perform multimaterial tetrahedral meshing from segmentations](https://github.com/SCIInstitute/ITKCleaver), and [read meshes from SWC files, a format for representing neuron morphology](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC).

![](https://i.imgur.com/Staejq8.png)

*[Knee MRI mapping of cartilage thickness in osteoarthritis](https://github.com/uncbiag/OAI_analysis_2) that leverages ITK's Dask support for distributed processing of large patient cohorts over the preprocessing, segmentation, registration, and post-processing steps of the analysis pipeline.*

Download
--------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```
pip install --upgrade --pre itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.3rc04.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/InsightSoftwareGuide-Book1-5.3rc04.pdf)
- [InsightSoftwareGuide-Book2-5.3rc04.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/InsightSoftwareGuide-Book2-5.3rc04.pdf)

**Library Sources**

- [InsightToolkit-5.3rc04.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/InsightToolkit-5.3rc04.tar.gz)
- [InsightToolkit-5.3rc04.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/InsightToolkit-5.3rc04.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.3rc04.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/InsightData-5.3rc04.tar.gz)
- [InsightData-5.3rc04.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/InsightData-5.3rc04.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc04/SHA512SUMS)


Features
--------

### Python

- Python packages now include oneTBB support for improved performance
- Following CPython's deprecation schedule Python 3.6 is no longer supported
- Python packages added for Python 3.10
- Initial Python wrapping is available for the Video modules
- `TransformToDisplacementField` is now available in Python
- Pythonic IO functions `itk.imread` understands `pathlib.Path`'s
- New `repr` for `itk.Matrix`
- `np.asarray` works on `itk.Matrix`
- `DCMTKImageIO` wrapping addressed
- `GradientDifferenceImageToImageMetric` wrapped
- `SynImageRegistrationMethod`, `BSplineSynImageRegistrationMethod` wrapped
- `ConjugateGradientLineSearchOptimizerv4` wrapped
- Wrap `ImageRegistrationMethodv4` for `itk.Mesh`
- Wrap `PointSetToPointSetMetric`, `PointSetToPointSetRegistrationMethod`
- Wrap `ANTSNeighborhoodCorrelationImageToImageMetricv4`
- Nearly all registration v4 classes are now wrapped
- `VectorImage` input for `DisplacementFieldTransform`
- Python wrapping for spatial orientation functionality
- PyImageFilter wrapped for additional types, supports pipeline functionality
- NumPy array interfaces for `itk.PointSet`, `itk.Mesh`
- manylinux_2_28 and manylinux2014 wheels are provided
- Dask support for `itk.Image`, `itk.PointSet`, `itk.Mesh`, `itk.Transform`


### C++

- C++14 is now required
- The minimum CMake version required is now 3.16.3
- New functions: `MakePoint`, `MakeVector`, `MakeIndex`, `MakeSize`.
- Targets in Visual Studio and other IDE's are now organize hierachically by ITK Group and Module
- Most of `itk::mpl` meta-programming functions replaced by C++14 equivalents
- Performance accelerations for b-spline interpolation, Mattes mutual information metric computation
- Improved modern C++ adoption, e.g. additional adoption of `constexpr`, `auto`
- `itk::ReadMesh`, `itk::WriteMesh` simple reader functions available, similar to `itk::ReadImage`, `itk::WriteImage`
- FFT backends are now registered through the object factory mechanism
- `cbegin()` and `cend()` member functions to `Index`, `Offset`, `Size`
- Add `itk::MakeFilled<TContainer>(value)`
- `itk::ConvertNumberToString<TValue>(val)` convenience function
- `itk::bit_cast<TDestination>(source)` function
- `itk::PolyLineCell`
- `InputSpaceName` and `OutputSpaceName` support for `itk::Transform`
- `qfac`, `qt_xyz` added to Nifti metadata
- `LZW` compression support
- Support requested output region in FFT filters
- Many code coverage improvements

### New filters

- `itk::TransformGeometryImageFilter`: applies a rigid transform to an `Image`'s metadata.
- 1D FFT classes
    - Interface classes for forward, inverse transformations
    - Vnl implementations
    - FFTW implementations
- `itk::TriangleMeshCurvatureCalculator` - Gaussian curvature calculator for `itk::Mesh`
- `FFTDiscreteGaussianImageFilter` -- discrete gaussian filters via FFTs

### Remote module updates

New remote modules:

- [HASI](https://github.com/KitwareMedical/HASI): High-Throughput Applications for Skeletal Imaging
- [ITKGrowCut](https://github.com/InsightSoftwareConsortium/ITKGrowCut): segments a 3D image from user-provided foreground and background seeds
- [ITKMeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData): Convert an ITK Mesh to a simple data structure compatible with vtkPolyData
- [ITKCudaCommon](https://github.com/SimonRit/ITKCudaCommon): Framework for processing images with CUDA
- [itk-wasm WebAssemblyInterface](https://github.com/InsightSoftwareConsortium/itk-wasm): Build WebAssembly processing pipelines to native executables and support ITK WebAssembly file formats
- [ITKCleaver](https://github.com/SCIInstitute/ITKCleaver): Multimaterial tetrahedral meshing.
- [ITKIOMeshSWC](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC): Read meshes from SWC files, a format for representing neuron morphology.

Updated modules: *AdaptiveDenoising*, *AnisotropicDiffusionLBR*, *BSplineGradient*, *BoneEnhancement*, *BoneMorphometry*, *Cuberille*, *GrowCut*, *HASI*, *HigherOrderAccurateGradient*, *IOFDF*, *IOScanco*, *IsotropicWavelets*, *MinimalPathExtraction*, *Montage*, *MorphologicalContourInterpolation*, *RTK*, *SimpleITKFilters*, *SkullStrip*, *SplitComponents*, *Strain*, *TextureFeatures*, *Thickness3D*, *TotalVariation*, *TubeTK*, and *Ultrasound*.


### Third party library updates

- dcmtk
- eigen
- expat
- fftw
- gdcm
- googletest
- hdf5
- kwsys
- kwiml
- minc
- metaio
- niftilib
- vxl
- zlib migrated to zlib-ng

### Congratulations

Congratulations and **thank you** to everyone who contributed to this release.

Of the *76 authors* who contributed since v5.2.0, we would like to specially recognize the new contributors:

*Michael Kuczynski, Tim Evain, Tomoyuki SADAKANE, Mario Emmenlauer, Andreas Gravgaard Andersen, Ebrahim Ebrahim, josempozo, Wenqi Li, Genevieve Buckley, Oleksandr Zavalistyi, Jose Tascon, Pranjal Sahu, ambrozicc1, Vagrant Ca                                                                                                                                                                                                                        scadian, MrTzschr, Philip Cook, Tihomir Heidelberg, Jason Rudy, Kian Weimer, z0gSh1u, Darren Thompson, Darren, Jose M Pozo, Paul Elliott, Gabriele Belotti, Rafael Palomar, Fernando Hueso-González, Mark Asselin, mrhardisty, Laryssa Abdala, Roland Bruggmann, Natalie Johnston, and ferdymercury.*


What's Next
-----------


This is the last release candidate before the 5.3.0 release. Please try out the current release candidate, and discuss your experiences at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**

ITK Changes Since v5.3rc03
---------------------------------------------

### Brad T. Moore (1):

#### Enhancements

- wrapped remaining v4 Registration classes ([6310d36d35](https://github.com/InsightSoftwareConsortium/ITK/commit/6310d36d35))


### Bradley Lowekamp (7):

#### Enhancements

- Add option to disable the server side searching ([1f6552cabe](https://github.com/InsightSoftwareConsortium/ITK/commit/1f6552cabe))

#### Bug Fixes

- Fix bad doxygen strings ([ce8181b202](https://github.com/InsightSoftwareConsortium/ITK/commit/ce8181b202))
- Fix numeric overflow in SLIC initialization ([86f8215c67](https://github.com/InsightSoftwareConsortium/ITK/commit/86f8215c67))
- Add DOXYGEN_(FORMAT) options to DoxygenConfig.cmake ([6eba9df7b1](https://github.com/InsightSoftwareConsortium/ITK/commit/6eba9df7b1))
- Fix Doxygen configuration for output formats ([c505191505](https://github.com/InsightSoftwareConsortium/ITK/commit/c505191505))
- Remove doxygen syntax markup for cmake lists ([ac2199bed0](https://github.com/InsightSoftwareConsortium/ITK/commit/ac2199bed0))

#### Style Changes

- Fix typo in debug macro ([87acfce9a9](https://github.com/InsightSoftwareConsortium/ITK/commit/87acfce9a9))


### Bryn Lloyd (1):

#### Bug Fixes

- ReconstructBiasField is setting bias field regions incorrectly ([f9b333c339](https://github.com/InsightSoftwareConsortium/ITK/commit/f9b333c339))


### Dženan Zukić (18):

#### Enhancements

- Refactor SpatialOrientation enumeration classes ([182c018e7b](https://github.com/InsightSoftwareConsortium/ITK/commit/182c018e7b))
- Add a Python test which demonstrates use of spatial orientation ([446723653b](https://github.com/InsightSoftwareConsortium/ITK/commit/446723653b))
- Follow-up to SpatialOrientationEnums refactoring ([387cc7c23f](https://github.com/InsightSoftwareConsortium/ITK/commit/387cc7c23f))
- Update remote modules by using the script ([d424d9da8e](https://github.com/InsightSoftwareConsortium/ITK/commit/d424d9da8e))
- Updating remote modules using the script ([cef0b6511c](https://github.com/InsightSoftwareConsortium/ITK/commit/cef0b6511c))
- Update Remote modules using the script ([865d0b0c7b](https://github.com/InsightSoftwareConsortium/ITK/commit/865d0b0c7b))
- Git hooks were updated ([8f8debd9b6](https://github.com/InsightSoftwareConsortium/ITK/commit/8f8debd9b6))
- Add Python wrapping for SpatialOrientationAdapter ([a3ac8de293](https://github.com/InsightSoftwareConsortium/ITK/commit/a3ac8de293))
- Make OrientationAdapterBase deprecated ([c294138d23](https://github.com/InsightSoftwareConsortium/ITK/commit/c294138d23))
- Mark CMake variables as advanced ([049ff7fe5a](https://github.com/InsightSoftwareConsortium/ITK/commit/049ff7fe5a))
- Update UpdateRemoteModules.sh to use authenticated Git protocol ([0d0fd8caf3](https://github.com/InsightSoftwareConsortium/ITK/commit/0d0fd8caf3))
- UpdateRemoteModules.sh now handles both master and main branches ([b1d5111592](https://github.com/InsightSoftwareConsortium/ITK/commit/b1d5111592))
- Updating remote modules to latest versions using the script ([895148dcea](https://github.com/InsightSoftwareConsortium/ITK/commit/895148dcea))
- Mark more zlib-ng options as advanced CMake variables ([b95c7be972](https://github.com/InsightSoftwareConsortium/ITK/commit/b95c7be972))
- Simplify Nifti IO test 13 using ReadImage and testing macros ([ee664da6bb](https://github.com/InsightSoftwareConsortium/ITK/commit/ee664da6bb))

#### Documentation Updates

- VLV CanBeDivided struct divides, not multiplies ([114dcc15f2](https://github.com/InsightSoftwareConsortium/ITK/commit/114dcc15f2))

#### Platform Fixes

- Update use of SpatialOrientation in non-default module PhilipsREC ([9a94f0a83d](https://github.com/InsightSoftwareConsortium/ITK/commit/9a94f0a83d))
- Fix GPUCommon compile errors ([9e78df2d7f](https://github.com/InsightSoftwareConsortium/ITK/commit/9e78df2d7f))


### Eigen Upstream (1):

#### Miscellaneous Changes

- Eigen3 2022-01-21 (803ae0ed) ([ae8cd25889](https://github.com/InsightSoftwareConsortium/ITK/commit/ae8cd25889))


### GDCM Upstream (1):

#### Miscellaneous Changes

- GDCM 2022-02-24 (ae0591f2) ([91f7139a53](https://github.com/InsightSoftwareConsortium/ITK/commit/91f7139a53))


### Gabriel A. Devenyi (1):

#### Bug Fixes

- Fix isAffine insuffcient precision in caluclations ([5ce861b0ba](https://github.com/InsightSoftwareConsortium/ITK/commit/5ce861b0ba))


### Hans J. Johnson (14):

#### Enhancements

- Suppress nullptr warnings ([6f4751d602](https://github.com/InsightSoftwareConsortium/ITK/commit/6f4751d602))

#### Platform Fixes

- Use nullptr instead of 0 or NULL ([3a6eaee232](https://github.com/InsightSoftwareConsortium/ITK/commit/3a6eaee232))
- Remove single use variable alias ([d5842b9198](https://github.com/InsightSoftwareConsortium/ITK/commit/d5842b9198))
- Inline single use macros and unset local variables ([75a1b9ab0e](https://github.com/InsightSoftwareConsortium/ITK/commit/75a1b9ab0e))
- Simplify submodule loading logic ([c34fb01a30](https://github.com/InsightSoftwareConsortium/ITK/commit/c34fb01a30))
- Inline single use macros ([4d31bbf12b](https://github.com/InsightSoftwareConsortium/ITK/commit/4d31bbf12b))
- Inline code for add_subdirectory that acted like a macro ([5eecf4de89](https://github.com/InsightSoftwareConsortium/ITK/commit/5eecf4de89))
- Simply prefix based on internal/external ([15aa8d58a0](https://github.com/InsightSoftwareConsortium/ITK/commit/15aa8d58a0))

#### Style Changes

- Add ; at end of macro for consistency ([897ab27879](https://github.com/InsightSoftwareConsortium/ITK/commit/897ab27879))
- Give error message when deprecated filename is encountered ([71fae7bf15](https://github.com/InsightSoftwareConsortium/ITK/commit/71fae7bf15))
- Make local variable names consistent ([9161222644](https://github.com/InsightSoftwareConsortium/ITK/commit/9161222644))
- Remove variable that is always set to OFF ([53acbd4396](https://github.com/InsightSoftwareConsortium/ITK/commit/53acbd4396))
- Prefer list mutation commands in cmake ([55962b7e1a](https://github.com/InsightSoftwareConsortium/ITK/commit/55962b7e1a))
- Simplify the candidate generators list ([243d4858e5](https://github.com/InsightSoftwareConsortium/ITK/commit/243d4858e5))


### Hans Johnson (40):

#### Enhancements

- Update DCMTK to more modern codebase ([f89399aa35](https://github.com/InsightSoftwareConsortium/ITK/commit/f89399aa35))
- Remove alias cmake macro ([7348e447c6](https://github.com/InsightSoftwareConsortium/ITK/commit/7348e447c6))
- Remove support for wrapping with TCL ([dedcefaa0f](https://github.com/InsightSoftwareConsortium/ITK/commit/dedcefaa0f))
- Remove support for wrapping with PERL ([e49cc53c52](https://github.com/InsightSoftwareConsortium/ITK/commit/e49cc53c52))
- Remove support for wrapping with JAVA ([2f9ee4ea99](https://github.com/InsightSoftwareConsortium/ITK/commit/2f9ee4ea99))
- Remove support for wrapping with RUBY ([da7804c4c5](https://github.com/InsightSoftwareConsortium/ITK/commit/da7804c4c5))
- Remove empty macro call function ([538f551508](https://github.com/InsightSoftwareConsortium/ITK/commit/538f551508))
- Update doxygen.config.in with new options ([9369958f06](https://github.com/InsightSoftwareConsortium/ITK/commit/9369958f06))
- Remove support for wrapping with WRAP_EXPLICIT ([0eac15b7bb](https://github.com/InsightSoftwareConsortium/ITK/commit/0eac15b7bb))
- Make conditional compilations ([1610321267](https://github.com/InsightSoftwareConsortium/ITK/commit/1610321267))
- Use function scoping for wrapping ([dba14cdb28](https://github.com/InsightSoftwareConsortium/ITK/commit/dba14cdb28))
- Rewrite python generation files with comments ([9e5d62dbb4](https://github.com/InsightSoftwareConsortium/ITK/commit/9e5d62dbb4))

#### Documentation Updates

- Document that ITK_WRAPPING is equivalent to ITK_WRAP_PYTHON ([a58826b5cb](https://github.com/InsightSoftwareConsortium/ITK/commit/a58826b5cb))
- Provide a comment for required file ([f2535dc3ea](https://github.com/InsightSoftwareConsortium/ITK/commit/f2535dc3ea))

#### Platform Fixes

- Remove use of deprecated functions ([50392d6f43](https://github.com/InsightSoftwareConsortium/ITK/commit/50392d6f43))
- Usage requirements should include language standard ([d6774dac04](https://github.com/InsightSoftwareConsortium/ITK/commit/d6774dac04))
- Missing semi-colon after macro ([94bc5a020f](https://github.com/InsightSoftwareConsortium/ITK/commit/94bc5a020f))
- C++20 ambiguous overloaded operator ([945563752d](https://github.com/InsightSoftwareConsortium/ITK/commit/945563752d))
- Simplify single use macros for wrapping ([1ab3807e4d](https://github.com/InsightSoftwareConsortium/ITK/commit/1ab3807e4d))
- Increased allowed size of doxygen.config.in ([d27156be60](https://github.com/InsightSoftwareConsortium/ITK/commit/d27156be60))
- Remove deprecated WRAPPER_LIBRARY_GROUPS ([88f3da19d1](https://github.com/InsightSoftwareConsortium/ITK/commit/88f3da19d1))
- Use same cmake_minimum_required values as ITK. ([b533f0679a](https://github.com/InsightSoftwareConsortium/ITK/commit/b533f0679a))
- Use modern doxygen_add_docs command ITK_WRAP_DOCS ([a44fd28a8e](https://github.com/InsightSoftwareConsortium/ITK/commit/a44fd28a8e))
- Use modern doxygen_add_docs for BUILD_DOCUMENTAITON ([a96d03fb5f](https://github.com/InsightSoftwareConsortium/ITK/commit/a96d03fb5f))

#### Bug Fixes

- Fix bug for remote AdaptiveDenoising ([d5e9e441c4](https://github.com/InsightSoftwareConsortium/ITK/commit/d5e9e441c4))
- Fix generated file name pattern ([bd448e5c80](https://github.com/InsightSoftwareConsortium/ITK/commit/bd448e5c80))
- XMLFileOutputWindowTest failed subsequent runs ([6d1bda2c6f](https://github.com/InsightSoftwareConsortium/ITK/commit/6d1bda2c6f))
- RecursiveGaussianImageFilterEnums double wrapped ([37239fea87](https://github.com/InsightSoftwareConsortium/ITK/commit/37239fea87))
- Add dependancy for bulding castxml before using it. ([ee989dc89a](https://github.com/InsightSoftwareConsortium/ITK/commit/ee989dc89a))

#### Style Changes

- Use default member initialization ([ac4c23412d](https://github.com/InsightSoftwareConsortium/ITK/commit/ac4c23412d))
- Prefer = default to explicitly trivial implementations ([3671be23b8](https://github.com/InsightSoftwareConsortium/ITK/commit/3671be23b8))
- Use vtk .clang-format for code style ([fca8b06fee](https://github.com/InsightSoftwareConsortium/ITK/commit/fca8b06fee))
- Convert CMake-language commands to lower case ([8761ffca97](https://github.com/InsightSoftwareConsortium/ITK/commit/8761ffca97))
- Remove CMake-language block-end command arguments ([3cd337fcf3](https://github.com/InsightSoftwareConsortium/ITK/commit/3cd337fcf3))
- Remove SVN revision number tracking in code ([c7ae377b96](https://github.com/InsightSoftwareConsortium/ITK/commit/c7ae377b96))
- Manually syncronize trivial fixes from VTK to ITK ([ddc0a37f78](https://github.com/InsightSoftwareConsortium/ITK/commit/ddc0a37f78))
- Prefer constexpr for zeroVector ([fef7832144](https://github.com/InsightSoftwareConsortium/ITK/commit/fef7832144))
- Remove debugging script and support code ([18ef48f1ab](https://github.com/InsightSoftwareConsortium/ITK/commit/18ef48f1ab))
- Simplify wrapping macro variable scope ([fe9bbb663b](https://github.com/InsightSoftwareConsortium/ITK/commit/fe9bbb663b))
- Remove unnecessary files from tree ([11ce56a7d8](https://github.com/InsightSoftwareConsortium/ITK/commit/11ce56a7d8))


### James Butler (1):

#### Platform Fixes

- Pass Windows specific OpenCV options to `ITKBridgeOpenCV` ([be81e62232](https://github.com/InsightSoftwareConsortium/ITK/commit/be81e62232))


### Jean-Christophe Fillion-Robin (4):

#### Platform Fixes

- Fix build against ITK install adding "expat_external.h" install rule ([1f7b427ec2](https://github.com/InsightSoftwareConsortium/ITK/commit/1f7b427ec2))
- Update ITKModuleExternal CMake message to avoid CTest false positive ([230839e71b](https://github.com/InsightSoftwareConsortium/ITK/commit/230839e71b))
- Fix older gcc build error including "cstddef" for "ptrdiff_t" ([056325814a](https://github.com/InsightSoftwareConsortium/ITK/commit/056325814a))
- Mangle hdf5 static symbols ([d00bcc78bf](https://github.com/InsightSoftwareConsortium/ITK/commit/d00bcc78bf))


### Jon Haitz Legarreta Gorroño (85):

#### Enhancements

- Test streaming `itk::SpatialOrientation` enum class types ([e82f200edc](https://github.com/InsightSoftwareConsortium/ITK/commit/e82f200edc))
- Increase `itk::SumOfSquaresImageFunction` class coverage ([346c084a0b](https://github.com/InsightSoftwareConsortium/ITK/commit/346c084a0b))
- Check GTest test method return value ([bb9d3c39d6](https://github.com/InsightSoftwareConsortium/ITK/commit/bb9d3c39d6))
- Improve `itk::ScalarImageKmeansImageFilter` testing ([00a2987d93](https://github.com/InsightSoftwareConsortium/ITK/commit/00a2987d93))
- Add `itk::PointSetToImageFilter` unit tests ([3adda5a464](https://github.com/InsightSoftwareConsortium/ITK/commit/3adda5a464))
- Add `itk::LaplacianSharpeningImageFilter` unit test ([93d238ebf1](https://github.com/InsightSoftwareConsortium/ITK/commit/93d238ebf1))
- Remove unnecessary/unused include statements ([c69afa338c](https://github.com/InsightSoftwareConsortium/ITK/commit/c69afa338c))
- Increase coverage for miscellaneous classes ([7866523c8d](https://github.com/InsightSoftwareConsortium/ITK/commit/7866523c8d))
- Increase coverage for miscellaneous classes ([c932d192a2](https://github.com/InsightSoftwareConsortium/ITK/commit/c932d192a2))
- Remove duplicate, commented `ITK_MANUAL_INSTANTIATION` guard ([d553554ff5](https://github.com/InsightSoftwareConsortium/ITK/commit/d553554ff5))
- Increase `itk::MaskFeaturePointSelectionFilter` class coverage ([4641ac4608](https://github.com/InsightSoftwareConsortium/ITK/commit/4641ac4608))
- Remove unreachable condition in FMUG all target reached mode ([9f94dfccc1](https://github.com/InsightSoftwareConsortium/ITK/commit/9f94dfccc1))
- Refactor FMUG filter target reached mode verification ([b49aaa8e28](https://github.com/InsightSoftwareConsortium/ITK/commit/b49aaa8e28))
- Increase `itk::FastMarchingBase` class coverage ([3a7a6f60c3](https://github.com/InsightSoftwareConsortium/ITK/commit/3a7a6f60c3))
- Increase `itk::XMLFileOutputWindow` class coverage ([bd1ba151d3](https://github.com/InsightSoftwareConsortium/ITK/commit/bd1ba151d3))
- Increase coverage for miscellaneous classes ([8273f8b104](https://github.com/InsightSoftwareConsortium/ITK/commit/8273f8b104))
- Fix typo in direction value exception macro message ([7c26965f2a](https://github.com/InsightSoftwareConsortium/ITK/commit/7c26965f2a))
- Prefer using the `itkTypeMacroNoParent` macro for RTTI ([748280c1af](https://github.com/InsightSoftwareConsortium/ITK/commit/748280c1af))
- Add `itkBooleanMacro` to `IFrameSafe` boolean ivar ([7cd8b768aa](https://github.com/InsightSoftwareConsortium/ITK/commit/7cd8b768aa))
- Add getter macro for boolean ivar ([755e894560](https://github.com/InsightSoftwareConsortium/ITK/commit/755e894560))
- Increase coverage for miscellaneous classes ([67653638c0](https://github.com/InsightSoftwareConsortium/ITK/commit/67653638c0))
- Prefer using existing file for unsupported format test ([cf66e47f0c](https://github.com/InsightSoftwareConsortium/ITK/commit/cf66e47f0c))
- Add boolean macros to `itk::MeshIOBase` data update ivars ([c14ee7b527](https://github.com/InsightSoftwareConsortium/ITK/commit/c14ee7b527))
- Increase coverage for `MeshIO` classes ([0fcfaf1288](https://github.com/InsightSoftwareConsortium/ITK/commit/0fcfaf1288))
- Call superclass `PrintSelf` method in child `PrintSelf` ([b5fdb855a0](https://github.com/InsightSoftwareConsortium/ITK/commit/b5fdb855a0))
- Increase coverage for miscellaneous classes ([90d0270e30](https://github.com/InsightSoftwareConsortium/ITK/commit/90d0270e30))
- Increase coverage for `itk::GDCMSeriesFileNames` ([f3c12edaf9](https://github.com/InsightSoftwareConsortium/ITK/commit/f3c12edaf9))

#### Documentation Updates

- Document methods in header file ([eafc48e491](https://github.com/InsightSoftwareConsortium/ITK/commit/eafc48e491))
- Fix typos and grammar in class and method documentation ([48010439a5](https://github.com/InsightSoftwareConsortium/ITK/commit/48010439a5))
- Increase `itk::MRASlabIdentifier` description Doxygen syntax use ([3d571f38cf](https://github.com/InsightSoftwareConsortium/ITK/commit/3d571f38cf))
- Fix typo in warning macro message ([26c4f2bd0c](https://github.com/InsightSoftwareConsortium/ITK/commit/26c4f2bd0c))
- Fix typos in miscellaneous comments ([5026c574c4](https://github.com/InsightSoftwareConsortium/ITK/commit/5026c574c4))
- Fix typo in variable names in test input argument usage ([6b594352a9](https://github.com/InsightSoftwareConsortium/ITK/commit/6b594352a9))
- Add `Writers` group to Doxygen documentation ([9bb0b7d830](https://github.com/InsightSoftwareConsortium/ITK/commit/9bb0b7d830))
- Prefer using ITK class names for syntax highlighting in Doxygen ([7eefc2f7eb](https://github.com/InsightSoftwareConsortium/ITK/commit/7eefc2f7eb))
- Fix typos and improve Doxygen related pages documentation ([2e481c4254](https://github.com/InsightSoftwareConsortium/ITK/commit/2e481c4254))
- Fix typo in method documentation ([af6b4b1f52](https://github.com/InsightSoftwareConsortium/ITK/commit/af6b4b1f52))
- Improve Doxygen modules documentation ([bcac6f9db2](https://github.com/InsightSoftwareConsortium/ITK/commit/bcac6f9db2))
- Fix typos in documentation, comments and exception messages ([a339bb6671](https://github.com/InsightSoftwareConsortium/ITK/commit/a339bb6671))

#### Platform Fixes

- Fix missing initialization braces warning ([1ec5c224c2](https://github.com/InsightSoftwareConsortium/ITK/commit/1ec5c224c2))
- Add missing semicolon to `itkExceptionMacro` statement end ([32d86d06be](https://github.com/InsightSoftwareConsortium/ITK/commit/32d86d06be))
- Remove duplicate include file ([a6fd170b53](https://github.com/InsightSoftwareConsortium/ITK/commit/a6fd170b53))

#### Bug Fixes

- Initialize `itk::ExhaustiveOptimizer::m_MinimumMetricValue` ([b4f096c0ea](https://github.com/InsightSoftwareConsortium/ITK/commit/b4f096c0ea))
- Set image origin according to point set bounding box ([8123eb3e91](https://github.com/InsightSoftwareConsortium/ITK/commit/8123eb3e91))
- Set mesh to join facet function in split facet function test ([bee86352a9](https://github.com/InsightSoftwareConsortium/ITK/commit/bee86352a9))
- Fix Superclass name in RTTI macro ([9de2b57048](https://github.com/InsightSoftwareConsortium/ITK/commit/9de2b57048))
- Fix gradient direction vector index ([88e626bda4](https://github.com/InsightSoftwareConsortium/ITK/commit/88e626bda4))
- Fix Superclass name in RTTI macro ([91029d4995](https://github.com/InsightSoftwareConsortium/ITK/commit/91029d4995))
- Set number of targets for FMUG image filter ([341050b1a3](https://github.com/InsightSoftwareConsortium/ITK/commit/341050b1a3))
- Fix class name in RTTI ([4bf79ac40d](https://github.com/InsightSoftwareConsortium/ITK/commit/4bf79ac40d))
- Fix variable type ([273d4ef8ea](https://github.com/InsightSoftwareConsortium/ITK/commit/273d4ef8ea))
- Fix `itkXMLFileOutputWindowTest` regression ([4ff05c0866](https://github.com/InsightSoftwareConsortium/ITK/commit/4ff05c0866))
- Fix Superclass type alias and name in RTTI macro ([e00832acac](https://github.com/InsightSoftwareConsortium/ITK/commit/e00832acac))
- Fix Superclass name in RTTI macro ([d05afe5f24](https://github.com/InsightSoftwareConsortium/ITK/commit/d05afe5f24))
- Provide appropriate enum value to `itkCellVisitMacro` ([bd556f0d32](https://github.com/InsightSoftwareConsortium/ITK/commit/bd556f0d32))
- Avoid querying about null variable size ([2eeb1b56d7](https://github.com/InsightSoftwareConsortium/ITK/commit/2eeb1b56d7))
- Fix test driver name for `MeshOBJ` and `MeshOFF` ([b66ca3e61b](https://github.com/InsightSoftwareConsortium/ITK/commit/b66ca3e61b))
- Fix `itkRegionalMinimaImageFilterTest` calls in test driver ([10c5475bf5](https://github.com/InsightSoftwareConsortium/ITK/commit/10c5475bf5))
- Match iterations array size value to number of levels ([f78d798ada](https://github.com/InsightSoftwareConsortium/ITK/commit/f78d798ada))
- Fix test method call argument order ([8b2a3d3fb3](https://github.com/InsightSoftwareConsortium/ITK/commit/8b2a3d3fb3))

#### Style Changes

- Prefer using `EXPECT_EQ` in GTest value check ([3f783a8be6](https://github.com/InsightSoftwareConsortium/ITK/commit/3f783a8be6))
- Use the `itkNameOfTestExecutableMacro` macro in tests ([1c3c7baa57](https://github.com/InsightSoftwareConsortium/ITK/commit/1c3c7baa57))
- Prefer using `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([e484b4f32d](https://github.com/InsightSoftwareConsortium/ITK/commit/e484b4f32d))
- Improve style in tests ([ca84de0df0](https://github.com/InsightSoftwareConsortium/ITK/commit/ca84de0df0))
- Prefer using `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([49015b62aa](https://github.com/InsightSoftwareConsortium/ITK/commit/49015b62aa))
- Rename `itkImageToHistogramFilterTest3` to honor tested class ([9325b2a457](https://github.com/InsightSoftwareConsortium/ITK/commit/9325b2a457))
- Improve style in FMUG filter test file ([a2c32681b4](https://github.com/InsightSoftwareConsortium/ITK/commit/a2c32681b4))
- Remove unnecessary empty comment blocks ([513216c714](https://github.com/InsightSoftwareConsortium/ITK/commit/513216c714))
- Allow a whitespace after variable in warning macro message ([8d78d09086](https://github.com/InsightSoftwareConsortium/ITK/commit/8d78d09086))
- Add a missing parameter message in test ([79d8c13e22](https://github.com/InsightSoftwareConsortium/ITK/commit/79d8c13e22))
- Improve the `itkFastMarchingBaseTest.cxx` style ([23a216dc1d](https://github.com/InsightSoftwareConsortium/ITK/commit/23a216dc1d))
- Use standard library exit codes in tests ([a1dcb9e985](https://github.com/InsightSoftwareConsortium/ITK/commit/a1dcb9e985))
- Check test input arguments at the beginning ([7462c48d8d](https://github.com/InsightSoftwareConsortium/ITK/commit/7462c48d8d))
- Remove uninformative/unnecessary print messages in tests ([4b0a50171a](https://github.com/InsightSoftwareConsortium/ITK/commit/4b0a50171a))
- Prefer using `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([5ff58ba746](https://github.com/InsightSoftwareConsortium/ITK/commit/5ff58ba746))
- Use the `itkNameOfTestExecutableMacro` macro in tests ([ff80a247f1](https://github.com/InsightSoftwareConsortium/ITK/commit/ff80a247f1))
- Prefer removing unused input arguments in tests ([ab1a7d78a2](https://github.com/InsightSoftwareConsortium/ITK/commit/ab1a7d78a2))
- Conform to ITK style in constant and variable naming in tests ([43630a0e13](https://github.com/InsightSoftwareConsortium/ITK/commit/43630a0e13))
- Improve variable value testing information ([9302d09298](https://github.com/InsightSoftwareConsortium/ITK/commit/9302d09298))
- Use the superclass name in `itkTypeMacro` ([43133866f4](https://github.com/InsightSoftwareConsortium/ITK/commit/43133866f4))
- Remove unnecessary `nullptr` assignment to smart pointer ([25fb76f424](https://github.com/InsightSoftwareConsortium/ITK/commit/25fb76f424))
- Make style consistent with the ITK style ([8f4939d871](https://github.com/InsightSoftwareConsortium/ITK/commit/8f4939d871))
- Use the `itkNameOfTestExecutableMacro` macro in tests ([155f0d4236](https://github.com/InsightSoftwareConsortium/ITK/commit/155f0d4236))
- Improve wording in `itk::GiftiMeshIO` exception messages ([1509cb21d7](https://github.com/InsightSoftwareConsortium/ITK/commit/1509cb21d7))
- Increase test style consistency ([3887bee498](https://github.com/InsightSoftwareConsortium/ITK/commit/3887bee498))


### Jose M Pozo (5):

#### Bug Fixes

- Limits check in ComputeJacobianWithRespectToPosition ([46e2ab9a14](https://github.com/InsightSoftwareConsortium/ITK/commit/46e2ab9a14))
- Non-isotropic spacing on Jacobian computation. ([0bb068d9c9](https://github.com/InsightSoftwareConsortium/ITK/commit/0bb068d9c9))
- Correct account of grid direction for Jacobian computation. ([492f2f8bfe](https://github.com/InsightSoftwareConsortium/ITK/commit/492f2f8bfe))
- remove unused variable size ([3b2bc5bae4](https://github.com/InsightSoftwareConsortium/ITK/commit/3b2bc5bae4))

#### Style Changes

- Clarifying logic in ComputeJacobianWithRespectToPositionInternal ([75bee914c7](https://github.com/InsightSoftwareConsortium/ITK/commit/75bee914c7))


### Julien Jomier (1):

#### Style Changes

- Wrong order of the arguments for the ITK book ([99cd695a61](https://github.com/InsightSoftwareConsortium/ITK/commit/99cd695a61))


### Kian Weimer (11):

#### Bug Fixes

- Fixed __init__.pyi generation for python stub files. ([cff58238af](https://github.com/InsightSoftwareConsortium/ITK/commit/cff58238af))
- Fixed import issues with Python stub interface files. ([9f6a17f869](https://github.com/InsightSoftwareConsortium/ITK/commit/9f6a17f869))
- Prevent append from duplicating arrays contents. ([fe0c52f059](https://github.com/InsightSoftwareConsortium/ITK/commit/fe0c52f059))

#### Style Changes

- Removed unused CMake statement and moved code location. ([a2626d684b](https://github.com/InsightSoftwareConsortium/ITK/commit/a2626d684b))
- refactored itk_end_wrap_submodule_python macro ([9216fac95c](https://github.com/InsightSoftwareConsortium/ITK/commit/9216fac95c))
- consistent use of lib in wrapping macros. ([a0b379b5c0](https://github.com/InsightSoftwareConsortium/ITK/commit/a0b379b5c0))
- Unset local vars and added comments ([00ac6f4ec7](https://github.com/InsightSoftwareConsortium/ITK/commit/00ac6f4ec7))
- Inlined macro that was called once. ([38e30bce3c](https://github.com/InsightSoftwareConsortium/ITK/commit/38e30bce3c))
- Removed empty macros ([1a3b189b48](https://github.com/InsightSoftwareConsortium/ITK/commit/1a3b189b48))
- Inlined single call macro. ([5f21dc096c](https://github.com/InsightSoftwareConsortium/ITK/commit/5f21dc096c))
- Inlined single call macro ([ea039670be](https://github.com/InsightSoftwareConsortium/ITK/commit/ea039670be))


### Lee Newberg (24):

#### Enhancements

- Introduce itk::Boolean for use with std::vector ([a837e7b5c7](https://github.com/InsightSoftwareConsortium/ITK/commit/a837e7b5c7))
- Use https instead of http when https works ([9cd0f2053f](https://github.com/InsightSoftwareConsortium/ITK/commit/9cd0f2053f))
- Use https instead of http when https works ([d6acfd26bf](https://github.com/InsightSoftwareConsortium/ITK/commit/d6acfd26bf))

#### Performance Improvements

- Combine conditions in ImageRegion::IsInside(index). ([f53e38ebce](https://github.com/InsightSoftwareConsortium/ITK/commit/f53e38ebce))

#### Documentation Updates

- Specify ```language in markdown.  Clang-format code examples. ([96724da54f](https://github.com/InsightSoftwareConsortium/ITK/commit/96724da54f))
- Do not end the subject line with a period ([86038f15c2](https://github.com/InsightSoftwareConsortium/ITK/commit/86038f15c2))

#### Platform Fixes

- Fix "warning: type qualifiers ignored on cast result type" ([d0321f01be](https://github.com/InsightSoftwareConsortium/ITK/commit/d0321f01be))
- Add #include "itkNumericTraitsVectorPixel.h" ([b9d65ac97b](https://github.com/InsightSoftwareConsortium/ITK/commit/b9d65ac97b))
- Fix overly narrow cast ([ea5d759daa](https://github.com/InsightSoftwareConsortium/ITK/commit/ea5d759daa))
- Add 9cd0f2053f0cf18 to .git-blame-ignore-revs ([1548b38298](https://github.com/InsightSoftwareConsortium/ITK/commit/1548b38298))

#### Bug Fixes

- Fix pointer to function returning unsigned int. ([b8864723c7](https://github.com/InsightSoftwareConsortium/ITK/commit/b8864723c7))
- FEM module has incorrect public member name ([1837c0e916](https://github.com/InsightSoftwareConsortium/ITK/commit/1837c0e916))

#### Style Changes

- Change `constexpr static` to `static constexpr`. ([e3147c16ee](https://github.com/InsightSoftwareConsortium/ITK/commit/e3147c16ee))
- Change unsigned to unsigned int. ([a812aa3cef](https://github.com/InsightSoftwareConsortium/ITK/commit/a812aa3cef))
- Apply `black` Python formatting. ([3291538d94](https://github.com/InsightSoftwareConsortium/ITK/commit/3291538d94))
- Ignore git commit that is only STYLE. ([5202fc29db](https://github.com/InsightSoftwareConsortium/ITK/commit/5202fc29db))
- Fix several spelling errors ([16fd80e520](https://github.com/InsightSoftwareConsortium/ITK/commit/16fd80e520))
- Ignore git commit that is only STYLE ([0df9d43eff](https://github.com/InsightSoftwareConsortium/ITK/commit/0df9d43eff))
- Change template parameter name prefix N to V ([4b43536c8b](https://github.com/InsightSoftwareConsortium/ITK/commit/4b43536c8b))
- Invoke pyupgrade --py37-plus on Python files ([0fbf00ad6e](https://github.com/InsightSoftwareConsortium/ITK/commit/0fbf00ad6e))
- Remove `std::` prefix from types that work without it ([c173dfd803](https://github.com/InsightSoftwareConsortium/ITK/commit/c173dfd803))
- Avoid old, C-style cast ([2fa80e8bd3](https://github.com/InsightSoftwareConsortium/ITK/commit/2fa80e8bd3))
- Drop `int` from `long int` and `short int` ([e03a94119d](https://github.com/InsightSoftwareConsortium/ITK/commit/e03a94119d))
- Drop `signed` from `signed short`, `signed int`, `signed long` ([8c2c654f3d](https://github.com/InsightSoftwareConsortium/ITK/commit/8c2c654f3d))


### Mark Asselin (1):

#### Platform Fixes

- Fix Slicer vtkITK build on macOS ([a5989825db](https://github.com/InsightSoftwareConsortium/ITK/commit/a5989825db))


### Matt McCormick (41):

#### Enhancements

- Wrap PyImageFilter for all wrapped scalar pixel types ([8f5241e9cf](https://github.com/InsightSoftwareConsortium/ITK/commit/8f5241e9cf))
- Pass in the class instance to the PyImageFilter PyGenerateData ([32186c8629](https://github.com/InsightSoftwareConsortium/ITK/commit/32186c8629))
- Add SetPyGenerateInputRequestedRegion to PyImageFilter ([d41cc7bfcc](https://github.com/InsightSoftwareConsortium/ITK/commit/d41cc7bfcc))
- Add SetPyGenerateOutputInformation to PyImageFilter ([76c82dabd0](https://github.com/InsightSoftwareConsortium/ITK/commit/76c82dabd0))
- Add SetPyEnlargeOutputRequestedRegion to PyImageFilter ([e2c206afa8](https://github.com/InsightSoftwareConsortium/ITK/commit/e2c206afa8))
- Load factories in Python at runtime ([67dbfc180a](https://github.com/InsightSoftwareConsortium/ITK/commit/67dbfc180a))
- Add MeshToPolyData remote module ([e5627894a1](https://github.com/InsightSoftwareConsortium/ITK/commit/e5627894a1))
- Add support for IPFS CID ExternalData content links ([73e67962a1](https://github.com/InsightSoftwareConsortium/ITK/commit/73e67962a1))
- Add WebAssemblyInterface remote module ([ba581f0a74](https://github.com/InsightSoftwareConsortium/ITK/commit/ba581f0a74))
- Add Cleaver remote module ([162ccd50c3](https://github.com/InsightSoftwareConsortium/ITK/commit/162ccd50c3))
- Transfer object name in xarray.DataArray conversion ([952dcb34c3](https://github.com/InsightSoftwareConsortium/ITK/commit/952dcb34c3))
- Refactor xarray support into separate module ([cf7580740b](https://github.com/InsightSoftwareConsortium/ITK/commit/cf7580740b))
- Add IOMeshSWC remote module. ([0dbaf37707](https://github.com/InsightSoftwareConsortium/ITK/commit/0dbaf37707))
- ITK 5.3rc04 content links ([c66b4934f8](https://github.com/InsightSoftwareConsortium/ITK/commit/c66b4934f8))

#### Documentation Updates

- Improve factory registration disablement doc ([2c94866637](https://github.com/InsightSoftwareConsortium/ITK/commit/2c94866637))
- Update Doxygen tarball URLs for new server ([9eaed1dcfa](https://github.com/InsightSoftwareConsortium/ITK/commit/9eaed1dcfa))
- Use full URL logo in README ([b19b881e34](https://github.com/InsightSoftwareConsortium/ITK/commit/b19b881e34))
- Website Doxygen download is a tar.gz instead of a zip ([f8c7a6e2bb](https://github.com/InsightSoftwareConsortium/ITK/commit/f8c7a6e2bb))
- Update Linux aarch Python wheel base image for manylinux_2_28 ([81799a7bc2](https://github.com/InsightSoftwareConsortium/ITK/commit/81799a7bc2))

#### Platform Fixes

- Update CastXML x86_64 binaries for LLVM 13.0.0 ([9a83f82f70](https://github.com/InsightSoftwareConsortium/ITK/commit/9a83f82f70))
- Add an option to not build the itkTestDriver executable ([43d4dde82f](https://github.com/InsightSoftwareConsortium/ITK/commit/43d4dde82f))
- Do not enable ITK_DYNAMIC_LOADING by default with Emscripten, WASI ([c1088ecb13](https://github.com/InsightSoftwareConsortium/ITK/commit/c1088ecb13))
- Do not use ExternalData symlinks with WASI builds ([81210a5988](https://github.com/InsightSoftwareConsortium/ITK/commit/81210a5988))
- Do not set instruction optimizations with WASI-SDK ([66b1ef7133](https://github.com/InsightSoftwareConsortium/ITK/commit/66b1ef7133))
- Do not use ITK_AUTOLOAD_PATH when ITK_WRAP_PYTHON is set ([5a395eb593](https://github.com/InsightSoftwareConsortium/ITK/commit/5a395eb593))
- Build errors when only ITK_WRAP_covariant_vector_double is enabled ([c10ff28e32](https://github.com/InsightSoftwareConsortium/ITK/commit/c10ff28e32))

#### Bug Fixes

- Do not let HDF5 set the CMAKE_INSTALL_PREFIX ([04455fd631](https://github.com/InsightSoftwareConsortium/ITK/commit/04455fd631))
- Do not use git call-outs to obtain Nifti version ([cfb3f28755](https://github.com/InsightSoftwareConsortium/ITK/commit/cfb3f28755))
- Provide module name with ITK_WRAP_DOC enabled ([4c1f55f2e9](https://github.com/InsightSoftwareConsortium/ITK/commit/4c1f55f2e9))
- Replace WRAPPER_MODULE_NAME use in CastXML wrapping configuration ([aa2354eb54](https://github.com/InsightSoftwareConsortium/ITK/commit/aa2354eb54))
- Remove duplicate Size entry in ImportImageFilter PrintSelf ([f372040a21](https://github.com/InsightSoftwareConsortium/ITK/commit/f372040a21))
- Correct xarray_from_image image_dims type ([3fbebc0042](https://github.com/InsightSoftwareConsortium/ITK/commit/3fbebc0042))
- Doxygen tarball links must be https ([b470f2831d](https://github.com/InsightSoftwareConsortium/ITK/commit/b470f2831d))
- Ignore third party *.h.in files for style checks ([9c01b7b299](https://github.com/InsightSoftwareConsortium/ITK/commit/9c01b7b299))
- Skip whitespace checks for ZLIB ghostflow ([9a6c2a0598](https://github.com/InsightSoftwareConsortium/ITK/commit/9a6c2a0598))
- Prevent Image corruption in Dask serialization ([594d602fb7](https://github.com/InsightSoftwareConsortium/ITK/commit/594d602fb7))
- Add missing name to image_to_dict ([bb76947526](https://github.com/InsightSoftwareConsortium/ITK/commit/bb76947526))
- Remove extra dimension member from Mesh, PointSet dict's ([28df2aff20](https://github.com/InsightSoftwareConsortium/ITK/commit/28df2aff20))
- Do not use assert in Python wrapping builds ([c44a7731f2](https://github.com/InsightSoftwareConsortium/ITK/commit/c44a7731f2))
- Remove wrapping configuration loading debug statement ([ffaf1a767c](https://github.com/InsightSoftwareConsortium/ITK/commit/ffaf1a767c))

#### Style Changes

- Apply black to base.py, helpers.py ([bde926014e](https://github.com/InsightSoftwareConsortium/ITK/commit/bde926014e))


### MetaIO Maintainers (1):

#### Miscellaneous Changes

- MetaIO 2022-03-10 (0b8c5284) ([ea77266974](https://github.com/InsightSoftwareConsortium/ITK/commit/ea77266974))


### Mihail Isakov (1):

#### Documentation Updates

- typo in itkMath comment ([963d0a82b1](https://github.com/InsightSoftwareConsortium/ITK/commit/963d0a82b1))


### Natalie Johnston (1):

#### Enhancements

- PointSet metric and registration method supports perspective proj. ([5bd7088044](https://github.com/InsightSoftwareConsortium/ITK/commit/5bd7088044))


### Niels Dekker (75):

#### Enhancements

- Add `Size.Fill` GoogleTest unit test ([9783af0c3c](https://github.com/InsightSoftwareConsortium/ITK/commit/9783af0c3c))
- Add itk::BooleanStdVectorType as alternative to `std::vector<bool>` ([4a6de1ebbc](https://github.com/InsightSoftwareConsortium/ITK/commit/4a6de1ebbc))
- Declare converting `Point(v)` constructors `explicit` ([8825834406](https://github.com/InsightSoftwareConsortium/ITK/commit/8825834406))
- Add `cbegin()` and `cend()` member functions to Index, Offset, Size ([ef44e3f730](https://github.com/InsightSoftwareConsortium/ITK/commit/ef44e3f730))
- Declare begin(), end() of FixedArray, Index, Offset, Size constexpr ([47bce26479](https://github.com/InsightSoftwareConsortium/ITK/commit/47bce26479))
- Test constexpr begin(), end() of FixedArray, Index, Offset, Size ([35648fa724](https://github.com/InsightSoftwareConsortium/ITK/commit/35648fa724))
- Declare RGBPixel, RGBAPixel constructors from component `explicit` ([0d352bdc63](https://github.com/InsightSoftwareConsortium/ITK/commit/0d352bdc63))
- Add `itk::MakeFilled<TContainer>(value)`, requested by issue #3230 ([b7715b3e74](https://github.com/InsightSoftwareConsortium/ITK/commit/b7715b3e74))
- Make Vector constructor from scalar explicit, unless LEGACY enabled ([abb88ccc48](https://github.com/InsightSoftwareConsortium/ITK/commit/abb88ccc48))
- Add `NumberToString<>` specialization, deducing its parameter type ([b933c6b12e](https://github.com/InsightSoftwareConsortium/ITK/commit/b933c6b12e))
- Add explicit `Matrix(const T (&)[VRows][VColumns])` constructor ([7dd9e49534](https://github.com/InsightSoftwareConsortium/ITK/commit/7dd9e49534))
- Support C-style arrays as MetaDataObjectType for MetaDataDictionary ([7299e5c59a](https://github.com/InsightSoftwareConsortium/ITK/commit/7299e5c59a))
- Add `itk::ConvertNumberToString<TValue>(val)` convenience function ([d3daa71b2f](https://github.com/InsightSoftwareConsortium/ITK/commit/d3daa71b2f))
- Add `itk::bit_cast<TDestination>(source)` function ([71e4c833f5](https://github.com/InsightSoftwareConsortium/ITK/commit/71e4c833f5))

#### Documentation Updates

- Mention changes scalar-to-container conversion in migration guide ([48976dfdaa](https://github.com/InsightSoftwareConsortium/ITK/commit/48976dfdaa))

#### Platform Fixes

- Add #include "itkNumericTraitsVectorPixel.h", for `MeanVectorType` ([c679de253e](https://github.com/InsightSoftwareConsortium/ITK/commit/c679de253e))
- Fix ImageBufferRange GTest clang `tautological-compare` warnings ([41fc630741](https://github.com/InsightSoftwareConsortium/ITK/commit/41fc630741))

#### Bug Fixes

- `region.IsInside(zeroSizedRegion)` should always return false ([1295d23939](https://github.com/InsightSoftwareConsortium/ITK/commit/1295d23939))
- Fix `ColorTableTestSpecialConditionChecker` component/pixel mix-up ([490ef8ce90](https://github.com/InsightSoftwareConsortium/ITK/commit/490ef8ce90))
- Quick-fix ContourSpatialObject::Update(), LINEAR_INTERPOLATION case ([5b71d63a88](https://github.com/InsightSoftwareConsortium/ITK/commit/5b71d63a88))
- Fix `SetCenterInObjectSpace` calls in Registration test ([12a501cddc](https://github.com/InsightSoftwareConsortium/ITK/commit/12a501cddc))
- Fix `TransformToDisplacementFieldFilter` displacementPoint/Vector ([dc70e38a5b](https://github.com/InsightSoftwareConsortium/ITK/commit/dc70e38a5b))
- Remove implicit conversions from a single value to `itk::Vector` ([7d732a3bd0](https://github.com/InsightSoftwareConsortium/ITK/commit/7d732a3bd0))
- Replace C-style casts from `_beginthreadex` with `bit_cast<HANDLE>` ([548b45f46d](https://github.com/InsightSoftwareConsortium/ITK/commit/548b45f46d))
- Replace `bit_cast<HANDLE>` calls with `reinterpret_cast<HANDLE>` ([21870fa743](https://github.com/InsightSoftwareConsortium/ITK/commit/21870fa743))
- Let MeshIOTestHelper AllocateBuffer return `std::shared_ptr<void>` ([db8d79733d](https://github.com/InsightSoftwareConsortium/ITK/commit/db8d79733d))

#### Style Changes

- Default (`= default`) special member functions of `Neighborhood` ([976baf8788](https://github.com/InsightSoftwareConsortium/ITK/commit/976baf8788))
- Remove private `ImageScanlineConstIterator` member `Increment()` ([b50207f64c](https://github.com/InsightSoftwareConsortium/ITK/commit/b50207f64c))
- Replace `NumericTraits<double>::ZeroValue()` calls by `0.0` ([5bb2a8cc7b](https://github.com/InsightSoftwareConsortium/ITK/commit/5bb2a8cc7b))
- Replace `NumericTraits<double>::OneValue()` calls by `1.0` ([7182b61a47](https://github.com/InsightSoftwareConsortium/ITK/commit/7182b61a47))
- Replace `NumericTraits<float>` ZeroValue() and OneValue() calls ([a0d4cef3ff](https://github.com/InsightSoftwareConsortium/ITK/commit/a0d4cef3ff))
- In-class default member initializers for ExhaustiveOptimizer data ([6914bfa40a](https://github.com/InsightSoftwareConsortium/ITK/commit/6914bfa40a))
- Remove obsolete `itkDebugMacro("Constructor")` calls ([48cc9e5f55](https://github.com/InsightSoftwareConsortium/ITK/commit/48cc9e5f55))
- Let assignment operators return a non-const reference ([61367f541e](https://github.com/InsightSoftwareConsortium/ITK/commit/61367f541e))
- Use type alias `BooleanStdVectorType` for `std::vector<uint8_t>` ([bc9ba8540f](https://github.com/InsightSoftwareConsortium/ITK/commit/bc9ba8540f))
- Remove unused `EnabledArrayType = std::vector<bool>` from test ([ee9116c4a8](https://github.com/InsightSoftwareConsortium/ITK/commit/ee9116c4a8))
- Replace `std::vector<bool>` with `std::unique_ptr<bool[]>` ([b7b7416d6d](https://github.com/InsightSoftwareConsortium/ITK/commit/b7b7416d6d))
- Apply C++ "Rule of Zero" to `itk::FixedArray` and derived classes ([b5e05140b5](https://github.com/InsightSoftwareConsortium/ITK/commit/b5e05140b5))
- Rename `ColorTable` template parameter `TPixel` to `TComponent` ([7b399810e8](https://github.com/InsightSoftwareConsortium/ITK/commit/7b399810e8))
- Avoid `T var = elementValue` syntax to initialize a filled array ([0c6c3a9b6d](https://github.com/InsightSoftwareConsortium/ITK/commit/0c6c3a9b6d))
- Fix SetIn/OutsideValue calls ConnectedComponentImageFilterTestRGB ([c5ca654ea5](https://github.com/InsightSoftwareConsortium/ITK/commit/c5ca654ea5))
- Clarify estimation ray position `RayCastInterpolateImageFunction` ([e4841aaba2](https://github.com/InsightSoftwareConsortium/ITK/commit/e4841aaba2))
- Use direct-initialization for component-to-RGBPixel conversion ([58a12673e0](https://github.com/InsightSoftwareConsortium/ITK/commit/58a12673e0))
- Remove function-style casts to iterator from Index, Offset, Size ([b85fc6202e](https://github.com/InsightSoftwareConsortium/ITK/commit/b85fc6202e))
- Replace type aliases with `using`-declarations, in itkIntTypes.h ([6ecb4dcf0c](https://github.com/InsightSoftwareConsortium/ITK/commit/6ecb4dcf0c))
- Use MakeFilled in Filled member functions FixedArray, Index, Size ([b836eb1f2d](https://github.com/InsightSoftwareConsortium/ITK/commit/b836eb1f2d))
- Use MakeFilled, () or {}, instead of `Vector(const ValueType &)` ([82001f3024](https://github.com/InsightSoftwareConsortium/ITK/commit/82001f3024))
- Use MakeFilled, () or {}, instead of `Point(const ValueType &)` ([100133db89](https://github.com/InsightSoftwareConsortium/ITK/commit/100133db89))
- Use MakeFilled instead of component-to-RGB/RGBAPixel constructors ([fa58a4db4a](https://github.com/InsightSoftwareConsortium/ITK/commit/fa58a4db4a))
- Use MakeFilled in any fixed array `NumericTraits` specialization ([908a29aa3c](https://github.com/InsightSoftwareConsortium/ITK/commit/908a29aa3c))
- Use ConvertNumberToString instead of local NumberToString objects ([c00f18a7b2](https://github.com/InsightSoftwareConsortium/ITK/commit/c00f18a7b2))
- Remove CMake checks on old MSVC versions (before version 1910) ([f9e6ca623c](https://github.com/InsightSoftwareConsortium/ITK/commit/f9e6ca623c))
- Encapsulate NiftiImage qto_xyz mat44 data as `Matrix<float,4,4>` ([e00bad0359](https://github.com/InsightSoftwareConsortium/ITK/commit/e00bad0359))
- Remove CMake code for old Apple compilers (GCC < 4.3/Clang < 3.2) ([91da17b832](https://github.com/InsightSoftwareConsortium/ITK/commit/91da17b832))
- Remove CMake workaround `ITK_REQUIRED_CXX_FLAGS` for GCC 4.8 ([e25750b8e6](https://github.com/InsightSoftwareConsortium/ITK/commit/e25750b8e6))
- Remove duplicate MSVC `/bigobj` flags from GPU test projects ([aec9e223a1](https://github.com/InsightSoftwareConsortium/ITK/commit/aec9e223a1))
- Replace unsafe `(T)x` and `T(x)` casts with `T{x}` in Common/src ([4bbccf2e80](https://github.com/InsightSoftwareConsortium/ITK/commit/4bbccf2e80))
- Remove casts from `MersenneTwisterRandomVariateGenerator::hash` ([59b001fac7](https://github.com/InsightSoftwareConsortium/ITK/commit/59b001fac7))
- Remove unnecessary `using` type aliases from struct definitions ([06808c4d52](https://github.com/InsightSoftwareConsortium/ITK/commit/06808c4d52))
- Remove unnecessary `using` type aliases from `enum` definitions ([1839cbee67](https://github.com/InsightSoftwareConsortium/ITK/commit/1839cbee67))
- Catch exceptions by _const_ reference ([f222a5e06b](https://github.com/InsightSoftwareConsortium/ITK/commit/f222a5e06b))
- Use `bit_cast` to convert random seeds from uint32_t to int32_t ([1d827a7868](https://github.com/InsightSoftwareConsortium/ITK/commit/1d827a7868))
- Remove unnecessary `(void *)` casts from `ByteSwapper` ([230617ae69](https://github.com/InsightSoftwareConsortium/ITK/commit/230617ae69))
- Use the `Self` type alias within `ByteSwapper<T>` ([21e5b173ad](https://github.com/InsightSoftwareConsortium/ITK/commit/21e5b173ad))
- Reduce code redundancy from `ByteSwapper` member functions ([98761284a4](https://github.com/InsightSoftwareConsortium/ITK/commit/98761284a4))
- Use `unique_ptr` in "SwapWrite" member functions of `ByteSwapper` ([88c2baa26f](https://github.com/InsightSoftwareConsortium/ITK/commit/88c2baa26f))
- Add const to first parameter of ByteSwapper "SwapWrite" functions ([faaae09983](https://github.com/InsightSoftwareConsortium/ITK/commit/faaae09983))
- Use `std::swap` within `ByteSwapper` ([741dad21a4](https://github.com/InsightSoftwareConsortium/ITK/commit/741dad21a4))
- Use `constexpr` and `bit_cast` within `GE4ImageIO::MvtSunf(int)` ([3b9894a5ea](https://github.com/InsightSoftwareConsortium/ITK/commit/3b9894a5ea))
- Remove `this->` and `static_cast<__int64>` from `RealTimeClock` ([61e6b3968a](https://github.com/InsightSoftwareConsortium/ITK/commit/61e6b3968a))
- Clean-up code Windows version default-constructor `RealTimeClock` ([1979a8002e](https://github.com/InsightSoftwareConsortium/ITK/commit/1979a8002e))
- Remove extra spaces between parentheses of CMake command calls ([7ba787a2d0](https://github.com/InsightSoftwareConsortium/ITK/commit/7ba787a2d0))
- Pass `bool` parameters by (const) value, not by `const` reference ([c9a24b1d03](https://github.com/InsightSoftwareConsortium/ITK/commit/c9a24b1d03))
- Pass numeric parameters by (const) value, not by const reference ([a2e5248a83](https://github.com/InsightSoftwareConsortium/ITK/commit/a2e5248a83))
- Call convenience member function, `ImageBase::SetRegions(region)` ([358f537627](https://github.com/InsightSoftwareConsortium/ITK/commit/358f537627))


### Paul Elliott (1):

#### Style Changes

- Use ReadImage and WriteImage in a few iterator examples ([cb436b8dd9](https://github.com/InsightSoftwareConsortium/ITK/commit/cb436b8dd9))


### Pranjal Sahu (23):

#### Enhancements

- Linux support for vector_container_from_array ([8e0aed0dca](https://github.com/InsightSoftwareConsortium/ITK/commit/8e0aed0dca))
- Adding SetPoints in PointSet for 1D input array ([6827360fa6](https://github.com/InsightSoftwareConsortium/ITK/commit/6827360fa6))
- Adding Set/GetCellsArray in Mesh ([ff3c0b604c](https://github.com/InsightSoftwareConsortium/ITK/commit/ff3c0b604c))
- Adding set/getstate in Python for Mesh serialization ([a8ca6fbd5c](https://github.com/InsightSoftwareConsortium/ITK/commit/a8ca6fbd5c))
- Adding test for Mesh serialization ([bf8336d965](https://github.com/InsightSoftwareConsortium/ITK/commit/bf8336d965))
- Adding set/getstate in Python for PointSet serialization ([22661e0e6f](https://github.com/InsightSoftwareConsortium/ITK/commit/22661e0e6f))
- Adding test for PointSet serialization ([6ec7adac49](https://github.com/InsightSoftwareConsortium/ITK/commit/6ec7adac49))
- Handle itk.ULL in _get_itk_pixelid for Windows ([5884998601](https://github.com/InsightSoftwareConsortium/ITK/commit/5884998601))
- Adding Support for Transform Serialization ([abc5b22de8](https://github.com/InsightSoftwareConsortium/ITK/commit/abc5b22de8))
- Adding Module Dependency for Windows Python Test ([375450227e](https://github.com/InsightSoftwareConsortium/ITK/commit/375450227e))
- Adding itk::PolyLineCell ([b7950e6b25](https://github.com/InsightSoftwareConsortium/ITK/commit/b7950e6b25))
- Adding changes for testing itk::PolyLineCell ([366c51e181](https://github.com/InsightSoftwareConsortium/ITK/commit/366c51e181))
- Initialize PolyLineCell with 2 points ([5b00720000](https://github.com/InsightSoftwareConsortium/ITK/commit/5b00720000))
- Moving PointSet Vector wrapping to itkPointSet.wrap ([bf53f05ed2](https://github.com/InsightSoftwareConsortium/ITK/commit/bf53f05ed2))
- Add InputSpaceName and OutputSpaceName in Transform ([05754850fd](https://github.com/InsightSoftwareConsortium/ITK/commit/05754850fd))
- Remove TransformType key from Transform serialization ([c7ed152db2](https://github.com/InsightSoftwareConsortium/ITK/commit/c7ed152db2))
- Add test for de-serialized transform output ([0da21c2aef](https://github.com/InsightSoftwareConsortium/ITK/commit/0da21c2aef))

#### Performance Improvements

- Set parameters in one function call ([9d7880b465](https://github.com/InsightSoftwareConsortium/ITK/commit/9d7880b465))

#### Platform Fixes

- Remove un-necessary wrapping to remove Windows warnings ([f2986ae944](https://github.com/InsightSoftwareConsortium/ITK/commit/f2986ae944))

#### Bug Fixes

- Use itk.ULL type for Python Windows test ([bbb5834cb8](https://github.com/InsightSoftwareConsortium/ITK/commit/bbb5834cb8))
- First set fixed parameters then parameters ([3e6352cec8](https://github.com/InsightSoftwareConsortium/ITK/commit/3e6352cec8))
- Solves intermittent corrupted cells during serialization ([d244d4bf71](https://github.com/InsightSoftwareConsortium/ITK/commit/d244d4bf71))

#### Style Changes

- Use proper capital letters following ITK convention ([22d0b9c688](https://github.com/InsightSoftwareConsortium/ITK/commit/22d0b9c688))


### Rafael Palomar (1):

#### Platform Fixes

- Add minimum version for double-conversion ([701c8c25ea](https://github.com/InsightSoftwareConsortium/ITK/commit/701c8c25ea))


### Roland Bruggmann (1):

#### Style Changes

- Member method DICOMParser::CloseFile added ([4b01ec460f](https://github.com/InsightSoftwareConsortium/ITK/commit/4b01ec460f))


### Sean McBride (15):

#### Enhancements

- deprecate INVALID_HANDLE_VALUE ([f120a3d770](https://github.com/InsightSoftwareConsortium/ITK/commit/f120a3d770))
- bug #3241: Add qfac and qto_xyz to itkNiftiImageIO metadata ([9eb4c1209d](https://github.com/InsightSoftwareConsortium/ITK/commit/9eb4c1209d))
- replaced all sprintf usage with safer snprintf ([6cb089d45f](https://github.com/InsightSoftwareConsortium/ITK/commit/6cb089d45f))

#### Platform Fixes

- added override keyword on a dtor ([b3c214d4d4](https://github.com/InsightSoftwareConsortium/ITK/commit/b3c214d4d4))
- fixed warning about missing override ([cf557c3891](https://github.com/InsightSoftwareConsortium/ITK/commit/cf557c3891))
- removed/replaced unneeded #includes ([89b973ed39](https://github.com/InsightSoftwareConsortium/ITK/commit/89b973ed39))
- changed a NULL to nullptr ([a4c648486c](https://github.com/InsightSoftwareConsortium/ITK/commit/a4c648486c))
- added missing HDF5 symbol mangling ([cb9952dde0](https://github.com/InsightSoftwareConsortium/ITK/commit/cb9952dde0))
- Remove GDCM-specific .gitattributes since they are in GDCM's own ([a88887e376](https://github.com/InsightSoftwareConsortium/ITK/commit/a88887e376))
- be sure to import GDCM's .gitattributes file ([007bfaf344](https://github.com/InsightSoftwareConsortium/ITK/commit/007bfaf344))
- Fixed issue #1821 by conditionalizing ITKGPUCommon_* per-OS ([ce936dee3e](https://github.com/InsightSoftwareConsortium/ITK/commit/ce936dee3e))

#### Bug Fixes

- fixed simultaneous read/write access of same ivar by different threads ([142e254ac4](https://github.com/InsightSoftwareConsortium/ITK/commit/142e254ac4))
- Protect itk::OutputWindow cerr usage with a mutex ([5844e03af0](https://github.com/InsightSoftwareConsortium/ITK/commit/5844e03af0))
- fixed threading bug, don't use vector<bool> from multiple threads ([915b8e48d8](https://github.com/InsightSoftwareConsortium/ITK/commit/915b8e48d8))

#### Style Changes

- removed obsolete and confusing old comment ([b53f1aae20](https://github.com/InsightSoftwareConsortium/ITK/commit/b53f1aae20))


### Simon Rit (1):

#### Platform Fixes

- add missing trailing semicolon after itkExceptionMacro ([01fa5a5b02](https://github.com/InsightSoftwareConsortium/ITK/commit/01fa5a5b02))


### Stephen R. Aylward (8):

#### Enhancements

- Bump TubeTK to v1.1rc01 which is targeted for ITKv5.3rc03 ([bb8dfff961](https://github.com/InsightSoftwareConsortium/ITK/commit/bb8dfff961))
- Bump TubeTK to v1.1 ([6cbaa15c07](https://github.com/InsightSoftwareConsortium/ITK/commit/6cbaa15c07))
- Updated to latest TubeTK that supports itk::BooleanStdVector ([5c91fcbd9e](https://github.com/InsightSoftwareConsortium/ITK/commit/5c91fcbd9e))
- Bump TubeTK to support pending ITK53rc04 release ([c8438e890f](https://github.com/InsightSoftwareConsortium/ITK/commit/c8438e890f))
- Update TubeTK to support Write3DImagesAs4DImage in python ([012ffc026d](https://github.com/InsightSoftwareConsortium/ITK/commit/012ffc026d))
- SurfaceSpatialObject templated over point type (#3417) ([6046668162](https://github.com/InsightSoftwareConsortium/ITK/commit/6046668162))
- Bump ITKMinimalPathExtraction tag ([7c222e40e7](https://github.com/InsightSoftwareConsortium/ITK/commit/7c222e40e7))

#### Bug Fixes

- Proper CastXML 0.45 hash for Windows ([dfa33a74c6](https://github.com/InsightSoftwareConsortium/ITK/commit/dfa33a74c6))


### Tabish Syed (1):

#### Enhancements

- Enable LZW compression ([93c7987b45](https://github.com/InsightSoftwareConsortium/ITK/commit/93c7987b45))


### Thomas Greer (1):

#### Platform Fixes

- Support VectorImage input to DisplacementFieldTransform ([447b82b5f0](https://github.com/InsightSoftwareConsortium/ITK/commit/447b82b5f0))


### Tom Birdsong (29):

#### Enhancements

- Expose kernel parameters in `DiscreteGaussianImageFilter` interface ([3c1b13d7a3](https://github.com/InsightSoftwareConsortium/ITK/commit/3c1b13d7a3))
- Add `FFTDiscreteGaussianImageFilter` ([a18d2e4887](https://github.com/InsightSoftwareConsortium/ITK/commit/a18d2e4887))
- Add `FFTDiscreteGaussianImageFilter` factory override ([50e5e9c124](https://github.com/InsightSoftwareConsortium/ITK/commit/50e5e9c124))
- Expand FFT Gaussian kernel options + improve test coverage ([93ad716eeb](https://github.com/InsightSoftwareConsortium/ITK/commit/93ad716eeb))
- Increase test coverage for `FFTDiscreteGaussianImageFilter` ([d1e7c9bac5](https://github.com/InsightSoftwareConsortium/ITK/commit/d1e7c9bac5))
- Expose FFT filter dimension traits ([f81d6636bc](https://github.com/InsightSoftwareConsortium/ITK/commit/f81d6636bc))
- Expose `itk::VariableLengthVector` operators in Python wrapping ([0e84a057ec](https://github.com/InsightSoftwareConsortium/ITK/commit/0e84a057ec))
- Expose FFT factory image template parameters ([10320a688d](https://github.com/InsightSoftwareConsortium/ITK/commit/10320a688d))
- Add configuration to disable Python factory loading ([3255ef0905](https://github.com/InsightSoftwareConsortium/ITK/commit/3255ef0905))
- Add ITKVkFFTBackend remote module ([72a00f42a1](https://github.com/InsightSoftwareConsortium/ITK/commit/72a00f42a1))
- Resolve remote module CMake failures ([b6ed27a1f5](https://github.com/InsightSoftwareConsortium/ITK/commit/b6ed27a1f5))
- Consider requested output region in FFT convolution ([999193a47b](https://github.com/InsightSoftwareConsortium/ITK/commit/999193a47b))
- Add ConvolutionImageFilter streaming test ([742d73a7f2](https://github.com/InsightSoftwareConsortium/ITK/commit/742d73a7f2))
- Add kernel helper methods to `itk::DiscreteGaussianImageFilter` ([74d01fa9b1](https://github.com/InsightSoftwareConsortium/ITK/commit/74d01fa9b1))
- Update `ApplyScriptToRemotes.sh` for Github auth token protocol ([9e9ee8a383](https://github.com/InsightSoftwareConsortium/ITK/commit/9e9ee8a383))
- Add utility scripts for managing remote modules ([4c282a4381](https://github.com/InsightSoftwareConsortium/ITK/commit/4c282a4381))
- Update list of http -> https links ([36fb451b05](https://github.com/InsightSoftwareConsortium/ITK/commit/36fb451b05))

#### Performance Improvements

- Reduce verbosity of `itk::GaussianOperator` warning ([a0890b1f13](https://github.com/InsightSoftwareConsortium/ITK/commit/a0890b1f13))

#### Platform Fixes

- Increase test coverage for `FFTDiscreteGaussianImageFilter` ([64f83128e9](https://github.com/InsightSoftwareConsortium/ITK/commit/64f83128e9))
- Resolve `itkDiscreteGaussianImageFilter` warnings ([49e929b0e2](https://github.com/InsightSoftwareConsortium/ITK/commit/49e929b0e2))
- Resolve MSVC Python stub file generation ([a1a95febf4](https://github.com/InsightSoftwareConsortium/ITK/commit/a1a95febf4))
- Fix license in `NiftiImageIOTest13.cxx` ([de2ff56bc1](https://github.com/InsightSoftwareConsortium/ITK/commit/de2ff56bc1))

#### Bug Fixes

- Fix `PythonVerifyGetOutputAPIConsistency` test on Windows ([bfee9962fe](https://github.com/InsightSoftwareConsortium/ITK/commit/bfee9962fe))
- Delete non-virtual function in DisplacementFieldTransform ([93a3b5174d](https://github.com/InsightSoftwareConsortium/ITK/commit/93a3b5174d))
- Re-add coverage for `itk::RegistrationParameterScales` types ([dd6daf20cf](https://github.com/InsightSoftwareConsortium/ITK/commit/dd6daf20cf))
- Fix largest possible output region in `itk::ConvolutionImageFilter` ([389a3748d7](https://github.com/InsightSoftwareConsortium/ITK/commit/389a3748d7))
- Remove broken warning in `itk::GaussianOperator` ([0f39902432](https://github.com/InsightSoftwareConsortium/ITK/commit/0f39902432))
- Add `itk::GaussianOperator` debug methods ([5c44b7f5e3](https://github.com/InsightSoftwareConsortium/ITK/commit/5c44b7f5e3))
- Copy to xarray by default ([880143236f](https://github.com/InsightSoftwareConsortium/ITK/commit/880143236f))


### Ziv Yaniv (2):

#### Documentation Updates

- Improve/correct TransformGeometryFilter documentation. ([9cc03219ee](https://github.com/InsightSoftwareConsortium/ITK/commit/9cc03219ee))

#### Bug Fixes

- GDCMImageIO accepted images with non-orthogonal direction cosine. ([75baa8eb04](https://github.com/InsightSoftwareConsortium/ITK/commit/75baa8eb04))


### Zlib-ng Upstream (2):

#### Miscellaneous Changes

- zlib-ng 2022-04-27 (d41f8ead) ([f2bb813e99](https://github.com/InsightSoftwareConsortium/ITK/commit/f2bb813e99))
- zlib-ng 2022-05-12 (41d67396) ([4cab5b3a50](https://github.com/InsightSoftwareConsortium/ITK/commit/4cab5b3a50))


### ferdymercury (1):

#### Enhancements

- Extend RawImage wrapper to other data types (#3190) ([c601abc1e3](https://github.com/InsightSoftwareConsortium/ITK/commit/c601abc1e3))




ITK Sphinx Examples Changes Since v5.3rc03
---------------------------------------------

### Andinet Enquobahrie (4):

#### Enhancements

- Add an example that demonstrates interfacing with NumPy ([d425d178](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d425d178))
- Update the notebook ([4151f1b5](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4151f1b5))
- Fix unit test ([1b1e53a1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/1b1e53a1))

#### Documentation Updates

- Update documentation files ([9bb1dec2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9bb1dec2))


### Andinet enquobahrie (3):

#### Enhancements

- Turn off Git protocol by default. ([8132a8d2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8132a8d2))
- Add documentation for the example ([d6a3af11](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d6a3af11))
- Add test and strengthen the documentation ([03ae7deb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/03ae7deb))


### Hans Johnson (3):

#### Platform Fixes

- ENABLE_QUICKVIEW code updates ([9ac0bafe](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9ac0bafe))
- Remove unnecessary shadow definition ([f1651b31](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f1651b31))
- Resolve deprecation warning for SphinxExamples ([6b9e0fea](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6b9e0fea))


### Jon Haitz Legarreta Gorroño (2):

#### Enhancements

- Switch Github Actions Linux environment ([e1c3d118](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e1c3d118))
- Switch Github Actions macOS environment ([ffdabca2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ffdabca2))


### Laryssa Abdala (1):

#### Enhancements

- Add example derivativeImage (#380) ([ff92cc65](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ff92cc65))


### Matt McCormick (14):

#### Enhancements

- Update Sphinx to 4.4.0 ([7c77f795](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7c77f795))
- Build documentation in CI with the Superbuild ([74f34732](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/74f34732))
- Migrate from gitstats to sphinx-contributors ([66cbdd66](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/66cbdd66))
- Update ITK to 5.3 RC 3 ([231ac876](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/231ac876))
- Update to ITK 5.3 RC 4 ([183fd56b](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/183fd56b))
- Bump CI itk-git-tag to v5.3rc04 ([7c195971](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7c195971))

#### Platform Fixes

- Sphinx warning node class 'meta' is already registered ([550f3b92](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/550f3b92))
- Address unused SPHINX_HTMLHELP_OUTPUT in superbuild ([4255ef27](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4255ef27))
- Add indentation for NumPy toctree ([cdb68bcf](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/cdb68bcf))
- Add ConvertNumPyArrayToitkImage.ipynb to Sphinx toctree ([8794c2df](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8794c2df))
- Add missing packages for testing notebooks ([308e31f6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/308e31f6))
- Bump CI Ubuntu version to 20.04 for newer Python ([f3da5eaf](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f3da5eaf))
- Downgrade itkwidgets from the alpha version for running in nbsphinx ([99a307fb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/99a307fb))
- Update itkwidgets to pre-release version ([d2f5264d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d2f5264d))


### Natalie Johnston (2):

#### Enhancements

- Add Python Example GlobalRegistrationOfTwoImages ([8b62ef28](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8b62ef28))

#### Style Changes

- Fixed Python styling ([91751ea9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/91751ea9))


### Niels Dekker (9):

#### Enhancements

- Add `ImageBufferAndIndexRange` example ([0ba28901](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0ba28901))

#### Documentation Updates

- Adjust title of `ImageBufferAndIndexRange` example ([65dee301](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/65dee301))

#### Style Changes

- Catch exceptions by _const_ reference ([851d5436](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/851d5436))
- Simplify C++ example of ReadAnImage by calling `itk::ReadImage` ([e714dbe5](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e714dbe5))
- Remove extra spaces between parentheses of CMake command calls ([94299f96](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/94299f96))
- Use `auto` for declaration of variables initialized by `New()` ([88b43bf9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/88b43bf9))
- Remove parameters from `main(int, char *[])` when both are unused ([792225c7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/792225c7))
- Replace postfix by prefix increment in C++ `for` loops ([0613c331](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0613c331))
- Use `${PROJECT_NAME}` as CMake target name of example projects ([b018c2bc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/b018c2bc))


### Paul Elliott (5):

#### Enhancements

- Removed sphinx-bootstrap-theme ([7f48a1ca](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7f48a1ca))
- Add pydata-sphinx-theme. Add example download link. ([3e44fd35](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3e44fd35))
- Higher res ITK logo. Edit navbar titles. ([ef64dae9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ef64dae9))

#### Miscellaneous Changes

- FIX: Update download example zip screenshots. ([73d60578](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/73d60578))
- FIX: avoid WARNING: image file not readable. ([9688054c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9688054c))


### Pranjal Sahu (3):

#### Enhancements

- Adding Python example to create mesh and cells ([88826a60](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/88826a60))
- Adding Set and Get CellData in Python example ([81f3b791](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/81f3b791))

#### Style Changes

- Changes for new code style ([3663efec](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3663efec))


### Tom Birdsong (23):

#### Enhancements

- Remove redundant ITK build step in docs CI ([74878f04](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/74878f04))
- Deploy docs to Fleek ([3325d7b6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3325d7b6))
- Adjust site dir for Fleek container reference ([a6e600a7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a6e600a7))
- Bump ITK version ([50d60aa6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/50d60aa6))
- `ScaleAnImage` Python example and baseline image update ([bed0f6bd](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/bed0f6bd))
- Add example on Python eager loading ([c9e16e9e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c9e16e9e))
- Add Python example for module loading printouts ([010dd230](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/010dd230))
- Bump ITK and change http to https ([9dc32aca](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9dc32aca))

#### Bug Fixes

- Fixes for HTML documentation ([0f025e3a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0f025e3a))
- Fix ITKDoxygenXML by copying instead of renaming directory ([2d080691](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2d080691))
- Use https protocol for Superbuild CI ([f1103ff8](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f1103ff8))
- Ignore breathe duplicate C++ warnings in docs CI ([19d77271](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/19d77271))
- Fix site unpack path ([7c084818](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7c084818))
- Remove comma ([8b0b3526](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8b0b3526))
- Update paths for Fleek source ([9d8a0780](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9d8a0780))
- Fix github actions variable ref ([a1f279d4](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a1f279d4))
- Revert deploy to Netlify ([2d8514bb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2d8514bb))
- Disable broken RegisterTwoPointSets tests ([9183236c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9183236c))
- Use Doxygen 5.2.0 archives rather than nightly ([2b44a1c8](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2b44a1c8))

#### Miscellaneous Changes

- Add .fleek.json ([5d192756](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5d192756))
- Set Fleek workdir reference ([d07c5936](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d07c5936))
- Move `.fleek.json` ([f6073eb6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f6073eb6))
- Copy `.fleek.json` ([3ac107a7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3ac107a7))




ITK Software Guide Changes Since v5.3rc03
---------------------------------------------

### Dženan Zukić (2):

#### Enhancements

- Update minimum CMake version ([f5304f0](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f5304f0))
- Make HTTP protocol the default in SuperBuild.cmake ([4f827f1](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/4f827f1))


### Jon Haitz Legarreta Gorroño (2):

#### Enhancements

- Use https instead of http when https works ([351ec22](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/351ec22))
- Switch Github Actions Linux environment ([ac80720](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/ac80720))


### Julien Jomier (3):

#### Enhancements

- Update new kitware logo ([733dabb](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/733dabb))

#### Style Changes

- Updated the contributors ([1d0a653](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1d0a653))
- Reverted back some contributions for clarity ([e21d83e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/e21d83e))


### Lee Newberg (4):

#### Documentation Updates

- clang-format of code samples and other minted changes ([dd10e33](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/dd10e33))

#### Style Changes

- Format Python code with black ([b041051](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/b041051))
- Format c++ code with clang-format ([061225e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/061225e))
- Use Python f" formatting ([cc3bbfc](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/cc3bbfc))


### Matt McCormick (3):

#### Enhancements

- Bump ITK to v5.3rc03 ([d833447](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d833447))
- Update ISBN for new publication ([7f6bf89](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/7f6bf89))
- Bump ITK version to v5.3rc04 ([9a94dc7](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/9a94dc7))


### Niels Dekker (1):

#### Enhancements

- Add "Trailing Return Types" section ([c64b23b](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/c64b23b))


### Tom Birdsong (1):

#### Bug Fixes

- Use https protocol for superbuild CI ([6cc25d0](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/6cc25d0))




Remote Module Changes Since v5.3rc03
---------------------------------------------

## AdaptiveDenoising:
### Hans Johnson (4):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([18f8aca](https://github.com/ntustison/ITKAdaptiveDenoising/commit/18f8aca))
- Modules need updated version of ITK ([b937680](https://github.com/ntustison/ITKAdaptiveDenoising/commit/b937680))

#### Bug Fixes

- ZScore computations invalid for small values ([4b6b444](https://github.com/ntustison/ITKAdaptiveDenoising/commit/4b6b444))

#### Style Changes

- enforce ITK style defined by clang-format ([c001c43](https://github.com/ntustison/ITKAdaptiveDenoising/commit/c001c43))



## AnalyzeObjectLabelMap:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([ece904d](https://github.com/InsightSoftwareConsortium/itkAnalyzeObjectMap/commit/ece904d))
- Remove inclusion of .hxx files as headers ([6501909](https://github.com/InsightSoftwareConsortium/itkAnalyzeObjectMap/commit/6501909))



## AnisotropicDiffusionLBR:
### Hans Johnson (3):

#### Platform Fixes

- Modules need updated version of ITK ([1d57bb6](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/1d57bb6))
- Remove inclusion of .hxx files as headers ([b66464f](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/b66464f))
- Avoid single value vector constructor ([66a74d2](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/66a74d2))



## BSplineGradient:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([170b959](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/170b959))
- Remove inclusion of .hxx files as headers ([ba1417c](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/ba1417c))



## BioCell:
### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([0ca0584](https://github.com/InsightSoftwareConsortium/ITKBioCell/commit/0ca0584))
- Modules need updated version of ITK ([4cef62a](https://github.com/InsightSoftwareConsortium/ITKBioCell/commit/4cef62a))



## BoneEnhancement:
### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([817e97c](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/817e97c))
- Modules need updated version of ITK ([68e550f](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/68e550f))



## BoneMorphometry:
### Dženan Zukić (1):

#### Platform Fixes

- Fix duplicate wrapping warnings. Closes #51. ([893b043](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/893b043))


### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([2a71b2b](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/2a71b2b))
- Remove inclusion of .hxx files as headers ([391e5bc](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/391e5bc))


### mrhardisty (1):

#### Miscellaneous Changes

- Fix Error in BsBv formula ([1c383c7](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/1c383c7))



## Cleaver:
### Matt McCormick (4):

#### Enhancements

- Build against ITK 5.3 RC 4 ([03f9c3f](https://github.com/SCIInstitute/ITKCleaver/commit/03f9c3f))
- Add WebAssembly interface ([5a0de71](https://github.com/SCIInstitute/ITKCleaver/commit/5a0de71))

#### Documentation Updates

- Add Jupyter notebook example ([9bb34f8](https://github.com/SCIInstitute/ITKCleaver/commit/9bb34f8))

#### Bug Fixes

- Expose OutputMeshType * GetOutput(index) ([a5b1d17](https://github.com/SCIInstitute/ITKCleaver/commit/a5b1d17))



## Cuberille:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([666c6ff](https://github.com/InsightSoftwareConsortium/ITKCuberille/commit/666c6ff))
- Remove inclusion of .hxx files as headers ([6b09611](https://github.com/InsightSoftwareConsortium/ITKCuberille/commit/6b09611))



## CudaCommon:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([350ce95](https://github.com/SimonRit/ITKCudaCommon/commit/350ce95))
- Remove inclusion of .hxx files as headers ([2fdd6d5](https://github.com/SimonRit/ITKCudaCommon/commit/2fdd6d5))


### LucasGandel (1):

#### Platform Fixes

- Add CUDA include dirs to CudaCommon_INCLUDE_DIRS ([8e2a7dc](https://github.com/SimonRit/ITKCudaCommon/commit/8e2a7dc))



## FixedPointInverseDisplacementField:
### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([76a08a0](https://github.com/InsightSoftwareConsortium/ITKFixedPointInverseDisplacementField/commit/76a08a0))
- Modules need updated version of ITK ([b540bb4](https://github.com/InsightSoftwareConsortium/ITKFixedPointInverseDisplacementField/commit/b540bb4))



## GenericLabelInterpolator:
### Dženan Zukić (1):

#### Enhancements

- update minimum required CMake version ([d804834](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/d804834))


### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([ffb2cd5](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/ffb2cd5))
- Remove inclusion of .hxx files as headers ([46fa11c](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/46fa11c))



## GrowCut:
### Hans Johnson (3):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([ca76baa](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/ca76baa))
- Modules need updated version of ITK ([9635539](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/9635539))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([c8db62a](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/c8db62a))


### Kian Weimer (3):

#### Platform Fixes

- Removed redundant variable declaration, resolving compiler shadow warning. ([dac251e](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/dac251e))
- Resolved shadowing of class member variables. ([1f0fdf7](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/1f0fdf7))
- Removed unused variables causing compiler warning. ([7e9959f](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/7e9959f))



## HASI:
### Dženan Zukić (7):

#### Enhancements

- Update required CMake and C++ standard to match ITK 5.3 ([3f286b8](https://github.com/KitwareMedical/HASI/commit/3f286b8))
- Add the overall segmentation pipeline in Python ([e255566](https://github.com/KitwareMedical/HASI/commit/e255566))
- Further changes identified from a complete run ([3b4e723](https://github.com/KitwareMedical/HASI/commit/3b4e723))
- Record per-label bone morphometry into a CSV file ([fae2e7d](https://github.com/KitwareMedical/HASI/commit/fae2e7d))
- Loop over all available atlases ([0f50ab5](https://github.com/KitwareMedical/HASI/commit/0f50ab5))

#### Bug Fixes

- Use subprocess invocation to avoid Elastix crash ([f3bdd31](https://github.com/KitwareMedical/HASI/commit/f3bdd31))

#### Style Changes

- remove unused code ([6eccaed](https://github.com/KitwareMedical/HASI/commit/6eccaed))


### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([3de4a2f](https://github.com/KitwareMedical/HASI/commit/3de4a2f))
- Remove inclusion of .hxx files as headers ([c349ec3](https://github.com/KitwareMedical/HASI/commit/c349ec3))


### Kian Weimer (1):

#### Platform Fixes

- Removed redundant type alias. ([9c9cbb7](https://github.com/KitwareMedical/HASI/commit/9c9cbb7))



## HigherOrderAccurateGradient:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([f75bd8e](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/f75bd8e))
- Remove inclusion of .hxx files as headers ([b57ee45](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/b57ee45))



## IOFDF:
### Hans Johnson (1):

#### Platform Fixes

- Modules need updated version of ITK ([0a17013](https://github.com/InsightSoftwareConsortium/ITKIOFDF/commit/0a17013))



## IOMeshSTL:
### Hans Johnson (1):

#### Platform Fixes

- Modules need updated version of ITK ([7841c13](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL/commit/7841c13))



## IOMeshSWC:



## IOScanco:
### Dženan Zukić (2):

#### Enhancements

- remove unsupported write extensions ([ebfcb2c](https://github.com/KitwareMedical/ITKIOScanco/commit/ebfcb2c))
- Make use of improvements in ImageIO file extensions ([a3afede](https://github.com/KitwareMedical/ITKIOScanco/commit/a3afede))


### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([f56c97b](https://github.com/KitwareMedical/ITKIOScanco/commit/f56c97b))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([3ac09fa](https://github.com/KitwareMedical/ITKIOScanco/commit/3ac09fa))



## IOTransformDCMTK:
### Hans Johnson (1):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([649da7a](https://github.com/InsightSoftwareConsortium/ITKIOTransformDCMTK/commit/649da7a))



## IsotropicWavelets:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([7e663c3](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/7e663c3))
- Remove inclusion of .hxx files as headers ([0f901b8](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/0f901b8))



## LabelErodeDilate:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([ee368c1](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/ee368c1))
- Remove inclusion of .hxx files as headers ([9cab6d5](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/9cab6d5))



## LesionSizingToolkit:
### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([0525c1d](https://github.com/InsightSoftwareConsortium/LesionSizingToolkit/commit/0525c1d))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([c1a8417](https://github.com/InsightSoftwareConsortium/LesionSizingToolkit/commit/c1a8417))



## MGHIO:
### Dženan Zukić (1):

#### Style Changes

- Standardize parameter names to argc and *argv[], replace ac/av ([b5b0d48](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/b5b0d48))


### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([645c035](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/645c035))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([8decfcf](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/8decfcf))


### Jean-Christophe Fillion-Robin (2):

#### Documentation Updates

- Fix reference to continuous integration in README ([b0e3c20](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/b0e3c20))
- Update description in README and include an History section ([7cac826](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/7cac826))


### Matt McCormick (2):

#### Enhancements

- Update CI for itk-5.3rc03 ([2309a73](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/2309a73))

#### Documentation Updates

- Update repository name to ISC repo naming convention ([a75c889](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/a75c889))



## MeshNoise:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([6cb12d8](https://github.com/InsightSoftwareConsortium/ITKMeshNoise/commit/6cb12d8))
- Remove inclusion of .hxx files as headers ([95cf585](https://github.com/InsightSoftwareConsortium/ITKMeshNoise/commit/95cf585))



## MeshToPolyData:
### Matt McCormick (2):

#### Enhancements

- Bump version in setup.py to 0.8.1 ([a8f6f9c](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/a8f6f9c))

#### Platform Fixes

- Remove unused variables ([18fce1a](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/18fce1a))



## MinimalPathExtraction:
### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([53110f3](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/53110f3))
- Modules need updated version of ITK ([8efc307](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/8efc307))


### Matt McCormick (1):

#### Enhancements

- Update Python package for itk-5.3rc4 ([ac79466](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/ac79466))


### Stephen R. Aylward (3):

#### Bug Fixes

- Set FastMarching targets prior to reach mode ([3639b9f](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/3639b9f))

#### Style Changes

- ITKHeader.h does not use https for apache license ([065eadf](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/065eadf))

#### Miscellaneous Changes

- Revert "STYLE: ITKHeader.h does not use https for apache license" ([1c96e27](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/1c96e27))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([c7cdbd8](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/c7cdbd8))



## Montage:
### Dženan Zukić (3):

#### Enhancements

- Use higher precision pixel accumulation type in Python wrapping ([5b77535](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/5b77535))

#### Platform Fixes

- Fix FFT factory failures by using a newer ITK in CI testing ([4ed5b60](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/4ed5b60))
- Update type correctness of point and vector math ([d4d7e4a](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/d4d7e4a))


### Hans Johnson (5):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([501ffd9](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/501ffd9))
- Modules need updated version of ITK ([d66f373](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/d66f373))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([7ad5492](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/7ad5492))
- Prefer itk::Math::abs for consistency. ([d595149](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/d595149))
- Match clang-format style ([c11ec2a](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/c11ec2a))


### Tom Birdsong (1):

#### Miscellaneous Changes

- Default to C++14 ([2ed2198](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/2ed2198))



## MorphologicalContourInterpolation:
### Dženan Zukić (2):

#### Enhancements

- Updating MCI for ITK 5.3RC3 ([37a9ede](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/37a9ede))

#### Style Changes

- Applying clang-format ([e518b40](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/e518b40))


### Hans Johnson (3):

#### Platform Fixes

- Modules need updated version of ITK ([c406c2c](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/c406c2c))
- Remove inclusion of .hxx files as headers ([36d7ca2](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/36d7ca2))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([aa4cf17](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/aa4cf17))



## MultipleImageIterator:
### Dženan Zukić (1):

#### Enhancements

- Fix CI (hashes MD5->SHA512, bump CMake version, ITK 5.3RC3) ([1571225](https://github.com/KitwareMedical/MultipleImageIterator/commit/1571225))


### Hans Johnson (1):

#### Platform Fixes

- Modules need updated version of ITK ([8fa63c8](https://github.com/KitwareMedical/MultipleImageIterator/commit/8fa63c8))



## ParabolicMorphology:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([4f64b7e](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/4f64b7e))
- Remove inclusion of .hxx files as headers ([18d15de](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/18d15de))



## PerformanceBenchmarking:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([026bc0a](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/026bc0a))
- Remove inclusion of .hxx files as headers ([f9a8dc2](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/f9a8dc2))



## PhaseSymmetry:
### Dženan Zukić (1):

#### Enhancements

- Update for ITK 5.3RC3. Bump version number. ([0b6993c](https://github.com/KitwareMedical/ITKPhaseSymmetry/commit/0b6993c))


### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([b9cedfe](https://github.com/KitwareMedical/ITKPhaseSymmetry/commit/b9cedfe))
- Remove inclusion of .hxx files as headers ([cb1d6b5](https://github.com/KitwareMedical/ITKPhaseSymmetry/commit/cb1d6b5))



## PolarTransform:
### Hans Johnson (3):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([48aa4ce](https://github.com/InsightSoftwareConsortium/ITKPolarTransform/commit/48aa4ce))
- Modules need updated version of ITK ([930d44a](https://github.com/InsightSoftwareConsortium/ITKPolarTransform/commit/930d44a))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([aa5f6a0](https://github.com/InsightSoftwareConsortium/ITKPolarTransform/commit/aa5f6a0))



## PrincipalComponentsAnalysis:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([e521ebe](https://github.com/InsightSoftwareConsortium/ITKPrincipalComponentsAnalysis/commit/e521ebe))
- Remove inclusion of .hxx files as headers ([d487781](https://github.com/InsightSoftwareConsortium/ITKPrincipalComponentsAnalysis/commit/d487781))



## RLEImage:
### Dženan Zukić (1):

#### Platform Fixes

- Fix assertion condition. It failed to compile in Debug mode. ([e18b8da](https://github.com/KitwareMedical/ITKRLEImage/commit/e18b8da))


### Hans Johnson (3):

#### Enhancements

- Use ITK .gitignore patterns for module ([1c46dc7](https://github.com/KitwareMedical/ITKRLEImage/commit/1c46dc7))

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([28ec5eb](https://github.com/KitwareMedical/ITKRLEImage/commit/28ec5eb))
- Modules need updated version of ITK ([26dde92](https://github.com/KitwareMedical/ITKRLEImage/commit/26dde92))



## RTK:
### Antoine Robert (2):

#### Enhancements

- Add convenience functions ReadGeometry and WriteGeometry ([1334e53c](https://github.com/SimonRit/RTK/commit/1334e53c))

#### Style Changes

- Use convenience functions for writing and reading image and geometry ([f34b10e4](https://github.com/SimonRit/RTK/commit/f34b10e4))


### Fernando Hueso-González (1):

#### Enhancements

- add SetImageIO to ProjectionsReader ([02913451](https://github.com/SimonRit/RTK/commit/02913451))


### Gabriele Belotti (1):

#### Style Changes

- Displaced Detector Filter variables name ([e3b56edf](https://github.com/SimonRit/RTK/commit/e3b56edf))


### GabrieleBelotti (1):

#### Documentation Updates

- Correct Parker reference and its implementation ([72238ee8](https://github.com/SimonRit/RTK/commit/72238ee8))


### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([4e48dc45](https://github.com/SimonRit/RTK/commit/4e48dc45))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([05f3ad2c](https://github.com/SimonRit/RTK/commit/05f3ad2c))


### Lucas Gandel (2):

#### Enhancements

- Build Cuda wheel on Linux self-hosted ([9aae2b3f](https://github.com/SimonRit/RTK/commit/9aae2b3f))
- Configure wheel name when CUDA is used ([1540c582](https://github.com/SimonRit/RTK/commit/1540c582))


### Simon Rit (29):

#### Enhancements

- upgrade CI for python packages to ITK v5.3rc03 ([e3b4d89a](https://github.com/SimonRit/RTK/commit/e3b4d89a))
- add Elekta synergy geometry wrapping and Python application ([d0b215f9](https://github.com/SimonRit/RTK/commit/d0b215f9))
- account for ImagingRing tilt available in newer versions ([5a1af896](https://github.com/SimonRit/RTK/commit/5a1af896))
- add test for Ora files with gantry tilt ([e35dd986](https://github.com/SimonRit/RTK/commit/e35dd986))
- update README.md file with target github action ([af809930](https://github.com/SimonRit/RTK/commit/af809930))
- Doxygen use svg and mathjax ([f2d5e950](https://github.com/SimonRit/RTK/commit/f2d5e950))
- Make Forbild phantom file reader locale insensitive ([942fa6f2](https://github.com/SimonRit/RTK/commit/942fa6f2))
- upgrade CI for python packages to ITK v5.3rc04 ([79b711ae](https://github.com/SimonRit/RTK/commit/79b711ae))
- add Windows Cuda CI ([e7ae96d9](https://github.com/SimonRit/RTK/commit/e7ae96d9))

#### Documentation Updates

- Update ITK Doxygen tarball URL ([f6393252](https://github.com/SimonRit/RTK/commit/f6393252))

#### Platform Fixes

- Include missing header includes in src files ([3a832edf](https://github.com/SimonRit/RTK/commit/3a832edf))
- fix compilation of external project depending on RTK with Cuda ([eff10ab1](https://github.com/SimonRit/RTK/commit/eff10ab1))
- set CMake vars for ITKCudaCommon targets ([4f33472e](https://github.com/SimonRit/RTK/commit/4f33472e))
- remove unused type warning ([c4c8c532](https://github.com/SimonRit/RTK/commit/c4c8c532))
- fix incorrect casts from scalar or vector to points ([abce7eee](https://github.com/SimonRit/RTK/commit/abce7eee))
- avoid implicit conversion from scalar to itk::Vector ([da1979ee](https://github.com/SimonRit/RTK/commit/da1979ee))
- remove unused wrapping of FDKWarpBackProjectionImageFilter ([4fa8de60](https://github.com/SimonRit/RTK/commit/4fa8de60))

#### Bug Fixes

- fix i-th ellipsoid of the Shepp Logan phantom ([33f8275b](https://github.com/SimonRit/RTK/commit/33f8275b))
- do not let tests write to the same temporary signal file ([40e40d7c](https://github.com/SimonRit/RTK/commit/40e40d7c))
- test compiled with rtk_add_cuda_test should use USE_CUDA ([f7dac1fe](https://github.com/SimonRit/RTK/commit/f7dac1fe))
- expect exception with Cuda conjugate gradient on CPU images ([7f23cbce](https://github.com/SimonRit/RTK/commit/7f23cbce))
- clone convex shapes to avoid double transformations ([6d73ac05](https://github.com/SimonRit/RTK/commit/6d73ac05))
- add missing checks after Cuda memory allocation ([fc9e8e2b](https://github.com/SimonRit/RTK/commit/fc9e8e2b))
- check matrix vector length before accessing an element ([d2d22bb9](https://github.com/SimonRit/RTK/commit/d2d22bb9))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([c759c9a9](https://github.com/SimonRit/RTK/commit/c759c9a9))
- fix clang-format style in a few RTK files ([a9bd58e7](https://github.com/SimonRit/RTK/commit/a9bd58e7))
- remove useless member for the union of 3 objects ([5522ddd3](https://github.com/SimonRit/RTK/commit/5522ddd3))
- Prefer error checked std::stod over atof ([e6c48ebc](https://github.com/SimonRit/RTK/commit/e6c48ebc))
- Prefer error checked std::stoi over atoi ([9f40cc05](https://github.com/SimonRit/RTK/commit/9f40cc05))



## SCIFIO:
### Hans Johnson (1):

#### Platform Fixes

- Modules need updated version of ITK ([42b30ee](https://github.com/scifio/scifio-imageio/commit/42b30ee))



## Shape:
### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([da29f7b](https://github.com/SlicerSALT/ITKShape/commit/da29f7b))
- Modules need updated version of ITK ([0714ffa](https://github.com/SlicerSALT/ITKShape/commit/0714ffa))



## SkullStrip:
### Hans Johnson (2):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([96bf689](https://github.com/InsightSoftwareConsortium/ITKSkullStrip/commit/96bf689))
- Modules need updated version of ITK ([9afa049](https://github.com/InsightSoftwareConsortium/ITKSkullStrip/commit/9afa049))



## SplitComponents:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([7d7a6f4](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/7d7a6f4))
- Remove inclusion of .hxx files as headers ([fc3601c](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/fc3601c))


### Tom Birdsong (4):

#### Enhancements

- Bump ITK to v5.3rc04 ([bbc62b1](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/bbc62b1))
- Update Python build versions ([4aa9248](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/4aa9248))
- Make ITK tags CI environment variables ([3dfd577](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/3dfd577))

#### Bug Fixes

- Remove quotes from PATH ([1942f48](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/1942f48))



## Strain:
### Dženan Zukić (1):

#### Platform Fixes

- Fix duplicate wrapping of ImageToImageFilter for IV->ICV case ([4fd046c](https://github.com/KitwareMedical/ITKStrain/commit/4fd046c))


### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([43d149f](https://github.com/KitwareMedical/ITKStrain/commit/43d149f))
- Remove inclusion of .hxx files as headers ([e7c920f](https://github.com/KitwareMedical/ITKStrain/commit/e7c920f))



## SubdivisionQuadEdgeMeshFilter:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([2250f62](https://github.com/InsightSoftwareConsortium/itkSubdivisionQuadEdgeMeshFilter/commit/2250f62))
- Remove inclusion of .hxx files as headers ([cb71f21](https://github.com/InsightSoftwareConsortium/itkSubdivisionQuadEdgeMeshFilter/commit/cb71f21))



## TextureFeatures:
### Hans Johnson (1):

#### Platform Fixes

- Modules need updated version of ITK ([8ff5106](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/8ff5106))



## Thickness3D:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([5aa7c26](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/5aa7c26))
- Remove inclusion of .hxx files as headers ([6830cad](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/6830cad))



## TotalVariation:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([16db3e4](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/16db3e4))
- Remove inclusion of .hxx files as headers ([8eb1673](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/8eb1673))


### Pablo Hernandez-Cerdan (1):

#### Platform Fixes

- Set the default CXX_STANDARD to 14 ([a9ba31a](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/a9ba31a))



## TubeTK:
### Hans Johnson (2):

#### Platform Fixes

- Modules need updated version of ITK ([6949dd84](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/6949dd84))
- Remove inclusion of .hxx files as headers ([88da3195](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/88da3195))


### Kian Weimer (8):

#### Platform Fixes

- Fixed compiler warnings for tubeWriteTubesAsPolyData. ([8c5d55f0](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/8c5d55f0))
- Resolved compiler warnings for itktubeRadiusExtractor3. ([68b126a3](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/68b126a3))
- Removed unused variable for itkAnisotropicSimilarityLandmarkBasedTransformInitializer. ([b9df7a3f](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b9df7a3f))
- Resolved compiler warnings for itktubePointBasedSpatialObjectToImageMetric. ([6435e55b](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/6435e55b))
- Removed several redundant typename statements. ([2a726763](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/2a726763))
- Removed unused typedefs from test files. ([f5596d88](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/f5596d88))
- Converted while loop to for loop to prevent later name shadowing. ([409dd089](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/409dd089))
- Removed many unused max and min variables. ([028f56de](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/028f56de))


### Stephen R. Aylward (21):

#### Enhancements

- Improved methods and examples for CTA processing ([a36f38eb](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/a36f38eb))
- Bump TubeTK Version ([2a85aef3](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/2a85aef3))
- Upgrade wheels to use ITK53rc02 ([b03e89b4](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b03e89b4))
- Provide a demo of manipulating the radius of tubes in python ([8f3a3e26](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/8f3a3e26))
- Add support for 2D images in the python wrapped RegisterImages ([f1de8eea](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/f1de8eea))
- Update baselines for ITKv53rc03 ([a0cccc97](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/a0cccc97))
- Include documentation file for pypi wheels (#102) ([8565a00f](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/8565a00f))
- Add building of python wheels for Python 3.7 and 3.8 on Linux (#104) ([0dfead80](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/0dfead80))
- Bump version to TubeTK v1.1 ([8567b0f9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/8567b0f9))
- Provide a more complete PyPI description ([fa9d2bf9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/fa9d2bf9))
- ValidTimeStep is back to being a bool.  ENH: Github Workflow build using ITK master ([7d643c7f](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/7d643c7f))
- Updates to work with ITKv5.3rc04 (#108) ([c33ba00b](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/c33ba00b))
- Enable specification of target Size for image resampling (#109) ([549e2c56](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/549e2c56))

#### Platform Fixes

- Updating to match API change in ITK for ValidTimeStep (#99) ([a8a0ed3f](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/a8a0ed3f))
- Reduce the templating of ImageMath python wrapping to save memory and increase swap size (#101) ([a2efaca7](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/a2efaca7))

#### Bug Fixes

- Missing typename's ([1a0e7112](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/1a0e7112))
- Template specification not needed ([ec011a32](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/ec011a32))
- SlicerExecutionModel not finding ITK - updating path ([3a50c1f8](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/3a50c1f8))
- Fix spelling of setup-readme.md ([bcac5b2f](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/bcac5b2f))
- Update Write4D python API to support python ITK Image args ([6bce62f9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/6bce62f9))

#### Style Changes

- Fixed spelling mistake ([2455f836](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/2455f836))



## TwoProjectionRegistration:
### Hans Johnson (3):

#### Platform Fixes

- Modules need updated version of ITK ([f153180](https://github.com/InsightSoftwareConsortium/ITKTwoProjectionRegistration/commit/f153180))
- Remove inclusion of .hxx files as headers ([93708fa](https://github.com/InsightSoftwareConsortium/ITKTwoProjectionRegistration/commit/93708fa))

#### Style Changes

- Prefer itk::Math::abs for consistency. ([8e77598](https://github.com/InsightSoftwareConsortium/ITKTwoProjectionRegistration/commit/8e77598))



## Ultrasound:
### Dženan Zukić (23):

#### Enhancements

- Update the minimum required version of CMake to match ITK 5.3 ([0a46a65](https://github.com/KitwareMedical/ITKUltrasound/commit/0a46a65))
- Use override for destructors and = default where appropriate ([eec7bf1](https://github.com/KitwareMedical/ITKUltrasound/commit/eec7bf1))
- Adding Spectra1DAveragingImageFilter ([d347bd4](https://github.com/KitwareMedical/ITKUltrasound/commit/d347bd4))
- Adding Spectra1DNormalizeImageFilter ([814944b](https://github.com/KitwareMedical/ITKUltrasound/commit/814944b))
- Compute single attenuation number using image to histogram filter ([99ad524](https://github.com/KitwareMedical/ITKUltrasound/commit/99ad524))
- do not recompute variables in ComputeAttenuation method ([f158edc](https://github.com/KitwareMedical/ITKUltrasound/commit/f158edc))
- Reduce large safety erosion at segment end ([03a1d39](https://github.com/KitwareMedical/ITKUltrasound/commit/03a1d39))
- Always compress mask output ([a51810d](https://github.com/KitwareMedical/ITKUltrasound/commit/a51810d))
- Compute attenuation from all pairs using inverted Gaussian weights ([8e84789](https://github.com/KitwareMedical/ITKUltrasound/commit/8e84789))
- Simplify the code a little ([e911cac](https://github.com/KitwareMedical/ITKUltrasound/commit/e911cac))
- Add two new (simpler) computation modes ([acc89db](https://github.com/KitwareMedical/ITKUltrasound/commit/acc89db))
- Do not run the filter twice ([e310816](https://github.com/KitwareMedical/ITKUltrasound/commit/e310816))
- Expose computation mode parameter in the test ([f2818b0](https://github.com/KitwareMedical/ITKUltrasound/commit/f2818b0))
- Add tests and baseline outputs for new computation modes ([9e20e7c](https://github.com/KitwareMedical/ITKUltrasound/commit/9e20e7c))
- Remove zeroes if not considering negative values ([71d1368](https://github.com/KitwareMedical/ITKUltrasound/commit/71d1368))
- Allow to run AttenuationImageFilter without a mask ([c8e529e](https://github.com/KitwareMedical/ITKUltrasound/commit/c8e529e))
- Start and end of a segment are more informative than midpoint only ([b0bad37](https://github.com/KitwareMedical/ITKUltrasound/commit/b0bad37))

#### Platform Fixes

- Fix compile error about VariableLengthVector ([b8a8ecc](https://github.com/KitwareMedical/ITKUltrasound/commit/b8a8ecc))

#### Bug Fixes

- Make the attenuation test work with mask values other than 1 ([e4a0665](https://github.com/KitwareMedical/ITKUltrasound/commit/e4a0665))
- Do not compute attenuation if segment is completely eroded away ([4ed2a5e](https://github.com/KitwareMedical/ITKUltrasound/commit/4ed2a5e))

#### Style Changes

- Update clang-format style definition to match ITK ([6da99f7](https://github.com/KitwareMedical/ITKUltrasound/commit/6da99f7))
- Reduce white space in itkAttenuationImageFilter.h ([fa83c85](https://github.com/KitwareMedical/ITKUltrasound/commit/fa83c85))

#### Miscellaneous Changes

- Quote sys.executable path in PlotPowerSpectra because of spaces in name ([4167992](https://github.com/KitwareMedical/ITKUltrasound/commit/4167992))


### Hans Johnson (1):

#### Platform Fixes

- Remove inclusion of .hxx files as headers ([382b074](https://github.com/KitwareMedical/ITKUltrasound/commit/382b074))


### Jean-Christophe Fillion-Robin (7):

#### Platform Fixes

- ITKv5 no longer supports legacy method signatures for VNL ([811104f](https://github.com/KitwareMedical/ITKUltrasound/commit/811104f))
- Fix -Wunused-parameter in itkBlockMatching classes ([162f921](https://github.com/KitwareMedical/ITKUltrasound/commit/162f921))
- Fix -Wreorder in itkBlockMatchingDisplacementPipeline ([4390a23](https://github.com/KitwareMedical/ITKUltrasound/commit/4390a23))
- Fix -fpermissive error in StrainWindowBlockAffineTransformCommand ([265d190](https://github.com/KitwareMedical/ITKUltrasound/commit/265d190))
- Fix -fpermissive error in OptimizingInterpolationDisplacementCalculator ([d21d74f](https://github.com/KitwareMedical/ITKUltrasound/commit/d21d74f))
- Update StrainWindowBlockAffineTransformCommand::SetStrainImage constness ([cb285e0](https://github.com/KitwareMedical/ITKUltrasound/commit/cb285e0))
- Fix -Woverloaded-virtual in MultiResolutionIterationCommand ([6012bf0](https://github.com/KitwareMedical/ITKUltrasound/commit/6012bf0))


### Tom Birdsong (16):

#### Enhancements

- Move Vnl and FFTW 1D FFT classes to ITK proper ([4c631f1](https://github.com/KitwareMedical/ITKUltrasound/commit/4c631f1))
- Fix CI. Bump ITK Python to v5.3rc03. Add symlinks to TBB sources. ([0c917ce](https://github.com/KitwareMedical/ITKUltrasound/commit/0c917ce))
- Add curvilinear image factory manual registration for testing ([8dfad42](https://github.com/KitwareMedical/ITKUltrasound/commit/8dfad42))
- Add `itk::AttenuationImageFilter` ([fb31c11](https://github.com/KitwareMedical/ITKUltrasound/commit/fb31c11))
- Generate output mask for attenuation statistics ([46f2c99](https://github.com/KitwareMedical/ITKUltrasound/commit/46f2c99))
- Add practical data tests ([d7ffd0e](https://github.com/KitwareMedical/ITKUltrasound/commit/d7ffd0e))
- Bump to ITK v5.3rc04 ([06f791c](https://github.com/KitwareMedical/ITKUltrasound/commit/06f791c))
- Make ITK tags CI environment variable ([06732c0](https://github.com/KitwareMedical/ITKUltrasound/commit/06732c0))

#### Documentation Updates

- Add RF attenuation statistics example ([a616e90](https://github.com/KitwareMedical/ITKUltrasound/commit/a616e90))

#### Bug Fixes

- Temporary workaround for wrapping failure ([b6335eb](https://github.com/KitwareMedical/ITKUltrasound/commit/b6335eb))
- Make ITKVideo modules test dependencies ([ffd62fb](https://github.com/KitwareMedical/ITKUltrasound/commit/ffd62fb))
- Set module wrapping order ([b4ea164](https://github.com/KitwareMedical/ITKUltrasound/commit/b4ea164))
- `Spectra1DAveragingImageFilter` iterator fix ([e836049](https://github.com/KitwareMedical/ITKUltrasound/commit/e836049))
- Fix `itk::AttenuationImageFilter` region threading ([1bc9bec](https://github.com/KitwareMedical/ITKUltrasound/commit/1bc9bec))
- Make ITKTestKernel a test dependency ([0094c63](https://github.com/KitwareMedical/ITKUltrasound/commit/0094c63))
- Fix Windows CI grep path ([2ba0431](https://github.com/KitwareMedical/ITKUltrasound/commit/2ba0431))



## VkFFTBackend:
### Lee Newberg (2):

#### Platform Fixes

- Format code to address clang_format warnings ([972ad64](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/972ad64))
- Update clang-format-linter.yml to match ITK ([cc15af1](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/cc15af1))


### Tom Birdsong (9):

#### Enhancements

- Add script for FFT benchmarking ([00fe715](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/00fe715))
- Add Gaussian blur benchmarking notebook ([6e24b23](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/6e24b23))
- Bump to ITK v5.3rc04 ([18b4ebd](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/18b4ebd))
- Make ITK tags CI environment variables ([fe54f06](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/fe54f06))
- Add default factory initialization ([3f1083e](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/3f1083e))
- Bump ITKVkFFTBackend to v0.1.4 ([5c2b5b4](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/5c2b5b4))
- Add Python factory override test ([7d48a62](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/7d48a62))
- Add example demonstrating FFT convolution over a subregion ([30ca3f0](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/30ca3f0))
- Benchmark FFT Gaussian blurring with different kernel sizes ([2b82d04](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/2b82d04))
