dnl Licensed under the Apache License, Version 2.0 (the "License");
dnl you may not use this file except in compliance with the License.
dnl You may obtain a copy of the License at
dnl 
dnl     http://www.apache.org/licenses/LICENSE-2.0
dnl 
dnl Unless required by applicable law or agreed to in writing, software
dnl distributed under the License is distributed on an "AS IS" BASIS,
dnl WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
dnl See the License for the specific language governing permissions and
dnl limitations under the License.
dnl 
dnl Authors:
dnl 2010-
dnl     Oscar Koeroo <okoeroo@nikhef.nl>
dnl     Mischa Sall\'e <msalle@nikhef.nl>
dnl     NIKHEF Amsterdam, the Netherlands


dnl Usage:
dnl AC_GLOBUS(<package>,[when found],[when not found])
dnl Variables for pkg-config:
dnl   GLOBUS_<package>_CFLAGS
dnl   GLOBUS_<package>_LIBS
dnl Variables when direct:
dnl   GLOBUS_<package>_NOTHR_CFLAGS
dnl   GLOBUS_<package>_NOTHR_LIBS
dnl NOTE: GLOBUS_CFLAGS etc are NOT set.
AC_DEFUN([AC_GLOBUS],
[
    AC_REQUIRE([AC_GLOBUS_INIT])

    AC_GLOBUS_$1([$2],[$3])

    dnl note: need two if's to prevent empty then clause or empty else clause
    ifelse([$2],[],[],[
	if test "[x$have_globus_]translit($1,[A-Z],[a-z])" = "xyes" ; then
	    $2
	fi
    ])
    ifelse([$3],[],[],[
	if test "[x$have_globus_]translit($1,[A-Z],[a-z])" != "xyes" ; then
	    $3
	fi
    ])
])

dnl sets up the --with-globus-* flags and defines all macros
AC_DEFUN([AC_GLOBUS_INIT],
[
    AC_ARG_WITH(globus_prefix,
	[AC_HELP_STRING([--with-globus-prefix=PFX],
			[prefix where GLOBUS is installed.])],
	[ac_globus_prefix=$with_globus_prefix],
        [ac_globus_prefix=${GLOBUS_LOCATION:-}])

    AC_ARG_WITH(globus_libdir,
	[AC_HELP_STRING([--with-globus-libdir=DIR],
			[directory where GLOBUS libraries are installed (default either GLOBUS-PREFIX/lib or GLOBUS-PREFIX/lib64).])],
	[ac_globus_libdir=$with_globus_libdir],
        [])

    AC_ARG_WITH(globus_flavor,
	[AC_HELP_STRING([--with-globus-flavor],
		        [globus flavor])],
	[],
        [with_globus_flavor=${GLOBUS_FLAVOR:-}])

    AC_ARG_WITH(globus_thr_flavor,
	[AC_HELP_STRING([--with-globus-thr-flavor],
		        [globus threaded flavor])],
	[],
        [with_globus_thr_flavor=${GLOBUS_FLAVOR:-}])

    AC_ARG_WITH(globus_nothr_flavor,
	[AC_HELP_STRING([--with-globus-nothr-flavor],
		        [globus non-threaded flavor])],
	[],
        [with_globus_nothr_flavor=${GLOBUS_FLAVOR:-}])

    AC_ARG_WITH(globus_flavorincdir,
	[AC_HELP_STRING([--with-globus-flavorincdir],
		        [flavored includedir, i.e. location of globus_config.h])],
	[ac_globus_flavorincdir=$with_globus_flavorincdir],
        [with_globus_flavorincdir=${GLOBUS_FLAVOR:-}])

    AC_GLOBUS_DEFINE_MODULE([globus-core],[],[globus_config.h])
    AC_GLOBUS_DEFINE_MODULE([globus-callout],[globus_callout],[globus_callout.h])
    dnl Note: globus-version is part of globus-common-progs
    AC_GLOBUS_DEFINE_MODULE([globus-common],[globus_common],[globus_common.h])

    AC_GLOBUS_DEFINE_MODULE([globus-ftp-client],[globus_ftp_client],[globus_ftp_client.h])
    AC_GLOBUS_DEFINE_MODULE([globus-ftp-control],[globus_ftp_control],[globus_ftp_control.h])

    AC_GLOBUS_DEFINE_MODULE([globus-gsi-callback],[globus_gsi_callback],[globus_gsi_callback.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gsi-cert-utils],[globus_gsi_cert_utils],[globus_gsi_cert_utils.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gsi-credential],[globus_gsi_credential],[globus_gsi_credential.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gsi-openssl-error],[globus_openssl_error],[globus_error_openssl.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gsi-proxy-core],[globus_gsi_proxy_core],[globus_gsi_proxy.h])
    dnl Note next libname
    AC_GLOBUS_DEFINE_MODULE([globus-gsi-proxy-ssl],[globus_proxy_ssl],[proxypolicy.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gsi-sysconfig],[globus_gsi_sysconfig],[globus_gsi_system_config.h])

    AC_GLOBUS_DEFINE_MODULE([globus-gssapi-gsi],[globus_gssapi_gsi],[gssapi.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gss-assist],[globus_gss_assist],[globus_gss_assist.h])

    AC_GLOBUS_DEFINE_MODULE([globus-gass-transfer],[globus_gass_transfer],[globus_gass_transfer.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gass-server-ez],[globus_gass_server_ez],[globus_gass_server_ez.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gass-copy],[globus_gass_copy],[globus_gass_copy.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gass-cache],[globus_gass_cache],[globus_gass_cache.h])

    AC_GLOBUS_DEFINE_MODULE([globus-gram-client],[globus_gram_client],[globus_gram_client.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gram-job-manager-callout-error],[globus_gram_job_manager_callout_error],[globus_gram_jobmanager_callout_error.h])
    AC_GLOBUS_DEFINE_MODULE([globus-gram-protocol],[globus_gram_protocol],[globus_gram_protocol.h])

    AC_GLOBUS_DEFINE_MODULE([globus-io],[globus_io],[globus_io.h])

    dnl GLOBUS_OPENSSL
    AC_GLOBUS_DEFINE_MODULE([globus-openssl-module],[globus_openssl],[globus_openssl.h])

    AC_GLOBUS_DEFINE_MODULE([globus-rls-client],[globus_rls_client],[globus_rls_client.h])

    AC_GLOBUS_DEFINE_MODULE([globus-rsl],[globus_rsl],[globus_rsl.h])
    AC_GLOBUS_DEFINE_MODULE([globus-rsl-assist],[globus_rsl_assist],[globus_rsl_assist.h])

    AC_GLOBUS_DEFINE_MODULE([globus-xio],[globus_xio],[globus_xio.h])
    AC_GLOBUS_DEFINE_MODULE([globus-xio-gsi-driver],[globus_xio_gsi_driver],[globus_xio_gsi.h])
    AC_GLOBUS_DEFINE_MODULE([globus-xio-popen-driver],[globus_xio_popen_driver],[globus_xio_popen_driver.h])
    AC_GLOBUS_DEFINE_MODULE([globus-xio-pipe-driver],[globus_xio_pipe_driver],[globus_xio_pipe_driver.h])

    AC_GLOBUS_DEFINE_MODULE([globus-gridmap-callout-error],[globus_gridmap_callout_error],[globus_gridmap_callout_error.h])
  
    dnl Have to do AC_GLOBUS_GSSAPI_ERROR by hand, since it depends on the
    dnl globus version
    AC_DEFUN([AC_GLOBUS_GSSAPI_ERROR],
    [
	if test "x$ac_globus_major" = "x4" ; then
	    AC_GLOBUS_CHECK_MODULE([globus-gssapi-error],[gssapi_error],[globus_error_gssapi.h])
	else
	    AC_GLOBUS_CHECK_MODULE([globus-gssapi-error],[globus_gssapi_error],[globus_error_gssapi.h])
	fi
    ])
])

dnl this macro defines macro AC_GLOBUS_<package> which calls
dnl AC_GLOBUS_CHECK_MODULE(<package>...)
dnl $1 - package / module name for pkg-config (with -)
dnl $2 - library name (with _)
dnl $3 - header file name
AC_DEFUN([AC_GLOBUS_DEFINE_MODULE],
[
    AC_DEFUN([AC_]translit($1,[a-z-],[A-Z_]),
    [
	AC_GLOBUS_CHECK_GLOBUS
	AC_GLOBUS_CHECK_MODULE(]$1[,]$2[,]$3[)
    ])
])

dnl This macro defines the general globus check, e.g. version etc.
dnl It is only called once
AC_DEFUN([AC_GLOBUS_CHECK_GLOBUS],
[
    AS_IF([test "x$globus_tested" = "x"],
    [
	dnl Make sure we only check once, cannot do this with AC_DEFUN_ONCE or
	dnl AC_REQUIRE since that would also trigger these tests in
	dnl disable-gsi-mode
	globus_tested="yes"

	dnl Check (non)threaded flavor flags and export if set, bail out when both
	if test "x$with_globus_thr_flavor" != "x" ; then
	    if test "x$with_globus_nothr_flavor" != "x" -o
	       test "x$with_globus_flavor" != "x" ; then
		AC_MSG_FAILURE([Cannot build against multiple flavor types])
	    fi
	    ac_globus_flavor=$with_globus_thr_flavor
	    GLOBUS_THR_FLAVOR=$with_globus_thr_flavor
	elif test "x$with_globus_nothr_flavor" != "x" ; then
	    if test "x$with_globus_flavor" != "x" ; then
		AC_MSG_FAILURE([Cannot build against multiple flavor types])
	    fi
	    ac_globus_flavor=$with_globus_nothr_flavor
	    GLOBUS_NOTHR_FLAVOR=$with_globus_nothr_flavor
	elif test "x$with_globus_flavor" != "x" ; then
	    ac_globus_flavor=$with_globus_flavor
	    GLOBUS_FLAVOR=$with_globus_flavor
	fi
	AC_SUBST(GLOBUS_FLAVOR)
	AC_SUBST(GLOBUS_THR_FLAVOR)
	AC_SUBST(GLOBUS_NOTHR_FLAVOR)

	dnl Prefer packaged globus in /usr to /opt/globus
	if test "x$ac_globus_prefix" = "x" -a -d /usr/include/globus ; then
	    ac_globus_prefix=/usr
	fi

	if test "x$ac_globus_prefix" = "x" -a -d /opt/globus ; then
	    ac_globus_prefix=/opt/globus
	fi

	dnl Note: globus-version is part of globus-common-progs
	AC_MSG_CHECKING([for globus version])
	if test "x$ac_globus_prefix" = "x" ; then
	    ac_globus_version_script=`which globus-version 2> /dev/null`
	else
	    ac_globus_version_script=$ac_globus_prefix/bin/globus-version
	fi
	if test "x$ac_globus_version_script" != "x" ; then
	    ac_globus_version=`grep 'GLOBUS_VERSION=' $ac_globus_version_script | head -1 | cut -d'"' -f2`
	fi
	AC_MSG_RESULT([$ac_globus_version])

	if test "x$ac_globus_version" != "x" ; then
	    ac_globus_major=`echo $ac_globus_version|cut -d. -f1`
	    ac_globus_minor=`echo $ac_globus_version|cut -d. -f2`
	    ac_globus_release=`echo $ac_globus_version|cut -d. -f3`
	fi

	if test "x$ac_globus_prefix" != "x" ; then
	    dnl Determine libdir if not yet known
	    if test "x$ac_globus_libdir" = "x" ; then
		dnl Check: arch==x86_64, lib64 exists as non-symlink
		dnl Also check it has libglobus* files, in case we have a 
		dnl mixed /lib and /lib64 setup
		if test "x$host_cpu" = "xx86_64" \
		     -a -e $ac_globus_prefix/lib64 \
		     -a ! -h $ac_globus_prefix/lib64 ; then
		    num=`find $ac_globus_prefix/lib64 -name "libglobus*"|wc -l`
		    if test $num -gt 0 ; then
			ac_globus_libdir="$ac_globus_prefix/lib64"
		    else
			ac_globus_libdir="$ac_globus_prefix/lib"
		    fi
		else
		    ac_globus_libdir="$ac_globus_prefix/lib"
		fi
	    fi
	    ac_globus_ldflags="-L$ac_globus_libdir"

	    dnl From GT5.1 to GT5.2 headers are now in include/globus, also covers EPEL
	    if test -d "$ac_globus_prefix/include/globus" ; then
		ac_globus_cflags=-I$ac_globus_prefix/include/globus 
		dnl Figure out flavor include dir
		if test "x$ac_globus_flavorincdir" != "x" ; then
		    ac_globus_cflags="$ac_globus_cflags -I$ac_globus_flavorincdir"
		elif test "x$ac_globus_flavor" != "x" ; then
		    ac_globus_cflags="$ac_globus_cflags -I$ac_globus_prefix/include/globus/$ac_globus_flavor"
		else
		    dnl Need <globus_libdir>/globus/include for EPEL
		    ac_globus_cflags="$ac_globus_cflags -I$ac_globus_libdir/globus/include"
		fi
		dnl These versions all use libraries without flavor
		ac_globus_libsuffix=""
	    dnl Next ones either use flavor or don't use /globus/, such as GT6
	    else
		dnl These versions use libraries with flavor, set it here
		if test "x$ac_globus_flavor" != "x" ; then
		    ac_globus_cflags=-I$ac_globus_prefix/include/$ac_globus_flavor
		    ac_globus_libsuffix=_$ac_globus_flavor
		dnl Next one is GT6
		elif test -d "$ac_globus_prefix/include"; then
		    ac_globus_cflags=-I$ac_globus_prefix/include
		dnl Assume system directory
		else    dnl EPEL case falls under the 5.2 behaviour
		    ac_globus_cflags=""
		    ac_globus_libsuffix=""
		fi
	    fi
	fi
    ],[])
])

dnl this macro checks for module $1 either direct via GLOBUS_DIRECT_CHECK_MODULES
dnl or via PKG_CHECK_MODULES
dnl $1 - module name for pkg-config (with -)
dnl $2 - library name (with _)
dnl $3 - header file name
AC_DEFUN([AC_GLOBUS_CHECK_MODULE],
[
    dnl Make sure autoconf (bootstrap) fails when macro is undefined
    ifdef([PKG_CHECK_MODULES],
          [],
          [m4_fatal([macro PKG_CHECK_MODULES is not defined])])

    if test "x$with_globus_prefix" = "x" ; then
	PKG_CHECK_MODULES(translit($1,[a-z-],[A-Z_]), $1, have_globus_mod=yes, have_globus_mod=no)
	if test "$have_globus_mod" = "no" ; then
	    GLOBUS_DIRECT_CHECK_MODULES(translit($1,[a-z-],[A-Z_]), $2, $3, have_globus_mod=yes, have_globus_mod=no)
	fi
    else
	GLOBUS_DIRECT_CHECK_MODULES(translit($1,[a-z-],[A-Z_]), $2, $3, have_globus_mod=yes, have_globus_mod=no)
	if test "$have_globus_mod" = "no" ; then
	    PKG_CHECK_MODULES(translit($1,[a-z-],[A-Z_]), $1, have_globus_mod=yes, have_globus_mod=no)
	fi
    fi
    [have_]translit($1,[-],[_])=$have_globus_mod
    AC_SUBST(translit($1,[a-z-],[A-Z_])_CFLAGS)
    AC_SUBST(translit($1,[a-z-],[A-Z_])_LIBS)
    AC_SUBST(translit($1,[a-z-],[A-Z_])_THR_CFLAGS)
    AC_SUBST(translit($1,[a-z-],[A-Z_])_THR_LIBS)
    AC_SUBST(translit($1,[a-z-],[A-Z_])_NOTHR_CFLAGS)
    AC_SUBST(translit($1,[a-z-],[A-Z_])_NOTHR_LIBS)
])

dnl this macro checks for module $1 trying to link against $2 and including
dnl header $3
dnl $1 - capitalized module name
dnl $2 - lib/module name (with _)
dnl $3 - header file name
dnl $4 - have_globus_mod = yes
dnl $5 - have_globus_mod = no
AC_DEFUN([GLOBUS_DIRECT_CHECK_MODULES],
[
    ac_save_CFLAGS=$CFLAGS
    ac_save_CPPFLAGS=$CPPFLAGS
    ac_save_LIBS=$LIBS
    ac_save_LDFLAGS=$LDFLAGS

    ac_try_CFLAGS=$ac_globus_cflags

    if test "x$2" = "x" ; then
	ac_try_LIBS=""
    else
	ac_try_LIBS="-l$2$ac_globus_libsuffix"
    fi

    ac_try_CPPFLAGS=$ac_try_CFLAGS
    if test "x$ac_globus_libdir" != "x" ; then
	ac_try_LDFLAGS="$ac_globus_ldflags"
	if test "x$LD_LIBRARY_PATH" != "x" ; then
	    ac_save_LD_LIBRARY_PATH=$LD_LIBRARY_PATH
	    export LD_LIBRARY_PATH="$ac_globus_libdir:$LD_LIBRARY_PATH"
	else
	    export LD_LIBRARY_PATH="$ac_globus_libdir"
	fi
	if test "x$DYLD_LIBRARY_PATH" != "x" ; then
	    ac_save_DYLD_LIBRARY_PATH=$DYLD_LIBRARY_PATH
	    export DYLD_LIBRARY_PATH="$ac_globus_libdir:$DYLD_LIBRARY_PATH"
	else
	    export DYLD_LIBRARY_PATH="$ac_globus_libdir"
	fi
    fi

    CFLAGS="$ac_try_CFLAGS $CFLAGS"
    CPPFLAGS="$ac_try_CPPFLAGS $CPPFLAGS"
    LIBS="$ac_try_LIBS $LIBS"
    LDFLAGS="$ac_try_LDFLAGS $LDFLAGS"
    AC_MSG_CHECKING([for $1 at system default and $ac_globus_libdir])
    AC_LINK_IFELSE([AC_LANG_SOURCE( [#include <$3>
		     int main(void) {return 0;}] )],
		    [have_mod=yes], [have_mod=no])
    AC_MSG_RESULT([$have_mod])

    if test "x$have_mod" = "xyes" ; then
	[$4]
	if test "x$with_globus_thr_flavor" != "x" ; then
	    $1_THR_LIBS="$ac_try_LDFLAGS $ac_try_LIBS"
	    $1_THR_CFLAGS=$ac_try_CFLAGS
	elif test "x$with_globus_nothr_flavor" != "x" ; then
	    $1_NOTHR_LIBS="$ac_try_LDFLAGS $ac_try_LIBS"
	    $1_NOTHR_CFLAGS=$ac_try_CFLAGS
	else
	    $1_LIBS="$ac_try_LDFLAGS $ac_try_LIBS"
	    $1_CFLAGS=$ac_try_CFLAGS
	fi
    else
	[$5]
    fi

    CFLAGS=$ac_save_CFLAGS
    CPPFLAGS=$ac_save_CPPFLAGS
    LIBS=$ac_save_LIBS
    LDFLAGS=$ac_save_LDFLAGS
    if test "x$ac_save_LD_LIBRARY_PATH" = "x" ; then
	unset LD_LIBRARY_PATH
    else
	LD_LIBRARY_PATH=$ac_save_LD_LIBRARY_PATH
    fi
    if test "x$ac_save_DYLD_LIBRARY_PATH" = "x" ; then
	unset DYLD_LIBRARY_PATH
    else
	DYLD_LIBRARY_PATH=$ac_save_DYLD_LIBRARY_PATH
    fi

])
