//===-- Linux implementation of the pthread_getspecific function ----------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include "pthread_getspecific.h"

#include "src/__support/common.h"
#include "src/__support/threads/thread.h"

#include <pthread.h>
#include <stddef.h>

namespace LIBC_NAMESPACE {

LLVM_LIBC_FUNCTION(void *, pthread_getspecific, (pthread_key_t key)) {
  return get_tss_value(key);
}

} // namespace LIBC_NAMESPACE
