
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileYHyperCoordinateAttributes.h
    \brief Definition of YHyperCoordinate Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef YHyperCoordinateAttributes_H
#define YHyperCoordinateAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class YHyperCoordinateAttributes 
{
public:
//  --  constructor
    YHyperCoordinateAttributes();
    
//  --  destructor
    virtual ~YHyperCoordinateAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const YHyperCoordinateAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double min_lat_;
	double max_lat_;
	double min_lon_;
	double max_lon_;
	bool reverse_;
	AxisAutomaticSetting automatic_;
	 

private:
	friend ostream& operator<<(ostream& s,const YHyperCoordinateAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

