# --------------------------------------------------------------------------
# ⚠️ WARNING - AUTO-GENERATED CODE - DO NOT EDIT ⚠️
# ⚙️ Generated by 'python -m opgen'
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# --------------------------------------------------------------------------
# pylint: disable=W0221,W0222,R0901,W0237
# mypy: disable-error-code=override
# ruff: noqa: N801,E741
# ruff: noqa: D214,D402,D405,D411,D412,D416,D417
# --------------------------------------------------------------------------

from __future__ import annotations

from typing import Optional, Tuple, TypeVar, Union

from onnx.defs import get_schema
from typing_extensions import TypeAlias

from onnxscript.onnx_opset._impl.opset5 import Opset5
from onnxscript.onnx_types import (
    BOOL,
    COMPLEX64,
    COMPLEX128,
    DOUBLE,
    FLOAT,
    FLOAT16,
    INT8,
    INT16,
    INT32,
    INT64,
    STRING,
    UINT8,
    UINT16,
    UINT32,
    UINT64,
)
from onnxscript.values import Op, Opset


class Opset6(Opset5):
    def __new__(cls):
        return Opset.__new__(cls, "", 6)

    T_Abs = TypeVar(
        "T_Abs",
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Abs(self, X: T_Abs) -> T_Abs:
        r"""[🌐 Abs(6)](https://onnx.ai/onnx/operators/onnx__Abs.html#abs-6 "Online Documentation")


        Absolute takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the absolute is, y = abs(x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor
        """

        schema = get_schema("Abs", 6, "")
        op = Op(self, "Abs", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Add = TypeVar("T_Add", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Add(
        self, A: T_Add, B: T_Add, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T_Add:
        r"""[🌐 Add(6)](https://onnx.ai/onnx/operators/onnx__Add.html#add-6 "Online Documentation")


        Performs element-wise binary addition (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting
        """

        schema = get_schema("Add", 6, "")
        op = Op(self, "Add", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_BatchNormalization = TypeVar("T_BatchNormalization", DOUBLE, FLOAT, FLOAT16)

    def BatchNormalization(
        self,
        X: T_BatchNormalization,
        scale: T_BatchNormalization,
        B: T_BatchNormalization,
        mean: T_BatchNormalization,
        var: T_BatchNormalization,
        *,
        epsilon: float = 9.999999747378752e-06,
        is_test: int = 0,
        momentum: float = 0.8999999761581421,
        spatial: int = 1,
    ) -> Tuple[
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
    ]:
        r"""[🌐 BatchNormalization(6)](https://onnx.ai/onnx/operators/onnx__BatchNormalization.html#batchnormalization-6 "Online Documentation")


        Carries out batch normalization as described in the paper
        https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
        there are multiple cases for the number of outputs, which we list below:

        Output case #1: Y, mean, var, saved_mean, saved_var (training mode)
        Output case #2: Y (test mode)


        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size.

            scale: The scale as a 1-dimensional tensor of size C to be applied to the
                output.

            B: The bias as a 1-dimensional tensor of size C to be applied to the output.

            mean: The running mean (training) or the estimated mean (testing) as a
                1-dimensional tensor of size C.

            var: The running variance (training) or the estimated variance (testing) as
                a 1-dimensional tensor of size C.

            epsilon: The epsilon value to use to avoid division by zero, default is
                1e-5f.

            is_test: If set to nonzero, run spatial batch normalization in test mode,
                default is 0.

            momentum: Factor used in computing the running mean and variance.e.g.,
                running_mean = running_mean * momentum + mean * (1 - momentum), default
                is 0.9f.

            spatial: If true, compute the mean and variance across all spatial elements
                If false, compute the mean and variance across per feature.Default is 1.
        """

        schema = get_schema("BatchNormalization", 6, "")
        op = Op(self, "BatchNormalization", schema)
        return op(
            *self._prepare_inputs(schema, X, scale, B, mean, var),
            epsilon=epsilon,
            is_test=is_test,
            momentum=momentum,
            spatial=spatial,
        )

    T1_Cast = TypeVar(
        "T1_Cast",
        BOOL,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T2_Cast: TypeAlias = Union[
        BOOL, DOUBLE, FLOAT, FLOAT16, INT16, INT32, INT64, INT8, UINT16, UINT32, UINT64, UINT8
    ]

    def Cast(self, input: T1_Cast, *, to: int) -> T2_Cast:
        r"""[🌐 Cast(6)](https://onnx.ai/onnx/operators/onnx__Cast.html#cast-6 "Online Documentation")


        The operator casts the elements of a given input tensor to a data type
        specified by the 'to' argument and returns an output tensor of the same size in
        the converted type. The 'to' argument must be one of the data types specified
        in the 'DataType' enum field in the TensorProto message.
        NOTE: Casting to and from strings is not supported yet.


        Args:
            input: Input tensor to be cast.

            to: The data type to which the elements of the input tensor are cast.
                Strictly must be one of the types from DataType enum in TensorProto
        """

        schema = get_schema("Cast", 6, "")
        op = Op(self, "Cast", schema)
        return op(*self._prepare_inputs(schema, input), to=to)

    T_Ceil = TypeVar("T_Ceil", DOUBLE, FLOAT, FLOAT16)

    def Ceil(self, X: T_Ceil) -> T_Ceil:
        r"""[🌐 Ceil(6)](https://onnx.ai/onnx/operators/onnx__Ceil.html#ceil-6 "Online Documentation")


        Ceil takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the ceil is, y = ceil(x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor
        """

        schema = get_schema("Ceil", 6, "")
        op = Op(self, "Ceil", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Clip = TypeVar("T_Clip", DOUBLE, FLOAT, FLOAT16)

    def Clip(
        self,
        input: T_Clip,
        *,
        max: float = 3.4028234663852886e38,
        min: float = -3.4028234663852886e38,
    ) -> T_Clip:
        r"""[🌐 Clip(6)](https://onnx.ai/onnx/operators/onnx__Clip.html#clip-6 "Online Documentation")


        Clip operator limits the given input within an interval. The interval is
        specified with arguments 'min' and 'max'. They default to
        numeric_limits::lowest() and numeric_limits::max() respectively.


        Args:
            input: Input tensor whose elements to be clipped

            max: Maximum value, above which element is replaced by max

            min: Minimum value, under which element is replaced by min
        """

        schema = get_schema("Clip", 6, "")
        op = Op(self, "Clip", schema)
        return op(*self._prepare_inputs(schema, input), max=max, min=min)

    T_Div = TypeVar("T_Div", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Div(
        self, A: T_Div, B: T_Div, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T_Div:
        r"""[🌐 Div(6)](https://onnx.ai/onnx/operators/onnx__Div.html#div-6 "Online Documentation")


        Performs element-wise binary division (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting
        """

        schema = get_schema("Div", 6, "")
        op = Op(self, "Div", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_Dropout = TypeVar("T_Dropout", DOUBLE, FLOAT, FLOAT16)

    def Dropout(
        self, data: T_Dropout, *, is_test: int = 0, ratio: float = 0.5
    ) -> Tuple[T_Dropout, T_Dropout]:
        r"""[🌐 Dropout(6)](https://onnx.ai/onnx/operators/onnx__Dropout.html#dropout-6 "Online Documentation")


        Dropout takes one input data (Tensor<float>) and produces two Tensor outputs,
        output (Tensor<float>) and mask (Tensor<bool>). Depending on whether it is in
        test mode or not, the output Y will either be a random dropout, or a simple
        copy of the input. Note that our implementation of Dropout does scaling in
        the training phase, so during testing nothing needs to be done.


        Args:
            data: The input data as Tensor.

            is_test: (int, default 0) if nonzero, run dropout in test mode where the
                output is simply Y = X.

            ratio: (float, default 0.5) the ratio of random dropout
        """

        schema = get_schema("Dropout", 6, "")
        op = Op(self, "Dropout", schema)
        return op(*self._prepare_inputs(schema, data), is_test=is_test, ratio=ratio)

    T_Elu = TypeVar("T_Elu", DOUBLE, FLOAT, FLOAT16)

    def Elu(self, X: T_Elu, *, alpha: float = 1.0) -> T_Elu:
        r"""[🌐 Elu(6)](https://onnx.ai/onnx/operators/onnx__Elu.html#elu-6 "Online Documentation")


        Elu takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the function `f(x) = alpha * (exp(x) - 1.) for x <
        0`, `f(x) = x for x >= 0`., is applied to the tensor elementwise.



        Args:
            X: (differentiable) 1D input tensor

            alpha: Coefficient of ELU.
        """

        schema = get_schema("Elu", 6, "")
        op = Op(self, "Elu", schema)
        return op(*self._prepare_inputs(schema, X), alpha=alpha)

    T_Exp = TypeVar("T_Exp", DOUBLE, FLOAT, FLOAT16)

    def Exp(self, input: T_Exp) -> T_Exp:
        r"""[🌐 Exp(6)](https://onnx.ai/onnx/operators/onnx__Exp.html#exp-6 "Online Documentation")


        Calculates the exponential of the given input tensor, element-wise.


        Args:
            input: Input tensor
        """

        schema = get_schema("Exp", 6, "")
        op = Op(self, "Exp", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Floor = TypeVar("T_Floor", DOUBLE, FLOAT, FLOAT16)

    def Floor(self, X: T_Floor) -> T_Floor:
        r"""[🌐 Floor(6)](https://onnx.ai/onnx/operators/onnx__Floor.html#floor-6 "Online Documentation")


        Floor takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the floor is, y = floor(x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor
        """

        schema = get_schema("Floor", 6, "")
        op = Op(self, "Floor", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Gemm = TypeVar("T_Gemm", DOUBLE, FLOAT, FLOAT16)

    def Gemm(
        self,
        A: T_Gemm,
        B: T_Gemm,
        C: T_Gemm,
        *,
        alpha: float = 1.0,
        beta: float = 1.0,
        broadcast: int = 0,
        transA: int = 0,
        transB: int = 0,
    ) -> T_Gemm:
        r"""[🌐 Gemm(6)](https://onnx.ai/onnx/operators/onnx__Gemm.html#gemm-6 "Online Documentation")

        General Matrix multiplication:
        https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3
        Compute Y = alpha * A * B + beta * C, where input tensor A has
        dimension (M X K), input tensor B has dimension (K X N), input tensor C and
        output tensor Y have dimension (M X N).
        If attribute broadcast is non-zero, input tensor C will be broadcasted to match
        the dimension requirement. A will be transposed before doing the computation
        if attribute transA is non-zero, same for B and transB.


        Args:
            A: Input tensor A

            B: Input tensor B

            C: Input tensor C

            alpha: Scalar multiplier for the product of input tensors A * B, the default
                value is 1.0.

            beta: Scalar multiplier for input tensor C, the default value is 1.0.

            broadcast: Whether C should be broadcasted

            transA: Whether A should be transposed

            transB: Whether B should be transposed
        """

        schema = get_schema("Gemm", 6, "")
        op = Op(self, "Gemm", schema)
        return op(
            *self._prepare_inputs(schema, A, B, C),
            alpha=alpha,
            beta=beta,
            broadcast=broadcast,
            transA=transA,
            transB=transB,
        )

    T_HardSigmoid = TypeVar("T_HardSigmoid", DOUBLE, FLOAT, FLOAT16)

    def HardSigmoid(
        self, X: T_HardSigmoid, *, alpha: float = 0.20000000298023224, beta: float = 0.5
    ) -> T_HardSigmoid:
        r"""[🌐 HardSigmoid(6)](https://onnx.ai/onnx/operators/onnx__HardSigmoid.html#hardsigmoid-6 "Online Documentation")


        HardSigmoid takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the HardSigmoid function, y = max(0, min(1, alpha * x + beta)),
        is applied to the tensor elementwise.


        Args:
            X: (differentiable) Input tensor

            alpha: Value of alpha.

            beta: Value of beta.
        """

        schema = get_schema("HardSigmoid", 6, "")
        op = Op(self, "HardSigmoid", schema)
        return op(*self._prepare_inputs(schema, X), alpha=alpha, beta=beta)

    T_InstanceNormalization = TypeVar("T_InstanceNormalization", DOUBLE, FLOAT, FLOAT16)

    def InstanceNormalization(
        self,
        input: T_InstanceNormalization,
        scale: T_InstanceNormalization,
        B: T_InstanceNormalization,
        *,
        epsilon: float = 9.999999747378752e-06,
    ) -> T_InstanceNormalization:
        r"""[🌐 InstanceNormalization(6)](https://onnx.ai/onnx/operators/onnx__InstanceNormalization.html#instancenormalization-6 "Online Documentation")


        Carries out instance normalization as described in the paper
        https://arxiv.org/abs/1607.08022.

        y = scale * (x - mean) / sqrt(variance + epsilon) + B,
        where mean and variance are computed per instance per channel.



        Args:
            input: (differentiable) Input data tensor from the previous operator;
                dimensions for image case are (N x C x H x W), where N is the batch
                size, C is the number of channels, and H and W are the height and the
                width of the data. For non image case, the dimensions are in the form of
                (N x C x D1 x D2 ... Dn), where N is the batch size.

            scale: (differentiable) The input 1-dimensional scale tensor of size C.

            B: (differentiable) The input 1-dimensional bias tensor of size C.

            epsilon: The epsilon value to use to avoid division by zero.
        """

        schema = get_schema("InstanceNormalization", 6, "")
        op = Op(self, "InstanceNormalization", schema)
        return op(*self._prepare_inputs(schema, input, scale, B), epsilon=epsilon)

    T_LeakyRelu = TypeVar("T_LeakyRelu", DOUBLE, FLOAT, FLOAT16)

    def LeakyRelu(self, X: T_LeakyRelu, *, alpha: float = 0.009999999776482582) -> T_LeakyRelu:
        r"""[🌐 LeakyRelu(6)](https://onnx.ai/onnx/operators/onnx__LeakyRelu.html#leakyrelu-6 "Online Documentation")


        LeakyRelu takes input data (Tensor<T>) and an argument alpha, and produces one
        output data (Tensor<T>) where the function `f(x) = alpha * x for x < 0`,
        `f(x) = x for x >= 0`, is applied to the data tensor elementwise.


        Args:
            X: (differentiable) Input tensor

            alpha: Coefficient of leakage.
        """

        schema = get_schema("LeakyRelu", 6, "")
        op = Op(self, "LeakyRelu", schema)
        return op(*self._prepare_inputs(schema, X), alpha=alpha)

    T_Log = TypeVar("T_Log", DOUBLE, FLOAT, FLOAT16)

    def Log(self, input: T_Log) -> T_Log:
        r"""[🌐 Log(6)](https://onnx.ai/onnx/operators/onnx__Log.html#log-6 "Online Documentation")


        Calculates the natural log of the given input tensor, element-wise.


        Args:
            input: Input tensor
        """

        schema = get_schema("Log", 6, "")
        op = Op(self, "Log", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Max = TypeVar("T_Max", DOUBLE, FLOAT, FLOAT16)

    def Max(self, *data_0: T_Max) -> T_Max:
        r"""[🌐 Max(6)](https://onnx.ai/onnx/operators/onnx__Max.html#max-6 "Online Documentation")


        Element-wise max of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Max.
        """

        schema = get_schema("Max", 6, "")
        op = Op(self, "Max", schema)
        return op(*self._prepare_inputs(schema, *data_0))

    T_Mean = TypeVar("T_Mean", DOUBLE, FLOAT, FLOAT16)

    def Mean(self, *data_0: T_Mean) -> T_Mean:
        r"""[🌐 Mean(6)](https://onnx.ai/onnx/operators/onnx__Mean.html#mean-6 "Online Documentation")


        Element-wise mean of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Mean.
        """

        schema = get_schema("Mean", 6, "")
        op = Op(self, "Mean", schema)
        return op(*self._prepare_inputs(schema, *data_0))

    T_Min = TypeVar("T_Min", DOUBLE, FLOAT, FLOAT16)

    def Min(self, *data_0: T_Min) -> T_Min:
        r"""[🌐 Min(6)](https://onnx.ai/onnx/operators/onnx__Min.html#min-6 "Online Documentation")


        Element-wise min of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Min
        """

        schema = get_schema("Min", 6, "")
        op = Op(self, "Min", schema)
        return op(*self._prepare_inputs(schema, *data_0))

    T_Mul = TypeVar("T_Mul", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Mul(
        self, A: T_Mul, B: T_Mul, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T_Mul:
        r"""[🌐 Mul(6)](https://onnx.ai/onnx/operators/onnx__Mul.html#mul-6 "Online Documentation")


        Performs element-wise binary multiplication (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting
        """

        schema = get_schema("Mul", 6, "")
        op = Op(self, "Mul", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_Neg = TypeVar("T_Neg", DOUBLE, FLOAT, FLOAT16, INT16, INT32, INT64, INT8)

    def Neg(self, X: T_Neg) -> T_Neg:
        r"""[🌐 Neg(6)](https://onnx.ai/onnx/operators/onnx__Neg.html#neg-6 "Online Documentation")


        Neg takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where each element flipped sign, y = -x, is applied to
        the tensor elementwise.


        Args:
            X: Input tensor
        """

        schema = get_schema("Neg", 6, "")
        op = Op(self, "Neg", schema)
        return op(*self._prepare_inputs(schema, X))

    T_PRelu = TypeVar("T_PRelu", DOUBLE, FLOAT, FLOAT16)

    def PRelu(self, X: T_PRelu, slope: T_PRelu) -> T_PRelu:
        r"""[🌐 PRelu(6)](https://onnx.ai/onnx/operators/onnx__PRelu.html#prelu-6 "Online Documentation")



        PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
        output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
        `f(x) = x for x >= 0`., is applied to the data tensor elementwise.



        Args:
            X: Input tensor

            slope: Slope tensor. If `Slope` is of size 1, the value is sharedacross
                different channels
        """

        schema = get_schema("PRelu", 6, "")
        op = Op(self, "PRelu", schema)
        return op(*self._prepare_inputs(schema, X, slope))

    T_Reciprocal = TypeVar("T_Reciprocal", DOUBLE, FLOAT, FLOAT16)

    def Reciprocal(self, X: T_Reciprocal) -> T_Reciprocal:
        r"""[🌐 Reciprocal(6)](https://onnx.ai/onnx/operators/onnx__Reciprocal.html#reciprocal-6 "Online Documentation")


        Reciprocal takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the reciprocal is, y = 1/x, is applied to
        the tensor elementwise.


        Args:
            X: Input tensor
        """

        schema = get_schema("Reciprocal", 6, "")
        op = Op(self, "Reciprocal", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Relu = TypeVar("T_Relu", DOUBLE, FLOAT, FLOAT16)

    def Relu(self, X: T_Relu) -> T_Relu:
        r"""[🌐 Relu(6)](https://onnx.ai/onnx/operators/onnx__Relu.html#relu-6 "Online Documentation")


        Relu takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the rectified linear function, y = max(0, x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor
        """

        schema = get_schema("Relu", 6, "")
        op = Op(self, "Relu", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Selu = TypeVar("T_Selu", DOUBLE, FLOAT, FLOAT16)

    def Selu(
        self,
        X: T_Selu,
        *,
        alpha: float = 1.6732631921768188,
        gamma: float = 1.0507010221481323,
    ) -> T_Selu:
        r"""[🌐 Selu(6)](https://onnx.ai/onnx/operators/onnx__Selu.html#selu-6 "Online Documentation")


        Selu takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the scaled exponential linear unit function,
        `y = gamma * (alpha * e^x - alpha) for x <= 0`, `y = gamma * x for x > 0`,
        is applied to the tensor elementwise.


        Args:
            X: (differentiable) Input tensor

            alpha: Coefficient of SELU default to 1.67326319217681884765625 (i.e.,
                float32 approximation of 1.6732632423543772848170429916717).

            gamma: Coefficient of SELU default to 1.05070102214813232421875 (i.e.,
                float32 approximation of 1.0507009873554804934193349852946).
        """

        schema = get_schema("Selu", 6, "")
        op = Op(self, "Selu", schema)
        return op(*self._prepare_inputs(schema, X), alpha=alpha, gamma=gamma)

    T_Sigmoid = TypeVar("T_Sigmoid", DOUBLE, FLOAT, FLOAT16)

    def Sigmoid(self, X: T_Sigmoid) -> T_Sigmoid:
        r"""[🌐 Sigmoid(6)](https://onnx.ai/onnx/operators/onnx__Sigmoid.html#sigmoid-6 "Online Documentation")


        Sigmoid takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the sigmoid function, y = 1 / (1 + exp(-x)), is applied to the
        tensor elementwise.


        Args:
            X: Input tensor
        """

        schema = get_schema("Sigmoid", 6, "")
        op = Op(self, "Sigmoid", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Sqrt = TypeVar("T_Sqrt", DOUBLE, FLOAT, FLOAT16)

    def Sqrt(self, X: T_Sqrt) -> T_Sqrt:
        r"""[🌐 Sqrt(6)](https://onnx.ai/onnx/operators/onnx__Sqrt.html#sqrt-6 "Online Documentation")


        Square root takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the square root is, y = x^0.5, is applied to
        the tensor elementwise. If x is negative, then it will return NaN.


        Args:
            X: Input tensor
        """

        schema = get_schema("Sqrt", 6, "")
        op = Op(self, "Sqrt", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Sub = TypeVar("T_Sub", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Sub(
        self, A: T_Sub, B: T_Sub, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T_Sub:
        r"""[🌐 Sub(6)](https://onnx.ai/onnx/operators/onnx__Sub.html#sub-6 "Online Documentation")


        Performs element-wise binary subtraction (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting
        """

        schema = get_schema("Sub", 6, "")
        op = Op(self, "Sub", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_Sum = TypeVar("T_Sum", DOUBLE, FLOAT, FLOAT16)

    def Sum(self, *data_0: T_Sum) -> T_Sum:
        r"""[🌐 Sum(6)](https://onnx.ai/onnx/operators/onnx__Sum.html#sum-6 "Online Documentation")


        Element-wise sum of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Sum.
        """

        schema = get_schema("Sum", 6, "")
        op = Op(self, "Sum", schema)
        return op(*self._prepare_inputs(schema, *data_0))

    T_Tanh = TypeVar("T_Tanh", DOUBLE, FLOAT, FLOAT16)

    def Tanh(self, input: T_Tanh) -> T_Tanh:
        r"""[🌐 Tanh(6)](https://onnx.ai/onnx/operators/onnx__Tanh.html#tanh-6 "Online Documentation")


        Calculates the hyperbolic tangent of the given input tensor element-wise.


        Args:
            input: Input tensor
        """

        schema = get_schema("Tanh", 6, "")
        op = Op(self, "Tanh", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Tile = TypeVar(
        "T_Tile",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T1_Tile: TypeAlias = INT64

    def Tile(self, input: T_Tile, repeats: T1_Tile) -> T_Tile:
        r"""[🌐 Tile(6)](https://onnx.ai/onnx/operators/onnx__Tile.html#tile-6 "Online Documentation")

        Constructs a tensor by tiling a given tensor.
        This is the same as function `tile` in Numpy, but no broadcast.
        For example A = [[1, 2], [3, 4]], B = [1, 2], tile(A, B) = [[1, 2, 1, 2], [3, 4, 3, 4]]


        Args:
            input: Input tensor of any shape.

            repeats: 1D int64 tensor of the same length as input's dimension number,
                includes numbers of repeated copies along input's dimensions.
        """

        schema = get_schema("Tile", 6, "")
        op = Op(self, "Tile", schema)
        return op(*self._prepare_inputs(schema, input, repeats))
