#define XERR
#include "screening.ih"

        // called from loop/initialize.cc

        // indices are Breast bi-rad indices used for the screening round
        // ages, determined by Densities 
        // or lung-cancer table S3 indices 
        // to use for the ages of the screening rounds

DoubleVect Screening::radiationRisk(
                                Modalities const &modalities,
                                Uint16Vect const &indices,
                                double beta, double eta)   // beir7 values
{
    DoubleVect vect = DoubleVect(END_AGE, 1);

//xerr("d_errRiskVector: " << d_errRiskVector);

    for (
        size_t roundIndex = 0, end = d_roundVect.size(); 
            roundIndex != end; 
                ++roundIndex
    )
    {
            // probabilities *lower* than the attendance rate mean the case 
            // is attending.
        if (Random::instance().uniform() <= d_rate)
            (*d_errRiskVector)  // errRisk1405, or (deprecated) with option
            (                   //                 -e: errRisk1405
                vect, modalities, 
                d_roundVect[roundIndex], indices[roundIndex],
                beta, eta
            ); 
    }

    return vect;
}







