## TFSA-2020-033: CHECK-fail in LSTM with zero-length input

### CVE Number
CVE-2020-26270

### Impact
Running an LSTM/GRU model where the LSTM/GRU layer receives an input with
zero-length results in a `CHECK` failure when using the CUDA backend.

This can result in a query-of-death vulnerability, via denial of service, if
users can control the input to the layer.

### Patches

We have patched the issue in GitHub commit
[14755416e364f17fb1870882fa778c7fec7f16e3](https://github.com/tensorflow/tensorflow/commit/14755416e364f17fb1870882fa778c7fec7f16e3)
and will release TensorFlow 2.4.0 containing the patch. TensorFlow nightly
packages after this commit will also have the issue resolved.

Since this issue also impacts TF versions before 2.4, we will patch all releases
between 1.15 and 2.3 inclusive.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.
