// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#include "config.h"
#include "CSSPropertyParsing.h"

#include "CSSParserContext.h"
#include "CSSParserIdioms.h"
#include "CSSPropertyParser.h"
#include "CSSPropertyParserCustom.h"
#include "CSSPropertyParserState.h"
#include "DeprecatedGlobalSettings.h"

namespace WebCore {

using namespace CSSPropertyParserHelpers;

static bool isKeywordValidForTestKeyword(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBar:
    case CSSValueID::CSSValueFoo:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestKeywordWithAliasedTo(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBar:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestMatchOneWithGroupWithSettingsFlag(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBar:
    case CSSValueID::CSSValueBaz:
    case CSSValueID::CSSValueFoo:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestMatchOneWithKeywordWithSettingsFlag(CSSValueID keyword, CSS::PropertyParserState& state)
{
    switch (keyword) {
    case CSSValueID::CSSValueBar:
    case CSSValueID::CSSValueBaz:
        return true;
    case CSSValueID::CSSValueFoo:
        return state.context.cssSettingsFooDisabled;
    default:
        return false;
    }
}

static bool isKeywordValidForTestMatchOneWithMultipleKeywords(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBar:
    case CSSValueID::CSSValueBaz:
    case CSSValueID::CSSValueFoo:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestMatchOneWithReferenceWithSettingsFlag(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueBar:
    case CSSValueID::CSSValueBaz:
    case CSSValueID::CSSValueFoo:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestUrlWithModifiers(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestUrlWithNoModifiers(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueNone:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestUsingSharedRule(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestUsingSharedRuleExported(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static bool isKeywordValidForTestUsingSharedRuleWithOverrideFunction(CSSValueID keyword)
{
    switch (keyword) {
    case CSSValueID::CSSValueAuto:
        return true;
    default:
        return false;
    }
}

static RefPtr<CSSValue> consumeBackgroundFillLayerTestPrimary(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds::minimumOf(1), ListOptimization::SingleValue, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeBackgroundFillLayerTestSecondary(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds::minimumOf(1), ListOptimization::SingleValue, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeBackgroundFillLayerTestSecondaryWithConverter(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds::minimumOf(1), ListOptimization::SingleValue, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithCommas(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#{2,3}
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds { 2, 3 }, ListOptimization::None>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithCommasFixed(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#{2}
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds { 2, 2 }, ListOptimization::None>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithCommasNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#{1,3}@(no-single-item-opt)
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds { 1, 3 }, ListOptimization::None>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithCommasSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#{1,3}
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds { 1, 3 }, ListOptimization::SingleValue>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpaces(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{2,3}
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds { 2, 3 }, ListOptimization::None>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpacesFixed(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{2}
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds { 2, 2 }, ListOptimization::None>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpacesNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{1,3}@(no-single-item-opt)
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds { 1, 3 }, ListOptimization::None>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpacesSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{1,3}
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds { 1, 3 }, ListOptimization::SingleValue>(range, consumeRepeatedTerm, state);
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpacesWithType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{1,2}@(type=CSSValuePair)
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        CSSParserTokenRange rangeCopy = range;
        auto term0 = consumeRepeatedTerm(rangeCopy, state);
        if (!term0)
            return { };
        auto term1 = consumeRepeatedTerm(rangeCopy, state);
        if (!term1) {
            range = rangeCopy;
            return term0.releaseNonNull(); // single item optimization
        }
        range = rangeCopy;
        return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull());
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpacesWithTypeNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{1,2}@(type=CSSValuePair no-single-item-opt)
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        CSSParserTokenRange rangeCopy = range;
        auto term0 = consumeRepeatedTerm(rangeCopy, state);
        if (!term0)
            return { };
        auto term1 = consumeRepeatedTerm(rangeCopy, state);
        if (!term1) {
            range = rangeCopy;
            return CSSValuePair::create(term0.releaseNonNull());
        }
        range = rangeCopy;
        return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull());
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpacesWithTypeWithDefaultPrevious(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{1,2}@(type=CSSValuePair default=previous)
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        CSSParserTokenRange rangeCopy = range;
        auto term0 = consumeRepeatedTerm(rangeCopy, state);
        if (!term0)
            return { };
        auto term1 = consumeRepeatedTerm(rangeCopy, state);
        if (!term1) {
            term1 = term0;
            range = rangeCopy;
            return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull());
        }
        range = rangeCopy;
        return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull());
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestBoundedRepetitionWithSpacesWithTypeWithDefaultPreviousTwo(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{1,4}@(type=CSSValuePair default=previous)
    auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        CSSParserTokenRange rangeCopy = range;
        auto term0 = consumeRepeatedTerm(rangeCopy, state);
        if (!term0)
            return { };
        auto term1 = consumeRepeatedTerm(rangeCopy, state);
        if (!term1) {
            term1 = term0;
            range = rangeCopy;
            return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull());
        }
        auto term2 = consumeRepeatedTerm(rangeCopy, state);
        if (!term2) {
            term2 = term1;
            range = rangeCopy;
            return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull(), term2.releaseNonNull());
        }
        auto term3 = consumeRepeatedTerm(rangeCopy, state);
        if (!term3) {
            term3 = term2;
            range = rangeCopy;
            return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull(), term2.releaseNonNull(), term3.releaseNonNull());
        }
        range = rangeCopy;
        return CSSValuePair::create(term0.releaseNonNull(), term1.releaseNonNull(), term2.releaseNonNull(), term3.releaseNonNull());
    };
    return consumeBoundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionBoundedParameters(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo(<number>#{1,4})
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // <number>#{1,4}
            auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                    // <number>
                    return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                };
                return consumeListSeparatedByIntoBuilder<',', ListBounds { 1, 4 }>(range, consumeRepeatedTerm, state);
            };
            return consumeBoundedRepetition(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionFixedParameters(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo(<number>#{3})
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // <number>#{3}
            auto consumeBoundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                    // <number>
                    return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                };
                return consumeListSeparatedByIntoBuilder<',', ListBounds { 3, 3 }>(range, consumeRepeatedTerm, state);
            };
            return consumeBoundedRepetition(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionNoParameters(CSSParserTokenRange& range)
{
    // foo([  ])
    auto consumeFooFunction = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args) -> std::optional<CSSValueListBuilder> {
            // [  ]
            auto consumeMatchAllOrdered = [](CSSParserTokenRange& range) -> std::optional<CSSValueListBuilder> {
                CSSValueListBuilder list;
                return { WTFMove(list) };
            };
            return consumeMatchAllOrdered(args);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range);
}

static RefPtr<CSSValue> consumeTestFunctionParametersMatchAllAnyOrder(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo([ <number> && <string> ])
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // [ <number> && <string> ]
            auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                RefPtr<CSSValue> value0; // <number>
                auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
                    auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                        // <number>
                        return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                    };
                    if (value0)
                        return false;
                    value0 = consumeTerm0(range, state);
                    return !!value0;
                };
                RefPtr<CSSValue> value1; // <string>
                auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
                    auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                        // <string>
                        return consumeString(range);
                    };
                    if (value1)
                        return false;
                    value1 = consumeTerm1(range);
                    return !!value1;
                };
                for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
                    if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range))
                        continue;
                    break;
                }
                CSSValueListBuilder list;
                if (value0) // <number>
                    list.append(value0.releaseNonNull());
                else
                    return { };
                if (value1) // <string>
                    list.append(value1.releaseNonNull());
                else
                    return { };
                return { WTFMove(list) };
            };
            return consumeMatchAllAnyOrder(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionParametersMatchAllAnyOrderWithOptional(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo([ <number> && <string>? ])
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // [ <number> && <string>? ]
            auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                RefPtr<CSSValue> value0; // <number>
                auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
                    auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                        // <number>
                        return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                    };
                    if (value0)
                        return false;
                    value0 = consumeTerm0(range, state);
                    return !!value0;
                };
                RefPtr<CSSValue> value1; // <string>?
                auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
                    auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                        // <string>
                        return consumeString(range);
                    };
                    if (value1)
                        return false;
                    value1 = consumeTerm1(range);
                    return !!value1;
                };
                for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
                    if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range))
                        continue;
                    break;
                }
                CSSValueListBuilder list;
                if (value0) // <number>
                    list.append(value0.releaseNonNull());
                else
                    return { };
                if (value1) // <string>?
                    list.append(value1.releaseNonNull());
                return { WTFMove(list) };
            };
            return consumeMatchAllAnyOrder(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionParametersMatchAllOrdered(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo([ <number> <string> ])
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // [ <number> <string> ]
            auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                    // <number>
                    return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                };
                auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                    // <string>
                    return consumeString(range);
                };
                CSSValueListBuilder list;
                // <number>
                auto value0 = consumeTerm0(range, state);
                if (value0)
                    list.append(value0.releaseNonNull());
                else
                    return { };
                // <string>
                auto value1 = consumeTerm1(range);
                if (value1)
                    list.append(value1.releaseNonNull());
                else
                    return { };
                return { WTFMove(list) };
            };
            return consumeMatchAllOrdered(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionParametersMatchAllOrderedWithOptional(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo([ <number> <string>? ])
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // [ <number> <string>? ]
            auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                    // <number>
                    return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                };
                auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                    // <string>
                    return consumeString(range);
                };
                CSSValueListBuilder list;
                // <number>
                auto value0 = consumeTerm0(range, state);
                if (value0)
                    list.append(value0.releaseNonNull());
                else
                    return { };
                // <string>?
                auto value1 = consumeTerm1(range);
                if (value1)
                    list.append(value1.releaseNonNull());
                return { WTFMove(list) };
            };
            return consumeMatchAllOrdered(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionParametersMatchOneOrMoreAnyOrder(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo([ <number> || <string> ])
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // [ <number> || <string> ]
            auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                RefPtr<CSSValue> value0; // <number>
                auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
                    auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                        // <number>
                        return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                    };
                    if (value0)
                        return false;
                    value0 = consumeTerm0(range, state);
                    return !!value0;
                };
                RefPtr<CSSValue> value1; // <string>
                auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
                    auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                        // <string>
                        return consumeString(range);
                    };
                    if (value1)
                        return false;
                    value1 = consumeTerm1(range);
                    return !!value1;
                };
                for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
                    if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range))
                        continue;
                    break;
                }
                CSSValueListBuilder list;
                if (value0) // <number>
                    list.append(value0.releaseNonNull());
                if (value1) // <string>
                    list.append(value1.releaseNonNull());
                if (list.isEmpty())
                    return { };
                return { WTFMove(list) };
            };
            return consumeMatchOneOrMoreAnyOrder(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionSingleParameter(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo(<number>)
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            auto consumeParameter = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(args, state);
            };
            auto parameter = consumeParameter(args, state);
            if (!parameter)
                return { };
            return CSSValueListBuilder { parameter.releaseNonNull() };
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionSingleParameterMatchOne(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo([ <number> | <string> | bar | baz ])
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            auto consumeParameter = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // bar | baz
                switch (auto keyword = args.peek().id(); keyword) {
                case CSSValueID::CSSValueBar:
                case CSSValueID::CSSValueBaz:
                    args.consumeIncludingWhitespace();
                    return CSSPrimitiveValue::create(keyword);
                default:
                    break;
                }
                // <number>
                if (auto result = CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(args, state))
                    return result;
                // <string>
                return consumeString(args);
            };
            auto parameter = consumeParameter(args, state);
            if (!parameter)
                return { };
            return CSSValueListBuilder { parameter.releaseNonNull() };
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionSingleParameterOptional(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo(<number>?)
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            auto consumeParameter = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(args, state);
            };
            auto parameter = consumeParameter(args, state);
            if (!parameter)
                return CSSValueListBuilder { };
            return CSSValueListBuilder { parameter.releaseNonNull() };
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionUnboundedParametersNoMin(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo(<number>#)
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // <number>#
            auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                    // <number>
                    return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                };
                return consumeListSeparatedByIntoBuilder<',', ListBounds::minimumOf(1)>(range, consumeRepeatedTerm, state);
            };
            return consumeUnboundedRepetition(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestFunctionUnboundedParametersWithMinimum(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // foo(<number>#{2,})
    auto consumeFooFunction = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeParameters = [](CSSParserTokenRange& args, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
            // <number>#{2,}
            auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> std::optional<CSSValueListBuilder> {
                auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                    // <number>
                    return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
                };
                return consumeListSeparatedByIntoBuilder<',', ListBounds::minimumOf(2)>(range, consumeRepeatedTerm, state);
            };
            return consumeUnboundedRepetition(args, state);
        };
        if (range.peek().functionId() != CSSValueID::CSSValueFoo)
            return { };
        CSSParserTokenRange rangeCopy = range;
        CSSParserTokenRange args = consumeFunction(rangeCopy);
        auto result = consumeParameters(args, state);
        if (!result)
            return { };
        if (!args.atEnd())
            return { };
        range = rangeCopy;
        return CSSFunctionValue::create(CSSValueID::CSSValueFoo, WTFMove(*result));
    };
    return consumeFooFunction(range, state);
}

static RefPtr<CSSValue> consumeTestKeywordWithAliasedTo(CSSParserTokenRange& range)
{
    // bar
    if (auto result = consumeIdent(range, isKeywordValidForTestKeywordWithAliasedTo))
        return result;
    // foo@(aliased-to=baz)
    switch (auto keyword = range.peek().id(); keyword) {
    case CSSValueID::CSSValueFoo:
        range.consumeIncludingWhitespace();
        return CSSPrimitiveValue::create(CSSValueID::CSSValueBaz);
    default:
        return nullptr;
    }
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrder(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length> ]
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!value0) // <number>
            return { };
        if (!value1) // <custom-ident>
            return { };
        if (!value2) // <length>
            return { };
        return CSSValueList::createSpaceSeparated(value0.releaseNonNull(), value1.releaseNonNull(), value2.releaseNonNull());
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length> ]@(type=CSSCustomType)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!value0) // <number>
            return { };
        if (!value1) // <custom-ident>
            return { };
        if (!value2) // <length>
            return { };
        return CSSCustomType::create(value0.releaseNonNull(), value1.releaseNonNull(), value2.releaseNonNull());
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptional(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident>? && <length> ]
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>?
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        else
            return { };
        if (value1) // <custom-ident>?
            list.append(value1.releaseNonNull());
        if (value2) // <length>
            list.append(value2.releaseNonNull());
        else
            return { };
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident>? && <length>? ]@(type=CSSCustomType)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>?
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>?
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        else
            return { };
        if (value1) // <custom-ident>?
            list.append(value1.releaseNonNull());
        if (value2) // <length>?
            list.append(value2.releaseNonNull());
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length>? ]@(type=CSSCustomType)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>?
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        else
            return { };
        if (value1) // <custom-ident>
            list.append(value1.releaseNonNull());
        else
            return { };
        if (value2) // <length>?
            list.append(value2.releaseNonNull());
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomTypeNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length>? ]@(type=CSSCustomType no-single-item-opt)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>?
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        else
            return { };
        if (value1) // <custom-ident>
            list.append(value1.releaseNonNull());
        else
            return { };
        if (value2) // <length>?
            list.append(value2.releaseNonNull());
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length>? ]@(preserve-order type=CSSCustomType)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>?
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        if (!consumedValue1) // <custom-ident>
            return { };
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomTypeNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length>? ]@(preserve-order type=CSSCustomType no-single-item-opt)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>?
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        if (!consumedValue1) // <custom-ident>
            return { };
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalAndPreserveOrderAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident>? && <length>? ]@(preserve-order type=CSSCustomType)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>?
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>?
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident>? && <length>? ]@(no-single-item-opt)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>?
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>?
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        else
            return { };
        if (value1) // <custom-ident>?
            list.append(value1.releaseNonNull());
        if (value2) // <length>?
            list.append(value2.releaseNonNull());
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident>? && <length>? ]
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>?
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>?
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        else
            return { };
        if (value1) // <custom-ident>?
            list.append(value1.releaseNonNull());
        if (value2) // <length>?
            list.append(value2.releaseNonNull());
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalWithPreserveOrder(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident>? && <length>? ]@(preserve-order)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>?
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>?
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithOptionalWithPreserveOrderNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident>? && <length>? ]@(preserve-order no-single-item-opt)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>?
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>?
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithPreserveOrder(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length> ]@(preserve-order)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        if (!consumedValue1) // <custom-ident>
            return { };
        if (!consumedValue2) // <length>
            return { };
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithPreserveOrderAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length> ]@(preserve-order type=CSSCustomType)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        if (!consumedValue1) // <custom-ident>
            return { };
        if (!consumedValue2) // <length>
            return { };
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllAnyOrderWithPreserveOrderNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> && <custom-ident> && <length> ]@(preserve-order no-single-item-opt)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (!consumedValue0) // <number>
            return { };
        if (!consumedValue1) // <custom-ident>
            return { };
        if (!consumedValue2) // <length>
            return { };
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrdered(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident> <length> ]
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (!value0)
            return { };
        // <custom-ident>
        auto value1 = consumeTerm1(range);
        if (!value1)
            return { };
        // <length>
        auto value2 = consumeTerm2(range, state);
        if (!value2)
            return { };
        return CSSValueList::createSpaceSeparated(value0.releaseNonNull(), value1.releaseNonNull(), value2.releaseNonNull());
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident> <length> ]@(type=CSSCustomType)
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (!value0)
            return { };
        // <custom-ident>
        auto value1 = consumeTerm1(range);
        if (!value1)
            return { };
        // <length>
        auto value2 = consumeTerm2(range, state);
        if (!value2)
            return { };
        return CSSCustomType::create(value0.releaseNonNull(), value1.releaseNonNull(), value2.releaseNonNull());
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithOptional(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident>? <length> ]
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        CSSValueListBuilder list;
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (value0)
            list.append(value0.releaseNonNull());
        else
            return { };
        // <custom-ident>?
        auto value1 = consumeTerm1(range);
        if (value1)
            list.append(value1.releaseNonNull());
        // <length>
        auto value2 = consumeTerm2(range, state);
        if (value2)
            list.append(value2.releaseNonNull());
        else
            return { };
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithOptionalAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident>? <length>? ]@(type=CSSCustomType)
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        CSSValueListBuilder list;
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (value0)
            list.append(value0.releaseNonNull());
        else
            return { };
        // <custom-ident>?
        auto value1 = consumeTerm1(range);
        if (value1)
            list.append(value1.releaseNonNull());
        // <length>?
        auto value2 = consumeTerm2(range, state);
        if (value2)
            list.append(value2.releaseNonNull());
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithOptionalAndCustomTypeAndNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident>? <length>? ]@(type=CSSCustomType no-single-item-opt)
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        CSSValueListBuilder list;
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (value0)
            list.append(value0.releaseNonNull());
        else
            return { };
        // <custom-ident>?
        auto value1 = consumeTerm1(range);
        if (value1)
            list.append(value1.releaseNonNull());
        // <length>?
        auto value2 = consumeTerm2(range, state);
        if (value2)
            list.append(value2.releaseNonNull());
        if (list.size() == 1)
            return CSSCustomType::create(WTFMove(list[0]));
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithOptionalAndMultipleRequired(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident> <length>? ]
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        CSSValueListBuilder list;
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (value0)
            list.append(value0.releaseNonNull());
        else
            return { };
        // <custom-ident>
        auto value1 = consumeTerm1(range);
        if (value1)
            list.append(value1.releaseNonNull());
        else
            return { };
        // <length>?
        auto value2 = consumeTerm2(range, state);
        if (value2)
            list.append(value2.releaseNonNull());
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithOptionalAndMultipleRequiredAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident> <length>? ]@(type=CSSCustomType)
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        CSSValueListBuilder list;
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (value0)
            list.append(value0.releaseNonNull());
        else
            return { };
        // <custom-ident>
        auto value1 = consumeTerm1(range);
        if (value1)
            list.append(value1.releaseNonNull());
        else
            return { };
        // <length>?
        auto value2 = consumeTerm2(range, state);
        if (value2)
            list.append(value2.releaseNonNull());
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithOptionalNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident>? <length>? ]@(no-single-item-opt)
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        CSSValueListBuilder list;
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (value0)
            list.append(value0.releaseNonNull());
        else
            return { };
        // <custom-ident>?
        auto value1 = consumeTerm1(range);
        if (value1)
            list.append(value1.releaseNonNull());
        // <length>?
        auto value2 = consumeTerm2(range, state);
        if (value2)
            list.append(value2.releaseNonNull());
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchAllOrderedWithOptionalSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> <custom-ident>? <length>? ]
    auto consumeMatchAllOrdered = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
            // <custom-ident>
            return consumeCustomIdent(range);
        };
        auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <length>
            return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
        };
        CSSValueListBuilder list;
        // <number>
        auto value0 = consumeTerm0(range, state);
        if (value0)
            list.append(value0.releaseNonNull());
        else
            return { };
        // <custom-ident>?
        auto value1 = consumeTerm1(range);
        if (value1)
            list.append(value1.releaseNonNull());
        // <length>?
        auto value2 = consumeTerm2(range, state);
        if (value2)
            list.append(value2.releaseNonNull());
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchAllOrdered(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOne(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>
    if (auto result = CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state))
        return result;
    // <custom-ident>
    if (auto result = consumeCustomIdent(range))
        return result;
    // <length>
    return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrder(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        if (value1) // <custom-ident>
            list.append(value1.releaseNonNull());
        if (value2) // <length>
            list.append(value2.releaseNonNull());
        if (list.isEmpty())
            return { };
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrderNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]@(no-single-item-opt)
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        if (value1) // <custom-ident>
            list.append(value1.releaseNonNull());
        if (value2) // <length>
            list.append(value2.releaseNonNull());
        if (list.isEmpty())
            return { };
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrderWithCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]@(type=CSSCustomType)
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        if (value1) // <custom-ident>
            list.append(value1.releaseNonNull());
        if (value2) // <length>
            list.append(value2.releaseNonNull());
        if (list.isEmpty())
            return { };
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrderWithCustomTypeNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]@(type=CSSCustomType no-single-item-opt)
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <number>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range, state);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <custom-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        RefPtr<CSSValue> value2; // <length>
        auto tryConsumeTerm2 = [&value2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (value2)
                return false;
            value2 = consumeTerm2(range, state);
            return !!value2;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // <number>
            list.append(value0.releaseNonNull());
        if (value1) // <custom-ident>
            list.append(value1.releaseNonNull());
        if (value2) // <length>
            list.append(value2.releaseNonNull());
        if (list.isEmpty())
            return { };
        if (list.size() == 1)
            return CSSCustomType::create(WTFMove(list[0]));
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrderWithPreserveOrder(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]@(preserve-order)
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (list.isEmpty())
            return { };
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomType(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]@(preserve-order type=CSSCustomType)
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (list.isEmpty())
            return { };
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomTypeNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]@(preserve-order type=CSSCustomType no-single-item-opt)
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (list.isEmpty())
            return { };
        if (list.size() == 1)
            return CSSCustomType::create(WTFMove(list[0]));
        if (list.size() == 2)
            return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]));
        return CSSCustomType::create(WTFMove(list[0]), WTFMove(list[1]), WTFMove(list[2]));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneOrMoreAnyOrderWithPreserveOrderNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ <number> || <custom-ident> || <length> ]@(preserve-order no-single-item-opt)
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        CSSValueListBuilder list;
        bool consumedValue0 = false; // <number>
        auto tryConsumeTerm0 = [&list, &consumedValue0](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <number>
                return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
            };
            if (consumedValue0)
                return false;
            if (auto value = consumeTerm0(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue0 = true;
                return true;
            }
            return false;
        };
        bool consumedValue1 = false; // <custom-ident>
        auto tryConsumeTerm1 = [&list, &consumedValue1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (consumedValue1)
                return false;
            if (auto value = consumeTerm1(range)) {
                list.append(value.releaseNonNull());
                consumedValue1 = true;
                return true;
            }
            return false;
        };
        bool consumedValue2 = false; // <length>
        auto tryConsumeTerm2 = [&list, &consumedValue2](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm2 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                // <length>
                return CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow });
            };
            if (consumedValue2)
                return false;
            if (auto value = consumeTerm2(range, state)) {
                list.append(value.releaseNonNull());
                consumedValue2 = true;
                return true;
            }
            return false;
        };
        for (size_t i = 0; i < 3 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range, state) || tryConsumeTerm1(range) || tryConsumeTerm2(range, state))
                continue;
            break;
        }
        if (list.isEmpty())
            return { };
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestMatchOneWithGroupWithSettingsFlag(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // bar | baz | foo
    if (auto result = consumeIdent(range, isKeywordValidForTestMatchOneWithGroupWithSettingsFlag))
        return result;
    // <number>
    if (auto result = CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state))
        return result;
    // [ <custom-ident> && <dashed-ident> ]@(settings-flag=cssSettingsGroupDisabled)
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        if (!state.context.cssSettingsGroupDisabled)
            return { };
        RefPtr<CSSValue> value0; // <custom-ident>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <dashed-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <dashed-ident>
                return consumeDashedIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range) || tryConsumeTerm1(range))
                continue;
            break;
        }
        if (!value0) // <custom-ident>
            return { };
        if (!value1) // <dashed-ident>
            return { };
        return CSSValueList::createSpaceSeparated(value0.releaseNonNull(), value1.releaseNonNull());
    };
    return consumeMatchAllAnyOrder(range);
}

static RefPtr<CSSValue> consumeTestMatchOneWithKeywordWithSettingsFlag(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // bar | baz | foo@(settings-flag=cssSettingsFooDisabled)
    if (auto result = consumeIdent(range, isKeywordValidForTestMatchOneWithKeywordWithSettingsFlag, state))
        return result;
    // <number>
    if (auto result = CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state))
        return result;
    // [ <custom-ident> && <dashed-ident> ]
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <custom-ident>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <dashed-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <dashed-ident>
                return consumeDashedIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range) || tryConsumeTerm1(range))
                continue;
            break;
        }
        if (!value0) // <custom-ident>
            return { };
        if (!value1) // <dashed-ident>
            return { };
        return CSSValueList::createSpaceSeparated(value0.releaseNonNull(), value1.releaseNonNull());
    };
    return consumeMatchAllAnyOrder(range);
}

static RefPtr<CSSValue> consumeTestMatchOneWithMultipleKeywords(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // bar | baz | foo
    if (auto result = consumeIdent(range, isKeywordValidForTestMatchOneWithMultipleKeywords))
        return result;
    // <number>
    if (auto result = CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state))
        return result;
    // [ <custom-ident> && <dashed-ident> ]
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <custom-ident>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <dashed-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <dashed-ident>
                return consumeDashedIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range) || tryConsumeTerm1(range))
                continue;
            break;
        }
        if (!value0) // <custom-ident>
            return { };
        if (!value1) // <dashed-ident>
            return { };
        return CSSValueList::createSpaceSeparated(value0.releaseNonNull(), value1.releaseNonNull());
    };
    return consumeMatchAllAnyOrder(range);
}

static RefPtr<CSSValue> consumeTestMatchOneWithReferenceWithSettingsFlag(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // bar | baz | foo
    if (auto result = consumeIdent(range, isKeywordValidForTestMatchOneWithReferenceWithSettingsFlag))
        return result;
    // <number>@(settings-flag=cssSettingsReferenceDisabled)
    auto consumeNumberReference = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        if (!state.context.cssSettingsReferenceDisabled)
            return { };
        return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
    };
    if (auto result = consumeNumberReference(range, state))
        return result;
    // [ <custom-ident> && <dashed-ident> ]
    auto consumeMatchAllAnyOrder = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // <custom-ident>
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <custom-ident>
                return consumeCustomIdent(range);
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // <dashed-ident>
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // <dashed-ident>
                return consumeDashedIdent(range);
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range);
            return !!value1;
        };
        for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range) || tryConsumeTerm1(range))
                continue;
            break;
        }
        if (!value0) // <custom-ident>
            return { };
        if (!value1) // <dashed-ident>
            return { };
        return CSSValueList::createSpaceSeparated(value0.releaseNonNull(), value1.releaseNonNull());
    };
    return consumeMatchAllAnyOrder(range);
}

static RefPtr<CSSValue> consumeTestMatchOneWithSettingsFlag(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // [ none || [ foo | bar ]@(settings-flag=cssSettingsGroupDisabled) ]
    auto consumeMatchOneOrMoreAnyOrder = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        RefPtr<CSSValue> value0; // none
        auto tryConsumeTerm0 = [&value0](CSSParserTokenRange& range) -> bool {
            auto consumeTerm0 = [](CSSParserTokenRange& range) -> RefPtr<CSSValue> {
                // none
                switch (auto keyword = range.peek().id(); keyword) {
                case CSSValueID::CSSValueNone:
                    range.consumeIncludingWhitespace();
                    return CSSPrimitiveValue::create(keyword);
                default:
                    return nullptr;
                }
            };
            if (value0)
                return false;
            value0 = consumeTerm0(range);
            return !!value0;
        };
        RefPtr<CSSValue> value1; // [ foo | bar ]@(settings-flag=cssSettingsGroupDisabled)
        auto tryConsumeTerm1 = [&value1](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> bool {
            auto consumeTerm1 = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
                if (!state.context.cssSettingsGroupDisabled)
                    return { };
                // foo | bar
                switch (auto keyword = range.peek().id(); keyword) {
                case CSSValueID::CSSValueFoo:
                case CSSValueID::CSSValueBar:
                    range.consumeIncludingWhitespace();
                    return CSSPrimitiveValue::create(keyword);
                default:
                    return nullptr;
                }
            };
            if (value1)
                return false;
            value1 = consumeTerm1(range, state);
            return !!value1;
        };
        for (size_t i = 0; i < 2 && !range.atEnd(); ++i) {
            if (tryConsumeTerm0(range) || tryConsumeTerm1(range, state))
                continue;
            break;
        }
        CSSValueListBuilder list;
        if (value0) // none
            list.append(value0.releaseNonNull());
        if (value1) // [ foo | bar ]@(settings-flag=cssSettingsGroupDisabled)
            list.append(value1.releaseNonNull());
        if (list.isEmpty())
            return { };
        if (list.size() == 1)
            return WTFMove(list[0]); // single item optimization
        return CSSValueList::createSpaceSeparated(WTFMove(list));
    };
    return consumeMatchOneOrMoreAnyOrder(range, state);
}

static RefPtr<CSSValue> consumeTestNumericValueRange(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number [-inf,-10]>
    if (auto result = CSSPrimitiveValueResolver<CSS::Number<CSS::Range{-CSS::Range::infinity, -10}>>::consumeAndResolve(range, state))
        return result;
    // <length [0,inf]>
    if (auto result = CSSPrimitiveValueResolver<CSS::Length<CSS::Range{0, CSS::Range::infinity}>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow }))
        return result;
    // <angle [-90,90]>
    if (auto result = CSSPrimitiveValueResolver<CSS::Angle<CSS::Range{-90, 90}>>::consumeAndResolve(range, state, { .unitlessZeroAngle = UnitlessZeroQuirk::Forbid }))
        return result;
    // <percentage [1,100]>
    return CSSPrimitiveValueResolver<CSS::Percentage<CSS::Range{1, 100}>>::consumeAndResolve(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithCommasWithMin(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#{2,}
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds::minimumOf(2), ListOptimization::None, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithCommasWithMinNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#@(no-single-item-opt)
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds::minimumOf(1), ListOptimization::None, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithCommasWithMinSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>#
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<',', ListBounds::minimumOf(1), ListOptimization::SingleValue, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithSpacesNoMin(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>*
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds::minimumOf(0), ListOptimization::SingleValue, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithSpacesNoMinNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>*@(no-single-item-opt)
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds::minimumOf(0), ListOptimization::None, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithSpacesWithMin(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>{2,}
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds::minimumOf(2), ListOptimization::None, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithSpacesWithMinNoSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>+@(no-single-item-opt)
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds::minimumOf(1), ListOptimization::None, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUnboundedRepetitionWithSpacesWithMinSingleItemOpt(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <number>+
    auto consumeUnboundedRepetition = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
        auto consumeRepeatedTerm = [](CSSParserTokenRange& range, CSS::PropertyParserState& state) -> RefPtr<CSSValue> {
            // <number>
            return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
        };
        return consumeListSeparatedBy<' ', ListBounds::minimumOf(1), ListOptimization::SingleValue, CSSValueList>(range, consumeRepeatedTerm, state);
    };
    return consumeUnboundedRepetition(range, state);
}

static RefPtr<CSSValue> consumeTestUrlWithModifiers(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // none
    if (auto result = consumeIdent(range, isKeywordValidForTestUrlWithModifiers))
        return result;
    // <url allowed-modifiers=['crossorigin', 'integrity', 'referrerpolicy']>
    return consumeURL(range, state, { AllowedURLModifiers::CrossOrigin, AllowedURLModifiers::Integrity, AllowedURLModifiers::ReferrerPolicy });
}

static RefPtr<CSSValue> consumeTestUrlWithNoModifiers(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // none
    if (auto result = consumeIdent(range, isKeywordValidForTestUrlWithNoModifiers))
        return result;
    // <url>
    return consumeURL(range, state, { });
}

static RefPtr<CSSValue> consumeTestUsingSharedRule(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // auto
    if (auto result = consumeIdent(range, isKeywordValidForTestUsingSharedRule))
        return result;
    // <number>
    if (auto result = CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state))
        return result;
    // <percentage>
    return CSSPrimitiveValueResolver<CSS::Percentage<>>::consumeAndResolve(range, state);
}

static RefPtr<CSSValue> consumeTestUsingSharedRuleExported(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // auto
    if (auto result = consumeIdent(range, isKeywordValidForTestUsingSharedRuleExported))
        return result;
    // <length>
    if (auto result = CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow }))
        return result;
    // <string>
    return consumeString(range);
}

static RefPtr<CSSValue> consumeTestUsingSharedRuleWithOverrideFunction(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // auto
    if (auto result = consumeIdent(range, isKeywordValidForTestUsingSharedRuleWithOverrideFunction))
        return result;
    // <shared-rule-with-override-function-override-function>
    return consumeFunctionForSharedRule(range, state);
}

RefPtr<CSSValue> CSSPropertyParsing::consumeSharedRuleExported(CSSParserTokenRange& range, CSS::PropertyParserState& state)
{
    // <length>
    if (auto result = CSSPrimitiveValueResolver<CSS::Length<>>::consumeAndResolve(range, state, { .unitlessZeroLength = UnitlessZeroQuirk::Allow }))
        return result;
    // <string>
    return consumeString(range);
}

RefPtr<CSSValue> CSSPropertyParsing::parseStylePropertyLonghand(CSSParserTokenRange& range, CSSPropertyID id, CSS::PropertyParserState& state)
{
    if (!isExposed(id, state.context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return { };
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyTestTopPriority:
    case CSSPropertyID::CSSPropertyTestHighPriority:
    case CSSPropertyID::CSSPropertyTestMediumPriority:
    case CSSPropertyID::CSSPropertyTestAnimationWrapper:
    case CSSPropertyID::CSSPropertyTestAnimationWrapperAccelerationAlways:
    case CSSPropertyID::CSSPropertyTestAnimationWrapperAccelerationThreadedOnly:
    case CSSPropertyID::CSSPropertyTestCustomExtractor:
    case CSSPropertyID::CSSPropertyTestExtractorConverter:
    case CSSPropertyID::CSSPropertyTestProperty:
    case CSSPropertyID::CSSPropertyTestSettingsOne:
    case CSSPropertyID::CSSPropertyTestSharedBuilderExtractorConverter:
    case CSSPropertyID::CSSPropertyTestSinkPriority:
    case CSSPropertyID::CSSPropertyTestLogicalPropertyGroupPhysicalHorizontal:
    case CSSPropertyID::CSSPropertyTestLogicalPropertyGroupPhysicalVertical:
    case CSSPropertyID::CSSPropertyTestLogicalPropertyGroupLogicalBlock:
    case CSSPropertyID::CSSPropertyTestLogicalPropertyGroupLogicalInline:
        return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
    case CSSPropertyID::CSSPropertyBackgroundFillLayerTestPrimary:
        return consumeBackgroundFillLayerTestPrimary(range, state);
    case CSSPropertyID::CSSPropertyBackgroundFillLayerTestSecondary:
        return consumeBackgroundFillLayerTestSecondary(range, state);
    case CSSPropertyID::CSSPropertyBackgroundFillLayerTestSecondaryWithConverter:
        return consumeBackgroundFillLayerTestSecondaryWithConverter(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithCommas:
        return consumeTestBoundedRepetitionWithCommas(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithCommasFixed:
        return consumeTestBoundedRepetitionWithCommasFixed(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithCommasNoSingleItemOpt:
        return consumeTestBoundedRepetitionWithCommasNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithCommasSingleItemOpt:
        return consumeTestBoundedRepetitionWithCommasSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpaces:
        return consumeTestBoundedRepetitionWithSpaces(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpacesFixed:
        return consumeTestBoundedRepetitionWithSpacesFixed(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpacesNoSingleItemOpt:
        return consumeTestBoundedRepetitionWithSpacesNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpacesSingleItemOpt:
        return consumeTestBoundedRepetitionWithSpacesSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpacesWithType:
        return consumeTestBoundedRepetitionWithSpacesWithType(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpacesWithTypeNoSingleItemOpt:
        return consumeTestBoundedRepetitionWithSpacesWithTypeNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpacesWithTypeWithDefaultPrevious:
        return consumeTestBoundedRepetitionWithSpacesWithTypeWithDefaultPrevious(range, state);
    case CSSPropertyID::CSSPropertyTestBoundedRepetitionWithSpacesWithTypeWithDefaultPreviousTwo:
        return consumeTestBoundedRepetitionWithSpacesWithTypeWithDefaultPreviousTwo(range, state);
    case CSSPropertyID::CSSPropertyTestColor:
    case CSSPropertyID::CSSPropertyTestColorPropertyWithNoVisitedLinkSupport:
    case CSSPropertyID::CSSPropertyTestColorPropertyWithVisitedLinkSupport:
        return consumeColor(range, state, { .allowedColorTypes = { CSS::ColorType::Absolute, CSS::ColorType::Current, CSS::ColorType::System } });
    case CSSPropertyID::CSSPropertyTestColorAllowsTypesAbsolute:
        return consumeColor(range, state, { .allowedColorTypes = { CSS::ColorType::Absolute } });
    case CSSPropertyID::CSSPropertyTestFunctionBoundedParameters:
        return consumeTestFunctionBoundedParameters(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionFixedParameters:
        return consumeTestFunctionFixedParameters(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionNoParameters:
        return consumeTestFunctionNoParameters(range);
    case CSSPropertyID::CSSPropertyTestFunctionParametersMatchAllAnyOrder:
        return consumeTestFunctionParametersMatchAllAnyOrder(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionParametersMatchAllAnyOrderWithOptional:
        return consumeTestFunctionParametersMatchAllAnyOrderWithOptional(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionParametersMatchAllOrdered:
        return consumeTestFunctionParametersMatchAllOrdered(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionParametersMatchAllOrderedWithOptional:
        return consumeTestFunctionParametersMatchAllOrderedWithOptional(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionParametersMatchOneOrMoreAnyOrder:
        return consumeTestFunctionParametersMatchOneOrMoreAnyOrder(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionSingleParameter:
        return consumeTestFunctionSingleParameter(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionSingleParameterMatchOne:
        return consumeTestFunctionSingleParameterMatchOne(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionSingleParameterOptional:
        return consumeTestFunctionSingleParameterOptional(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionUnboundedParametersNoMin:
        return consumeTestFunctionUnboundedParametersNoMin(range, state);
    case CSSPropertyID::CSSPropertyTestFunctionUnboundedParametersWithMinimum:
        return consumeTestFunctionUnboundedParametersWithMinimum(range, state);
    case CSSPropertyID::CSSPropertyTestImage:
        return consumeImage(range, state, { AllowedImageType::URLFunction, AllowedImageType::ImageSet, AllowedImageType::GeneratedImage });
    case CSSPropertyID::CSSPropertyTestImageNoImageSet:
        return consumeImage(range, state, { AllowedImageType::URLFunction, AllowedImageType::GeneratedImage });
    case CSSPropertyID::CSSPropertyTestKeyword:
        return consumeIdent(range, isKeywordValidForTestKeyword);
    case CSSPropertyID::CSSPropertyTestKeywordWithAliasedTo:
        return consumeTestKeywordWithAliasedTo(range);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrder:
        return consumeTestMatchAllAnyOrder(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithCustomType:
        return consumeTestMatchAllAnyOrderWithCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptional:
        return consumeTestMatchAllAnyOrderWithOptional(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalAndCustomType:
        return consumeTestMatchAllAnyOrderWithOptionalAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomType:
        return consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomTypeNoSingleItemOpt:
        return consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndCustomTypeNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomType:
        return consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomTypeNoSingleItemOpt:
        return consumeTestMatchAllAnyOrderWithOptionalAndMultipleRequiredAndPreserveOrderAndCustomTypeNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalAndPreserveOrderAndCustomType:
        return consumeTestMatchAllAnyOrderWithOptionalAndPreserveOrderAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalNoSingleItemOpt:
        return consumeTestMatchAllAnyOrderWithOptionalNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalSingleItemOpt:
        return consumeTestMatchAllAnyOrderWithOptionalSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalWithPreserveOrder:
        return consumeTestMatchAllAnyOrderWithOptionalWithPreserveOrder(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithOptionalWithPreserveOrderNoSingleItemOpt:
        return consumeTestMatchAllAnyOrderWithOptionalWithPreserveOrderNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithPreserveOrder:
        return consumeTestMatchAllAnyOrderWithPreserveOrder(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithPreserveOrderAndCustomType:
        return consumeTestMatchAllAnyOrderWithPreserveOrderAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllAnyOrderWithPreserveOrderNoSingleItemOpt:
        return consumeTestMatchAllAnyOrderWithPreserveOrderNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrdered:
        return consumeTestMatchAllOrdered(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithCustomType:
        return consumeTestMatchAllOrderedWithCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithOptional:
        return consumeTestMatchAllOrderedWithOptional(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithOptionalAndCustomType:
        return consumeTestMatchAllOrderedWithOptionalAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithOptionalAndCustomTypeAndNoSingleItemOpt:
        return consumeTestMatchAllOrderedWithOptionalAndCustomTypeAndNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithOptionalAndMultipleRequired:
        return consumeTestMatchAllOrderedWithOptionalAndMultipleRequired(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithOptionalAndMultipleRequiredAndCustomType:
        return consumeTestMatchAllOrderedWithOptionalAndMultipleRequiredAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithOptionalNoSingleItemOpt:
        return consumeTestMatchAllOrderedWithOptionalNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchAllOrderedWithOptionalSingleItemOpt:
        return consumeTestMatchAllOrderedWithOptionalSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOne:
        return consumeTestMatchOne(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrder:
        return consumeTestMatchOneOrMoreAnyOrder(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrderNoSingleItemOpt:
        return consumeTestMatchOneOrMoreAnyOrderNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrderWithCustomType:
        return consumeTestMatchOneOrMoreAnyOrderWithCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrderWithCustomTypeNoSingleItemOpt:
        return consumeTestMatchOneOrMoreAnyOrderWithCustomTypeNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrder:
        return consumeTestMatchOneOrMoreAnyOrderWithPreserveOrder(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomType:
        return consumeTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomType(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomTypeNoSingleItemOpt:
        return consumeTestMatchOneOrMoreAnyOrderWithPreserveOrderAndCustomTypeNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneOrMoreAnyOrderWithPreserveOrderNoSingleItemOpt:
        return consumeTestMatchOneOrMoreAnyOrderWithPreserveOrderNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneWithGroupWithSettingsFlag:
        return consumeTestMatchOneWithGroupWithSettingsFlag(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneWithKeywordWithSettingsFlag:
        return consumeTestMatchOneWithKeywordWithSettingsFlag(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneWithMultipleKeywords:
        return consumeTestMatchOneWithMultipleKeywords(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneWithReferenceWithSettingsFlag:
        return consumeTestMatchOneWithReferenceWithSettingsFlag(range, state);
    case CSSPropertyID::CSSPropertyTestMatchOneWithSettingsFlag:
        return consumeTestMatchOneWithSettingsFlag(range, state);
    case CSSPropertyID::CSSPropertyTestNumericValueRange:
        return consumeTestNumericValueRange(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithCommasWithMin:
        return consumeTestUnboundedRepetitionWithCommasWithMin(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithCommasWithMinNoSingleItemOpt:
        return consumeTestUnboundedRepetitionWithCommasWithMinNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithCommasWithMinSingleItemOpt:
        return consumeTestUnboundedRepetitionWithCommasWithMinSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithSpacesNoMin:
        return consumeTestUnboundedRepetitionWithSpacesNoMin(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithSpacesNoMinNoSingleItemOpt:
        return consumeTestUnboundedRepetitionWithSpacesNoMinNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithSpacesWithMin:
        return consumeTestUnboundedRepetitionWithSpacesWithMin(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithSpacesWithMinNoSingleItemOpt:
        return consumeTestUnboundedRepetitionWithSpacesWithMinNoSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestUnboundedRepetitionWithSpacesWithMinSingleItemOpt:
        return consumeTestUnboundedRepetitionWithSpacesWithMinSingleItemOpt(range, state);
    case CSSPropertyID::CSSPropertyTestUrlWithModifiers:
        return consumeTestUrlWithModifiers(range, state);
    case CSSPropertyID::CSSPropertyTestUrlWithNoModifiers:
        return consumeTestUrlWithNoModifiers(range, state);
    case CSSPropertyID::CSSPropertyTestUsingSharedRule:
        return consumeTestUsingSharedRule(range, state);
    case CSSPropertyID::CSSPropertyTestUsingSharedRuleExported:
        return consumeTestUsingSharedRuleExported(range, state);
    case CSSPropertyID::CSSPropertyTestUsingSharedRuleWithOverrideFunction:
        return consumeTestUsingSharedRuleWithOverrideFunction(range, state);
    default:
        return { };
    }
}

bool CSSPropertyParsing::parseStylePropertyShorthand(CSSParserTokenRange& range, CSSPropertyID id, CSS::PropertyParserState& state, CSS::PropertyParserResult& result)
{
    ASSERT(isShorthand(id));

    switch (id) {
    case CSSPropertyID::CSSPropertyFont:
        return CSS::PropertyParserCustom::consumeFontShorthand(range, state, fontShorthand(), result);
    case CSSPropertyID::CSSPropertyTestShorthandOne:
        return CSS::PropertyParserCustom::consumeValues2Shorthand(range, state, testShorthandOneShorthandForParsing(), result);
    case CSSPropertyID::CSSPropertyTestShorthandTwo:
        if (!state.context.propertySettings.cssSettingsShorthandEnabled) {
            ASSERT_NOT_REACHED();
            return false;
        }
        return CSS::PropertyParserCustom::consumeCoalescingPairShorthand(range, state, testShorthandTwoShorthand(), result);
    default:
        return false;
    }
}

bool CSSPropertyParsing::isKeywordValidForStyleProperty(CSSPropertyID id, CSSValueID keyword, CSS::PropertyParserState& state)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyTestKeyword:
        return isKeywordValidForTestKeyword(keyword);
    case CSSPropertyID::CSSPropertyTestKeywordWithAliasedTo:
        return isKeywordValidForTestKeywordWithAliasedTo(keyword);
    case CSSPropertyID::CSSPropertyTestMatchOneWithGroupWithSettingsFlag:
        return isKeywordValidForTestMatchOneWithGroupWithSettingsFlag(keyword);
    case CSSPropertyID::CSSPropertyTestMatchOneWithKeywordWithSettingsFlag:
        return isKeywordValidForTestMatchOneWithKeywordWithSettingsFlag(keyword, state);
    case CSSPropertyID::CSSPropertyTestMatchOneWithMultipleKeywords:
        return isKeywordValidForTestMatchOneWithMultipleKeywords(keyword);
    case CSSPropertyID::CSSPropertyTestMatchOneWithReferenceWithSettingsFlag:
        return isKeywordValidForTestMatchOneWithReferenceWithSettingsFlag(keyword);
    case CSSPropertyID::CSSPropertyTestUrlWithModifiers:
        return isKeywordValidForTestUrlWithModifiers(keyword);
    case CSSPropertyID::CSSPropertyTestUrlWithNoModifiers:
        return isKeywordValidForTestUrlWithNoModifiers(keyword);
    case CSSPropertyID::CSSPropertyTestUsingSharedRule:
        return isKeywordValidForTestUsingSharedRule(keyword);
    case CSSPropertyID::CSSPropertyTestUsingSharedRuleExported:
        return isKeywordValidForTestUsingSharedRuleExported(keyword);
    case CSSPropertyID::CSSPropertyTestUsingSharedRuleWithOverrideFunction:
        return isKeywordValidForTestUsingSharedRuleWithOverrideFunction(keyword);
    default:
        return false;
    }
}

bool CSSPropertyParsing::isKeywordFastPathEligibleStyleProperty(CSSPropertyID id)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyTestKeyword:
    case CSSPropertyID::CSSPropertyTestKeywordWithAliasedTo:
    case CSSPropertyID::CSSPropertyTestMatchOneWithGroupWithSettingsFlag:
    case CSSPropertyID::CSSPropertyTestMatchOneWithKeywordWithSettingsFlag:
    case CSSPropertyID::CSSPropertyTestMatchOneWithMultipleKeywords:
    case CSSPropertyID::CSSPropertyTestMatchOneWithReferenceWithSettingsFlag:
    case CSSPropertyID::CSSPropertyTestUrlWithModifiers:
    case CSSPropertyID::CSSPropertyTestUrlWithNoModifiers:
    case CSSPropertyID::CSSPropertyTestUsingSharedRule:
    case CSSPropertyID::CSSPropertyTestUsingSharedRuleExported:
    case CSSPropertyID::CSSPropertyTestUsingSharedRuleWithOverrideFunction:
        return true;
    default:
        return false;
    }
}

RefPtr<CSSValue> CSSPropertyParsing::parseFirstAtRuleDescriptor(CSSParserTokenRange& range, CSSPropertyID id, CSS::PropertyParserState& state)
{
    if (!isExposed(id, state.context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return { };
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyFirstTestDescriptorForFirstDescriptor:
        return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
    default:
        return { };
    }
}

bool CSSPropertyParsing::isKeywordValidForFirstAtRuleDescriptor(CSSPropertyID, CSSValueID, CSS::PropertyParserState&)
{
    return false;
}

bool CSSPropertyParsing::isKeywordFastPathEligibleFirstAtRuleDescriptor(CSSPropertyID)
{
    return false;
}

RefPtr<CSSValue> CSSPropertyParsing::parseSecondAtRuleDescriptor(CSSParserTokenRange& range, CSSPropertyID id, CSS::PropertyParserState& state)
{
    if (!isExposed(id, state.context.propertySettings) && !isInternal(id)) {
        // Allow internal properties as we use them to parse several internal-only-shorthands (e.g. background-repeat),
        // and to handle certain DOM-exposed values (e.g. -webkit-font-size-delta from execCommand('FontSizeDelta')).
        ASSERT_NOT_REACHED();
        return { };
    }
    switch (id) {
    case CSSPropertyID::CSSPropertyFirstTestDescriptorForSecondDescriptor:
        return CSSPrimitiveValueResolver<CSS::Number<>>::consumeAndResolve(range, state);
    default:
        return { };
    }
}

bool CSSPropertyParsing::isKeywordValidForSecondAtRuleDescriptor(CSSPropertyID, CSSValueID, CSS::PropertyParserState&)
{
    return false;
}

bool CSSPropertyParsing::isKeywordFastPathEligibleSecondAtRuleDescriptor(CSSPropertyID)
{
    return false;
}

} // namespace WebCore

