# SPDX-License-Identifier: Apache-2.0
# Copyright (C) 2019-2021 Xilinx, Inc. All rights reserved.
#
message("-- Preparing XRT pkg-config")

if (${LINUX_FLAVOR} MATCHES "^(Ubuntu)")
  set(XRT_PKG_CONFIG_DIR "/usr/lib/pkgconfig")
elseif (${LINUX_FLAVOR} MATCHES "^(RedHat|CentOS|Amazon|Fedora|SUSE)")
  set(XRT_PKG_CONFIG_DIR "/usr/lib64/pkgconfig")
else ()
  set(XRT_PKG_CONFIG_DIR "/usr/share/pkgconfig")
endif ()

configure_file (
  ${CMAKE_SOURCE_DIR}/CMake/config/xrt.pc.in
  xrt.pc
  @ONLY
  )
install (
  FILES ${CMAKE_CURRENT_BINARY_DIR}/xrt.pc
  DESTINATION ${XRT_PKG_CONFIG_DIR}
  COMPONENT ${XRT_DEV_COMPONENT}
  )

configure_file (
  ${CMAKE_SOURCE_DIR}/CMake/config/libxmaapi.pc.in
  ${CMAKE_CURRENT_BINARY_DIR}/libxmaapi.pc
  @ONLY
  )
install (
  FILES ${CMAKE_CURRENT_BINARY_DIR}/libxmaapi.pc
  DESTINATION ${XRT_PKG_CONFIG_DIR}
  COMPONENT ${XRT_DEV_COMPONENT}
  )

configure_file (
  ${CMAKE_SOURCE_DIR}/CMake/config/libxmaplugin.pc.in
  ${CMAKE_CURRENT_BINARY_DIR}/libxmaplugin.pc
  @ONLY
  )
install (
  FILES ${CMAKE_CURRENT_BINARY_DIR}/libxmaplugin.pc
  DESTINATION ${XRT_PKG_CONFIG_DIR}
  COMPONENT ${XRT_DEV_COMPONENT}
  )

configure_file (
  ${CMAKE_SOURCE_DIR}/CMake/config/libxma2api.pc.in
  ${CMAKE_CURRENT_BINARY_DIR}/libxma2api.pc
  @ONLY
  )
install (
  FILES ${CMAKE_CURRENT_BINARY_DIR}/libxma2api.pc
  DESTINATION ${XRT_PKG_CONFIG_DIR}
  COMPONENT ${XRT_DEV_COMPONENT}
  )

configure_file (
  ${CMAKE_SOURCE_DIR}/CMake/config/libxma2plugin.pc.in
  ${CMAKE_CURRENT_BINARY_DIR}/libxma2plugin.pc
  @ONLY
  )
install (
  FILES ${CMAKE_CURRENT_BINARY_DIR}/libxma2plugin.pc
  DESTINATION ${XRT_PKG_CONFIG_DIR}
  COMPONENT ${XRT_DEV_COMPONENT}
  )


