/* riscv-opc.h.  RISC-V instruction opcode and CSR macros.
   Copyright (C) 2011-2025 Free Software Foundation, Inc.
   Contributed by Andrew Waterman

   This file is part of GDB, GAS, and the GNU binutils.

   GDB, GAS, and the GNU binutils are free software; you can redistribute
   them and/or modify them under the terms of the GNU General Public
   License as published by the Free Software Foundation; either version
   3, or (at your option) any later version.

   GDB, GAS, and the GNU binutils are distributed in the hope that they
   will be useful, but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#ifndef RISCV_ENCODING_H
#define RISCV_ENCODING_H
/* Instruction opcode macros.  */
#define MATCH_SLLI_RV32 0x1013
#define MASK_SLLI_RV32  0xfe00707f
#define MATCH_SRLI_RV32 0x5013
#define MASK_SRLI_RV32  0xfe00707f
#define MATCH_SRAI_RV32 0x40005013
#define MASK_SRAI_RV32  0xfe00707f
#define MATCH_FRFLAGS 0x102073
#define MASK_FRFLAGS  0xfffff07f
#define MATCH_FSFLAGS 0x101073
#define MASK_FSFLAGS  0xfff0707f
#define MATCH_FSFLAGSI 0x105073
#define MASK_FSFLAGSI  0xfff0707f
#define MATCH_FRRM 0x202073
#define MASK_FRRM  0xfffff07f
#define MATCH_FSRM 0x201073
#define MASK_FSRM  0xfff0707f
#define MATCH_FSRMI 0x205073
#define MASK_FSRMI  0xfff0707f
#define MATCH_FSCSR 0x301073
#define MASK_FSCSR  0xfff0707f
#define MATCH_FRCSR 0x302073
#define MASK_FRCSR  0xfffff07f
#define MATCH_RDCYCLE 0xc0002073
#define MASK_RDCYCLE  0xfffff07f
#define MATCH_RDTIME 0xc0102073
#define MASK_RDTIME  0xfffff07f
#define MATCH_RDINSTRET 0xc0202073
#define MASK_RDINSTRET  0xfffff07f
#define MATCH_RDCYCLEH 0xc8002073
#define MASK_RDCYCLEH  0xfffff07f
#define MATCH_RDTIMEH 0xc8102073
#define MASK_RDTIMEH  0xfffff07f
#define MATCH_RDINSTRETH 0xc8202073
#define MASK_RDINSTRETH  0xfffff07f
#define MATCH_SCALL 0x73
#define MASK_SCALL  0xffffffff
#define MATCH_SBREAK 0x100073
#define MASK_SBREAK  0xffffffff
#define MATCH_BEQ 0x63
#define MASK_BEQ  0x707f
#define MATCH_BNE 0x1063
#define MASK_BNE  0x707f
#define MATCH_BLT 0x4063
#define MASK_BLT  0x707f
#define MATCH_BGE 0x5063
#define MASK_BGE  0x707f
#define MATCH_BLTU 0x6063
#define MASK_BLTU  0x707f
#define MATCH_BGEU 0x7063
#define MASK_BGEU  0x707f
#define MATCH_JALR 0x67
#define MASK_JALR  0x707f
#define MATCH_JAL 0x6f
#define MASK_JAL  0x7f
#define MATCH_LUI 0x37
#define MASK_LUI  0x7f
#define MATCH_AUIPC 0x17
#define MASK_AUIPC  0x7f
#define MATCH_ADDI 0x13
#define MASK_ADDI  0x707f
#define MATCH_SLLI 0x1013
#define MASK_SLLI  0xfc00707f
#define MATCH_SLTI 0x2013
#define MASK_SLTI  0x707f
#define MATCH_SLTIU 0x3013
#define MASK_SLTIU  0x707f
#define MATCH_XORI 0x4013
#define MASK_XORI  0x707f
#define MATCH_SRLI 0x5013
#define MASK_SRLI  0xfc00707f
#define MATCH_SRAI 0x40005013
#define MASK_SRAI  0xfc00707f
#define MATCH_ORI 0x6013
#define MASK_ORI  0x707f
#define MATCH_ANDI 0x7013
#define MASK_ANDI  0x707f
#define MATCH_ADD 0x33
#define MASK_ADD  0xfe00707f
#define MATCH_SUB 0x40000033
#define MASK_SUB  0xfe00707f
#define MATCH_SLL 0x1033
#define MASK_SLL  0xfe00707f
#define MATCH_SLT 0x2033
#define MASK_SLT  0xfe00707f
#define MATCH_SLTU 0x3033
#define MASK_SLTU  0xfe00707f
#define MATCH_XOR 0x4033
#define MASK_XOR  0xfe00707f
#define MATCH_SRL 0x5033
#define MASK_SRL  0xfe00707f
#define MATCH_SRA 0x40005033
#define MASK_SRA  0xfe00707f
#define MATCH_OR 0x6033
#define MASK_OR  0xfe00707f
#define MATCH_AND 0x7033
#define MASK_AND  0xfe00707f
#define MATCH_ADDIW 0x1b
#define MASK_ADDIW  0x707f
#define MATCH_SLLIW 0x101b
#define MASK_SLLIW  0xfe00707f
#define MATCH_SRLIW 0x501b
#define MASK_SRLIW  0xfe00707f
#define MATCH_SRAIW 0x4000501b
#define MASK_SRAIW  0xfe00707f
#define MATCH_ADDW 0x3b
#define MASK_ADDW  0xfe00707f
#define MATCH_SUBW 0x4000003b
#define MASK_SUBW  0xfe00707f
#define MATCH_SLLW 0x103b
#define MASK_SLLW  0xfe00707f
#define MATCH_SRLW 0x503b
#define MASK_SRLW  0xfe00707f
#define MATCH_SRAW 0x4000503b
#define MASK_SRAW  0xfe00707f
#define MATCH_LB 0x3
#define MASK_LB  0x707f
#define MATCH_LH 0x1003
#define MASK_LH  0x707f
#define MATCH_LW 0x2003
#define MASK_LW  0x707f
#define MATCH_LD 0x3003
#define MASK_LD  0x707f
#define MATCH_LBU 0x4003
#define MASK_LBU  0x707f
#define MATCH_LHU 0x5003
#define MASK_LHU  0x707f
#define MATCH_LWU 0x6003
#define MASK_LWU  0x707f
#define MATCH_SB 0x23
#define MASK_SB  0x707f
#define MATCH_SH 0x1023
#define MASK_SH  0x707f
#define MATCH_SW 0x2023
#define MASK_SW  0x707f
#define MATCH_SD 0x3023
#define MASK_SD  0x707f
#define MATCH_PAUSE 0x0100000f
#define MASK_PAUSE  0xffffffff
#define MATCH_FENCE 0xf
#define MASK_FENCE  0x707f
#define MATCH_FENCE_I 0x100f
#define MASK_FENCE_I  0x707f
#define MATCH_FENCE_TSO 0x8330000f
#define MASK_FENCE_TSO  0xfff0707f
#define MATCH_MUL 0x2000033
#define MASK_MUL  0xfe00707f
#define MATCH_MULH 0x2001033
#define MASK_MULH  0xfe00707f
#define MATCH_MULHSU 0x2002033
#define MASK_MULHSU  0xfe00707f
#define MATCH_MULHU 0x2003033
#define MASK_MULHU  0xfe00707f
#define MATCH_DIV 0x2004033
#define MASK_DIV  0xfe00707f
#define MATCH_DIVU 0x2005033
#define MASK_DIVU  0xfe00707f
#define MATCH_REM 0x2006033
#define MASK_REM  0xfe00707f
#define MATCH_REMU 0x2007033
#define MASK_REMU  0xfe00707f
#define MATCH_MULW 0x200003b
#define MASK_MULW  0xfe00707f
#define MATCH_DIVW 0x200403b
#define MASK_DIVW  0xfe00707f
#define MATCH_DIVUW 0x200503b
#define MASK_DIVUW  0xfe00707f
#define MATCH_REMW 0x200603b
#define MASK_REMW  0xfe00707f
#define MATCH_REMUW 0x200703b
#define MASK_REMUW  0xfe00707f
#define MATCH_AMOADD_W 0x202f
#define MASK_AMOADD_W  0xf800707f
#define MATCH_AMOXOR_W 0x2000202f
#define MASK_AMOXOR_W  0xf800707f
#define MATCH_AMOOR_W 0x4000202f
#define MASK_AMOOR_W  0xf800707f
#define MATCH_AMOAND_W 0x6000202f
#define MASK_AMOAND_W  0xf800707f
#define MATCH_AMOMIN_W 0x8000202f
#define MASK_AMOMIN_W  0xf800707f
#define MATCH_AMOMAX_W 0xa000202f
#define MASK_AMOMAX_W  0xf800707f
#define MATCH_AMOMINU_W 0xc000202f
#define MASK_AMOMINU_W  0xf800707f
#define MATCH_AMOMAXU_W 0xe000202f
#define MASK_AMOMAXU_W  0xf800707f
#define MATCH_AMOSWAP_W 0x800202f
#define MASK_AMOSWAP_W  0xf800707f
#define MATCH_LR_W 0x1000202f
#define MASK_LR_W  0xf9f0707f
#define MATCH_SC_W 0x1800202f
#define MASK_SC_W  0xf800707f
#define MATCH_AMOADD_D 0x302f
#define MASK_AMOADD_D  0xf800707f
#define MATCH_AMOXOR_D 0x2000302f
#define MASK_AMOXOR_D  0xf800707f
#define MATCH_AMOOR_D 0x4000302f
#define MASK_AMOOR_D  0xf800707f
#define MATCH_AMOAND_D 0x6000302f
#define MASK_AMOAND_D  0xf800707f
#define MATCH_AMOMIN_D 0x8000302f
#define MASK_AMOMIN_D  0xf800707f
#define MATCH_AMOMAX_D 0xa000302f
#define MASK_AMOMAX_D  0xf800707f
#define MATCH_AMOMINU_D 0xc000302f
#define MASK_AMOMINU_D  0xf800707f
#define MATCH_AMOMAXU_D 0xe000302f
#define MASK_AMOMAXU_D  0xf800707f
#define MATCH_AMOSWAP_D 0x800302f
#define MASK_AMOSWAP_D  0xf800707f
#define MATCH_LR_D 0x1000302f
#define MASK_LR_D  0xf9f0707f
#define MATCH_SC_D 0x1800302f
#define MASK_SC_D  0xf800707f
#define MATCH_AMOADD_B 0x02f
#define MASK_AMOADD_B  0xf800707f
#define MATCH_AMOXOR_B 0x2000002f
#define MASK_AMOXOR_B  0xf800707f
#define MATCH_AMOOR_B 0x4000002f
#define MASK_AMOOR_B  0xf800707f
#define MATCH_AMOAND_B 0x6000002f
#define MASK_AMOAND_B  0xf800707f
#define MATCH_AMOMIN_B 0x8000002f
#define MASK_AMOMIN_B  0xf800707f
#define MATCH_AMOMAX_B 0xa000002f
#define MASK_AMOMAX_B  0xf800707f
#define MATCH_AMOMINU_B 0xc000002f
#define MASK_AMOMINU_B  0xf800707f
#define MATCH_AMOMAXU_B 0xe000002f
#define MASK_AMOMAXU_B  0xf800707f
#define MATCH_AMOSWAP_B 0x800002f
#define MASK_AMOSWAP_B  0xf800707f
#define MATCH_AMOCAS_B 0x2800002f
#define MASK_AMOCAS_B 0xf800707f
#define MATCH_AMOADD_H 0x102f
#define MASK_AMOADD_H  0xf800707f
#define MATCH_AMOXOR_H 0x2000102f
#define MASK_AMOXOR_H  0xf800707f
#define MATCH_AMOOR_H 0x4000102f
#define MASK_AMOOR_H  0xf800707f
#define MATCH_AMOAND_H 0x6000102f
#define MASK_AMOAND_H  0xf800707f
#define MATCH_AMOMIN_H 0x8000102f
#define MASK_AMOMIN_H  0xf800707f
#define MATCH_AMOMAX_H 0xa000102f
#define MASK_AMOMAX_H  0xf800707f
#define MATCH_AMOMINU_H 0xc000102f
#define MASK_AMOMINU_H  0xf800707f
#define MATCH_AMOMAXU_H 0xe000102f
#define MASK_AMOMAXU_H  0xf800707f
#define MATCH_AMOSWAP_H 0x800102f
#define MASK_AMOSWAP_H  0xf800707f
#define MATCH_AMOCAS_H 0x2800102f
#define MASK_AMOCAS_H 0xf800707f
#define MATCH_ECALL 0x73
#define MASK_ECALL  0xffffffff
#define MATCH_EBREAK 0x100073
#define MASK_EBREAK  0xffffffff
#define MATCH_URET 0x200073
#define MASK_URET  0xffffffff
#define MATCH_SRET 0x10200073
#define MASK_SRET  0xffffffff
#define MATCH_HRET 0x20200073
#define MASK_HRET  0xffffffff
#define MATCH_MRET 0x30200073
#define MASK_MRET  0xffffffff
#define MATCH_DRET 0x7b200073
#define MASK_DRET  0xffffffff
#define MATCH_SFENCE_VMA 0x12000073
#define MASK_SFENCE_VMA  0xfe007fff
#define MATCH_WFI 0x10500073
#define MASK_WFI  0xffffffff
#define MATCH_CSRRW 0x1073
#define MASK_CSRRW  0x707f
#define MATCH_CSRRS 0x2073
#define MASK_CSRRS  0x707f
#define MATCH_CSRRC 0x3073
#define MASK_CSRRC  0x707f
#define MATCH_CSRRWI 0x5073
#define MASK_CSRRWI  0x707f
#define MATCH_CSRRSI 0x6073
#define MASK_CSRRSI  0x707f
#define MATCH_CSRRCI 0x7073
#define MASK_CSRRCI  0x707f
#define MATCH_FADD_S 0x53
#define MASK_FADD_S  0xfe00007f
#define MATCH_FSUB_S 0x8000053
#define MASK_FSUB_S  0xfe00007f
#define MATCH_FMUL_S 0x10000053
#define MASK_FMUL_S  0xfe00007f
#define MATCH_FDIV_S 0x18000053
#define MASK_FDIV_S  0xfe00007f
#define MATCH_FSGNJ_S 0x20000053
#define MASK_FSGNJ_S  0xfe00707f
#define MATCH_FSGNJN_S 0x20001053
#define MASK_FSGNJN_S  0xfe00707f
#define MATCH_FSGNJX_S 0x20002053
#define MASK_FSGNJX_S  0xfe00707f
#define MATCH_FMIN_S 0x28000053
#define MASK_FMIN_S  0xfe00707f
#define MATCH_FMAX_S 0x28001053
#define MASK_FMAX_S  0xfe00707f
#define MATCH_FSQRT_S 0x58000053
#define MASK_FSQRT_S  0xfff0007f
#define MATCH_FADD_D 0x2000053
#define MASK_FADD_D  0xfe00007f
#define MATCH_FSUB_D 0xa000053
#define MASK_FSUB_D  0xfe00007f
#define MATCH_FMUL_D 0x12000053
#define MASK_FMUL_D  0xfe00007f
#define MATCH_FDIV_D 0x1a000053
#define MASK_FDIV_D  0xfe00007f
#define MATCH_FSGNJ_D 0x22000053
#define MASK_FSGNJ_D  0xfe00707f
#define MATCH_FSGNJN_D 0x22001053
#define MASK_FSGNJN_D  0xfe00707f
#define MATCH_FSGNJX_D 0x22002053
#define MASK_FSGNJX_D  0xfe00707f
#define MATCH_FMIN_D 0x2a000053
#define MASK_FMIN_D  0xfe00707f
#define MATCH_FMAX_D 0x2a001053
#define MASK_FMAX_D  0xfe00707f
#define MATCH_FCVT_S_D 0x40100053
#define MASK_FCVT_S_D  0xfff0007f
#define MATCH_FCVT_D_S 0x42000053
#define MASK_FCVT_D_S  0xfff0007f
#define MATCH_FSQRT_D 0x5a000053
#define MASK_FSQRT_D  0xfff0007f
#define MATCH_FADD_Q 0x6000053
#define MASK_FADD_Q  0xfe00007f
#define MATCH_FSUB_Q 0xe000053
#define MASK_FSUB_Q  0xfe00007f
#define MATCH_FMUL_Q 0x16000053
#define MASK_FMUL_Q  0xfe00007f
#define MATCH_FDIV_Q 0x1e000053
#define MASK_FDIV_Q  0xfe00007f
#define MATCH_FSGNJ_Q 0x26000053
#define MASK_FSGNJ_Q  0xfe00707f
#define MATCH_FSGNJN_Q 0x26001053
#define MASK_FSGNJN_Q  0xfe00707f
#define MATCH_FSGNJX_Q 0x26002053
#define MASK_FSGNJX_Q  0xfe00707f
#define MATCH_FMIN_Q 0x2e000053
#define MASK_FMIN_Q  0xfe00707f
#define MATCH_FMAX_Q 0x2e001053
#define MASK_FMAX_Q  0xfe00707f
#define MATCH_FCVT_S_Q 0x40300053
#define MASK_FCVT_S_Q  0xfff0007f
#define MATCH_FCVT_Q_S 0x46000053
#define MASK_FCVT_Q_S  0xfff0007f
#define MATCH_FCVT_D_Q 0x42300053
#define MASK_FCVT_D_Q  0xfff0007f
#define MATCH_FCVT_Q_D 0x46100053
#define MASK_FCVT_Q_D  0xfff0007f
#define MATCH_FSQRT_Q 0x5e000053
#define MASK_FSQRT_Q  0xfff0007f
#define MATCH_FLE_S 0xa0000053
#define MASK_FLE_S  0xfe00707f
#define MATCH_FLT_S 0xa0001053
#define MASK_FLT_S  0xfe00707f
#define MATCH_FEQ_S 0xa0002053
#define MASK_FEQ_S  0xfe00707f
#define MATCH_FLE_D 0xa2000053
#define MASK_FLE_D  0xfe00707f
#define MATCH_FLT_D 0xa2001053
#define MASK_FLT_D  0xfe00707f
#define MATCH_FEQ_D 0xa2002053
#define MASK_FEQ_D  0xfe00707f
#define MATCH_FLE_Q 0xa6000053
#define MASK_FLE_Q  0xfe00707f
#define MATCH_FLT_Q 0xa6001053
#define MASK_FLT_Q  0xfe00707f
#define MATCH_FEQ_Q 0xa6002053
#define MASK_FEQ_Q  0xfe00707f
#define MATCH_FCVT_W_S 0xc0000053
#define MASK_FCVT_W_S  0xfff0007f
#define MATCH_FCVT_WU_S 0xc0100053
#define MASK_FCVT_WU_S  0xfff0007f
#define MATCH_FCVT_L_S 0xc0200053
#define MASK_FCVT_L_S  0xfff0007f
#define MATCH_FCVT_LU_S 0xc0300053
#define MASK_FCVT_LU_S  0xfff0007f
#define MATCH_FMV_X_S 0xe0000053
#define MASK_FMV_X_S  0xfff0707f
#define MATCH_FCLASS_S 0xe0001053
#define MASK_FCLASS_S  0xfff0707f
#define MATCH_FCVT_W_D 0xc2000053
#define MASK_FCVT_W_D  0xfff0007f
#define MATCH_FCVT_WU_D 0xc2100053
#define MASK_FCVT_WU_D  0xfff0007f
#define MATCH_FCVT_L_D 0xc2200053
#define MASK_FCVT_L_D  0xfff0007f
#define MATCH_FCVT_LU_D 0xc2300053
#define MASK_FCVT_LU_D  0xfff0007f
#define MATCH_FMV_X_D 0xe2000053
#define MASK_FMV_X_D  0xfff0707f
#define MATCH_FCLASS_D 0xe2001053
#define MASK_FCLASS_D  0xfff0707f
#define MATCH_FCVT_W_Q 0xc6000053
#define MASK_FCVT_W_Q  0xfff0007f
#define MATCH_FCVT_WU_Q 0xc6100053
#define MASK_FCVT_WU_Q  0xfff0007f
#define MATCH_FCVT_L_Q 0xc6200053
#define MASK_FCVT_L_Q  0xfff0007f
#define MATCH_FCVT_LU_Q 0xc6300053
#define MASK_FCVT_LU_Q  0xfff0007f
#define MATCH_FCLASS_Q 0xe6001053
#define MASK_FCLASS_Q  0xfff0707f
#define MATCH_FCVT_S_W 0xd0000053
#define MASK_FCVT_S_W  0xfff0007f
#define MATCH_FCVT_S_WU 0xd0100053
#define MASK_FCVT_S_WU  0xfff0007f
#define MATCH_FCVT_S_L 0xd0200053
#define MASK_FCVT_S_L  0xfff0007f
#define MATCH_FCVT_S_LU 0xd0300053
#define MASK_FCVT_S_LU  0xfff0007f
#define MATCH_FMV_S_X 0xf0000053
#define MASK_FMV_S_X  0xfff0707f
#define MATCH_FCVT_D_W 0xd2000053
#define MASK_FCVT_D_W  0xfff0007f
#define MATCH_FCVT_D_WU 0xd2100053
#define MASK_FCVT_D_WU  0xfff0007f
#define MATCH_FCVT_D_L 0xd2200053
#define MASK_FCVT_D_L  0xfff0007f
#define MATCH_FCVT_D_LU 0xd2300053
#define MASK_FCVT_D_LU  0xfff0007f
#define MATCH_FMV_D_X 0xf2000053
#define MASK_FMV_D_X  0xfff0707f
#define MATCH_FCVT_Q_W 0xd6000053
#define MASK_FCVT_Q_W  0xfff0007f
#define MATCH_FCVT_Q_WU 0xd6100053
#define MASK_FCVT_Q_WU  0xfff0007f
#define MATCH_FCVT_Q_L 0xd6200053
#define MASK_FCVT_Q_L  0xfff0007f
#define MATCH_FCVT_Q_LU 0xd6300053
#define MASK_FCVT_Q_LU  0xfff0007f
#define MATCH_FLI_H 0xf4100053
#define MASK_FLI_H 0xfff0707f
#define MATCH_FMINM_H 0x2c002053
#define MASK_FMINM_H 0xfe00707f
#define MATCH_FMAXM_H 0x2c003053
#define MASK_FMAXM_H 0xfe00707f
#define MATCH_FROUND_H 0x44400053
#define MASK_FROUND_H 0xfff0007f
#define MATCH_FROUNDNX_H 0x44500053
#define MASK_FROUNDNX_H 0xfff0007f
#define MATCH_FLTQ_H 0xa4005053
#define MASK_FLTQ_H 0xfe00707f
#define MATCH_FLEQ_H 0xa4004053
#define MASK_FLEQ_H 0xfe00707f
#define MATCH_FLI_S 0xf0100053
#define MASK_FLI_S 0xfff0707f
#define MATCH_FMINM_S 0x28002053
#define MASK_FMINM_S 0xfe00707f
#define MATCH_FMAXM_S 0x28003053
#define MASK_FMAXM_S 0xfe00707f
#define MATCH_FROUND_S 0x40400053
#define MASK_FROUND_S 0xfff0007f
#define MATCH_FROUNDNX_S 0x40500053
#define MASK_FROUNDNX_S 0xfff0007f
#define MATCH_FLTQ_S 0xa0005053
#define MASK_FLTQ_S 0xfe00707f
#define MATCH_FLEQ_S 0xa0004053
#define MASK_FLEQ_S 0xfe00707f
#define MATCH_FLI_D 0xf2100053
#define MASK_FLI_D 0xfff0707f
#define MATCH_FMINM_D 0x2a002053
#define MASK_FMINM_D 0xfe00707f
#define MATCH_FMAXM_D 0x2a003053
#define MASK_FMAXM_D 0xfe00707f
#define MATCH_FROUND_D 0x42400053
#define MASK_FROUND_D 0xfff0007f
#define MATCH_FROUNDNX_D 0x42500053
#define MASK_FROUNDNX_D 0xfff0007f
#define MATCH_FLTQ_D 0xa2005053
#define MASK_FLTQ_D 0xfe00707f
#define MATCH_FLEQ_D 0xa2004053
#define MASK_FLEQ_D 0xfe00707f
#define MATCH_FLI_Q 0xf6100053
#define MASK_FLI_Q 0xfff0707f
#define MATCH_FMINM_Q 0x2e002053
#define MASK_FMINM_Q 0xfe00707f
#define MATCH_FMAXM_Q 0x2e003053
#define MASK_FMAXM_Q 0xfe00707f
#define MATCH_FROUND_Q 0x46400053
#define MASK_FROUND_Q 0xfff0007f
#define MATCH_FROUNDNX_Q 0x46500053
#define MASK_FROUNDNX_Q 0xfff0007f
#define MATCH_FLTQ_Q 0xa6005053
#define MASK_FLTQ_Q 0xfe00707f
#define MATCH_FLEQ_Q 0xa6004053
#define MASK_FLEQ_Q 0xfe00707f
#define MATCH_FCVTMOD_W_D 0xc2801053
#define MASK_FCVTMOD_W_D 0xfff0707f
#define MATCH_FMVH_X_D 0xe2100053
#define MASK_FMVH_X_D 0xfff0707f
#define MATCH_FMVH_X_Q 0xe6100053
#define MASK_FMVH_X_Q 0xfff0707f
#define MATCH_FMVP_D_X 0xb2000053
#define MASK_FMVP_D_X 0xfe00707f
#define MATCH_FMVP_Q_X 0xb6000053
#define MASK_FMVP_Q_X 0xfe00707f
#define MATCH_CLZ 0x60001013
#define MASK_CLZ  0xfff0707f
#define MATCH_CTZ 0x60101013
#define MASK_CTZ  0xfff0707f
#define MATCH_CPOP 0x60201013
#define MASK_CPOP  0xfff0707f
#define MATCH_MIN 0xa004033
#define MASK_MIN  0xfe00707f
#define MATCH_MINU 0xa005033
#define MASK_MINU  0xfe00707f
#define MATCH_MAX 0xa006033
#define MASK_MAX  0xfe00707f
#define MATCH_MAXU 0xa007033
#define MASK_MAXU  0xfe00707f
#define MATCH_SEXT_B 0x60401013
#define MASK_SEXT_B  0xfff0707f
#define MATCH_SEXT_H 0x60501013
#define MASK_SEXT_H  0xfff0707f
#define MATCH_PACK 0x8004033
#define MASK_PACK  0xfe00707f
#define MATCH_PACKH 0x8007033
#define MASK_PACKH  0xfe00707f
#define MATCH_PACKW 0x800403b
#define MASK_PACKW  0xfe00707f
#define MATCH_ANDN 0x40007033
#define MASK_ANDN  0xfe00707f
#define MATCH_ORN 0x40006033
#define MASK_ORN  0xfe00707f
#define MATCH_XNOR 0x40004033
#define MASK_XNOR  0xfe00707f
#define MATCH_ROL 0x60001033
#define MASK_ROL  0xfe00707f
#define MATCH_ROR 0x60005033
#define MASK_ROR  0xfe00707f
#define MATCH_RORI 0x60005013
#define MASK_RORI  0xfc00707f
#define MATCH_GREVI 0x68005013
#define MASK_GREVI  0xfc00707f
#define MATCH_GORCI 0x28005013
#define MASK_GORCI  0xfc00707f
#define MATCH_SHFLI 0x8001013
#define MASK_SHFLI  0xfe00707f
#define MATCH_UNSHFLI 0x8005013
#define MASK_UNSHFLI  0xfe00707f
#define MATCH_CLZW 0x6000101b
#define MASK_CLZW  0xfff0707f
#define MATCH_CTZW 0x6010101b
#define MASK_CTZW  0xfff0707f
#define MATCH_CPOPW 0x6020101b
#define MASK_CPOPW  0xfff0707f
#define MATCH_ROLW 0x6000103b
#define MASK_ROLW  0xfe00707f
#define MATCH_RORW 0x6000503b
#define MASK_RORW  0xfe00707f
#define MATCH_RORIW 0x6000501b
#define MASK_RORIW  0xfe00707f
#define MATCH_SH1ADD 0x20002033
#define MASK_SH1ADD  0xfe00707f
#define MATCH_SH2ADD 0x20004033
#define MASK_SH2ADD  0xfe00707f
#define MATCH_SH3ADD 0x20006033
#define MASK_SH3ADD  0xfe00707f
#define MATCH_SH1ADD_UW 0x2000203b
#define MASK_SH1ADD_UW  0xfe00707f
#define MATCH_SH2ADD_UW 0x2000403b
#define MASK_SH2ADD_UW  0xfe00707f
#define MATCH_SH3ADD_UW 0x2000603b
#define MASK_SH3ADD_UW  0xfe00707f
#define MATCH_ADD_UW 0x800003b
#define MASK_ADD_UW  0xfe00707f
#define MATCH_SLLI_UW 0x800101b
#define MASK_SLLI_UW  0xfc00707f
#define MATCH_CLMUL 0xa001033
#define MASK_CLMUL  0xfe00707f
#define MATCH_CLMULH 0xa003033
#define MASK_CLMULH  0xfe00707f
#define MATCH_CLMULR 0xa002033
#define MASK_CLMULR  0xfe00707f
#define MATCH_XPERM4 0x28002033
#define MASK_XPERM4  0xfe00707f
#define MATCH_XPERM8 0x28004033
#define MASK_XPERM8  0xfe00707f
#define MATCH_BCLRI 0x48001013
#define MASK_BCLRI  0xfc00707f
#define MATCH_BSETI 0x28001013
#define MASK_BSETI  0xfc00707f
#define MATCH_BINVI 0x68001013
#define MASK_BINVI  0xfc00707f
#define MATCH_BEXTI 0x48005013
#define MASK_BEXTI  0xfc00707f
#define MATCH_BCLR  0x48001033
#define MASK_BCLR   0xfe00707f
#define MATCH_BSET  0x28001033
#define MASK_BSET   0xfe00707f
#define MATCH_BINV  0x68001033
#define MASK_BINV   0xfe00707f
#define MATCH_BEXT  0x48005033
#define MASK_BEXT   0xfe00707f
#define MATCH_FLW 0x2007
#define MASK_FLW  0x707f
#define MATCH_FLD 0x3007
#define MASK_FLD  0x707f
#define MATCH_FLQ 0x4007
#define MASK_FLQ  0x707f
#define MATCH_FSW 0x2027
#define MASK_FSW  0x707f
#define MATCH_FSD 0x3027
#define MASK_FSD  0x707f
#define MATCH_FSQ 0x4027
#define MASK_FSQ  0x707f
#define MATCH_FMADD_S 0x43
#define MASK_FMADD_S  0x600007f
#define MATCH_FMSUB_S 0x47
#define MASK_FMSUB_S  0x600007f
#define MATCH_FNMSUB_S 0x4b
#define MASK_FNMSUB_S  0x600007f
#define MATCH_FNMADD_S 0x4f
#define MASK_FNMADD_S  0x600007f
#define MATCH_FMADD_D 0x2000043
#define MASK_FMADD_D  0x600007f
#define MATCH_FMSUB_D 0x2000047
#define MASK_FMSUB_D  0x600007f
#define MATCH_FNMSUB_D 0x200004b
#define MASK_FNMSUB_D  0x600007f
#define MATCH_FNMADD_D 0x200004f
#define MASK_FNMADD_D  0x600007f
#define MATCH_FMADD_Q 0x6000043
#define MASK_FMADD_Q  0x600007f
#define MATCH_FMSUB_Q 0x6000047
#define MASK_FMSUB_Q  0x600007f
#define MATCH_FNMSUB_Q 0x600004b
#define MASK_FNMSUB_Q  0x600007f
#define MATCH_FNMADD_Q 0x600004f
#define MASK_FNMADD_Q  0x600007f
#define MATCH_C_ADDI4SPN 0x0
#define MASK_C_ADDI4SPN  0xe003
#define MATCH_C_FLD 0x2000
#define MASK_C_FLD  0xe003
#define MATCH_C_LW 0x4000
#define MASK_C_LW  0xe003
#define MATCH_C_FLW 0x6000
#define MASK_C_FLW  0xe003
#define MATCH_C_FSD 0xa000
#define MASK_C_FSD  0xe003
#define MATCH_C_SW 0xc000
#define MASK_C_SW  0xe003
#define MATCH_C_FSW 0xe000
#define MASK_C_FSW  0xe003
#define MATCH_C_ADDI 0x1
#define MASK_C_ADDI  0xe003
#define MATCH_C_JAL 0x2001
#define MASK_C_JAL  0xe003
#define MATCH_C_LI 0x4001
#define MASK_C_LI  0xe003
#define MATCH_C_LUI 0x6001
#define MASK_C_LUI  0xe003
#define MATCH_C_SRLI 0x8001
#define MASK_C_SRLI  0xec03
#define MATCH_C_SRLI64 0x8001
#define MASK_C_SRLI64  0xfc7f
#define MATCH_C_SRAI 0x8401
#define MASK_C_SRAI  0xec03
#define MATCH_C_SRAI64 0x8401
#define MASK_C_SRAI64  0xfc7f
#define MATCH_C_ANDI 0x8801
#define MASK_C_ANDI  0xec03
#define MATCH_C_SUB 0x8c01
#define MASK_C_SUB  0xfc63
#define MATCH_C_XOR 0x8c21
#define MASK_C_XOR  0xfc63
#define MATCH_C_OR 0x8c41
#define MASK_C_OR  0xfc63
#define MATCH_C_AND 0x8c61
#define MASK_C_AND  0xfc63
#define MATCH_C_SUBW 0x9c01
#define MASK_C_SUBW  0xfc63
#define MATCH_C_ADDW 0x9c21
#define MASK_C_ADDW  0xfc63
#define MATCH_C_J 0xa001
#define MASK_C_J  0xe003
#define MATCH_C_BEQZ 0xc001
#define MASK_C_BEQZ  0xe003
#define MATCH_C_BNEZ 0xe001
#define MASK_C_BNEZ  0xe003
#define MATCH_C_SLLI 0x2
#define MASK_C_SLLI  0xe003
#define MATCH_C_SLLI64 0x2
#define MASK_C_SLLI64 0xf07f
#define MATCH_C_FLDSP 0x2002
#define MASK_C_FLDSP  0xe003
#define MATCH_C_LWSP 0x4002
#define MASK_C_LWSP  0xe003
#define MATCH_C_FLWSP 0x6002
#define MASK_C_FLWSP  0xe003
#define MATCH_C_MV 0x8002
#define MASK_C_MV  0xf003
#define MATCH_C_ADD 0x9002
#define MASK_C_ADD  0xf003
#define MATCH_C_FSDSP 0xa002
#define MASK_C_FSDSP  0xe003
#define MATCH_C_SWSP 0xc002
#define MASK_C_SWSP  0xe003
#define MATCH_C_FSWSP 0xe002
#define MASK_C_FSWSP  0xe003
#define MATCH_C_NOP 0x1
#define MASK_C_NOP  0xffff
#define MATCH_C_ADDI16SP 0x6101
#define MASK_C_ADDI16SP  0xef83
#define MATCH_C_JR 0x8002
#define MASK_C_JR  0xf07f
#define MATCH_C_JALR 0x9002
#define MASK_C_JALR  0xf07f
#define MATCH_C_EBREAK 0x9002
#define MASK_C_EBREAK  0xffff
#define MATCH_C_LD 0x6000
#define MASK_C_LD  0xe003
#define MATCH_C_SD 0xe000
#define MASK_C_SD  0xe003
#define MATCH_C_ADDIW 0x2001
#define MASK_C_ADDIW  0xe003
#define MATCH_C_LDSP 0x6002
#define MASK_C_LDSP  0xe003
#define MATCH_C_SDSP 0xe002
#define MASK_C_SDSP  0xe003
#define MATCH_SM3P0 0x10801013
#define MASK_SM3P0  0xfff0707f
#define MATCH_SM3P1 0x10901013
#define MASK_SM3P1  0xfff0707f
#define MATCH_SHA256SUM0 0x10001013
#define MASK_SHA256SUM0  0xfff0707f
#define MATCH_SHA256SUM1 0x10101013
#define MASK_SHA256SUM1  0xfff0707f
#define MATCH_SHA256SIG0 0x10201013
#define MASK_SHA256SIG0  0xfff0707f
#define MATCH_SHA256SIG1 0x10301013
#define MASK_SHA256SIG1  0xfff0707f
#define MATCH_SHA512SUM0R 0x50000033
#define MASK_SHA512SUM0R  0xfe00707f
#define MATCH_SHA512SUM1R 0x52000033
#define MASK_SHA512SUM1R  0xfe00707f
#define MATCH_SHA512SIG0L 0x54000033
#define MASK_SHA512SIG0L  0xfe00707f
#define MATCH_SHA512SIG0H 0x5c000033
#define MASK_SHA512SIG0H  0xfe00707f
#define MATCH_SHA512SIG1L 0x56000033
#define MASK_SHA512SIG1L  0xfe00707f
#define MATCH_SHA512SIG1H 0x5e000033
#define MASK_SHA512SIG1H  0xfe00707f
#define MATCH_SM4ED 0x30000033
#define MASK_SM4ED  0x3e00707f
#define MATCH_SM4KS 0x34000033
#define MASK_SM4KS  0x3e00707f
#define MATCH_AES32ESMI 0x26000033
#define MASK_AES32ESMI  0x3e00707f
#define MATCH_AES32ESI 0x22000033
#define MASK_AES32ESI  0x3e00707f
#define MATCH_AES32DSMI 0x2e000033
#define MASK_AES32DSMI  0x3e00707f
#define MATCH_AES32DSI 0x2a000033
#define MASK_AES32DSI  0x3e00707f
#define MATCH_SHA512SUM0 0x10401013
#define MASK_SHA512SUM0  0xfff0707f
#define MATCH_SHA512SUM1 0x10501013
#define MASK_SHA512SUM1  0xfff0707f
#define MATCH_SHA512SIG0 0x10601013
#define MASK_SHA512SIG0  0xfff0707f
#define MATCH_SHA512SIG1 0x10701013
#define MASK_SHA512SIG1  0xfff0707f
#define MATCH_AES64KS1I 0x31001013
#define MASK_AES64KS1I  0xff00707f
#define MATCH_AES64IM 0x30001013
#define MASK_AES64IM  0xfff0707f
#define MATCH_AES64KS2 0x7e000033
#define MASK_AES64KS2  0xfe00707f
#define MATCH_AES64ESM 0x36000033
#define MASK_AES64ESM  0xfe00707f
#define MATCH_AES64ES 0x32000033
#define MASK_AES64ES  0xfe00707f
#define MATCH_AES64DSM 0x3e000033
#define MASK_AES64DSM  0xfe00707f
#define MATCH_AES64DS 0x3a000033
#define MASK_AES64DS  0xfe00707f
#define MATCH_FADD_H 0x4000053
#define MASK_FADD_H 0xfe00007f
#define MATCH_FSUB_H 0xc000053
#define MASK_FSUB_H 0xfe00007f
#define MATCH_FMUL_H 0x14000053
#define MASK_FMUL_H 0xfe00007f
#define MATCH_FDIV_H 0x1c000053
#define MASK_FDIV_H 0xfe00007f
#define MATCH_FSGNJ_H 0x24000053
#define MASK_FSGNJ_H 0xfe00707f
#define MATCH_FSGNJN_H 0x24001053
#define MASK_FSGNJN_H 0xfe00707f
#define MATCH_FSGNJX_H 0x24002053
#define MASK_FSGNJX_H 0xfe00707f
#define MATCH_FMIN_H 0x2c000053
#define MASK_FMIN_H 0xfe00707f
#define MATCH_FMAX_H 0x2c001053
#define MASK_FMAX_H 0xfe00707f
#define MATCH_FCVT_H_S 0x44000053
#define MASK_FCVT_H_S 0xfff0007f
#define MATCH_FCVT_S_H 0x40200053
#define MASK_FCVT_S_H 0xfff0007f
#define MATCH_FSQRT_H 0x5c000053
#define MASK_FSQRT_H 0xfff0007f
#define MATCH_FLE_H 0xa4000053
#define MASK_FLE_H 0xfe00707f
#define MATCH_FLT_H 0xa4001053
#define MASK_FLT_H 0xfe00707f
#define MATCH_FEQ_H 0xa4002053
#define MASK_FEQ_H 0xfe00707f
#define MATCH_FCVT_W_H 0xc4000053
#define MASK_FCVT_W_H 0xfff0007f
#define MATCH_FCVT_WU_H 0xc4100053
#define MASK_FCVT_WU_H 0xfff0007f
#define MATCH_FMV_X_H 0xe4000053
#define MASK_FMV_X_H 0xfff0707f
#define MATCH_FCLASS_H 0xe4001053
#define MASK_FCLASS_H 0xfff0707f
#define MATCH_FCVT_H_W 0xd4000053
#define MASK_FCVT_H_W 0xfff0007f
#define MATCH_FCVT_H_WU 0xd4100053
#define MASK_FCVT_H_WU 0xfff0007f
#define MATCH_FMV_H_X 0xf4000053
#define MASK_FMV_H_X 0xfff0707f
#define MATCH_FLH 0x1007
#define MASK_FLH 0x707f
#define MATCH_FSH 0x1027
#define MASK_FSH 0x707f
#define MATCH_FMADD_H 0x4000043
#define MASK_FMADD_H 0x600007f
#define MATCH_FMSUB_H 0x4000047
#define MASK_FMSUB_H 0x600007f
#define MATCH_FNMSUB_H 0x400004b
#define MASK_FNMSUB_H 0x600007f
#define MATCH_FNMADD_H 0x400004f
#define MASK_FNMADD_H 0x600007f
#define MATCH_FCVT_H_D 0x44100053
#define MASK_FCVT_H_D 0xfff0007f
#define MATCH_FCVT_D_H 0x42200053
#define MASK_FCVT_D_H 0xfff0007f
#define MATCH_FCVT_H_Q 0x44300053
#define MASK_FCVT_H_Q 0xfff0007f
#define MATCH_FCVT_Q_H 0x46200053
#define MASK_FCVT_Q_H 0xfff0007f
#define MATCH_FCVT_L_H 0xc4200053
#define MASK_FCVT_L_H 0xfff0007f
#define MATCH_FCVT_LU_H 0xc4300053
#define MASK_FCVT_LU_H 0xfff0007f
#define MATCH_FCVT_H_L 0xd4200053
#define MASK_FCVT_H_L 0xfff0007f
#define MATCH_FCVT_H_LU 0xd4300053
#define MASK_FCVT_H_LU 0xfff0007f
#define MATCH_VSETVL  0x80007057
#define MASK_VSETVL  0xfe00707f
#define MATCH_VSETIVLI  0xc0007057
#define MASK_VSETIVLI  0xc000707f
#define MATCH_VSETVLI  0x00007057
#define MASK_VSETVLI  0x8000707f
#define MATCH_VLMV  0x02b00007
#define MASK_VLMV  0xfff0707f
#define MATCH_VSMV  0x02b00027
#define MASK_VSMV  0xfff0707f
#define MATCH_VLE8V  0x00000007
#define MASK_VLE8V  0xfdf0707f
#define MATCH_VLE16V  0x00005007
#define MASK_VLE16V  0xfdf0707f
#define MATCH_VLE32V  0x00006007
#define MASK_VLE32V  0xfdf0707f
#define MATCH_VLE64V  0x00007007
#define MASK_VLE64V  0xfdf0707f
#define MATCH_VSE8V  0x00000027
#define MASK_VSE8V  0xfdf0707f
#define MATCH_VSE16V  0x00005027
#define MASK_VSE16V  0xfdf0707f
#define MATCH_VSE32V  0x00006027
#define MASK_VSE32V  0xfdf0707f
#define MATCH_VSE64V  0x00007027
#define MASK_VSE64V  0xfdf0707f
#define MATCH_VLSE8V  0x08000007
#define MASK_VLSE8V  0xfc00707f
#define MATCH_VLSE16V  0x08005007
#define MASK_VLSE16V  0xfc00707f
#define MATCH_VLSE32V  0x08006007
#define MASK_VLSE32V  0xfc00707f
#define MATCH_VLSE64V  0x08007007
#define MASK_VLSE64V  0xfc00707f
#define MATCH_VSSE8V  0x08000027
#define MASK_VSSE8V  0xfc00707f
#define MATCH_VSSE16V  0x08005027
#define MASK_VSSE16V  0xfc00707f
#define MATCH_VSSE32V  0x08006027
#define MASK_VSSE32V  0xfc00707f
#define MATCH_VSSE64V  0x08007027
#define MASK_VSSE64V  0xfc00707f
#define MATCH_VLOXEI8V  0x0c000007
#define MASK_VLOXEI8V  0xfc00707f
#define MATCH_VLOXEI16V  0x0c005007
#define MASK_VLOXEI16V  0xfc00707f
#define MATCH_VLOXEI32V  0x0c006007
#define MASK_VLOXEI32V  0xfc00707f
#define MATCH_VLOXEI64V  0x0c007007
#define MASK_VLOXEI64V  0xfc00707f
#define MATCH_VSOXEI8V  0x0c000027
#define MASK_VSOXEI8V  0xfc00707f
#define MATCH_VSOXEI16V  0x0c005027
#define MASK_VSOXEI16V  0xfc00707f
#define MATCH_VSOXEI32V  0x0c006027
#define MASK_VSOXEI32V  0xfc00707f
#define MATCH_VSOXEI64V  0x0c007027
#define MASK_VSOXEI64V  0xfc00707f
#define MATCH_VLUXEI8V  0x04000007
#define MASK_VLUXEI8V  0xfc00707f
#define MATCH_VLUXEI16V  0x04005007
#define MASK_VLUXEI16V  0xfc00707f
#define MATCH_VLUXEI32V  0x04006007
#define MASK_VLUXEI32V  0xfc00707f
#define MATCH_VLUXEI64V  0x04007007
#define MASK_VLUXEI64V  0xfc00707f
#define MATCH_VSUXEI8V  0x04000027
#define MASK_VSUXEI8V  0xfc00707f
#define MATCH_VSUXEI16V  0x04005027
#define MASK_VSUXEI16V  0xfc00707f
#define MATCH_VSUXEI32V  0x04006027
#define MASK_VSUXEI32V  0xfc00707f
#define MATCH_VSUXEI64V  0x04007027
#define MASK_VSUXEI64V  0xfc00707f
#define MATCH_VLE8FFV  0x01000007
#define MASK_VLE8FFV  0xfdf0707f
#define MATCH_VLE16FFV  0x01005007
#define MASK_VLE16FFV  0xfdf0707f
#define MATCH_VLE32FFV  0x01006007
#define MASK_VLE32FFV  0xfdf0707f
#define MATCH_VLE64FFV  0x01007007
#define MASK_VLE64FFV  0xfdf0707f
#define MATCH_VLSEG2E8V  0x20000007
#define MASK_VLSEG2E8V  0xfdf0707f
#define MATCH_VSSEG2E8V  0x20000027
#define MASK_VSSEG2E8V  0xfdf0707f
#define MATCH_VLSEG3E8V  0x40000007
#define MASK_VLSEG3E8V  0xfdf0707f
#define MATCH_VSSEG3E8V  0x40000027
#define MASK_VSSEG3E8V  0xfdf0707f
#define MATCH_VLSEG4E8V  0x60000007
#define MASK_VLSEG4E8V  0xfdf0707f
#define MATCH_VSSEG4E8V  0x60000027
#define MASK_VSSEG4E8V  0xfdf0707f
#define MATCH_VLSEG5E8V  0x80000007
#define MASK_VLSEG5E8V  0xfdf0707f
#define MATCH_VSSEG5E8V  0x80000027
#define MASK_VSSEG5E8V  0xfdf0707f
#define MATCH_VLSEG6E8V  0xa0000007
#define MASK_VLSEG6E8V  0xfdf0707f
#define MATCH_VSSEG6E8V  0xa0000027
#define MASK_VSSEG6E8V  0xfdf0707f
#define MATCH_VLSEG7E8V  0xc0000007
#define MASK_VLSEG7E8V  0xfdf0707f
#define MATCH_VSSEG7E8V  0xc0000027
#define MASK_VSSEG7E8V  0xfdf0707f
#define MATCH_VLSEG8E8V  0xe0000007
#define MASK_VLSEG8E8V  0xfdf0707f
#define MATCH_VSSEG8E8V  0xe0000027
#define MASK_VSSEG8E8V  0xfdf0707f
#define MATCH_VLSEG2E16V 0x20005007
#define MASK_VLSEG2E16V  0xfdf0707f
#define MATCH_VSSEG2E16V 0x20005027
#define MASK_VSSEG2E16V  0xfdf0707f
#define MATCH_VLSEG3E16V 0x40005007
#define MASK_VLSEG3E16V  0xfdf0707f
#define MATCH_VSSEG3E16V 0x40005027
#define MASK_VSSEG3E16V  0xfdf0707f
#define MATCH_VLSEG4E16V 0x60005007
#define MASK_VLSEG4E16V  0xfdf0707f
#define MATCH_VSSEG4E16V 0x60005027
#define MASK_VSSEG4E16V  0xfdf0707f
#define MATCH_VLSEG5E16V 0x80005007
#define MASK_VLSEG5E16V  0xfdf0707f
#define MATCH_VSSEG5E16V 0x80005027
#define MASK_VSSEG5E16V  0xfdf0707f
#define MATCH_VLSEG6E16V 0xa0005007
#define MASK_VLSEG6E16V  0xfdf0707f
#define MATCH_VSSEG6E16V 0xa0005027
#define MASK_VSSEG6E16V  0xfdf0707f
#define MATCH_VLSEG7E16V 0xc0005007
#define MASK_VLSEG7E16V  0xfdf0707f
#define MATCH_VSSEG7E16V 0xc0005027
#define MASK_VSSEG7E16V  0xfdf0707f
#define MATCH_VLSEG8E16V 0xe0005007
#define MASK_VLSEG8E16V  0xfdf0707f
#define MATCH_VSSEG8E16V 0xe0005027
#define MASK_VSSEG8E16V  0xfdf0707f
#define MATCH_VLSEG2E32V 0x20006007
#define MASK_VLSEG2E32V  0xfdf0707f
#define MATCH_VSSEG2E32V 0x20006027
#define MASK_VSSEG2E32V  0xfdf0707f
#define MATCH_VLSEG3E32V 0x40006007
#define MASK_VLSEG3E32V  0xfdf0707f
#define MATCH_VSSEG3E32V 0x40006027
#define MASK_VSSEG3E32V  0xfdf0707f
#define MATCH_VLSEG4E32V 0x60006007
#define MASK_VLSEG4E32V  0xfdf0707f
#define MATCH_VSSEG4E32V 0x60006027
#define MASK_VSSEG4E32V  0xfdf0707f
#define MATCH_VLSEG5E32V 0x80006007
#define MASK_VLSEG5E32V  0xfdf0707f
#define MATCH_VSSEG5E32V 0x80006027
#define MASK_VSSEG5E32V  0xfdf0707f
#define MATCH_VLSEG6E32V 0xa0006007
#define MASK_VLSEG6E32V  0xfdf0707f
#define MATCH_VSSEG6E32V 0xa0006027
#define MASK_VSSEG6E32V  0xfdf0707f
#define MATCH_VLSEG7E32V 0xc0006007
#define MASK_VLSEG7E32V  0xfdf0707f
#define MATCH_VSSEG7E32V 0xc0006027
#define MASK_VSSEG7E32V  0xfdf0707f
#define MATCH_VLSEG8E32V 0xe0006007
#define MASK_VLSEG8E32V  0xfdf0707f
#define MATCH_VSSEG8E32V 0xe0006027
#define MASK_VSSEG8E32V  0xfdf0707f
#define MATCH_VLSEG2E64V 0x20007007
#define MASK_VLSEG2E64V  0xfdf0707f
#define MATCH_VSSEG2E64V 0x20007027
#define MASK_VSSEG2E64V  0xfdf0707f
#define MATCH_VLSEG3E64V 0x40007007
#define MASK_VLSEG3E64V  0xfdf0707f
#define MATCH_VSSEG3E64V 0x40007027
#define MASK_VSSEG3E64V  0xfdf0707f
#define MATCH_VLSEG4E64V 0x60007007
#define MASK_VLSEG4E64V  0xfdf0707f
#define MATCH_VSSEG4E64V 0x60007027
#define MASK_VSSEG4E64V  0xfdf0707f
#define MATCH_VLSEG5E64V 0x80007007
#define MASK_VLSEG5E64V  0xfdf0707f
#define MATCH_VSSEG5E64V 0x80007027
#define MASK_VSSEG5E64V  0xfdf0707f
#define MATCH_VLSEG6E64V 0xa0007007
#define MASK_VLSEG6E64V  0xfdf0707f
#define MATCH_VSSEG6E64V 0xa0007027
#define MASK_VSSEG6E64V  0xfdf0707f
#define MATCH_VLSEG7E64V 0xc0007007
#define MASK_VLSEG7E64V  0xfdf0707f
#define MATCH_VSSEG7E64V 0xc0007027
#define MASK_VSSEG7E64V  0xfdf0707f
#define MATCH_VLSEG8E64V 0xe0007007
#define MASK_VLSEG8E64V  0xfdf0707f
#define MATCH_VSSEG8E64V 0xe0007027
#define MASK_VSSEG8E64V  0xfdf0707f
#define MATCH_VLSSEG2E8V 0x28000007
#define MASK_VLSSEG2E8V  0xfc00707f
#define MATCH_VSSSEG2E8V 0x28000027
#define MASK_VSSSEG2E8V  0xfc00707f
#define MATCH_VLSSEG3E8V 0x48000007
#define MASK_VLSSEG3E8V  0xfc00707f
#define MATCH_VSSSEG3E8V 0x48000027
#define MASK_VSSSEG3E8V  0xfc00707f
#define MATCH_VLSSEG4E8V 0x68000007
#define MASK_VLSSEG4E8V  0xfc00707f
#define MATCH_VSSSEG4E8V 0x68000027
#define MASK_VSSSEG4E8V  0xfc00707f
#define MATCH_VLSSEG5E8V 0x88000007
#define MASK_VLSSEG5E8V  0xfc00707f
#define MATCH_VSSSEG5E8V 0x88000027
#define MASK_VSSSEG5E8V  0xfc00707f
#define MATCH_VLSSEG6E8V 0xa8000007
#define MASK_VLSSEG6E8V  0xfc00707f
#define MATCH_VSSSEG6E8V 0xa8000027
#define MASK_VSSSEG6E8V  0xfc00707f
#define MATCH_VLSSEG7E8V 0xc8000007
#define MASK_VLSSEG7E8V  0xfc00707f
#define MATCH_VSSSEG7E8V 0xc8000027
#define MASK_VSSSEG7E8V  0xfc00707f
#define MATCH_VLSSEG8E8V 0xe8000007
#define MASK_VLSSEG8E8V  0xfc00707f
#define MATCH_VSSSEG8E8V 0xe8000027
#define MASK_VSSSEG8E8V  0xfc00707f
#define MATCH_VLSSEG2E16V 0x28005007
#define MASK_VLSSEG2E16V 0xfc00707f
#define MATCH_VSSSEG2E16V 0x28005027
#define MASK_VSSSEG2E16V 0xfc00707f
#define MATCH_VLSSEG3E16V 0x48005007
#define MASK_VLSSEG3E16V 0xfc00707f
#define MATCH_VSSSEG3E16V 0x48005027
#define MASK_VSSSEG3E16V 0xfc00707f
#define MATCH_VLSSEG4E16V 0x68005007
#define MASK_VLSSEG4E16V 0xfc00707f
#define MATCH_VSSSEG4E16V 0x68005027
#define MASK_VSSSEG4E16V 0xfc00707f
#define MATCH_VLSSEG5E16V 0x88005007
#define MASK_VLSSEG5E16V 0xfc00707f
#define MATCH_VSSSEG5E16V 0x88005027
#define MASK_VSSSEG5E16V 0xfc00707f
#define MATCH_VLSSEG6E16V 0xa8005007
#define MASK_VLSSEG6E16V 0xfc00707f
#define MATCH_VSSSEG6E16V 0xa8005027
#define MASK_VSSSEG6E16V 0xfc00707f
#define MATCH_VLSSEG7E16V 0xc8005007
#define MASK_VLSSEG7E16V 0xfc00707f
#define MATCH_VSSSEG7E16V 0xc8005027
#define MASK_VSSSEG7E16V 0xfc00707f
#define MATCH_VLSSEG8E16V 0xe8005007
#define MASK_VLSSEG8E16V 0xfc00707f
#define MATCH_VSSSEG8E16V 0xe8005027
#define MASK_VSSSEG8E16V 0xfc00707f
#define MATCH_VLSSEG2E32V 0x28006007
#define MASK_VLSSEG2E32V 0xfc00707f
#define MATCH_VSSSEG2E32V 0x28006027
#define MASK_VSSSEG2E32V 0xfc00707f
#define MATCH_VLSSEG3E32V 0x48006007
#define MASK_VLSSEG3E32V 0xfc00707f
#define MATCH_VSSSEG3E32V 0x48006027
#define MASK_VSSSEG3E32V 0xfc00707f
#define MATCH_VLSSEG4E32V 0x68006007
#define MASK_VLSSEG4E32V 0xfc00707f
#define MATCH_VSSSEG4E32V 0x68006027
#define MASK_VSSSEG4E32V 0xfc00707f
#define MATCH_VLSSEG5E32V 0x88006007
#define MASK_VLSSEG5E32V 0xfc00707f
#define MATCH_VSSSEG5E32V 0x88006027
#define MASK_VSSSEG5E32V 0xfc00707f
#define MATCH_VLSSEG6E32V 0xa8006007
#define MASK_VLSSEG6E32V 0xfc00707f
#define MATCH_VSSSEG6E32V 0xa8006027
#define MASK_VSSSEG6E32V 0xfc00707f
#define MATCH_VLSSEG7E32V 0xc8006007
#define MASK_VLSSEG7E32V 0xfc00707f
#define MATCH_VSSSEG7E32V 0xc8006027
#define MASK_VSSSEG7E32V 0xfc00707f
#define MATCH_VLSSEG8E32V 0xe8006007
#define MASK_VLSSEG8E32V 0xfc00707f
#define MATCH_VSSSEG8E32V 0xe8006027
#define MASK_VSSSEG8E32V 0xfc00707f
#define MATCH_VLSSEG2E64V 0x28007007
#define MASK_VLSSEG2E64V 0xfc00707f
#define MATCH_VSSSEG2E64V 0x28007027
#define MASK_VSSSEG2E64V 0xfc00707f
#define MATCH_VLSSEG3E64V 0x48007007
#define MASK_VLSSEG3E64V 0xfc00707f
#define MATCH_VSSSEG3E64V 0x48007027
#define MASK_VSSSEG3E64V 0xfc00707f
#define MATCH_VLSSEG4E64V 0x68007007
#define MASK_VLSSEG4E64V 0xfc00707f
#define MATCH_VSSSEG4E64V 0x68007027
#define MASK_VSSSEG4E64V 0xfc00707f
#define MATCH_VLSSEG5E64V 0x88007007
#define MASK_VLSSEG5E64V 0xfc00707f
#define MATCH_VSSSEG5E64V 0x88007027
#define MASK_VSSSEG5E64V 0xfc00707f
#define MATCH_VLSSEG6E64V 0xa8007007
#define MASK_VLSSEG6E64V 0xfc00707f
#define MATCH_VSSSEG6E64V 0xa8007027
#define MASK_VSSSEG6E64V 0xfc00707f
#define MATCH_VLSSEG7E64V 0xc8007007
#define MASK_VLSSEG7E64V 0xfc00707f
#define MATCH_VSSSEG7E64V 0xc8007027
#define MASK_VSSSEG7E64V 0xfc00707f
#define MATCH_VLSSEG8E64V 0xe8007007
#define MASK_VLSSEG8E64V 0xfc00707f
#define MATCH_VSSSEG8E64V 0xe8007027
#define MASK_VSSSEG8E64V 0xfc00707f
#define MATCH_VLOXSEG2EI8V 0x2c000007
#define MASK_VLOXSEG2EI8V 0xfc00707f
#define MATCH_VSOXSEG2EI8V 0x2c000027
#define MASK_VSOXSEG2EI8V 0xfc00707f
#define MATCH_VLOXSEG3EI8V 0x4c000007
#define MASK_VLOXSEG3EI8V 0xfc00707f
#define MATCH_VSOXSEG3EI8V 0x4c000027
#define MASK_VSOXSEG3EI8V 0xfc00707f
#define MATCH_VLOXSEG4EI8V 0x6c000007
#define MASK_VLOXSEG4EI8V 0xfc00707f
#define MATCH_VSOXSEG4EI8V 0x6c000027
#define MASK_VSOXSEG4EI8V 0xfc00707f
#define MATCH_VLOXSEG5EI8V 0x8c000007
#define MASK_VLOXSEG5EI8V 0xfc00707f
#define MATCH_VSOXSEG5EI8V 0x8c000027
#define MASK_VSOXSEG5EI8V 0xfc00707f
#define MATCH_VLOXSEG6EI8V 0xac000007
#define MASK_VLOXSEG6EI8V 0xfc00707f
#define MATCH_VSOXSEG6EI8V 0xac000027
#define MASK_VSOXSEG6EI8V 0xfc00707f
#define MATCH_VLOXSEG7EI8V 0xcc000007
#define MASK_VLOXSEG7EI8V 0xfc00707f
#define MATCH_VSOXSEG7EI8V 0xcc000027
#define MASK_VSOXSEG7EI8V 0xfc00707f
#define MATCH_VLOXSEG8EI8V 0xec000007
#define MASK_VLOXSEG8EI8V 0xfc00707f
#define MATCH_VSOXSEG8EI8V 0xec000027
#define MASK_VSOXSEG8EI8V 0xfc00707f
#define MATCH_VLUXSEG2EI8V 0x24000007
#define MASK_VLUXSEG2EI8V 0xfc00707f
#define MATCH_VSUXSEG2EI8V 0x24000027
#define MASK_VSUXSEG2EI8V 0xfc00707f
#define MATCH_VLUXSEG3EI8V 0x44000007
#define MASK_VLUXSEG3EI8V 0xfc00707f
#define MATCH_VSUXSEG3EI8V 0x44000027
#define MASK_VSUXSEG3EI8V 0xfc00707f
#define MATCH_VLUXSEG4EI8V 0x64000007
#define MASK_VLUXSEG4EI8V 0xfc00707f
#define MATCH_VSUXSEG4EI8V 0x64000027
#define MASK_VSUXSEG4EI8V 0xfc00707f
#define MATCH_VLUXSEG5EI8V 0x84000007
#define MASK_VLUXSEG5EI8V 0xfc00707f
#define MATCH_VSUXSEG5EI8V 0x84000027
#define MASK_VSUXSEG5EI8V 0xfc00707f
#define MATCH_VLUXSEG6EI8V 0xa4000007
#define MASK_VLUXSEG6EI8V 0xfc00707f
#define MATCH_VSUXSEG6EI8V 0xa4000027
#define MASK_VSUXSEG6EI8V 0xfc00707f
#define MATCH_VLUXSEG7EI8V 0xc4000007
#define MASK_VLUXSEG7EI8V 0xfc00707f
#define MATCH_VSUXSEG7EI8V 0xc4000027
#define MASK_VSUXSEG7EI8V 0xfc00707f
#define MATCH_VLUXSEG8EI8V 0xe4000007
#define MASK_VLUXSEG8EI8V 0xfc00707f
#define MATCH_VSUXSEG8EI8V 0xe4000027
#define MASK_VSUXSEG8EI8V 0xfc00707f
#define MATCH_VLOXSEG2EI16V 0x2c005007
#define MASK_VLOXSEG2EI16V 0xfc00707f
#define MATCH_VSOXSEG2EI16V 0x2c005027
#define MASK_VSOXSEG2EI16V 0xfc00707f
#define MATCH_VLOXSEG3EI16V 0x4c005007
#define MASK_VLOXSEG3EI16V 0xfc00707f
#define MATCH_VSOXSEG3EI16V 0x4c005027
#define MASK_VSOXSEG3EI16V 0xfc00707f
#define MATCH_VLOXSEG4EI16V 0x6c005007
#define MASK_VLOXSEG4EI16V 0xfc00707f
#define MATCH_VSOXSEG4EI16V 0x6c005027
#define MASK_VSOXSEG4EI16V 0xfc00707f
#define MATCH_VLOXSEG5EI16V 0x8c005007
#define MASK_VLOXSEG5EI16V 0xfc00707f
#define MATCH_VSOXSEG5EI16V 0x8c005027
#define MASK_VSOXSEG5EI16V 0xfc00707f
#define MATCH_VLOXSEG6EI16V 0xac005007
#define MASK_VLOXSEG6EI16V 0xfc00707f
#define MATCH_VSOXSEG6EI16V 0xac005027
#define MASK_VSOXSEG6EI16V 0xfc00707f
#define MATCH_VLOXSEG7EI16V 0xcc005007
#define MASK_VLOXSEG7EI16V 0xfc00707f
#define MATCH_VSOXSEG7EI16V 0xcc005027
#define MASK_VSOXSEG7EI16V 0xfc00707f
#define MATCH_VLOXSEG8EI16V 0xec005007
#define MASK_VLOXSEG8EI16V 0xfc00707f
#define MATCH_VSOXSEG8EI16V 0xec005027
#define MASK_VSOXSEG8EI16V 0xfc00707f
#define MATCH_VLUXSEG2EI16V 0x24005007
#define MASK_VLUXSEG2EI16V 0xfc00707f
#define MATCH_VSUXSEG2EI16V 0x24005027
#define MASK_VSUXSEG2EI16V 0xfc00707f
#define MATCH_VLUXSEG3EI16V 0x44005007
#define MASK_VLUXSEG3EI16V 0xfc00707f
#define MATCH_VSUXSEG3EI16V 0x44005027
#define MASK_VSUXSEG3EI16V 0xfc00707f
#define MATCH_VLUXSEG4EI16V 0x64005007
#define MASK_VLUXSEG4EI16V 0xfc00707f
#define MATCH_VSUXSEG4EI16V 0x64005027
#define MASK_VSUXSEG4EI16V 0xfc00707f
#define MATCH_VLUXSEG5EI16V 0x84005007
#define MASK_VLUXSEG5EI16V 0xfc00707f
#define MATCH_VSUXSEG5EI16V 0x84005027
#define MASK_VSUXSEG5EI16V 0xfc00707f
#define MATCH_VLUXSEG6EI16V 0xa4005007
#define MASK_VLUXSEG6EI16V 0xfc00707f
#define MATCH_VSUXSEG6EI16V 0xa4005027
#define MASK_VSUXSEG6EI16V 0xfc00707f
#define MATCH_VLUXSEG7EI16V 0xc4005007
#define MASK_VLUXSEG7EI16V 0xfc00707f
#define MATCH_VSUXSEG7EI16V 0xc4005027
#define MASK_VSUXSEG7EI16V 0xfc00707f
#define MATCH_VLUXSEG8EI16V 0xe4005007
#define MASK_VLUXSEG8EI16V 0xfc00707f
#define MATCH_VSUXSEG8EI16V 0xe4005027
#define MASK_VSUXSEG8EI16V 0xfc00707f
#define MATCH_VLOXSEG2EI32V 0x2c006007
#define MASK_VLOXSEG2EI32V 0xfc00707f
#define MATCH_VSOXSEG2EI32V 0x2c006027
#define MASK_VSOXSEG2EI32V 0xfc00707f
#define MATCH_VLOXSEG3EI32V 0x4c006007
#define MASK_VLOXSEG3EI32V 0xfc00707f
#define MATCH_VSOXSEG3EI32V 0x4c006027
#define MASK_VSOXSEG3EI32V 0xfc00707f
#define MATCH_VLOXSEG4EI32V 0x6c006007
#define MASK_VLOXSEG4EI32V 0xfc00707f
#define MATCH_VSOXSEG4EI32V 0x6c006027
#define MASK_VSOXSEG4EI32V 0xfc00707f
#define MATCH_VLOXSEG5EI32V 0x8c006007
#define MASK_VLOXSEG5EI32V 0xfc00707f
#define MATCH_VSOXSEG5EI32V 0x8c006027
#define MASK_VSOXSEG5EI32V 0xfc00707f
#define MATCH_VLOXSEG6EI32V 0xac006007
#define MASK_VLOXSEG6EI32V 0xfc00707f
#define MATCH_VSOXSEG6EI32V 0xac006027
#define MASK_VSOXSEG6EI32V 0xfc00707f
#define MATCH_VLOXSEG7EI32V 0xcc006007
#define MASK_VLOXSEG7EI32V 0xfc00707f
#define MATCH_VSOXSEG7EI32V 0xcc006027
#define MASK_VSOXSEG7EI32V 0xfc00707f
#define MATCH_VLOXSEG8EI32V 0xec006007
#define MASK_VLOXSEG8EI32V 0xfc00707f
#define MATCH_VSOXSEG8EI32V 0xec006027
#define MASK_VSOXSEG8EI32V 0xfc00707f
#define MATCH_VLUXSEG2EI32V 0x24006007
#define MASK_VLUXSEG2EI32V 0xfc00707f
#define MATCH_VSUXSEG2EI32V 0x24006027
#define MASK_VSUXSEG2EI32V 0xfc00707f
#define MATCH_VLUXSEG3EI32V 0x44006007
#define MASK_VLUXSEG3EI32V 0xfc00707f
#define MATCH_VSUXSEG3EI32V 0x44006027
#define MASK_VSUXSEG3EI32V 0xfc00707f
#define MATCH_VLUXSEG4EI32V 0x64006007
#define MASK_VLUXSEG4EI32V 0xfc00707f
#define MATCH_VSUXSEG4EI32V 0x64006027
#define MASK_VSUXSEG4EI32V 0xfc00707f
#define MATCH_VLUXSEG5EI32V 0x84006007
#define MASK_VLUXSEG5EI32V 0xfc00707f
#define MATCH_VSUXSEG5EI32V 0x84006027
#define MASK_VSUXSEG5EI32V 0xfc00707f
#define MATCH_VLUXSEG6EI32V 0xa4006007
#define MASK_VLUXSEG6EI32V 0xfc00707f
#define MATCH_VSUXSEG6EI32V 0xa4006027
#define MASK_VSUXSEG6EI32V 0xfc00707f
#define MATCH_VLUXSEG7EI32V 0xc4006007
#define MASK_VLUXSEG7EI32V 0xfc00707f
#define MATCH_VSUXSEG7EI32V 0xc4006027
#define MASK_VSUXSEG7EI32V 0xfc00707f
#define MATCH_VLUXSEG8EI32V 0xe4006007
#define MASK_VLUXSEG8EI32V 0xfc00707f
#define MATCH_VSUXSEG8EI32V 0xe4006027
#define MASK_VSUXSEG8EI32V 0xfc00707f
#define MATCH_VLOXSEG2EI64V 0x2c007007
#define MASK_VLOXSEG2EI64V 0xfc00707f
#define MATCH_VSOXSEG2EI64V 0x2c007027
#define MASK_VSOXSEG2EI64V 0xfc00707f
#define MATCH_VLOXSEG3EI64V 0x4c007007
#define MASK_VLOXSEG3EI64V 0xfc00707f
#define MATCH_VSOXSEG3EI64V 0x4c007027
#define MASK_VSOXSEG3EI64V 0xfc00707f
#define MATCH_VLOXSEG4EI64V 0x6c007007
#define MASK_VLOXSEG4EI64V 0xfc00707f
#define MATCH_VSOXSEG4EI64V 0x6c007027
#define MASK_VSOXSEG4EI64V 0xfc00707f
#define MATCH_VLOXSEG5EI64V 0x8c007007
#define MASK_VLOXSEG5EI64V 0xfc00707f
#define MATCH_VSOXSEG5EI64V 0x8c007027
#define MASK_VSOXSEG5EI64V 0xfc00707f
#define MATCH_VLOXSEG6EI64V 0xac007007
#define MASK_VLOXSEG6EI64V 0xfc00707f
#define MATCH_VSOXSEG6EI64V 0xac007027
#define MASK_VSOXSEG6EI64V 0xfc00707f
#define MATCH_VLOXSEG7EI64V 0xcc007007
#define MASK_VLOXSEG7EI64V 0xfc00707f
#define MATCH_VSOXSEG7EI64V 0xcc007027
#define MASK_VSOXSEG7EI64V 0xfc00707f
#define MATCH_VLOXSEG8EI64V 0xec007007
#define MASK_VLOXSEG8EI64V 0xfc00707f
#define MATCH_VSOXSEG8EI64V 0xec007027
#define MASK_VSOXSEG8EI64V 0xfc00707f
#define MATCH_VLUXSEG2EI64V 0x24007007
#define MASK_VLUXSEG2EI64V 0xfc00707f
#define MATCH_VSUXSEG2EI64V 0x24007027
#define MASK_VSUXSEG2EI64V 0xfc00707f
#define MATCH_VLUXSEG3EI64V 0x44007007
#define MASK_VLUXSEG3EI64V 0xfc00707f
#define MATCH_VSUXSEG3EI64V 0x44007027
#define MASK_VSUXSEG3EI64V 0xfc00707f
#define MATCH_VLUXSEG4EI64V 0x64007007
#define MASK_VLUXSEG4EI64V 0xfc00707f
#define MATCH_VSUXSEG4EI64V 0x64007027
#define MASK_VSUXSEG4EI64V 0xfc00707f
#define MATCH_VLUXSEG5EI64V 0x84007007
#define MASK_VLUXSEG5EI64V 0xfc00707f
#define MATCH_VSUXSEG5EI64V 0x84007027
#define MASK_VSUXSEG5EI64V 0xfc00707f
#define MATCH_VLUXSEG6EI64V 0xa4007007
#define MASK_VLUXSEG6EI64V 0xfc00707f
#define MATCH_VSUXSEG6EI64V 0xa4007027
#define MASK_VSUXSEG6EI64V 0xfc00707f
#define MATCH_VLUXSEG7EI64V 0xc4007007
#define MASK_VLUXSEG7EI64V 0xfc00707f
#define MATCH_VSUXSEG7EI64V 0xc4007027
#define MASK_VSUXSEG7EI64V 0xfc00707f
#define MATCH_VLUXSEG8EI64V 0xe4007007
#define MASK_VLUXSEG8EI64V 0xfc00707f
#define MATCH_VSUXSEG8EI64V 0xe4007027
#define MASK_VSUXSEG8EI64V 0xfc00707f
#define MATCH_VLSEG2E8FFV 0x21000007
#define MASK_VLSEG2E8FFV 0xfdf0707f
#define MATCH_VLSEG3E8FFV 0x41000007
#define MASK_VLSEG3E8FFV 0xfdf0707f
#define MATCH_VLSEG4E8FFV 0x61000007
#define MASK_VLSEG4E8FFV 0xfdf0707f
#define MATCH_VLSEG5E8FFV 0x81000007
#define MASK_VLSEG5E8FFV 0xfdf0707f
#define MATCH_VLSEG6E8FFV 0xa1000007
#define MASK_VLSEG6E8FFV 0xfdf0707f
#define MATCH_VLSEG7E8FFV 0xc1000007
#define MASK_VLSEG7E8FFV 0xfdf0707f
#define MATCH_VLSEG8E8FFV 0xe1000007
#define MASK_VLSEG8E8FFV 0xfdf0707f
#define MATCH_VLSEG2E16FFV 0x21005007
#define MASK_VLSEG2E16FFV 0xfdf0707f
#define MATCH_VLSEG3E16FFV 0x41005007
#define MASK_VLSEG3E16FFV 0xfdf0707f
#define MATCH_VLSEG4E16FFV 0x61005007
#define MASK_VLSEG4E16FFV 0xfdf0707f
#define MATCH_VLSEG5E16FFV 0x81005007
#define MASK_VLSEG5E16FFV 0xfdf0707f
#define MATCH_VLSEG6E16FFV 0xa1005007
#define MASK_VLSEG6E16FFV 0xfdf0707f
#define MATCH_VLSEG7E16FFV 0xc1005007
#define MASK_VLSEG7E16FFV 0xfdf0707f
#define MATCH_VLSEG8E16FFV 0xe1005007
#define MASK_VLSEG8E16FFV 0xfdf0707f
#define MATCH_VLSEG2E32FFV 0x21006007
#define MASK_VLSEG2E32FFV 0xfdf0707f
#define MATCH_VLSEG3E32FFV 0x41006007
#define MASK_VLSEG3E32FFV 0xfdf0707f
#define MATCH_VLSEG4E32FFV 0x61006007
#define MASK_VLSEG4E32FFV 0xfdf0707f
#define MATCH_VLSEG5E32FFV 0x81006007
#define MASK_VLSEG5E32FFV 0xfdf0707f
#define MATCH_VLSEG6E32FFV 0xa1006007
#define MASK_VLSEG6E32FFV 0xfdf0707f
#define MATCH_VLSEG7E32FFV 0xc1006007
#define MASK_VLSEG7E32FFV 0xfdf0707f
#define MATCH_VLSEG8E32FFV 0xe1006007
#define MASK_VLSEG8E32FFV 0xfdf0707f
#define MATCH_VLSEG2E64FFV 0x21007007
#define MASK_VLSEG2E64FFV 0xfdf0707f
#define MATCH_VLSEG3E64FFV 0x41007007
#define MASK_VLSEG3E64FFV 0xfdf0707f
#define MATCH_VLSEG4E64FFV 0x61007007
#define MASK_VLSEG4E64FFV 0xfdf0707f
#define MATCH_VLSEG5E64FFV 0x81007007
#define MASK_VLSEG5E64FFV 0xfdf0707f
#define MATCH_VLSEG6E64FFV 0xa1007007
#define MASK_VLSEG6E64FFV 0xfdf0707f
#define MATCH_VLSEG7E64FFV 0xc1007007
#define MASK_VLSEG7E64FFV 0xfdf0707f
#define MATCH_VLSEG8E64FFV 0xe1007007
#define MASK_VLSEG8E64FFV 0xfdf0707f
#define MATCH_VL1RE8V  0x02800007
#define MASK_VL1RE8V  0xfff0707f
#define MATCH_VL1RE16V  0x02805007
#define MASK_VL1RE16V  0xfff0707f
#define MATCH_VL1RE32V  0x02806007
#define MASK_VL1RE32V  0xfff0707f
#define MATCH_VL1RE64V  0x02807007
#define MASK_VL1RE64V  0xfff0707f
#define MATCH_VL2RE8V  0x22800007
#define MASK_VL2RE8V  0xfff0707f
#define MATCH_VL2RE16V  0x22805007
#define MASK_VL2RE16V  0xfff0707f
#define MATCH_VL2RE32V  0x22806007
#define MASK_VL2RE32V  0xfff0707f
#define MATCH_VL2RE64V  0x22807007
#define MASK_VL2RE64V  0xfff0707f
#define MATCH_VL4RE8V  0x62800007
#define MASK_VL4RE8V  0xfff0707f
#define MATCH_VL4RE16V  0x62805007
#define MASK_VL4RE16V  0xfff0707f
#define MATCH_VL4RE32V  0x62806007
#define MASK_VL4RE32V  0xfff0707f
#define MATCH_VL4RE64V  0x62807007
#define MASK_VL4RE64V  0xfff0707f
#define MATCH_VL8RE8V  0xe2800007
#define MASK_VL8RE8V  0xfff0707f
#define MATCH_VL8RE16V  0xe2805007
#define MASK_VL8RE16V  0xfff0707f
#define MATCH_VL8RE32V  0xe2806007
#define MASK_VL8RE32V  0xfff0707f
#define MATCH_VL8RE64V  0xe2807007
#define MASK_VL8RE64V  0xfff0707f
#define MATCH_VS1RV  0x02800027
#define MASK_VS1RV  0xfff0707f
#define MATCH_VS2RV  0x22800027
#define MASK_VS2RV  0xfff0707f
#define MATCH_VS4RV  0x62800027
#define MASK_VS4RV  0xfff0707f
#define MATCH_VS8RV  0xe2800027
#define MASK_VS8RV  0xfff0707f
#define MATCH_VADDVV  0x00000057
#define MASK_VADDVV  0xfc00707f
#define MATCH_VADDVX  0x00004057
#define MASK_VADDVX  0xfc00707f
#define MATCH_VADDVI  0x00003057
#define MASK_VADDVI  0xfc00707f
#define MATCH_VSUBVV  0x08000057
#define MASK_VSUBVV  0xfc00707f
#define MATCH_VSUBVX  0x08004057
#define MASK_VSUBVX  0xfc00707f
#define MATCH_VRSUBVX  0x0c004057
#define MASK_VRSUBVX  0xfc00707f
#define MATCH_VRSUBVI  0x0c003057
#define MASK_VRSUBVI  0xfc00707f
#define MATCH_VWCVTXXV  0xc4006057
#define MASK_VWCVTXXV  0xfc0ff07f
#define MATCH_VWCVTUXXV  0xc0006057
#define MASK_VWCVTUXXV  0xfc0ff07f
#define MATCH_VWADDVV  0xc4002057
#define MASK_VWADDVV  0xfc00707f
#define MATCH_VWADDVX  0xc4006057
#define MASK_VWADDVX  0xfc00707f
#define MATCH_VWSUBVV  0xcc002057
#define MASK_VWSUBVV  0xfc00707f
#define MATCH_VWSUBVX  0xcc006057
#define MASK_VWSUBVX  0xfc00707f
#define MATCH_VWADDWV  0xd4002057
#define MASK_VWADDWV  0xfc00707f
#define MATCH_VWADDWX  0xd4006057
#define MASK_VWADDWX  0xfc00707f
#define MATCH_VWSUBWV  0xdc002057
#define MASK_VWSUBWV  0xfc00707f
#define MATCH_VWSUBWX  0xdc006057
#define MASK_VWSUBWX  0xfc00707f
#define MATCH_VWADDUVV  0xc0002057
#define MASK_VWADDUVV  0xfc00707f
#define MATCH_VWADDUVX  0xc0006057
#define MASK_VWADDUVX  0xfc00707f
#define MATCH_VWSUBUVV  0xc8002057
#define MASK_VWSUBUVV  0xfc00707f
#define MATCH_VWSUBUVX  0xc8006057
#define MASK_VWSUBUVX  0xfc00707f
#define MATCH_VWADDUWV  0xd0002057
#define MASK_VWADDUWV  0xfc00707f
#define MATCH_VWADDUWX  0xd0006057
#define MASK_VWADDUWX  0xfc00707f
#define MATCH_VWSUBUWV  0xd8002057
#define MASK_VWSUBUWV  0xfc00707f
#define MATCH_VWSUBUWX  0xd8006057
#define MASK_VWSUBUWX  0xfc00707f
#define MATCH_VZEXT_VF8  0x48012057
#define MASK_VZEXT_VF8  0xfc0ff07f
#define MATCH_VSEXT_VF8  0x4801a057
#define MASK_VSEXT_VF8  0xfc0ff07f
#define MATCH_VZEXT_VF4  0x48022057
#define MASK_VZEXT_VF4  0xfc0ff07f
#define MATCH_VSEXT_VF4  0x4802a057
#define MASK_VSEXT_VF4  0xfc0ff07f
#define MATCH_VZEXT_VF2  0x48032057
#define MASK_VZEXT_VF2  0xfc0ff07f
#define MATCH_VSEXT_VF2  0x4803a057
#define MASK_VSEXT_VF2  0xfc0ff07f
#define MATCH_VADCVVM  0x40000057
#define MASK_VADCVVM  0xfe00707f
#define MATCH_VADCVXM  0x40004057
#define MASK_VADCVXM  0xfe00707f
#define MATCH_VADCVIM  0x40003057
#define MASK_VADCVIM  0xfe00707f
#define MATCH_VMADCVVM  0x44000057
#define MASK_VMADCVVM  0xfe00707f
#define MATCH_VMADCVXM  0x44004057
#define MASK_VMADCVXM  0xfe00707f
#define MATCH_VMADCVIM  0x44003057
#define MASK_VMADCVIM  0xfe00707f
#define MATCH_VMADCVV  0x46000057
#define MASK_VMADCVV  0xfe00707f
#define MATCH_VMADCVX  0x46004057
#define MASK_VMADCVX  0xfe00707f
#define MATCH_VMADCVI  0x46003057
#define MASK_VMADCVI  0xfe00707f
#define MATCH_VSBCVVM  0x48000057
#define MASK_VSBCVVM  0xfe00707f
#define MATCH_VSBCVXM  0x48004057
#define MASK_VSBCVXM  0xfe00707f
#define MATCH_VMSBCVVM  0x4c000057
#define MASK_VMSBCVVM  0xfe00707f
#define MATCH_VMSBCVXM  0x4c004057
#define MASK_VMSBCVXM  0xfe00707f
#define MATCH_VMSBCVV  0x4e000057
#define MASK_VMSBCVV  0xfe00707f
#define MATCH_VMSBCVX  0x4e004057
#define MASK_VMSBCVX  0xfe00707f
#define MATCH_VNOTV  0x2c0fb057
#define MASK_VNOTV  0xfc0ff07f
#define MATCH_VANDVV  0x24000057
#define MASK_VANDVV  0xfc00707f
#define MATCH_VANDVX  0x24004057
#define MASK_VANDVX  0xfc00707f
#define MATCH_VANDVI  0x24003057
#define MASK_VANDVI  0xfc00707f
#define MATCH_VORVV  0x28000057
#define MASK_VORVV  0xfc00707f
#define MATCH_VORVX  0x28004057
#define MASK_VORVX  0xfc00707f
#define MATCH_VORVI  0x28003057
#define MASK_VORVI  0xfc00707f
#define MATCH_VXORVV  0x2c000057
#define MASK_VXORVV  0xfc00707f
#define MATCH_VXORVX  0x2c004057
#define MASK_VXORVX  0xfc00707f
#define MATCH_VXORVI  0x2c003057
#define MASK_VXORVI  0xfc00707f
#define MATCH_VSLLVV  0x94000057
#define MASK_VSLLVV  0xfc00707f
#define MATCH_VSLLVX  0x94004057
#define MASK_VSLLVX  0xfc00707f
#define MATCH_VSLLVI  0x94003057
#define MASK_VSLLVI  0xfc00707f
#define MATCH_VSRLVV  0xa0000057
#define MASK_VSRLVV  0xfc00707f
#define MATCH_VSRLVX  0xa0004057
#define MASK_VSRLVX  0xfc00707f
#define MATCH_VSRLVI  0xa0003057
#define MASK_VSRLVI  0xfc00707f
#define MATCH_VSRAVV  0xa4000057
#define MASK_VSRAVV  0xfc00707f
#define MATCH_VSRAVX  0xa4004057
#define MASK_VSRAVX  0xfc00707f
#define MATCH_VSRAVI  0xa4003057
#define MASK_VSRAVI  0xfc00707f
#define MATCH_VNCVTXXW  0xb0004057
#define MASK_VNCVTXXW  0xfc0ff07f
#define MATCH_VNSRLWV  0xb0000057
#define MASK_VNSRLWV  0xfc00707f
#define MATCH_VNSRLWX  0xb0004057
#define MASK_VNSRLWX  0xfc00707f
#define MATCH_VNSRLWI  0xb0003057
#define MASK_VNSRLWI  0xfc00707f
#define MATCH_VNSRAWV  0xb4000057
#define MASK_VNSRAWV  0xfc00707f
#define MATCH_VNSRAWX  0xb4004057
#define MASK_VNSRAWX  0xfc00707f
#define MATCH_VNSRAWI  0xb4003057
#define MASK_VNSRAWI  0xfc00707f
#define MATCH_VMSEQVV  0x60000057
#define MASK_VMSEQVV  0xfc00707f
#define MATCH_VMSEQVX  0x60004057
#define MASK_VMSEQVX  0xfc00707f
#define MATCH_VMSEQVI  0x60003057
#define MASK_VMSEQVI  0xfc00707f
#define MATCH_VMSNEVV  0x64000057
#define MASK_VMSNEVV  0xfc00707f
#define MATCH_VMSNEVX  0x64004057
#define MASK_VMSNEVX  0xfc00707f
#define MATCH_VMSNEVI  0x64003057
#define MASK_VMSNEVI  0xfc00707f
#define MATCH_VMSLTVV  0x6c000057
#define MASK_VMSLTVV  0xfc00707f
#define MATCH_VMSLTVX  0x6c004057
#define MASK_VMSLTVX  0xfc00707f
#define MATCH_VMSLTUVV  0x68000057
#define MASK_VMSLTUVV  0xfc00707f
#define MATCH_VMSLTUVX  0x68004057
#define MASK_VMSLTUVX  0xfc00707f
#define MATCH_VMSLEVV  0x74000057
#define MASK_VMSLEVV  0xfc00707f
#define MATCH_VMSLEVX  0x74004057
#define MASK_VMSLEVX  0xfc00707f
#define MATCH_VMSLEVI  0x74003057
#define MASK_VMSLEVI  0xfc00707f
#define MATCH_VMSLEUVV  0x70000057
#define MASK_VMSLEUVV  0xfc00707f
#define MATCH_VMSLEUVX  0x70004057
#define MASK_VMSLEUVX  0xfc00707f
#define MATCH_VMSLEUVI  0x70003057
#define MASK_VMSLEUVI  0xfc00707f
#define MATCH_VMSGTVX  0x7c004057
#define MASK_VMSGTVX  0xfc00707f
#define MATCH_VMSGTVI  0x7c003057
#define MASK_VMSGTVI  0xfc00707f
#define MATCH_VMSGTUVX  0x78004057
#define MASK_VMSGTUVX  0xfc00707f
#define MATCH_VMSGTUVI  0x78003057
#define MASK_VMSGTUVI  0xfc00707f
#define MATCH_VMINVV  0x14000057
#define MASK_VMINVV  0xfc00707f
#define MATCH_VMINVX  0x14004057
#define MASK_VMINVX  0xfc00707f
#define MATCH_VMAXVV  0x1c000057
#define MASK_VMAXVV  0xfc00707f
#define MATCH_VMAXVX  0x1c004057
#define MASK_VMAXVX  0xfc00707f
#define MATCH_VMINUVV  0x10000057
#define MASK_VMINUVV  0xfc00707f
#define MATCH_VMINUVX  0x10004057
#define MASK_VMINUVX  0xfc00707f
#define MATCH_VMAXUVV  0x18000057
#define MASK_VMAXUVV  0xfc00707f
#define MATCH_VMAXUVX  0x18004057
#define MASK_VMAXUVX  0xfc00707f
#define MATCH_VMULVV  0x94002057
#define MASK_VMULVV  0xfc00707f
#define MATCH_VMULVX  0x94006057
#define MASK_VMULVX  0xfc00707f
#define MATCH_VMULHVV  0x9c002057
#define MASK_VMULHVV  0xfc00707f
#define MATCH_VMULHVX  0x9c006057
#define MASK_VMULHVX  0xfc00707f
#define MATCH_VMULHUVV  0x90002057
#define MASK_VMULHUVV  0xfc00707f
#define MATCH_VMULHUVX  0x90006057
#define MASK_VMULHUVX  0xfc00707f
#define MATCH_VMULHSUVV  0x98002057
#define MASK_VMULHSUVV  0xfc00707f
#define MATCH_VMULHSUVX  0x98006057
#define MASK_VMULHSUVX  0xfc00707f
#define MATCH_VWMULVV  0xec002057
#define MASK_VWMULVV  0xfc00707f
#define MATCH_VWMULVX  0xec006057
#define MASK_VWMULVX  0xfc00707f
#define MATCH_VWMULUVV  0xe0002057
#define MASK_VWMULUVV  0xfc00707f
#define MATCH_VWMULUVX  0xe0006057
#define MASK_VWMULUVX  0xfc00707f
#define MATCH_VWMULSUVV  0xe8002057
#define MASK_VWMULSUVV  0xfc00707f
#define MATCH_VWMULSUVX  0xe8006057
#define MASK_VWMULSUVX  0xfc00707f
#define MATCH_VMACCVV  0xb4002057
#define MASK_VMACCVV  0xfc00707f
#define MATCH_VMACCVX  0xb4006057
#define MASK_VMACCVX  0xfc00707f
#define MATCH_VNMSACVV  0xbc002057
#define MASK_VNMSACVV  0xfc00707f
#define MATCH_VNMSACVX  0xbc006057
#define MASK_VNMSACVX  0xfc00707f
#define MATCH_VMADDVV  0xa4002057
#define MASK_VMADDVV  0xfc00707f
#define MATCH_VMADDVX  0xa4006057
#define MASK_VMADDVX  0xfc00707f
#define MATCH_VNMSUBVV  0xac002057
#define MASK_VNMSUBVV  0xfc00707f
#define MATCH_VNMSUBVX  0xac006057
#define MASK_VNMSUBVX  0xfc00707f
#define MATCH_VWMACCUVV  0xf0002057
#define MASK_VWMACCUVV  0xfc00707f
#define MATCH_VWMACCUVX  0xf0006057
#define MASK_VWMACCUVX  0xfc00707f
#define MATCH_VWMACCVV  0xf4002057
#define MASK_VWMACCVV  0xfc00707f
#define MATCH_VWMACCVX  0xf4006057
#define MASK_VWMACCVX  0xfc00707f
#define MATCH_VWMACCSUVV 0xfc002057
#define MASK_VWMACCSUVV  0xfc00707f
#define MATCH_VWMACCSUVX 0xfc006057
#define MASK_VWMACCSUVX  0xfc00707f
#define MATCH_VWMACCUSVX 0xf8006057
#define MASK_VWMACCUSVX  0xfc00707f
#define MATCH_VQMACCUVV  0xf0000057
#define MASK_VQMACCUVV  0xfc00707f
#define MATCH_VQMACCUVX  0xf0004057
#define MASK_VQMACCUVX  0xfc00707f
#define MATCH_VQMACCVV  0xf4000057
#define MASK_VQMACCVV  0xfc00707f
#define MATCH_VQMACCVX  0xf4004057
#define MASK_VQMACCVX  0xfc00707f
#define MATCH_VQMACCSUVV 0xfc000057
#define MASK_VQMACCSUVV  0xfc00707f
#define MATCH_VQMACCSUVX 0xfc004057
#define MASK_VQMACCSUVX  0xfc00707f
#define MATCH_VQMACCUSVX 0xf8004057
#define MASK_VQMACCUSVX  0xfc00707f
#define MATCH_VDIVVV  0x84002057
#define MASK_VDIVVV  0xfc00707f
#define MATCH_VDIVVX  0x84006057
#define MASK_VDIVVX  0xfc00707f
#define MATCH_VDIVUVV  0x80002057
#define MASK_VDIVUVV  0xfc00707f
#define MATCH_VDIVUVX  0x80006057
#define MASK_VDIVUVX  0xfc00707f
#define MATCH_VREMVV  0x8c002057
#define MASK_VREMVV  0xfc00707f
#define MATCH_VREMVX  0x8c006057
#define MASK_VREMVX  0xfc00707f
#define MATCH_VREMUVV  0x88002057
#define MASK_VREMUVV  0xfc00707f
#define MATCH_VREMUVX  0x88006057
#define MASK_VREMUVX  0xfc00707f
#define MATCH_VMERGEVVM  0x5c000057
#define MASK_VMERGEVVM  0xfe00707f
#define MATCH_VMERGEVXM  0x5c004057
#define MASK_VMERGEVXM  0xfe00707f
#define MATCH_VMERGEVIM  0x5c003057
#define MASK_VMERGEVIM  0xfe00707f
#define MATCH_VMVVV  0x5e000057
#define MASK_VMVVV  0xfff0707f
#define MATCH_VMVVX  0x5e004057
#define MASK_VMVVX  0xfff0707f
#define MATCH_VMVVI  0x5e003057
#define MASK_VMVVI  0xfff0707f
#define MATCH_VSADDUVV  0x80000057
#define MASK_VSADDUVV  0xfc00707f
#define MATCH_VSADDUVX  0x80004057
#define MASK_VSADDUVX  0xfc00707f
#define MATCH_VSADDUVI  0x80003057
#define MASK_VSADDUVI  0xfc00707f
#define MATCH_VSADDVV  0x84000057
#define MASK_VSADDVV  0xfc00707f
#define MATCH_VSADDVX  0x84004057
#define MASK_VSADDVX  0xfc00707f
#define MATCH_VSADDVI  0x84003057
#define MASK_VSADDVI  0xfc00707f
#define MATCH_VSSUBUVV  0x88000057
#define MASK_VSSUBUVV  0xfc00707f
#define MATCH_VSSUBUVX  0x88004057
#define MASK_VSSUBUVX  0xfc00707f
#define MATCH_VSSUBVV  0x8c000057
#define MASK_VSSUBVV  0xfc00707f
#define MATCH_VSSUBVX  0x8c004057
#define MASK_VSSUBVX  0xfc00707f
#define MATCH_VAADDUVV  0x20002057
#define MASK_VAADDUVV  0xfc00707f
#define MATCH_VAADDUVX  0x20006057
#define MASK_VAADDUVX  0xfc00707f
#define MATCH_VAADDVV  0x24002057
#define MASK_VAADDVV  0xfc00707f
#define MATCH_VAADDVX  0x24006057
#define MASK_VAADDVX  0xfc00707f
#define MATCH_VASUBUVV  0x28002057
#define MASK_VASUBUVV  0xfc00707f
#define MATCH_VASUBUVX  0x28006057
#define MASK_VASUBUVX  0xfc00707f
#define MATCH_VASUBVV  0x2c002057
#define MASK_VASUBVV  0xfc00707f
#define MATCH_VASUBVX  0x2c006057
#define MASK_VASUBVX  0xfc00707f
#define MATCH_VSMULVV  0x9c000057
#define MASK_VSMULVV  0xfc00707f
#define MATCH_VSMULVX  0x9c004057
#define MASK_VSMULVX  0xfc00707f
#define MATCH_VSSRLVV  0xa8000057
#define MASK_VSSRLVV  0xfc00707f
#define MATCH_VSSRLVX  0xa8004057
#define MASK_VSSRLVX  0xfc00707f
#define MATCH_VSSRLVI  0xa8003057
#define MASK_VSSRLVI  0xfc00707f
#define MATCH_VSSRAVV  0xac000057
#define MASK_VSSRAVV  0xfc00707f
#define MATCH_VSSRAVX  0xac004057
#define MASK_VSSRAVX  0xfc00707f
#define MATCH_VSSRAVI  0xac003057
#define MASK_VSSRAVI  0xfc00707f
#define MATCH_VNCLIPUWV  0xb8000057
#define MASK_VNCLIPUWV  0xfc00707f
#define MATCH_VNCLIPUWX  0xb8004057
#define MASK_VNCLIPUWX  0xfc00707f
#define MATCH_VNCLIPUWI  0xb8003057
#define MASK_VNCLIPUWI  0xfc00707f
#define MATCH_VNCLIPWV  0xbc000057
#define MASK_VNCLIPWV  0xfc00707f
#define MATCH_VNCLIPWX  0xbc004057
#define MASK_VNCLIPWX  0xfc00707f
#define MATCH_VNCLIPWI  0xbc003057
#define MASK_VNCLIPWI  0xfc00707f
#define MATCH_VFADDVV  0x00001057
#define MASK_VFADDVV  0xfc00707f
#define MATCH_VFADDVF  0x00005057
#define MASK_VFADDVF  0xfc00707f
#define MATCH_VFSUBVV  0x08001057
#define MASK_VFSUBVV  0xfc00707f
#define MATCH_VFSUBVF  0x08005057
#define MASK_VFSUBVF  0xfc00707f
#define MATCH_VFRSUBVF  0x9c005057
#define MASK_VFRSUBVF  0xfc00707f
#define MATCH_VFWADDVV  0xc0001057
#define MASK_VFWADDVV  0xfc00707f
#define MATCH_VFWADDVF  0xc0005057
#define MASK_VFWADDVF  0xfc00707f
#define MATCH_VFWSUBVV  0xc8001057
#define MASK_VFWSUBVV  0xfc00707f
#define MATCH_VFWSUBVF  0xc8005057
#define MASK_VFWSUBVF  0xfc00707f
#define MATCH_VFWADDWV  0xd0001057
#define MASK_VFWADDWV  0xfc00707f
#define MATCH_VFWADDWF  0xd0005057
#define MASK_VFWADDWF  0xfc00707f
#define MATCH_VFWSUBWV  0xd8001057
#define MASK_VFWSUBWV  0xfc00707f
#define MATCH_VFWSUBWF  0xd8005057
#define MASK_VFWSUBWF  0xfc00707f
#define MATCH_VFMULVV  0x90001057
#define MASK_VFMULVV  0xfc00707f
#define MATCH_VFMULVF  0x90005057
#define MASK_VFMULVF  0xfc00707f
#define MATCH_VFDIVVV  0x80001057
#define MASK_VFDIVVV  0xfc00707f
#define MATCH_VFDIVVF  0x80005057
#define MASK_VFDIVVF  0xfc00707f
#define MATCH_VFRDIVVF  0x84005057
#define MASK_VFRDIVVF  0xfc00707f
#define MATCH_VFWMULVV  0xe0001057
#define MASK_VFWMULVV  0xfc00707f
#define MATCH_VFWMULVF  0xe0005057
#define MASK_VFWMULVF  0xfc00707f
#define MATCH_VFMADDVV  0xa0001057
#define MASK_VFMADDVV  0xfc00707f
#define MATCH_VFMADDVF  0xa0005057
#define MASK_VFMADDVF  0xfc00707f
#define MATCH_VFNMADDVV  0xa4001057
#define MASK_VFNMADDVV  0xfc00707f
#define MATCH_VFNMADDVF  0xa4005057
#define MASK_VFNMADDVF  0xfc00707f
#define MATCH_VFMSUBVV  0xa8001057
#define MASK_VFMSUBVV  0xfc00707f
#define MATCH_VFMSUBVF  0xa8005057
#define MASK_VFMSUBVF  0xfc00707f
#define MATCH_VFNMSUBVV  0xac001057
#define MASK_VFNMSUBVV  0xfc00707f
#define MATCH_VFNMSUBVF  0xac005057
#define MASK_VFNMSUBVF  0xfc00707f
#define MATCH_VFMACCVV  0xb0001057
#define MASK_VFMACCVV  0xfc00707f
#define MATCH_VFMACCVF  0xb0005057
#define MASK_VFMACCVF  0xfc00707f
#define MATCH_VFNMACCVV  0xb4001057
#define MASK_VFNMACCVV  0xfc00707f
#define MATCH_VFNMACCVF  0xb4005057
#define MASK_VFNMACCVF  0xfc00707f
#define MATCH_VFMSACVV  0xb8001057
#define MASK_VFMSACVV  0xfc00707f
#define MATCH_VFMSACVF  0xb8005057
#define MASK_VFMSACVF  0xfc00707f
#define MATCH_VFNMSACVV  0xbc001057
#define MASK_VFNMSACVV  0xfc00707f
#define MATCH_VFNMSACVF  0xbc005057
#define MASK_VFNMSACVF  0xfc00707f
#define MATCH_VFWMACCVV  0xf0001057
#define MASK_VFWMACCVV  0xfc00707f
#define MATCH_VFWMACCVF  0xf0005057
#define MASK_VFWMACCVF  0xfc00707f
#define MATCH_VFWNMACCVV 0xf4001057
#define MASK_VFWNMACCVV  0xfc00707f
#define MATCH_VFWNMACCVF 0xf4005057
#define MASK_VFWNMACCVF  0xfc00707f
#define MATCH_VFWMSACVV  0xf8001057
#define MASK_VFWMSACVV  0xfc00707f
#define MATCH_VFWMSACVF  0xf8005057
#define MASK_VFWMSACVF  0xfc00707f
#define MATCH_VFWNMSACVV 0xfc001057
#define MASK_VFWNMSACVV  0xfc00707f
#define MATCH_VFWNMSACVF 0xfc005057
#define MASK_VFWNMSACVF  0xfc00707f
#define MATCH_VFSQRTV  0x4c001057
#define MASK_VFSQRTV  0xfc0ff07f
#define MATCH_VFRSQRT7V  0x4c021057
#define MASK_VFRSQRT7V  0xfc0ff07f
#define MATCH_VFREC7V  0x4c029057
#define MASK_VFREC7V  0xfc0ff07f
#define MATCH_VFCLASSV  0x4c081057
#define MASK_VFCLASSV  0xfc0ff07f
#define MATCH_VFMINVV  0x10001057
#define MASK_VFMINVV  0xfc00707f
#define MATCH_VFMINVF  0x10005057
#define MASK_VFMINVF  0xfc00707f
#define MATCH_VFMAXVV  0x18001057
#define MASK_VFMAXVV  0xfc00707f
#define MATCH_VFMAXVF  0x18005057
#define MASK_VFMAXVF  0xfc00707f
#define MATCH_VFSGNJVV  0x20001057
#define MASK_VFSGNJVV  0xfc00707f
#define MATCH_VFSGNJVF  0x20005057
#define MASK_VFSGNJVF  0xfc00707f
#define MATCH_VFSGNJNVV  0x24001057
#define MASK_VFSGNJNVV  0xfc00707f
#define MATCH_VFSGNJNVF  0x24005057
#define MASK_VFSGNJNVF  0xfc00707f
#define MATCH_VFSGNJXVV  0x28001057
#define MASK_VFSGNJXVV  0xfc00707f
#define MATCH_VFSGNJXVF  0x28005057
#define MASK_VFSGNJXVF  0xfc00707f
#define MATCH_VMFEQVV  0x60001057
#define MASK_VMFEQVV  0xfc00707f
#define MATCH_VMFEQVF  0x60005057
#define MASK_VMFEQVF  0xfc00707f
#define MATCH_VMFNEVV  0x70001057
#define MASK_VMFNEVV  0xfc00707f
#define MATCH_VMFNEVF  0x70005057
#define MASK_VMFNEVF  0xfc00707f
#define MATCH_VMFLTVV  0x6c001057
#define MASK_VMFLTVV  0xfc00707f
#define MATCH_VMFLTVF  0x6c005057
#define MASK_VMFLTVF  0xfc00707f
#define MATCH_VMFLEVV  0x64001057
#define MASK_VMFLEVV  0xfc00707f
#define MATCH_VMFLEVF  0x64005057
#define MASK_VMFLEVF  0xfc00707f
#define MATCH_VMFGTVF  0x74005057
#define MASK_VMFGTVF  0xfc00707f
#define MATCH_VMFGEVF  0x7c005057
#define MASK_VMFGEVF  0xfc00707f
#define MATCH_VFMERGEVFM 0x5c005057
#define MASK_VFMERGEVFM  0xfe00707f
#define MATCH_VFMVVF  0x5e005057
#define MASK_VFMVVF  0xfff0707f
#define MATCH_VFCVTXUFV  0x48001057
#define MASK_VFCVTXUFV  0xfc0ff07f
#define MATCH_VFCVTXFV  0x48009057
#define MASK_VFCVTXFV  0xfc0ff07f
#define MATCH_VFCVTFXUV  0x48011057
#define MASK_VFCVTFXUV  0xfc0ff07f
#define MATCH_VFCVTFXV  0x48019057
#define MASK_VFCVTFXV  0xfc0ff07f
#define MATCH_VFCVTRTZXUFV 0x48031057
#define MASK_VFCVTRTZXUFV 0xfc0ff07f
#define MATCH_VFCVTRTZXFV 0x48039057
#define MASK_VFCVTRTZXFV 0xfc0ff07f
#define MATCH_VFWCVTXUFV 0x48041057
#define MASK_VFWCVTXUFV  0xfc0ff07f
#define MATCH_VFWCVTXFV  0x48049057
#define MASK_VFWCVTXFV  0xfc0ff07f
#define MATCH_VFWCVTFXUV 0x48051057
#define MASK_VFWCVTFXUV  0xfc0ff07f
#define MATCH_VFWCVTFXV  0x48059057
#define MASK_VFWCVTFXV  0xfc0ff07f
#define MATCH_VFWCVTFFV  0x48061057
#define MASK_VFWCVTFFV  0xfc0ff07f
#define MATCH_VFWCVTRTZXUFV 0x48071057
#define MASK_VFWCVTRTZXUFV 0xfc0ff07f
#define MATCH_VFWCVTRTZXFV 0x48079057
#define MASK_VFWCVTRTZXFV 0xfc0ff07f
#define MATCH_VFNCVTXUFW 0x48081057
#define MASK_VFNCVTXUFW  0xfc0ff07f
#define MATCH_VFNCVTXFW  0x48089057
#define MASK_VFNCVTXFW  0xfc0ff07f
#define MATCH_VFNCVTFXUW 0x48091057
#define MASK_VFNCVTFXUW  0xfc0ff07f
#define MATCH_VFNCVTFXW  0x48099057
#define MASK_VFNCVTFXW  0xfc0ff07f
#define MATCH_VFNCVTFFW  0x480a1057
#define MASK_VFNCVTFFW  0xfc0ff07f
#define MATCH_VFNCVTRODFFW 0x480a9057
#define MASK_VFNCVTRODFFW 0xfc0ff07f
#define MATCH_VFNCVTRTZXUFW 0x480b1057
#define MASK_VFNCVTRTZXUFW 0xfc0ff07f
#define MATCH_VFNCVTRTZXFW 0x480b9057
#define MASK_VFNCVTRTZXFW 0xfc0ff07f
#define MATCH_VREDSUMVS  0x00002057
#define MASK_VREDSUMVS  0xfc00707f
#define MATCH_VREDMAXVS  0x1c002057
#define MASK_VREDMAXVS  0xfc00707f
#define MATCH_VREDMAXUVS 0x18002057
#define MASK_VREDMAXUVS  0xfc00707f
#define MATCH_VREDMINVS  0x14002057
#define MASK_VREDMINVS  0xfc00707f
#define MATCH_VREDMINUVS 0x10002057
#define MASK_VREDMINUVS  0xfc00707f
#define MATCH_VREDANDVS  0x04002057
#define MASK_VREDANDVS  0xfc00707f
#define MATCH_VREDORVS  0x08002057
#define MASK_VREDORVS  0xfc00707f
#define MATCH_VREDXORVS  0x0c002057
#define MASK_VREDXORVS  0xfc00707f
#define MATCH_VWREDSUMUVS 0xc0000057
#define MASK_VWREDSUMUVS 0xfc00707f
#define MATCH_VWREDSUMVS 0xc4000057
#define MASK_VWREDSUMVS  0xfc00707f
#define MATCH_VFREDOSUMVS 0x0c001057
#define MASK_VFREDOSUMVS 0xfc00707f
#define MATCH_VFREDUSUMVS 0x04001057
#define MASK_VFREDUSUMVS 0xfc00707f
#define MATCH_VFREDMAXVS 0x1c001057
#define MASK_VFREDMAXVS  0xfc00707f
#define MATCH_VFREDMINVS 0x14001057
#define MASK_VFREDMINVS  0xfc00707f
#define MATCH_VFWREDOSUMVS 0xcc001057
#define MASK_VFWREDOSUMVS 0xfc00707f
#define MATCH_VFWREDUSUMVS 0xc4001057
#define MASK_VFWREDUSUMVS 0xfc00707f
#define MATCH_VMANDMM  0x66002057
#define MASK_VMANDMM  0xfe00707f
#define MATCH_VMNANDMM  0x76002057
#define MASK_VMNANDMM  0xfe00707f
#define MATCH_VMANDNMM 0x62002057
#define MASK_VMANDNMM  0xfe00707f
#define MATCH_VMXORMM  0x6e002057
#define MASK_VMXORMM  0xfe00707f
#define MATCH_VMORMM  0x6a002057
#define MASK_VMORMM  0xfe00707f
#define MATCH_VMNORMM  0x7a002057
#define MASK_VMNORMM  0xfe00707f
#define MATCH_VMORNMM  0x72002057
#define MASK_VMORNMM  0xfe00707f
#define MATCH_VMXNORMM  0x7e002057
#define MASK_VMXNORMM  0xfe00707f
#define MATCH_VCPOPM  0x40082057
#define MASK_VCPOPM  0xfc0ff07f
#define MATCH_VFIRSTM  0x4008a057
#define MASK_VFIRSTM  0xfc0ff07f
#define MATCH_VMSBFM  0x5000a057
#define MASK_VMSBFM  0xfc0ff07f
#define MATCH_VMSIFM  0x5001a057
#define MASK_VMSIFM  0xfc0ff07f
#define MATCH_VMSOFM  0x50012057
#define MASK_VMSOFM  0xfc0ff07f
#define MATCH_VIOTAM  0x50082057
#define MASK_VIOTAM  0xfc0ff07f
#define MATCH_VIDV  0x5008a057
#define MASK_VIDV  0xfdfff07f
#define MATCH_VMVXS  0x42002057
#define MASK_VMVXS  0xfe0ff07f
#define MATCH_VMVSX  0x42006057
#define MASK_VMVSX  0xfff0707f
#define MATCH_VFMVFS  0x42001057
#define MASK_VFMVFS  0xfe0ff07f
#define MATCH_VFMVSF  0x42005057
#define MASK_VFMVSF  0xfff0707f
#define MATCH_VSLIDEUPVX 0x38004057
#define MASK_VSLIDEUPVX  0xfc00707f
#define MATCH_VSLIDEUPVI 0x38003057
#define MASK_VSLIDEUPVI  0xfc00707f
#define MATCH_VSLIDEDOWNVX 0x3c004057
#define MASK_VSLIDEDOWNVX 0xfc00707f
#define MATCH_VSLIDEDOWNVI 0x3c003057
#define MASK_VSLIDEDOWNVI 0xfc00707f
#define MATCH_VSLIDE1UPVX 0x38006057
#define MASK_VSLIDE1UPVX 0xfc00707f
#define MATCH_VSLIDE1DOWNVX 0x3c006057
#define MASK_VSLIDE1DOWNVX 0xfc00707f
#define MATCH_VFSLIDE1UPVF 0x38005057
#define MASK_VFSLIDE1UPVF 0xfc00707f
#define MATCH_VFSLIDE1DOWNVF 0x3c005057
#define MASK_VFSLIDE1DOWNVF 0xfc00707f
#define MATCH_VRGATHERVV 0x30000057
#define MASK_VRGATHERVV  0xfc00707f
#define MATCH_VRGATHERVX 0x30004057
#define MASK_VRGATHERVX  0xfc00707f
#define MATCH_VRGATHERVI 0x30003057
#define MASK_VRGATHERVI  0xfc00707f
#define MATCH_VRGATHEREI16VV 0x38000057
#define MASK_VRGATHEREI16VV 0xfc00707f
#define MATCH_VCOMPRESSVM 0x5e002057
#define MASK_VCOMPRESSVM 0xfe00707f
#define MATCH_VMV1RV  0x9e003057
#define MASK_VMV1RV  0xfe0ff07f
#define MATCH_VMV2RV  0x9e00b057
#define MASK_VMV2RV  0xfe0ff07f
#define MATCH_VMV4RV  0x9e01b057
#define MASK_VMV4RV  0xfe0ff07f
#define MATCH_VMV8RV  0x9e03b057
#define MASK_VMV8RV  0xfe0ff07f
#define MATCH_VDOTVV  0xe4000057
#define MASK_VDOTVV  0xfc00707f
#define MATCH_VDOTUVV  0xe0000057
#define MASK_VDOTUVV  0xfc00707f
#define MATCH_VFDOTVV  0xe4001057
#define MASK_VFDOTVV  0xfc00707f
/* Zvbb/Zvkb instructions.  */
#define MATCH_VANDN_VV 0x4000057
#define MASK_VANDN_VV 0xfc00707f
#define MATCH_VANDN_VX 0x4004057
#define MASK_VANDN_VX 0xfc00707f
#define MATCH_VBREV8_V 0x48042057
#define MASK_VBREV8_V 0xfc0ff07f
#define MATCH_VBREV_V 0x48052057
#define MASK_VBREV_V 0xfc0ff07f
#define MATCH_VCLZ_V 0x48062057
#define MASK_VCLZ_V 0xfc0ff07f
#define MATCH_VCPOP_V 0x48072057
#define MASK_VCPOP_V 0xfc0ff07f
#define MATCH_VCTZ_V 0x4806a057
#define MASK_VCTZ_V 0xfc0ff07f
#define MATCH_VREV8_V 0x4804a057
#define MASK_VREV8_V 0xfc0ff07f
#define MATCH_VROL_VV 0x54000057
#define MASK_VROL_VV 0xfc00707f
#define MATCH_VROL_VX 0x54004057
#define MASK_VROL_VX 0xfc00707f
#define MATCH_VROR_VI 0x50003057
#define MASK_VROR_VI 0xf800707f
#define MATCH_VROR_VV 0x50000057
#define MASK_VROR_VV 0xfc00707f
#define MATCH_VROR_VX 0x50004057
#define MASK_VROR_VX 0xfc00707f
#define MATCH_VWSLL_VI 0xd4003057
#define MASK_VWSLL_VI 0xfc00707f
#define MATCH_VWSLL_VV 0xd4000057
#define MASK_VWSLL_VV 0xfc00707f
#define MATCH_VWSLL_VX 0xd4004057
#define MASK_VWSLL_VX 0xfc00707f
/* Zvbc instructions. */
#define MATCH_VCLMUL_VV 0x30002057
#define MASK_VCLMUL_VV 0xfc00707f
#define MATCH_VCLMUL_VX 0x30006057
#define MASK_VCLMUL_VX 0xfc00707f
#define MATCH_VCLMULH_VV 0x34002057
#define MASK_VCLMULH_VV 0xfc00707f
#define MATCH_VCLMULH_VX 0x34006057
#define MASK_VCLMULH_VX 0xfc00707f
/* Zvkg instructions.  */
#define MATCH_VGHSH_VV 0xb2002077
#define MASK_VGHSH_VV 0xfe00707f
#define MATCH_VGMUL_VV 0xa208a077
#define MASK_VGMUL_VV 0xfe0ff07f
/* Zvkned instructions.  */
#define MATCH_VAESDF_VS 0xa600a077
#define MASK_VAESDF_VS 0xfe0ff07f
#define MATCH_VAESDF_VV 0xa200a077
#define MASK_VAESDF_VV 0xfe0ff07f
#define MATCH_VAESDM_VS 0xa6002077
#define MASK_VAESDM_VS 0xfe0ff07f
#define MATCH_VAESDM_VV 0xa2002077
#define MASK_VAESDM_VV 0xfe0ff07f
#define MATCH_VAESEF_VS 0xa601a077
#define MASK_VAESEF_VS 0xfe0ff07f
#define MATCH_VAESEF_VV 0xa201a077
#define MASK_VAESEF_VV 0xfe0ff07f
#define MATCH_VAESEM_VS 0xa6012077
#define MASK_VAESEM_VS 0xfe0ff07f
#define MATCH_VAESEM_VV 0xa2012077
#define MASK_VAESEM_VV 0xfe0ff07f
#define MATCH_VAESKF1_VI 0x8a002077
#define MASK_VAESKF1_VI 0xfe00707f
#define MATCH_VAESKF2_VI 0xaa002077
#define MASK_VAESKF2_VI 0xfe00707f
#define MATCH_VAESZ_VS 0xa603a077
#define MASK_VAESZ_VS 0xfe0ff07f
/* Zvknh[a,b] instructions.  */
#define MATCH_VSHA2CH_VV 0xba002077
#define MASK_VSHA2CH_VV 0xfe00707f
#define MATCH_VSHA2CL_VV 0xbe002077
#define MASK_VSHA2CL_VV 0xfe00707f
#define MATCH_VSHA2MS_VV 0xb6002077
#define MASK_VSHA2MS_VV 0xfe00707f
/* Zvksed instructions.  */
#define MATCH_VSM4K_VI 0x86002077
#define MASK_VSM4K_VI 0xfe00707f
#define MATCH_VSM4R_VS 0xa6082077
#define MASK_VSM4R_VS 0xfe0ff07f
#define MATCH_VSM4R_VV 0xa2082077
#define MASK_VSM4R_VV 0xfe0ff07f
/* Zvksh instructions.  */
#define MATCH_VSM3C_VI 0xae002077
#define MASK_VSM3C_VI 0xfe00707f
#define MATCH_VSM3ME_VV 0x82002077
#define MASK_VSM3ME_VV 0xfe00707f
/* Zcb instructions.  */
#define MATCH_C_LBU 0x8000
#define MASK_C_LBU 0xfc03
#define MATCH_C_LHU 0x8400
#define MASK_C_LHU 0xfc43
#define MATCH_C_LH 0x8440
#define MASK_C_LH 0xfc43
#define MATCH_C_SB 0x8800
#define MASK_C_SB 0xfc03
#define MATCH_C_SH 0x8c00
#define MASK_C_SH 0xfc43
#define MATCH_C_ZEXT_B 0x9c61
#define MASK_C_ZEXT_B 0xfc7f
#define MATCH_C_SEXT_B 0x9c65
#define MASK_C_SEXT_B 0xfc7f
#define MATCH_C_ZEXT_H 0x9c69
#define MASK_C_ZEXT_H 0xfc7f
#define MATCH_C_SEXT_H 0x9c6d
#define MASK_C_SEXT_H 0xfc7f
#define MATCH_C_ZEXT_W 0x9c71
#define MASK_C_ZEXT_W 0xfc7f
#define MATCH_C_NOT 0x9c75
#define MASK_C_NOT 0xfc7f
#define MATCH_C_MUL 0x9c41
#define MASK_C_MUL 0xfc63
/* Zcmop instructions.  */
#define MATCH_C_MOP_1 0x6081
#define MASK_C_MOP_1 0xffff
#define MATCH_C_MOP_3 0x6181
#define MASK_C_MOP_3 0xffff
#define MATCH_C_MOP_5 0x6281
#define MASK_C_MOP_5 0xffff
#define MATCH_C_MOP_7 0x6381
#define MASK_C_MOP_7 0xffff
#define MATCH_C_MOP_9 0x6481
#define MASK_C_MOP_9 0xffff
#define MATCH_C_MOP_11 0x6581
#define MASK_C_MOP_11 0xffff
#define MATCH_C_MOP_13 0x6681
#define MASK_C_MOP_13 0xffff
#define MATCH_C_MOP_15 0x6781
#define MASK_C_MOP_15 0xffff
/* Zcmp instructions.  */
#define MATCH_CM_PUSH 0xb802
#define MASK_CM_PUSH 0xff03
#define MATCH_CM_POP 0xba02
#define MASK_CM_POP 0xff03
#define MATCH_CM_POPRET 0xbe02
#define MASK_CM_POPRET 0xff03
#define MATCH_CM_POPRETZ 0xbc02
#define MASK_CM_POPRETZ 0xff03
#define MATCH_CM_MVA01S 0xac62
#define MASK_CM_MVA01S 0xfc63
#define MATCH_CM_MVSA01 0xac22
#define MASK_CM_MVSA01 0xfc63
/* Zcmt instructions.  */
#define MATCH_CM_JT 0xa002
#define MASK_CM_JT 0xfc03
#define MATCH_CM_JALT 0xa002
#define MASK_CM_JALT 0xfc03
/* Smctr/Ssctr instruction.  */
#define MATCH_SCTRCLR 0x10400073
#define MASK_SCTRCLR 0xffffffff
/* Svinval instruction.  */
#define MATCH_SINVAL_VMA 0x16000073
#define MASK_SINVAL_VMA 0xfe007fff
#define MATCH_SFENCE_W_INVAL 0x18000073
#define MASK_SFENCE_W_INVAL 0xffffffff
#define MATCH_SFENCE_INVAL_IR 0x18100073
#define MASK_SFENCE_INVAL_IR 0xffffffff
#define MATCH_HINVAL_VVMA 0x26000073
#define MASK_HINVAL_VVMA 0xfe007fff
#define MATCH_HINVAL_GVMA 0x66000073
#define MASK_HINVAL_GVMA 0xfe007fff
/* Hypervisor instruction.  */
#define MATCH_HFENCE_VVMA 0x22000073
#define MASK_HFENCE_VVMA 0xfe007fff
#define MATCH_HFENCE_GVMA 0x62000073
#define MASK_HFENCE_GVMA 0xfe007fff
#define MATCH_HLV_B 0x60004073
#define MASK_HLV_B 0xfff0707f
#define MATCH_HLV_H 0x64004073
#define MASK_HLV_H 0xfff0707f
#define MATCH_HLV_W 0x68004073
#define MASK_HLV_W 0xfff0707f
#define MATCH_HLV_D 0x6c004073
#define MASK_HLV_D 0xfff0707f
#define MATCH_HLV_BU 0x60104073
#define MASK_HLV_BU 0xfff0707f
#define MATCH_HLV_HU 0x64104073
#define MASK_HLV_HU 0xfff0707f
#define MATCH_HLV_WU 0x68104073
#define MASK_HLV_WU 0xfff0707f
#define MATCH_HLVX_HU 0x64304073
#define MASK_HLVX_HU 0xfff0707f
#define MATCH_HLVX_WU 0x68304073
#define MASK_HLVX_WU 0xfff0707f
#define MATCH_HSV_B 0x62004073
#define MASK_HSV_B 0xfe007fff
#define MATCH_HSV_H 0x66004073
#define MASK_HSV_H 0xfe007fff
#define MATCH_HSV_W 0x6a004073
#define MASK_HSV_W 0xfe007fff
#define MATCH_HSV_D 0x6e004073
#define MASK_HSV_D 0xfe007fff
/* Zicfiss instructions.  */
#define MATCH_SSPUSH 0xce004073
#define MASK_SSPUSH 0xfe0fffff
#define MATCH_SSPOPCHK 0xcdc04073
#define MASK_SSPOPCHK 0xfff07fff
#define MATCH_SSRDP 0xcdc04073
#define MASK_SSRDP 0xfffff07f
#define MATCH_SSAMOSWAP_W 0x4800202f
#define MASK_SSAMOSWAP_W 0xf800707f
#define MATCH_SSAMOSWAP_D 0x4800302f
#define MASK_SSAMOSWAP_D 0xf800707f
#define MATCH_C_SSPUSH 0x6081
#define MASK_C_SSPUSH 0xffff
#define MATCH_C_SSPOPCHK 0x6281
#define MASK_C_SSPOPCHK 0xffff
/* Zicfilp instructions.  */
#define MATCH_LPAD 0x17
#define MASK_LPAD  0xfff
/* Zicbop hint instructions. */
#define MATCH_PREFETCH_I 0x6013
#define MASK_PREFETCH_I 0x1f07fff
#define MATCH_PREFETCH_R 0x106013
#define MASK_PREFETCH_R 0x1f07fff
#define MATCH_PREFETCH_W 0x306013
#define MASK_PREFETCH_W 0x1f07fff
/* Zicbom/Zicboz instructions. */
#define MATCH_CBO_CLEAN 0x10200f
#define MASK_CBO_CLEAN 0xfff07fff
#define MATCH_CBO_FLUSH 0x20200f
#define MASK_CBO_FLUSH 0xfff07fff
#define MATCH_CBO_INVAL 0x200f
#define MASK_CBO_INVAL 0xfff07fff
#define MATCH_CBO_ZERO 0x40200f
#define MASK_CBO_ZERO 0xfff07fff
/* Zicond instructions. */
#define MATCH_CZERO_EQZ 0xe005033
#define MASK_CZERO_EQZ 0xfe00707f
#define MATCH_CZERO_NEZ 0xe007033
#define MASK_CZERO_NEZ 0xfe00707f
/* Zihintntl hint instructions.  */
#define MATCH_NTL_P1 0x200033
#define MASK_NTL_P1 0xffffffff
#define MATCH_NTL_PALL 0x300033
#define MASK_NTL_PALL 0xffffffff
#define MATCH_NTL_S1 0x400033
#define MASK_NTL_S1 0xffffffff
#define MATCH_NTL_ALL 0x500033
#define MASK_NTL_ALL 0xffffffff
#define MATCH_C_NTL_P1 0x900a
#define MASK_C_NTL_P1 0xffff
#define MATCH_C_NTL_PALL 0x900e
#define MASK_C_NTL_PALL 0xffff
#define MATCH_C_NTL_S1 0x9012
#define MASK_C_NTL_S1 0xffff
#define MATCH_C_NTL_ALL 0x9016
#define MASK_C_NTL_ALL 0xffff
/* Zimop instructions.  */
#define MATCH_MOP_R_0 0x81c04073
#define MASK_MOP_R_0 0xfff0707f
#define MATCH_MOP_R_1 0x81d04073
#define MASK_MOP_R_1 0xfff0707f
#define MATCH_MOP_R_2 0x81e04073
#define MASK_MOP_R_2 0xfff0707f
#define MATCH_MOP_R_3 0x81f04073
#define MASK_MOP_R_3 0xfff0707f
#define MATCH_MOP_R_4 0x85c04073
#define MASK_MOP_R_4 0xfff0707f
#define MATCH_MOP_R_5 0x85d04073
#define MASK_MOP_R_5 0xfff0707f
#define MATCH_MOP_R_6 0x85e04073
#define MASK_MOP_R_6 0xfff0707f
#define MATCH_MOP_R_7 0x85f04073
#define MASK_MOP_R_7 0xfff0707f
#define MATCH_MOP_R_8 0x89c04073
#define MASK_MOP_R_8 0xfff0707f
#define MATCH_MOP_R_9 0x89d04073
#define MASK_MOP_R_9 0xfff0707f
#define MATCH_MOP_R_10 0x89e04073
#define MASK_MOP_R_10 0xfff0707f
#define MATCH_MOP_R_11 0x89f04073
#define MASK_MOP_R_11 0xfff0707f
#define MATCH_MOP_R_12 0x8dc04073
#define MASK_MOP_R_12 0xfff0707f
#define MATCH_MOP_R_13 0x8dd04073
#define MASK_MOP_R_13 0xfff0707f
#define MATCH_MOP_R_14 0x8de04073
#define MASK_MOP_R_14 0xfff0707f
#define MATCH_MOP_R_15 0x8df04073
#define MASK_MOP_R_15 0xfff0707f
#define MATCH_MOP_R_16 0xc1c04073
#define MASK_MOP_R_16 0xfff0707f
#define MATCH_MOP_R_17 0xc1d04073
#define MASK_MOP_R_17 0xfff0707f
#define MATCH_MOP_R_18 0xc1e04073
#define MASK_MOP_R_18 0xfff0707f
#define MATCH_MOP_R_19 0xc1f04073
#define MASK_MOP_R_19 0xfff0707f
#define MATCH_MOP_R_20 0xc5c04073
#define MASK_MOP_R_20 0xfff0707f
#define MATCH_MOP_R_21 0xc5d04073
#define MASK_MOP_R_21 0xfff0707f
#define MATCH_MOP_R_22 0xc5e04073
#define MASK_MOP_R_22 0xfff0707f
#define MATCH_MOP_R_23 0xc5f04073
#define MASK_MOP_R_23 0xfff0707f
#define MATCH_MOP_R_24 0xc9c04073
#define MASK_MOP_R_24 0xfff0707f
#define MATCH_MOP_R_25 0xc9d04073
#define MASK_MOP_R_25 0xfff0707f
#define MATCH_MOP_R_26 0xc9e04073
#define MASK_MOP_R_26 0xfff0707f
#define MATCH_MOP_R_27 0xc9f04073
#define MASK_MOP_R_27 0xfff0707f
#define MATCH_MOP_R_28 0xcdc04073
#define MASK_MOP_R_28 0xfff0707f
#define MATCH_MOP_R_29 0xcdd04073
#define MASK_MOP_R_29 0xfff0707f
#define MATCH_MOP_R_30 0xcde04073
#define MASK_MOP_R_30 0xfff0707f
#define MATCH_MOP_R_31 0xcdf04073
#define MASK_MOP_R_31 0xfff0707f
#define MATCH_MOP_RR_0 0x82004073
#define MASK_MOP_RR_0 0xfe00707f
#define MATCH_MOP_RR_1 0x86004073
#define MASK_MOP_RR_1 0xfe00707f
#define MATCH_MOP_RR_2 0x8a004073
#define MASK_MOP_RR_2 0xfe00707f
#define MATCH_MOP_RR_3 0x8e004073
#define MASK_MOP_RR_3 0xfe00707f
#define MATCH_MOP_RR_4 0xc2004073
#define MASK_MOP_RR_4 0xfe00707f
#define MATCH_MOP_RR_5 0xc6004073
#define MASK_MOP_RR_5 0xfe00707f
#define MATCH_MOP_RR_6 0xca004073
#define MASK_MOP_RR_6 0xfe00707f
#define MATCH_MOP_RR_7 0xce004073
#define MASK_MOP_RR_7 0xfe00707f
/* Zacas instructions.  */
#define MATCH_AMOCAS_W 0x2800202f
#define MASK_AMOCAS_W 0xf800707f
#define MATCH_AMOCAS_D 0x2800302f
#define MASK_AMOCAS_D 0xf800707f
#define MATCH_AMOCAS_Q 0x2800402f
#define MASK_AMOCAS_Q 0xf800707f
/* Zawrs instructions.  */
#define MATCH_WRS_NTO 0x00d00073
#define MASK_WRS_NTO 0xffffffff
#define MATCH_WRS_STO 0x01d00073
#define MASK_WRS_STO 0xffffffff
/* Zfbfmin intructions.  */
#define MATCH_FCVT_BF16_S 0x44800053
#define MASK_FCVT_BF16_S 0xfff0007f
#define MATCH_FCVT_S_BF16 0x40600053
#define MASK_FCVT_S_BF16 0xfff0007f
/* Zvfbfmin intructions.  */
#define MATCH_VFNCVTBF16_F_F_W 0x480e9057
#define MASK_VFNCVTBF16_F_F_W 0xfc0ff07f
#define MATCH_VFWCVTBF16_F_F_V 0x48069057
#define MASK_VFWCVTBF16_F_F_V 0xfc0ff07f
/* Zvfbfwma intructions.  */
#define MATCH_VFWMACCBF16_VF 0xec005057
#define MASK_VFWMACCBF16_VF 0xfc00707f
#define MATCH_VFWMACCBF16_VV 0xec001057
#define MASK_VFWMACCBF16_VV 0xfc00707f
/* Vendor-specific (CORE-V) Xcvmac instructions.  */
#define MATCH_CV_MAC       0x9000302b
#define MASK_CV_MAC        0xfe00707f
#define MATCH_CV_MSU       0x9200302b
#define MASK_CV_MSU        0xfe00707f
#define MATCH_CV_MULSN     0x405b
#define MASK_CV_MULSN      0xc000707f
#define MATCH_CV_MULHHSN   0x4000405b
#define MASK_CV_MULHHSN    0xc000707f
#define MATCH_CV_MULSRN    0x8000405b
#define MASK_CV_MULSRN     0xc000707f
#define MATCH_CV_MULHHSRN  0xc000405b
#define MASK_CV_MULHHSRN   0xc000707f
#define MATCH_CV_MULUN     0x505b
#define MASK_CV_MULUN      0xc000707f
#define MATCH_CV_MULHHUN   0x4000505b
#define MASK_CV_MULHHUN    0xc000707f
#define MATCH_CV_MULURN    0x8000505b
#define MASK_CV_MULURN     0xc000707f
#define MATCH_CV_MULHHURN  0xc000505b
#define MASK_CV_MULHHURN   0xc000707f
#define MATCH_CV_MACSN     0x605b
#define MASK_CV_MACSN      0xc000707f
#define MATCH_CV_MACHHSN   0x4000605b
#define MASK_CV_MACHHSN    0xc000707f
#define MATCH_CV_MACSRN    0x8000605b
#define MASK_CV_MACSRN     0xc000707f
#define MATCH_CV_MACHHSRN  0xc000605b
#define MASK_CV_MACHHSRN   0xc000707f
#define MATCH_CV_MACUN     0x705b
#define MASK_CV_MACUN      0xc000707f
#define MATCH_CV_MACHHUN   0x4000705b
#define MASK_CV_MACHHUN    0xc000707f
#define MATCH_CV_MACURN    0x8000705b
#define MASK_CV_MACURN     0xc000707f
#define MATCH_CV_MACHHURN  0xc000705b
#define MASK_CV_MACHHURN   0xc000707f
/* Vendor-specific (CORE-V) Xcvalu instructions.  */
#define MATCH_CV_ABS 0x5000302b
#define MASK_CV_ABS 0xfff0707f
#define MATCH_CV_SLE 0x5200302b
#define MASK_CV_SLE 0xfe00707f
#define MATCH_CV_SLET 0x5200302b
#define MASK_CV_SLET 0xfe00707f
#define MATCH_CV_SLEU 0x5400302b
#define MASK_CV_SLEU 0xfe00707f
#define MATCH_CV_SLETU 0x5400302b
#define MASK_CV_SLETU 0xfe00707f
#define MATCH_CV_MIN 0x5600302b
#define MASK_CV_MIN 0xfe00707f
#define MATCH_CV_MINU 0x5800302b
#define MASK_CV_MINU 0xfe00707f
#define MATCH_CV_MAX 0x5a00302b
#define MASK_CV_MAX 0xfe00707f
#define MATCH_CV_MAXU 0x5c00302b
#define MASK_CV_MAXU 0xfe00707f
#define MATCH_CV_EXTHS 0x6000302b
#define MASK_CV_EXTHS 0xfff0707f
#define MATCH_CV_EXTHZ 0x6200302b
#define MASK_CV_EXTHZ 0xfff0707f
#define MATCH_CV_EXTBS 0x6400302b
#define MASK_CV_EXTBS 0xfff0707f
#define MATCH_CV_EXTBZ 0x6600302b
#define MASK_CV_EXTBZ 0xfff0707f
#define MATCH_CV_CLIP 0x7000302b
#define MASK_CV_CLIP 0xfe00707f
#define MATCH_CV_CLIPU 0x7200302b
#define MASK_CV_CLIPU 0xfe00707f
#define MATCH_CV_CLIPR 0x7400302b
#define MASK_CV_CLIPR 0xfe00707f
#define MATCH_CV_CLIPUR 0x7600302b
#define MASK_CV_CLIPUR 0xfe00707f
#define MATCH_CV_ADDNR 0x8000302b
#define MASK_CV_ADDNR 0xfe00707f
#define MATCH_CV_ADDUNR 0x8200302b
#define MASK_CV_ADDUNR 0xfe00707f
#define MATCH_CV_ADDRNR 0x8400302b
#define MASK_CV_ADDRNR 0xfe00707f
#define MATCH_CV_ADDURNR 0x8600302b
#define MASK_CV_ADDURNR 0xfe00707f
#define MATCH_CV_SUBNR 0x8800302b
#define MASK_CV_SUBNR 0xfe00707f
#define MATCH_CV_SUBUNR 0x8a00302b
#define MASK_CV_SUBUNR 0xfe00707f
#define MATCH_CV_SUBRNR 0x8c00302b
#define MASK_CV_SUBRNR 0xfe00707f
#define MATCH_CV_SUBURNR 0x8e00302b
#define MASK_CV_SUBURNR 0xfe00707f
#define MATCH_CV_ADDN 0x205b
#define MASK_CV_ADDN 0xc000707f
#define MATCH_CV_ADDUN 0x4000205b
#define MASK_CV_ADDUN 0xc000707f
#define MATCH_CV_ADDRN 0x8000205b
#define MASK_CV_ADDRN 0xc000707f
#define MATCH_CV_ADDURN 0xc000205b
#define MASK_CV_ADDURN 0xc000707f
#define MATCH_CV_SUBN 0x305b
#define MASK_CV_SUBN 0xc000707f
#define MATCH_CV_SUBUN 0x4000305b
#define MASK_CV_SUBUN 0xc000707f
#define MATCH_CV_SUBRN 0x8000305b
#define MASK_CV_SUBRN 0xc000707f
#define MATCH_CV_SUBURN 0xc000305b
#define MASK_CV_SUBURN 0xc000707f
/* Vendor-specific (CORE-V) Xcvelw instructions. */
#define MATCH_CV_ELW 0x600b
#define MASK_CV_ELW 0x707f
/* Vendor-specific (CORE-V) Xcvbi instructions. */
#define MATCH_CV_BNEIMM 0x700b
#define MASK_CV_BNEIMM 0x707f
#define MATCH_CV_BEQIMM 0x600b
#define MASK_CV_BEQIMM 0x707f
/* Vendor-specific (CORE-V) Xcvmem instructions. */
#define MASK_CV_LBPOST     0x707f
#define MATCH_CV_LBPOST    0xb
#define MASK_CV_LBUPOST    0x707f
#define MATCH_CV_LBUPOST   0x400b
#define MASK_CV_LHPOST     0x707f
#define MATCH_CV_LHPOST    0x100b
#define MASK_CV_LHUPOST    0x707f
#define MATCH_CV_LHUPOST   0x500b
#define MASK_CV_LWPOST     0x707f
#define MATCH_CV_LWPOST    0x200b
#define MASK_CV_LBRRPOST   0xfe00707f
#define MATCH_CV_LBRRPOST  0x302b
#define MASK_CV_LBURRPOST  0xfe00707f
#define MATCH_CV_LBURRPOST 0x1000302b
#define MASK_CV_LHRRPOST   0xfe00707f
#define MATCH_CV_LHRRPOST  0x200302b
#define MASK_CV_LHURRPOST  0xfe00707f
#define MATCH_CV_LHURRPOST 0x1200302b
#define MASK_CV_LWRRPOST   0xfe00707f
#define MATCH_CV_LWRRPOST  0x400302b
#define MASK_CV_LBRR       0xfe00707f
#define MATCH_CV_LBRR      0x800302b
#define MASK_CV_LBURR      0xfe00707f
#define MATCH_CV_LBURR     0x1800302b
#define MASK_CV_LHRR       0xfe00707f
#define MATCH_CV_LHRR      0xa00302b
#define MASK_CV_LHURR      0xfe00707f
#define MATCH_CV_LHURR     0x1a00302b
#define MASK_CV_LWRR       0xfe00707f
#define MATCH_CV_LWRR      0xc00302b
#define MASK_CV_SBPOST     0x707f
#define MATCH_CV_SBPOST    0x2b
#define MASK_CV_SHPOST     0x707f
#define MATCH_CV_SHPOST    0x102b
#define MASK_CV_SWPOST     0x707f
#define MATCH_CV_SWPOST    0x202b
#define MASK_CV_SBRRPOST   0xfe00707f
#define MATCH_CV_SBRRPOST  0x2000302b
#define MASK_CV_SHRRPOST   0xfe00707f
#define MATCH_CV_SHRRPOST  0x2200302b
#define MASK_CV_SWRRPOST   0xfe00707f
#define MATCH_CV_SWRRPOST  0x2400302b
#define MASK_CV_SBRR       0xfe00707f
#define MATCH_CV_SBRR      0x2800302b
#define MASK_CV_SHRR       0xfe00707f
#define MATCH_CV_SHRR      0x2a00302b
#define MASK_CV_SWRR       0xfe00707f
#define MATCH_CV_SWRR      0x2c00302b
/* Vendor-specific (CORE-V) Xcvbitmanip instructions.  */
#define MATCH_CV_EXTRACTR     0x3000302b
#define MATCH_CV_EXTRACTUR    0x3200302b
#define MATCH_CV_INSERTR      0x3400302b
#define MATCH_CV_BCLRR        0x3800302b
#define MATCH_CV_BSETR        0x3a00302b
#define MATCH_CV_ROR          0x4000302b
#define MATCH_CV_FF1          0x4200302b
#define MATCH_CV_FL1          0x4400302b
#define MATCH_CV_CLB          0x4600302b
#define MATCH_CV_CNT          0x4800302b
#define MATCH_CV_EXTRACT      0x5b
#define MATCH_CV_EXTRACTU     0x4000005b
#define MATCH_CV_INSERT       0x8000005b
#define MATCH_CV_BCLR         0x105b
#define MATCH_CV_BSET         0x4000105b
#define MATCH_CV_BITREV       0xc000105b
#define MASK_CV_EXTRACTR      0xfe00707f
#define MASK_CV_EXTRACTUR     0xfe00707f
#define MASK_CV_INSERTR       0xfe00707f
#define MASK_CV_BCLRR         0xfe00707f
#define MASK_CV_BSETR         0xfe00707f
#define MASK_CV_ROR           0xfe00707f
#define MASK_CV_FF1           0xfff0707f
#define MASK_CV_FL1           0xfff0707f
#define MASK_CV_CLB           0xfff0707f
#define MASK_CV_CNT           0xfff0707f
#define MASK_CV_EXTRACT       0xc000707f
#define MASK_CV_EXTRACTU      0xc000707f
#define MASK_CV_INSERT        0xc000707f
#define MASK_CV_BCLR          0xc000707f
#define MASK_CV_BSET          0xc000707f
#define MASK_CV_BITREV        0xf800707f
/* Vendor-specific (CORE-V) Xcvsimd instructions. */
#define MATCH_CV_ADD_H             0x7b
#define MATCH_CV_ADD_B             0x107b
#define MATCH_CV_ADD_SC_H          0x407b
#define MATCH_CV_ADD_SC_B          0x507b
#define MATCH_CV_ADD_SCI_H         0x607b
#define MATCH_CV_ADD_SCI_B         0x707b
#define MATCH_CV_SUB_H             0x800007b
#define MATCH_CV_SUB_B             0x800107b
#define MATCH_CV_SUB_SC_H          0x800407b
#define MATCH_CV_SUB_SC_B          0x800507b
#define MATCH_CV_SUB_SCI_H         0x800607b
#define MATCH_CV_SUB_SCI_B         0x800707b
#define MATCH_CV_AVG_H             0x1000007b
#define MATCH_CV_AVG_B             0x1000107b
#define MATCH_CV_AVG_SC_H          0x1000407b
#define MATCH_CV_AVG_SC_B          0x1000507b
#define MATCH_CV_AVG_SCI_H         0x1000607b
#define MATCH_CV_AVG_SCI_B         0x1000707b
#define MATCH_CV_AVGU_H            0x1800007b
#define MATCH_CV_AVGU_B            0x1800107b
#define MATCH_CV_AVGU_SC_H         0x1800407b
#define MATCH_CV_AVGU_SC_B         0x1800507b
#define MATCH_CV_AVGU_SCI_H        0x1800607b
#define MATCH_CV_AVGU_SCI_B        0x1800707b
#define MATCH_CV_MIN_H             0x2000007b
#define MATCH_CV_MIN_B             0x2000107b
#define MATCH_CV_MIN_SC_H          0x2000407b
#define MATCH_CV_MIN_SC_B          0x2000507b
#define MATCH_CV_MIN_SCI_H         0x2000607b
#define MATCH_CV_MIN_SCI_B         0x2000707b
#define MATCH_CV_MINU_H            0x2800007b
#define MATCH_CV_MINU_B            0x2800107b
#define MATCH_CV_MINU_SC_H         0x2800407b
#define MATCH_CV_MINU_SC_B         0x2800507b
#define MATCH_CV_MINU_SCI_H        0x2800607b
#define MATCH_CV_MINU_SCI_B        0x2800707b
#define MATCH_CV_MAX_H             0x3000007b
#define MATCH_CV_MAX_B             0x3000107b
#define MATCH_CV_MAX_SC_H          0x3000407b
#define MATCH_CV_MAX_SC_B          0x3000507b
#define MATCH_CV_MAX_SCI_H         0x3000607b
#define MATCH_CV_MAX_SCI_B         0x3000707b
#define MATCH_CV_MAXU_H            0x3800007b
#define MATCH_CV_MAXU_B            0x3800107b
#define MATCH_CV_MAXU_SC_H         0x3800407b
#define MATCH_CV_MAXU_SC_B         0x3800507b
#define MATCH_CV_MAXU_SCI_H        0x3800607b
#define MATCH_CV_MAXU_SCI_B        0x3800707b
#define MATCH_CV_SRL_H             0x4000007b
#define MATCH_CV_SRL_B             0x4000107b
#define MATCH_CV_SRL_SC_H          0x4000407b
#define MATCH_CV_SRL_SC_B          0x4000507b
#define MATCH_CV_SRL_SCI_H         0x4000607b
#define MATCH_CV_SRL_SCI_B         0x4000707b
#define MATCH_CV_SRA_H             0x4800007b
#define MATCH_CV_SRA_B             0x4800107b
#define MATCH_CV_SRA_SC_H          0x4800407b
#define MATCH_CV_SRA_SC_B          0x4800507b
#define MATCH_CV_SRA_SCI_H         0x4800607b
#define MATCH_CV_SRA_SCI_B         0x4800707b
#define MATCH_CV_SLL_H             0x5000007b
#define MATCH_CV_SLL_B             0x5000107b
#define MATCH_CV_SLL_SC_H          0x5000407b
#define MATCH_CV_SLL_SC_B          0x5000507b
#define MATCH_CV_SLL_SCI_H         0x5000607b
#define MATCH_CV_SLL_SCI_B         0x5000707b
#define MATCH_CV_OR_H              0x5800007b
#define MATCH_CV_OR_B              0x5800107b
#define MATCH_CV_OR_SC_H           0x5800407b
#define MATCH_CV_OR_SC_B           0x5800507b
#define MATCH_CV_OR_SCI_H          0x5800607b
#define MATCH_CV_OR_SCI_B          0x5800707b
#define MATCH_CV_XOR_H             0x6000007b
#define MATCH_CV_XOR_B             0x6000107b
#define MATCH_CV_XOR_SC_H          0x6000407b
#define MATCH_CV_XOR_SC_B          0x6000507b
#define MATCH_CV_XOR_SCI_H         0x6000607b
#define MATCH_CV_XOR_SCI_B         0x6000707b
#define MATCH_CV_AND_H             0x6800007b
#define MATCH_CV_AND_B             0x6800107b
#define MATCH_CV_AND_SC_H          0x6800407b
#define MATCH_CV_AND_SC_B          0x6800507b
#define MATCH_CV_AND_SCI_H         0x6800607b
#define MATCH_CV_AND_SCI_B         0x6800707b
#define MATCH_CV_ABS_H             0x7000007b
#define MATCH_CV_ABS_B             0x7000107b
#define MATCH_CV_DOTUP_H           0x8000007b
#define MATCH_CV_DOTUP_B           0x8000107b
#define MATCH_CV_DOTUP_SC_H        0x8000407b
#define MATCH_CV_DOTUP_SC_B        0x8000507b
#define MATCH_CV_DOTUP_SCI_H       0x8000607b
#define MATCH_CV_DOTUP_SCI_B       0x8000707b
#define MATCH_CV_DOTUSP_H          0x8800007b
#define MATCH_CV_DOTUSP_B          0x8800107b
#define MATCH_CV_DOTUSP_SC_H       0x8800407b
#define MATCH_CV_DOTUSP_SC_B       0x8800507b
#define MATCH_CV_DOTUSP_SCI_H      0x8800607b
#define MATCH_CV_DOTUSP_SCI_B      0x8800707b
#define MATCH_CV_DOTSP_H           0x9000007b
#define MATCH_CV_DOTSP_B           0x9000107b
#define MATCH_CV_DOTSP_SC_H        0x9000407b
#define MATCH_CV_DOTSP_SC_B        0x9000507b
#define MATCH_CV_DOTSP_SCI_H       0x9000607b
#define MATCH_CV_DOTSP_SCI_B       0x9000707b
#define MATCH_CV_SDOTUP_H          0x9800007b
#define MATCH_CV_SDOTUP_B          0x9800107b
#define MATCH_CV_SDOTUP_SC_H       0x9800407b
#define MATCH_CV_SDOTUP_SC_B       0x9800507b
#define MATCH_CV_SDOTUP_SCI_H      0x9800607b
#define MATCH_CV_SDOTUP_SCI_B      0x9800707b
#define MATCH_CV_SDOTUSP_H         0xa000007b
#define MATCH_CV_SDOTUSP_B         0xa000107b
#define MATCH_CV_SDOTUSP_SC_H      0xa000407b
#define MATCH_CV_SDOTUSP_SC_B      0xa000507b
#define MATCH_CV_SDOTUSP_SCI_H     0xa000607b
#define MATCH_CV_SDOTUSP_SCI_B     0xa000707b
#define MATCH_CV_SDOTSP_H          0xa800007b
#define MATCH_CV_SDOTSP_B          0xa800107b
#define MATCH_CV_SDOTSP_SC_H       0xa800407b
#define MATCH_CV_SDOTSP_SC_B       0xa800507b
#define MATCH_CV_SDOTSP_SCI_H      0xa800607b
#define MATCH_CV_SDOTSP_SCI_B      0xa800707b
#define MATCH_CV_EXTRACT_H         0xb800007b
#define MATCH_CV_EXTRACT_B         0xb800107b
#define MATCH_CV_EXTRACTU_H        0xb800207b
#define MATCH_CV_EXTRACTU_B        0xb800307b
#define MATCH_CV_INSERT_H          0xb800407b
#define MATCH_CV_INSERT_B          0xb800507b
#define MATCH_CV_SHUFFLE_H         0xc000007b
#define MATCH_CV_SHUFFLE_B         0xc000107b
#define MATCH_CV_SHUFFLE_SCI_H     0xc000607b
#define MATCH_CV_SHUFFLEI0_SCI_B   0xc000707b
#define MATCH_CV_SHUFFLEI1_SCI_B   0xc800707b
#define MATCH_CV_SHUFFLEI2_SCI_B   0xd000707b
#define MATCH_CV_SHUFFLEI3_SCI_B   0xd800707b
#define MATCH_CV_SHUFFLE2_H        0xe000007b
#define MATCH_CV_SHUFFLE2_B        0xe000107b
#define MATCH_CV_PACK              0xf000007b
#define MATCH_CV_PACK_H            0xf200007b
#define MATCH_CV_PACKHI_B          0xfa00107b
#define MATCH_CV_PACKLO_B          0xf800107b
#define MATCH_CV_CMPEQ_H           0x400007b
#define MATCH_CV_CMPEQ_B           0x400107b
#define MATCH_CV_CMPEQ_SC_H        0x400407b
#define MATCH_CV_CMPEQ_SC_B        0x400507b
#define MATCH_CV_CMPEQ_SCI_H       0x400607b
#define MATCH_CV_CMPEQ_SCI_B       0x400707b
#define MATCH_CV_CMPNE_H           0xc00007b
#define MATCH_CV_CMPNE_B           0xc00107b
#define MATCH_CV_CMPNE_SC_H        0xc00407b
#define MATCH_CV_CMPNE_SC_B        0xc00507b
#define MATCH_CV_CMPNE_SCI_H       0xc00607b
#define MATCH_CV_CMPNE_SCI_B       0xc00707b
#define MATCH_CV_CMPGT_H           0x1400007b
#define MATCH_CV_CMPGT_B           0x1400107b
#define MATCH_CV_CMPGT_SC_H        0x1400407b
#define MATCH_CV_CMPGT_SC_B        0x1400507b
#define MATCH_CV_CMPGT_SCI_H       0x1400607b
#define MATCH_CV_CMPGT_SCI_B       0x1400707b
#define MATCH_CV_CMPGE_H           0x1c00007b
#define MATCH_CV_CMPGE_B           0x1c00107b
#define MATCH_CV_CMPGE_SC_H        0x1c00407b
#define MATCH_CV_CMPGE_SC_B        0x1c00507b
#define MATCH_CV_CMPGE_SCI_H       0x1c00607b
#define MATCH_CV_CMPGE_SCI_B       0x1c00707b
#define MATCH_CV_CMPLT_H           0x2400007b
#define MATCH_CV_CMPLT_B           0x2400107b
#define MATCH_CV_CMPLT_SC_H        0x2400407b
#define MATCH_CV_CMPLT_SC_B        0x2400507b
#define MATCH_CV_CMPLT_SCI_H       0x2400607b
#define MATCH_CV_CMPLT_SCI_B       0x2400707b
#define MATCH_CV_CMPLE_H           0x2c00007b
#define MATCH_CV_CMPLE_B           0x2c00107b
#define MATCH_CV_CMPLE_SC_H        0x2c00407b
#define MATCH_CV_CMPLE_SC_B        0x2c00507b
#define MATCH_CV_CMPLE_SCI_H       0x2c00607b
#define MATCH_CV_CMPLE_SCI_B       0x2c00707b
#define MATCH_CV_CMPGTU_H          0x3400007b
#define MATCH_CV_CMPGTU_B          0x3400107b
#define MATCH_CV_CMPGTU_SC_H       0x3400407b
#define MATCH_CV_CMPGTU_SC_B       0x3400507b
#define MATCH_CV_CMPGTU_SCI_H      0x3400607b
#define MATCH_CV_CMPGTU_SCI_B      0x3400707b
#define MATCH_CV_CMPGEU_H          0x3c00007b
#define MATCH_CV_CMPGEU_B          0x3c00107b
#define MATCH_CV_CMPGEU_SC_H       0x3c00407b
#define MATCH_CV_CMPGEU_SC_B       0x3c00507b
#define MATCH_CV_CMPGEU_SCI_H      0x3c00607b
#define MATCH_CV_CMPGEU_SCI_B      0x3c00707b
#define MATCH_CV_CMPLTU_H          0x4400007b
#define MATCH_CV_CMPLTU_B          0x4400107b
#define MATCH_CV_CMPLTU_SC_H       0x4400407b
#define MATCH_CV_CMPLTU_SC_B       0x4400507b
#define MATCH_CV_CMPLTU_SCI_H      0x4400607b
#define MATCH_CV_CMPLTU_SCI_B      0x4400707b
#define MATCH_CV_CMPLEU_H          0x4c00007b
#define MATCH_CV_CMPLEU_B          0x4c00107b
#define MATCH_CV_CMPLEU_SC_H       0x4c00407b
#define MATCH_CV_CMPLEU_SC_B       0x4c00507b
#define MATCH_CV_CMPLEU_SCI_H      0x4c00607b
#define MATCH_CV_CMPLEU_SCI_B      0x4c00707b
#define MATCH_CV_CPLXMUL_R         0x5400007b
#define MATCH_CV_CPLXMUL_I         0x5600007b
#define MATCH_CV_CPLXMUL_R_DIV2    0x5400207b
#define MATCH_CV_CPLXMUL_I_DIV2    0x5600207b
#define MATCH_CV_CPLXMUL_R_DIV4    0x5400407b
#define MATCH_CV_CPLXMUL_I_DIV4    0x5600407b
#define MATCH_CV_CPLXMUL_R_DIV8    0x5400607b
#define MATCH_CV_CPLXMUL_I_DIV8    0x5600607b
#define MATCH_CV_CPLXCONJ          0x5c00007b
#define MATCH_CV_SUBROTMJ          0x6400007b
#define MATCH_CV_SUBROTMJ_DIV2     0x6400207b
#define MATCH_CV_SUBROTMJ_DIV4     0x6400407b
#define MATCH_CV_SUBROTMJ_DIV8     0x6400607b
#define MATCH_CV_ADD_DIV2          0x6c00207b
#define MATCH_CV_ADD_DIV4          0x6c00407b
#define MATCH_CV_ADD_DIV8          0x6c00607b
#define MATCH_CV_SUB_DIV2          0x7400207b
#define MATCH_CV_SUB_DIV4          0x7400407b
#define MATCH_CV_SUB_DIV8          0x7400607b
#define MASK_CV_ADD_H              0xfe00707f
#define MASK_CV_ADD_B              0xfe00707f
#define MASK_CV_ADD_SC_H           0xfe00707f
#define MASK_CV_ADD_SC_B           0xfe00707f
#define MASK_CV_ADD_SCI_H          0xfc00707f
#define MASK_CV_ADD_SCI_B          0xfc00707f
#define MASK_CV_SUB_H              0xfe00707f
#define MASK_CV_SUB_B              0xfe00707f
#define MASK_CV_SUB_SC_H           0xfe00707f
#define MASK_CV_SUB_SC_B           0xfe00707f
#define MASK_CV_SUB_SCI_H          0xfc00707f
#define MASK_CV_SUB_SCI_B          0xfc00707f
#define MASK_CV_AVG_H              0xfe00707f
#define MASK_CV_AVG_B              0xfe00707f
#define MASK_CV_AVG_SC_H           0xfe00707f
#define MASK_CV_AVG_SC_B           0xfe00707f
#define MASK_CV_AVG_SCI_H          0xfc00707f
#define MASK_CV_AVG_SCI_B          0xfc00707f
#define MASK_CV_AVGU_H             0xfe00707f
#define MASK_CV_AVGU_B             0xfe00707f
#define MASK_CV_AVGU_SC_H          0xfe00707f
#define MASK_CV_AVGU_SC_B          0xfe00707f
#define MASK_CV_AVGU_SCI_H         0xfc00707f
#define MASK_CV_AVGU_SCI_B         0xfc00707f
#define MASK_CV_MIN_H              0xfe00707f
#define MASK_CV_MIN_B              0xfe00707f
#define MASK_CV_MIN_SC_H           0xfe00707f
#define MASK_CV_MIN_SC_B           0xfe00707f
#define MASK_CV_MIN_SCI_H          0xfc00707f
#define MASK_CV_MIN_SCI_B          0xfc00707f
#define MASK_CV_MINU_H             0xfe00707f
#define MASK_CV_MINU_B             0xfe00707f
#define MASK_CV_MINU_SC_H          0xfe00707f
#define MASK_CV_MINU_SC_B          0xfe00707f
#define MASK_CV_MINU_SCI_H         0xfc00707f
#define MASK_CV_MINU_SCI_B         0xfc00707f
#define MASK_CV_MAX_H              0xfe00707f
#define MASK_CV_MAX_B              0xfe00707f
#define MASK_CV_MAX_SC_H           0xfe00707f
#define MASK_CV_MAX_SC_B           0xfe00707f
#define MASK_CV_MAX_SCI_H          0xfc00707f
#define MASK_CV_MAX_SCI_B          0xfc00707f
#define MASK_CV_MAXU_H             0xfe00707f
#define MASK_CV_MAXU_B             0xfe00707f
#define MASK_CV_MAXU_SC_H          0xfe00707f
#define MASK_CV_MAXU_SC_B          0xfe00707f
#define MASK_CV_MAXU_SCI_H         0xfc00707f
#define MASK_CV_MAXU_SCI_B         0xfc00707f
#define MASK_CV_SRL_H              0xfe00707f
#define MASK_CV_SRL_B              0xfe00707f
#define MASK_CV_SRL_SC_H           0xfe00707f
#define MASK_CV_SRL_SC_B           0xfe00707f
#define MASK_CV_SRL_SCI_H          0xfc00707f
#define MASK_CV_SRL_SCI_B          0xfc00707f
#define MASK_CV_SRA_H              0xfe00707f
#define MASK_CV_SRA_B              0xfe00707f
#define MASK_CV_SRA_SC_H           0xfe00707f
#define MASK_CV_SRA_SC_B           0xfe00707f
#define MASK_CV_SRA_SCI_H          0xfc00707f
#define MASK_CV_SRA_SCI_B          0xfc00707f
#define MASK_CV_SLL_H              0xfe00707f
#define MASK_CV_SLL_B              0xfe00707f
#define MASK_CV_SLL_SC_H           0xfe00707f
#define MASK_CV_SLL_SC_B           0xfe00707f
#define MASK_CV_SLL_SCI_H          0xfc00707f
#define MASK_CV_SLL_SCI_B          0xfc00707f
#define MASK_CV_OR_H               0xfe00707f
#define MASK_CV_OR_B               0xfe00707f
#define MASK_CV_OR_SC_H            0xfe00707f
#define MASK_CV_OR_SC_B            0xfe00707f
#define MASK_CV_OR_SCI_H           0xfc00707f
#define MASK_CV_OR_SCI_B           0xfc00707f
#define MASK_CV_XOR_H              0xfe00707f
#define MASK_CV_XOR_B              0xfe00707f
#define MASK_CV_XOR_SC_H           0xfe00707f
#define MASK_CV_XOR_SC_B           0xfe00707f
#define MASK_CV_XOR_SCI_H          0xfc00707f
#define MASK_CV_XOR_SCI_B          0xfc00707f
#define MASK_CV_AND_H              0xfe00707f
#define MASK_CV_AND_B              0xfe00707f
#define MASK_CV_AND_SC_H           0xfe00707f
#define MASK_CV_AND_SC_B           0xfe00707f
#define MASK_CV_AND_SCI_H          0xfc00707f
#define MASK_CV_AND_SCI_B          0xfc00707f
#define MASK_CV_ABS_H              0xfff0707f
#define MASK_CV_ABS_B              0xfff0707f
#define MASK_CV_DOTUP_H            0xfe00707f
#define MASK_CV_DOTUP_B            0xfe00707f
#define MASK_CV_DOTUP_SC_H         0xfe00707f
#define MASK_CV_DOTUP_SC_B         0xfe00707f
#define MASK_CV_DOTUP_SCI_H        0xfc00707f
#define MASK_CV_DOTUP_SCI_B        0xfc00707f
#define MASK_CV_DOTUSP_H           0xfe00707f
#define MASK_CV_DOTUSP_B           0xfe00707f
#define MASK_CV_DOTUSP_SC_H        0xfe00707f
#define MASK_CV_DOTUSP_SC_B        0xfe00707f
#define MASK_CV_DOTUSP_SCI_H       0xfc00707f
#define MASK_CV_DOTUSP_SCI_B       0xfc00707f
#define MASK_CV_DOTSP_H            0xfe00707f
#define MASK_CV_DOTSP_B            0xfe00707f
#define MASK_CV_DOTSP_SC_H         0xfe00707f
#define MASK_CV_DOTSP_SC_B         0xfe00707f
#define MASK_CV_DOTSP_SCI_H        0xfc00707f
#define MASK_CV_DOTSP_SCI_B        0xfc00707f
#define MASK_CV_SDOTUP_H           0xfe00707f
#define MASK_CV_SDOTUP_B           0xfe00707f
#define MASK_CV_SDOTUP_SC_H        0xfe00707f
#define MASK_CV_SDOTUP_SC_B        0xfe00707f
#define MASK_CV_SDOTUP_SCI_H       0xfc00707f
#define MASK_CV_SDOTUP_SCI_B       0xfc00707f
#define MASK_CV_SDOTUSP_H          0xfe00707f
#define MASK_CV_SDOTUSP_B          0xfe00707f
#define MASK_CV_SDOTUSP_SC_H       0xfe00707f
#define MASK_CV_SDOTUSP_SC_B       0xfe00707f
#define MASK_CV_SDOTUSP_SCI_H      0xfc00707f
#define MASK_CV_SDOTUSP_SCI_B      0xfc00707f
#define MASK_CV_SDOTSP_H           0xfe00707f
#define MASK_CV_SDOTSP_B           0xfe00707f
#define MASK_CV_SDOTSP_SC_H        0xfe00707f
#define MASK_CV_SDOTSP_SC_B        0xfe00707f
#define MASK_CV_SDOTSP_SCI_H       0xfc00707f
#define MASK_CV_SDOTSP_SCI_B       0xfc00707f
#define MASK_CV_EXTRACT_H          0xfc00707f
#define MASK_CV_EXTRACT_B          0xfc00707f
#define MASK_CV_EXTRACTU_H         0xfc00707f
#define MASK_CV_EXTRACTU_B         0xfc00707f
#define MASK_CV_INSERT_H           0xfc00707f
#define MASK_CV_INSERT_B           0xfc00707f
#define MASK_CV_SHUFFLE_H          0xfe00707f
#define MASK_CV_SHUFFLE_B          0xfe00707f
#define MASK_CV_SHUFFLE_SCI_H      0xfc00707f
#define MASK_CV_SHUFFLEI0_SCI_B    0xfc00707f
#define MASK_CV_SHUFFLEI1_SCI_B    0xfc00707f
#define MASK_CV_SHUFFLEI2_SCI_B    0xfc00707f
#define MASK_CV_SHUFFLEI3_SCI_B    0xfc00707f
#define MASK_CV_SHUFFLE2_H         0xfe00707f
#define MASK_CV_SHUFFLE2_B         0xfe00707f
#define MASK_CV_PACK               0xfe00707f
#define MASK_CV_PACK_H             0xfe00707f
#define MASK_CV_PACKHI_B           0xfe00707f
#define MASK_CV_PACKLO_B           0xfe00707f
#define MASK_CV_CMPEQ_H            0xfe00707f
#define MASK_CV_CMPEQ_B            0xfe00707f
#define MASK_CV_CMPEQ_SC_H         0xfe00707f
#define MASK_CV_CMPEQ_SC_B         0xfe00707f
#define MASK_CV_CMPEQ_SCI_H        0xfc00707f
#define MASK_CV_CMPEQ_SCI_B        0xfc00707f
#define MASK_CV_CMPNE_H            0xfe00707f
#define MASK_CV_CMPNE_B            0xfe00707f
#define MASK_CV_CMPNE_SC_H         0xfe00707f
#define MASK_CV_CMPNE_SC_B         0xfe00707f
#define MASK_CV_CMPNE_SCI_H        0xfc00707f
#define MASK_CV_CMPNE_SCI_B        0xfc00707f
#define MASK_CV_CMPGT_H            0xfe00707f
#define MASK_CV_CMPGT_B            0xfe00707f
#define MASK_CV_CMPGT_SC_H         0xfe00707f
#define MASK_CV_CMPGT_SC_B         0xfe00707f
#define MASK_CV_CMPGT_SCI_H        0xfc00707f
#define MASK_CV_CMPGT_SCI_B        0xfc00707f
#define MASK_CV_CMPGE_H            0xfe00707f
#define MASK_CV_CMPGE_B            0xfe00707f
#define MASK_CV_CMPGE_SC_H         0xfe00707f
#define MASK_CV_CMPGE_SC_B         0xfe00707f
#define MASK_CV_CMPGE_SCI_H        0xfc00707f
#define MASK_CV_CMPGE_SCI_B        0xfc00707f
#define MASK_CV_CMPLT_H            0xfe00707f
#define MASK_CV_CMPLT_B            0xfe00707f
#define MASK_CV_CMPLT_SC_H         0xfe00707f
#define MASK_CV_CMPLT_SC_B         0xfe00707f
#define MASK_CV_CMPLT_SCI_H        0xfc00707f
#define MASK_CV_CMPLT_SCI_B        0xfc00707f
#define MASK_CV_CMPLE_H            0xfe00707f
#define MASK_CV_CMPLE_B            0xfe00707f
#define MASK_CV_CMPLE_SC_H         0xfe00707f
#define MASK_CV_CMPLE_SC_B         0xfe00707f
#define MASK_CV_CMPLE_SCI_H        0xfc00707f
#define MASK_CV_CMPLE_SCI_B        0xfc00707f
#define MASK_CV_CMPGTU_H           0xfe00707f
#define MASK_CV_CMPGTU_B           0xfe00707f
#define MASK_CV_CMPGTU_SC_H        0xfe00707f
#define MASK_CV_CMPGTU_SC_B        0xfe00707f
#define MASK_CV_CMPGTU_SCI_H       0xfc00707f
#define MASK_CV_CMPGTU_SCI_B       0xfc00707f
#define MASK_CV_CMPGEU_H           0xfe00707f
#define MASK_CV_CMPGEU_B           0xfe00707f
#define MASK_CV_CMPGEU_SC_H        0xfe00707f
#define MASK_CV_CMPGEU_SC_B        0xfe00707f
#define MASK_CV_CMPGEU_SCI_H       0xfc00707f
#define MASK_CV_CMPGEU_SC_B        0xfe00707f
#define MASK_CV_CMPGEU_SCI_H       0xfc00707f
#define MASK_CV_CMPGEU_SCI_B       0xfc00707f
#define MASK_CV_CMPLTU_H           0xfe00707f
#define MASK_CV_CMPLTU_B           0xfe00707f
#define MASK_CV_CMPLTU_SC_H        0xfe00707f
#define MASK_CV_CMPLTU_SC_B        0xfe00707f
#define MASK_CV_CMPLTU_SCI_H       0xfc00707f
#define MASK_CV_CMPLTU_SCI_B       0xfc00707f
#define MASK_CV_CMPLEU_H           0xfe00707f
#define MASK_CV_CMPLEU_B           0xfe00707f
#define MASK_CV_CMPLEU_SC_H        0xfe00707f
#define MASK_CV_CMPLEU_SC_B        0xfe00707f
#define MASK_CV_CMPLEU_SCI_H       0xfc00707f
#define MASK_CV_CMPLEU_SCI_B       0xfc00707f
#define MASK_CV_CPLXMUL_R          0xfe00707f
#define MASK_CV_CPLXMUL_I          0xfe00707f
#define MASK_CV_CPLXMUL_R_DIV2     0xfe00707f
#define MASK_CV_CPLXMUL_I_DIV2     0xfe00707f
#define MASK_CV_CPLXMUL_R_DIV4     0xfe00707f
#define MASK_CV_CPLXMUL_I_DIV4     0xfe00707f
#define MASK_CV_CPLXMUL_R_DIV8     0xfe00707f
#define MASK_CV_CPLXMUL_I_DIV8     0xfe00707f
#define MASK_CV_CPLXCONJ           0xfff0707f
#define MASK_CV_SUBROTMJ           0xfe00707f
#define MASK_CV_SUBROTMJ_DIV2      0xfe00707f
#define MASK_CV_SUBROTMJ_DIV4      0xfe00707f
#define MASK_CV_SUBROTMJ_DIV8      0xfe00707f
#define MASK_CV_ADD_DIV2           0xfe00707f
#define MASK_CV_ADD_DIV4           0xfe00707f
#define MASK_CV_ADD_DIV8           0xfe00707f
#define MASK_CV_SUB_DIV2           0xfe00707f
#define MASK_CV_SUB_DIV4           0xfe00707f
#define MASK_CV_SUB_DIV8           0xfe00707f
/* Vendor-specific (T-Head) XTheadBa instructions.  */
#define MATCH_TH_ADDSL 0x0000100b
#define MASK_TH_ADDSL 0xf800707f
/* Vendor-specific (T-Head) XTheadBb instructions.  */
#define MATCH_TH_SRRI 0x1000100b
#define MASK_TH_SRRI 0xfc00707f
#define MATCH_TH_SRRIW 0x1400100b
#define MASK_TH_SRRIW 0xfe00707f
#define MATCH_TH_EXT 0x0000200b
#define MASK_TH_EXT 0x0000707f
#define MATCH_TH_EXTU 0x0000300b
#define MASK_TH_EXTU 0x0000707f
#define MATCH_TH_FF0 0x8400100b
#define MASK_TH_FF0 0xfff0707f
#define MATCH_TH_FF1 0x8600100b
#define MASK_TH_FF1 0xfff0707f
#define MATCH_TH_REV 0x8200100b
#define MASK_TH_REV 0xfff0707f
#define MATCH_TH_REVW 0x9000100b
#define MASK_TH_REVW 0xfff0707f
#define MATCH_TH_TSTNBZ 0x8000100b
#define MASK_TH_TSTNBZ 0xfff0707f
/* Vendor-specific (T-Head) XTheadBs instructions.  */
#define MATCH_TH_TST 0x8800100b
#define MASK_TH_TST 0xfc00707f
/* Vendor-specific (T-Head) XTheadCmo instructions.  */
#define MATCH_TH_DCACHE_CALL 0x0010000b
#define MASK_TH_DCACHE_CALL 0xffffffff
#define MATCH_TH_DCACHE_CIALL 0x0030000b
#define MASK_TH_DCACHE_CIALL 0xffffffff
#define MATCH_TH_DCACHE_IALL 0x0020000b
#define MASK_TH_DCACHE_IALL 0xffffffff
#define MATCH_TH_DCACHE_CPA 0x0290000b
#define MASK_TH_DCACHE_CPA 0xfff07fff
#define MATCH_TH_DCACHE_CIPA 0x02b0000b
#define MASK_TH_DCACHE_CIPA 0xfff07fff
#define MATCH_TH_DCACHE_IPA 0x02a0000b
#define MASK_TH_DCACHE_IPA 0xfff07fff
#define MATCH_TH_DCACHE_CVA 0x0250000b
#define MASK_TH_DCACHE_CVA 0xfff07fff
#define MATCH_TH_DCACHE_CIVA 0x0270000b
#define MASK_TH_DCACHE_CIVA 0xfff07fff
#define MATCH_TH_DCACHE_IVA 0x0260000b
#define MASK_TH_DCACHE_IVA 0xfff07fff
#define MATCH_TH_DCACHE_CSW 0x0210000b
#define MASK_TH_DCACHE_CSW 0xfff07fff
#define MATCH_TH_DCACHE_CISW 0x0230000b
#define MASK_TH_DCACHE_CISW 0xfff07fff
#define MATCH_TH_DCACHE_ISW 0x0220000b
#define MASK_TH_DCACHE_ISW 0xfff07fff
#define MATCH_TH_DCACHE_CPAL1 0x0280000b
#define MASK_TH_DCACHE_CPAL1 0xfff07fff
#define MATCH_TH_DCACHE_CVAL1 0x0240000b
#define MASK_TH_DCACHE_CVAL1 0xfff07fff
#define MATCH_TH_ICACHE_IALL 0x0100000b
#define MASK_TH_ICACHE_IALL 0xffffffff
#define MATCH_TH_ICACHE_IALLS 0x0110000b
#define MASK_TH_ICACHE_IALLS 0xffffffff
#define MATCH_TH_ICACHE_IPA 0x0380000b
#define MASK_TH_ICACHE_IPA 0xfff07fff
#define MATCH_TH_ICACHE_IVA 0x0300000b
#define MASK_TH_ICACHE_IVA 0xfff07fff
#define MATCH_TH_L2CACHE_CALL 0x0150000b
#define MASK_TH_L2CACHE_CALL 0xffffffff
#define MATCH_TH_L2CACHE_CIALL 0x0170000b
#define MASK_TH_L2CACHE_CIALL 0xffffffff
#define MATCH_TH_L2CACHE_IALL 0x0160000b
#define MASK_TH_L2CACHE_IALL 0xffffffff
/* Vendor-specific (T-Head) XTheadCondMov instructions.  */
#define MATCH_TH_MVEQZ 0x4000100b
#define MASK_TH_MVEQZ 0xfe00707f
#define MATCH_TH_MVNEZ 0x4200100b
#define MASK_TH_MVNEZ 0xfe00707f
/* Vendor-specific (T-Head) XTheadFMemIdx instructions. */
#define MATCH_TH_FLRD 0x6000600b
#define MASK_TH_FLRD 0xf800707f
#define MATCH_TH_FLRW 0x4000600b
#define MASK_TH_FLRW 0xf800707f
#define MATCH_TH_FLURD 0x7000600b
#define MASK_TH_FLURD 0xf800707f
#define MATCH_TH_FLURW 0x5000600b
#define MASK_TH_FLURW 0xf800707f
#define MATCH_TH_FSRD 0x6000700b
#define MASK_TH_FSRD 0xf800707f
#define MATCH_TH_FSRW 0x4000700b
#define MASK_TH_FSRW 0xf800707f
#define MATCH_TH_FSURD 0x7000700b
#define MASK_TH_FSURD 0xf800707f
#define MATCH_TH_FSURW 0x5000700b
#define MASK_TH_FSURW 0xf800707f
/* Vendor-specific (T-Head) XTheadFmv instructions. */
#define MATCH_TH_FMV_X_HW 0xc000100b
#define MASK_TH_FMV_X_HW  0xfff0707f
#define MATCH_TH_FMV_HW_X 0xa000100b
#define MASK_TH_FMV_HW_X  0xfff0707f
/* Vendor-specific (T-Head) XTheadInt instructions. */
#define MATCH_TH_IPOP 0x0050000b
#define MASK_TH_IPOP 0xffffffff
#define MATCH_TH_IPUSH 0x0040000b
#define MASK_TH_IPUSH 0xffffffff
/* Vendor-specific (T-Head) XTheadMac instructions.  */
#define MATCH_TH_MULA 0x2000100b
#define MASK_TH_MULA 0xfe00707f
#define MATCH_TH_MULAH 0x2800100b
#define MASK_TH_MULAH 0xfe00707f
#define MATCH_TH_MULAW 0x2400100b
#define MASK_TH_MULAW 0xfe00707f
#define MATCH_TH_MULS 0x2200100b
#define MASK_TH_MULS 0xfe00707f
#define MATCH_TH_MULSH 0x2a00100b
#define MASK_TH_MULSH 0xfe00707f
#define MATCH_TH_MULSW 0x2600100b
#define MASK_TH_MULSW 0xfe00707f
/* Vendor-specific (T-Head) XTheadMemPair instructions. */
#define MATCH_TH_LDD 0xf800400b
#define MASK_TH_LDD 0xf800707f
#define MATCH_TH_LWD 0xe000400b
#define MASK_TH_LWD 0xf800707f
#define MATCH_TH_LWUD 0xf000400b
#define MASK_TH_LWUD 0xf800707f
#define MATCH_TH_SDD 0xf800500b
#define MASK_TH_SDD 0xf800707f
#define MATCH_TH_SWD 0xe000500b
#define MASK_TH_SWD 0xf800707f
/* Vendor-specific (T-Head) XTheadMemIdx instructions. */
#define MATCH_TH_LDIA 0x7800400b
#define MASK_TH_LDIA 0xf800707f
#define MATCH_TH_LDIB 0x6800400b
#define MASK_TH_LDIB 0xf800707f
#define MATCH_TH_LWIA 0x5800400b
#define MASK_TH_LWIA 0xf800707f
#define MATCH_TH_LWIB 0x4800400b
#define MASK_TH_LWIB 0xf800707f
#define MATCH_TH_LWUIA 0xd800400b
#define MASK_TH_LWUIA 0xf800707f
#define MATCH_TH_LWUIB 0xc800400b
#define MASK_TH_LWUIB 0xf800707f
#define MATCH_TH_LHIA 0x3800400b
#define MASK_TH_LHIA 0xf800707f
#define MATCH_TH_LHIB 0x2800400b
#define MASK_TH_LHIB 0xf800707f
#define MATCH_TH_LHUIA 0xb800400b
#define MASK_TH_LHUIA 0xf800707f
#define MATCH_TH_LHUIB 0xa800400b
#define MASK_TH_LHUIB 0xf800707f
#define MATCH_TH_LBIA 0x1800400b
#define MASK_TH_LBIA 0xf800707f
#define MATCH_TH_LBIB 0x0800400b
#define MASK_TH_LBIB 0xf800707f
#define MATCH_TH_LBUIA 0x9800400b
#define MASK_TH_LBUIA 0xf800707f
#define MATCH_TH_LBUIB 0x8800400b
#define MASK_TH_LBUIB 0xf800707f
#define MATCH_TH_SDIA 0x7800500b
#define MASK_TH_SDIA 0xf800707f
#define MATCH_TH_SDIB 0x6800500b
#define MASK_TH_SDIB 0xf800707f
#define MATCH_TH_SWIA 0x5800500b
#define MASK_TH_SWIA 0xf800707f
#define MATCH_TH_SWIB 0x4800500b
#define MASK_TH_SWIB 0xf800707f
#define MATCH_TH_SHIA 0x3800500b
#define MASK_TH_SHIA 0xf800707f
#define MATCH_TH_SHIB 0x2800500b
#define MASK_TH_SHIB 0xf800707f
#define MATCH_TH_SBIA 0x1800500b
#define MASK_TH_SBIA 0xf800707f
#define MATCH_TH_SBIB 0x0800500b
#define MASK_TH_SBIB 0xf800707f
#define MATCH_TH_LRD 0x6000400b
#define MASK_TH_LRD 0xf800707f
#define MATCH_TH_LRW 0x4000400b
#define MASK_TH_LRW 0xf800707f
#define MATCH_TH_LRWU 0xc000400b
#define MASK_TH_LRWU 0xf800707f
#define MATCH_TH_LRH 0x2000400b
#define MASK_TH_LRH 0xf800707f
#define MATCH_TH_LRHU 0xa000400b
#define MASK_TH_LRHU 0xf800707f
#define MATCH_TH_LRB 0x0000400b
#define MASK_TH_LRB 0xf800707f
#define MATCH_TH_LRBU 0x8000400b
#define MASK_TH_LRBU 0xf800707f
#define MATCH_TH_SRD 0x6000500b
#define MASK_TH_SRD 0xf800707f
#define MATCH_TH_SRW 0x4000500b
#define MASK_TH_SRW 0xf800707f
#define MATCH_TH_SRH 0x2000500b
#define MASK_TH_SRH 0xf800707f
#define MATCH_TH_SRB 0x0000500b
#define MASK_TH_SRB 0xf800707f
#define MATCH_TH_LURD 0x7000400b
#define MASK_TH_LURD 0xf800707f
#define MATCH_TH_LURW 0x5000400b
#define MASK_TH_LURW 0xf800707f
#define MATCH_TH_LURWU 0xd000400b
#define MASK_TH_LURWU 0xf800707f
#define MATCH_TH_LURH 0x3000400b
#define MASK_TH_LURH 0xf800707f
#define MATCH_TH_LURHU 0xb000400b
#define MASK_TH_LURHU 0xf800707f
#define MATCH_TH_LURB 0x1000400b
#define MASK_TH_LURB 0xf800707f
#define MATCH_TH_LURBU 0x9000400b
#define MASK_TH_LURBU 0xf800707f
#define MATCH_TH_SURD 0x7000500b
#define MASK_TH_SURD 0xf800707f
#define MATCH_TH_SURW 0x5000500b
#define MASK_TH_SURW 0xf800707f
#define MATCH_TH_SURH 0x3000500b
#define MASK_TH_SURH 0xf800707f
#define MATCH_TH_SURB 0x1000500b
#define MASK_TH_SURB 0xf800707f
/* Vendor-specific (T-Head) XTheadSync instructions.  */
#define MATCH_TH_SFENCE_VMAS 0x0400000b
#define MASK_TH_SFENCE_VMAS 0xfe007fff
#define MATCH_TH_SYNC 0x0180000b
#define MASK_TH_SYNC 0xffffffff
#define MATCH_TH_SYNC_I 0x01a0000b
#define MASK_TH_SYNC_I 0xffffffff
#define MATCH_TH_SYNC_IS 0x01b0000b
#define MASK_TH_SYNC_IS 0xffffffff
#define MATCH_TH_SYNC_S 0x0190000b
#define MASK_TH_SYNC_S 0xffffffff
/* Vendor-specific (T-Head) XTheadVector instructions.  */
#define MATCH_TH_VLBV  0x10000007
#define MASK_TH_VLBV   0xfdf0707f
#define MATCH_TH_VLHV  0x10005007
#define MASK_TH_VLHV   0xfdf0707f
#define MATCH_TH_VLWV  0x10006007
#define MASK_TH_VLWV   0xfdf0707f
#define MATCH_TH_VLSBV    0x18000007
#define MASK_TH_VLSBV     0xfc00707f
#define MATCH_TH_VLSHV    0x18005007
#define MASK_TH_VLSHV     0xfc00707f
#define MATCH_TH_VLSWV    0x18006007
#define MASK_TH_VLSWV     0xfc00707f
#define MATCH_TH_VLXBV    0x1c000007
#define MASK_TH_VLXBV     0xfc00707f
#define MATCH_TH_VLXHV    0x1c005007
#define MASK_TH_VLXHV     0xfc00707f
#define MATCH_TH_VLXWV    0x1c006007
#define MASK_TH_VLXWV     0xfc00707f
#define MATCH_TH_VSUXBV   0x1c000027
#define MASK_TH_VSUXBV    0xfc00707f
#define MATCH_TH_VSUXHV   0x1c005027
#define MASK_TH_VSUXHV    0xfc00707f
#define MATCH_TH_VSUXWV   0x1c006027
#define MASK_TH_VSUXWV    0xfc00707f
#define MATCH_TH_VSUXEV   0x1c007027
#define MASK_TH_VSUXEV    0xfc00707f
#define MATCH_TH_VLBFFV  0x11000007
#define MASK_TH_VLBFFV   0xfdf0707f
#define MATCH_TH_VLHFFV  0x11005007
#define MASK_TH_VLHFFV   0xfdf0707f
#define MATCH_TH_VLWFFV  0x11006007
#define MASK_TH_VLWFFV   0xfdf0707f
#define MATCH_TH_VLSEG2BV 0x30000007
#define MASK_TH_VLSEG2BV 0xfdf0707f
#define MATCH_TH_VLSEG2HV 0x30005007
#define MASK_TH_VLSEG2HV 0xfdf0707f
#define MATCH_TH_VLSEG2WV 0x30006007
#define MASK_TH_VLSEG2WV 0xfdf0707f
#define MATCH_TH_VLSEG3BV 0x50000007
#define MASK_TH_VLSEG3BV 0xfdf0707f
#define MATCH_TH_VLSEG3HV 0x50005007
#define MASK_TH_VLSEG3HV 0xfdf0707f
#define MATCH_TH_VLSEG3WV 0x50006007
#define MASK_TH_VLSEG3WV 0xfdf0707f
#define MATCH_TH_VLSEG4BV 0x70000007
#define MASK_TH_VLSEG4BV 0xfdf0707f
#define MATCH_TH_VLSEG4HV 0x70005007
#define MASK_TH_VLSEG4HV 0xfdf0707f
#define MATCH_TH_VLSEG4WV 0x70006007
#define MASK_TH_VLSEG4WV 0xfdf0707f
#define MATCH_TH_VLSEG5BV 0x90000007
#define MASK_TH_VLSEG5BV 0xfdf0707f
#define MATCH_TH_VLSEG5HV 0x90005007
#define MASK_TH_VLSEG5HV 0xfdf0707f
#define MATCH_TH_VLSEG5WV 0x90006007
#define MASK_TH_VLSEG5WV 0xfdf0707f
#define MATCH_TH_VLSEG6BV 0xb0000007
#define MASK_TH_VLSEG6BV 0xfdf0707f
#define MATCH_TH_VLSEG6HV 0xb0005007
#define MASK_TH_VLSEG6HV 0xfdf0707f
#define MATCH_TH_VLSEG6WV 0xb0006007
#define MASK_TH_VLSEG6WV 0xfdf0707f
#define MATCH_TH_VLSEG7BV 0xd0000007
#define MASK_TH_VLSEG7BV 0xfdf0707f
#define MATCH_TH_VLSEG7HV 0xd0005007
#define MASK_TH_VLSEG7HV 0xfdf0707f
#define MATCH_TH_VLSEG7WV 0xd0006007
#define MASK_TH_VLSEG7WV 0xfdf0707f
#define MATCH_TH_VLSEG8BV 0xf0000007
#define MASK_TH_VLSEG8BV 0xfdf0707f
#define MATCH_TH_VLSEG8HV 0xf0005007
#define MASK_TH_VLSEG8HV 0xfdf0707f
#define MATCH_TH_VLSEG8WV 0xf0006007
#define MASK_TH_VLSEG8WV 0xfdf0707f
#define MATCH_TH_VLSSEG2BV 0x38000007
#define MASK_TH_VLSSEG2BV 0xfc00707f
#define MATCH_TH_VLSSEG2HV 0x38005007
#define MASK_TH_VLSSEG2HV 0xfc00707f
#define MATCH_TH_VLSSEG2WV 0x38006007
#define MASK_TH_VLSSEG2WV 0xfc00707f
#define MATCH_TH_VLSSEG3BV 0x58000007
#define MASK_TH_VLSSEG3BV 0xfc00707f
#define MATCH_TH_VLSSEG3HV 0x58005007
#define MASK_TH_VLSSEG3HV 0xfc00707f
#define MATCH_TH_VLSSEG3WV 0x58006007
#define MASK_TH_VLSSEG3WV 0xfc00707f
#define MATCH_TH_VLSSEG4BV 0x78000007
#define MASK_TH_VLSSEG4BV 0xfc00707f
#define MATCH_TH_VLSSEG4HV 0x78005007
#define MASK_TH_VLSSEG4HV 0xfc00707f
#define MATCH_TH_VLSSEG4WV 0x78006007
#define MASK_TH_VLSSEG4WV 0xfc00707f
#define MATCH_TH_VLSSEG5BV 0x98000007
#define MASK_TH_VLSSEG5BV 0xfc00707f
#define MATCH_TH_VLSSEG5HV 0x98005007
#define MASK_TH_VLSSEG5HV 0xfc00707f
#define MATCH_TH_VLSSEG5WV 0x98006007
#define MASK_TH_VLSSEG5WV 0xfc00707f
#define MATCH_TH_VLSSEG6BV 0xb8000007
#define MASK_TH_VLSSEG6BV 0xfc00707f
#define MATCH_TH_VLSSEG6HV 0xb8005007
#define MASK_TH_VLSSEG6HV 0xfc00707f
#define MATCH_TH_VLSSEG6WV 0xb8006007
#define MASK_TH_VLSSEG6WV 0xfc00707f
#define MATCH_TH_VLSSEG7BV 0xd8000007
#define MASK_TH_VLSSEG7BV 0xfc00707f
#define MATCH_TH_VLSSEG7HV 0xd8005007
#define MASK_TH_VLSSEG7HV 0xfc00707f
#define MATCH_TH_VLSSEG7WV 0xd8006007
#define MASK_TH_VLSSEG7WV 0xfc00707f
#define MATCH_TH_VLSSEG8BV 0xf8000007
#define MASK_TH_VLSSEG8BV 0xfc00707f
#define MATCH_TH_VLSSEG8HV 0xf8005007
#define MASK_TH_VLSSEG8HV 0xfc00707f
#define MATCH_TH_VLSSEG8WV 0xf8006007
#define MASK_TH_VLSSEG8WV 0xfc00707f
#define MATCH_TH_VLXSEG2BV 0x3c000007
#define MASK_TH_VLXSEG2BV 0xfc00707f
#define MATCH_TH_VLXSEG2HV 0x3c005007
#define MASK_TH_VLXSEG2HV 0xfc00707f
#define MATCH_TH_VLXSEG2WV 0x3c006007
#define MASK_TH_VLXSEG2WV 0xfc00707f
#define MATCH_TH_VLXSEG3BV 0x5c000007
#define MASK_TH_VLXSEG3BV 0xfc00707f
#define MATCH_TH_VLXSEG3HV 0x5c005007
#define MASK_TH_VLXSEG3HV 0xfc00707f
#define MATCH_TH_VLXSEG3WV 0x5c006007
#define MASK_TH_VLXSEG3WV 0xfc00707f
#define MATCH_TH_VLXSEG4BV 0x7c000007
#define MASK_TH_VLXSEG4BV 0xfc00707f
#define MATCH_TH_VLXSEG4HV 0x7c005007
#define MASK_TH_VLXSEG4HV 0xfc00707f
#define MATCH_TH_VLXSEG4WV 0x7c006007
#define MASK_TH_VLXSEG4WV 0xfc00707f
#define MATCH_TH_VLXSEG5BV 0x9c000007
#define MASK_TH_VLXSEG5BV 0xfc00707f
#define MATCH_TH_VLXSEG5HV 0x9c005007
#define MASK_TH_VLXSEG5HV 0xfc00707f
#define MATCH_TH_VLXSEG5WV 0x9c006007
#define MASK_TH_VLXSEG5WV 0xfc00707f
#define MATCH_TH_VLXSEG6BV 0xbc000007
#define MASK_TH_VLXSEG6BV 0xfc00707f
#define MATCH_TH_VLXSEG6HV 0xbc005007
#define MASK_TH_VLXSEG6HV 0xfc00707f
#define MATCH_TH_VLXSEG6WV 0xbc006007
#define MASK_TH_VLXSEG6WV 0xfc00707f
#define MATCH_TH_VLXSEG7BV 0xdc000007
#define MASK_TH_VLXSEG7BV 0xfc00707f
#define MATCH_TH_VLXSEG7HV 0xdc005007
#define MASK_TH_VLXSEG7HV 0xfc00707f
#define MATCH_TH_VLXSEG7WV 0xdc006007
#define MASK_TH_VLXSEG7WV 0xfc00707f
#define MATCH_TH_VLXSEG8BV 0xfc000007
#define MASK_TH_VLXSEG8BV 0xfc00707f
#define MATCH_TH_VLXSEG8HV 0xfc005007
#define MASK_TH_VLXSEG8HV 0xfc00707f
#define MATCH_TH_VLXSEG8WV 0xfc006007
#define MASK_TH_VLXSEG8WV 0xfc00707f
#define MATCH_TH_VLSEG2BFFV 0x31000007
#define MASK_TH_VLSEG2BFFV 0xfdf0707f
#define MATCH_TH_VLSEG2HFFV 0x31005007
#define MASK_TH_VLSEG2HFFV 0xfdf0707f
#define MATCH_TH_VLSEG2WFFV 0x31006007
#define MASK_TH_VLSEG2WFFV 0xfdf0707f
#define MATCH_TH_VLSEG3BFFV 0x51000007
#define MASK_TH_VLSEG3BFFV 0xfdf0707f
#define MATCH_TH_VLSEG3HFFV 0x51005007
#define MASK_TH_VLSEG3HFFV 0xfdf0707f
#define MATCH_TH_VLSEG3WFFV 0x51006007
#define MASK_TH_VLSEG3WFFV 0xfdf0707f
#define MATCH_TH_VLSEG4BFFV 0x71000007
#define MASK_TH_VLSEG4BFFV 0xfdf0707f
#define MATCH_TH_VLSEG4HFFV 0x71005007
#define MASK_TH_VLSEG4HFFV 0xfdf0707f
#define MATCH_TH_VLSEG4WFFV 0x71006007
#define MASK_TH_VLSEG4WFFV 0xfdf0707f
#define MATCH_TH_VLSEG5BFFV 0x91000007
#define MASK_TH_VLSEG5BFFV 0xfdf0707f
#define MATCH_TH_VLSEG5HFFV 0x91005007
#define MASK_TH_VLSEG5HFFV 0xfdf0707f
#define MATCH_TH_VLSEG5WFFV 0x91006007
#define MASK_TH_VLSEG5WFFV 0xfdf0707f
#define MATCH_TH_VLSEG6BFFV 0xb1000007
#define MASK_TH_VLSEG6BFFV 0xfdf0707f
#define MATCH_TH_VLSEG6HFFV 0xb1005007
#define MASK_TH_VLSEG6HFFV 0xfdf0707f
#define MATCH_TH_VLSEG6WFFV 0xb1006007
#define MASK_TH_VLSEG6WFFV 0xfdf0707f
#define MATCH_TH_VLSEG7BFFV 0xd1000007
#define MASK_TH_VLSEG7BFFV 0xfdf0707f
#define MATCH_TH_VLSEG7HFFV 0xd1005007
#define MASK_TH_VLSEG7HFFV 0xfdf0707f
#define MATCH_TH_VLSEG7WFFV 0xd1006007
#define MASK_TH_VLSEG7WFFV 0xfdf0707f
#define MATCH_TH_VLSEG8BFFV 0xf1000007
#define MASK_TH_VLSEG8BFFV 0xfdf0707f
#define MATCH_TH_VLSEG8HFFV 0xf1005007
#define MASK_TH_VLSEG8HFFV 0xfdf0707f
#define MATCH_TH_VLSEG8WFFV 0xf1006007
#define MASK_TH_VLSEG8WFFV 0xfdf0707f
#define MATCH_TH_VAMOADDWV 0x0000602f
#define MASK_TH_VAMOADDWV 0xf800707f
#define MATCH_TH_VAMOADDDV 0x0000702f
#define MASK_TH_VAMOADDDV 0xf800707f
#define MATCH_TH_VAMOSWAPWV 0x0800602f
#define MASK_TH_VAMOSWAPWV 0xf800707f
#define MATCH_TH_VAMOSWAPDV 0x0800702f
#define MASK_TH_VAMOSWAPDV 0xf800707f
#define MATCH_TH_VAMOXORWV 0x2000602f
#define MASK_TH_VAMOXORWV 0xf800707f
#define MATCH_TH_VAMOXORDV 0x2000702f
#define MASK_TH_VAMOXORDV 0xf800707f
#define MATCH_TH_VAMOANDWV 0x6000602f
#define MASK_TH_VAMOANDWV 0xf800707f
#define MATCH_TH_VAMOANDDV 0x6000702f
#define MASK_TH_VAMOANDDV 0xf800707f
#define MATCH_TH_VAMOORWV 0x4000602f
#define MASK_TH_VAMOORWV 0xf800707f
#define MATCH_TH_VAMOORDV 0x4000702f
#define MASK_TH_VAMOORDV 0xf800707f
#define MATCH_TH_VAMOMINWV 0x8000602f
#define MASK_TH_VAMOMINWV 0xf800707f
#define MATCH_TH_VAMOMINDV 0x8000702f
#define MASK_TH_VAMOMINDV 0xf800707f
#define MATCH_TH_VAMOMAXWV 0xa000602f
#define MASK_TH_VAMOMAXWV 0xf800707f
#define MATCH_TH_VAMOMAXDV 0xa000702f
#define MASK_TH_VAMOMAXDV 0xf800707f
#define MATCH_TH_VAMOMINUWV 0xc000602f
#define MASK_TH_VAMOMINUWV 0xf800707f
#define MATCH_TH_VAMOMINUDV 0xc000702f
#define MASK_TH_VAMOMINUDV 0xf800707f
#define MATCH_TH_VAMOMAXUWV 0xe000602f
#define MASK_TH_VAMOMAXUWV 0xf800707f
#define MATCH_TH_VAMOMAXUDV 0xe000702f
#define MASK_TH_VAMOMAXUDV 0xf800707f
#define MATCH_TH_VADCVVM 0x42000057
#define MASK_TH_VADCVVM 0xfe00707f
#define MATCH_TH_VADCVXM 0x42004057
#define MASK_TH_VADCVXM 0xfe00707f
#define MATCH_TH_VADCVIM 0x42003057
#define MASK_TH_VADCVIM 0xfe00707f
#define MATCH_TH_VSBCVVM 0x4a000057
#define MASK_TH_VSBCVVM 0xfe00707f
#define MATCH_TH_VSBCVXM 0x4a004057
#define MASK_TH_VSBCVXM 0xfe00707f
#define MATCH_TH_VWMACCSUVV 0xf8002057
#define MASK_TH_VWMACCSUVV 0xfc00707f
#define MATCH_TH_VAADDVV 0x90000057
#define MASK_TH_VAADDVV 0xfc00707f
#define MATCH_TH_VAADDVX 0x90004057
#define MASK_TH_VAADDVX 0xfc00707f
#define MATCH_TH_VAADDVI 0x90003057
#define MASK_TH_VAADDVI 0xfc00707f
#define MATCH_TH_VASUBVV 0x98000057
#define MASK_TH_VASUBVV 0xfc00707f
#define MATCH_TH_VASUBVX 0x98004057
#define MASK_TH_VASUBVX 0xfc00707f
#define MATCH_TH_VWSMACCSUVV 0xf8000057
#define MASK_TH_VWSMACCSUVV 0xfc00707f
#define MATCH_TH_VFSQRTV 0x8c001057
#define MASK_TH_VFSQRTV 0xfc0ff07f
#define MATCH_TH_VMFORDVV 0x68001057
#define MASK_TH_VMFORDVV 0xfc00707f
#define MATCH_TH_VMFORDVF 0x68005057
#define MASK_TH_VMFORDVF 0xfc00707f
#define MATCH_TH_VFCLASSV 0x8c081057
#define MASK_TH_VFCLASSV 0xfc0ff07f
#define MATCH_TH_VFCVTXUFV 0x88001057
#define MASK_TH_VFCVTXUFV 0xfc0ff07f
#define MATCH_TH_VFCVTXFV 0x88009057
#define MASK_TH_VFCVTXFV 0xfc0ff07f
#define MATCH_TH_VFCVTFXUV 0x88011057
#define MASK_TH_VFCVTFXUV 0xfc0ff07f
#define MATCH_TH_VFCVTFXV 0x88019057
#define MASK_TH_VFCVTFXV 0xfc0ff07f
#define MATCH_TH_VFWCVTXUFV 0x88041057
#define MASK_TH_VFWCVTXUFV 0xfc0ff07f
#define MATCH_TH_VFWCVTXFV 0x88049057
#define MASK_TH_VFWCVTXFV 0xfc0ff07f
#define MATCH_TH_VFWCVTFXUV 0x88051057
#define MASK_TH_VFWCVTFXUV 0xfc0ff07f
#define MATCH_TH_VFWCVTFXV 0x88059057
#define MASK_TH_VFWCVTFXV 0xfc0ff07f
#define MATCH_TH_VFWCVTFFV 0x88061057
#define MASK_TH_VFWCVTFFV 0xfc0ff07f
#define MATCH_TH_VFNCVTXUFV 0x88081057
#define MASK_TH_VFNCVTXUFV 0xfc0ff07f
#define MATCH_TH_VFNCVTXFV 0x88089057
#define MASK_TH_VFNCVTXFV 0xfc0ff07f
#define MATCH_TH_VFNCVTFXUV 0x88091057
#define MASK_TH_VFNCVTFXUV 0xfc0ff07f
#define MATCH_TH_VFNCVTFXV 0x88099057
#define MASK_TH_VFNCVTFXV 0xfc0ff07f
#define MATCH_TH_VFNCVTFFV 0x880a1057
#define MASK_TH_VFNCVTFFV 0xfc0ff07f
#define MATCH_TH_VMPOPCM 0x50002057
#define MASK_TH_VMPOPCM 0xfc0ff07f
#define MATCH_TH_VMFIRSTM 0x54002057
#define MASK_TH_VMFIRSTM 0xfc0ff07f
#define MATCH_TH_VMSBFM 0x5800a057
#define MASK_TH_VMSBFM 0xfc0ff07f
#define MATCH_TH_VMSIFM 0x5801a057
#define MASK_TH_VMSIFM 0xfc0ff07f
#define MATCH_TH_VMSOFM 0x58012057
#define MASK_TH_VMSOFM 0xfc0ff07f
#define MATCH_TH_VIOTAM 0x58082057
#define MASK_TH_VIOTAM 0xfc0ff07f
#define MATCH_TH_VIDV 0x5808a057
#define MASK_TH_VIDV 0xfdfff07f
#define MATCH_TH_VMVXS 0x32002057
#define MASK_TH_VMVXS 0xfe0ff07f
#define MATCH_TH_VEXTXV 0x32002057
#define MASK_TH_VEXTXV 0xfe00707f
#define MATCH_TH_VMVSX 0x36006057
#define MASK_TH_VMVSX 0xfff0707f
#define MATCH_TH_VFMVFS 0x32001057
#define MASK_TH_VFMVFS 0xfe0ff07f
#define MATCH_TH_VFMVSF 0x36005057
#define MASK_TH_VFMVSF 0xfff0707f
/* Vendor-specific (Ventana Microsystems) XVentanaCondOps instructions */
#define MATCH_VT_MASKC 0x607b
#define MASK_VT_MASKC 0xfe00707f
#define MATCH_VT_MASKCN 0x707b
#define MASK_VT_MASKCN 0xfe00707f
/* Vendor-specific (SiFive) vector coprocessor interface instructions.  */
#define MATCH_SF_VC_X 0x0200405b
#define MASK_SF_VC_X 0xf200707f
#define MATCH_SF_VC_V_X 0x0000405b
#define MASK_SF_VC_V_X 0xf200707f
#define MATCH_SF_VC_I 0x0200305b
#define MASK_SF_VC_I 0xf200707f
#define MATCH_SF_VC_V_I 0x0000305b
#define MASK_SF_VC_V_I 0xf200707f
#define MATCH_SF_VC_VV 0x2200005b
#define MASK_SF_VC_VV 0xf200707f
#define MATCH_SF_VC_V_VV 0x2000005b
#define MASK_SF_VC_V_VV 0xf200707f
#define MATCH_SF_VC_XV 0x2200405b
#define MASK_SF_VC_XV 0xf200707f
#define MATCH_SF_VC_V_XV 0x2000405b
#define MASK_SF_VC_V_XV 0xf200707f
#define MATCH_SF_VC_IV 0x2200305b
#define MASK_SF_VC_IV 0xf200707f
#define MATCH_SF_VC_V_IV 0x2000305b
#define MASK_SF_VC_V_IV 0xf200707f
#define MATCH_SF_VC_FV 0x2a00505b
#define MASK_SF_VC_FV 0xfa00707f
#define MATCH_SF_VC_V_FV 0x2800505b
#define MASK_SF_VC_V_FV 0xfa00707f
#define MATCH_SF_VC_VVV 0xa200005b
#define MASK_SF_VC_VVV 0xf200707f
#define MATCH_SF_VC_V_VVV 0xa000005b
#define MASK_SF_VC_V_VVV 0xf200707f
#define MATCH_SF_VC_XVV 0xa200405b
#define MASK_SF_VC_XVV 0xf200707f
#define MATCH_SF_VC_V_XVV 0xa000405b
#define MASK_SF_VC_V_XVV 0xf200707f
#define MATCH_SF_VC_IVV 0xa200305b
#define MASK_SF_VC_IVV 0xf200707f
#define MATCH_SF_VC_V_IVV 0xa000305b
#define MASK_SF_VC_V_IVV 0xf200707f
#define MATCH_SF_VC_FVV 0xaa00505b
#define MASK_SF_VC_FVV 0xfa00707f
#define MATCH_SF_VC_V_FVV 0xa800505b
#define MASK_SF_VC_V_FVV 0xfa00707f
#define MATCH_SF_VC_VVW 0xf200005b
#define MASK_SF_VC_VVW 0xf200707f
#define MATCH_SF_VC_V_VVW 0xf000005b
#define MASK_SF_VC_V_VVW 0xf200707f
#define MATCH_SF_VC_XVW 0xf200405b
#define MASK_SF_VC_XVW 0xf200707f
#define MATCH_SF_VC_V_XVW 0xf000405b
#define MASK_SF_VC_V_XVW 0xf200707f
#define MATCH_SF_VC_IVW 0xf200305b
#define MASK_SF_VC_IVW 0xf200707f
#define MATCH_SF_VC_V_IVW 0xf000305b
#define MASK_SF_VC_V_IVW 0xf200707f
#define MATCH_SF_VC_FVW 0xfa00505b
#define MASK_SF_VC_FVW 0xfa00707f
#define MATCH_SF_VC_V_FVW 0xf800505b
#define MASK_SF_VC_V_FVW 0xfa00707f
/* Vendor-specific (SiFive) cease instruction.  */
#define MATCH_SF_CEASE 0x30500073
#define MASK_SF_CEASE 0xffffffff
/* SiFive custom int8 matrix-multiply instruction.  */
#define MATCH_SFVQMACCU4X8X4 0xf200205b
#define MASK_SFVQMACCU4X8X4 0xfe00707f
#define MATCH_SFVQMACC4X8X4 0xf600205b
#define MASK_SFVQMACC4X8X4 0xfe00707f
#define MATCH_SFVQMACCUS4X8X4 0xfa00205b
#define MASK_SFVQMACCUS4X8X4 0xfe00707f
#define MATCH_SFVQMACCSU4X8X4 0xfe00205b
#define MASK_SFVQMACCSU4X8X4 0xfe00707f
#define MATCH_SFVQMACCU2X8X2 0xb200205b
#define MASK_SFVQMACCU2X8X2 0xfe00707f
#define MATCH_SFVQMACC2X8X2 0xb600205b
#define MASK_SFVQMACC2X8X2 0xfe00707f
#define MATCH_SFVQMACCUS2X8X2 0xba00205b
#define MASK_SFVQMACCUS2X8X2 0xfe00707f
#define MATCH_SFVQMACCSU2X8X2 0xbe00205b
#define MASK_SFVQMACCSU2X8X2 0xfe00707f
/* FP32-to-int8 Ranged Clip Instructions (Xsfvfnrclipxfqf).  */
#define MATCH_SFVFNRCLIPXUFQF 0x8a00505b
#define MASK_SFVFNRCLIPXUFQF 0xfe00707f
#define MATCH_SFVFNRCLIPXFQF 0x8e00505b
#define MASK_SFVFNRCLIPXFQF 0xfe00707f
/* Unprivileged Counter/Timers CSR addresses.  */
#define CSR_CYCLE 0xc00
#define CSR_TIME 0xc01
#define CSR_INSTRET 0xc02
#define CSR_HPMCOUNTER3 0xc03
#define CSR_HPMCOUNTER4 0xc04
#define CSR_HPMCOUNTER5 0xc05
#define CSR_HPMCOUNTER6 0xc06
#define CSR_HPMCOUNTER7 0xc07
#define CSR_HPMCOUNTER8 0xc08
#define CSR_HPMCOUNTER9 0xc09
#define CSR_HPMCOUNTER10 0xc0a
#define CSR_HPMCOUNTER11 0xc0b
#define CSR_HPMCOUNTER12 0xc0c
#define CSR_HPMCOUNTER13 0xc0d
#define CSR_HPMCOUNTER14 0xc0e
#define CSR_HPMCOUNTER15 0xc0f
#define CSR_HPMCOUNTER16 0xc10
#define CSR_HPMCOUNTER17 0xc11
#define CSR_HPMCOUNTER18 0xc12
#define CSR_HPMCOUNTER19 0xc13
#define CSR_HPMCOUNTER20 0xc14
#define CSR_HPMCOUNTER21 0xc15
#define CSR_HPMCOUNTER22 0xc16
#define CSR_HPMCOUNTER23 0xc17
#define CSR_HPMCOUNTER24 0xc18
#define CSR_HPMCOUNTER25 0xc19
#define CSR_HPMCOUNTER26 0xc1a
#define CSR_HPMCOUNTER27 0xc1b
#define CSR_HPMCOUNTER28 0xc1c
#define CSR_HPMCOUNTER29 0xc1d
#define CSR_HPMCOUNTER30 0xc1e
#define CSR_HPMCOUNTER31 0xc1f
#define CSR_CYCLEH 0xc80
#define CSR_TIMEH 0xc81
#define CSR_INSTRETH 0xc82
#define CSR_HPMCOUNTER3H 0xc83
#define CSR_HPMCOUNTER4H 0xc84
#define CSR_HPMCOUNTER5H 0xc85
#define CSR_HPMCOUNTER6H 0xc86
#define CSR_HPMCOUNTER7H 0xc87
#define CSR_HPMCOUNTER8H 0xc88
#define CSR_HPMCOUNTER9H 0xc89
#define CSR_HPMCOUNTER10H 0xc8a
#define CSR_HPMCOUNTER11H 0xc8b
#define CSR_HPMCOUNTER12H 0xc8c
#define CSR_HPMCOUNTER13H 0xc8d
#define CSR_HPMCOUNTER14H 0xc8e
#define CSR_HPMCOUNTER15H 0xc8f
#define CSR_HPMCOUNTER16H 0xc90
#define CSR_HPMCOUNTER17H 0xc91
#define CSR_HPMCOUNTER18H 0xc92
#define CSR_HPMCOUNTER19H 0xc93
#define CSR_HPMCOUNTER20H 0xc94
#define CSR_HPMCOUNTER21H 0xc95
#define CSR_HPMCOUNTER22H 0xc96
#define CSR_HPMCOUNTER23H 0xc97
#define CSR_HPMCOUNTER24H 0xc98
#define CSR_HPMCOUNTER25H 0xc99
#define CSR_HPMCOUNTER26H 0xc9a
#define CSR_HPMCOUNTER27H 0xc9b
#define CSR_HPMCOUNTER28H 0xc9c
#define CSR_HPMCOUNTER29H 0xc9d
#define CSR_HPMCOUNTER30H 0xc9e
#define CSR_HPMCOUNTER31H 0xc9f
/* Privileged Supervisor CSR addresses.  */
#define CSR_SSTATUS 0x100
#define CSR_SIE 0x104
#define CSR_STVEC 0x105
#define CSR_SCOUNTEREN 0x106
#define CSR_SENVCFG 0x10a
#define CSR_SSCRATCH 0x140
#define CSR_SEPC 0x141
#define CSR_SCAUSE 0x142
#define CSR_STVAL 0x143
#define CSR_SIP 0x144
#define CSR_SATP 0x180
/* Privileged Machine CSR addresses. */
#define CSR_MVENDORID 0xf11
#define CSR_MARCHID 0xf12
#define CSR_MIMPID 0xf13
#define CSR_MHARTID 0xf14
#define CSR_MCONFIGPTR 0xf15
#define CSR_MSTATUS 0x300
#define CSR_MISA 0x301
#define CSR_MEDELEG 0x302
#define CSR_MIDELEG 0x303
#define CSR_MIE 0x304
#define CSR_MTVEC 0x305
#define CSR_MCOUNTEREN 0x306
#define CSR_MSTATUSH 0x310
#define CSR_MSCRATCH 0x340
#define CSR_MEPC 0x341
#define CSR_MCAUSE 0x342
#define CSR_MTVAL 0x343
#define CSR_MIP 0x344
#define CSR_MTINST 0x34a
#define CSR_MTVAL2 0x34b
#define CSR_MENVCFG 0x30a
#define CSR_MENVCFGH 0x31a
#define CSR_MSECCFG 0x747
#define CSR_MSECCFGH 0x757
#define CSR_PMPCFG0 0x3a0
#define CSR_PMPCFG1 0x3a1
#define CSR_PMPCFG2 0x3a2
#define CSR_PMPCFG3 0x3a3
#define CSR_PMPCFG4 0x3a4
#define CSR_PMPCFG5 0x3a5
#define CSR_PMPCFG6 0x3a6
#define CSR_PMPCFG7 0x3a7
#define CSR_PMPCFG8 0x3a8
#define CSR_PMPCFG9 0x3a9
#define CSR_PMPCFG10 0x3aa
#define CSR_PMPCFG11 0x3ab
#define CSR_PMPCFG12 0x3ac
#define CSR_PMPCFG13 0x3ad
#define CSR_PMPCFG14 0x3ae
#define CSR_PMPCFG15 0x3af
#define CSR_PMPADDR0 0x3b0
#define CSR_PMPADDR1 0x3b1
#define CSR_PMPADDR2 0x3b2
#define CSR_PMPADDR3 0x3b3
#define CSR_PMPADDR4 0x3b4
#define CSR_PMPADDR5 0x3b5
#define CSR_PMPADDR6 0x3b6
#define CSR_PMPADDR7 0x3b7
#define CSR_PMPADDR8 0x3b8
#define CSR_PMPADDR9 0x3b9
#define CSR_PMPADDR10 0x3ba
#define CSR_PMPADDR11 0x3bb
#define CSR_PMPADDR12 0x3bc
#define CSR_PMPADDR13 0x3bd
#define CSR_PMPADDR14 0x3be
#define CSR_PMPADDR15 0x3bf
#define CSR_PMPADDR16 0x3c0
#define CSR_PMPADDR17 0x3c1
#define CSR_PMPADDR18 0x3c2
#define CSR_PMPADDR19 0x3c3
#define CSR_PMPADDR20 0x3c4
#define CSR_PMPADDR21 0x3c5
#define CSR_PMPADDR22 0x3c6
#define CSR_PMPADDR23 0x3c7
#define CSR_PMPADDR24 0x3c8
#define CSR_PMPADDR25 0x3c9
#define CSR_PMPADDR26 0x3ca
#define CSR_PMPADDR27 0x3cb
#define CSR_PMPADDR28 0x3cc
#define CSR_PMPADDR29 0x3cd
#define CSR_PMPADDR30 0x3ce
#define CSR_PMPADDR31 0x3cf
#define CSR_PMPADDR32 0x3d0
#define CSR_PMPADDR33 0x3d1
#define CSR_PMPADDR34 0x3d2
#define CSR_PMPADDR35 0x3d3
#define CSR_PMPADDR36 0x3d4
#define CSR_PMPADDR37 0x3d5
#define CSR_PMPADDR38 0x3d6
#define CSR_PMPADDR39 0x3d7
#define CSR_PMPADDR40 0x3d8
#define CSR_PMPADDR41 0x3d9
#define CSR_PMPADDR42 0x3da
#define CSR_PMPADDR43 0x3db
#define CSR_PMPADDR44 0x3dc
#define CSR_PMPADDR45 0x3dd
#define CSR_PMPADDR46 0x3de
#define CSR_PMPADDR47 0x3df
#define CSR_PMPADDR48 0x3e0
#define CSR_PMPADDR49 0x3e1
#define CSR_PMPADDR50 0x3e2
#define CSR_PMPADDR51 0x3e3
#define CSR_PMPADDR52 0x3e4
#define CSR_PMPADDR53 0x3e5
#define CSR_PMPADDR54 0x3e6
#define CSR_PMPADDR55 0x3e7
#define CSR_PMPADDR56 0x3e8
#define CSR_PMPADDR57 0x3e9
#define CSR_PMPADDR58 0x3ea
#define CSR_PMPADDR59 0x3eb
#define CSR_PMPADDR60 0x3ec
#define CSR_PMPADDR61 0x3ed
#define CSR_PMPADDR62 0x3ee
#define CSR_PMPADDR63 0x3ef
#define CSR_MCYCLE 0xb00
#define CSR_MINSTRET 0xb02
#define CSR_MHPMCOUNTER3 0xb03
#define CSR_MHPMCOUNTER4 0xb04
#define CSR_MHPMCOUNTER5 0xb05
#define CSR_MHPMCOUNTER6 0xb06
#define CSR_MHPMCOUNTER7 0xb07
#define CSR_MHPMCOUNTER8 0xb08
#define CSR_MHPMCOUNTER9 0xb09
#define CSR_MHPMCOUNTER10 0xb0a
#define CSR_MHPMCOUNTER11 0xb0b
#define CSR_MHPMCOUNTER12 0xb0c
#define CSR_MHPMCOUNTER13 0xb0d
#define CSR_MHPMCOUNTER14 0xb0e
#define CSR_MHPMCOUNTER15 0xb0f
#define CSR_MHPMCOUNTER16 0xb10
#define CSR_MHPMCOUNTER17 0xb11
#define CSR_MHPMCOUNTER18 0xb12
#define CSR_MHPMCOUNTER19 0xb13
#define CSR_MHPMCOUNTER20 0xb14
#define CSR_MHPMCOUNTER21 0xb15
#define CSR_MHPMCOUNTER22 0xb16
#define CSR_MHPMCOUNTER23 0xb17
#define CSR_MHPMCOUNTER24 0xb18
#define CSR_MHPMCOUNTER25 0xb19
#define CSR_MHPMCOUNTER26 0xb1a
#define CSR_MHPMCOUNTER27 0xb1b
#define CSR_MHPMCOUNTER28 0xb1c
#define CSR_MHPMCOUNTER29 0xb1d
#define CSR_MHPMCOUNTER30 0xb1e
#define CSR_MHPMCOUNTER31 0xb1f
#define CSR_MCYCLEH 0xb80
#define CSR_MINSTRETH 0xb82
#define CSR_MHPMCOUNTER3H 0xb83
#define CSR_MHPMCOUNTER4H 0xb84
#define CSR_MHPMCOUNTER5H 0xb85
#define CSR_MHPMCOUNTER6H 0xb86
#define CSR_MHPMCOUNTER7H 0xb87
#define CSR_MHPMCOUNTER8H 0xb88
#define CSR_MHPMCOUNTER9H 0xb89
#define CSR_MHPMCOUNTER10H 0xb8a
#define CSR_MHPMCOUNTER11H 0xb8b
#define CSR_MHPMCOUNTER12H 0xb8c
#define CSR_MHPMCOUNTER13H 0xb8d
#define CSR_MHPMCOUNTER14H 0xb8e
#define CSR_MHPMCOUNTER15H 0xb8f
#define CSR_MHPMCOUNTER16H 0xb90
#define CSR_MHPMCOUNTER17H 0xb91
#define CSR_MHPMCOUNTER18H 0xb92
#define CSR_MHPMCOUNTER19H 0xb93
#define CSR_MHPMCOUNTER20H 0xb94
#define CSR_MHPMCOUNTER21H 0xb95
#define CSR_MHPMCOUNTER22H 0xb96
#define CSR_MHPMCOUNTER23H 0xb97
#define CSR_MHPMCOUNTER24H 0xb98
#define CSR_MHPMCOUNTER25H 0xb99
#define CSR_MHPMCOUNTER26H 0xb9a
#define CSR_MHPMCOUNTER27H 0xb9b
#define CSR_MHPMCOUNTER28H 0xb9c
#define CSR_MHPMCOUNTER29H 0xb9d
#define CSR_MHPMCOUNTER30H 0xb9e
#define CSR_MHPMCOUNTER31H 0xb9f
#define CSR_MCOUNTINHIBIT 0x320
#define CSR_MHPMEVENT3 0x323
#define CSR_MHPMEVENT4 0x324
#define CSR_MHPMEVENT5 0x325
#define CSR_MHPMEVENT6 0x326
#define CSR_MHPMEVENT7 0x327
#define CSR_MHPMEVENT8 0x328
#define CSR_MHPMEVENT9 0x329
#define CSR_MHPMEVENT10 0x32a
#define CSR_MHPMEVENT11 0x32b
#define CSR_MHPMEVENT12 0x32c
#define CSR_MHPMEVENT13 0x32d
#define CSR_MHPMEVENT14 0x32e
#define CSR_MHPMEVENT15 0x32f
#define CSR_MHPMEVENT16 0x330
#define CSR_MHPMEVENT17 0x331
#define CSR_MHPMEVENT18 0x332
#define CSR_MHPMEVENT19 0x333
#define CSR_MHPMEVENT20 0x334
#define CSR_MHPMEVENT21 0x335
#define CSR_MHPMEVENT22 0x336
#define CSR_MHPMEVENT23 0x337
#define CSR_MHPMEVENT24 0x338
#define CSR_MHPMEVENT25 0x339
#define CSR_MHPMEVENT26 0x33a
#define CSR_MHPMEVENT27 0x33b
#define CSR_MHPMEVENT28 0x33c
#define CSR_MHPMEVENT29 0x33d
#define CSR_MHPMEVENT30 0x33e
#define CSR_MHPMEVENT31 0x33f
/* Privileged Hypervisor CSR addresses. */
#define CSR_HSTATUS 0x600
#define CSR_HEDELEG 0x602
#define CSR_HIDELEG 0x603
#define CSR_HIE 0x604
#define CSR_HCOUNTEREN 0x606
#define CSR_HGEIE 0x607
#define CSR_HTVAL 0x643
#define CSR_HIP 0x644
#define CSR_HVIP 0x645
#define CSR_HTINST 0x64a
#define CSR_HGEIP 0xe12
#define CSR_HENVCFG 0x60a
#define CSR_HENVCFGH 0x61a
#define CSR_HGATP 0x680
#define CSR_HTIMEDELTA 0x605
#define CSR_HTIMEDELTAH 0x615
#define CSR_VSSTATUS 0x200
#define CSR_VSIE 0x204
#define CSR_VSTVEC 0x205
#define CSR_VSSCRATCH 0x240
#define CSR_VSEPC 0x241
#define CSR_VSCAUSE 0x242
#define CSR_VSTVAL 0x243
#define CSR_VSIP 0x244
#define CSR_VSATP 0x280
/* Droppped CSR addresses.  */
#define CSR_USTATUS 0x0
#define CSR_UIE 0x4
#define CSR_UTVEC 0x5
#define CSR_USCRATCH 0x40
#define CSR_UEPC 0x41
#define CSR_UCAUSE 0x42
#define CSR_UTVAL 0x43
#define CSR_UIP 0x44
#define CSR_SEDELEG 0x102
#define CSR_SIDELEG 0x103
/* Smaia extension */
#define CSR_MISELECT 0x350
#define CSR_MIREG    0x351
#define CSR_MTOPEI   0x35c
#define CSR_MTOPI    0xfb0
#define CSR_MVIEN    0x308
#define CSR_MVIP     0x309
#define CSR_MIDELEGH 0x313
#define CSR_MIEH     0x314
#define CSR_MVIENH   0x318
#define CSR_MVIPH    0x319
#define CSR_MIPH     0x354
/*Smcsrind extension */
#define CSR_MIREG2    0x352
#define CSR_MIREG3    0x353
#define CSR_MIREG4    0x355
#define CSR_MIREG5    0x356
#define CSR_MIREG6    0x357
/* Smcntrpmf extension.  */
#define CSR_MCYCLECFG    0x321
#define CSR_MINSTRETCFG  0x322
#define CSR_MCYCLECFGH   0x721
#define CSR_MINSTRETCFGH 0x722
/* Smrnmi extension.  */
#define CSR_MNSCRATCH       0x740
#define CSR_MNEPC           0x741
#define CSR_MNCAUSE         0x742
#define CSR_MNSTATUS        0x744
/* Smstateen extension */
#define CSR_MSTATEEN0 0x30c
#define CSR_MSTATEEN1 0x30d
#define CSR_MSTATEEN2 0x30e
#define CSR_MSTATEEN3 0x30f
#define CSR_SSTATEEN0 0x10c
#define CSR_SSTATEEN1 0x10d
#define CSR_SSTATEEN2 0x10e
#define CSR_SSTATEEN3 0x10f
#define CSR_HSTATEEN0 0x60c
#define CSR_HSTATEEN1 0x60d
#define CSR_HSTATEEN2 0x60e
#define CSR_HSTATEEN3 0x60f
#define CSR_MSTATEEN0H 0x31c
#define CSR_MSTATEEN1H 0x31d
#define CSR_MSTATEEN2H 0x31e
#define CSR_MSTATEEN3H 0x31f
#define CSR_HSTATEEN0H 0x61c
#define CSR_HSTATEEN1H 0x61d
#define CSR_HSTATEEN2H 0x61e
#define CSR_HSTATEEN3H 0x61f
/* Ssaia extension */
#define CSR_SISELECT 0x150
#define CSR_SIREG    0x151
#define CSR_STOPEI   0x15c
#define CSR_STOPI    0xdb0
#define CSR_SIEH     0x114
#define CSR_SIPH     0x154
#define CSR_HVIEN     0x608
#define CSR_HVICTL    0x609
#define CSR_HVIPRIO1  0x646
#define CSR_HVIPRIO2  0x647
#define CSR_VSISELECT 0x250
#define CSR_VSIREG    0x251
#define CSR_VSTOPEI   0x25c
#define CSR_VSTOPI    0xeb0
#define CSR_HIDELEGH  0x613
#define CSR_HVIENH    0x618
#define CSR_HVIPH     0x655
#define CSR_HVIPRIO1H 0x656
#define CSR_HVIPRIO2H 0x657
#define CSR_VSIEH     0x214
#define CSR_VSIPH     0x254
/* Sscsrind extension */
#define CSR_SIREG2    0x152
#define CSR_SIREG3    0x153
#define CSR_SIREG4    0x155
#define CSR_SIREG5    0x156
#define CSR_SIREG6    0x157
#define CSR_VSIREG2    0x252
#define CSR_VSIREG3    0x253
#define CSR_VSIREG4    0x255
#define CSR_VSIREG5    0x256
#define CSR_VSIREG6    0x257
/* Sscofpmf extension */
#define CSR_SCOUNTOVF 0xda0
#define CSR_MHPMEVENT3H 0x723
#define CSR_MHPMEVENT4H 0x724
#define CSR_MHPMEVENT5H 0x725
#define CSR_MHPMEVENT6H 0x726
#define CSR_MHPMEVENT7H 0x727
#define CSR_MHPMEVENT8H 0x728
#define CSR_MHPMEVENT9H 0x729
#define CSR_MHPMEVENT10H 0x72a
#define CSR_MHPMEVENT11H 0x72b
#define CSR_MHPMEVENT12H 0x72c
#define CSR_MHPMEVENT13H 0x72d
#define CSR_MHPMEVENT14H 0x72e
#define CSR_MHPMEVENT15H 0x72f
#define CSR_MHPMEVENT16H 0x730
#define CSR_MHPMEVENT17H 0x731
#define CSR_MHPMEVENT18H 0x732
#define CSR_MHPMEVENT19H 0x733
#define CSR_MHPMEVENT20H 0x734
#define CSR_MHPMEVENT21H 0x735
#define CSR_MHPMEVENT22H 0x736
#define CSR_MHPMEVENT23H 0x737
#define CSR_MHPMEVENT24H 0x738
#define CSR_MHPMEVENT25H 0x739
#define CSR_MHPMEVENT26H 0x73a
#define CSR_MHPMEVENT27H 0x73b
#define CSR_MHPMEVENT28H 0x73c
#define CSR_MHPMEVENT29H 0x73d
#define CSR_MHPMEVENT30H 0x73e
#define CSR_MHPMEVENT31H 0x73f
/* Sstc extension */
#define CSR_STIMECMP 0x14d
#define CSR_STIMECMPH 0x15d
#define CSR_VSTIMECMP 0x24d
#define CSR_VSTIMECMPH 0x25d
/* Smctr/Ssctr CSR addresses.  */
#define CSR_SCTRCTL 0x14e
#define CSR_SCTRSTATUS 0x14f
#define CSR_SCTRDEPTH 0x15f
#define CSR_VSCTRCTL 0x24e
#define CSR_MCTRCTL 0x34e
/* Zicfissp CSR addresses.  */
#define CSR_SSP 0x11
/* Unprivileged Floating-Point CSR addresses.  */
#define CSR_FFLAGS 0x1
#define CSR_FRM 0x2
#define CSR_FCSR 0x3
/* Unprivileged Debug CSR addresses.  */
#define CSR_DCSR 0x7b0
#define CSR_DPC 0x7b1
#define CSR_DSCRATCH0 0x7b2
#define CSR_DSCRATCH1 0x7b3
#define CSR_TSELECT 0x7a0
#define CSR_TDATA1 0x7a1
#define CSR_TDATA2 0x7a2
#define CSR_TDATA3 0x7a3
#define CSR_TINFO 0x7a4
#define CSR_TCONTROL 0x7a5
#define CSR_HCONTEXT 0x6a8
#define CSR_SCONTEXT 0x5a8
#define CSR_MCONTEXT 0x7a8
#define CSR_MSCONTEXT 0x7aa
/* Unprivileged Scalar Crypto CSR addresses.  */
#define CSR_SEED 0x015
/* Unprivileged Zcmt CSR addresses.  */
#define CSR_JVT 0x017
/* Unprivileged Vector CSR addresses.  */
#define CSR_VSTART 0x008
#define CSR_VXSAT 0x009
#define CSR_VXRM 0x00a
#define CSR_VCSR 0x00f
#define CSR_VL 0xc20
#define CSR_VTYPE 0xc21
#define CSR_VLENB 0xc22
#endif /* RISCV_ENCODING_H */
#ifdef DECLARE_INSN
DECLARE_INSN(slli_rv32, MATCH_SLLI_RV32, MASK_SLLI_RV32)
DECLARE_INSN(srli_rv32, MATCH_SRLI_RV32, MASK_SRLI_RV32)
DECLARE_INSN(srai_rv32, MATCH_SRAI_RV32, MASK_SRAI_RV32)
DECLARE_INSN(frflags, MATCH_FRFLAGS, MASK_FRFLAGS)
DECLARE_INSN(fsflags, MATCH_FSFLAGS, MASK_FSFLAGS)
DECLARE_INSN(fsflagsi, MATCH_FSFLAGSI, MASK_FSFLAGSI)
DECLARE_INSN(frrm, MATCH_FRRM, MASK_FRRM)
DECLARE_INSN(fsrm, MATCH_FSRM, MASK_FSRM)
DECLARE_INSN(fsrmi, MATCH_FSRMI, MASK_FSRMI)
DECLARE_INSN(fscsr, MATCH_FSCSR, MASK_FSCSR)
DECLARE_INSN(frcsr, MATCH_FRCSR, MASK_FRCSR)
DECLARE_INSN(rdcycle, MATCH_RDCYCLE, MASK_RDCYCLE)
DECLARE_INSN(rdtime, MATCH_RDTIME, MASK_RDTIME)
DECLARE_INSN(rdinstret, MATCH_RDINSTRET, MASK_RDINSTRET)
DECLARE_INSN(rdcycleh, MATCH_RDCYCLEH, MASK_RDCYCLEH)
DECLARE_INSN(rdtimeh, MATCH_RDTIMEH, MASK_RDTIMEH)
DECLARE_INSN(rdinstreth, MATCH_RDINSTRETH, MASK_RDINSTRETH)
DECLARE_INSN(scall, MATCH_SCALL, MASK_SCALL)
DECLARE_INSN(sbreak, MATCH_SBREAK, MASK_SBREAK)
DECLARE_INSN(beq, MATCH_BEQ, MASK_BEQ)
DECLARE_INSN(bne, MATCH_BNE, MASK_BNE)
DECLARE_INSN(blt, MATCH_BLT, MASK_BLT)
DECLARE_INSN(bge, MATCH_BGE, MASK_BGE)
DECLARE_INSN(bltu, MATCH_BLTU, MASK_BLTU)
DECLARE_INSN(bgeu, MATCH_BGEU, MASK_BGEU)
DECLARE_INSN(jalr, MATCH_JALR, MASK_JALR)
DECLARE_INSN(jal, MATCH_JAL, MASK_JAL)
DECLARE_INSN(lui, MATCH_LUI, MASK_LUI)
DECLARE_INSN(auipc, MATCH_AUIPC, MASK_AUIPC)
DECLARE_INSN(addi, MATCH_ADDI, MASK_ADDI)
DECLARE_INSN(slli, MATCH_SLLI, MASK_SLLI)
DECLARE_INSN(slti, MATCH_SLTI, MASK_SLTI)
DECLARE_INSN(sltiu, MATCH_SLTIU, MASK_SLTIU)
DECLARE_INSN(xori, MATCH_XORI, MASK_XORI)
DECLARE_INSN(srli, MATCH_SRLI, MASK_SRLI)
DECLARE_INSN(srai, MATCH_SRAI, MASK_SRAI)
DECLARE_INSN(ori, MATCH_ORI, MASK_ORI)
DECLARE_INSN(andi, MATCH_ANDI, MASK_ANDI)
DECLARE_INSN(add, MATCH_ADD, MASK_ADD)
DECLARE_INSN(sub, MATCH_SUB, MASK_SUB)
DECLARE_INSN(sll, MATCH_SLL, MASK_SLL)
DECLARE_INSN(slt, MATCH_SLT, MASK_SLT)
DECLARE_INSN(sltu, MATCH_SLTU, MASK_SLTU)
DECLARE_INSN(xor, MATCH_XOR, MASK_XOR)
DECLARE_INSN(srl, MATCH_SRL, MASK_SRL)
DECLARE_INSN(sra, MATCH_SRA, MASK_SRA)
DECLARE_INSN(or, MATCH_OR, MASK_OR)
DECLARE_INSN(and, MATCH_AND, MASK_AND)
DECLARE_INSN(addiw, MATCH_ADDIW, MASK_ADDIW)
DECLARE_INSN(slliw, MATCH_SLLIW, MASK_SLLIW)
DECLARE_INSN(srliw, MATCH_SRLIW, MASK_SRLIW)
DECLARE_INSN(sraiw, MATCH_SRAIW, MASK_SRAIW)
DECLARE_INSN(addw, MATCH_ADDW, MASK_ADDW)
DECLARE_INSN(subw, MATCH_SUBW, MASK_SUBW)
DECLARE_INSN(sllw, MATCH_SLLW, MASK_SLLW)
DECLARE_INSN(srlw, MATCH_SRLW, MASK_SRLW)
DECLARE_INSN(sraw, MATCH_SRAW, MASK_SRAW)
DECLARE_INSN(lb, MATCH_LB, MASK_LB)
DECLARE_INSN(lh, MATCH_LH, MASK_LH)
DECLARE_INSN(lw, MATCH_LW, MASK_LW)
DECLARE_INSN(ld, MATCH_LD, MASK_LD)
DECLARE_INSN(lbu, MATCH_LBU, MASK_LBU)
DECLARE_INSN(lhu, MATCH_LHU, MASK_LHU)
DECLARE_INSN(lwu, MATCH_LWU, MASK_LWU)
DECLARE_INSN(sb, MATCH_SB, MASK_SB)
DECLARE_INSN(sh, MATCH_SH, MASK_SH)
DECLARE_INSN(sw, MATCH_SW, MASK_SW)
DECLARE_INSN(sd, MATCH_SD, MASK_SD)
DECLARE_INSN(pause, MATCH_PAUSE, MASK_PAUSE)
DECLARE_INSN(fence, MATCH_FENCE, MASK_FENCE)
DECLARE_INSN(fence_i, MATCH_FENCE_I, MASK_FENCE_I)
DECLARE_INSN(mul, MATCH_MUL, MASK_MUL)
DECLARE_INSN(mulh, MATCH_MULH, MASK_MULH)
DECLARE_INSN(mulhsu, MATCH_MULHSU, MASK_MULHSU)
DECLARE_INSN(mulhu, MATCH_MULHU, MASK_MULHU)
DECLARE_INSN(div, MATCH_DIV, MASK_DIV)
DECLARE_INSN(divu, MATCH_DIVU, MASK_DIVU)
DECLARE_INSN(rem, MATCH_REM, MASK_REM)
DECLARE_INSN(remu, MATCH_REMU, MASK_REMU)
DECLARE_INSN(mulw, MATCH_MULW, MASK_MULW)
DECLARE_INSN(divw, MATCH_DIVW, MASK_DIVW)
DECLARE_INSN(divuw, MATCH_DIVUW, MASK_DIVUW)
DECLARE_INSN(remw, MATCH_REMW, MASK_REMW)
DECLARE_INSN(remuw, MATCH_REMUW, MASK_REMUW)
DECLARE_INSN(amoadd_w, MATCH_AMOADD_W, MASK_AMOADD_W)
DECLARE_INSN(amoxor_w, MATCH_AMOXOR_W, MASK_AMOXOR_W)
DECLARE_INSN(amoor_w, MATCH_AMOOR_W, MASK_AMOOR_W)
DECLARE_INSN(amoand_w, MATCH_AMOAND_W, MASK_AMOAND_W)
DECLARE_INSN(amomin_w, MATCH_AMOMIN_W, MASK_AMOMIN_W)
DECLARE_INSN(amomax_w, MATCH_AMOMAX_W, MASK_AMOMAX_W)
DECLARE_INSN(amominu_w, MATCH_AMOMINU_W, MASK_AMOMINU_W)
DECLARE_INSN(amomaxu_w, MATCH_AMOMAXU_W, MASK_AMOMAXU_W)
DECLARE_INSN(amoswap_w, MATCH_AMOSWAP_W, MASK_AMOSWAP_W)
DECLARE_INSN(lr_w, MATCH_LR_W, MASK_LR_W)
DECLARE_INSN(sc_w, MATCH_SC_W, MASK_SC_W)
DECLARE_INSN(amoadd_d, MATCH_AMOADD_D, MASK_AMOADD_D)
DECLARE_INSN(amoxor_d, MATCH_AMOXOR_D, MASK_AMOXOR_D)
DECLARE_INSN(amoor_d, MATCH_AMOOR_D, MASK_AMOOR_D)
DECLARE_INSN(amoand_d, MATCH_AMOAND_D, MASK_AMOAND_D)
DECLARE_INSN(amomin_d, MATCH_AMOMIN_D, MASK_AMOMIN_D)
DECLARE_INSN(amomax_d, MATCH_AMOMAX_D, MASK_AMOMAX_D)
DECLARE_INSN(amominu_d, MATCH_AMOMINU_D, MASK_AMOMINU_D)
DECLARE_INSN(amomaxu_d, MATCH_AMOMAXU_D, MASK_AMOMAXU_D)
DECLARE_INSN(amoswap_d, MATCH_AMOSWAP_D, MASK_AMOSWAP_D)
DECLARE_INSN(lr_d, MATCH_LR_D, MASK_LR_D)
DECLARE_INSN(sc_d, MATCH_SC_D, MASK_SC_D)
DECLARE_INSN(amoadd_b, MATCH_AMOADD_B, MASK_AMOADD_B)
DECLARE_INSN(amoxor_b, MATCH_AMOXOR_B, MASK_AMOXOR_B)
DECLARE_INSN(amoor_b, MATCH_AMOOR_B, MASK_AMOOR_B)
DECLARE_INSN(amoand_b, MATCH_AMOAND_B, MASK_AMOAND_B)
DECLARE_INSN(amomin_b, MATCH_AMOMIN_B, MASK_AMOMIN_B)
DECLARE_INSN(amomax_b, MATCH_AMOMAX_B, MASK_AMOMAX_B)
DECLARE_INSN(amominu_b, MATCH_AMOMINU_B, MASK_AMOMINU_B)
DECLARE_INSN(amomaxu_b, MATCH_AMOMAXU_B, MASK_AMOMAXU_B)
DECLARE_INSN(amoswap_b, MATCH_AMOSWAP_B, MASK_AMOSWAP_B)
DECLARE_INSN(amocas_b, MATCH_AMOCAS_B, MASK_AMOCAS_B)
DECLARE_INSN(amoadd_h, MATCH_AMOADD_H, MASK_AMOADD_H)
DECLARE_INSN(amoxor_h, MATCH_AMOXOR_H, MASK_AMOXOR_H)
DECLARE_INSN(amoor_h, MATCH_AMOOR_H, MASK_AMOOR_H)
DECLARE_INSN(amoand_h, MATCH_AMOAND_H, MASK_AMOAND_H)
DECLARE_INSN(amomin_h, MATCH_AMOMIN_H, MASK_AMOMIN_H)
DECLARE_INSN(amomax_h, MATCH_AMOMAX_H, MASK_AMOMAX_H)
DECLARE_INSN(amominu_h, MATCH_AMOMINU_H, MASK_AMOMINU_H)
DECLARE_INSN(amomaxu_h, MATCH_AMOMAXU_H, MASK_AMOMAXU_H)
DECLARE_INSN(amoswap_h, MATCH_AMOSWAP_H, MASK_AMOSWAP_H)
DECLARE_INSN(amocas_h, MATCH_AMOCAS_H, MASK_AMOCAS_H)
DECLARE_INSN(ecall, MATCH_ECALL, MASK_ECALL)
DECLARE_INSN(ebreak, MATCH_EBREAK, MASK_EBREAK)
DECLARE_INSN(uret, MATCH_URET, MASK_URET)
DECLARE_INSN(sret, MATCH_SRET, MASK_SRET)
DECLARE_INSN(hret, MATCH_HRET, MASK_HRET)
DECLARE_INSN(mret, MATCH_MRET, MASK_MRET)
DECLARE_INSN(dret, MATCH_DRET, MASK_DRET)
DECLARE_INSN(sfence_vma, MATCH_SFENCE_VMA, MASK_SFENCE_VMA)
DECLARE_INSN(wfi, MATCH_WFI, MASK_WFI)
DECLARE_INSN(csrrw, MATCH_CSRRW, MASK_CSRRW)
DECLARE_INSN(csrrs, MATCH_CSRRS, MASK_CSRRS)
DECLARE_INSN(csrrc, MATCH_CSRRC, MASK_CSRRC)
DECLARE_INSN(csrrwi, MATCH_CSRRWI, MASK_CSRRWI)
DECLARE_INSN(csrrsi, MATCH_CSRRSI, MASK_CSRRSI)
DECLARE_INSN(csrrci, MATCH_CSRRCI, MASK_CSRRCI)
DECLARE_INSN(fadd_s, MATCH_FADD_S, MASK_FADD_S)
DECLARE_INSN(fsub_s, MATCH_FSUB_S, MASK_FSUB_S)
DECLARE_INSN(fmul_s, MATCH_FMUL_S, MASK_FMUL_S)
DECLARE_INSN(fdiv_s, MATCH_FDIV_S, MASK_FDIV_S)
DECLARE_INSN(fsgnj_s, MATCH_FSGNJ_S, MASK_FSGNJ_S)
DECLARE_INSN(fsgnjn_s, MATCH_FSGNJN_S, MASK_FSGNJN_S)
DECLARE_INSN(fsgnjx_s, MATCH_FSGNJX_S, MASK_FSGNJX_S)
DECLARE_INSN(fmin_s, MATCH_FMIN_S, MASK_FMIN_S)
DECLARE_INSN(fmax_s, MATCH_FMAX_S, MASK_FMAX_S)
DECLARE_INSN(fsqrt_s, MATCH_FSQRT_S, MASK_FSQRT_S)
DECLARE_INSN(fadd_d, MATCH_FADD_D, MASK_FADD_D)
DECLARE_INSN(fsub_d, MATCH_FSUB_D, MASK_FSUB_D)
DECLARE_INSN(fmul_d, MATCH_FMUL_D, MASK_FMUL_D)
DECLARE_INSN(fdiv_d, MATCH_FDIV_D, MASK_FDIV_D)
DECLARE_INSN(fsgnj_d, MATCH_FSGNJ_D, MASK_FSGNJ_D)
DECLARE_INSN(fsgnjn_d, MATCH_FSGNJN_D, MASK_FSGNJN_D)
DECLARE_INSN(fsgnjx_d, MATCH_FSGNJX_D, MASK_FSGNJX_D)
DECLARE_INSN(fmin_d, MATCH_FMIN_D, MASK_FMIN_D)
DECLARE_INSN(fmax_d, MATCH_FMAX_D, MASK_FMAX_D)
DECLARE_INSN(fcvt_s_d, MATCH_FCVT_S_D, MASK_FCVT_S_D)
DECLARE_INSN(fcvt_d_s, MATCH_FCVT_D_S, MASK_FCVT_D_S)
DECLARE_INSN(fsqrt_d, MATCH_FSQRT_D, MASK_FSQRT_D)
DECLARE_INSN(fadd_q, MATCH_FADD_Q, MASK_FADD_Q)
DECLARE_INSN(fsub_q, MATCH_FSUB_Q, MASK_FSUB_Q)
DECLARE_INSN(fmul_q, MATCH_FMUL_Q, MASK_FMUL_Q)
DECLARE_INSN(fdiv_q, MATCH_FDIV_Q, MASK_FDIV_Q)
DECLARE_INSN(fsgnj_q, MATCH_FSGNJ_Q, MASK_FSGNJ_Q)
DECLARE_INSN(fsgnjn_q, MATCH_FSGNJN_Q, MASK_FSGNJN_Q)
DECLARE_INSN(fsgnjx_q, MATCH_FSGNJX_Q, MASK_FSGNJX_Q)
DECLARE_INSN(fmin_q, MATCH_FMIN_Q, MASK_FMIN_Q)
DECLARE_INSN(fmax_q, MATCH_FMAX_Q, MASK_FMAX_Q)
DECLARE_INSN(fcvt_s_q, MATCH_FCVT_S_Q, MASK_FCVT_S_Q)
DECLARE_INSN(fcvt_q_s, MATCH_FCVT_Q_S, MASK_FCVT_Q_S)
DECLARE_INSN(fcvt_d_q, MATCH_FCVT_D_Q, MASK_FCVT_D_Q)
DECLARE_INSN(fcvt_q_d, MATCH_FCVT_Q_D, MASK_FCVT_Q_D)
DECLARE_INSN(fsqrt_q, MATCH_FSQRT_Q, MASK_FSQRT_Q)
DECLARE_INSN(fle_s, MATCH_FLE_S, MASK_FLE_S)
DECLARE_INSN(flt_s, MATCH_FLT_S, MASK_FLT_S)
DECLARE_INSN(feq_s, MATCH_FEQ_S, MASK_FEQ_S)
DECLARE_INSN(fle_d, MATCH_FLE_D, MASK_FLE_D)
DECLARE_INSN(flt_d, MATCH_FLT_D, MASK_FLT_D)
DECLARE_INSN(feq_d, MATCH_FEQ_D, MASK_FEQ_D)
DECLARE_INSN(fle_q, MATCH_FLE_Q, MASK_FLE_Q)
DECLARE_INSN(flt_q, MATCH_FLT_Q, MASK_FLT_Q)
DECLARE_INSN(feq_q, MATCH_FEQ_Q, MASK_FEQ_Q)
DECLARE_INSN(fcvt_w_s, MATCH_FCVT_W_S, MASK_FCVT_W_S)
DECLARE_INSN(fcvt_wu_s, MATCH_FCVT_WU_S, MASK_FCVT_WU_S)
DECLARE_INSN(fcvt_l_s, MATCH_FCVT_L_S, MASK_FCVT_L_S)
DECLARE_INSN(fcvt_lu_s, MATCH_FCVT_LU_S, MASK_FCVT_LU_S)
DECLARE_INSN(fmv_x_s, MATCH_FMV_X_S, MASK_FMV_X_S)
DECLARE_INSN(fclass_s, MATCH_FCLASS_S, MASK_FCLASS_S)
DECLARE_INSN(fcvt_w_d, MATCH_FCVT_W_D, MASK_FCVT_W_D)
DECLARE_INSN(fcvt_wu_d, MATCH_FCVT_WU_D, MASK_FCVT_WU_D)
DECLARE_INSN(fcvt_l_d, MATCH_FCVT_L_D, MASK_FCVT_L_D)
DECLARE_INSN(fcvt_lu_d, MATCH_FCVT_LU_D, MASK_FCVT_LU_D)
DECLARE_INSN(fmv_x_d, MATCH_FMV_X_D, MASK_FMV_X_D)
DECLARE_INSN(fclass_d, MATCH_FCLASS_D, MASK_FCLASS_D)
DECLARE_INSN(fcvt_w_q, MATCH_FCVT_W_Q, MASK_FCVT_W_Q)
DECLARE_INSN(fcvt_wu_q, MATCH_FCVT_WU_Q, MASK_FCVT_WU_Q)
DECLARE_INSN(fcvt_l_q, MATCH_FCVT_L_Q, MASK_FCVT_L_Q)
DECLARE_INSN(fcvt_lu_q, MATCH_FCVT_LU_Q, MASK_FCVT_LU_Q)
DECLARE_INSN(fclass_q, MATCH_FCLASS_Q, MASK_FCLASS_Q)
DECLARE_INSN(fcvt_s_w, MATCH_FCVT_S_W, MASK_FCVT_S_W)
DECLARE_INSN(fcvt_s_wu, MATCH_FCVT_S_WU, MASK_FCVT_S_WU)
DECLARE_INSN(fcvt_s_l, MATCH_FCVT_S_L, MASK_FCVT_S_L)
DECLARE_INSN(fcvt_s_lu, MATCH_FCVT_S_LU, MASK_FCVT_S_LU)
DECLARE_INSN(fmv_s_x, MATCH_FMV_S_X, MASK_FMV_S_X)
DECLARE_INSN(fcvt_d_w, MATCH_FCVT_D_W, MASK_FCVT_D_W)
DECLARE_INSN(fcvt_d_wu, MATCH_FCVT_D_WU, MASK_FCVT_D_WU)
DECLARE_INSN(fcvt_d_l, MATCH_FCVT_D_L, MASK_FCVT_D_L)
DECLARE_INSN(fcvt_d_lu, MATCH_FCVT_D_LU, MASK_FCVT_D_LU)
DECLARE_INSN(fmv_d_x, MATCH_FMV_D_X, MASK_FMV_D_X)
DECLARE_INSN(fcvt_q_w, MATCH_FCVT_Q_W, MASK_FCVT_Q_W)
DECLARE_INSN(fcvt_q_wu, MATCH_FCVT_Q_WU, MASK_FCVT_Q_WU)
DECLARE_INSN(fcvt_q_l, MATCH_FCVT_Q_L, MASK_FCVT_Q_L)
DECLARE_INSN(fcvt_q_lu, MATCH_FCVT_Q_LU, MASK_FCVT_Q_LU)
DECLARE_INSN(fli_h, MATCH_FLI_H, MASK_FLI_H)
DECLARE_INSN(fminm_h, MATCH_FMINM_H, MASK_FMINM_H)
DECLARE_INSN(fmaxm_h, MATCH_FMAXM_H, MASK_FMAXM_H)
DECLARE_INSN(fround_h, MATCH_FROUND_H, MASK_FROUND_H)
DECLARE_INSN(fround_nx_h, MATCH_FROUNDNX_H, MASK_FROUNDNX_H)
DECLARE_INSN(fltq_h, MATCH_FLTQ_H, MASK_FLTQ_H)
DECLARE_INSN(fleq_h, MATCH_FLEQ_H, MASK_FLEQ_H)
DECLARE_INSN(fli_s, MATCH_FLI_S, MASK_FLI_S)
DECLARE_INSN(fminm_s, MATCH_FMINM_S, MASK_FMINM_S)
DECLARE_INSN(fmaxm_s, MATCH_FMAXM_S, MASK_FMAXM_S)
DECLARE_INSN(fround_s, MATCH_FROUND_S, MASK_FROUND_S)
DECLARE_INSN(fround_nx_s, MATCH_FROUNDNX_S, MASK_FROUNDNX_S)
DECLARE_INSN(fltq_s, MATCH_FLTQ_S, MASK_FLTQ_S)
DECLARE_INSN(fleq_s, MATCH_FLEQ_S, MASK_FLEQ_S)
DECLARE_INSN(fli_d, MATCH_FLI_D, MASK_FLI_D)
DECLARE_INSN(fminm_d, MATCH_FMINM_D, MASK_FMINM_D)
DECLARE_INSN(fmaxm_d, MATCH_FMAXM_D, MASK_FMAXM_D)
DECLARE_INSN(fround_d, MATCH_FROUND_D, MASK_FROUND_D)
DECLARE_INSN(fround_nx_d, MATCH_FROUNDNX_D, MASK_FROUNDNX_D)
DECLARE_INSN(fltq_d, MATCH_FLTQ_D, MASK_FLTQ_D)
DECLARE_INSN(fleq_d, MATCH_FLEQ_D, MASK_FLEQ_D)
DECLARE_INSN(fli_q, MATCH_FLI_Q, MASK_FLI_Q)
DECLARE_INSN(fminm_q, MATCH_FMINM_Q, MASK_FMINM_Q)
DECLARE_INSN(fmaxm_q, MATCH_FMAXM_Q, MASK_FMAXM_Q)
DECLARE_INSN(fround_q, MATCH_FROUND_Q, MASK_FROUND_Q)
DECLARE_INSN(fround_nx_q, MATCH_FROUNDNX_Q, MASK_FROUNDNX_Q)
DECLARE_INSN(fltq_q, MATCH_FLTQ_Q, MASK_FLTQ_Q)
DECLARE_INSN(fleq_q, MATCH_FLEQ_Q, MASK_FLEQ_Q)
DECLARE_INSN(fcvtmod_w_d, MATCH_FCVTMOD_W_D, MASK_FCVTMOD_W_D)
DECLARE_INSN(fmvh_x_d, MATCH_FMVH_X_D, MASK_FMVH_X_D)
DECLARE_INSN(fmvh_x_q, MATCH_FMVH_X_Q, MASK_FMVH_X_Q)
DECLARE_INSN(fmvp_d_x, MATCH_FMVP_D_X, MASK_FMVP_D_X)
DECLARE_INSN(fmvp_q_x, MATCH_FMVP_Q_X, MASK_FMVP_Q_X)
DECLARE_INSN(clz, MATCH_CLZ, MASK_CLZ)
DECLARE_INSN(ctz, MATCH_CTZ, MASK_CTZ)
DECLARE_INSN(cpop, MATCH_CPOP, MASK_CPOP)
DECLARE_INSN(min, MATCH_MIN, MASK_MIN)
DECLARE_INSN(minu, MATCH_MINU, MASK_MINU)
DECLARE_INSN(max, MATCH_MAX, MASK_MAX)
DECLARE_INSN(maxu, MATCH_MAXU, MASK_MAXU)
DECLARE_INSN(sext_b, MATCH_SEXT_B, MASK_SEXT_B)
DECLARE_INSN(sext_h, MATCH_SEXT_H, MASK_SEXT_H)
DECLARE_INSN(andn, MATCH_ANDN, MASK_ANDN)
DECLARE_INSN(orn, MATCH_ORN, MASK_ORN)
DECLARE_INSN(xnor, MATCH_XNOR, MASK_XNOR)
DECLARE_INSN(rol, MATCH_ROL, MASK_ROL)
DECLARE_INSN(ror, MATCH_ROR, MASK_ROR)
DECLARE_INSN(rori, MATCH_RORI, MASK_RORI)
DECLARE_INSN(clzw, MATCH_CLZW, MASK_CLZW)
DECLARE_INSN(ctzw, MATCH_CTZW, MASK_CTZW)
DECLARE_INSN(cpopw, MATCH_CPOPW, MASK_CPOPW)
DECLARE_INSN(rolw, MATCH_ROLW, MASK_ROLW)
DECLARE_INSN(rorw, MATCH_RORW, MASK_RORW)
DECLARE_INSN(roriw, MATCH_RORIW, MASK_RORIW)
DECLARE_INSN(sh1add, MATCH_SH1ADD, MASK_SH1ADD)
DECLARE_INSN(sh2add, MATCH_SH2ADD, MASK_SH2ADD)
DECLARE_INSN(sh3add, MATCH_SH3ADD, MASK_SH3ADD)
DECLARE_INSN(sh1add_uw, MATCH_SH1ADD_UW, MASK_SH1ADD_UW)
DECLARE_INSN(sh2add_uw, MATCH_SH2ADD_UW, MASK_SH2ADD_UW)
DECLARE_INSN(sh3add_uw, MATCH_SH3ADD_UW, MASK_SH3ADD_UW)
DECLARE_INSN(add_uw, MATCH_ADD_UW, MASK_ADD_UW)
DECLARE_INSN(slli_uw, MATCH_SLLI_UW, MASK_SLLI_UW)
DECLARE_INSN(clmul, MATCH_CLMUL, MASK_CLMUL)
DECLARE_INSN(clmulh, MATCH_CLMULH, MASK_CLMULH)
DECLARE_INSN(clmulr, MATCH_CLMULR, MASK_CLMULR)
DECLARE_INSN(pack, MATCH_PACK, MASK_PACK)
DECLARE_INSN(packh, MATCH_PACKH, MASK_PACKH)
DECLARE_INSN(packw, MATCH_PACKW, MASK_PACKW)
DECLARE_INSN(xperm4, MATCH_XPERM4, MASK_XPERM4)
DECLARE_INSN(xperm8, MATCH_XPERM8, MASK_XPERM8)
DECLARE_INSN(bclri, MATCH_BCLRI, MASK_BCLRI)
DECLARE_INSN(bseti, MATCH_BSETI, MASK_BSETI)
DECLARE_INSN(binvi, MATCH_BINVI, MASK_BINVI)
DECLARE_INSN(bexti, MATCH_BEXTI, MASK_BEXTI)
DECLARE_INSN(bclr, MATCH_BCLR, MASK_BCLR)
DECLARE_INSN(bset, MATCH_BSET, MASK_BSET)
DECLARE_INSN(binv, MATCH_BINV, MASK_BINV)
DECLARE_INSN(bext, MATCH_BEXT, MASK_BEXT)
DECLARE_INSN(flw, MATCH_FLW, MASK_FLW)
DECLARE_INSN(fld, MATCH_FLD, MASK_FLD)
DECLARE_INSN(flq, MATCH_FLQ, MASK_FLQ)
DECLARE_INSN(fsw, MATCH_FSW, MASK_FSW)
DECLARE_INSN(fsd, MATCH_FSD, MASK_FSD)
DECLARE_INSN(fsq, MATCH_FSQ, MASK_FSQ)
DECLARE_INSN(fmadd_s, MATCH_FMADD_S, MASK_FMADD_S)
DECLARE_INSN(fmsub_s, MATCH_FMSUB_S, MASK_FMSUB_S)
DECLARE_INSN(fnmsub_s, MATCH_FNMSUB_S, MASK_FNMSUB_S)
DECLARE_INSN(fnmadd_s, MATCH_FNMADD_S, MASK_FNMADD_S)
DECLARE_INSN(fmadd_d, MATCH_FMADD_D, MASK_FMADD_D)
DECLARE_INSN(fmsub_d, MATCH_FMSUB_D, MASK_FMSUB_D)
DECLARE_INSN(fnmsub_d, MATCH_FNMSUB_D, MASK_FNMSUB_D)
DECLARE_INSN(fnmadd_d, MATCH_FNMADD_D, MASK_FNMADD_D)
DECLARE_INSN(fmadd_q, MATCH_FMADD_Q, MASK_FMADD_Q)
DECLARE_INSN(fmsub_q, MATCH_FMSUB_Q, MASK_FMSUB_Q)
DECLARE_INSN(fnmsub_q, MATCH_FNMSUB_Q, MASK_FNMSUB_Q)
DECLARE_INSN(fnmadd_q, MATCH_FNMADD_Q, MASK_FNMADD_Q)
DECLARE_INSN(c_addi4spn, MATCH_C_ADDI4SPN, MASK_C_ADDI4SPN)
DECLARE_INSN(c_fld, MATCH_C_FLD, MASK_C_FLD)
DECLARE_INSN(c_lw, MATCH_C_LW, MASK_C_LW)
DECLARE_INSN(c_flw, MATCH_C_FLW, MASK_C_FLW)
DECLARE_INSN(c_fsd, MATCH_C_FSD, MASK_C_FSD)
DECLARE_INSN(c_sw, MATCH_C_SW, MASK_C_SW)
DECLARE_INSN(c_fsw, MATCH_C_FSW, MASK_C_FSW)
DECLARE_INSN(c_addi, MATCH_C_ADDI, MASK_C_ADDI)
DECLARE_INSN(c_jal, MATCH_C_JAL, MASK_C_JAL)
DECLARE_INSN(c_li, MATCH_C_LI, MASK_C_LI)
DECLARE_INSN(c_lui, MATCH_C_LUI, MASK_C_LUI)
DECLARE_INSN(c_srli, MATCH_C_SRLI, MASK_C_SRLI)
DECLARE_INSN(c_srai, MATCH_C_SRAI, MASK_C_SRAI)
DECLARE_INSN(c_andi, MATCH_C_ANDI, MASK_C_ANDI)
DECLARE_INSN(c_sub, MATCH_C_SUB, MASK_C_SUB)
DECLARE_INSN(c_xor, MATCH_C_XOR, MASK_C_XOR)
DECLARE_INSN(c_or, MATCH_C_OR, MASK_C_OR)
DECLARE_INSN(c_and, MATCH_C_AND, MASK_C_AND)
DECLARE_INSN(c_subw, MATCH_C_SUBW, MASK_C_SUBW)
DECLARE_INSN(c_addw, MATCH_C_ADDW, MASK_C_ADDW)
DECLARE_INSN(c_j, MATCH_C_J, MASK_C_J)
DECLARE_INSN(c_beqz, MATCH_C_BEQZ, MASK_C_BEQZ)
DECLARE_INSN(c_bnez, MATCH_C_BNEZ, MASK_C_BNEZ)
DECLARE_INSN(c_slli, MATCH_C_SLLI, MASK_C_SLLI)
DECLARE_INSN(c_fldsp, MATCH_C_FLDSP, MASK_C_FLDSP)
DECLARE_INSN(c_lwsp, MATCH_C_LWSP, MASK_C_LWSP)
DECLARE_INSN(c_flwsp, MATCH_C_FLWSP, MASK_C_FLWSP)
DECLARE_INSN(c_mv, MATCH_C_MV, MASK_C_MV)
DECLARE_INSN(c_add, MATCH_C_ADD, MASK_C_ADD)
DECLARE_INSN(c_fsdsp, MATCH_C_FSDSP, MASK_C_FSDSP)
DECLARE_INSN(c_swsp, MATCH_C_SWSP, MASK_C_SWSP)
DECLARE_INSN(c_fswsp, MATCH_C_FSWSP, MASK_C_FSWSP)
DECLARE_INSN(c_nop, MATCH_C_NOP, MASK_C_NOP)
DECLARE_INSN(c_addi16sp, MATCH_C_ADDI16SP, MASK_C_ADDI16SP)
DECLARE_INSN(c_jr, MATCH_C_JR, MASK_C_JR)
DECLARE_INSN(c_jalr, MATCH_C_JALR, MASK_C_JALR)
DECLARE_INSN(c_ebreak, MATCH_C_EBREAK, MASK_C_EBREAK)
DECLARE_INSN(c_ld, MATCH_C_LD, MASK_C_LD)
DECLARE_INSN(c_sd, MATCH_C_SD, MASK_C_SD)
DECLARE_INSN(c_addiw, MATCH_C_ADDIW, MASK_C_ADDIW)
DECLARE_INSN(c_ldsp, MATCH_C_LDSP, MASK_C_LDSP)
DECLARE_INSN(c_sdsp, MATCH_C_SDSP, MASK_C_SDSP)
DECLARE_INSN(sinval_vma, MATCH_SINVAL_VMA, MASK_SINVAL_VMA)
DECLARE_INSN(sfence_w_inval, MATCH_SFENCE_W_INVAL, MASK_SFENCE_W_INVAL)
DECLARE_INSN(sfence_inval_ir, MATCH_SFENCE_INVAL_IR, MASK_SFENCE_INVAL_IR)
DECLARE_INSN(hinval_vvma, MATCH_HINVAL_VVMA, MASK_HINVAL_VVMA)
DECLARE_INSN(hinval_gvma, MATCH_HINVAL_GVMA, MASK_HINVAL_GVMA)
DECLARE_INSN(hfence_vvma, MATCH_HFENCE_VVMA, MASK_HFENCE_VVMA)
DECLARE_INSN(hfence_gvma, MATCH_HFENCE_GVMA, MASK_HFENCE_GVMA)
DECLARE_INSN(hlv_b, MATCH_HLV_B, MASK_HLV_B)
DECLARE_INSN(hlv_h, MATCH_HLV_H, MASK_HLV_H)
DECLARE_INSN(hlv_w, MATCH_HLV_W, MASK_HLV_W)
DECLARE_INSN(hlv_d, MATCH_HLV_D, MASK_HLV_D)
DECLARE_INSN(hlv_bu, MATCH_HLV_BU, MASK_HLV_BU)
DECLARE_INSN(hlv_hu, MATCH_HLV_HU, MASK_HLV_HU)
DECLARE_INSN(hlv_wu, MATCH_HLV_WU, MASK_HLV_WU)
DECLARE_INSN(hlvx_hu, MATCH_HLVX_HU, MASK_HLVX_HU)
DECLARE_INSN(hlvx_wu, MATCH_HLVX_WU, MASK_HLVX_WU)
DECLARE_INSN(hsv_b, MATCH_HSV_B, MASK_HSV_B)
DECLARE_INSN(hsv_h, MATCH_HSV_H, MASK_HSV_H)
DECLARE_INSN(hsv_w, MATCH_HSV_W, MASK_HSV_W)
DECLARE_INSN(hsv_d, MATCH_HSV_D, MASK_HSV_D)
/* Zicbop instructions.  */
DECLARE_INSN(prefetch_r, MATCH_PREFETCH_R, MASK_PREFETCH_R)
DECLARE_INSN(prefetch_w, MATCH_PREFETCH_W, MASK_PREFETCH_W)
DECLARE_INSN(prefetch_i, MATCH_PREFETCH_I, MASK_PREFETCH_I)
/* Zicbom/Zicboz instructions. */
DECLARE_INSN(cbo_clean, MATCH_CBO_CLEAN, MASK_CBO_CLEAN)
DECLARE_INSN(cbo_flush, MATCH_CBO_FLUSH, MASK_CBO_FLUSH)
DECLARE_INSN(cbo_inval, MATCH_CBO_INVAL, MASK_CBO_INVAL)
DECLARE_INSN(cbo_zero, MATCH_CBO_ZERO, MASK_CBO_ZERO)
/* Zicond instructions. */
DECLARE_INSN(czero_eqz, MATCH_CZERO_EQZ, MASK_CZERO_EQZ)
DECLARE_INSN(czero_nez, MATCH_CZERO_NEZ, MASK_CZERO_NEZ)
/* Zihintntl hint instructions.  */
DECLARE_INSN(ntl_p1, MATCH_NTL_P1, MASK_NTL_P1)
DECLARE_INSN(ntl_pall, MATCH_NTL_PALL, MASK_NTL_PALL)
DECLARE_INSN(ntl_s1, MATCH_NTL_S1, MASK_NTL_S1)
DECLARE_INSN(ntl_all, MATCH_NTL_ALL, MASK_NTL_ALL)
DECLARE_INSN(c_ntl_p1, MATCH_C_NTL_P1, MASK_C_NTL_P1)
DECLARE_INSN(c_ntl_pall, MATCH_C_NTL_PALL, MASK_C_NTL_PALL)
DECLARE_INSN(c_ntl_s1, MATCH_C_NTL_S1, MASK_C_NTL_S1)
DECLARE_INSN(c_ntl_all, MATCH_C_NTL_ALL, MASK_C_NTL_ALL)
/* Zimop instructions.  */
DECLARE_INSN(MOP_R_0, MATCH_MOP_R_0, MASK_MOP_R_0)
DECLARE_INSN(MOP_R_1, MATCH_MOP_R_1, MASK_MOP_R_1)
DECLARE_INSN(MOP_R_2, MATCH_MOP_R_2, MASK_MOP_R_2)
DECLARE_INSN(MOP_R_3, MATCH_MOP_R_3, MASK_MOP_R_3)
DECLARE_INSN(MOP_R_4, MATCH_MOP_R_4, MASK_MOP_R_4)
DECLARE_INSN(MOP_R_5, MATCH_MOP_R_5, MASK_MOP_R_5)
DECLARE_INSN(MOP_R_6, MATCH_MOP_R_6, MASK_MOP_R_6)
DECLARE_INSN(MOP_R_7, MATCH_MOP_R_7, MASK_MOP_R_7)
DECLARE_INSN(MOP_R_8, MATCH_MOP_R_8, MASK_MOP_R_8)
DECLARE_INSN(MOP_R_9, MATCH_MOP_R_9, MASK_MOP_R_9)
DECLARE_INSN(MOP_R_10, MATCH_MOP_R_10, MASK_MOP_R_10)
DECLARE_INSN(MOP_R_11, MATCH_MOP_R_11, MASK_MOP_R_11)
DECLARE_INSN(MOP_R_12, MATCH_MOP_R_12, MASK_MOP_R_12)
DECLARE_INSN(MOP_R_13, MATCH_MOP_R_13, MASK_MOP_R_13)
DECLARE_INSN(MOP_R_14, MATCH_MOP_R_14, MASK_MOP_R_14)
DECLARE_INSN(MOP_R_15, MATCH_MOP_R_15, MASK_MOP_R_15)
DECLARE_INSN(MOP_R_16, MATCH_MOP_R_16, MASK_MOP_R_16)
DECLARE_INSN(MOP_R_17, MATCH_MOP_R_17, MASK_MOP_R_17)
DECLARE_INSN(MOP_R_18, MATCH_MOP_R_18, MASK_MOP_R_18)
DECLARE_INSN(MOP_R_19, MATCH_MOP_R_19, MASK_MOP_R_19)
DECLARE_INSN(MOP_R_20, MATCH_MOP_R_20, MASK_MOP_R_20)
DECLARE_INSN(MOP_R_21, MATCH_MOP_R_21, MASK_MOP_R_21)
DECLARE_INSN(MOP_R_22, MATCH_MOP_R_22, MASK_MOP_R_22)
DECLARE_INSN(MOP_R_23, MATCH_MOP_R_23, MASK_MOP_R_23)
DECLARE_INSN(MOP_R_24, MATCH_MOP_R_24, MASK_MOP_R_24)
DECLARE_INSN(MOP_R_25, MATCH_MOP_R_25, MASK_MOP_R_25)
DECLARE_INSN(MOP_R_26, MATCH_MOP_R_26, MASK_MOP_R_26)
DECLARE_INSN(MOP_R_27, MATCH_MOP_R_27, MASK_MOP_R_27)
DECLARE_INSN(MOP_R_28, MATCH_MOP_R_28, MASK_MOP_R_28)
DECLARE_INSN(MOP_R_29, MATCH_MOP_R_29, MASK_MOP_R_29)
DECLARE_INSN(MOP_R_30, MATCH_MOP_R_30, MASK_MOP_R_30)
DECLARE_INSN(MOP_R_31, MATCH_MOP_R_31, MASK_MOP_R_31)
DECLARE_INSN(MOP_RR_0, MATCH_MOP_RR_0, MASK_MOP_RR_0)
DECLARE_INSN(MOP_RR_1, MATCH_MOP_RR_1, MASK_MOP_RR_1)
DECLARE_INSN(MOP_RR_2, MATCH_MOP_RR_2, MASK_MOP_RR_2)
DECLARE_INSN(MOP_RR_3, MATCH_MOP_RR_3, MASK_MOP_RR_3)
DECLARE_INSN(MOP_RR_4, MATCH_MOP_RR_4, MASK_MOP_RR_4)
DECLARE_INSN(MOP_RR_5, MATCH_MOP_RR_5, MASK_MOP_RR_5)
DECLARE_INSN(MOP_RR_6, MATCH_MOP_RR_6, MASK_MOP_RR_6)
DECLARE_INSN(MOP_RR_7, MATCH_MOP_RR_7, MASK_MOP_RR_7)
/* Zacas instructions.  */
DECLARE_INSN(amocas_w, MATCH_AMOCAS_W, MASK_AMOCAS_W)
DECLARE_INSN(amocas_d, MATCH_AMOCAS_D, MASK_AMOCAS_D)
DECLARE_INSN(amocas_q, MATCH_AMOCAS_Q, MASK_AMOCAS_Q)
/* Zawrs instructions.  */
DECLARE_INSN(wrs_nto, MATCH_WRS_NTO, MASK_WRS_NTO)
DECLARE_INSN(wrs_sto, MATCH_WRS_STO, MASK_WRS_STO)
/* Zfbfmin instructions.  */
DECLARE_INSN(FCVT_BF16_S, MATCH_FCVT_BF16_S, MASK_FCVT_BF16_S)
DECLARE_INSN(FCVT_S_BF16, MATCH_FCVT_S_BF16, MASK_FCVT_S_BF16)
/* Zvfbfmin instructions.  */
DECLARE_INSN(VFNCVTBF16_F_F_W, MATCH_VFNCVTBF16_F_F_W, MASK_VFNCVTBF16_F_F_W)
DECLARE_INSN(VFWCVTBF16_F_F_V, MATCH_VFWCVTBF16_F_F_V, MASK_VFWCVTBF16_F_F_V)
/* Zvfbfwma instructions.  */
DECLARE_INSN(VFWMACCBF16_VF, MATCH_VFWMACCBF16_VF, MASK_VFWMACCBF16_VF)
DECLARE_INSN(VFWMACCBF16_VV, MATCH_VFWMACCBF16_VV, MASK_VFWMACCBF16_VV)
/* Zvbb/Zvkb instructions.  */
DECLARE_INSN(vandn_vv, MATCH_VANDN_VV, MASK_VANDN_VV)
DECLARE_INSN(vandn_vx, MATCH_VANDN_VX, MASK_VANDN_VX)
DECLARE_INSN(vbrev8_v, MATCH_VBREV8_V, MASK_VBREV8_V)
DECLARE_INSN(vbrev_v, MATCH_VBREV_V, MASK_VBREV_V)
DECLARE_INSN(vclz_v, MATCH_VCLZ_V, MASK_VCLZ_V)
DECLARE_INSN(vcpop_v, MATCH_VCPOP_V, MASK_VCPOP_V)
DECLARE_INSN(vctz_v, MATCH_VCTZ_V, MASK_VCTZ_V)
DECLARE_INSN(vrev8_v, MATCH_VREV8_V, MASK_VREV8_V)
DECLARE_INSN(vrol_vv, MATCH_VROL_VV, MASK_VROL_VV)
DECLARE_INSN(vrol_vx, MATCH_VROL_VX, MASK_VROL_VX)
DECLARE_INSN(vror_vi, MATCH_VROR_VI, MASK_VROR_VI)
DECLARE_INSN(vror_vv, MATCH_VROR_VV, MASK_VROR_VV)
DECLARE_INSN(vror_vx, MATCH_VROR_VX, MASK_VROR_VX)
DECLARE_INSN(vwsll_vi, MATCH_VWSLL_VI, MASK_VWSLL_VI)
DECLARE_INSN(vwsll_vv, MATCH_VWSLL_VV, MASK_VWSLL_VV)
DECLARE_INSN(vwsll_vx, MATCH_VWSLL_VX, MASK_VWSLL_VX)
/* Zvbc instructions.  */
DECLARE_INSN(vclmul_vv, MATCH_VCLMUL_VV, MASK_VCLMUL_VV)
DECLARE_INSN(vclmul_vx, MATCH_VCLMUL_VX, MASK_VCLMUL_VX)
DECLARE_INSN(vclmulh_vv, MATCH_VCLMULH_VV, MASK_VCLMULH_VV)
DECLARE_INSN(vclmulh_vx, MATCH_VCLMULH_VX, MASK_VCLMULH_VX)
/* Zvkg instructions.  */
DECLARE_INSN(vghsh_vv, MATCH_VGHSH_VV, MASK_VGHSH_VV)
DECLARE_INSN(vgmul_vv, MATCH_VGMUL_VV, MASK_VGMUL_VV)
/* Zvkned instructions.  */
DECLARE_INSN(vaesdf_vs, MATCH_VAESDF_VS, MASK_VAESDF_VS)
DECLARE_INSN(vaesdf_vv, MATCH_VAESDF_VV, MASK_VAESDF_VV)
DECLARE_INSN(vaesdm_vs, MATCH_VAESDM_VS, MASK_VAESDM_VS)
DECLARE_INSN(vaesdm_vv, MATCH_VAESDM_VV, MASK_VAESDM_VV)
DECLARE_INSN(vaesef_vs, MATCH_VAESEF_VS, MASK_VAESEF_VS)
DECLARE_INSN(vaesef_vv, MATCH_VAESEF_VV, MASK_VAESEF_VV)
DECLARE_INSN(vaesem_vs, MATCH_VAESEM_VS, MASK_VAESEM_VS)
DECLARE_INSN(vaesem_vv, MATCH_VAESEM_VV, MASK_VAESEM_VV)
DECLARE_INSN(vaeskf1_vi, MATCH_VAESKF1_VI, MASK_VAESKF1_VI)
DECLARE_INSN(vaeskf2_vi, MATCH_VAESKF2_VI, MASK_VAESKF2_VI)
DECLARE_INSN(vaesz_vs, MATCH_VAESZ_VS, MASK_VAESZ_VS)
/* Zvknh[a,b] instructions.  */
DECLARE_INSN(vsha2ch_vv, MATCH_VSHA2CH_VV, MASK_VSHA2CH_VV)
DECLARE_INSN(vsha2cl_vv, MATCH_VSHA2CL_VV, MASK_VSHA2CL_VV)
DECLARE_INSN(vsha2ms_vv, MATCH_VSHA2MS_VV, MASK_VSHA2MS_VV)
/* Zvksed instructions.  */
DECLARE_INSN(vsm4k_vi, MATCH_VSM4K_VI, MASK_VSM4K_VI)
DECLARE_INSN(vsm4r_vs, MATCH_VSM4R_VS, MASK_VSM4R_VS)
DECLARE_INSN(vsm4r_vv, MATCH_VSM4R_VV, MASK_VSM4R_VV)
/* Zvksh instructions.  */
DECLARE_INSN(vsm3c_vi, MATCH_VSM3C_VI, MASK_VSM3C_VI)
DECLARE_INSN(vsm3me_vv, MATCH_VSM3ME_VV, MASK_VSM3ME_VV)
/* Zcb instructions.  */
DECLARE_INSN(c_sext_b, MATCH_C_SEXT_B, MASK_C_SEXT_B)
DECLARE_INSN(c_sext_h, MATCH_C_SEXT_H, MASK_C_SEXT_H)
DECLARE_INSN(c_zext_b, MATCH_C_ZEXT_B, MASK_C_ZEXT_B)
DECLARE_INSN(c_zext_h, MATCH_C_ZEXT_H, MASK_C_ZEXT_H)
DECLARE_INSN(c_zext_w, MATCH_C_ZEXT_W, MASK_C_ZEXT_W)
DECLARE_INSN(c_mul, MATCH_C_MUL, MASK_C_MUL)
DECLARE_INSN(c_not, MATCH_C_NOT, MASK_C_NOT)
DECLARE_INSN(c_lbu, MATCH_C_LBU, MASK_C_LBU)
DECLARE_INSN(c_lhu, MATCH_C_LHU, MASK_C_LHU)
DECLARE_INSN(c_lh, MATCH_C_LH, MASK_C_LH)
DECLARE_INSN(c_sb, MATCH_C_SB, MASK_C_SB)
DECLARE_INSN(c_sh, MATCH_C_SH, MASK_C_SH)
/* Zcmop instructions.  */
DECLARE_INSN(c_mop_1, MATCH_C_MOP_1, MASK_C_MOP_1)
DECLARE_INSN(c_mop_3, MATCH_C_MOP_3, MASK_C_MOP_3)
DECLARE_INSN(c_mop_5, MATCH_C_MOP_5, MASK_C_MOP_5)
DECLARE_INSN(c_mop_7, MATCH_C_MOP_7, MASK_C_MOP_7)
DECLARE_INSN(c_mop_9, MATCH_C_MOP_9, MASK_C_MOP_9)
DECLARE_INSN(c_mop_11, MATCH_C_MOP_11, MASK_C_MOP_11)
DECLARE_INSN(c_mop_13, MATCH_C_MOP_13, MASK_C_MOP_13)
DECLARE_INSN(c_mop_15, MATCH_C_MOP_15, MASK_C_MOP_15)
/* Zcmp instructions.  */
DECLARE_INSN(cm_push, MATCH_CM_PUSH, MASK_CM_PUSH)
DECLARE_INSN(cm_pop, MATCH_CM_POP, MASK_CM_POP)
DECLARE_INSN(cm_popret, MATCH_CM_POPRET, MASK_CM_POPRET)
DECLARE_INSN(cm_popretz, MATCH_CM_POPRETZ, MASK_CM_POPRETZ)
DECLARE_INSN(cm_mvsa01, MATCH_CM_MVSA01, MASK_CM_MVSA01)
DECLARE_INSN(cm_mva01s, MATCH_CM_MVA01S, MASK_CM_MVA01S)
/* Zcmt instructions.  */
DECLARE_INSN(cm_jt, MATCH_CM_JT, MASK_CM_JT)
DECLARE_INSN(cm_jalt, MATCH_CM_JALT, MASK_CM_JALT)
/* Smctr/Ssctr instruction.  */
DECLARE_INSN(sctrclr, MATCH_SCTRCLR, MASK_SCTRCLR)
/* Vendor-specific (T-Head) XTheadBa instructions.  */
DECLARE_INSN(th_addsl, MATCH_TH_ADDSL, MASK_TH_ADDSL)
/* Vendor-specific (T-Head) XTheadBb instructions.  */
DECLARE_INSN(th_srri, MATCH_TH_SRRI, MASK_TH_SRRI)
DECLARE_INSN(th_srriw, MATCH_TH_SRRIW, MASK_TH_SRRIW)
DECLARE_INSN(th_ext, MATCH_TH_EXT, MASK_TH_EXT)
DECLARE_INSN(th_extu, MATCH_TH_EXTU, MASK_TH_EXTU)
DECLARE_INSN(th_ff0, MATCH_TH_FF0, MASK_TH_FF0)
DECLARE_INSN(th_ff1, MATCH_TH_FF1, MASK_TH_FF1)
DECLARE_INSN(th_rev, MATCH_TH_REV, MASK_TH_REV)
DECLARE_INSN(th_revw, MATCH_TH_REVW, MASK_TH_REVW)
DECLARE_INSN(th_tstbnz, MATCH_TH_TSTNBZ, MASK_TH_TSTNBZ)
/* Vendor-specific (T-Head) XTheadBs instructions.  */
DECLARE_INSN(th_tst, MATCH_TH_TST, MASK_TH_TST)
/* Vendor-specific (T-Head) XTheadCmo instructions.  */
DECLARE_INSN(th_dcache_call, MATCH_TH_DCACHE_CALL, MASK_TH_DCACHE_CALL)
DECLARE_INSN(th_dcache_ciall, MATCH_TH_DCACHE_CIALL, MASK_TH_DCACHE_CIALL)
DECLARE_INSN(th_dcache_iall, MATCH_TH_DCACHE_IALL, MASK_TH_DCACHE_IALL)
DECLARE_INSN(th_dcache_cpa, MATCH_TH_DCACHE_CPA, MASK_TH_DCACHE_CPA)
DECLARE_INSN(th_dcache_cipa, MATCH_TH_DCACHE_CIPA, MASK_TH_DCACHE_CIPA)
DECLARE_INSN(th_dcache_ipa, MATCH_TH_DCACHE_IPA, MASK_TH_DCACHE_IPA)
DECLARE_INSN(th_dcache_cva, MATCH_TH_DCACHE_CVA, MASK_TH_DCACHE_CVA)
DECLARE_INSN(th_dcache_civa, MATCH_TH_DCACHE_CIVA, MASK_TH_DCACHE_CIVA)
DECLARE_INSN(th_dcache_iva, MATCH_TH_DCACHE_IVA, MASK_TH_DCACHE_IVA)
DECLARE_INSN(th_dcache_csw, MATCH_TH_DCACHE_CSW, MASK_TH_DCACHE_CSW)
DECLARE_INSN(th_dcache_cisw, MATCH_TH_DCACHE_CISW, MASK_TH_DCACHE_CISW)
DECLARE_INSN(th_dcache_isw, MATCH_TH_DCACHE_ISW, MASK_TH_DCACHE_ISW)
DECLARE_INSN(th_dcache_cpal1, MATCH_TH_DCACHE_CPAL1, MASK_TH_DCACHE_CPAL1)
DECLARE_INSN(th_dcache_cval1, MATCH_TH_DCACHE_CVAL1, MASK_TH_DCACHE_CVAL1)
DECLARE_INSN(th_icache_iall, MATCH_TH_ICACHE_IALL, MASK_TH_ICACHE_IALL)
DECLARE_INSN(th_icache_ialls, MATCH_TH_ICACHE_IALLS, MASK_TH_ICACHE_IALLS)
DECLARE_INSN(th_icache_ipa, MATCH_TH_ICACHE_IPA, MASK_TH_ICACHE_IPA)
DECLARE_INSN(th_icache_iva, MATCH_TH_ICACHE_IVA, MASK_TH_ICACHE_IVA)
DECLARE_INSN(th_l2cache_call, MATCH_TH_L2CACHE_CALL, MASK_TH_L2CACHE_CALL)
DECLARE_INSN(th_l2cache_ciall, MATCH_TH_L2CACHE_CIALL, MASK_TH_L2CACHE_CIALL)
DECLARE_INSN(th_l2cache_iall, MATCH_TH_L2CACHE_IALL, MASK_TH_L2CACHE_IALL)
/* Vendor-specific (T-Head) XTheadCondMov instructions.  */
DECLARE_INSN(th_mveqz, MATCH_TH_MVEQZ, MASK_TH_MVEQZ)
DECLARE_INSN(th_mvnez, MATCH_TH_MVNEZ, MASK_TH_MVNEZ)
/* Vendor-specific (T-Head) XTheadFMemIdx instructions. */
DECLARE_INSN(th_flrd, MATCH_TH_FLRD, MASK_TH_FLRD)
DECLARE_INSN(th_flrw, MATCH_TH_FLRW, MASK_TH_FLRW)
DECLARE_INSN(th_flurd, MATCH_TH_FLURD, MASK_TH_FLURD)
DECLARE_INSN(th_flurw, MATCH_TH_FLURW, MASK_TH_FLURW)
DECLARE_INSN(th_fsrd, MATCH_TH_FSRD, MASK_TH_FSRD)
DECLARE_INSN(th_fsrw, MATCH_TH_FSRW, MASK_TH_FSRW)
DECLARE_INSN(th_fsurd, MATCH_TH_FSURD, MASK_TH_FSURD)
DECLARE_INSN(th_fsurw, MATCH_TH_FSURW, MASK_TH_FSURW)
/* Vendor-specific (T-Head) XTheadFmv instructions. */
DECLARE_INSN(th_fmv_hw_x, MATCH_TH_FMV_HW_X, MASK_TH_FMV_HW_X)
DECLARE_INSN(th_fmv_x_hw, MATCH_TH_FMV_X_HW, MASK_TH_FMV_X_HW)
/* Vendor-specific (T-Head) XTheadInt instructions. */
DECLARE_INSN(th_ipop, MATCH_TH_IPOP, MASK_TH_IPOP)
DECLARE_INSN(th_ipush, MATCH_TH_IPUSH, MASK_TH_IPUSH)
/* Vendor-specific (T-Head) XTheadMac instructions.  */
DECLARE_INSN(th_mula, MATCH_TH_MULA, MASK_TH_MULA)
DECLARE_INSN(th_mulah, MATCH_TH_MULAH, MASK_TH_MULAH)
DECLARE_INSN(th_mulaw, MATCH_TH_MULAW, MASK_TH_MULAW)
DECLARE_INSN(th_muls, MATCH_TH_MULS, MASK_TH_MULS)
DECLARE_INSN(th_mulsh, MATCH_TH_MULSH, MASK_TH_MULSH)
DECLARE_INSN(th_mulsw, MATCH_TH_MULSW, MASK_TH_MULSW)
/* Vendor-specific (T-Head) XTheadMemIdx instructions. */
DECLARE_INSN(th_ldia, MATCH_TH_LDIA, MASK_TH_LDIA)
DECLARE_INSN(th_ldib, MATCH_TH_LDIB, MASK_TH_LDIB)
DECLARE_INSN(th_lwia, MATCH_TH_LWIA, MASK_TH_LWIA)
DECLARE_INSN(th_lwib, MATCH_TH_LWIB, MASK_TH_LWIB)
DECLARE_INSN(th_lwuia, MATCH_TH_LWUIA, MASK_TH_LWUIA)
DECLARE_INSN(th_lwuib, MATCH_TH_LWUIB, MASK_TH_LWUIB)
DECLARE_INSN(th_lhia, MATCH_TH_LHIA, MASK_TH_LHIA)
DECLARE_INSN(th_lhib, MATCH_TH_LHIB, MASK_TH_LHIB)
DECLARE_INSN(th_lhuia, MATCH_TH_LHUIA, MASK_TH_LHUIA)
DECLARE_INSN(th_lhuib, MATCH_TH_LHUIB, MASK_TH_LHUIB)
DECLARE_INSN(th_lbia, MATCH_TH_LBIA, MASK_TH_LBIA)
DECLARE_INSN(th_lbib, MATCH_TH_LBIB, MASK_TH_LBIB)
DECLARE_INSN(th_lbuia, MATCH_TH_LBUIA, MASK_TH_LBUIA)
DECLARE_INSN(th_lbuib, MATCH_TH_LBUIB, MASK_TH_LBUIB)
DECLARE_INSN(th_sdia, MATCH_TH_SDIA, MASK_TH_SDIA)
DECLARE_INSN(th_sdib, MATCH_TH_SDIB, MASK_TH_SDIB)
DECLARE_INSN(th_swia, MATCH_TH_SWIA, MASK_TH_SWIA)
DECLARE_INSN(th_swib, MATCH_TH_SWIB, MASK_TH_SWIB)
DECLARE_INSN(th_shia, MATCH_TH_SHIA, MASK_TH_SHIA)
DECLARE_INSN(th_shib, MATCH_TH_SHIB, MASK_TH_SHIB)
DECLARE_INSN(th_sbia, MATCH_TH_SBIA, MASK_TH_SBIA)
DECLARE_INSN(th_sbib, MATCH_TH_SBIB, MASK_TH_SBIB)
DECLARE_INSN(th_lrd, MATCH_TH_LRD, MASK_TH_LRD)
DECLARE_INSN(th_lrw, MATCH_TH_LRW, MASK_TH_LRW)
DECLARE_INSN(th_lrwu, MATCH_TH_LRWU, MASK_TH_LRWU)
DECLARE_INSN(th_lrh, MATCH_TH_LRH, MASK_TH_LRH)
DECLARE_INSN(th_lrhu, MATCH_TH_LRHU, MASK_TH_LRHU)
DECLARE_INSN(th_lrb, MATCH_TH_LRB, MASK_TH_LRB)
DECLARE_INSN(th_lrbu, MATCH_TH_LRBU, MASK_TH_LRBU)
DECLARE_INSN(th_srd, MATCH_TH_SRD, MASK_TH_SRD)
DECLARE_INSN(th_srw, MATCH_TH_SRW, MASK_TH_SRW)
DECLARE_INSN(th_srh, MATCH_TH_SRH, MASK_TH_SRH)
DECLARE_INSN(th_srb, MATCH_TH_SRB, MASK_TH_SRB)
DECLARE_INSN(th_lurd, MATCH_TH_LURD, MASK_TH_LURD)
DECLARE_INSN(th_lurw, MATCH_TH_LURW, MASK_TH_LURW)
DECLARE_INSN(th_lurwu, MATCH_TH_LURWU, MASK_TH_LURWU)
DECLARE_INSN(th_lurh, MATCH_TH_LURH, MASK_TH_LURH)
DECLARE_INSN(th_lurhu, MATCH_TH_LURHU, MASK_TH_LURHU)
DECLARE_INSN(th_lurb, MATCH_TH_LURB, MASK_TH_LURB)
DECLARE_INSN(th_lurbu, MATCH_TH_LURBU, MASK_TH_LURBU)
DECLARE_INSN(th_surd, MATCH_TH_SURD, MASK_TH_SURD)
DECLARE_INSN(th_surw, MATCH_TH_SURW, MASK_TH_SURW)
DECLARE_INSN(th_surh, MATCH_TH_SURH, MASK_TH_SURH)
DECLARE_INSN(th_surb, MATCH_TH_SURB, MASK_TH_SURB)
/* Vendor-specific (T-Head) XTheadMemPair instructions. */
DECLARE_INSN(th_ldd, MATCH_TH_LDD, MASK_TH_LDD)
DECLARE_INSN(th_lwd, MATCH_TH_LWD, MASK_TH_LWD)
DECLARE_INSN(th_lwud, MATCH_TH_LWUD, MASK_TH_LWUD)
DECLARE_INSN(th_sdd, MATCH_TH_SDD, MASK_TH_SDD)
DECLARE_INSN(th_swd, MATCH_TH_SWD, MASK_TH_SWD)
/* Vendor-specific (T-Head) XTheadSync instructions.  */
DECLARE_INSN(th_sfence_vmas, MATCH_TH_SFENCE_VMAS, MASK_TH_SFENCE_VMAS)
DECLARE_INSN(th_sync, MATCH_TH_SYNC, MASK_TH_SYNC)
DECLARE_INSN(th_sync_i, MATCH_TH_SYNC_I, MASK_TH_SYNC_I)
DECLARE_INSN(th_sync_is, MATCH_TH_SYNC_IS, MASK_TH_SYNC_IS)
DECLARE_INSN(th_sync_s, MATCH_TH_SYNC_S, MASK_TH_SYNC_S)
/* XVentanaCondOps instructions. */
DECLARE_INSN(vt_maskc, MATCH_VT_MASKC, MASK_VT_MASKC)
DECLARE_INSN(vt_maskcn, MATCH_VT_MASKCN, MASK_VT_MASKCN)

/* Zicfiss instructions.  */
DECLARE_INSN(sspush, MATCH_SSPUSH, MASK_SSPUSH)
DECLARE_INSN(sspopchk, MATCH_SSPOPCHK, MASK_SSPOPCHK)
DECLARE_INSN(c_sspush, MATCH_C_SSPUSH, MASK_C_SSPUSH)
DECLARE_INSN(c_sspopchk, MATCH_C_SSPOPCHK, MASK_C_SSPOPCHK)
DECLARE_INSN(ssrdp, MATCH_SSRDP, MASK_SSRDP)
DECLARE_INSN(ssamoswap_w, MATCH_SSAMOSWAP_W, MASK_SSAMOSWAP_W)
DECLARE_INSN(ssamoswap_d, MATCH_SSAMOSWAP_D, MASK_SSAMOSWAP_D)
/* Zicfilp instructions.  */
DECLARE_INSN(lpad, MATCH_LPAD, MASK_LPAD)
#endif /* DECLARE_INSN */
#ifdef DECLARE_CSR
/* Unprivileged Counter/Timers CSRs.  */
DECLARE_CSR(cycle, CSR_CYCLE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(time, CSR_TIME, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(instret, CSR_INSTRET, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter3, CSR_HPMCOUNTER3, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter4, CSR_HPMCOUNTER4, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter5, CSR_HPMCOUNTER5, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter6, CSR_HPMCOUNTER6, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter7, CSR_HPMCOUNTER7, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter8, CSR_HPMCOUNTER8, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter9, CSR_HPMCOUNTER9, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter10, CSR_HPMCOUNTER10, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter11, CSR_HPMCOUNTER11, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter12, CSR_HPMCOUNTER12, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter13, CSR_HPMCOUNTER13, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter14, CSR_HPMCOUNTER14, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter15, CSR_HPMCOUNTER15, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter16, CSR_HPMCOUNTER16, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter17, CSR_HPMCOUNTER17, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter18, CSR_HPMCOUNTER18, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter19, CSR_HPMCOUNTER19, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter20, CSR_HPMCOUNTER20, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter21, CSR_HPMCOUNTER21, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter22, CSR_HPMCOUNTER22, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter23, CSR_HPMCOUNTER23, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter24, CSR_HPMCOUNTER24, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter25, CSR_HPMCOUNTER25, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter26, CSR_HPMCOUNTER26, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter27, CSR_HPMCOUNTER27, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter28, CSR_HPMCOUNTER28, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter29, CSR_HPMCOUNTER29, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter30, CSR_HPMCOUNTER30, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter31, CSR_HPMCOUNTER31, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(cycleh, CSR_CYCLEH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(timeh, CSR_TIMEH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(instreth, CSR_INSTRETH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter3h, CSR_HPMCOUNTER3H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter4h, CSR_HPMCOUNTER4H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter5h, CSR_HPMCOUNTER5H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter6h, CSR_HPMCOUNTER6H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter7h, CSR_HPMCOUNTER7H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter8h, CSR_HPMCOUNTER8H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter9h, CSR_HPMCOUNTER9H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter10h, CSR_HPMCOUNTER10H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter11h, CSR_HPMCOUNTER11H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter12h, CSR_HPMCOUNTER12H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter13h, CSR_HPMCOUNTER13H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter14h, CSR_HPMCOUNTER14H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter15h, CSR_HPMCOUNTER15H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter16h, CSR_HPMCOUNTER16H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter17h, CSR_HPMCOUNTER17H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter18h, CSR_HPMCOUNTER18H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter19h, CSR_HPMCOUNTER19H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter20h, CSR_HPMCOUNTER20H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter21h, CSR_HPMCOUNTER21H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter22h, CSR_HPMCOUNTER22H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter23h, CSR_HPMCOUNTER23H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter24h, CSR_HPMCOUNTER24H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter25h, CSR_HPMCOUNTER25H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter26h, CSR_HPMCOUNTER26H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter27h, CSR_HPMCOUNTER27H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter28h, CSR_HPMCOUNTER28H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter29h, CSR_HPMCOUNTER29H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter30h, CSR_HPMCOUNTER30H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(hpmcounter31h, CSR_HPMCOUNTER31H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
/* Privileged Supervisor CSRs.  */
DECLARE_CSR(sstatus, CSR_SSTATUS, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(sie, CSR_SIE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(stvec, CSR_STVEC, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(scounteren, CSR_SCOUNTEREN, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(senvcfg, CSR_SENVCFG, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(sscratch, CSR_SSCRATCH, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(sepc, CSR_SEPC, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(scause, CSR_SCAUSE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(stval, CSR_STVAL, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(sip, CSR_SIP, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(satp, CSR_SATP, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
/* Privileged Machine CSRs.  */
DECLARE_CSR(mvendorid, CSR_MVENDORID, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(marchid, CSR_MARCHID, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mimpid, CSR_MIMPID, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhartid, CSR_MHARTID, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mconfigptr, CSR_MCONFIGPTR, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mstatus, CSR_MSTATUS, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(misa, CSR_MISA, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(medeleg, CSR_MEDELEG, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mideleg, CSR_MIDELEG, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mie, CSR_MIE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mtvec, CSR_MTVEC, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mcounteren, CSR_MCOUNTEREN, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mstatush, CSR_MSTATUSH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mscratch, CSR_MSCRATCH, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mepc, CSR_MEPC, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mcause, CSR_MCAUSE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mtval, CSR_MTVAL, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mip, CSR_MIP, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mtinst, CSR_MTINST, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mtval2, CSR_MTVAL2, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(menvcfg, CSR_MENVCFG, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(menvcfgh, CSR_MENVCFGH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mseccfg, CSR_MSECCFG, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mseccfgh, CSR_MSECCFGH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg0, CSR_PMPCFG0, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg1, CSR_PMPCFG1, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg2, CSR_PMPCFG2, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg3, CSR_PMPCFG3, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg4, CSR_PMPCFG4, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg5, CSR_PMPCFG5, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg6, CSR_PMPCFG6, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg7, CSR_PMPCFG7, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg8, CSR_PMPCFG8, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg9, CSR_PMPCFG9, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg10, CSR_PMPCFG10, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg11, CSR_PMPCFG11, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg12, CSR_PMPCFG12, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg13, CSR_PMPCFG13, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg14, CSR_PMPCFG14, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpcfg15, CSR_PMPCFG15, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr0, CSR_PMPADDR0, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr1, CSR_PMPADDR1, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr2, CSR_PMPADDR2, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr3, CSR_PMPADDR3, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr4, CSR_PMPADDR4, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr5, CSR_PMPADDR5, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr6, CSR_PMPADDR6, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr7, CSR_PMPADDR7, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr8, CSR_PMPADDR8, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr9, CSR_PMPADDR9, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr10, CSR_PMPADDR10, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr11, CSR_PMPADDR11, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr12, CSR_PMPADDR12, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr13, CSR_PMPADDR13, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr14, CSR_PMPADDR14, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr15, CSR_PMPADDR15, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr16, CSR_PMPADDR16, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr17, CSR_PMPADDR17, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr18, CSR_PMPADDR18, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr19, CSR_PMPADDR19, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr20, CSR_PMPADDR20, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr21, CSR_PMPADDR21, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr22, CSR_PMPADDR22, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr23, CSR_PMPADDR23, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr24, CSR_PMPADDR24, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr25, CSR_PMPADDR25, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr26, CSR_PMPADDR26, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr27, CSR_PMPADDR27, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr28, CSR_PMPADDR28, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr29, CSR_PMPADDR29, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr30, CSR_PMPADDR30, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr31, CSR_PMPADDR31, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr32, CSR_PMPADDR32, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr33, CSR_PMPADDR33, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr34, CSR_PMPADDR34, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr35, CSR_PMPADDR35, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr36, CSR_PMPADDR36, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr37, CSR_PMPADDR37, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr38, CSR_PMPADDR38, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr39, CSR_PMPADDR39, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr40, CSR_PMPADDR40, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr41, CSR_PMPADDR41, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr42, CSR_PMPADDR42, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr43, CSR_PMPADDR43, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr44, CSR_PMPADDR44, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr45, CSR_PMPADDR45, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr46, CSR_PMPADDR46, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr47, CSR_PMPADDR47, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr48, CSR_PMPADDR48, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr49, CSR_PMPADDR49, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr50, CSR_PMPADDR50, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr51, CSR_PMPADDR51, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr52, CSR_PMPADDR52, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr53, CSR_PMPADDR53, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr54, CSR_PMPADDR54, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr55, CSR_PMPADDR55, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr56, CSR_PMPADDR56, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr57, CSR_PMPADDR57, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr58, CSR_PMPADDR58, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr59, CSR_PMPADDR59, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr60, CSR_PMPADDR60, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr61, CSR_PMPADDR61, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr62, CSR_PMPADDR62, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(pmpaddr63, CSR_PMPADDR63, CSR_CLASS_I, PRIV_SPEC_CLASS_1P12, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mcycle, CSR_MCYCLE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(minstret, CSR_MINSTRET, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter3, CSR_MHPMCOUNTER3, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter4, CSR_MHPMCOUNTER4, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter5, CSR_MHPMCOUNTER5, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter6, CSR_MHPMCOUNTER6, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter7, CSR_MHPMCOUNTER7, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter8, CSR_MHPMCOUNTER8, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter9, CSR_MHPMCOUNTER9, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter10, CSR_MHPMCOUNTER10, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter11, CSR_MHPMCOUNTER11, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter12, CSR_MHPMCOUNTER12, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter13, CSR_MHPMCOUNTER13, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter14, CSR_MHPMCOUNTER14, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter15, CSR_MHPMCOUNTER15, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter16, CSR_MHPMCOUNTER16, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter17, CSR_MHPMCOUNTER17, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter18, CSR_MHPMCOUNTER18, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter19, CSR_MHPMCOUNTER19, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter20, CSR_MHPMCOUNTER20, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter21, CSR_MHPMCOUNTER21, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter22, CSR_MHPMCOUNTER22, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter23, CSR_MHPMCOUNTER23, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter24, CSR_MHPMCOUNTER24, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter25, CSR_MHPMCOUNTER25, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter26, CSR_MHPMCOUNTER26, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter27, CSR_MHPMCOUNTER27, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter28, CSR_MHPMCOUNTER28, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter29, CSR_MHPMCOUNTER29, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter30, CSR_MHPMCOUNTER30, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter31, CSR_MHPMCOUNTER31, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mcycleh, CSR_MCYCLEH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(minstreth, CSR_MINSTRETH, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter3h, CSR_MHPMCOUNTER3H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter4h, CSR_MHPMCOUNTER4H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter5h, CSR_MHPMCOUNTER5H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter6h, CSR_MHPMCOUNTER6H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter7h, CSR_MHPMCOUNTER7H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter8h, CSR_MHPMCOUNTER8H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter9h, CSR_MHPMCOUNTER9H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter10h, CSR_MHPMCOUNTER10H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter11h, CSR_MHPMCOUNTER11H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter12h, CSR_MHPMCOUNTER12H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter13h, CSR_MHPMCOUNTER13H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter14h, CSR_MHPMCOUNTER14H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter15h, CSR_MHPMCOUNTER15H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter16h, CSR_MHPMCOUNTER16H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter17h, CSR_MHPMCOUNTER17H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter18h, CSR_MHPMCOUNTER18H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter19h, CSR_MHPMCOUNTER19H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter20h, CSR_MHPMCOUNTER20H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter21h, CSR_MHPMCOUNTER21H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter22h, CSR_MHPMCOUNTER22H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter23h, CSR_MHPMCOUNTER23H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter24h, CSR_MHPMCOUNTER24H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter25h, CSR_MHPMCOUNTER25H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter26h, CSR_MHPMCOUNTER26H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter27h, CSR_MHPMCOUNTER27H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter28h, CSR_MHPMCOUNTER28H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter29h, CSR_MHPMCOUNTER29H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter30h, CSR_MHPMCOUNTER30H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmcounter31h, CSR_MHPMCOUNTER31H, CSR_CLASS_I_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mcountinhibit, CSR_MCOUNTINHIBIT, CSR_CLASS_I, PRIV_SPEC_CLASS_1P11, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent3, CSR_MHPMEVENT3, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent4, CSR_MHPMEVENT4, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent5, CSR_MHPMEVENT5, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent6, CSR_MHPMEVENT6, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent7, CSR_MHPMEVENT7, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent8, CSR_MHPMEVENT8, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent9, CSR_MHPMEVENT9, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent10, CSR_MHPMEVENT10, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent11, CSR_MHPMEVENT11, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent12, CSR_MHPMEVENT12, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent13, CSR_MHPMEVENT13, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent14, CSR_MHPMEVENT14, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent15, CSR_MHPMEVENT15, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent16, CSR_MHPMEVENT16, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent17, CSR_MHPMEVENT17, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent18, CSR_MHPMEVENT18, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent19, CSR_MHPMEVENT19, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent20, CSR_MHPMEVENT20, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent21, CSR_MHPMEVENT21, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent22, CSR_MHPMEVENT22, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent23, CSR_MHPMEVENT23, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent24, CSR_MHPMEVENT24, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent25, CSR_MHPMEVENT25, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent26, CSR_MHPMEVENT26, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent27, CSR_MHPMEVENT27, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent28, CSR_MHPMEVENT28, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent29, CSR_MHPMEVENT29, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent30, CSR_MHPMEVENT30, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mhpmevent31, CSR_MHPMEVENT31, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
/* Privileged Hypervisor CSRs.  */
DECLARE_CSR(hstatus, CSR_HSTATUS, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hedeleg, CSR_HEDELEG, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hideleg, CSR_HIDELEG, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hie, CSR_HIE, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hcounteren, CSR_HCOUNTEREN, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hgeie, CSR_HGEIE, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(htval, CSR_HTVAL, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hip, CSR_HIP, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hvip, CSR_HVIP, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(htinst, CSR_HTINST, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hgeip, CSR_HGEIP, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(henvcfg, CSR_HENVCFG, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(henvcfgh, CSR_HENVCFGH, CSR_CLASS_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hgatp, CSR_HGATP, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(htimedelta, CSR_HTIMEDELTA, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(htimedeltah, CSR_HTIMEDELTAH, CSR_CLASS_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsstatus, CSR_VSSTATUS, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsie, CSR_VSIE, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vstvec, CSR_VSTVEC, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsscratch, CSR_VSSCRATCH, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsepc, CSR_VSEPC, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vscause, CSR_VSCAUSE, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vstval, CSR_VSTVAL, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsip, CSR_VSIP, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsatp, CSR_VSATP, CSR_CLASS_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Smaia extension */
DECLARE_CSR(miselect, CSR_MISELECT, CSR_CLASS_SMAIA_OR_SMCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mireg, CSR_MIREG, CSR_CLASS_SMAIA_OR_SMCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mtopei, CSR_MTOPEI, CSR_CLASS_SMAIA, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mtopi, CSR_MTOPI, CSR_CLASS_SMAIA, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mvien, CSR_MVIEN, CSR_CLASS_SMAIA, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mvip, CSR_MVIP, CSR_CLASS_SMAIA, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(midelegh, CSR_MIDELEGH, CSR_CLASS_SMAIA_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mieh, CSR_MIEH, CSR_CLASS_SMAIA_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mvienh, CSR_MVIENH, CSR_CLASS_SMAIA_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mviph, CSR_MVIPH, CSR_CLASS_SMAIA_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(miph, CSR_MIPH, CSR_CLASS_SMAIA_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Smcsrind extension */
DECLARE_CSR(mireg2, CSR_MIREG2, CSR_CLASS_SMCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mireg3, CSR_MIREG3, CSR_CLASS_SMCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mireg4, CSR_MIREG4, CSR_CLASS_SMCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mireg5, CSR_MIREG5, CSR_CLASS_SMCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mireg6, CSR_MIREG6, CSR_CLASS_SMCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Smcntrpmf extension (incompatible with the privileged spec v1.9.1).  */
DECLARE_CSR(mcyclecfg, CSR_MCYCLECFG, CSR_CLASS_SMCNTRPMF, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(minstretcfg, CSR_MINSTRETCFG, CSR_CLASS_SMCNTRPMF, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(mcyclecfgh, CSR_MCYCLECFGH, CSR_CLASS_SMCNTRPMF_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
DECLARE_CSR(minstretcfgh, CSR_MINSTRETCFGH, CSR_CLASS_SMCNTRPMF_32, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_DRAFT)
/* Smrnmi extensions.  */
DECLARE_CSR(mnepc, CSR_MNEPC, CSR_CLASS_SMRNMI, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mncause, CSR_MNCAUSE, CSR_CLASS_SMRNMI, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mnscratch, CSR_MNSCRATCH, CSR_CLASS_SMRNMI, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mnstatus, CSR_MNSTATUS, CSR_CLASS_SMRNMI, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Smstateen/Ssstateen extensions.  */
DECLARE_CSR(mstateen0, CSR_MSTATEEN0, CSR_CLASS_SMSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mstateen1, CSR_MSTATEEN1, CSR_CLASS_SMSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mstateen2, CSR_MSTATEEN2, CSR_CLASS_SMSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mstateen3, CSR_MSTATEEN3, CSR_CLASS_SMSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sstateen0, CSR_SSTATEEN0, CSR_CLASS_SSSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sstateen1, CSR_SSTATEEN1, CSR_CLASS_SSSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sstateen2, CSR_SSTATEEN2, CSR_CLASS_SSSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sstateen3, CSR_SSTATEEN3, CSR_CLASS_SSSTATEEN, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen0, CSR_HSTATEEN0, CSR_CLASS_SSSTATEEN_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen1, CSR_HSTATEEN1, CSR_CLASS_SSSTATEEN_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen2, CSR_HSTATEEN2, CSR_CLASS_SSSTATEEN_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen3, CSR_HSTATEEN3, CSR_CLASS_SSSTATEEN_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mstateen0h, CSR_MSTATEEN0H, CSR_CLASS_SMSTATEEN_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mstateen1h, CSR_MSTATEEN1H, CSR_CLASS_SMSTATEEN_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mstateen2h, CSR_MSTATEEN2H, CSR_CLASS_SMSTATEEN_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mstateen3h, CSR_MSTATEEN3H, CSR_CLASS_SMSTATEEN_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen0h, CSR_HSTATEEN0H, CSR_CLASS_SSSTATEEN_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen1h, CSR_HSTATEEN1H, CSR_CLASS_SSSTATEEN_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen2h, CSR_HSTATEEN2H, CSR_CLASS_SSSTATEEN_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hstateen3h, CSR_HSTATEEN3H, CSR_CLASS_SSSTATEEN_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Ssaia extension */
DECLARE_CSR(siselect, CSR_SISELECT, CSR_CLASS_SSAIA_OR_SSCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sireg, CSR_SIREG, CSR_CLASS_SSAIA_OR_SSCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(stopei, CSR_STOPEI, CSR_CLASS_SSAIA, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(stopi, CSR_STOPI, CSR_CLASS_SSAIA, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sieh, CSR_SIEH, CSR_CLASS_SSAIA_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(siph, CSR_SIPH, CSR_CLASS_SSAIA_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hvien, CSR_HVIEN, CSR_CLASS_SSAIA_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hvictl, CSR_HVICTL, CSR_CLASS_SSAIA_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hviprio1, CSR_HVIPRIO1, CSR_CLASS_SSAIA_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hviprio2, CSR_HVIPRIO2, CSR_CLASS_SSAIA_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsiselect, CSR_VSISELECT, CSR_CLASS_SSAIA_OR_SSCSRIND_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsireg, CSR_VSIREG, CSR_CLASS_SSAIA_OR_SSCSRIND_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vstopei, CSR_VSTOPEI, CSR_CLASS_SSAIA_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vstopi, CSR_VSTOPI, CSR_CLASS_SSAIA_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hidelegh, CSR_HIDELEGH, CSR_CLASS_SSAIA_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hvienh, CSR_HVIENH, CSR_CLASS_SSAIA_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hviph, CSR_HVIPH, CSR_CLASS_SSAIA_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hviprio1h, CSR_HVIPRIO1H, CSR_CLASS_SSAIA_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hviprio2h, CSR_HVIPRIO2H, CSR_CLASS_SSAIA_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsieh, CSR_VSIEH, CSR_CLASS_SSAIA_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsiph, CSR_VSIPH, CSR_CLASS_SSAIA_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Sscsrind extension */
DECLARE_CSR(sireg2, CSR_SIREG2, CSR_CLASS_SSCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sireg3, CSR_SIREG3, CSR_CLASS_SSCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sireg4, CSR_SIREG4, CSR_CLASS_SSCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sireg5, CSR_SIREG5, CSR_CLASS_SSCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sireg6, CSR_SIREG6, CSR_CLASS_SSCSRIND, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsireg2, CSR_VSIREG2, CSR_CLASS_SSCSRIND_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsireg3, CSR_VSIREG3, CSR_CLASS_SSCSRIND_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsireg4, CSR_VSIREG4, CSR_CLASS_SSCSRIND_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsireg5, CSR_VSIREG5, CSR_CLASS_SSCSRIND_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsireg6, CSR_VSIREG6, CSR_CLASS_SSCSRIND_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Sscofpmf extension */
DECLARE_CSR(scountovf, CSR_SCOUNTOVF, CSR_CLASS_SSCOFPMF, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent3h, CSR_MHPMEVENT3H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent4h, CSR_MHPMEVENT4H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent5h, CSR_MHPMEVENT5H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent6h, CSR_MHPMEVENT6H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent7h, CSR_MHPMEVENT7H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent8h, CSR_MHPMEVENT8H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent9h, CSR_MHPMEVENT9H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent10h, CSR_MHPMEVENT10H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent11h, CSR_MHPMEVENT11H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent12h, CSR_MHPMEVENT12H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent13h, CSR_MHPMEVENT13H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent14h, CSR_MHPMEVENT14H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent15h, CSR_MHPMEVENT15H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent16h, CSR_MHPMEVENT16H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent17h, CSR_MHPMEVENT17H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent18h, CSR_MHPMEVENT18H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent19h, CSR_MHPMEVENT19H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent20h, CSR_MHPMEVENT20H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent21h, CSR_MHPMEVENT21H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent22h, CSR_MHPMEVENT22H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent23h, CSR_MHPMEVENT23H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent24h, CSR_MHPMEVENT24H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent25h, CSR_MHPMEVENT25H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent26h, CSR_MHPMEVENT26H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent27h, CSR_MHPMEVENT27H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent28h, CSR_MHPMEVENT28H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent29h, CSR_MHPMEVENT29H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent30h, CSR_MHPMEVENT30H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mhpmevent31h, CSR_MHPMEVENT31H, CSR_CLASS_SSCOFPMF_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Sstc extension */
DECLARE_CSR(stimecmp, CSR_STIMECMP, CSR_CLASS_SSTC, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(stimecmph, CSR_STIMECMPH, CSR_CLASS_SSTC_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vstimecmp, CSR_VSTIMECMP, CSR_CLASS_SSTC_AND_H, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vstimecmph, CSR_VSTIMECMPH, CSR_CLASS_SSTC_AND_H_32, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Smctr/Ssctr CSRs.  */
DECLARE_CSR(sctrctl, CSR_SCTRCTL, CSR_CLASS_SSCTR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sctrstatus, CSR_SCTRSTATUS, CSR_CLASS_SSCTR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(sctrdepth, CSR_SCTRDEPTH, CSR_CLASS_SSCTR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vsctrctl, CSR_VSCTRCTL, CSR_CLASS_SSCTR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mctrctl, CSR_MCTRCTL, CSR_CLASS_SMCTR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Zicfiss CSRs.  */
DECLARE_CSR(ssp, CSR_SSP, CSR_CLASS_ZICFISS, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Dropped CSRs.  */
DECLARE_CSR(ustatus, CSR_USTATUS, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(uie, CSR_UIE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(utvec, CSR_UTVEC, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(uscratch, CSR_USCRATCH, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(uepc, CSR_UEPC, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(ucause, CSR_UCAUSE, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(utval, CSR_UTVAL, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(uip, CSR_UIP, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(sedeleg, CSR_SEDELEG, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
DECLARE_CSR(sideleg, CSR_SIDELEG, CSR_CLASS_I, PRIV_SPEC_CLASS_1P10, PRIV_SPEC_CLASS_1P12)
/* Unprivileged Floating-Point CSRs.  */
DECLARE_CSR(fflags, CSR_FFLAGS, CSR_CLASS_F, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(frm, CSR_FRM, CSR_CLASS_F, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(fcsr, CSR_FCSR, CSR_CLASS_F, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Unprivileged Debug CSRs.  */
DECLARE_CSR(dcsr, CSR_DCSR, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(dpc, CSR_DPC, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(dscratch0, CSR_DSCRATCH0, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(dscratch1, CSR_DSCRATCH1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(tselect, CSR_TSELECT, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(tdata1, CSR_TDATA1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(tdata2, CSR_TDATA2, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(tdata3, CSR_TDATA3, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(tinfo, CSR_TINFO, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(tcontrol, CSR_TCONTROL, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(hcontext, CSR_HCONTEXT, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(scontext, CSR_SCONTEXT, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mcontext, CSR_MCONTEXT, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(mscontext, CSR_MSCONTEXT, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Unprivileged Scalar Crypto CSRs.  */
DECLARE_CSR(seed, CSR_SEED, CSR_CLASS_ZKR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Unprivileged Zcmt CSRs.  */
DECLARE_CSR(jvt, CSR_JVT, CSR_CLASS_ZCMT, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Unprivileged Vector CSRs.  */
DECLARE_CSR(vstart, CSR_VSTART, CSR_CLASS_V, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vxsat, CSR_VXSAT, CSR_CLASS_V, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vxrm, CSR_VXRM, CSR_CLASS_V, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vcsr, CSR_VCSR, CSR_CLASS_V, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vl, CSR_VL, CSR_CLASS_V, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vtype, CSR_VTYPE, CSR_CLASS_V, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR(vlenb, CSR_VLENB, CSR_CLASS_V, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
#endif /* DECLARE_CSR */
#ifdef DECLARE_CSR_ALIAS
DECLARE_CSR_ALIAS(dscratch, CSR_DSCRATCH0, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(mcontrol, CSR_TDATA1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(mcontrol6, CSR_TDATA1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(icount, CSR_TDATA1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(itrigger, CSR_TDATA1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(etrigger, CSR_TDATA1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(tmexttrigger, CSR_TDATA1, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(textra32, CSR_TDATA3, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(textra64, CSR_TDATA3, CSR_CLASS_DEBUG, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
/* Unprivileged T-Head Vector CSRs.  */
DECLARE_CSR_ALIAS(th.vstart, CSR_VSTART, CSR_CLASS_XTHEADVECTOR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(th.vxsat, CSR_VXSAT, CSR_CLASS_XTHEADVECTOR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(th.vxrm, CSR_VXRM, CSR_CLASS_XTHEADVECTOR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(th.vl, CSR_VL, CSR_CLASS_XTHEADVECTOR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(th.vtype, CSR_VTYPE, CSR_CLASS_XTHEADVECTOR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
DECLARE_CSR_ALIAS(th.vlenb, CSR_VLENB, CSR_CLASS_XTHEADVECTOR, PRIV_SPEC_CLASS_NONE, PRIV_SPEC_CLASS_NONE)
#endif /* DECLARE_CSR_ALIAS */
