/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/
/*****************************************************************************/
/*                                                                           */
/* File: log.c                                                               */
/*                                                                           */
/*****************************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"

extern char CFLOCK[bufsize];

/*****************************************************************************/

void CfLog(level,string,errstr)

enum cfoutputlevel level;
char *string, *errstr;

{ int endl = false;
  char *sp, buffer[1024];

if ((string == NULL) || (strlen(string) == 0))
   {
   return;
   }

strncpy(buffer,string,1022);
buffer[1023] = '\0'; 

/* Check for %s %m which someone might be able to insert into
   an error message in order to get a syslog buffer overflow...
   bug reported by Pekka Savola */
 
for (sp = buffer; *sp != NULL; sp++)
   {
   if (*sp == '%')
      {
      *sp = '*';
      }
   }
 
switch(level)
   {
   case cfsilent:    if (! SILENT || VERBOSE || DEBUG || D2)
                        {
			ShowAction();
			printf("%s: %s",VPREFIX,buffer);
			endl = true;
                        }
                     break;

   case cfinform:    if (SILENT)
                        {
			return;
                        }
   
                     if (INFORM || VERBOSE || DEBUG || D2)
                        {
			ShowAction();
			printf("%s: %s",VPREFIX,buffer);
			endl = true;
                        }
		     
		     if (LOGGING && IsPrivileged())
			{
			syslog(LOG_ERR,buffer,VFQNAME);

			if (strlen(errstr) != 0)
			   {
			   syslog(LOG_ERR,errstr,VFQNAME);
			   syslog(LOG_ERR,strerror(errno),VFQNAME);
			   }
			}
                     break;
			
   case cfverbose:   if (VERBOSE || DEBUG || D2)
                        {
			if ((errstr == NULL) || (strlen(errstr) > 0))
			   {
			   ShowAction();
			   printf("%s: %s",VPREFIX,buffer);
			   printf("%s: %s",VPREFIX,errstr);
			   endl = true;
			   }
			else
			   {
			   ShowAction();
			   printf("%s: %s",VPREFIX,buffer);
			   endl = true;
			   }
                        }
                     break;

   case cfeditverbose: if (EDITVERBOSE || DEBUG)
                          {
			  ShowAction();
		   	  printf("%s: %s",VPREFIX,buffer);
			  endl = true;
                          }
                     break;

   case cflogonly:
                     if (LOGGING && IsPrivileged())
			{
			syslog(LOG_INFO,buffer,VFQNAME);
			
			if ((errstr == NULL) || (strlen(errstr) > 0))
			   {
			   syslog(LOG_ERR,errstr,VFQNAME);
			   }
			}
		     
                     break;

   case cferror:
                     printf("%s: %s",VPREFIX,buffer);

		     if (LOGGING && IsPrivileged())
			{
			syslog(LOG_ERR,buffer,VFQNAME);
			}
 
		     if (buffer[strlen(buffer)-1] != '\n')
			{
			printf("\n");
			}
		     
		     if ((errstr != NULL) && (strlen(errstr) > 0))
                        {
			ShowAction();
		        printf("%s: %s: %s\n",VPREFIX,errstr,strerror(errno));
			endl = true;
			
			if (LOGGING && IsPrivileged())
			   {
			   syslog(LOG_ERR,errstr,VFQNAME);
			   syslog(LOG_ERR,strerror(errno),VFQNAME);
			   }
                        }
		     return;
   }

 
if (endl && (buffer[strlen(buffer)-1] != '\n'))
    {
    printf("\n");
    }
}

/*****************************************************************************/

void ResetOutputRoute (log,inform)

char log, inform;

  /* t = true, f = false, d = default */

{
if ((log == 't') || (log == 'f') || (inform == 't') || (inform == 'f'))
   {
   INFORM_save = INFORM;
   LOGGING_save = LOGGING;
   
   switch (log)
      {
      case 't': LOGGING = true;
	        break;
      case 'f': LOGGING = false;
	        break;
      }

   switch (inform)
      {
      case 't': INFORM = true;
	        break;
      case 'f': INFORM = false;
	        break;
      }
   }
else
   {
   INFORM = INFORM_save;
   LOGGING = LOGGING_save;
   }
}

/*****************************************************************************/

void ShowAction()

{
if (SHOWACTIONS)
   {
   printf("%s:",CFLOCK);
   }
}
