;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: CLUEI; Base: 10; Patch-File: T; -*-

(in-package :cluei)

(defmethod update-tree ((composite composite))
  ;; Search for a composite with an unrealized child and update it.  
  (let ((children (composite-children composite)))
    (if (dolist (child children)
	  (when (and (not (realized-p child)) (managed-p child))
	    (return t)))
	
	(progn
	  (initialize-geometry composite)
	  (dolist (child children)
;	    (when (and (not (realized-p child)) (managed-p child))
;	      (realize child)
;	      (realize-state child))
	    (cond ((and (not (realized-p child)) (managed-p child))
		   (realize child)
		   (realize-state child))

		  ;; ***** continue to search for unrealized ***** 
		  ;;       children of a realized child!!
		  ((realized-p child)
		   (update-tree child)))))
	
	;; No unrealized children here, continue the search lower down
	(dolist (child children)
	  (when (realized-p child)
	    (update-tree child))))))


