;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;___________________________________________________________________________
;;;
;;;                       System: XACT
;;;                       Module: header
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/xact/header.lisp
;;; File Creation Date: 11/11/91 14:54:20
;;; Last Modification Time: 06/15/92 12:50:25
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;___________________________________________________________________________

(in-package :xit)

(defun find-window (name &optional (parent *toplevel*))
  (cluei::find-contact parent :name name))

(defun find-window-in-list (name window-list &optional recursive-p)
  (if recursive-p
      (some #'(lambda (window) (find-window name window))
	    window-list)
    (find name window-list :key #'contact-name)))

(defun find-window-in-work-area (name &optional recursive-p)
  (declare (special *interface-builder*))
  (find-window-in-list name (windows-in-work-area) recursive-p))
