/*
 * Electric(tm) VLSI Design System
 *
 * File: rout.h
 * Header file for the wire routing aid
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* the meaning of "ROUT_state" */
#define STITCHMODE             07			/* type of stitching being done */
#define NOSTITCH                0			/* no stitching */
#define AUTOSTITCH              1			/* automatic stitching by placement */
#define MIMICSTITCH             2			/* mimic user stitching */
#define SELECT                010			/* bit set if each wire should be OKed */
#define SELSKIP               020			/* bit set if OK's should be skipped */
#define SELDONE               040			/* bit set if any selection was done */

/* the meaning of "ROUT_options" */
#define MIMICINTERACTIVE      010			/* bit set if mimic runs interactively */
#define MIMICIGNORENODESIZE   020			/* bit set if mimic ignores node size */
#define MIMICIGNORENODETYPE   040			/* bit set if mimic ignores node type */
#define MIMICUNROUTES        0100			/* bit set if mimic can unroute */
#define MIMICIGNOREPORTS     0200			/* bit set if mimic ignores ports */

extern AIDENTRY *ro_aid;				/* the Router aid object */
extern INTBIG    ro_statekey;			/* cached key for "ROUT_state" */
extern INTBIG    ro_state;				/* cached value for "ROUT_state" */
extern INTBIG    ro_optionskey;			/* cached key for "ROUT_options" */
extern INTBIG    ro_preferedkey;		/* cached key for "ROUT_prefered_arc" */

/****************************** AUTO-STITCH ROUTING ******************************/

/* check modules */
#define NORCHECK ((RCHECK *)-1)

typedef struct Icheck
{
	NODEINST      *entity;				/* node instance being checked */
	struct Icheck *nextcheck;			/* next in list */
} RCHECK;
extern RCHECK *ro_firstrcheck;
extern RCHECK *ro_rcheckfree;

extern AIDENTRY *ro_source;				/* source of batch of changes */

/****************************** MIMIC ROUTING ******************************/

extern ARCINST   *ro_createdarc;		/* last created arc for mimicing */
extern NODEINST  *ro_deletednodes[2];	/* nodes at end of last deleted arc */
extern PORTPROTO *ro_deletedports[2];	/* ports on nodes at end of last deleted arc */
extern ARCPROTO  *ro_deletedarc;		/* type of last deleted arc */

/****************************** MAZE ROUTING ******************************/

extern INTBIG ro_mazegridx;
extern INTBIG ro_mazegridy;
extern INTBIG ro_mazeoffsetx;
extern INTBIG ro_mazeoffsety;
extern INTBIG ro_mazeboundary;

/****************************** ROUTINES ******************************/

/* prototypes for tool interface */
void ro_init(INTBIG*, char*[], AIDENTRY*);
void ro_done(void);
INTSML ro_set(INTSML, char*[]);
void ro_slice(void);
void ro_startbatch(AIDENTRY*, INTSML);
void ro_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void ro_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void ro_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void ro_newobject(INTBIG, INTBIG);
void ro_killobject(INTBIG, INTBIG);
void ro_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);

/* prototypes for intratool interface */
void   ro_autostitch(void);
INTBIG ro_didaccept(ARCINST*, ARCINST*, ARCINST*);
INTBIG ro_findnetends(NETWORK *net, NODEINST ***nilist, PORTPROTO ***pplist,
		INTBIG **xplist, INTBIG **yplist);
void   ro_freemazememory(void);
void   ro_freemimicmemory(void);
void   ro_freerivermemory(void);
INTBIG ro_getoptions(void);
void   ro_mazeroutecell(void);
void   ro_mazerouteselected(void);
void   ro_mimicstitch(INTSML forced);
INTSML ro_river(NODEPROTO*);
#if ROUTAIDSUN
  void ro_par(void);
#endif

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
