#! /opt/local/bin/perl
#
# Copyright (c) 2010 Tama Communications Corporation
#
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
$script_name = 'completion.cgi';
$global_command = '/usr/local/bin/global';
sub error_and_exit {
	print STDERR "$script_name: " . $_[0];
	exit 1;
}
@pairs = split (/&/, $ENV{'QUERY_STRING'});
foreach $p (@pairs) {
	($name, $value) = split(/=/, $p);
	$value =~ tr/+/ /;
	$value =~ s/%([\dA-Fa-f][\dA-Fa-f])/pack("C", hex($1))/eg;
	$form{$name} = $value;
}
$q = $form{'q'};
if (!$q) {
	error_and_exit("request value is null.");
}
$type = $form{'type'};
if ($type eq 'definition' || $type eq 'reference') {
	$flags = 'c';
} elsif ($type eq 'symbol') {
	$flags = 'cs';
} elsif ($type eq 'path') {
	$flags = 'cP';
} elsif ($type eq 'idutils') {
	$flags = 'cI';
} elsif ($type eq 'grep') {
	exit(0);	# Ignored because completion for grep is groundless.
} else {
	error_and_exit("invalid type name.");
}
if ($form{'icase'}) {
	$flags .= 'i';
}
if ($form{'other'}) {
	$flags .= 'o';
}
if ($form{'limit'}) {
	$limit = $form{'limit'};
}
if (-d "cgi-bin") {
	# This code avoids the bug of the python built-in web server.
	chdir("cgi-bin");
	if ($?) {
		error_and_exit("Couldn't change 'cgi-bin' directory.");
	}
}
if (-f "../GTAGSROOT" && open(GTAGSROOT, "../GTAGSROOT")) {
	$gtagsroot = <GTAGSROOT>;
	chop($gtagsroot);
	close(GTAGSROOT);
} else {
	$gtagsroot = "../..";
}
chdir($gtagsroot);
print "Content-Type: text/html\n\n";
#
# This code was commented out, because it may have a security hole in the future.
# To use this code, please uncomment in your own responsibility.
#
#if ($^O eq 'MSWin32') {
#	open(PIPE, $global_command . " -${flags}e $q |");
#} else {
	open(PIPE, "-|") || exec $global_command, '-'.$flags.'e', $q;
#}
if ($limit > 0) {
	while (<PIPE>) {
		print if ($limit-- > 0);
	}
} else {
	print <PIPE>;
}
close(PIPE);
exit(0);
