/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: help.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino. If not, see <http://www.gnu.org/licenses/>.
 */    

#include <stdio.h>
#include <stdlib.h>
#include "defs.h"
#include "help.h"
#include "kbd.h"

void showAboutBox()
{
    msgBox(copyrightNotice, OK, INFO);
}

void showQuickReference()
{
    drawBox(3, 5, 24, SCREEN_W-5, "Quick Reference", YES, 0);
    fprintf(stdout, "\e[4;7HBasic functions:");
    fprintf(stdout, "\e[5;9HArrow keys: move around");
    fprintf(stdout, "\e[6;9HALT+F: Open File menu");
    fprintf(stdout, "\e[7;9HALT+E: Open Edit menu");
    fprintf(stdout, "\e[8;9HALT+O: Open Options menu");
    fprintf(stdout, "\e[9;9HALT+H: Open Help menu");
    fprintf(stdout, "\e[11;7HShortcut keys:");
    fprintf(stdout, "\e[12;9HCTRL+O: Open file dialog");
    fprintf(stdout, "\e[13;9HCTRL+S: Save file");
    fprintf(stdout, "\e[14;9HCTRL+Q: Exit mino");
    fprintf(stdout, "\e[15;9HCTRL+X: Cut selection");
    fprintf(stdout, "\e[16;9HCTRL+C: Copy selection");
    fprintf(stdout, "\e[17;9HCTRL+V: Paste selection");
    fprintf(stdout, "\e[18;9HCTRL+Z: Undo");
    fprintf(stdout, "\e[19;9HCTRL+Y: Redo");
    fprintf(stdout, "\e[20;9HCTRL+A: Select All");
    fprintf(stdout, "\e[21;9HCTRL+F: Find");
    fprintf(stdout, "\e[22;9HCTRL+R: Find & Replace");
    fprintf(stdout, "\e[23;7HPress any key to continue..");
    fflush(stdout);
    do {;} while(!getKey());
}

void _do_show(int readme_keybindings)
{
  FILE *README;
  char *buf;		//buffer to hold data
  long buf_len = 0;
  
  char *file_name[] =
  {
    "/usr/share/doc/gnudos/mino/README",
    "/usr/local/share/doc/gnudos/mino/README",
    "/usr/share/doc/gnudos/mino/keybindings",
    "/usr/local/share/doc/gnudos/mino/keybindings"
  };
  char *title[] = { " README ", " KEYBINDINGS " };
  char *err[] =
  {
    "Failed to read the README file!.",
    "Failed to read the KEYBINDINGS file!."
  };
  /* choose file to open according to readme_keybindings flag */
  char *file1 = readme_keybindings ? file_name[2] : file_name[0];
  char *file2 = readme_keybindings ? file_name[3] : file_name[1];
  
  if(!(README = fopen(file1, "r"))) 
  {
    if(!(README = fopen(file2, "r"))) 
    {
      msgBox(err[readme_keybindings], OK, ERROR);
      refreshView();
      return;
    }
  }
  
  int i;
  i = fseek(README, 0, SEEK_END);
  buf_len = ftell(README);
  rewind(README);
  if(i == -1 || buf_len == -1) goto return_err;
  buf_len += 512;
  
  buf = (char *)malloc(buf_len);
  if(!buf) goto return_err;
  
  int x = 3;
  int y = 3;
  int w = SCREEN_W-4;
  int h = SCREEN_H-5;
  
  i = 0;
  int firstVisLine = 0;
  //int ch;
  char moreLines = 1;	//used as boolean to indicate if still more lines
  
  int index = 0;
  int inc;
  long total_lines = 0;
  long first_char = 0;
  while((inc = fgetc(README)) != EOF)
  {
    buf[index++] = inc;
    if(inc == '\n') { i = 0; total_lines++; }
    else i++;

    if(i == w)
    {
      buf[index++] = '\n';
      buf_len++;
      total_lines++;
      i = 0;
    }
    buf_len++;
  }
  if(!total_lines)
  {
    if(index) total_lines = 1;
    else goto return_err;
  }
  if(total_lines < h) moreLines = 0;
  else moreLines = 1;
  firstVisLine = 0;
  first_char = 0;

  
  int lines;
read:
  //redraw the box with its contents
  drawBox(x-1, y-1, h+x, w+y, title[readme_keybindings], YES, 0);
  lines = 0;

  fprintf(stdout, "\e[%d;%dH", x, y);
  i = first_char;
  while(i < buf_len)
  {
    if(buf[i] == '\n')
    {
      lines++;
      fprintf(stdout, "\e[%d;%dH", x+lines, y);
      if(lines >= h) break;
    }
    else putchar(buf[i]);
    i++;
    fflush(stdout);
  }
  if(firstVisLine+lines < total_lines) moreLines = 1;
  else moreLines = 0;
  

  while(1) 
  {
    char *ch = getKey();
    switch(ch[0]) 
    {
      case('g'):
	if(GNU_DOS_LEVEL < 3) break;
	if(!CTRL) break;
	goto do_esc;
      case(ESC_KEY):
	if(GNU_DOS_LEVEL > 2) break;
do_esc:
      case(ENTER_KEY):
      case(SPACE_KEY):
	goto end;
	break;
      case('p'):
	if(GNU_DOS_LEVEL < 2) break;
	if(!CTRL) break;
	goto do_up;
      case(UP_KEY):
	if(GNU_DOS_LEVEL > 1) break;
do_up:
	/* go up */
	if(firstVisLine == 0) break;
	i = first_char-1;
	while(i >= 0)
	{
	  i--;
	  if(buf[i] == '\n') break;
	}
	i++;
	first_char = i;
	firstVisLine--;
	goto read;
	break;
      case('n'):
	if(GNU_DOS_LEVEL < 2) break;
	if(!CTRL) break;
	goto do_down;
      case(DOWN_KEY):
	if(GNU_DOS_LEVEL > 1) break;
do_down:
	/* go down */
	if(!moreLines) break;
	i = first_char;
	while(i < buf_len)
	{
	  if(buf[i] == '\n' || buf[i] == '\0') break;
	  i++;
	}
	if(i < buf_len) i++;
	first_char = i;
	firstVisLine++;
	goto read;
	break;
    }	//end of switch
  }	//end of outer while
  
end:
    fclose(README);
    drawBox(2, 1, SCREEN_H-1, SCREEN_W, documentTitle, YES, 0);
    refreshView();
    return;
return_err:
    fclose(README);
    msgBox(err[readme_keybindings], OK, ERROR);
    refreshView();
    return;
}

////////////////////////////////////////////////////////
//shows a window with KEYBINDINGS file as its contents//
////////////////////////////////////////////////////////
void showKeybindings() 
{
  _do_show(1);
}

///////////////////////////////////////////////////
//shows a window with README file as its contents//
///////////////////////////////////////////////////
void showReadMe() 
{
  _do_show(0);
}
