#include <stdio.h>
#include <stdlib.h>

/*********************************************************************

Copyright (C) 2016 Davin Pearson

Maintainer: Davin Pearson <davin.pearson@gmail.com>
Maintainer Website:       http://davin.50webs.com

This text file is not part of GNU Emacs

Commentary:

This C program strips the given file's CR characters so that
the given file can be cleanly loaded into a UNIX program.

Limitation of Warranty:

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more detail.

You should have received a copy of the GNU General Public License
along with GNU Emacs, see the file COPYING.  If not, see:

                <http://www.gnu.org/licenses/gpl.txt>.

***********************************************************************/


int main(int argc, char** argv)
{
   if (argc != 2)
   {
      fprintf(stdout,"Usage: dos2unix <filename>\n");
      exit(EXIT_FAILURE);
   }
   FILE* f = fopen(argv[1],"rb");
   int ch = fgetc(f);
   while (ch != EOF)
   {
      if (ch != '\r')
      {
         fputc(ch,stdout);
      }
      ch = fgetc(f);
   }
   exit(EXIT_SUCCESS);
}
