/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.util;

import java.io.BufferedReader;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.domterm.util.Util;

public class StyleSheets {
    static Console console;

    public static void fatal(String string) {
        System.err.println(string);
        System.exit(-1);
    }

    static Console getConsole() {
        if (console == null) {
            console = System.console();
        }
        if (console == null) {
            StyleSheets.fatal("no console");
        }
        return console;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if ((string = stringArray[n++]).equals("--list")) {
                StyleSheets.listStyleSheets();
                continue;
            }
            if (string.equals("--disable") && n < stringArray.length) {
                StyleSheets.maybeDisable(stringArray[n++], true);
                continue;
            }
            if (string.equals("--enable") && n < stringArray.length) {
                StyleSheets.maybeDisable(stringArray[n++], false);
                continue;
            }
            if (string.equals("--add-rule") && n < stringArray.length) {
                StyleSheets.addRule(stringArray[n++]);
                continue;
            }
            if (string.equals("--load-stylesheet") && n + 1 < stringArray.length) {
                StyleSheets.loadStyleSheet(stringArray[n++], stringArray[n++]);
                continue;
            }
            if (string.equals("--print") && n < stringArray.length) {
                StyleSheets.printStyleSheet(stringArray[n++]);
                continue;
            }
            StyleSheets.fatal("unknown argument '" + string + "'");
        }
    }

    public static String requestReponse(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream("/dev/tty");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        outputStreamWriter.write(string);
        ((Writer)outputStreamWriter).flush();
        FileInputStream fileInputStream = new FileInputStream("/dev/tty");
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        bufferedReader.mark(1);
        int n = bufferedReader.read();
        if (n == 157) {
            return bufferedReader.readLine();
        }
        if (n >= 0) {
            bufferedReader.reset();
        }
        System.err.println("(no response received)");
        return "";
    }

    public static void addRule(String string) {
        String string2 = "\u001b]94;" + Util.toJson(string) + "\u0007";
        console = StyleSheets.getConsole();
        console.format(string2, new Object[0]);
        console.flush();
    }

    public static String loadStyleSheetRequest(String string, String string2) {
        return "\u001b]95;" + Util.toJson(string) + "," + Util.toJson(string2) + "\u0007";
    }

    public static void loadStyleSheet(String string, String string2) throws IOException {
        char[] cArray = new char[2048];
        int n = 0;
        InputStreamReader inputStreamReader = string2.equals("-") ? new InputStreamReader(System.in) : new FileReader(string2);
        while (true) {
            int n2;
            int n3;
            if ((n3 = cArray.length - n) < 512) {
                char[] cArray2 = new char[cArray.length * 3 >> 1];
                System.arraycopy(cArray, 0, cArray2, 0, n);
                cArray = cArray2;
                n3 = cArray.length - n;
            }
            if ((n2 = ((Reader)inputStreamReader).read(cArray, n, n3)) < 0) break;
            n += n2;
        }
        String string3 = new String(cArray, 0, n);
        String string4 = StyleSheets.loadStyleSheetRequest(string, string3);
        String string5 = StyleSheets.requestReponse(string4);
        if (string5 != null && string5.length() > 0) {
            System.err.println(string5);
            System.exit(-1);
        }
    }

    public static void printStyleSheet(String string) throws IOException {
        int[] nArray;
        int n;
        int n2;
        String string2 = "\u001b]93;" + string + "\u0007";
        String string3 = StyleSheets.requestReponse(string2);
        String string4 = Util.parseSimpleJsonString(string3, n2 = 0, n = string3.length(), nArray = new int[1]);
        if (string4 == null) {
            System.err.println(string3);
        } else {
            while (string4 != null) {
                System.out.println(string4);
                n2 = nArray[0] + 1;
                string4 = Util.parseSimpleJsonString(string3, n2, n, nArray);
            }
        }
    }

    public static void maybeDisable(String string, boolean bl) throws IOException {
        String string2 = "\u001b]" + (bl ? 91 : 92) + ";" + string + "\u0007";
        String string3 = StyleSheets.requestReponse(string2);
        if (string3 != null && string3.length() > 0) {
            System.err.println(string3);
            System.exit(-1);
        }
    }

    public static void listStyleSheets() throws IOException {
        String string = StyleSheets.requestReponse("\u001b]90;\u0007");
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = string.indexOf(9, n3);
            if (n4 < 0) {
                n4 = string.length();
            }
            if (n3 == n4) break;
            System.out.print("" + n + ": ");
            System.out.append(string, n3, n4);
            System.out.println();
            n3 = n4 + 1;
            ++n;
        }
    }
}

