#!/bin/sh
#$Id: check_cue.sh.in,v 1.15 2003/10/06 04:04:05 rocky Exp $
# Tests to see that BIN/CUE file iamge reading is correct (via cd-info). 
if test -n "-L/usr/local/lib -lvcdinfo -liso9660 -lcdio -lm  " ; then
  vcd_opt='--no-vcd'
fi

if test -z $srcdir ; then
  srcdir=`pwd`
fi

. ${srcdir}/check_common_fn

if test ! -x ../src/cd-info ; then
  exit 77
fi

BASE=`basename $0 .sh`

fname=cdda
testnum=CD-DA
test_cdinfo "--quiet --cue-file ${srcdir}/${fname}.cue --no-cddb" \
  ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC "cd-info CUE test $testnum"

test_cdinfo "--quiet --bin-file ${srcdir}/${fname}.bin --no-cddb" \
  ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC "cd-info BIN test $testnum"

fname=isofs-m1
testnum='ISO 9660 mode1'
if test -f  ${srcdir}/${fname}.bin ; then
  test_cdinfo "-q --cue-file ${srcdir}/${fname}.cue --iso9660" \
    ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cd-info CUE test $testnum"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.bin. Test $testum skipped."
fi

fname=vcd_demo
if test -z "-L/usr/local/lib -lvcdinfo -liso9660 -lcdio -lm  " ; then
  right=${srcdir}/${fname}.right
else
  right=${srcdir}/${fname}_vcdinfo.right
fi
testnum='Video CD'
if test -f ${srcdir}/${fname}.cue ; then
  test_cdinfo "-q -c ${srcdir}/vcd_demo.cue --iso9660" \
      ${fname}.dump $right
  RC=$?
  check_result $RC "cd-info CUE test $testnum"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.cue. Test $testum skipped."
fi

fname=svcd_ogt_test_ntsc
testnum='Super Video CD'
if test -f ${srcdir}/${fname}.bin ; then
  test_cdinfo "-q --cue-file ${srcdir}/${fname}.cue $vcd_opt --iso9660" \
    ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cd-info CUE test $testnum"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.bin. Test $testnum skipped."
fi

exit $RC

#;;; Local Variables: ***
#;;; mode:shell-script ***
#;;; eval: (sh-set-shell "bash") ***
#;;; End: ***
