/* broken start to a module to support questions appearing in a randomized order
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

#include <stdio.h>
#include "capaCommon.h"
#include "capaParser.h"
#include "capaRQO.h"
extern RandQO_t          *QuestionOrder;

/*FIXME I don't actually do anything yet*/
void rqo_finish()
{
  printf("rqo_finish\n");
}

void rqo_1spec()
{
  printf("rqo_1spec\n");
}

void rqo_2spec()
{
  printf("rqo_2spec\n");
}

void init_rqo()
{
  QuestionOrder=(RandQO_t*) capa_malloc(sizeof(RandQO_t),1);
  QuestionOrder->num=0;
  QuestionOrder->used=(int *) capa_malloc(sizeof(int)*MAX_BUFFER_SIZE,1);
  QuestionOrder->length=MAX_BUFFER_SIZE;
  QuestionOrder->groups=(RandGroup_t**)capa_malloc(sizeof(RandGroup_t*)*MAX_BUFFER_SIZE,1);
  QuestionOrder->length=MAX_BUFFER_SIZE;
}

int rqo_used(int a)
{
  if (QuestionOrder->used[a]) return 1;
  QuestionOrder->used[a]=1;
  return 0;
}

void rqo_expand_range()
{
  /*int num=QuestionOrder->num-1;*/
}

void start_rqo_type(int type)
{
  int num;
  printf("start_rqo_type,%d\n",type);
  if (!QuestionOrder) {init_rqo();}
  if (QuestionOrder->groups[(QuestionOrder->num)-1]->type == RANGE) rqo_expand_range();
  num=QuestionOrder->num;
  QuestionOrder->groups[num]=(RandGroup_t*)capa_malloc(sizeof(RandGroup_t),1);
  QuestionOrder->groups[num]->type=type;
  QuestionOrder->groups[num]->length=0;
  QuestionOrder->groups[num]->list=(int *) capa_malloc(sizeof(int)*MAX_BUFFER_SIZE,1);
  QuestionOrder->num++;
}

void append_rqo(Symbol*s)
{
  int num=QuestionOrder->num-1;
  printf("append_rqo,%ld\n",s->s_int);
  QuestionOrder->groups[num]->list[QuestionOrder->groups[num]->length]=s->s_int;
  QuestionOrder->groups[num]->length++;
  if (rqo_used(s->s_int)) {
    char warn_msg[WARN_MSG_LENGTH];
    sprintf(warn_msg,"Question %ld, used twice in /RQO",s->s_int);
    capa_msg(MESSAGE_ERROR,warn_msg);
  }
  capa_mfree((char*)s);
}

void prefix_rqo(Symbol*s)
{
  int i, num=QuestionOrder->num-1;
  printf("prefix_rqo,%ld\n",s->s_int);
  for(i=(QuestionOrder->groups[num]->length);i>0;i--) {
      QuestionOrder->groups[num]->list[i]=QuestionOrder->groups[num]->list[i-1];
  }
  QuestionOrder->groups[num]->list[0]=s->s_int;
  QuestionOrder->groups[num]->length++;
  if (rqo_used(s->s_int)) {
    char warn_msg[WARN_MSG_LENGTH];
    sprintf(warn_msg,"Question %ld, used twice in /RQO",s->s_int);
    capa_msg(MESSAGE_ERROR,warn_msg);
  }
  capa_mfree((char*)s);
}

