#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation scripts (C function declarations)
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 2001, 2003 Free Software Foundation, Inc.
# Written by Paolo Bonzini and Dragomir Milivojevic
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
    print "\"Automatically generated, do not edit!\""
    FS = "[ (\t]+"

    type["void"] = "#void"
    type["int"] = "#int"
    type["char"] = "#string"
    type["double"] = "#double"
    type["gconstpointer"] = "#cObject"
    type["gpointer"] = "#cObject"

    type["va_list"] = "__skip_this__"
    type["GCallback"] = "__skip_this__"
    type["GClosure"] = "__skip_this__"
    type["GCClosure"] = "__skip_this__"
    type["GCompareDataFunc"] = "__skip_this__"
    type["GCompareFunc"] = "__skip_this__"
    type["GDestroyNotify"] = "__skip_this__"
    type["GFunc"] = "__skip_this__"
    type["GWeakNotify"] = "__skip_this__"
    
    type["gint8"] = "#int"
    type["guint8"] = "#int"
    type["gint16"] = "#int"
    type["guint16"] = "#int"
    type["gint32"] = "#int"
    type["guint32"] = "#int"
    
    type["gchar"] = "#int"
    type["guchar"] = "#int"
    type["gshort"] = "#int"
    type["gushort"] = "#int"
    type["glong"] = "#long"
    type["gulong"] = "#long"
    type["gint"] = "#int"
    type["guint"] = "#int"
    type["gboolean"] = "#boolean"
    type["gfloat"] = "#float"
    type["gdouble"] = "#double"

    # Fix asymmetry
    method_regexp = "g_param_values?_|g_param_type_"
    class["g_param_value_"] = "GParamSpec"
    class["g_param_values_"] = "GParamSpec"
    class["g_param_type_"] = "GParamSpec"
}

# Pick the correct case for the class (e.g. CList vs. Clist)
# and decide what will be the prefix for its methods

$1 == "struct" && $2 ~ /^_/ {
  name = substr($2, 2)
  define_class(name)
}

$0 ~ /^typedef (struct|union)/ && $3 ~ /_(G|Pango|Atk)/ {
  # Take into account typedefs from a struct named differently.
  # We emit all these at the end, because they're often forward
  # references.
  gsub(/[_;]/, "", $0)
  define_class($4)
}

$1 == "typedef" && $2 ~ /^(G|Pango|Atk)/ {
  # Take into account typedefs from a struct named differently.
  # We emit all these at the end, because they're often forward
  # references.
  gsub(/[_;]/, "", $0)
  define_class($3)
}

$2 ~ /^(g[a-z]*|pango)_/ && $1 ~ /[a-zA-Z]/ && $1 !~ /^#/ { 
  $0 = $0

  cFuncName = $2

  if (match($2, "^(" method_regexp ")"))
    className = class[substr($2, 1, RLENGTH)]
  else if (match ($2, /^(g_)?[a-z]*_/))
    className = smalltalkize(toupper(substr($2, 1, RLENGTH - 1)))

  if (tolower(className) in correct_case)
    className = correct_case[tolower(className)]

  $2 = substr($2, RLENGTH + 1)
  creation = $2 ~ /^(newv?|alloc)($|_)/

  # Lose some symmetry for the sake of intuitiveness
  self = $2 ~ /(^|_)((un)?ref$|(dis)?connect)/
  if (match($2, /^(draw|paint)_/))
    className = "GtkStyle"

  smalltalkFuncName = smalltalkize($2)

  # create one long string and tokenize it
  decl = $0
  while( match( decl, ";" ) == 0 )
  {
    getline

    for (i = 1; i <= NF; i++)
      # Convert arrays to pointers
      while( $i ~ /\[\]/ )
      {
        $i = "*" $i
        sub (/\[\]/, "", $i)
      }

    decl = decl " " $0
  }

  # Check for presence of pointers to functions
  if (decl ~ /\([ \t]*\*/)
    next

  split( decl, arr )

  # tokenize
  decl = save_decl = ""
  void = 0
  strip_variadic = 0
  
  for(i = 1; i in arr; i++) {
    last = strip(tst)
    tst = arr[i]

    if (substr(tst, 1, 3) == "...") {
      # remove last argument if it was actually the first variadic argument
      if (decl ~ /: first/ && save_decl !~ /: first/) {
        strip_variadic = 1
        decl = save_decl
      }

      decl = decl " varargs: varargs"
      break
    }

    if( tst !~ /[,\)]/ )
      continue
  
    tst = smalltalkize( strip( tst ) )

    if (tst == "void" || last == "void") {
      void = 1
      break
    }

    if (decl != "")
    {
      save_decl = decl
      decl = decl " " tst ": " tst
      continue
    }

    if (i < 5 && last == className)
      self = 1

    if (i >= 5 || !self)
      decl = smalltalkFuncName ": " tst
  }

  argdecl = save_decl = ""
  tst = ""

  for(i = 1; i in arr; i++)
  {
    last = strip(tst)
    tst = arr[i]

    if( tst !~ /[,\)]/ )
      continue
  
    if (i < 5 && self)
      argdecl = argdecl " #self"

    else if (substr(tst, 1, 3) == "...")
      {
        if (strip_variadic)
          argdecl = save_decl
        argdecl = argdecl " #variadic"
        break
      }

    else if ( index( tst, "," ) > 0 || index( tst, ")" ) > 0 )
      {
        save_decl = argdecl
        argdecl = argdecl " " ctype( strip( last ), tst )
      }
  }

  if (creation)
    retType = returned(className "*")
  else 
    retType = returned(arr[1]) 

  if (void)
    argdecl = ""

  # skip some functions that we don't have bindings for

  if (argdecl ~ /__skip_this__/ || retType == "__skip_this__")
    next

  # print the declaration

  print className (self ? "" : " class")
  print "\tdefineCFunc: '" cFuncName "'"
  print "\twithSelectorArgs: '" (decl == "" ? smalltalkFuncName : decl) "'" 
  print "\treturning: " retType
  print "\targs: #(" argdecl " )!\n"
}


# strips garbage from string
function strip( var )
{
  gsub( /[()\\,;*]/, "", var )
  return var
}

function ctype( var, name )
{
  # everything else is CObject
  res = type[var]
  if (name ~ /^\*\*/)
    return "#cObject"
  else if (name ~ /^\*/)
    return var ~ /g?char$/ ? "#string" : "#cObject"
  else if( res != "" ) 
    return res
  else
    return "#int"
}

function returned( var )
{
  pointer = var ~ /\*$/
  var = strip(var)
  res = type[var]

  if (pointer && res != "__skip_this__")
    return var ~ /g?char/ ? "#string" : var " type"
  else if( res != "" ) 
    return res
  else
    return "#int"
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (j = index (res, "_")) {
    first = first substr(res, 1, j - 1) toupper( substr (res, j + 1, 1))
    res = substr (res, j + 2)
  }

  return first res
}

function define_class(name) {
  if (name ~ /(Class|Iface)$/)
    return

  correct_case[tolower(name)] = name
  prefix = method_prefix(name) "_"
  method_regexp = method_regexp "|" prefix
  class[prefix] = name
}

function method_prefix( name )
{
  prefix = ""
  glib = name ~ /^G[A-Z]/

  while (match(name, /[A-Z]/)) {
    prefix = prefix substr(name, 1, RSTART - 1) "_" substr(name, RSTART, 1)
    for (name = substr(name, RSTART + 1); name ~ /^[A-Z]/; \
         name = substr(name, 2))
      prefix = prefix substr(name, 1, 1)
  }

  name = tolower(substr(prefix, 2) name)
  if (glib)
    sub (/^g/, "g_", name)

  return name
}

