#!/bin/bash
set -exuo pipefail
# This file is in the public domain.
# Helper script to build the latest DEB packages in the container.


unset LD_LIBRARY_PATH

# Run the bootstrap script in case it hasn't been done already at this point
./bootstrap

# gbp wants the debian directory in the root of the git repo
# so we symlink in the debian directory for the package we want to create
rm -f ./debian # in case we already have a symlink there
ln -s packages/taler-harness/debian .

# Change to our package directory
cd packages/taler-harness

# Install build-time dependencies.
# Update apt cache first
apt-get update
apt-get upgrade -y
mk-build-deps --install --tool='apt-get -o Debug::pkgProblemResolver=yes --no-install-recommends --yes' debian/control

export VERSION="$(../../contrib/ci/jobs/4-taler-harness-deb-package/version.sh)"
echo "Building package version ${VERSION}"

EMAIL=none gbp dch --ignore-branch --debian-tag="%(version)s" --git-author --new-version="${VERSION}"
echo "Current PWD is $PWD"
./configure --prefix=$HOME/local/
dpkg-buildpackage -rfakeroot -b -uc -us

ls -alh ../*.deb
mkdir -p /artifacts/wallet-core/${CI_COMMIT_REF} # Variable comes from CI environment
mv ../*.deb /artifacts/wallet-core/${CI_COMMIT_REF}/
