# Bulgarian (bg) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                            | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-ма                                    | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-та                                       | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-ма                                    | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-та                                       | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-во                                       | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ро                                       | Invalid Date             |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-во тримес.                               | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ро тримес.                               | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-во тримесечие                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ро тримесечие                            | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                          | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-во                                       | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ро                                       | Invalid Date             |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-во тримес.                               | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ро тримес.                               | Invalid Date             |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-во тримесечие                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ро тримесечие                            | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2-ри                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ми                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | фев                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | юли                                        | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | юли                                        | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | юли                                        | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2-ри                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ми                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | фев                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | юли                                        | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | юли                                        | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | юли                                        | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-ва                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ма                                      | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-ва                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ма                                      | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11-ти                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-ми                                      | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-ри                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-ти                                     | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петък                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | пн                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                         | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-ви                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ти                                       | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петък                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | пн                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-ви                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ти                                       | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петък                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | пн                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-ви                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ти                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петък                                      | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | пн                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пт                                         | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | aa           | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | bb           | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | преди обяд                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | след обяд                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | преди обяд                                 | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | сутринта                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | следобед                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | вечерта                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | през нощта                                 | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | сутринта                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | следобед                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | вечерта                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | през нощта                                 | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | сутринта                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | следобед                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | вечерта                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | през нощта                                 | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | сутринта                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | следобед                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | вечерта                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | през нощта                                 | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | сутринта                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | следобед                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | вечерта                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | през нощта                                 | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ти                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ти                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ти                                      | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ти                                      | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-ва                                       | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-та                                      | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-ва                                       | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-та                                      | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                 | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 фев 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май 1453                                | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 февруари 1987                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май 1453                                | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | сряда, 11 февруари 1987                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | неделя, 29 май 1453                        | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                      | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                      | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                   | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                   | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                             | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                         | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987 12:13                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453 23:59                           | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 фев 1987 12:13:14                       | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май 1453 23:59:59                       | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 февруари 1987 12:13:14 GMT+0            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 май 1453 23:59:59 GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | сряда, 11 февруари 1987 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | неделя, 29 май 1453 23:59:59 GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | ------------------ | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | около 6 години     | около 6 години         | след около 6 години      |
| 2005-01-01T00:00:00.000Z | около 5 години     | около 5 години         | след около 5 години      |
| 2004-01-01T00:00:00.000Z | около 4 години     | около 4 години         | след около 4 години      |
| 2003-01-01T00:00:00.000Z | около 3 години     | около 3 години         | след около 3 години      |
| 2002-01-01T00:00:00.000Z | около 2 години     | около 2 години         | след около 2 години      |
| 2001-06-01T00:00:00.000Z | над година         | над година             | след над година          |
| 2001-02-01T00:00:00.000Z | около година       | около година           | след около година        |
| 2001-01-01T00:00:00.000Z | около година       | около година           | след около година        |
| 2000-06-01T00:00:00.000Z | 5 месеца           | 5 месеца               | след 5 месеца            |
| 2000-03-01T00:00:00.000Z | 2 месеца           | 2 месеца               | след 2 месеца            |
| 2000-02-01T00:00:00.000Z | около месец        | около месец            | след около месец         |
| 2000-01-15T00:00:00.000Z | 14 дни             | 14 дни                 | след 14 дни              |
| 2000-01-02T00:00:00.000Z | 1 ден              | 1 ден                  | след 1 ден               |
| 2000-01-01T06:00:00.000Z | около 6 часа       | около 6 часа           | след около 6 часа        |
| 2000-01-01T01:00:00.000Z | около час          | около час              | след около час           |
| 2000-01-01T00:45:00.000Z | около час          | около час              | след около час           |
| 2000-01-01T00:30:00.000Z | 30 минути          | 30 минути              | след 30 минути           |
| 2000-01-01T00:15:00.000Z | 15 минути          | 15 минути              | след 15 минути           |
| 2000-01-01T00:01:00.000Z | 1 минута           | 1 минута               | след 1 минута            |
| 2000-01-01T00:00:25.000Z | по-малко от минута | половин минута         | след по-малко от минута  |
| 2000-01-01T00:00:15.000Z | по-малко от минута | по-малко от 20 секунди | след по-малко от минута  |
| 2000-01-01T00:00:05.000Z | по-малко от минута | по-малко от 10 секунди | след по-малко от минута  |
| 2000-01-01T00:00:00.000Z | по-малко от минута | по-малко от 5 секунди  | преди по-малко от минута |
| 1999-12-31T23:59:55.000Z | по-малко от минута | по-малко от 10 секунди | преди по-малко от минута |
| 1999-12-31T23:59:45.000Z | по-малко от минута | по-малко от 20 секунди | преди по-малко от минута |
| 1999-12-31T23:59:35.000Z | по-малко от минута | половин минута         | преди по-малко от минута |
| 1999-12-31T23:59:00.000Z | 1 минута           | 1 минута               | преди 1 минута           |
| 1999-12-31T23:45:00.000Z | 15 минути          | 15 минути              | преди 15 минути          |
| 1999-12-31T23:30:00.000Z | 30 минути          | 30 минути              | преди 30 минути          |
| 1999-12-31T23:15:00.000Z | около час          | около час              | преди около час          |
| 1999-12-31T23:00:00.000Z | около час          | около час              | преди около час          |
| 1999-12-31T18:00:00.000Z | около 6 часа       | около 6 часа           | преди около 6 часа       |
| 1999-12-30T00:00:00.000Z | 2 дни              | 2 дни                  | преди 2 дни              |
| 1999-12-15T00:00:00.000Z | 17 дни             | 17 дни                 | преди 17 дни             |
| 1999-12-01T00:00:00.000Z | около месец        | около месец            | преди около месец        |
| 1999-11-01T00:00:00.000Z | 2 месеца           | 2 месеца               | преди 2 месеца           |
| 1999-06-01T00:00:00.000Z | 7 месеца           | 7 месеца               | преди 7 месеца           |
| 1999-01-01T00:00:00.000Z | около година       | около година           | преди около година       |
| 1998-12-01T00:00:00.000Z | около година       | около година           | преди около година       |
| 1998-06-01T00:00:00.000Z | над година         | над година             | преди над година         |
| 1998-01-01T00:00:00.000Z | около 2 години     | около 2 години         | преди около 2 години     |
| 1997-01-01T00:00:00.000Z | около 3 години     | около 3 години         | преди около 3 години     |
| 1996-01-01T00:00:00.000Z | около 4 години     | около 4 години         | преди около 4 години     |
| 1995-01-01T00:00:00.000Z | около 5 години     | около 5 години         | преди около 5 години     |
| 1994-01-01T00:00:00.000Z | около 6 години     | около 6 години         | преди около 6 години     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 години   | след 6 години     | 52608 часа                     |
| 2005-01-01T00:00:00.000Z | 5 години   | след 5 години     | 43848 часа                     |
| 2004-01-01T00:00:00.000Z | 4 години   | след 4 години     | 35064 часа                     |
| 2003-01-01T00:00:00.000Z | 3 години   | след 3 години     | 26304 часа                     |
| 2002-01-01T00:00:00.000Z | 2 години   | след 2 години     | 17544 часа                     |
| 2001-06-01T00:00:00.000Z | 1 година   | след 1 година     | 12408 часа                     |
| 2001-02-01T00:00:00.000Z | 1 година   | след 1 година     | 9528 часа                      |
| 2001-01-01T00:00:00.000Z | 1 година   | след 1 година     | 8784 часа                      |
| 2000-06-01T00:00:00.000Z | 5 месеца   | след 5 месеца     | 3648 часа                      |
| 2000-03-01T00:00:00.000Z | 2 месеца   | след 2 месеца     | 1440 часа                      |
| 2000-02-01T00:00:00.000Z | 1 месец    | след 1 месец      | 744 часа                       |
| 2000-01-15T00:00:00.000Z | 14 дни     | след 14 дни       | 336 часа                       |
| 2000-01-02T00:00:00.000Z | 1 ден      | след 1 ден        | 24 часа                        |
| 2000-01-01T06:00:00.000Z | 6 часа     | след 6 часа       | 6 часа                         |
| 2000-01-01T01:00:00.000Z | 1 час      | след 1 час        | 1 час                          |
| 2000-01-01T00:45:00.000Z | 45 минути  | след 45 минути    | 1 час                          |
| 2000-01-01T00:30:00.000Z | 30 минути  | след 30 минути    | 1 час                          |
| 2000-01-01T00:15:00.000Z | 15 минути  | след 15 минути    | 0 часа                         |
| 2000-01-01T00:01:00.000Z | 1 минута   | след 1 минута     | 0 часа                         |
| 2000-01-01T00:00:25.000Z | 25 секунди | след 25 секунди   | 0 часа                         |
| 2000-01-01T00:00:15.000Z | 15 секунди | след 15 секунди   | 0 часа                         |
| 2000-01-01T00:00:05.000Z | 5 секунди  | след 5 секунди    | 0 часа                         |
| 2000-01-01T00:00:00.000Z | 0 секунди  | преди 0 секунди   | 0 часа                         |
| 1999-12-31T23:59:55.000Z | 5 секунди  | преди 5 секунди   | 0 часа                         |
| 1999-12-31T23:59:45.000Z | 15 секунди | преди 15 секунди  | 0 часа                         |
| 1999-12-31T23:59:35.000Z | 25 секунди | преди 25 секунди  | 0 часа                         |
| 1999-12-31T23:59:00.000Z | 1 минута   | преди 1 минута    | 0 часа                         |
| 1999-12-31T23:45:00.000Z | 15 минути  | преди 15 минути   | 0 часа                         |
| 1999-12-31T23:30:00.000Z | 30 минути  | преди 30 минути   | 1 час                          |
| 1999-12-31T23:15:00.000Z | 45 минути  | преди 45 минути   | 1 час                          |
| 1999-12-31T23:00:00.000Z | 1 час      | преди 1 час       | 1 час                          |
| 1999-12-31T18:00:00.000Z | 6 часа     | преди 6 часа      | 6 часа                         |
| 1999-12-30T00:00:00.000Z | 2 дни      | преди 2 дни       | 48 часа                        |
| 1999-12-15T00:00:00.000Z | 17 дни     | преди 17 дни      | 408 часа                       |
| 1999-12-01T00:00:00.000Z | 1 месец    | преди 1 месец     | 744 часа                       |
| 1999-11-01T00:00:00.000Z | 2 месеца   | преди 2 месеца    | 1464 часа                      |
| 1999-06-01T00:00:00.000Z | 7 месеца   | преди 7 месеца    | 5136 часа                      |
| 1999-01-01T00:00:00.000Z | 1 година   | преди 1 година    | 8760 часа                      |
| 1998-12-01T00:00:00.000Z | 1 година   | преди 1 година    | 9504 часа                      |
| 1998-06-01T00:00:00.000Z | 2 години   | преди 2 години    | 13896 часа                     |
| 1998-01-01T00:00:00.000Z | 2 години   | преди 2 години    | 17520 часа                     |
| 1997-01-01T00:00:00.000Z | 3 години   | преди 3 години    | 26280 часа                     |
| 1996-01-01T00:00:00.000Z | 4 години   | преди 4 години    | 35064 часа                     |
| 1995-01-01T00:00:00.000Z | 5 години   | преди 5 години    | 43824 часа                     |
| 1994-01-01T00:00:00.000Z | 6 години   | преди 6 години    | 52584 часа                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                  |
| ------------------------ | ----------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000              |
| 2000-01-05T00:00:00.000Z | следващата сряда в 0:00 |
| 2000-01-02T00:00:00.000Z | утре в 0:00             |
| 2000-01-01T00:00:00.000Z | днес в 0:00             |
| 1999-12-31T00:00:00.000Z | вчера в 0:00            |
| 1999-12-27T00:00:00.000Z | в понеделник в 0:00     |
| 1999-12-21T00:00:00.000Z | 21/12/1999              |
