#!/usr/bin/env node
/*
 This file is part of GNU Anastasis
 (C) 2021-2022 Anastasis SARL

 GNU Anastasis is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Anastasis is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License along with
 GNU Anastasis; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { serve } from "@gnu-taler/web-util/node";
import { initializeDev } from "@gnu-taler/web-util/build";

const devEntryPoints = ["src/stories.tsx", "src/index.ts"];

const build = initializeDev({
  type: "development",
  source: {
    js: devEntryPoints,
    assets: [{base:"src",files:["src/index.html"]}],
  },
  css: "sass",
  destination: "./dist/dev",
});

await build();

serve({
  folder: "./dist/dev",
  port: 8080,
  source: "./src",
  onSourceUpdate: build,
});
