# coding: utf-8

# archversion - Archlinux Version Controller
# Copyright © 2012 Sébastien Luttringer
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

'''Archlinux Version Controller Package'''

import os
import logging

# Init log systems
logging.basicConfig(format="%(levelname)s: %(message)s")

# xdg config directory
XDG_DIRECTORY = os.environ.get('XDG_DIRECTORY',"archversion")

# Stored list of packagas we want to track
CONFIG_PACKAGES = os.environ.get('CONFIG_PACKAGES',"packages.conf")

# Configuration for sendmail command
CONFIG_SENDMAIL = os.environ.get('CONFIG_SENDMAIL',"sendmail.conf")

# Cache is stored package versions
CACHE_PACKAGES = os.environ.get('CACHE_PACKAGES',"packages.cache")

# Annouced version (from autoconf)
VERSION = "0"

# Http request headers
# Advertise archversion version
# Try to disable caching
HTTP_HEADERS = {
	"User-Agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36",
	"Pragma": "no-cache",
	"Cache-Control": "no-cache, no-store, must-revalidate"
}
