/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.DefaultJadxArgs;
import jadx.api.IJadxArgs;
import jadx.api.JavaClass;
import jadx.api.JavaPackage;
import jadx.core.Jadx;
import jadx.core.ProcessClass;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.SaveCode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.InputFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JadxDecompiler {
    private static final Logger LOG = LoggerFactory.getLogger(JadxDecompiler.class);
    private final IJadxArgs args;
    private final List<InputFile> inputFiles = new ArrayList<InputFile>();
    private File outDir;
    private RootNode root;
    private List<IDexTreeVisitor> passes;
    private List<JavaClass> classes;

    public JadxDecompiler() {
        this(new DefaultJadxArgs());
    }

    public JadxDecompiler(IJadxArgs jadxArgs) {
        this.args = jadxArgs;
        this.outDir = jadxArgs.getOutDir();
        this.reset();
        this.init();
    }

    public void setOutputDir(File outDir) {
        this.outDir = outDir;
        this.init();
    }

    void init() {
        if (this.outDir == null) {
            this.outDir = new DefaultJadxArgs().getOutDir();
        }
        this.passes = Jadx.getPassesList(this.args, this.outDir);
    }

    void reset() {
        ClassInfo.clearCache();
        this.classes = null;
        this.root = null;
    }

    public static String getVersion() {
        return Jadx.getVersion();
    }

    public void loadFile(File file) throws JadxException {
        this.loadFiles(Collections.singletonList(file));
    }

    public void loadFiles(List<File> files) throws JadxException {
        if (files.isEmpty()) {
            throw new JadxException("Empty file list");
        }
        this.inputFiles.clear();
        for (File file : files) {
            try {
                this.inputFiles.add(new InputFile(file));
            }
            catch (IOException e) {
                throw new JadxException("Error load file: " + file, e);
            }
        }
        this.parse();
    }

    public void save() {
        try {
            ExecutorService ex = this.getSaveExecutor();
            ex.shutdown();
            ex.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new JadxRuntimeException("Save interrupted", e);
        }
    }

    public ExecutorService getSaveExecutor() {
        if (this.root == null) {
            throw new JadxRuntimeException("No loaded files");
        }
        int threadsCount = this.args.getThreadsCount();
        LOG.debug("processing threads count: {}", (Object)threadsCount);
        LOG.info("processing ...");
        ExecutorService executor = Executors.newFixedThreadPool(threadsCount);
        for (final JavaClass cls : this.getClasses()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    cls.decompile();
                    SaveCode.save(JadxDecompiler.this.outDir, JadxDecompiler.this.args, cls.getClassNode());
                }
            });
        }
        return executor;
    }

    public List<JavaClass> getClasses() {
        if (this.root == null) {
            return Collections.emptyList();
        }
        if (this.classes == null) {
            List<ClassNode> classNodeList = this.root.getClasses(false);
            ArrayList<JavaClass> clsList = new ArrayList<JavaClass>(classNodeList.size());
            for (ClassNode classNode : classNodeList) {
                clsList.add(new JavaClass(classNode, this));
            }
            this.classes = Collections.unmodifiableList(clsList);
        }
        return this.classes;
    }

    public List<JavaPackage> getPackages() {
        List<JavaClass> classList = this.getClasses();
        if (classList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, ArrayList<JavaClass>> map = new HashMap<String, ArrayList<JavaClass>>();
        for (JavaClass javaClass : classList) {
            String string = javaClass.getPackage();
            ArrayList<JavaClass> clsList = (ArrayList<JavaClass>)map.get(string);
            if (clsList == null) {
                clsList = new ArrayList<JavaClass>();
                map.put(string, clsList);
            }
            clsList.add(javaClass);
        }
        ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            packages.add(new JavaPackage((String)entry.getKey(), (List)entry.getValue()));
        }
        Collections.sort(packages);
        for (JavaPackage javaPackage : packages) {
            Collections.sort(javaPackage.getClasses(), new Comparator<JavaClass>(){

                @Override
                public int compare(JavaClass o1, JavaClass o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return Collections.unmodifiableList(packages);
    }

    public int getErrorsCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getErrorsCounter().getErrorCount();
    }

    public void printErrorsReport() {
        if (this.root == null) {
            return;
        }
        this.root.getErrorsCounter().printReport();
    }

    void parse() throws DecodeException {
        this.reset();
        this.root = new RootNode();
        LOG.info("loading ...");
        this.root.load(this.inputFiles);
    }

    void processClass(ClassNode cls) {
        ProcessClass.process(cls, this.passes);
    }

    RootNode getRoot() {
        return this.root;
    }

    JavaClass findJavaClass(ClassNode cls) {
        if (cls == null) {
            return null;
        }
        for (JavaClass javaClass : this.getClasses()) {
            if (!javaClass.getClassNode().equals(cls)) continue;
            return javaClass;
        }
        return null;
    }

    public String toString() {
        return "jadx decompiler " + JadxDecompiler.getVersion();
    }
}

