/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;

public final class ClassInfo {
    private static final Map<ArgType, ClassInfo> CLASSINFO_CACHE = new WeakHashMap<ArgType, ClassInfo>();
    private final ArgType type;
    private String pkg;
    private String name;
    private String fullName;
    private ClassInfo parentClass;

    private ClassInfo(ArgType type) {
        assert (type.isObject()) : "Not class type: " + type;
        this.type = type;
        this.splitNames(true);
    }

    public static ClassInfo fromDex(DexNode dex, int clsIndex) {
        if (clsIndex == -1) {
            return null;
        }
        ArgType type = dex.getType(clsIndex);
        if (type.isArray()) {
            type = ArgType.OBJECT;
        }
        return ClassInfo.fromType(type);
    }

    public static ClassInfo fromName(String clsName) {
        return ClassInfo.fromType(ArgType.object(clsName));
    }

    public static ClassInfo fromType(ArgType type) {
        ClassInfo cls = CLASSINFO_CACHE.get(type);
        if (cls == null) {
            cls = new ClassInfo(type);
            CLASSINFO_CACHE.put(type, cls);
        }
        return cls;
    }

    public static void clearCache() {
        CLASSINFO_CACHE.clear();
    }

    private void splitNames(boolean canBeInner) {
        String clsName;
        String fullObjectName = this.type.getObject();
        assert (fullObjectName.indexOf(47) == -1) : "Raw type: " + this.type;
        int dot = fullObjectName.lastIndexOf(46);
        if (dot == -1) {
            this.pkg = "defpackage";
            clsName = fullObjectName;
        } else {
            this.pkg = fullObjectName.substring(0, dot);
            clsName = fullObjectName.substring(dot + 1);
        }
        int sep = clsName.lastIndexOf(36);
        if (canBeInner && sep > 0 && sep != clsName.length() - 1) {
            String parClsName = this.pkg + "." + clsName.substring(0, sep);
            this.parentClass = ClassInfo.fromName(parClsName);
            clsName = clsName.substring(sep + 1);
        } else {
            this.parentClass = null;
        }
        char firstChar = clsName.charAt(0);
        if (Character.isDigit(firstChar)) {
            clsName = "AnonymousClass_" + clsName;
        } else if (firstChar == '$') {
            clsName = "_" + clsName;
        }
        if (NameMapper.isReserved(clsName)) {
            clsName = clsName + "_";
        }
        this.fullName = (this.parentClass != null ? this.parentClass.getFullName() : this.pkg) + "." + clsName;
        this.name = clsName;
    }

    public String getFullPath() {
        return this.pkg.replace('.', File.separatorChar) + File.separatorChar + this.getNameWithoutPackage().replace('.', '_');
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isObject() {
        return this.fullName.equals("java.lang.Object");
    }

    public String getShortName() {
        return this.name;
    }

    public String getRawName() {
        return this.type.getObject();
    }

    public String getPackage() {
        return this.pkg;
    }

    public boolean isPackageDefault() {
        return this.pkg.isEmpty() || this.pkg.equals("defpackage");
    }

    public String getNameWithoutPackage() {
        return (this.parentClass != null ? this.parentClass.getNameWithoutPackage() + "." : "") + this.name;
    }

    public ClassInfo getParentClass() {
        return this.parentClass;
    }

    public boolean isInner() {
        return this.parentClass != null;
    }

    public void notInner() {
        this.splitNames(false);
    }

    public ArgType getType() {
        return this.type;
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassInfo) {
            ClassInfo other = (ClassInfo)obj;
            return this.getFullName().equals(other.getFullName());
        }
        return false;
    }
}

