/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.List;

public class ConstInlinerVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        ArrayList<InsnNode> toRemove = new ArrayList<InsnNode>();
        for (BlockNode block : mth.getBasicBlocks()) {
            toRemove.clear();
            for (InsnNode insn : block.getInstructions()) {
                if (!ConstInlinerVisitor.checkInsn(mth, insn)) continue;
                toRemove.add(insn);
            }
            if (toRemove.isEmpty()) continue;
            InstructionRemover.removeAll(mth, block, toRemove);
        }
    }

    private static boolean checkInsn(MethodNode mth, InsnNode insn) {
        if (insn.getType() != InsnType.CONST) {
            return false;
        }
        InsnArg arg = insn.getArg(0);
        if (!arg.isLiteral()) {
            return false;
        }
        long lit = ((LiteralArg)arg).getLiteral();
        SSAVar sVar = insn.getResult().getSVar();
        if (lit == 0L && ConstInlinerVisitor.checkObjectInline(sVar)) {
            if (sVar.getUseCount() == 1) {
                insn.getResult().getAssignInsn().add(AFlag.DONT_INLINE);
            }
            return false;
        }
        ArgType resType = insn.getResult().getType();
        if (!arg.getType().isTypeKnown()) {
            arg.merge(resType);
        }
        return ConstInlinerVisitor.replaceConst(mth, sVar, lit);
    }

    private static boolean checkObjectInline(SSAVar sVar) {
        for (RegisterArg useArg : sVar.getUseList()) {
            InvokeNode inv;
            InsnType insnType;
            InsnNode insn = useArg.getParentInsn();
            if (insn == null || !((insnType = insn.getType()) == InsnType.INVOKE ? (inv = (InvokeNode)insn).getInvokeType() != InvokeType.STATIC && inv.getArg(0) == useArg : insnType == InsnType.ARRAY_LENGTH && insn.getArg(0) == useArg)) continue;
            return true;
        }
        return false;
    }

    private static boolean replaceConst(MethodNode mth, SSAVar sVar, long literal) {
        ArrayList<RegisterArg> use = new ArrayList<RegisterArg>(sVar.getUseList());
        int replaceCount = 0;
        for (RegisterArg arg : use) {
            LiteralArg litArg;
            InsnNode useInsn = arg.getParentInsn();
            if (useInsn.getType() == InsnType.PHI || !useInsn.replaceArg(arg, litArg = use.size() == 1 || arg.isTypeImmutable() ? InsnArg.lit(literal, arg.getType()) : (useInsn.getType() == InsnType.MOVE && !useInsn.getResult().getType().isTypeKnown() ? InsnArg.lit(literal, arg.getType()) : InsnArg.lit(literal, ArgType.UNKNOWN)))) continue;
            ConstInlinerVisitor.fixTypes(mth, useInsn, litArg);
            ++replaceCount;
        }
        return replaceCount == use.size();
    }

    private static void fixTypes(MethodNode mth, InsnNode insn, LiteralArg litArg) {
        switch (insn.getType()) {
            case CONST: {
                insn.getArg(0).merge(insn.getResult());
                break;
            }
            case MOVE: {
                insn.getResult().merge(insn.getArg(0));
                insn.getArg(0).merge(insn.getResult());
                break;
            }
            case IPUT: 
            case SPUT: {
                IndexInsnNode node = (IndexInsnNode)insn;
                insn.getArg(0).merge(((FieldInfo)node.getIndex()).getType());
                break;
            }
            case IF: {
                InsnArg arg0 = insn.getArg(0);
                InsnArg arg1 = insn.getArg(1);
                if (arg0 == litArg) {
                    arg0.merge(arg1);
                    break;
                }
                arg1.merge(arg0);
                break;
            }
            case CMP_G: 
            case CMP_L: {
                InsnArg arg0 = insn.getArg(0);
                InsnArg arg1 = insn.getArg(1);
                if (arg0 == litArg) {
                    arg0.merge(arg1);
                    break;
                }
                arg1.merge(arg0);
                break;
            }
            case RETURN: {
                if (insn.getArgsCount() == 0) break;
                insn.getArg(0).merge(mth.getReturnType());
                break;
            }
            case INVOKE: {
                InvokeNode inv = (InvokeNode)insn;
                List<ArgType> types = inv.getCallMth().getArgumentsTypes();
                int count = insn.getArgsCount();
                int k = types.size() == count ? 0 : -1;
                for (int i = 0; i < count; ++i) {
                    InsnArg arg = insn.getArg(i);
                    if (!arg.getType().isTypeKnown()) {
                        ArgType type = k >= 0 ? types.get(k) : mth.getParentClass().getClassInfo().getType();
                        arg.merge(type);
                    }
                    ++k;
                }
                break;
            }
            case ARITH: {
                litArg.merge(insn.getResult());
                break;
            }
            case APUT: 
            case AGET: {
                if (litArg != insn.getArg(1)) break;
                litArg.merge(ArgType.INT);
                break;
            }
            case NEW_ARRAY: {
                litArg.merge(ArgType.INT);
                break;
            }
        }
    }
}

