/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.ssa;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ssa.LiveVarAnalysis;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;

public class SSATransform
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        SSATransform.process(mth);
    }

    private static void process(MethodNode mth) {
        LiveVarAnalysis la = new LiveVarAnalysis(mth);
        la.runAnalysis();
        int regsCount = mth.getRegsCount();
        for (int i = 0; i < regsCount; ++i) {
            SSATransform.placePhi(mth, i, la);
        }
        SSATransform.renameVariables(mth);
        SSATransform.fixLastTryCatchAssign(mth);
        if (SSATransform.removeUselessPhi(mth)) {
            SSATransform.renameVariables(mth);
        }
    }

    private static void placePhi(MethodNode mth, int regNum, LiveVarAnalysis la) {
        List<BlockNode> blocks = mth.getBasicBlocks();
        int blocksCount = blocks.size();
        BitSet hasPhi = new BitSet(blocksCount);
        BitSet processed = new BitSet(blocksCount);
        LinkedList<BlockNode> workList = new LinkedList<BlockNode>();
        BitSet assignBlocks = la.getAssignBlocks(regNum);
        int id = assignBlocks.nextSetBit(0);
        while (id >= 0) {
            processed.set(id);
            workList.add(blocks.get(id));
            id = assignBlocks.nextSetBit(id + 1);
        }
        while (!workList.isEmpty()) {
            BlockNode block = (BlockNode)workList.pop();
            BitSet domFrontier = block.getDomFrontier();
            int id2 = domFrontier.nextSetBit(0);
            while (id2 >= 0) {
                if (!hasPhi.get(id2) && la.isLive(id2, regNum)) {
                    BlockNode df = blocks.get(id2);
                    SSATransform.addPhi(df, regNum);
                    hasPhi.set(id2);
                    if (!processed.get(id2)) {
                        processed.set(id2);
                        workList.add(df);
                    }
                }
                id2 = domFrontier.nextSetBit(id2 + 1);
            }
        }
    }

    private static void addPhi(BlockNode block, int regNum) {
        PhiListAttr phiList = block.get(AType.PHI_LIST);
        if (phiList == null) {
            phiList = new PhiListAttr();
            block.addAttr(phiList);
        }
        PhiInsn phiInsn = new PhiInsn(regNum, block.getPredecessors().size());
        phiList.getList().add(phiInsn);
        phiInsn.setOffset(block.getStartOffset());
        block.getInstructions().add(0, phiInsn);
    }

    private static void renameVariables(MethodNode mth) {
        int regsCount = mth.getRegsCount();
        SSAVar[] vars = new SSAVar[regsCount];
        int[] versions = new int[regsCount];
        for (RegisterArg arg : mth.getArguments(true)) {
            int regNum = arg.getRegNum();
            vars[regNum] = mth.makeNewSVar(regNum, versions, arg);
        }
        SSATransform.renameVar(mth, vars, versions, mth.getEnterBlock());
    }

    private static void renameVar(MethodNode mth, SSAVar[] vars, int[] vers, BlockNode block) {
        SSAVar[] inputVars = Arrays.copyOf(vars, vars.length);
        for (InsnNode insn : block.getInstructions()) {
            RegisterArg result;
            if (insn.getType() != InsnType.PHI) {
                for (InsnArg arg : insn.getArguments()) {
                    if (!arg.isRegister()) continue;
                    RegisterArg reg = (RegisterArg)arg;
                    int regNum = reg.getRegNum();
                    SSAVar var = vars[regNum];
                    if (var == null) {
                        vars[regNum] = var = mth.makeNewSVar(regNum, vers, null);
                    }
                    var.use(reg);
                }
            }
            if ((result = insn.getResult()) == null) continue;
            int regNum = result.getRegNum();
            vars[regNum] = mth.makeNewSVar(regNum, vers, result);
        }
        for (BlockNode s : block.getSuccessors()) {
            PhiListAttr phiList = s.get(AType.PHI_LIST);
            if (phiList == null) continue;
            int j = s.getPredecessors().indexOf(block);
            if (j == -1) {
                throw new JadxRuntimeException("Can't find predecessor for " + block + " " + s);
            }
            for (PhiInsn phiInsn : phiList.getList()) {
                if (j >= phiInsn.getArgsCount()) continue;
                int regNum = phiInsn.getResult().getRegNum();
                SSAVar var = vars[regNum];
                if (var == null) {
                    vars[regNum] = var = mth.makeNewSVar(regNum, vers, null);
                }
                var.use(phiInsn.getArg(j));
                var.setUsedInPhi(phiInsn);
            }
        }
        for (BlockNode domOn : block.getDominatesOn()) {
            SSATransform.renameVar(mth, vars, vers, domOn);
        }
        System.arraycopy(inputVars, 0, vars, 0, vars.length);
    }

    private static void fixLastTryCatchAssign(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null || !block.contains(AType.EXC_HANDLER)) continue;
            for (PhiInsn phi : phiList.getList()) {
                for (int i = 0; i < phi.getArgsCount(); ++i) {
                    RegisterArg arg = phi.getArg(i);
                    InsnNode parentInsn = arg.getAssignInsn();
                    if (parentInsn == null || parentInsn.getResult() == null || !parentInsn.contains(AFlag.TRY_LEAVE)) continue;
                    phi.removeArg(arg);
                }
            }
        }
    }

    private static boolean removeUselessPhi(MethodNode mth) {
        ArrayList<PhiInsn> insnToRemove = new ArrayList<PhiInsn>();
        for (SSAVar var : mth.getSVars()) {
            InsnNode assignInsn;
            if (var.getUseCount() != 0 || (assignInsn = var.getAssign().getParentInsn()) == null || assignInsn.getType() != InsnType.PHI) continue;
            insnToRemove.add((PhiInsn)assignInsn);
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null) continue;
            for (PhiInsn phi : phiList.getList()) {
                SSATransform.removePhiWithSameArgs(phi, insnToRemove);
            }
        }
        return SSATransform.removePhiList(mth, insnToRemove);
    }

    private static void removePhiWithSameArgs(PhiInsn phi, List<PhiInsn> insnToRemove) {
        if (phi.getArgsCount() <= 1) {
            insnToRemove.add(phi);
            return;
        }
        boolean allSame = true;
        SSAVar var = phi.getArg(0).getSVar();
        for (int i = 1; i < phi.getArgsCount(); ++i) {
            if (var == phi.getArg(i).getSVar()) continue;
            allSame = false;
            break;
        }
        if (allSame) {
            insnToRemove.add(phi);
            SSAVar assign = phi.getResult().getSVar();
            for (RegisterArg arg : new ArrayList<RegisterArg>(assign.getUseList())) {
                assign.removeUse(arg);
                var.use(arg);
            }
        }
    }

    private static boolean removePhiList(MethodNode mth, List<PhiInsn> insnToRemove) {
        if (insnToRemove.isEmpty()) {
            return false;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiList = block.get(AType.PHI_LIST);
            if (phiList == null) continue;
            List<PhiInsn> list = phiList.getList();
            for (PhiInsn phiInsn : insnToRemove) {
                if (!list.remove(phiInsn)) continue;
                for (InsnArg arg : phiInsn.getArguments()) {
                    ((RegisterArg)arg).getSVar().setUsedInPhi(null);
                }
                InstructionRemover.remove(mth, block, phiInsn);
            }
            if (!list.isEmpty()) continue;
            block.remove(AType.PHI_LIST);
        }
        insnToRemove.clear();
        return true;
    }
}

